/* char and string functions
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __CSTRINGF_H__
#define __CSTRINGF_H__

/* return length of sring s (without the \0) */
int string_length(char *s);

/* get one line from the indicated file */
void get_line(FILE * f, char *s, boolean * eof);

/* return uppercase of c */
char up_char(char c);

#define up_char(x) ((((x)>='a')&&((x)<='z'))?((x)-'a'+'A'):(x))

/* return lowercase of c */
char low_char(char c);

/* report whether c1 and c2 are the same (ignore case) */
boolean char_match(char c1, char c2);

/* report whether s1 and s2 are the same (ignore case) */
boolean string_match(char *s1, char *s2);

/* report whether s1 and s2 are the same (watch case) */
boolean string_equal(char *s1, char *s2);

/* report whether x is a prefix of s */
boolean string_prefix(char *x, char *s);

/* return index of first occurrence of x in s, -1 if none */
int string_pos(char *x, char *s);

/* give index of first appearance of c in x, -1 if none */
int char_pos(char c, char *s);

/* copy string s to d */
void string_copy(char *d, char *s);

/* convert string s in-place to lowercase */
void string_to_lowercase(char *s);

/* copy string s to d, convert to uppercase */
void string_copy_lowercase(char *d, char *s);

/* copy string s to d, skip chars which appear in x */
void string_copy_skip(char *d, char *s, char *x);

void replace_char(char *p, char old, char new);

void normalize_directory_separator(char *p);

/* return int value of c assuming c is a hex char */
int char_hex_value(char c);

/* convert s to an integer value, report success */
boolean string_int_value(char *z, int *x);

/* return alloacted copy of s */
char *new_string(char *s);

/* return alloacted copy of s */
char *new_string_lowercase(char *s);

/* return allocated string of n c's */
char *bar(int n, char c);

/* return allocated string s, padded by c's up to length n */
char *pad(char *s, unsigned n, char c);

/* replace '.' with '\0' */
void chop_extension(char *s);

void chop_path_tail(char *s);

void chop_path(char *s);

/* report whether file s exists */
boolean file_exists(char *s);


/********** char classification functions **********/

/* report whether c is a separator */
boolean is_separator(char c);

/* report whether c is a letter */
boolean is_letter(char c);

/* report whether c is a number */
boolean is_number(char c);

/* report whether c is valid as first character of an identifier */
boolean is_id_start(char c);

/* report whether c is valid as next character of an identifier */
boolean is_id_next(char c);

/* report whether c is valid as first character of a constant */
boolean is_number_start(char c);

/* report whether c is valid as next character of a constant */
boolean is_number_next(char c);

/* report whether c is a special (operator) character */
boolean is_special(char c);

/* search list handling */
#define slist struct _slist

struct _slist {
    slist *next;
    char *s;
};

extern slist slist_first;

void add_to_searchlist(string s);

boolean find_name2(char *dest, char *source);

boolean find_name(char *dest, char *source);

/********** date and time **********/

float current_time(void);

char *date_and_time(void);

#endif
