/* global things
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __GLOBAL_H__
#define __GLOBAL_H__

#ifndef _MSC_VER
/* for lack of a build-in boolean... */
typedef enum { false = (0 == 1), true = (0 == 0) } boolean;
#else
#define false 0
#define true 1
#endif


/* return max or min of two expressions */
#ifndef max
#define max( x, y ) ( ( ( x ) > ( y ) ) ? ( x ) : ( y ) )
#define min( x, y ) ( ( ( x ) > ( y ) ) ? ( y ) : ( x ) )
#endif

/* return absolute value */
#ifndef abs
int abs(int x);
#endif

/* bit test */
#define has( x, y ) ( ( (x) & (y) ) != 0 )

/* swap two pointers */
#define swapp( p, q ){ void *t = p; p = q; q = t; }

/* the default string type */
typedef char string[256];

/* an allocated empty string */
extern char *empty_string;


/********** forwards **********/

#define allocate( x ) _allocate( x, __LINE__ )
void *_allocate(int size, int line);
void free_all(void);

boolean file_exists(char *s);


/********** settings, pragma's etc. **********/

/* verbosity */
extern boolean verbose_scanner;
extern boolean verbose_parser;
extern boolean verbose_optimizer;
extern boolean verbose_squasher;
extern boolean verbose_ralloc;
extern boolean verbose_coder;
extern boolean verbose_assembler;
extern boolean verbose_simulator;
extern boolean verbose_passes;
extern boolean verbose_malloc;
extern boolean verbose_progress;
extern boolean verbose_stack;

/* checks */
extern boolean check_blocks;
extern boolean check_pool;
extern boolean check_asserts;
extern boolean check_memory_zero;
extern boolean check_stack;

/* optimizations */
extern boolean optimize_constant_folding;
extern boolean optimize_strength_reduction;
extern boolean optimize_tree_shape;
extern boolean optimize_tail_calls;
extern boolean optimize_trivial_expressions;
extern boolean optimize_dead_code;
extern boolean optimize_bank_instructions;
extern boolean optimize_pass_in_w;

/* results */
extern boolean result_hex;
extern boolean result_asm;
extern boolean result_src;
extern boolean result_hex_code;
extern boolean result_gpsim_info;
extern FILE *src_file;

/* simulator */
extern boolean enable_simulator;

/* error catching */
extern int catch_line;
extern int catch_pos;
extern string main_source_file;
extern string current_source_file;

extern int scanner_total_lines;
extern int scanner_total_files;
extern int scanner_total_chars;
extern int simulated_instructions;
extern int total_code_size;
extern int main_stack_usage;
extern int indirect_stack_usage;
extern int int_stack_usage;
extern int total_stack_usage;
extern float start_time;
extern float compilation_seconds;

extern char command_line[2048];

#endif
