/* lexical scanner
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __SCANNER_H__
#define __SCANNER_H__

typedef char *charp_t;
extern charp_t rtl[];
extern charp_t rtl_trailer[];
extern charp_t rtl_trailer_16[];

/* context while scanning in an input file */
#define scanner_context_t struct scanner_struct
struct scanner_struct {
    loc_t loc;                  /* location info for reporting */
    char *line;                 /* current input file line */
    int len;                    /* length of line */
    int pos;                    /* position of next char within line */
    string token;               /* current token */
    boolean eof;                /* current input file at EOF? */
    boolean eoi;                /* total input at EOF? */
    charp_t *internal;          /* internal input "file" */
    FILE *f;                    /* external input file */
    string file_name;           /* chopped name of the current file */
    scanner_context_t *previous;        /* previous scanner_context block */
    string src_line;            /* for the src file */
};

/* intial context, used for post-scanning error reporting */
extern scanner_context_t scanner_initial_context;
extern scanner_context_t *scanner_context;
extern string scanner_progress;

void print_src(char *s);

/* advance one char in the input */
void scanner_advance_char(void);

/* return the next char in the input */
char scanner_next_char(void);

boolean scanner_at_end_of_line(void);

/* advance one token in the input */
void scanner_next_token(void);

void scanner_open(charp_t * internal, char *file_name, boolean save);

/* report whether the token matches s */
boolean scanner_is_like(char *s);

/* report whether the token matches s, advance token if match */
boolean scanner_is_like_advance(char *s);

/* cassert that the token matches s */
void scanner_check(char *s);

/* cassert that the token matches s and advance */
void scanner_check_advance(char *s);

/* report whether the token is an identifier */
boolean scanner_is_identifier(void);


/* cassert that the token is an identifier */
void scanner_check_identifier(void);

/* cassert that the token is an identifier and advance */
void scanner_check_identifier_advance(void);

/* return current location */
loc_t scanner_here(void);

#endif
