#!/bin/bash

#
# note: you may need to edit the paths's for the old jal libs and the JAL_LIBS

if [ -z $2 ] ; then
	echo usage : $0 fast mcu1 mcu2 ...  
	echo usage : $0 reg-gpl mcu1 mcu2 ...  "<-- regression"
	echo usage : $0 reg-4_55 mcu1 mcu2 ...  "<-- regression"
	echo usage : $0 reg-last mcu1 mcu2 ...  "<-- regression"

	echo Some PICs you could try: f877_10 P18f458 f675_20 f628_10 16f84_4 f452_20 sx18_50 12c509a_int_4_int_mclr;
	
	exit
fi
# TODO: do something with command line switch.


FLAGS="-t -cas"

extras=$1

shift

JAL=../../jal
JAL_4_55=jal_4_55

JAL_LIBS=../../../lib

OLD_JAL=old_jal
# old_jal is the build of the original gpl'ed jal.c

OLD_JAL_LIBS=/usr/local/share/jal/old_lib
# old_lib is where I put the 4-53 libs (copied from my windows system)

LAST_JAL=jal
LAST_LIBS=

SRC_PATH=../src

for i in `find "$SRC_PATH" -name "*.jal" -print -maxdepth 1 `
do
	echo ${i%jal}
	rm -f ${i%jal}hex
	rm -f ${i%jal}asm
	rm -f ${i%jal}dif

	##for chip in f877_10 f675_20 f628_10 16f84_4 f452_20 sx18_50 12c509a_int_4_int_mclr;
	# TODO: add parrameters for selecting chip...

##	for chip in f877_20 ;
	for chip in "$@";
	do
##		
			e=-1
			$JAL -s$JAL_LIBS $chip $FLAGS $i >${i%jal}$chip".out" && e=1

			if [ $e = -1 ]; then
				max_steps=`grep -c "max steps" ${i%jal}$chip".out"`;
				if [ $max_steps = 0 ]; then
					echo JAL ERROR in $i for $chip 
					echo     JAL ERROR in $i for $chip  >>errors.out
				else
					rm -f ${i%jal}$chip".out"
				fi
			#   echo >stop.flg
			else
				rm -f ${i%jal}$chip".out"
			fi
##	

		if [ $extras = 'reg-4_55' ]; then

			e=-1
			$JAL_4_55 $chip $FLAGS $i >${i%jal}$chip".455" && e=1

			if [ $e = -1 ]; then
				max_steps=`grep -c "max steps" ${i%jal}$chip".455"`;
				if [ $max_steps = 0 ]; then
					echo JAL_4_55 ERROR in $i for $chip 
					echo     JAL ERROR in $i for $chip  >>errors.455
				else
					rm -f ${i%jal}$chip".455"
				fi

			#   echo >stop.flg
			else
				rm -f ${i%jal}$chip".455"
			fi
		fi
	
		if [ $extras = 'reg-gpl' ]; then

			e=-1
			$OLD_JAL -s$OLD_JAL_LIBS $chip $FLAGS $i >${i%jal}$chip".old" && e=1

			if [ $e = -1 ]; then
				max_steps=`grep -c "max steps" ${i%jal}$chip".old"`;
				if [ $max_steps = 0 ]; then
					echo old JAL ERROR in $i for $chip 
					echo     JAL ERROR in $i for $chip  >>errors.old
				else
					rm -f ${i%jal}$chip".old"
				fi

			#   echo >stop.flg
			else
				rm -f ${i%jal}$chip".old"
			fi
		fi

		if [ $extras = 'reg-last' ]; then

			e=-1
			$LAST_JAL -s$LAST_JAL_LIBS $chip $FLAGS $i >${i%jal}$chip".last" && e=1

			if [ $e = -1 ]; then
				max_steps=`grep -c "max steps" ${i%jal}$chip".last"`;
				if [ $max_steps = 0 ]; then
					echo last JAL ERROR in $i for $chip 
					echo     JAL ERROR in $i for $chip  >>errors.last
				else
					rm -f ${i%jal}$chip".last"
				fi

			#   echo >stop.flg
			else
				rm -f ${i%jal}$chip".last"
			fi
		fi
	done

done


