/*********************************************************************/
/*                                                                   */
/*             Optimized BLAS libraries                              */
/*                     By Kazushige Goto <kgoto@tacc.utexas.edu>     */
/*                                                                   */
/* Copyright (c) The University of Texas, 2009. All rights reserved. */
/* UNIVERSITY EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES CONCERNING  */
/* THIS SOFTWARE AND DOCUMENTATION, INCLUDING ANY WARRANTIES OF      */
/* MERCHANTABILITY, FITNESS FOR ANY PARTICULAR PURPOSE,              */
/* NON-INFRINGEMENT AND WARRANTIES OF PERFORMANCE, AND ANY WARRANTY  */
/* THAT MIGHT OTHERWISE ARISE FROM COURSE OF DEALING OR USAGE OF     */
/* TRADE. NO WARRANTY IS EITHER EXPRESS OR IMPLIED WITH RESPECT TO   */
/* THE USE OF THE SOFTWARE OR DOCUMENTATION.                         */
/* Under no circumstances shall University be liable for incidental, */
/* special, indirect, direct or consequential damages or loss of     */
/* profits, interruption of business, or related expenses which may  */
/* arise from use of Software or Documentation, including but not    */
/* limited to those resulting from defects in Software and/or        */
/* Documentation, or loss or inaccuracy of data of any kind.         */
/*********************************************************************/

#define ASSEMBLER
#include "common.h"
	
#define N	r3
#define X	r4
#define INCX	r5	

#define PREA	r8
#define	INCXM1	r9

#define FZERO	f1

#define STACKSIZE 160

	PROLOGUE
	PROFCODE

	addi	SP, SP, -STACKSIZE
	li	r0,   0

	stfd	f14,    0(SP)
	stfd	f15,    8(SP)
	stfd	f16,   16(SP)
	stfd	f17,   24(SP)

	stfd	f18,   32(SP)
	stfd	f19,   40(SP)
	stfd	f20,   48(SP)
	stfd	f21,   56(SP)

	stfd	f22,   64(SP)
	stfd	f23,   72(SP)
	stfd	f24,   80(SP)
	stfd	f25,   88(SP)

	stfd	f26,   96(SP)
	stfd	f27,  104(SP)
	stfd	f28,  112(SP)
	stfd	f29,  120(SP)

	stfd	f30,  128(SP)
	stfd	f31,  136(SP)

	stw	r0,   144(SP)
	lfs	FZERO,144(SP)

#ifdef F_INTERFACE
	LDINT	N,    0(N)
	LDINT	INCX, 0(INCX)
#endif

	slwi	INCX, INCX, ZBASE_SHIFT
	subi	INCXM1, INCX, SIZE

	li	PREA, 10 * 16 * SIZE

	cmpwi	cr0, N, 0
	ble-	LL(9999)
	cmpwi	cr0, INCX, 0
	ble-	LL(9999)

	LFD	f1, 0 * SIZE(X)
	LFD	f2, 1 * SIZE(X)
	add	X, X, INCX

	fabs	f1, f1
	fabs	f2, f2
	fadd	f1, f1, f2

	fmr	f0, f1
	fmr	f2, f1
	fmr	f3, f1

	subi	N, N, 1

	cmpwi	cr0, INCX, 2 * SIZE
	bne-	cr0, LL(100)

	srawi.	r0, N, 3
	mtspr	CTR, r0
	beq-	cr0, LL(50)
	.align 4

	LFD	f24,   0 * SIZE(X)
	LFD	f25,   1 * SIZE(X)

	fabs	f8,  f24
	LFD	f26,   2 * SIZE(X)
	fabs	f9,  f25
	LFD	f27,   3 * SIZE(X)
	fabs	f10, f26
	LFD	f28,   4 * SIZE(X)
	fabs	f11, f27
	LFD	f29,   5 * SIZE(X)
	fabs	f12, f28
	LFD	f30,   6 * SIZE(X)
	fabs	f13, f29
	LFD	f31,   7 * SIZE(X)
	fabs	f14, f30
	nop
	fabs	f15, f31
	bdz	LL(20)
	.align 4

LL(10):
	fadd	f4,  f8,  f9
	dcbt	X, PREA
	fadd	f5,  f10, f11
	nop
	fadd	f6,  f12, f13
	LFD	f24,   8 * SIZE(X)
	fadd	f7,  f14, f15
	LFD	f25,   9 * SIZE(X)

	fabs	f8,  f24
	LFD	f26,  10 * SIZE(X)
	fabs	f9,  f25
	LFD	f27,  11 * SIZE(X)
	fabs	f10, f26
	fabs	f11, f27

	fsub	f16, f0,  f4
	fsub	f17, f1,  f5
	fsub	f18, f2,  f6
	LFD	f28,  12 * SIZE(X)
	fsub	f19, f3,  f7
	LFD	f29,  13 * SIZE(X)

	fabs	f12, f28
	LFD	f30,  14 * SIZE(X)
	fabs	f13, f29
	LFD	f31,  15 * SIZE(X)
	fabs	f14, f30
	fabs	f15, f31

	fsel	f0,  f16, f4, f0
	fsel	f1,  f17, f5, f1
	fsel	f2,  f18, f6, f2
	fsel	f3,  f19, f7, f3

	fadd	f20, f8,  f9
	fadd	f21, f10, f11
	fadd	f22, f12, f13
	LFD	f24,  16 * SIZE(X)
	fadd	f23, f14, f15
	LFD	f25,  17 * SIZE(X)

	fabs	f8,  f24
	LFD	f26,  18 * SIZE(X)
	fabs	f9,  f25
	LFD	f27,  19 * SIZE(X)
	fabs	f10, f26
	fabs	f11, f27

	fsub	f16, f0,  f20
	fsub	f17, f1,  f21
	fsub	f18, f2,  f22
	LFD	f28,  20 * SIZE(X)
	fsub	f19, f3,  f23
	LFD	f29,  21 * SIZE(X)

	fabs	f12, f28
	LFD	f30,  22 * SIZE(X)
	fabs	f13, f29
	LFD	f31,  23 * SIZE(X)
	fabs	f14, f30
	addi	X, X, 16 * SIZE
	fabs	f15, f31

	fsel	f0,  f16, f20, f0
	fsel	f1,  f17, f21, f1
	fsel	f2,  f18, f22, f2
	fsel	f3,  f19, f23, f3

	bdnz	LL(10)
	.align 4

LL(20):
	fadd	f4,  f8,  f9
	fadd	f5,  f10, f11
	fadd	f6,  f12, f13
	LFD	f24,   8 * SIZE(X)
	fadd	f7,  f14, f15
	LFD	f25,   9 * SIZE(X)

	fabs	f8,  f24
	LFD	f26,  10 * SIZE(X)
	fabs	f9,  f25
	LFD	f27,  11 * SIZE(X)
	fabs	f10, f26
	fabs	f11, f27

	fsub	f16, f0,  f4
	fsub	f17, f1,  f5
	fsub	f18, f2,  f6
	LFD	f28,  12 * SIZE(X)
	fsub	f19, f3,  f7
	LFD	f29,  13 * SIZE(X)

	fabs	f12, f28
	LFD	f30,  14 * SIZE(X)
	fabs	f13, f29
	LFD	f31,  15 * SIZE(X)
	fabs	f14, f30
	fabs	f15, f31

	fsel	f0,  f16, f4, f0
	fsel	f1,  f17, f5, f1
	fsel	f2,  f18, f6, f2
	fsel	f3,  f19, f7, f3

	fadd	f20, f8,  f9
	fadd	f21, f10, f11
	fadd	f22, f12, f13
	fadd	f23, f14, f15

	fsub	f16, f0,  f20
	fsub	f17, f1,  f21
	fsub	f18, f2,  f22
	fsub	f19, f3,  f23

	fsel	f0,  f16, f20, f0
	fsel	f1,  f17, f21, f1
	fsel	f2,  f18, f22, f2
	fsel	f3,  f19, f23, f3
	addi	X, X, 16 * SIZE

	.align 4

LL(50):
	andi.	r0,  N, 7
	mtspr	CTR, r0
	beq	LL(999)
	.align 4

LL(60):
	LFD	f8,  0 * SIZE(X)
	LFD	f9,  1 * SIZE(X)
	addi	X, X,  2 * SIZE

	fabs	f8, f8
	fabs	f9, f9
	fadd	f8, f8, f9
	fsub	f16, f1, f8
	fsel	f1, f16, f8, f1
	bdnz	LL(60)
	b	LL(999)
	.align 4

LL(100):
	sub	X, X, INCXM1

	srawi.	r0, N, 3
	mtspr	CTR,  r0
	beq-	LL(150)

	LFDX	f24,   X, INCXM1
	LFDUX	f25,   X, INCX
	LFDX	f26,   X, INCXM1
	LFDUX	f27,   X, INCX
	LFDX	f28,   X, INCXM1
	LFDUX	f29,   X, INCX
	LFDX	f30,   X, INCXM1
	LFDUX	f31,   X, INCX

	fabs	f8,  f24
	fabs	f9,  f25
	fabs	f10, f26
	fabs	f11, f27
	fabs	f12, f28
	fabs	f13, f29
	fabs	f14, f30
	fabs	f15, f31

	LFDX	f24,   X, INCXM1
	LFDUX	f25,   X, INCX
	LFDX	f26,   X, INCXM1
	LFDUX	f27,   X, INCX
	LFDX	f28,   X, INCXM1
	LFDUX	f29,   X, INCX
	LFDX	f30,   X, INCXM1
	LFDUX	f31,   X, INCX

	bdz	LL(120)
	.align 4

LL(110):
	fadd	f4,  f8,  f9
	fadd	f5,  f10, f11
	fadd	f6,  f12, f13
	fadd	f7,  f14, f15

	fabs	f8,  f24
	fabs	f9,  f25
	fabs	f10, f26
	fabs	f11, f27

	LFDX	f24,   X, INCXM1
	LFDUX	f25,   X, INCX
	LFDX	f26,   X, INCXM1
	LFDUX	f27,   X, INCX

	fabs	f12, f28
	fabs	f13, f29
	fabs	f14, f30
	fabs	f15, f31

	LFDX	f28,   X, INCXM1
	LFDUX	f29,   X, INCX
	LFDX	f30,   X, INCXM1
	LFDUX	f31,   X, INCX

	fsub	f16, f0,  f4
	fsub	f17, f1,  f5
	fsub	f18, f2,  f6
	fsub	f19, f3,  f7

	fadd	f20, f8,  f9
	fadd	f21, f10, f11
	fadd	f22, f12, f13
	fadd	f23, f14, f15

	fabs	f8,  f24
	fabs	f9,  f25
	fabs	f10, f26
	fabs	f11, f27

	LFDX	f24,   X, INCXM1
	LFDUX	f25,   X, INCX
	LFDX	f26,   X, INCXM1
	LFDUX	f27,   X, INCX

	fsel	f0,  f16, f4, f0
	fsel	f1,  f17, f5, f1
	fsel	f2,  f18, f6, f2
	fsel	f3,  f19, f7, f3

	fabs	f12, f28
	fabs	f13, f29
	fabs	f14, f30
	fabs	f15, f31

	LFDX	f28,   X, INCXM1
	LFDUX	f29,   X, INCX
	LFDX	f30,   X, INCXM1
	LFDUX	f31,   X, INCX

	fsub	f16, f0,  f20
	fsub	f17, f1,  f21
	fsub	f18, f2,  f22
	fsub	f19, f3,  f23

	fsel	f0,  f16, f20, f0
	fsel	f1,  f17, f21, f1
	fsel	f2,  f18, f22, f2
	fsel	f3,  f19, f23, f3
	bdnz	LL(110)
	.align 4

LL(120):
	fadd	f4,  f8,  f9
	fadd	f5,  f10, f11
	fadd	f6,  f12, f13
	fadd	f7,  f14, f15

	fabs	f8,  f24
	fabs	f9,  f25
	fabs	f10, f26
	fabs	f11, f27

	fabs	f12, f28
	fabs	f13, f29
	fabs	f14, f30
	fabs	f15, f31

	fsub	f16, f0,  f4
	fsub	f17, f1,  f5
	fsub	f18, f2,  f6
	fsub	f19, f3,  f7

	fadd	f20, f8,  f9
	fadd	f21, f10, f11
	fadd	f22, f12, f13
	fadd	f23, f14, f15

	fsel	f0,  f16, f4, f0
	fsel	f1,  f17, f5, f1
	fsel	f2,  f18, f6, f2
	fsel	f3,  f19, f7, f3

	fsub	f16, f0,  f20
	fsub	f17, f1,  f21
	fsub	f18, f2,  f22
	fsub	f19, f3,  f23

	fsel	f0,  f16, f20, f0
	fsel	f1,  f17, f21, f1
	fsel	f2,  f18, f22, f2
	fsel	f3,  f19, f23, f3
	.align 4

LL(150):
	andi.	r0,  N, 7
	mtspr	CTR, r0
	beq	LL(999)
	.align 4

LL(160):
	LFDX	f8,    X, INCXM1
	LFDUX	f9,    X, INCX

	fabs	f8, f8
	fabs	f9, f9
	fadd	f8, f8, f9
	fsub	f16, f1, f8
	fsel	f1, f16, f8, f1
	bdnz	LL(160)
	.align 4

LL(999):
	fsub	f8,  f0,  f1
	fsub	f9,  f2,  f3

	fsel	f0,  f8,  f1, f0
	fsel	f2,  f9,  f3, f2
	fsub	f8,  f0,  f2
	fsel	f1,  f8,  f2, f0
	.align 4

LL(9999):
	lfd	f14,    0(SP)
	lfd	f15,    8(SP)
	lfd	f16,   16(SP)
	lfd	f17,   24(SP)

	lfd	f18,   32(SP)
	lfd	f19,   40(SP)
	lfd	f20,   48(SP)
	lfd	f21,   56(SP)

	lfd	f22,   64(SP)
	lfd	f23,   72(SP)
	lfd	f24,   80(SP)
	lfd	f25,   88(SP)

	lfd	f26,   96(SP)
	lfd	f27,  104(SP)
	lfd	f28,  112(SP)
	lfd	f29,  120(SP)

	lfd	f30,  128(SP)
	lfd	f31,  136(SP)

	addi	SP, SP, STACKSIZE
	blr

	EPILOGUE
