// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetNamedQuery = "BatchGetNamedQuery"

// BatchGetNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetNamedQuery for more information on using the BatchGetNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetNamedQueryRequest method.
//    req, resp := client.BatchGetNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery
func (c *Athena) BatchGetNamedQueryRequest(input *BatchGetNamedQueryInput) (req *request.Request, output *BatchGetNamedQueryOutput) {
	op := &request.Operation{
		Name:       opBatchGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetNamedQueryInput{}
	}

	output = &BatchGetNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetNamedQuery API operation for Amazon Athena.
//
// Returns the details of a single named query or a list of up to 50 queries,
// which you provide as an array of query ID strings. Requires you to have access
// to the workgroup in which the queries were saved. Use ListNamedQueriesInput
// to get the list of named query IDs in the specified workgroup. If information
// could not be retrieved for a submitted query ID, information about the query
// ID submitted is listed under UnprocessedNamedQueryId. Named queries differ
// from executed queries. Use BatchGetQueryExecutionInput to get details about
// each unique query execution, and ListQueryExecutionsInput to get a list of
// query execution IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation BatchGetNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetNamedQuery
func (c *Athena) BatchGetNamedQuery(input *BatchGetNamedQueryInput) (*BatchGetNamedQueryOutput, error) {
	req, out := c.BatchGetNamedQueryRequest(input)
	return out, req.Send()
}

// BatchGetNamedQueryWithContext is the same as BatchGetNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) BatchGetNamedQueryWithContext(ctx aws.Context, input *BatchGetNamedQueryInput, opts ...request.Option) (*BatchGetNamedQueryOutput, error) {
	req, out := c.BatchGetNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetQueryExecution = "BatchGetQueryExecution"

// BatchGetQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetQueryExecution for more information on using the BatchGetQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetQueryExecutionRequest method.
//    req, resp := client.BatchGetQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Athena) BatchGetQueryExecutionRequest(input *BatchGetQueryExecutionInput) (req *request.Request, output *BatchGetQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opBatchGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetQueryExecutionInput{}
	}

	output = &BatchGetQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetQueryExecution API operation for Amazon Athena.
//
// Returns the details of a single query execution or a list of up to 50 query
// executions, which you provide as an array of query execution ID strings.
// Requires you to have access to the workgroup in which the queries ran. To
// get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup.
// Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput
// to get details about named queries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation BatchGetQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/BatchGetQueryExecution
func (c *Athena) BatchGetQueryExecution(input *BatchGetQueryExecutionInput) (*BatchGetQueryExecutionOutput, error) {
	req, out := c.BatchGetQueryExecutionRequest(input)
	return out, req.Send()
}

// BatchGetQueryExecutionWithContext is the same as BatchGetQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) BatchGetQueryExecutionWithContext(ctx aws.Context, input *BatchGetQueryExecutionInput, opts ...request.Option) (*BatchGetQueryExecutionOutput, error) {
	req, out := c.BatchGetQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamedQuery = "CreateNamedQuery"

// CreateNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamedQuery for more information on using the CreateNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNamedQueryRequest method.
//    req, resp := client.CreateNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery
func (c *Athena) CreateNamedQueryRequest(input *CreateNamedQueryInput) (req *request.Request, output *CreateNamedQueryOutput) {
	op := &request.Operation{
		Name:       opCreateNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNamedQueryInput{}
	}

	output = &CreateNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamedQuery API operation for Amazon Athena.
//
// Creates a named query in the specified workgroup. Requires that you have
// access to the workgroup.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation CreateNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateNamedQuery
func (c *Athena) CreateNamedQuery(input *CreateNamedQueryInput) (*CreateNamedQueryOutput, error) {
	req, out := c.CreateNamedQueryRequest(input)
	return out, req.Send()
}

// CreateNamedQueryWithContext is the same as CreateNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) CreateNamedQueryWithContext(ctx aws.Context, input *CreateNamedQueryInput, opts ...request.Option) (*CreateNamedQueryOutput, error) {
	req, out := c.CreateNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkGroup = "CreateWorkGroup"

// CreateWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkGroup for more information on using the CreateWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkGroupRequest method.
//    req, resp := client.CreateWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup
func (c *Athena) CreateWorkGroupRequest(input *CreateWorkGroupInput) (req *request.Request, output *CreateWorkGroupOutput) {
	op := &request.Operation{
		Name:       opCreateWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkGroupInput{}
	}

	output = &CreateWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateWorkGroup API operation for Amazon Athena.
//
// Creates a workgroup with the specified name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation CreateWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/CreateWorkGroup
func (c *Athena) CreateWorkGroup(input *CreateWorkGroupInput) (*CreateWorkGroupOutput, error) {
	req, out := c.CreateWorkGroupRequest(input)
	return out, req.Send()
}

// CreateWorkGroupWithContext is the same as CreateWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) CreateWorkGroupWithContext(ctx aws.Context, input *CreateWorkGroupInput, opts ...request.Option) (*CreateWorkGroupOutput, error) {
	req, out := c.CreateWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamedQuery = "DeleteNamedQuery"

// DeleteNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamedQuery for more information on using the DeleteNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamedQueryRequest method.
//    req, resp := client.DeleteNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Athena) DeleteNamedQueryRequest(input *DeleteNamedQueryInput) (req *request.Request, output *DeleteNamedQueryOutput) {
	op := &request.Operation{
		Name:       opDeleteNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamedQueryInput{}
	}

	output = &DeleteNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNamedQuery API operation for Amazon Athena.
//
// Deletes the named query if you have access to the workgroup in which the
// query was saved.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation DeleteNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Athena) DeleteNamedQuery(input *DeleteNamedQueryInput) (*DeleteNamedQueryOutput, error) {
	req, out := c.DeleteNamedQueryRequest(input)
	return out, req.Send()
}

// DeleteNamedQueryWithContext is the same as DeleteNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) DeleteNamedQueryWithContext(ctx aws.Context, input *DeleteNamedQueryInput, opts ...request.Option) (*DeleteNamedQueryOutput, error) {
	req, out := c.DeleteNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkGroup = "DeleteWorkGroup"

// DeleteWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkGroup for more information on using the DeleteWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkGroupRequest method.
//    req, resp := client.DeleteWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup
func (c *Athena) DeleteWorkGroupRequest(input *DeleteWorkGroupInput) (req *request.Request, output *DeleteWorkGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkGroupInput{}
	}

	output = &DeleteWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkGroup API operation for Amazon Athena.
//
// Deletes the workgroup with the specified name. The primary workgroup cannot
// be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation DeleteWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteWorkGroup
func (c *Athena) DeleteWorkGroup(input *DeleteWorkGroupInput) (*DeleteWorkGroupOutput, error) {
	req, out := c.DeleteWorkGroupRequest(input)
	return out, req.Send()
}

// DeleteWorkGroupWithContext is the same as DeleteWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) DeleteWorkGroupWithContext(ctx aws.Context, input *DeleteWorkGroupInput, opts ...request.Option) (*DeleteWorkGroupOutput, error) {
	req, out := c.DeleteWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNamedQuery = "GetNamedQuery"

// GetNamedQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetNamedQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamedQuery for more information on using the GetNamedQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNamedQueryRequest method.
//    req, resp := client.GetNamedQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Athena) GetNamedQueryRequest(input *GetNamedQueryInput) (req *request.Request, output *GetNamedQueryOutput) {
	op := &request.Operation{
		Name:       opGetNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamedQueryInput{}
	}

	output = &GetNamedQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamedQuery API operation for Amazon Athena.
//
// Returns information about a single query. Requires that you have access to
// the workgroup in which the query was saved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetNamedQuery for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetNamedQuery
func (c *Athena) GetNamedQuery(input *GetNamedQueryInput) (*GetNamedQueryOutput, error) {
	req, out := c.GetNamedQueryRequest(input)
	return out, req.Send()
}

// GetNamedQueryWithContext is the same as GetNamedQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamedQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetNamedQueryWithContext(ctx aws.Context, input *GetNamedQueryInput, opts ...request.Option) (*GetNamedQueryOutput, error) {
	req, out := c.GetNamedQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryExecution = "GetQueryExecution"

// GetQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryExecution for more information on using the GetQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryExecutionRequest method.
//    req, resp := client.GetQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution
func (c *Athena) GetQueryExecutionRequest(input *GetQueryExecutionInput) (req *request.Request, output *GetQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opGetQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQueryExecutionInput{}
	}

	output = &GetQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryExecution API operation for Amazon Athena.
//
// Returns information about a single execution of a query if you have access
// to the workgroup in which the query ran. Each time a query executes, information
// about the query execution is saved with a unique ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryExecution
func (c *Athena) GetQueryExecution(input *GetQueryExecutionInput) (*GetQueryExecutionOutput, error) {
	req, out := c.GetQueryExecutionRequest(input)
	return out, req.Send()
}

// GetQueryExecutionWithContext is the same as GetQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryExecutionWithContext(ctx aws.Context, input *GetQueryExecutionInput, opts ...request.Option) (*GetQueryExecutionOutput, error) {
	req, out := c.GetQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueryResults = "GetQueryResults"

// GetQueryResultsRequest generates a "aws/request.Request" representing the
// client's request for the GetQueryResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueryResults for more information on using the GetQueryResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQueryResultsRequest method.
//    req, resp := client.GetQueryResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults
func (c *Athena) GetQueryResultsRequest(input *GetQueryResultsInput) (req *request.Request, output *GetQueryResultsOutput) {
	op := &request.Operation{
		Name:       opGetQueryResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetQueryResultsInput{}
	}

	output = &GetQueryResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQueryResults API operation for Amazon Athena.
//
// Streams the results of a single query execution specified by QueryExecutionId
// from the Athena query results location in Amazon S3. For more information,
// see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html)
// in the Amazon Athena User Guide. This request does not execute the query
// but returns results. Use StartQueryExecution to run a query.
//
// To stream query results successfully, the IAM principal with permission to
// call GetQueryResults also must have permissions to the Amazon S3 GetObject
// action for the Athena query results location.
//
// IAM principals with permission to the Amazon S3 GetObject action for the
// query results location are able to retrieve query results from Amazon S3
// even if permission to the GetQueryResults action is denied. To restrict user
// or role access, ensure that Amazon S3 permissions to the Athena query location
// are denied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetQueryResults for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetQueryResults
func (c *Athena) GetQueryResults(input *GetQueryResultsInput) (*GetQueryResultsOutput, error) {
	req, out := c.GetQueryResultsRequest(input)
	return out, req.Send()
}

// GetQueryResultsWithContext is the same as GetQueryResults with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueryResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryResultsWithContext(ctx aws.Context, input *GetQueryResultsInput, opts ...request.Option) (*GetQueryResultsOutput, error) {
	req, out := c.GetQueryResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetQueryResultsPages iterates over the pages of a GetQueryResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetQueryResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetQueryResults operation.
//    pageNum := 0
//    err := client.GetQueryResultsPages(params,
//        func(page *athena.GetQueryResultsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) GetQueryResultsPages(input *GetQueryResultsInput, fn func(*GetQueryResultsOutput, bool) bool) error {
	return c.GetQueryResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetQueryResultsPagesWithContext same as GetQueryResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetQueryResultsPagesWithContext(ctx aws.Context, input *GetQueryResultsInput, fn func(*GetQueryResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetQueryResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetQueryResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetQueryResultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetWorkGroup = "GetWorkGroup"

// GetWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkGroup for more information on using the GetWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkGroupRequest method.
//    req, resp := client.GetWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup
func (c *Athena) GetWorkGroupRequest(input *GetWorkGroupInput) (req *request.Request, output *GetWorkGroupOutput) {
	op := &request.Operation{
		Name:       opGetWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkGroupInput{}
	}

	output = &GetWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkGroup API operation for Amazon Athena.
//
// Returns information about the workgroup with the specified name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation GetWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetWorkGroup
func (c *Athena) GetWorkGroup(input *GetWorkGroupInput) (*GetWorkGroupOutput, error) {
	req, out := c.GetWorkGroupRequest(input)
	return out, req.Send()
}

// GetWorkGroupWithContext is the same as GetWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) GetWorkGroupWithContext(ctx aws.Context, input *GetWorkGroupInput, opts ...request.Option) (*GetWorkGroupOutput, error) {
	req, out := c.GetWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNamedQueries = "ListNamedQueries"

// ListNamedQueriesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamedQueries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamedQueries for more information on using the ListNamedQueries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNamedQueriesRequest method.
//    req, resp := client.ListNamedQueriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries
func (c *Athena) ListNamedQueriesRequest(input *ListNamedQueriesInput) (req *request.Request, output *ListNamedQueriesOutput) {
	op := &request.Operation{
		Name:       opListNamedQueries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamedQueriesInput{}
	}

	output = &ListNamedQueriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamedQueries API operation for Amazon Athena.
//
// Provides a list of available query IDs only for queries saved in the specified
// workgroup. Requires that you have access to the workgroup.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListNamedQueries for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNamedQueries
func (c *Athena) ListNamedQueries(input *ListNamedQueriesInput) (*ListNamedQueriesOutput, error) {
	req, out := c.ListNamedQueriesRequest(input)
	return out, req.Send()
}

// ListNamedQueriesWithContext is the same as ListNamedQueries with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamedQueries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListNamedQueriesWithContext(ctx aws.Context, input *ListNamedQueriesInput, opts ...request.Option) (*ListNamedQueriesOutput, error) {
	req, out := c.ListNamedQueriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamedQueriesPages iterates over the pages of a ListNamedQueries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamedQueries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNamedQueries operation.
//    pageNum := 0
//    err := client.ListNamedQueriesPages(params,
//        func(page *athena.ListNamedQueriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListNamedQueriesPages(input *ListNamedQueriesInput, fn func(*ListNamedQueriesOutput, bool) bool) error {
	return c.ListNamedQueriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamedQueriesPagesWithContext same as ListNamedQueriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListNamedQueriesPagesWithContext(ctx aws.Context, input *ListNamedQueriesInput, fn func(*ListNamedQueriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamedQueriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamedQueriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamedQueriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueryExecutions = "ListQueryExecutions"

// ListQueryExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueryExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueryExecutions for more information on using the ListQueryExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQueryExecutionsRequest method.
//    req, resp := client.ListQueryExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions
func (c *Athena) ListQueryExecutionsRequest(input *ListQueryExecutionsInput) (req *request.Request, output *ListQueryExecutionsOutput) {
	op := &request.Operation{
		Name:       opListQueryExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueryExecutionsInput{}
	}

	output = &ListQueryExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueryExecutions API operation for Amazon Athena.
//
// Provides a list of available query execution IDs for the queries in the specified
// workgroup. Requires you to have access to the workgroup in which the queries
// ran.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListQueryExecutions for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListQueryExecutions
func (c *Athena) ListQueryExecutions(input *ListQueryExecutionsInput) (*ListQueryExecutionsOutput, error) {
	req, out := c.ListQueryExecutionsRequest(input)
	return out, req.Send()
}

// ListQueryExecutionsWithContext is the same as ListQueryExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueryExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListQueryExecutionsWithContext(ctx aws.Context, input *ListQueryExecutionsInput, opts ...request.Option) (*ListQueryExecutionsOutput, error) {
	req, out := c.ListQueryExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueryExecutionsPages iterates over the pages of a ListQueryExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueryExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQueryExecutions operation.
//    pageNum := 0
//    err := client.ListQueryExecutionsPages(params,
//        func(page *athena.ListQueryExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListQueryExecutionsPages(input *ListQueryExecutionsInput, fn func(*ListQueryExecutionsOutput, bool) bool) error {
	return c.ListQueryExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueryExecutionsPagesWithContext same as ListQueryExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListQueryExecutionsPagesWithContext(ctx aws.Context, input *ListQueryExecutionsInput, fn func(*ListQueryExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueryExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueryExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueryExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource
func (c *Athena) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Athena.
//
// Lists the tags associated with this workgroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ResourceNotFoundException
//   A resource, such as a workgroup, was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTagsForResource
func (c *Athena) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkGroups = "ListWorkGroups"

// ListWorkGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkGroups for more information on using the ListWorkGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkGroupsRequest method.
//    req, resp := client.ListWorkGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups
func (c *Athena) ListWorkGroupsRequest(input *ListWorkGroupsInput) (req *request.Request, output *ListWorkGroupsOutput) {
	op := &request.Operation{
		Name:       opListWorkGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkGroupsInput{}
	}

	output = &ListWorkGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkGroups API operation for Amazon Athena.
//
// Lists available workgroups for the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation ListWorkGroups for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListWorkGroups
func (c *Athena) ListWorkGroups(input *ListWorkGroupsInput) (*ListWorkGroupsOutput, error) {
	req, out := c.ListWorkGroupsRequest(input)
	return out, req.Send()
}

// ListWorkGroupsWithContext is the same as ListWorkGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListWorkGroupsWithContext(ctx aws.Context, input *ListWorkGroupsInput, opts ...request.Option) (*ListWorkGroupsOutput, error) {
	req, out := c.ListWorkGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkGroupsPages iterates over the pages of a ListWorkGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkGroups operation.
//    pageNum := 0
//    err := client.ListWorkGroupsPages(params,
//        func(page *athena.ListWorkGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Athena) ListWorkGroupsPages(input *ListWorkGroupsInput, fn func(*ListWorkGroupsOutput, bool) bool) error {
	return c.ListWorkGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkGroupsPagesWithContext same as ListWorkGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) ListWorkGroupsPagesWithContext(ctx aws.Context, input *ListWorkGroupsInput, fn func(*ListWorkGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartQueryExecution = "StartQueryExecution"

// StartQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartQueryExecution for more information on using the StartQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartQueryExecutionRequest method.
//    req, resp := client.StartQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution
func (c *Athena) StartQueryExecutionRequest(input *StartQueryExecutionInput) (req *request.Request, output *StartQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opStartQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartQueryExecutionInput{}
	}

	output = &StartQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartQueryExecution API operation for Amazon Athena.
//
// Runs the SQL query statements contained in the Query. Requires you to have
// access to the workgroup in which the query ran.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation StartQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * TooManyRequestsException
//   Indicates that the request was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StartQueryExecution
func (c *Athena) StartQueryExecution(input *StartQueryExecutionInput) (*StartQueryExecutionOutput, error) {
	req, out := c.StartQueryExecutionRequest(input)
	return out, req.Send()
}

// StartQueryExecutionWithContext is the same as StartQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) StartQueryExecutionWithContext(ctx aws.Context, input *StartQueryExecutionInput, opts ...request.Option) (*StartQueryExecutionOutput, error) {
	req, out := c.StartQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopQueryExecution = "StopQueryExecution"

// StopQueryExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopQueryExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopQueryExecution for more information on using the StopQueryExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopQueryExecutionRequest method.
//    req, resp := client.StopQueryExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution
func (c *Athena) StopQueryExecutionRequest(input *StopQueryExecutionInput) (req *request.Request, output *StopQueryExecutionOutput) {
	op := &request.Operation{
		Name:       opStopQueryExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopQueryExecutionInput{}
	}

	output = &StopQueryExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopQueryExecution API operation for Amazon Athena.
//
// Stops a query execution. Requires you to have access to the workgroup in
// which the query ran.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation StopQueryExecution for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/StopQueryExecution
func (c *Athena) StopQueryExecution(input *StopQueryExecutionInput) (*StopQueryExecutionOutput, error) {
	req, out := c.StopQueryExecutionRequest(input)
	return out, req.Send()
}

// StopQueryExecutionWithContext is the same as StopQueryExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopQueryExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) StopQueryExecutionWithContext(ctx aws.Context, input *StopQueryExecutionInput, opts ...request.Option) (*StopQueryExecutionOutput, error) {
	req, out := c.StopQueryExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource
func (c *Athena) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Athena.
//
// Adds one or more tags to the resource, such as a workgroup. A tag is a label
// that you assign to an AWS Athena resource (a workgroup). Each tag consists
// of a key and an optional value, both of which you define. Tags enable you
// to categorize resources (workgroups) in Athena, for example, by purpose,
// owner, or environment. Use a consistent set of tag keys to make it easier
// to search and filter workgroups in your account. For best practices, see
// AWS Tagging Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
// The key length is from 1 (minimum) to 128 (maximum) Unicode characters in
// UTF-8. The tag value length is from 0 (minimum) to 256 (maximum) Unicode
// characters in UTF-8. You can use letters and numbers representable in UTF-8,
// and the following characters: + - = . _ : / @. Tag keys and values are case-sensitive.
// Tag keys must be unique per resource. If you specify more than one, separate
// them by commas.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ResourceNotFoundException
//   A resource, such as a workgroup, was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/TagResource
func (c *Athena) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource
func (c *Athena) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Athena.
//
// Removes one or more tags from the workgroup resource. Takes as an input a
// list of TagKey Strings separated by commas, and removes their tags at the
// same time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
//   * ResourceNotFoundException
//   A resource, such as a workgroup, was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UntagResource
func (c *Athena) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkGroup = "UpdateWorkGroup"

// UpdateWorkGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkGroup for more information on using the UpdateWorkGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkGroupRequest method.
//    req, resp := client.UpdateWorkGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup
func (c *Athena) UpdateWorkGroupRequest(input *UpdateWorkGroupInput) (req *request.Request, output *UpdateWorkGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkGroupInput{}
	}

	output = &UpdateWorkGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkGroup API operation for Amazon Athena.
//
// Updates the workgroup with the specified name. The workgroup's name cannot
// be changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Athena's
// API operation UpdateWorkGroup for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Indicates a platform issue, which may be due to a transient condition or
//   outage.
//
//   * InvalidRequestException
//   Indicates that something is wrong with the input to the request. For example,
//   a required parameter may be missing or out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/UpdateWorkGroup
func (c *Athena) UpdateWorkGroup(input *UpdateWorkGroupInput) (*UpdateWorkGroupOutput, error) {
	req, out := c.UpdateWorkGroupRequest(input)
	return out, req.Send()
}

// UpdateWorkGroupWithContext is the same as UpdateWorkGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Athena) UpdateWorkGroupWithContext(ctx aws.Context, input *UpdateWorkGroupInput, opts ...request.Option) (*UpdateWorkGroupOutput, error) {
	req, out := c.UpdateWorkGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchGetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// An array of query IDs.
	//
	// NamedQueryIds is a required field
	NamedQueryIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetNamedQueryInput"}
	if s.NamedQueryIds == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryIds"))
	}
	if s.NamedQueryIds != nil && len(s.NamedQueryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamedQueryIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryIds sets the NamedQueryIds field's value.
func (s *BatchGetNamedQueryInput) SetNamedQueryIds(v []*string) *BatchGetNamedQueryInput {
	s.NamedQueryIds = v
	return s
}

type BatchGetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the named query IDs submitted.
	NamedQueries []*NamedQuery `type:"list"`

	// Information about provided query IDs.
	UnprocessedNamedQueryIds []*UnprocessedNamedQueryId `type:"list"`
}

// String returns the string representation
func (s BatchGetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQueries sets the NamedQueries field's value.
func (s *BatchGetNamedQueryOutput) SetNamedQueries(v []*NamedQuery) *BatchGetNamedQueryOutput {
	s.NamedQueries = v
	return s
}

// SetUnprocessedNamedQueryIds sets the UnprocessedNamedQueryIds field's value.
func (s *BatchGetNamedQueryOutput) SetUnprocessedNamedQueryIds(v []*UnprocessedNamedQueryId) *BatchGetNamedQueryOutput {
	s.UnprocessedNamedQueryIds = v
	return s
}

type BatchGetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// An array of query execution IDs.
	//
	// QueryExecutionIds is a required field
	QueryExecutionIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetQueryExecutionInput"}
	if s.QueryExecutionIds == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionIds"))
	}
	if s.QueryExecutionIds != nil && len(s.QueryExecutionIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryExecutionIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionIds sets the QueryExecutionIds field's value.
func (s *BatchGetQueryExecutionInput) SetQueryExecutionIds(v []*string) *BatchGetQueryExecutionInput {
	s.QueryExecutionIds = v
	return s
}

type BatchGetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about a query execution.
	QueryExecutions []*QueryExecution `type:"list"`

	// Information about the query executions that failed to run.
	UnprocessedQueryExecutionIds []*UnprocessedQueryExecutionId `type:"list"`
}

// String returns the string representation
func (s BatchGetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecutions sets the QueryExecutions field's value.
func (s *BatchGetQueryExecutionOutput) SetQueryExecutions(v []*QueryExecution) *BatchGetQueryExecutionOutput {
	s.QueryExecutions = v
	return s
}

// SetUnprocessedQueryExecutionIds sets the UnprocessedQueryExecutionIds field's value.
func (s *BatchGetQueryExecutionOutput) SetUnprocessedQueryExecutionIds(v []*UnprocessedQueryExecutionId) *BatchGetQueryExecutionOutput {
	s.UnprocessedQueryExecutionIds = v
	return s
}

// Information about the columns in a query execution result.
type ColumnInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether values in the column are case-sensitive.
	CaseSensitive *bool `type:"boolean"`

	// The catalog to which the query results belong.
	CatalogName *string `type:"string"`

	// A column label.
	Label *string `type:"string"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Indicates the column's nullable status.
	Nullable *string `type:"string" enum:"ColumnNullable"`

	// For DECIMAL data types, specifies the total number of digits, up to 38. For
	// performance reasons, we recommend up to 18 digits.
	Precision *int64 `type:"integer"`

	// For DECIMAL data types, specifies the total number of digits in the fractional
	// part of the value. Defaults to 0.
	Scale *int64 `type:"integer"`

	// The schema name (database name) to which the query results belong.
	SchemaName *string `type:"string"`

	// The table name for the query results.
	TableName *string `type:"string"`

	// The data type of the column.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ColumnInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ColumnInfo) GoString() string {
	return s.String()
}

// SetCaseSensitive sets the CaseSensitive field's value.
func (s *ColumnInfo) SetCaseSensitive(v bool) *ColumnInfo {
	s.CaseSensitive = &v
	return s
}

// SetCatalogName sets the CatalogName field's value.
func (s *ColumnInfo) SetCatalogName(v string) *ColumnInfo {
	s.CatalogName = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *ColumnInfo) SetLabel(v string) *ColumnInfo {
	s.Label = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnInfo) SetName(v string) *ColumnInfo {
	s.Name = &v
	return s
}

// SetNullable sets the Nullable field's value.
func (s *ColumnInfo) SetNullable(v string) *ColumnInfo {
	s.Nullable = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ColumnInfo) SetPrecision(v int64) *ColumnInfo {
	s.Precision = &v
	return s
}

// SetScale sets the Scale field's value.
func (s *ColumnInfo) SetScale(v int64) *ColumnInfo {
	s.Scale = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *ColumnInfo) SetSchemaName(v string) *ColumnInfo {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ColumnInfo) SetTableName(v string) *ColumnInfo {
	s.TableName = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnInfo) SetType(v string) *ColumnInfo {
	s.Type = &v
	return s
}

type CreateNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure the request to create the query
	// is idempotent (executes only once). If another CreateNamedQuery request is
	// received, the same response is returned and another query is not created.
	// If a parameter has changed, for example, the QueryString, an error is returned.
	//
	// This token is listed as not required because AWS SDKs (for example the AWS
	// SDK for Java) auto-generate the token for users. If you are not using the
	// AWS SDK or the AWS CLI, you must provide this token or the action will fail.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The database to which the query belongs.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The query description.
	Description *string `min:"1" type:"string"`

	// The query name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The contents of the query with all query statements.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// The name of the workgroup in which the named query is being created.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s CreateNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNamedQueryInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNamedQueryInput) SetClientRequestToken(v string) *CreateNamedQueryInput {
	s.ClientRequestToken = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *CreateNamedQueryInput) SetDatabase(v string) *CreateNamedQueryInput {
	s.Database = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNamedQueryInput) SetDescription(v string) *CreateNamedQueryInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNamedQueryInput) SetName(v string) *CreateNamedQueryInput {
	s.Name = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *CreateNamedQueryInput) SetQueryString(v string) *CreateNamedQueryInput {
	s.QueryString = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *CreateNamedQueryInput) SetWorkGroup(v string) *CreateNamedQueryInput {
	s.WorkGroup = &v
	return s
}

type CreateNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query.
	NamedQueryId *string `type:"string"`
}

// String returns the string representation
func (s CreateNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *CreateNamedQueryOutput) SetNamedQueryId(v string) *CreateNamedQueryOutput {
	s.NamedQueryId = &v
	return s
}

type CreateWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The configuration for the workgroup, which includes the location in Amazon
	// S3 where query results are stored, the encryption configuration, if any,
	// used for encrypting query results, whether the Amazon CloudWatch Metrics
	// are enabled for the workgroup, the limit for the amount of bytes scanned
	// (cutoff) per query, if it is specified, and whether workgroup's settings
	// (specified with EnforceWorkGroupConfiguration) in the WorkGroupConfiguration
	// override client-side settings. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	Configuration *WorkGroupConfiguration `type:"structure"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// One or more tags, separated by commas, that you want to attach to the workgroup
	// as you create it.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateWorkGroupInput) SetConfiguration(v *WorkGroupConfiguration) *CreateWorkGroupInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateWorkGroupInput) SetDescription(v string) *CreateWorkGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorkGroupInput) SetName(v string) *CreateWorkGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkGroupInput) SetTags(v []*Tag) *CreateWorkGroupInput {
	s.Tags = v
	return s
}

type CreateWorkGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkGroupOutput) GoString() string {
	return s.String()
}

// A piece of data (a field in the table).
type Datum struct {
	_ struct{} `type:"structure"`

	// The value of the datum.
	VarCharValue *string `type:"string"`
}

// String returns the string representation
func (s Datum) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datum) GoString() string {
	return s.String()
}

// SetVarCharValue sets the VarCharValue field's value.
func (s *Datum) SetVarCharValue(v string) *Datum {
	s.VarCharValue = &v
	return s
}

type DeleteNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query to delete.
	NamedQueryId *string `type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamedQueryInput) GoString() string {
	return s.String()
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *DeleteNamedQueryInput) SetNamedQueryId(v string) *DeleteNamedQueryInput {
	s.NamedQueryId = &v
	return s
}

type DeleteNamedQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamedQueryOutput) GoString() string {
	return s.String()
}

type DeleteWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The option to delete the workgroup and its contents even if the workgroup
	// contains any named queries.
	RecursiveDeleteOption *bool `type:"boolean"`

	// The unique name of the workgroup to delete.
	//
	// WorkGroup is a required field
	WorkGroup *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkGroupInput"}
	if s.WorkGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecursiveDeleteOption sets the RecursiveDeleteOption field's value.
func (s *DeleteWorkGroupInput) SetRecursiveDeleteOption(v bool) *DeleteWorkGroupInput {
	s.RecursiveDeleteOption = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *DeleteWorkGroupInput) SetWorkGroup(v string) *DeleteWorkGroupInput {
	s.WorkGroup = &v
	return s
}

type DeleteWorkGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkGroupOutput) GoString() string {
	return s.String()
}

// If query results are encrypted in Amazon S3, indicates the encryption option
// used (for example, SSE-KMS or CSE-KMS) and key information.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether Amazon S3 server-side encryption with Amazon S3-managed
	// keys (SSE-S3), server-side encryption with KMS-managed keys (SSE-KMS), or
	// client-side encryption with KMS-managed keys (CSE-KMS) is used.
	//
	// If a query runs in a workgroup and the workgroup overrides client-side settings,
	// then the workgroup's setting for encryption is used. It specifies whether
	// query results must be encrypted, for all queries that run in this workgroup.
	//
	// EncryptionOption is a required field
	EncryptionOption *string `type:"string" required:"true" enum:"EncryptionOption"`

	// For SSE-KMS and CSE-KMS, this is the KMS key ARN or ID.
	KmsKey *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.EncryptionOption == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionOption"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionOption sets the EncryptionOption field's value.
func (s *EncryptionConfiguration) SetEncryptionOption(v string) *EncryptionConfiguration {
	s.EncryptionOption = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *EncryptionConfiguration) SetKmsKey(v string) *EncryptionConfiguration {
	s.KmsKey = &v
	return s
}

type GetNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query. Use ListNamedQueries to get query IDs.
	//
	// NamedQueryId is a required field
	NamedQueryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamedQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamedQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNamedQueryInput"}
	if s.NamedQueryId == nil {
		invalidParams.Add(request.NewErrParamRequired("NamedQueryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *GetNamedQueryInput) SetNamedQueryId(v string) *GetNamedQueryInput {
	s.NamedQueryId = &v
	return s
}

type GetNamedQueryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query.
	NamedQuery *NamedQuery `type:"structure"`
}

// String returns the string representation
func (s GetNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamedQueryOutput) GoString() string {
	return s.String()
}

// SetNamedQuery sets the NamedQuery field's value.
func (s *GetNamedQueryOutput) SetNamedQuery(v *NamedQuery) *GetNamedQueryOutput {
	s.NamedQuery = v
	return s
}

type GetQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query execution.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryExecutionInput"}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *GetQueryExecutionInput) SetQueryExecutionId(v string) *GetQueryExecutionInput {
	s.QueryExecutionId = &v
	return s
}

type GetQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query execution.
	QueryExecution *QueryExecution `type:"structure"`
}

// String returns the string representation
func (s GetQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecution sets the QueryExecution field's value.
func (s *GetQueryExecutionOutput) SetQueryExecution(v *QueryExecution) *GetQueryExecutionOutput {
	s.QueryExecution = v
	return s
}

type GetQueryResultsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results (rows) to return in this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that specifies where to start pagination if a previous request
	// was truncated.
	NextToken *string `min:"1" type:"string"`

	// The unique ID of the query execution.
	//
	// QueryExecutionId is a required field
	QueryExecutionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetQueryResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueryResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueryResultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QueryExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryExecutionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetQueryResultsInput) SetMaxResults(v int64) *GetQueryResultsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetQueryResultsInput) SetNextToken(v string) *GetQueryResultsInput {
	s.NextToken = &v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *GetQueryResultsInput) SetQueryExecutionId(v string) *GetQueryResultsInput {
	s.QueryExecutionId = &v
	return s
}

type GetQueryResultsOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`

	// The results of the query execution.
	ResultSet *ResultSet `type:"structure"`

	// The number of rows inserted with a CREATE TABLE AS SELECT statement.
	UpdateCount *int64 `type:"long"`
}

// String returns the string representation
func (s GetQueryResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQueryResultsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetQueryResultsOutput) SetNextToken(v string) *GetQueryResultsOutput {
	s.NextToken = &v
	return s
}

// SetResultSet sets the ResultSet field's value.
func (s *GetQueryResultsOutput) SetResultSet(v *ResultSet) *GetQueryResultsOutput {
	s.ResultSet = v
	return s
}

// SetUpdateCount sets the UpdateCount field's value.
func (s *GetQueryResultsOutput) SetUpdateCount(v int64) *GetQueryResultsOutput {
	s.UpdateCount = &v
	return s
}

type GetWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the workgroup.
	//
	// WorkGroup is a required field
	WorkGroup *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkGroupInput"}
	if s.WorkGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkGroup"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *GetWorkGroupInput) SetWorkGroup(v string) *GetWorkGroupInput {
	s.WorkGroup = &v
	return s
}

type GetWorkGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the workgroup.
	WorkGroup *WorkGroup `type:"structure"`
}

// String returns the string representation
func (s GetWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkGroupOutput) GoString() string {
	return s.String()
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *GetWorkGroupOutput) SetWorkGroup(v *WorkGroup) *GetWorkGroupOutput {
	s.WorkGroup = v
	return s
}

// Indicates a platform issue, which may be due to a transient condition or
// outage.
type InternalServerException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalServerException) OrigErr() error {
	return nil
}

func (s InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalServerException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalServerException) RequestID() string {
	return s.respMetadata.RequestID
}

// Indicates that something is wrong with the input to the request. For example,
// a required parameter may be missing or out of range.
type InvalidRequestException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// The error code returned when the query execution failed to process, or when
	// the processing request for the named query failed.
	AthenaErrorCode *string `min:"1" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidRequestException) OrigErr() error {
	return nil
}

func (s InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidRequestException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidRequestException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListNamedQueriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of queries to return in this request.
	MaxResults *int64 `type:"integer"`

	// The token that specifies where to start pagination if a previous request
	// was truncated.
	NextToken *string `min:"1" type:"string"`

	// The name of the workgroup from which the named queries are being returned.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s ListNamedQueriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamedQueriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamedQueriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamedQueriesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNamedQueriesInput) SetMaxResults(v int64) *ListNamedQueriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedQueriesInput) SetNextToken(v string) *ListNamedQueriesInput {
	s.NextToken = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *ListNamedQueriesInput) SetWorkGroup(v string) *ListNamedQueriesInput {
	s.WorkGroup = &v
	return s
}

type ListNamedQueriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of unique query IDs.
	NamedQueryIds []*string `min:"1" type:"list"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListNamedQueriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamedQueriesOutput) GoString() string {
	return s.String()
}

// SetNamedQueryIds sets the NamedQueryIds field's value.
func (s *ListNamedQueriesOutput) SetNamedQueryIds(v []*string) *ListNamedQueriesOutput {
	s.NamedQueryIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedQueriesOutput) SetNextToken(v string) *ListNamedQueriesOutput {
	s.NextToken = &v
	return s
}

type ListQueryExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of query executions to return in this request.
	MaxResults *int64 `type:"integer"`

	// The token that specifies where to start pagination if a previous request
	// was truncated.
	NextToken *string `min:"1" type:"string"`

	// The name of the workgroup from which queries are being returned.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s ListQueryExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueryExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueryExecutionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueryExecutionsInput) SetMaxResults(v int64) *ListQueryExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryExecutionsInput) SetNextToken(v string) *ListQueryExecutionsInput {
	s.NextToken = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *ListQueryExecutionsInput) SetWorkGroup(v string) *ListQueryExecutionsInput {
	s.WorkGroup = &v
	return s
}

type ListQueryExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`

	// The unique IDs of each query execution as an array of strings.
	QueryExecutionIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s ListQueryExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQueryExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueryExecutionsOutput) SetNextToken(v string) *ListQueryExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetQueryExecutionIds sets the QueryExecutionIds field's value.
func (s *ListQueryExecutionsOutput) SetQueryExecutionIds(v []*string) *ListQueryExecutionsOutput {
	s.QueryExecutionIds = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per request that lists the tags
	// for the workgroup resource.
	MaxResults *int64 `min:"75" type:"integer"`

	// The token for the next set of results, or null if there are no additional
	// results for this request, where the request lists the tags for the workgroup
	// resource with the specified ARN.
	NextToken *string `min:"1" type:"string"`

	// Lists the tags for the workgroup resource with the specified ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 75 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 75))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`

	// The list of tags associated with this workgroup.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWorkGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of workgroups to return in this request.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorkGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkGroupsInput) SetMaxResults(v int64) *ListWorkGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkGroupsInput) SetNextToken(v string) *ListWorkGroupsInput {
	s.NextToken = &v
	return s
}

type ListWorkGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A token to be used by the next request if this request is truncated.
	NextToken *string `min:"1" type:"string"`

	// The list of workgroups, including their names, descriptions, creation times,
	// and states.
	WorkGroups []*WorkGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListWorkGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkGroupsOutput) SetNextToken(v string) *ListWorkGroupsOutput {
	s.NextToken = &v
	return s
}

// SetWorkGroups sets the WorkGroups field's value.
func (s *ListWorkGroupsOutput) SetWorkGroups(v []*WorkGroupSummary) *ListWorkGroupsOutput {
	s.WorkGroups = v
	return s
}

// A query, where QueryString is the list of SQL query statements that comprise
// the query.
type NamedQuery struct {
	_ struct{} `type:"structure"`

	// The database to which the query belongs.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The query description.
	Description *string `min:"1" type:"string"`

	// The query name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the query.
	NamedQueryId *string `type:"string"`

	// The SQL query statements that comprise the query.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// The name of the workgroup that contains the named query.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s NamedQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamedQuery) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *NamedQuery) SetDatabase(v string) *NamedQuery {
	s.Database = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NamedQuery) SetDescription(v string) *NamedQuery {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamedQuery) SetName(v string) *NamedQuery {
	s.Name = &v
	return s
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *NamedQuery) SetNamedQueryId(v string) *NamedQuery {
	s.NamedQueryId = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *NamedQuery) SetQueryString(v string) *NamedQuery {
	s.QueryString = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *NamedQuery) SetWorkGroup(v string) *NamedQuery {
	s.WorkGroup = &v
	return s
}

// Information about a single instance of a query execution.
type QueryExecution struct {
	_ struct{} `type:"structure"`

	// The SQL query statements which the query execution ran.
	Query *string `min:"1" type:"string"`

	// The database in which the query execution occurred.
	QueryExecutionContext *QueryExecutionContext `type:"structure"`

	// The unique identifier for each query execution.
	QueryExecutionId *string `type:"string"`

	// The location in Amazon S3 where query results were stored and the encryption
	// option, if any, used for query results. These are known as "client-side settings".
	// If workgroup settings override client-side settings, then the query uses
	// the location for the query results and the encryption configuration that
	// are specified for the workgroup.
	ResultConfiguration *ResultConfiguration `type:"structure"`

	// The type of query statement that was run. DDL indicates DDL query statements.
	// DML indicates DML (Data Manipulation Language) query statements, such as
	// CREATE TABLE AS SELECT. UTILITY indicates query statements other than DDL
	// and DML, such as SHOW CREATE TABLE, or DESCRIBE <table>.
	StatementType *string `type:"string" enum:"StatementType"`

	// The amount of data scanned during the query execution and the amount of time
	// that it took to execute, and the type of statement that was run.
	Statistics *QueryExecutionStatistics `type:"structure"`

	// The completion date, current state, submission time, and state change reason
	// (if applicable) for the query execution.
	Status *QueryExecutionStatus `type:"structure"`

	// The name of the workgroup in which the query ran.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s QueryExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecution) GoString() string {
	return s.String()
}

// SetQuery sets the Query field's value.
func (s *QueryExecution) SetQuery(v string) *QueryExecution {
	s.Query = &v
	return s
}

// SetQueryExecutionContext sets the QueryExecutionContext field's value.
func (s *QueryExecution) SetQueryExecutionContext(v *QueryExecutionContext) *QueryExecution {
	s.QueryExecutionContext = v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *QueryExecution) SetQueryExecutionId(v string) *QueryExecution {
	s.QueryExecutionId = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *QueryExecution) SetResultConfiguration(v *ResultConfiguration) *QueryExecution {
	s.ResultConfiguration = v
	return s
}

// SetStatementType sets the StatementType field's value.
func (s *QueryExecution) SetStatementType(v string) *QueryExecution {
	s.StatementType = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *QueryExecution) SetStatistics(v *QueryExecutionStatistics) *QueryExecution {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueryExecution) SetStatus(v *QueryExecutionStatus) *QueryExecution {
	s.Status = v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *QueryExecution) SetWorkGroup(v string) *QueryExecution {
	s.WorkGroup = &v
	return s
}

// The database in which the query execution occurs.
type QueryExecutionContext struct {
	_ struct{} `type:"structure"`

	// The name of the database.
	Database *string `min:"1" type:"string"`
}

// String returns the string representation
func (s QueryExecutionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionContext) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryExecutionContext) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryExecutionContext"}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *QueryExecutionContext) SetDatabase(v string) *QueryExecutionContext {
	s.Database = &v
	return s
}

// The amount of data scanned during the query execution and the amount of time
// that it took to execute, and the type of statement that was run.
type QueryExecutionStatistics struct {
	_ struct{} `type:"structure"`

	// The location and file name of a data manifest file. The manifest file is
	// saved to the Athena query results location in Amazon S3. The manifest file
	// tracks files that the query wrote to Amazon S3. If the query fails, the manifest
	// file also tracks files that the query intended to write. The manifest is
	// useful for identifying orphaned files resulting from a failed query. For
	// more information, see Working with Query Results, Output Files, and Query
	// History (https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the
	// Amazon Athena User Guide.
	DataManifestLocation *string `type:"string"`

	// The number of bytes in the data that was queried.
	DataScannedInBytes *int64 `type:"long"`

	// The number of milliseconds that the query took to execute.
	EngineExecutionTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that Athena took to plan the query processing
	// flow. This includes the time spent retrieving table partitions from the data
	// source. Note that because the query engine performs the query planning, query
	// planning time is a subset of engine processing time.
	QueryPlanningTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that the query was in your query queue waiting
	// for resources. Note that if transient errors occur, Athena might automatically
	// add the query back to the queue.
	QueryQueueTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that Athena took to finalize and publish the query
	// results after the query engine finished running the query.
	ServiceProcessingTimeInMillis *int64 `type:"long"`

	// The number of milliseconds that Athena took to run the query.
	TotalExecutionTimeInMillis *int64 `type:"long"`
}

// String returns the string representation
func (s QueryExecutionStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionStatistics) GoString() string {
	return s.String()
}

// SetDataManifestLocation sets the DataManifestLocation field's value.
func (s *QueryExecutionStatistics) SetDataManifestLocation(v string) *QueryExecutionStatistics {
	s.DataManifestLocation = &v
	return s
}

// SetDataScannedInBytes sets the DataScannedInBytes field's value.
func (s *QueryExecutionStatistics) SetDataScannedInBytes(v int64) *QueryExecutionStatistics {
	s.DataScannedInBytes = &v
	return s
}

// SetEngineExecutionTimeInMillis sets the EngineExecutionTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetEngineExecutionTimeInMillis(v int64) *QueryExecutionStatistics {
	s.EngineExecutionTimeInMillis = &v
	return s
}

// SetQueryPlanningTimeInMillis sets the QueryPlanningTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetQueryPlanningTimeInMillis(v int64) *QueryExecutionStatistics {
	s.QueryPlanningTimeInMillis = &v
	return s
}

// SetQueryQueueTimeInMillis sets the QueryQueueTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetQueryQueueTimeInMillis(v int64) *QueryExecutionStatistics {
	s.QueryQueueTimeInMillis = &v
	return s
}

// SetServiceProcessingTimeInMillis sets the ServiceProcessingTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetServiceProcessingTimeInMillis(v int64) *QueryExecutionStatistics {
	s.ServiceProcessingTimeInMillis = &v
	return s
}

// SetTotalExecutionTimeInMillis sets the TotalExecutionTimeInMillis field's value.
func (s *QueryExecutionStatistics) SetTotalExecutionTimeInMillis(v int64) *QueryExecutionStatistics {
	s.TotalExecutionTimeInMillis = &v
	return s
}

// The completion date, current state, submission time, and state change reason
// (if applicable) for the query execution.
type QueryExecutionStatus struct {
	_ struct{} `type:"structure"`

	// The date and time that the query completed.
	CompletionDateTime *time.Time `type:"timestamp"`

	// The state of query execution. QUEUED state is listed but is not used by Athena
	// and is reserved for future use. RUNNING indicates that the query has been
	// submitted to the service, and Athena will execute the query as soon as resources
	// are available. SUCCEEDED indicates that the query completed without errors.
	// FAILED indicates that the query experienced an error and did not complete
	// processing. CANCELLED indicates that a user input interrupted query execution.
	State *string `type:"string" enum:"QueryExecutionState"`

	// Further detail about the status of the query.
	StateChangeReason *string `type:"string"`

	// The date and time that the query was submitted.
	SubmissionDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s QueryExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryExecutionStatus) GoString() string {
	return s.String()
}

// SetCompletionDateTime sets the CompletionDateTime field's value.
func (s *QueryExecutionStatus) SetCompletionDateTime(v time.Time) *QueryExecutionStatus {
	s.CompletionDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *QueryExecutionStatus) SetState(v string) *QueryExecutionStatus {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *QueryExecutionStatus) SetStateChangeReason(v string) *QueryExecutionStatus {
	s.StateChangeReason = &v
	return s
}

// SetSubmissionDateTime sets the SubmissionDateTime field's value.
func (s *QueryExecutionStatus) SetSubmissionDateTime(v time.Time) *QueryExecutionStatus {
	s.SubmissionDateTime = &v
	return s
}

// A resource, such as a workgroup, was not found.
type ResourceNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`

	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// The location in Amazon S3 where query results are stored and the encryption
// option, if any, used for query results. These are known as "client-side settings".
// If workgroup settings override client-side settings, then the query uses
// the workgroup settings.
type ResultConfiguration struct {
	_ struct{} `type:"structure"`

	// If query results are encrypted in Amazon S3, indicates the encryption option
	// used (for example, SSE-KMS or CSE-KMS) and key information. This is a client-side
	// setting. If workgroup settings override client-side settings, then the query
	// uses the encryption configuration that is specified for the workgroup, and
	// also uses the location for storing query results specified in the workgroup.
	// See WorkGroupConfiguration$EnforceWorkGroupConfiguration and Workgroup Settings
	// Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The location in Amazon S3 where your query results are stored, such as s3://path/to/query/bucket/.
	// To run the query, you must specify the query results location using one of
	// the ways: either for individual queries using either this setting (client-side),
	// or in the workgroup, using WorkGroupConfiguration. If none of them is set,
	// Athena issues an error that no output location is provided. For more information,
	// see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html).
	// If workgroup settings override client-side settings, then the query uses
	// the settings specified for the workgroup. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	OutputLocation *string `type:"string"`
}

// String returns the string representation
func (s ResultConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResultConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResultConfiguration"}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ResultConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *ResultConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *ResultConfiguration) SetOutputLocation(v string) *ResultConfiguration {
	s.OutputLocation = &v
	return s
}

// The information about the updates in the query results, such as output location
// and encryption configuration for the query results.
type ResultConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// The encryption configuration for the query results.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The location in Amazon S3 where your query results are stored, such as s3://path/to/query/bucket/.
	// For more information, see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html)
	// If workgroup settings override client-side settings, then the query uses
	// the location for the query results and the encryption configuration that
	// are specified for the workgroup. The "workgroup settings override" is specified
	// in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration.
	// See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	OutputLocation *string `type:"string"`

	// If set to "true", indicates that the previously-specified encryption configuration
	// (also known as the client-side setting) for queries in this workgroup should
	// be ignored and set to null. If set to "false" or not set, and a value is
	// present in the EncryptionConfiguration in ResultConfigurationUpdates (the
	// client-side setting), the EncryptionConfiguration in the workgroup's ResultConfiguration
	// will be updated with the new value. For more information, see Workgroup Settings
	// Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	RemoveEncryptionConfiguration *bool `type:"boolean"`

	// If set to "true", indicates that the previously-specified query results location
	// (also known as a client-side setting) for queries in this workgroup should
	// be ignored and set to null. If set to "false" or not set, and a value is
	// present in the OutputLocation in ResultConfigurationUpdates (the client-side
	// setting), the OutputLocation in the workgroup's ResultConfiguration will
	// be updated with the new value. For more information, see Workgroup Settings
	// Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	RemoveOutputLocation *bool `type:"boolean"`
}

// String returns the string representation
func (s ResultConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultConfigurationUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResultConfigurationUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResultConfigurationUpdates"}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ResultConfigurationUpdates) SetEncryptionConfiguration(v *EncryptionConfiguration) *ResultConfigurationUpdates {
	s.EncryptionConfiguration = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *ResultConfigurationUpdates) SetOutputLocation(v string) *ResultConfigurationUpdates {
	s.OutputLocation = &v
	return s
}

// SetRemoveEncryptionConfiguration sets the RemoveEncryptionConfiguration field's value.
func (s *ResultConfigurationUpdates) SetRemoveEncryptionConfiguration(v bool) *ResultConfigurationUpdates {
	s.RemoveEncryptionConfiguration = &v
	return s
}

// SetRemoveOutputLocation sets the RemoveOutputLocation field's value.
func (s *ResultConfigurationUpdates) SetRemoveOutputLocation(v bool) *ResultConfigurationUpdates {
	s.RemoveOutputLocation = &v
	return s
}

// The metadata and rows that comprise a query result set. The metadata describes
// the column structure and data types.
type ResultSet struct {
	_ struct{} `type:"structure"`

	// The metadata that describes the column structure and data types of a table
	// of query results.
	ResultSetMetadata *ResultSetMetadata `type:"structure"`

	// The rows in the table.
	Rows []*Row `type:"list"`
}

// String returns the string representation
func (s ResultSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSet) GoString() string {
	return s.String()
}

// SetResultSetMetadata sets the ResultSetMetadata field's value.
func (s *ResultSet) SetResultSetMetadata(v *ResultSetMetadata) *ResultSet {
	s.ResultSetMetadata = v
	return s
}

// SetRows sets the Rows field's value.
func (s *ResultSet) SetRows(v []*Row) *ResultSet {
	s.Rows = v
	return s
}

// The metadata that describes the column structure and data types of a table
// of query results.
type ResultSetMetadata struct {
	_ struct{} `type:"structure"`

	// Information about the columns returned in a query result metadata.
	ColumnInfo []*ColumnInfo `type:"list"`
}

// String returns the string representation
func (s ResultSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultSetMetadata) GoString() string {
	return s.String()
}

// SetColumnInfo sets the ColumnInfo field's value.
func (s *ResultSetMetadata) SetColumnInfo(v []*ColumnInfo) *ResultSetMetadata {
	s.ColumnInfo = v
	return s
}

// The rows that comprise a query result table.
type Row struct {
	_ struct{} `type:"structure"`

	// The data that populates a row in a query result table.
	Data []*Datum `type:"list"`
}

// String returns the string representation
func (s Row) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Row) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Row) SetData(v []*Datum) *Row {
	s.Data = v
	return s
}

type StartQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive string used to ensure the request to create the query
	// is idempotent (executes only once). If another StartQueryExecution request
	// is received, the same response is returned and another query is not created.
	// If a parameter has changed, for example, the QueryString, an error is returned.
	//
	// This token is listed as not required because AWS SDKs (for example the AWS
	// SDK for Java) auto-generate the token for users. If you are not using the
	// AWS SDK or the AWS CLI, you must provide this token or the action will fail.
	ClientRequestToken *string `min:"32" type:"string" idempotencyToken:"true"`

	// The database within which the query executes.
	QueryExecutionContext *QueryExecutionContext `type:"structure"`

	// The SQL query statements to be executed.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// Specifies information about where and how to save the results of the query
	// execution. If the query runs in a workgroup, then workgroup's settings may
	// override query settings. This affects the query results location. The workgroup
	// settings override is specified in EnforceWorkGroupConfiguration (true/false)
	// in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	ResultConfiguration *ResultConfiguration `type:"structure"`

	// The name of the workgroup in which the query is being started.
	WorkGroup *string `type:"string"`
}

// String returns the string representation
func (s StartQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartQueryExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartQueryExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartQueryExecutionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 32))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.QueryExecutionContext != nil {
		if err := s.QueryExecutionContext.Validate(); err != nil {
			invalidParams.AddNested("QueryExecutionContext", err.(request.ErrInvalidParams))
		}
	}
	if s.ResultConfiguration != nil {
		if err := s.ResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartQueryExecutionInput) SetClientRequestToken(v string) *StartQueryExecutionInput {
	s.ClientRequestToken = &v
	return s
}

// SetQueryExecutionContext sets the QueryExecutionContext field's value.
func (s *StartQueryExecutionInput) SetQueryExecutionContext(v *QueryExecutionContext) *StartQueryExecutionInput {
	s.QueryExecutionContext = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *StartQueryExecutionInput) SetQueryString(v string) *StartQueryExecutionInput {
	s.QueryString = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *StartQueryExecutionInput) SetResultConfiguration(v *ResultConfiguration) *StartQueryExecutionInput {
	s.ResultConfiguration = v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *StartQueryExecutionInput) SetWorkGroup(v string) *StartQueryExecutionInput {
	s.WorkGroup = &v
	return s
}

type StartQueryExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query that ran as a result of this request.
	QueryExecutionId *string `type:"string"`
}

// String returns the string representation
func (s StartQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartQueryExecutionOutput) GoString() string {
	return s.String()
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *StartQueryExecutionOutput) SetQueryExecutionId(v string) *StartQueryExecutionOutput {
	s.QueryExecutionId = &v
	return s
}

type StopQueryExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query execution to stop.
	QueryExecutionId *string `type:"string" idempotencyToken:"true"`
}

// String returns the string representation
func (s StopQueryExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopQueryExecutionInput) GoString() string {
	return s.String()
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *StopQueryExecutionInput) SetQueryExecutionId(v string) *StopQueryExecutionInput {
	s.QueryExecutionId = &v
	return s
}

type StopQueryExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopQueryExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopQueryExecutionOutput) GoString() string {
	return s.String()
}

// A tag that you can add to a resource. A tag is a label that you assign to
// an AWS Athena resource (a workgroup). Each tag consists of a key and an optional
// value, both of which you define. Tags enable you to categorize workgroups
// in Athena, for example, by purpose, owner, or environment. Use a consistent
// set of tag keys to make it easier to search and filter workgroups in your
// account. The maximum tag key length is 128 Unicode characters in UTF-8. The
// maximum tag value length is 256 Unicode characters in UTF-8. You can use
// letters and numbers representable in UTF-8, and the following characters:
// + - = . _ : / @. Tag keys and values are case-sensitive. Tag keys must be
// unique per resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8.
	// You can use letters and numbers representable in UTF-8, and the following
	// characters: + - = . _ : / @. Tag keys are case-sensitive and must be unique
	// per resource.
	Key *string `min:"1" type:"string"`

	// A tag value. The tag value length is from 0 to 256 Unicode characters in
	// UTF-8. You can use letters and numbers representable in UTF-8, and the following
	// characters: + - = . _ : / @. Tag values are case-sensitive.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Requests that one or more tags are added to the resource (such as a workgroup)
	// for the specified ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// One or more tags, separated by commas, to be added to the resource, such
	// as a workgroup.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Indicates that the request was throttled.
type TooManyRequestsException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the query throttling, for example, when it exceeds the concurrent
	// query limit.
	Reason *string `type:"string" enum:"ThrottleReason"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TooManyRequestsException) OrigErr() error {
	return nil
}

func (s TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s TooManyRequestsException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TooManyRequestsException) RequestID() string {
	return s.respMetadata.RequestID
}

// Information about a named query ID that could not be processed.
type UnprocessedNamedQueryId struct {
	_ struct{} `type:"structure"`

	// The error code returned when the processing request for the named query failed,
	// if applicable.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned when the processing request for the named query
	// failed, if applicable.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the named query.
	NamedQueryId *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedNamedQueryId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedNamedQueryId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedNamedQueryId) SetErrorCode(v string) *UnprocessedNamedQueryId {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedNamedQueryId) SetErrorMessage(v string) *UnprocessedNamedQueryId {
	s.ErrorMessage = &v
	return s
}

// SetNamedQueryId sets the NamedQueryId field's value.
func (s *UnprocessedNamedQueryId) SetNamedQueryId(v string) *UnprocessedNamedQueryId {
	s.NamedQueryId = &v
	return s
}

// Describes a query execution that failed to process.
type UnprocessedQueryExecutionId struct {
	_ struct{} `type:"structure"`

	// The error code returned when the query execution failed to process, if applicable.
	ErrorCode *string `min:"1" type:"string"`

	// The error message returned when the query execution failed to process, if
	// applicable.
	ErrorMessage *string `type:"string"`

	// The unique identifier of the query execution.
	QueryExecutionId *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedQueryExecutionId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedQueryExecutionId) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UnprocessedQueryExecutionId) SetErrorCode(v string) *UnprocessedQueryExecutionId {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedQueryExecutionId) SetErrorMessage(v string) *UnprocessedQueryExecutionId {
	s.ErrorMessage = &v
	return s
}

// SetQueryExecutionId sets the QueryExecutionId field's value.
func (s *UnprocessedQueryExecutionId) SetQueryExecutionId(v string) *UnprocessedQueryExecutionId {
	s.QueryExecutionId = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Removes one or more tags from the workgroup resource for the specified ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// Removes the tags associated with one or more tag keys from the workgroup
	// resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateWorkGroupInput struct {
	_ struct{} `type:"structure"`

	// The workgroup configuration that will be updated for the given workgroup.
	ConfigurationUpdates *WorkGroupConfigurationUpdates `type:"structure"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup state that will be updated for the given workgroup.
	State *string `type:"string" enum:"WorkGroupState"`

	// The specified workgroup that will be updated.
	//
	// WorkGroup is a required field
	WorkGroup *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateWorkGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorkGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkGroupInput"}
	if s.WorkGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkGroup"))
	}
	if s.ConfigurationUpdates != nil {
		if err := s.ConfigurationUpdates.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationUpdates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationUpdates sets the ConfigurationUpdates field's value.
func (s *UpdateWorkGroupInput) SetConfigurationUpdates(v *WorkGroupConfigurationUpdates) *UpdateWorkGroupInput {
	s.ConfigurationUpdates = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateWorkGroupInput) SetDescription(v string) *UpdateWorkGroupInput {
	s.Description = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateWorkGroupInput) SetState(v string) *UpdateWorkGroupInput {
	s.State = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *UpdateWorkGroupInput) SetWorkGroup(v string) *UpdateWorkGroupInput {
	s.WorkGroup = &v
	return s
}

type UpdateWorkGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateWorkGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorkGroupOutput) GoString() string {
	return s.String()
}

// A workgroup, which contains a name, description, creation time, state, and
// other configuration, listed under WorkGroup$Configuration. Each workgroup
// enables you to isolate queries for you or your group of users from other
// queries in the same account, to configure the query results location and
// the encryption configuration (known as workgroup settings), to enable sending
// query metrics to Amazon CloudWatch, and to establish per-query data usage
// control limits for all queries in a workgroup. The workgroup settings override
// is specified in EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration.
// See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
type WorkGroup struct {
	_ struct{} `type:"structure"`

	// The configuration of the workgroup, which includes the location in Amazon
	// S3 where query results are stored, the encryption configuration, if any,
	// used for query results; whether the Amazon CloudWatch Metrics are enabled
	// for the workgroup; whether workgroup settings override client-side settings;
	// and the data usage limits for the amount of data scanned per query or per
	// workgroup. The workgroup settings override is specified in EnforceWorkGroupConfiguration
	// (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
	Configuration *WorkGroupConfiguration `type:"structure"`

	// The date and time the workgroup was created.
	CreationTime *time.Time `type:"timestamp"`

	// The workgroup description.
	Description *string `type:"string"`

	// The workgroup name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The state of the workgroup: ENABLED or DISABLED.
	State *string `type:"string" enum:"WorkGroupState"`
}

// String returns the string representation
func (s WorkGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroup) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *WorkGroup) SetConfiguration(v *WorkGroupConfiguration) *WorkGroup {
	s.Configuration = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkGroup) SetCreationTime(v time.Time) *WorkGroup {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkGroup) SetDescription(v string) *WorkGroup {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkGroup) SetName(v string) *WorkGroup {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkGroup) SetState(v string) *WorkGroup {
	s.State = &v
	return s
}

// The configuration of the workgroup, which includes the location in Amazon
// S3 where query results are stored, the encryption option, if any, used for
// query results, whether the Amazon CloudWatch Metrics are enabled for the
// workgroup and whether workgroup settings override query settings, and the
// data usage limits for the amount of data scanned per query or per workgroup.
// The workgroup settings override is specified in EnforceWorkGroupConfiguration
// (true/false) in the WorkGroupConfiguration. See WorkGroupConfiguration$EnforceWorkGroupConfiguration.
type WorkGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The upper data usage limit (cutoff) for the amount of bytes a single query
	// in a workgroup is allowed to scan.
	BytesScannedCutoffPerQuery *int64 `min:"1e+07" type:"long"`

	// If set to "true", the settings for the workgroup override client-side settings.
	// If set to "false", client-side settings are used. For more information, see
	// Workgroup Settings Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	EnforceWorkGroupConfiguration *bool `type:"boolean"`

	// Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.
	PublishCloudWatchMetricsEnabled *bool `type:"boolean"`

	// If set to true, allows members assigned to a workgroup to reference Amazon
	// S3 Requester Pays buckets in queries. If set to false, workgroup members
	// cannot query data from Requester Pays buckets, and queries that retrieve
	// data from Requester Pays buckets cause an error. The default is false. For
	// more information about Requester Pays buckets, see Requester Pays Buckets
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html)
	// in the Amazon Simple Storage Service Developer Guide.
	RequesterPaysEnabled *bool `type:"boolean"`

	// The configuration for the workgroup, which includes the location in Amazon
	// S3 where query results are stored and the encryption option, if any, used
	// for query results. To run the query, you must specify the query results location
	// using one of the ways: either in the workgroup using this setting, or for
	// individual queries (client-side), using ResultConfiguration$OutputLocation.
	// If none of them is set, Athena issues an error that no output location is
	// provided. For more information, see Query Results (https://docs.aws.amazon.com/athena/latest/ug/querying.html).
	ResultConfiguration *ResultConfiguration `type:"structure"`
}

// String returns the string representation
func (s WorkGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroupConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkGroupConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkGroupConfiguration"}
	if s.BytesScannedCutoffPerQuery != nil && *s.BytesScannedCutoffPerQuery < 1e+07 {
		invalidParams.Add(request.NewErrParamMinValue("BytesScannedCutoffPerQuery", 1e+07))
	}
	if s.ResultConfiguration != nil {
		if err := s.ResultConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResultConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytesScannedCutoffPerQuery sets the BytesScannedCutoffPerQuery field's value.
func (s *WorkGroupConfiguration) SetBytesScannedCutoffPerQuery(v int64) *WorkGroupConfiguration {
	s.BytesScannedCutoffPerQuery = &v
	return s
}

// SetEnforceWorkGroupConfiguration sets the EnforceWorkGroupConfiguration field's value.
func (s *WorkGroupConfiguration) SetEnforceWorkGroupConfiguration(v bool) *WorkGroupConfiguration {
	s.EnforceWorkGroupConfiguration = &v
	return s
}

// SetPublishCloudWatchMetricsEnabled sets the PublishCloudWatchMetricsEnabled field's value.
func (s *WorkGroupConfiguration) SetPublishCloudWatchMetricsEnabled(v bool) *WorkGroupConfiguration {
	s.PublishCloudWatchMetricsEnabled = &v
	return s
}

// SetRequesterPaysEnabled sets the RequesterPaysEnabled field's value.
func (s *WorkGroupConfiguration) SetRequesterPaysEnabled(v bool) *WorkGroupConfiguration {
	s.RequesterPaysEnabled = &v
	return s
}

// SetResultConfiguration sets the ResultConfiguration field's value.
func (s *WorkGroupConfiguration) SetResultConfiguration(v *ResultConfiguration) *WorkGroupConfiguration {
	s.ResultConfiguration = v
	return s
}

// The configuration information that will be updated for this workgroup, which
// includes the location in Amazon S3 where query results are stored, the encryption
// option, if any, used for query results, whether the Amazon CloudWatch Metrics
// are enabled for the workgroup, whether the workgroup settings override the
// client-side settings, and the data usage limit for the amount of bytes scanned
// per query, if it is specified.
type WorkGroupConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// The upper limit (cutoff) for the amount of bytes a single query in a workgroup
	// is allowed to scan.
	BytesScannedCutoffPerQuery *int64 `min:"1e+07" type:"long"`

	// If set to "true", the settings for the workgroup override client-side settings.
	// If set to "false" client-side settings are used. For more information, see
	// Workgroup Settings Override Client-Side Settings (https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html).
	EnforceWorkGroupConfiguration *bool `type:"boolean"`

	// Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.
	PublishCloudWatchMetricsEnabled *bool `type:"boolean"`

	// Indicates that the data usage control limit per query is removed. WorkGroupConfiguration$BytesScannedCutoffPerQuery
	RemoveBytesScannedCutoffPerQuery *bool `type:"boolean"`

	// If set to true, allows members assigned to a workgroup to specify Amazon
	// S3 Requester Pays buckets in queries. If set to false, workgroup members
	// cannot query data from Requester Pays buckets, and queries that retrieve
	// data from Requester Pays buckets cause an error. The default is false. For
	// more information about Requester Pays buckets, see Requester Pays Buckets
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html)
	// in the Amazon Simple Storage Service Developer Guide.
	RequesterPaysEnabled *bool `type:"boolean"`

	// The result configuration information about the queries in this workgroup
	// that will be updated. Includes the updated results location and an updated
	// option for encrypting query results.
	ResultConfigurationUpdates *ResultConfigurationUpdates `type:"structure"`
}

// String returns the string representation
func (s WorkGroupConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroupConfigurationUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkGroupConfigurationUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkGroupConfigurationUpdates"}
	if s.BytesScannedCutoffPerQuery != nil && *s.BytesScannedCutoffPerQuery < 1e+07 {
		invalidParams.Add(request.NewErrParamMinValue("BytesScannedCutoffPerQuery", 1e+07))
	}
	if s.ResultConfigurationUpdates != nil {
		if err := s.ResultConfigurationUpdates.Validate(); err != nil {
			invalidParams.AddNested("ResultConfigurationUpdates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytesScannedCutoffPerQuery sets the BytesScannedCutoffPerQuery field's value.
func (s *WorkGroupConfigurationUpdates) SetBytesScannedCutoffPerQuery(v int64) *WorkGroupConfigurationUpdates {
	s.BytesScannedCutoffPerQuery = &v
	return s
}

// SetEnforceWorkGroupConfiguration sets the EnforceWorkGroupConfiguration field's value.
func (s *WorkGroupConfigurationUpdates) SetEnforceWorkGroupConfiguration(v bool) *WorkGroupConfigurationUpdates {
	s.EnforceWorkGroupConfiguration = &v
	return s
}

// SetPublishCloudWatchMetricsEnabled sets the PublishCloudWatchMetricsEnabled field's value.
func (s *WorkGroupConfigurationUpdates) SetPublishCloudWatchMetricsEnabled(v bool) *WorkGroupConfigurationUpdates {
	s.PublishCloudWatchMetricsEnabled = &v
	return s
}

// SetRemoveBytesScannedCutoffPerQuery sets the RemoveBytesScannedCutoffPerQuery field's value.
func (s *WorkGroupConfigurationUpdates) SetRemoveBytesScannedCutoffPerQuery(v bool) *WorkGroupConfigurationUpdates {
	s.RemoveBytesScannedCutoffPerQuery = &v
	return s
}

// SetRequesterPaysEnabled sets the RequesterPaysEnabled field's value.
func (s *WorkGroupConfigurationUpdates) SetRequesterPaysEnabled(v bool) *WorkGroupConfigurationUpdates {
	s.RequesterPaysEnabled = &v
	return s
}

// SetResultConfigurationUpdates sets the ResultConfigurationUpdates field's value.
func (s *WorkGroupConfigurationUpdates) SetResultConfigurationUpdates(v *ResultConfigurationUpdates) *WorkGroupConfigurationUpdates {
	s.ResultConfigurationUpdates = v
	return s
}

// The summary information for the workgroup, which includes its name, state,
// description, and the date and time it was created.
type WorkGroupSummary struct {
	_ struct{} `type:"structure"`

	// The workgroup creation date and time.
	CreationTime *time.Time `type:"timestamp"`

	// The workgroup description.
	Description *string `type:"string"`

	// The name of the workgroup.
	Name *string `type:"string"`

	// The state of the workgroup.
	State *string `type:"string" enum:"WorkGroupState"`
}

// String returns the string representation
func (s WorkGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkGroupSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkGroupSummary) SetCreationTime(v time.Time) *WorkGroupSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkGroupSummary) SetDescription(v string) *WorkGroupSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkGroupSummary) SetName(v string) *WorkGroupSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkGroupSummary) SetState(v string) *WorkGroupSummary {
	s.State = &v
	return s
}

const (
	// ColumnNullableNotNull is a ColumnNullable enum value
	ColumnNullableNotNull = "NOT_NULL"

	// ColumnNullableNullable is a ColumnNullable enum value
	ColumnNullableNullable = "NULLABLE"

	// ColumnNullableUnknown is a ColumnNullable enum value
	ColumnNullableUnknown = "UNKNOWN"
)

const (
	// EncryptionOptionSseS3 is a EncryptionOption enum value
	EncryptionOptionSseS3 = "SSE_S3"

	// EncryptionOptionSseKms is a EncryptionOption enum value
	EncryptionOptionSseKms = "SSE_KMS"

	// EncryptionOptionCseKms is a EncryptionOption enum value
	EncryptionOptionCseKms = "CSE_KMS"
)

const (
	// QueryExecutionStateQueued is a QueryExecutionState enum value
	QueryExecutionStateQueued = "QUEUED"

	// QueryExecutionStateRunning is a QueryExecutionState enum value
	QueryExecutionStateRunning = "RUNNING"

	// QueryExecutionStateSucceeded is a QueryExecutionState enum value
	QueryExecutionStateSucceeded = "SUCCEEDED"

	// QueryExecutionStateFailed is a QueryExecutionState enum value
	QueryExecutionStateFailed = "FAILED"

	// QueryExecutionStateCancelled is a QueryExecutionState enum value
	QueryExecutionStateCancelled = "CANCELLED"
)

const (
	// StatementTypeDdl is a StatementType enum value
	StatementTypeDdl = "DDL"

	// StatementTypeDml is a StatementType enum value
	StatementTypeDml = "DML"

	// StatementTypeUtility is a StatementType enum value
	StatementTypeUtility = "UTILITY"
)

// The reason for the query throttling, for example, when it exceeds the concurrent
// query limit.
const (
	// ThrottleReasonConcurrentQueryLimitExceeded is a ThrottleReason enum value
	ThrottleReasonConcurrentQueryLimitExceeded = "CONCURRENT_QUERY_LIMIT_EXCEEDED"
)

const (
	// WorkGroupStateEnabled is a WorkGroupState enum value
	WorkGroupStateEnabled = "ENABLED"

	// WorkGroupStateDisabled is a WorkGroupState enum value
	WorkGroupStateDisabled = "DISABLED"
)
