# The PGRX Book

- [Introduction](./README.md)
- [Working with PGRX](./extension.md)
  - [Hello, `cargo pgrx`!](./extension/cargo-pgrx.md)
  - [Building Extensions with PGRX](./extension/build.md)
    - [Cross Compiling](./extension/build/cross-compile.md)
  - [Writing Extensions with PGRX](./extension/write.md)
  - [Testing Extensions with PGRX](./extension/test.md)
    - [Memory Checking](./extension/test/memory-checking.md)
  - [Installing a PGRX Extension](./extension/install.md)
  - [Schema Configuration](./extension/schema.md)
- [Basics of Postgres Internals](./pg-internal.md)
  - [Pass-By-Datum](./pg-internal/datum.md)
  - [Memory Contexts](./pg-internal/memory-context.md)
  - [Varlena Types](./pg-internal/varlena.md)
  - [`sigsetjmp` & `siglongjmp`](./pg-internal/setjmp-longjmp.md)
- [FFI Error Handling](./ffi-error-handling.md)
- [Contributing](./contributing.md)
  - [PGRX Internals](./contributing/pgrx-internal.md)
  - [Releases](./contributing/release.md)
- [Articles](./articles.md)
  - [Forging SQL from Rust](./articles/forging-sql-from-rust.md)
  - [Postgres Aggregates from Rust](./articles/postgresql-aggregates-with-rust.md)
- [Design Decisions](./design-decisions.md)
