/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class Multipolygon {
    public static final String PREF_KEY_OUTER_ROLES = "mappaint.multipolygon.outer.roles";
    public static final String PREF_KEY_OUTER_ROLE_PREFIXES = "mappaint.multipolygon.outer.role-prefixes";
    public static final String PREF_KEY_INNER_ROLES = "mappaint.multipolygon.inner.roles";
    public static final String PREF_KEY_INNER_ROLE_PREFIXES = "mappaint.multipolygon.inner.role-prefixes";
    private static MultipolygonRoleMatcher roleMatcher;
    private final List<Way> innerWays = new ArrayList<Way>();
    private final List<Way> outerWays = new ArrayList<Way>();
    private final List<PolyData> combinedPolygons = new ArrayList<PolyData>();
    private final List<Node> openEnds = new ArrayList<Node>();
    private boolean incomplete;

    private static synchronized MultipolygonRoleMatcher getMultipolygonRoleMatcher() {
        if (roleMatcher == null) {
            roleMatcher = new MultipolygonRoleMatcher();
            if (Config.getPref() != null) {
                roleMatcher.initFromPreferences();
                Config.getPref().addPreferenceChangeListener(roleMatcher);
            }
        }
        return roleMatcher;
    }

    public Multipolygon(Relation r) {
        this.load(r);
    }

    private void load(Relation r) {
        MultipolygonRoleMatcher matcher = Multipolygon.getMultipolygonRoleMatcher();
        for (RelationMember m : r.getMembers()) {
            Way w;
            if (m.getMember().isIncomplete()) {
                this.incomplete = true;
                continue;
            }
            if (m.getMember().isDeleted() || !m.isWay() || !(w = m.getWay()).hasOnlyLocatableNodes() || w.getNodesCount() < 2) continue;
            if (matcher.isInnerRole(m.getRole())) {
                this.innerWays.add(w);
                continue;
            }
            if (m.hasRole() && !matcher.isOuterRole(m.getRole())) continue;
            this.outerWays.add(w);
        }
        ArrayList<PolyData> innerPolygons = new ArrayList<PolyData>();
        ArrayList<PolyData> outerPolygons = new ArrayList<PolyData>();
        this.createPolygons(this.innerWays, innerPolygons);
        this.createPolygons(this.outerWays, outerPolygons);
        if (!outerPolygons.isEmpty()) {
            this.addInnerToOuters(innerPolygons, outerPolygons);
        }
    }

    public final boolean isIncomplete() {
        return this.incomplete;
    }

    private void createPolygons(List<Way> ways, List<PolyData> result) {
        ArrayList<Way> waysToJoin = new ArrayList<Way>();
        for (Way way : ways) {
            if (way.isClosed()) {
                result.add(new PolyData(way));
                continue;
            }
            waysToJoin.add(way);
        }
        for (JoinedWay jw : Multipolygon.joinWays(waysToJoin)) {
            result.add(new PolyData(jw));
            if (jw.isClosed()) continue;
            this.openEnds.add(jw.getFirstNode());
            this.openEnds.add(jw.getLastNode());
        }
    }

    public static Collection<JoinedWay> joinWays(Collection<Way> waysToJoin) {
        ArrayList<JoinedWay> result = new ArrayList<JoinedWay>();
        Way[] joinArray = waysToJoin.toArray(new Way[0]);
        int left = waysToJoin.size();
        while (left > 0) {
            boolean selected = false;
            ArrayList<Node> nodes = null;
            HashSet<Long> wayIds = new HashSet<Long>();
            boolean joined = true;
            while (joined && left > 0) {
                joined = false;
                for (int i = 0; i < joinArray.length && left != 0; ++i) {
                    Way c = joinArray[i];
                    if (c != null && c.isEmpty()) {
                        joinArray[i] = null;
                        --left;
                        continue;
                    }
                    if (c == null || c.isEmpty()) continue;
                    if (nodes == null) {
                        selected = c.isSelected();
                        joinArray[i] = null;
                        --left;
                        nodes = new ArrayList<Node>(c.getNodes());
                        wayIds.add(c.getUniqueId());
                        continue;
                    }
                    int cl = c.getNodesCount() - 1;
                    int nl = nodes.size() - 1;
                    int mode = 0;
                    if (nodes.get(nl) == c.getNode(0)) {
                        mode = 21;
                    } else if (nodes.get(0) == c.getNode(cl)) {
                        mode = 12;
                    } else if (nodes.get(0) == c.getNode(0)) {
                        mode = 11;
                    } else if (nodes.get(nl) == c.getNode(cl)) {
                        mode = 22;
                    }
                    if (mode == 0) continue;
                    joinArray[i] = null;
                    joined = true;
                    if (c.isSelected()) {
                        selected = true;
                    }
                    --left;
                    if (mode == 21) {
                        nodes.addAll(c.getNodes().subList(1, cl + 1));
                    } else if (mode == 12) {
                        nodes.addAll(0, c.getNodes().subList(0, cl));
                    } else {
                        ArrayList<Node> reversed = new ArrayList<Node>(c.getNodes());
                        Collections.reverse(reversed);
                        if (mode == 22) {
                            nodes.addAll(reversed.subList(1, cl + 1));
                        } else {
                            nodes.addAll(0, reversed.subList(0, cl));
                        }
                    }
                    wayIds.add(c.getUniqueId());
                }
            }
            if (nodes == null) continue;
            result.add(new JoinedWay(nodes, wayIds, selected));
        }
        return result;
    }

    public PolyData findOuterPolygon(PolyData inner, List<PolyData> outerPolygons) {
        Rectangle2D innerBox = inner.getBounds();
        PolyData insidePolygon = null;
        PolyData intersectingPolygon = null;
        int insideCount = 0;
        int intersectingCount = 0;
        for (PolyData outer : outerPolygons) {
            if (outer.getBounds().contains(innerBox)) {
                insidePolygon = outer;
                ++insideCount;
                continue;
            }
            if (!outer.getBounds().intersects(innerBox)) continue;
            intersectingPolygon = outer;
            ++intersectingCount;
        }
        if (insideCount == 1) {
            return insidePolygon;
        }
        if (intersectingCount == 1) {
            return intersectingPolygon;
        }
        PolyData result = null;
        for (PolyData combined : outerPolygons) {
            if (combined.contains(inner.poly) == PolyData.Intersection.OUTSIDE || result != null && result.contains(combined.poly) != PolyData.Intersection.INSIDE) continue;
            result = combined;
        }
        return result;
    }

    private void addInnerToOuters(List<PolyData> innerPolygons, List<PolyData> outerPolygons) {
        if (innerPolygons.isEmpty()) {
            this.combinedPolygons.addAll(outerPolygons);
        } else if (outerPolygons.size() == 1) {
            PolyData combinedOuter = new PolyData(outerPolygons.get(0));
            for (PolyData inner : innerPolygons) {
                combinedOuter.addInner(inner);
            }
            this.combinedPolygons.add(combinedOuter);
        } else {
            for (PolyData outer : outerPolygons) {
                this.combinedPolygons.add(new PolyData(outer));
            }
            for (PolyData pdInner : innerPolygons) {
                Optional.ofNullable(this.findOuterPolygon(pdInner, this.combinedPolygons)).orElseGet(() -> (PolyData)outerPolygons.get(0)).addInner(pdInner);
            }
        }
    }

    public List<Way> getOuterWays() {
        return Collections.unmodifiableList(this.outerWays);
    }

    public List<Way> getInnerWays() {
        return Collections.unmodifiableList(this.innerWays);
    }

    public List<PolyData> getCombinedPolygons() {
        return Collections.unmodifiableList(this.combinedPolygons);
    }

    public List<PolyData> getInnerPolygons() {
        ArrayList<PolyData> innerPolygons = new ArrayList<PolyData>();
        this.createPolygons(this.innerWays, innerPolygons);
        return innerPolygons;
    }

    public List<PolyData> getOuterPolygons() {
        ArrayList<PolyData> outerPolygons = new ArrayList<PolyData>();
        this.createPolygons(this.outerWays, outerPolygons);
        return outerPolygons;
    }

    public List<Node> getOpenEnds() {
        return Collections.unmodifiableList(this.openEnds);
    }

    public static class PolyData
    extends JoinedWay {
        private final Path2D.Double poly;
        private Rectangle2D bounds;
        private final List<PolyData> inners;

        public PolyData(Way closedWay) {
            this(closedWay.getNodes(), closedWay.isSelected(), Collections.singleton(closedWay.getUniqueId()));
        }

        public PolyData(JoinedWay joinedWay) {
            this(joinedWay.nodes, joinedWay.selected, joinedWay.wayIds);
        }

        private PolyData(List<Node> nodes, boolean selected, Collection<Long> wayIds) {
            super(nodes, wayIds, selected);
            this.inners = new ArrayList<PolyData>();
            this.poly = new Path2D.Double();
            this.poly.setWindingRule(0);
            this.buildPoly();
        }

        public PolyData(PolyData copy) {
            super(copy.nodes, copy.wayIds, copy.selected);
            this.poly = (Path2D.Double)copy.poly.clone();
            this.inners = new ArrayList<PolyData>(copy.inners);
        }

        private void buildPoly() {
            boolean initial = true;
            for (Node n : this.nodes) {
                EastNorth p = n.getEastNorth();
                if (p == null) continue;
                if (initial) {
                    this.poly.moveTo(p.getX(), p.getY());
                    initial = false;
                    continue;
                }
                this.poly.lineTo(p.getX(), p.getY());
            }
            if (this.nodes.size() >= 3 && this.nodes.get(0) == this.nodes.get(this.nodes.size() - 1)) {
                this.poly.closePath();
            }
            for (PolyData inner : this.inners) {
                this.appendInner(inner.poly);
            }
        }

        public Intersection contains(Path2D.Double p) {
            int contains = 0;
            int total = 0;
            double[] coords = new double[6];
            PathIterator it = p.getPathIterator(null);
            while (!it.isDone()) {
                switch (it.currentSegment(coords)) {
                    case 0: 
                    case 1: {
                        if (this.poly.contains(coords[0], coords[1])) {
                            ++contains;
                        }
                        ++total;
                        break;
                    }
                }
                it.next();
            }
            if (contains == total) {
                return Intersection.INSIDE;
            }
            if (contains == 0) {
                return Intersection.OUTSIDE;
            }
            return Intersection.CROSSING;
        }

        public void addInner(PolyData inner) {
            this.inners.add(inner);
            this.appendInner(inner.poly);
        }

        private void appendInner(Path2D.Double inner) {
            this.poly.append(inner.getPathIterator(null), false);
        }

        public Path2D.Double get() {
            return this.poly;
        }

        public Rectangle2D getBounds() {
            if (this.bounds == null) {
                this.bounds = this.poly.getBounds2D();
            }
            return this.bounds;
        }

        public List<PolyData> getInners() {
            return Collections.unmodifiableList(this.inners);
        }

        private void resetNodes(DataSet dataSet) {
            if (!this.nodes.isEmpty()) {
                DataSet ds = dataSet;
                Iterator it = this.nodes.iterator();
                while (it.hasNext() && ds == null) {
                    ds = ((Node)it.next()).getDataSet();
                }
                this.nodes.clear();
                if (ds == null) {
                    Logging.warn("DataSet not found while resetting nodes in Multipolygon. This should not happen, you may report it to JOSM developers.");
                } else if (this.wayIds.size() == 1) {
                    Way w = (Way)ds.getPrimitiveById((Long)this.wayIds.iterator().next(), OsmPrimitiveType.WAY);
                    this.nodes.addAll(w.getNodes());
                } else if (!this.wayIds.isEmpty()) {
                    ArrayList<Way> waysToJoin = new ArrayList<Way>();
                    for (Long wayId : this.wayIds) {
                        Way w = (Way)ds.getPrimitiveById(wayId, OsmPrimitiveType.WAY);
                        if (w == null || w.isEmpty()) continue;
                        waysToJoin.add(w);
                    }
                    if (!waysToJoin.isEmpty()) {
                        this.nodes.addAll(Multipolygon.joinWays(waysToJoin).iterator().next().getNodes());
                    }
                }
                this.resetPoly();
            }
        }

        private void resetPoly() {
            this.poly.reset();
            this.buildPoly();
            this.bounds = null;
        }

        public void nodeMoved(NodeMovedEvent event) {
            Node n = event.getNode();
            boolean innerChanged = false;
            for (PolyData inner : this.inners) {
                if (!inner.nodes.contains(n)) continue;
                inner.resetPoly();
                innerChanged = true;
            }
            if (this.nodes.contains(n) || innerChanged) {
                this.resetPoly();
            }
        }

        public void wayNodesChanged(WayNodesChangedEvent event) {
            Long wayId = event.getChangedWay().getUniqueId();
            boolean innerChanged = false;
            for (PolyData inner : this.inners) {
                if (!inner.wayIds.contains(wayId)) continue;
                inner.resetNodes(event.getDataset());
                innerChanged = true;
            }
            if (this.wayIds.contains(wayId) || innerChanged) {
                this.resetNodes(event.getDataset());
            }
        }

        @Override
        public boolean isClosed() {
            if (this.nodes.size() < 3 || !this.getFirstNode().equals(this.getLastNode())) {
                return false;
            }
            return this.inners.stream().allMatch(PolyData::isClosed);
        }

        public Geometry.AreaAndPerimeter getAreaAndPerimeter(Projection projection) {
            Geometry.AreaAndPerimeter ap = Geometry.getAreaAndPerimeter(this.nodes, projection);
            double area = ap.getArea();
            double perimeter = ap.getPerimeter();
            for (PolyData inner : this.inners) {
                Geometry.AreaAndPerimeter apInner = inner.getAreaAndPerimeter(projection);
                area -= apInner.getArea();
                perimeter += apInner.getPerimeter();
            }
            return new Geometry.AreaAndPerimeter(area, perimeter);
        }

        public static enum Intersection {
            INSIDE,
            OUTSIDE,
            CROSSING;

        }
    }

    public static class JoinedWay {
        protected final List<Node> nodes;
        protected final Collection<Long> wayIds;
        protected boolean selected;

        public JoinedWay(List<Node> nodes, Collection<Long> wayIds, boolean selected) {
            this.nodes = new ArrayList<Node>(nodes);
            int size = wayIds.size();
            this.wayIds = size == 1 ? Collections.singleton(wayIds.iterator().next()) : (size <= 10 ? new ArrayList<Long>(wayIds) : new HashSet<Long>(wayIds));
            this.selected = selected;
        }

        public List<Node> getNodes() {
            return Collections.unmodifiableList(this.nodes);
        }

        public Collection<Long> getWayIds() {
            return Collections.unmodifiableCollection(this.wayIds);
        }

        public final boolean isSelected() {
            return this.selected;
        }

        public final void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean isClosed() {
            return this.nodes.isEmpty() || this.getLastNode().equals(this.getFirstNode());
        }

        public Node getFirstNode() {
            return this.nodes.get(0);
        }

        public Node getLastNode() {
            return this.nodes.get(this.nodes.size() - 1);
        }
    }

    private static final class MultipolygonRoleMatcher
    implements PreferenceChangedListener {
        private final List<String> outerExactRoles = new ArrayList<String>();
        private final List<String> outerRolePrefixes = new ArrayList<String>();
        private final List<String> innerExactRoles = new ArrayList<String>();
        private final List<String> innerRolePrefixes = new ArrayList<String>();

        private MultipolygonRoleMatcher() {
        }

        private void initDefaults() {
            this.outerExactRoles.clear();
            this.outerRolePrefixes.clear();
            this.innerExactRoles.clear();
            this.innerRolePrefixes.clear();
            this.outerExactRoles.add("outer");
            this.innerExactRoles.add("inner");
        }

        private static void setNormalized(Collection<String> literals, List<String> target) {
            target.clear();
            for (String l : literals) {
                if (l == null || target.contains(l = l.trim())) continue;
                target.add(l);
            }
        }

        private void initFromPreferences() {
            this.initDefaults();
            if (Config.getPref() == null) {
                return;
            }
            List<String> literals = Config.getPref().getList(Multipolygon.PREF_KEY_OUTER_ROLES);
            if (!Utils.isEmpty(literals)) {
                MultipolygonRoleMatcher.setNormalized(literals, this.outerExactRoles);
            }
            if (!Utils.isEmpty(literals = Config.getPref().getList(Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES))) {
                MultipolygonRoleMatcher.setNormalized(literals, this.outerRolePrefixes);
            }
            if (!Utils.isEmpty(literals = Config.getPref().getList(Multipolygon.PREF_KEY_INNER_ROLES))) {
                MultipolygonRoleMatcher.setNormalized(literals, this.innerExactRoles);
            }
            if (!Utils.isEmpty(literals = Config.getPref().getList(Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES))) {
                MultipolygonRoleMatcher.setNormalized(literals, this.innerRolePrefixes);
            }
        }

        @Override
        public void preferenceChanged(PreferenceChangeEvent evt) {
            if (Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES.equals(evt.getKey()) || Multipolygon.PREF_KEY_INNER_ROLES.equals(evt.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES.equals(evt.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLES.equals(evt.getKey())) {
                this.initFromPreferences();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isOuterRole(String role) {
            if (role == null) {
                return false;
            }
            if (this.outerExactRoles.stream().anyMatch(role::equals)) return true;
            if (!this.outerRolePrefixes.stream().anyMatch(role::startsWith)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isInnerRole(String role) {
            if (role == null) {
                return false;
            }
            if (this.innerExactRoles.stream().anyMatch(role::equals)) return true;
            if (!this.innerRolePrefixes.stream().anyMatch(role::startsWith)) return false;
            return true;
        }
    }
}

