// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: compute.proto

package compute

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Compute_LaunchSatellite_FullMethodName      = "/api.public.compute.Compute/LaunchSatellite"
	Compute_ListSatellites_FullMethodName       = "/api.public.compute.Compute/ListSatellites"
	Compute_UpdateSatellite_FullMethodName      = "/api.public.compute.Compute/UpdateSatellite"
	Compute_DeleteSatellite_FullMethodName      = "/api.public.compute.Compute/DeleteSatellite"
	Compute_GetSatellite_FullMethodName         = "/api.public.compute.Compute/GetSatellite"
	Compute_RegisterSatellite_FullMethodName    = "/api.public.compute.Compute/RegisterSatellite"
	Compute_DeregisterSatellite_FullMethodName  = "/api.public.compute.Compute/DeregisterSatellite"
	Compute_SatelliteHeartbeat_FullMethodName   = "/api.public.compute.Compute/SatelliteHeartbeat"
	Compute_WakeSatellite_FullMethodName        = "/api.public.compute.Compute/WakeSatellite"
	Compute_SleepSatellite_FullMethodName       = "/api.public.compute.Compute/SleepSatellite"
	Compute_ReserveSatellite_FullMethodName     = "/api.public.compute.Compute/ReserveSatellite"
	Compute_SetGithubToken_FullMethodName       = "/api.public.compute.Compute/SetGithubToken"
	Compute_CreateGHAIntegration_FullMethodName = "/api.public.compute.Compute/CreateGHAIntegration"
	Compute_RemoveGHAIntegration_FullMethodName = "/api.public.compute.Compute/RemoveGHAIntegration"
	Compute_ListGHAIntegrations_FullMethodName  = "/api.public.compute.Compute/ListGHAIntegrations"
	Compute_PickGithubJobs_FullMethodName       = "/api.public.compute.Compute/PickGithubJobs"
	Compute_ConfigureCloud_FullMethodName       = "/api.public.compute.Compute/ConfigureCloud"
	Compute_UseCloud_FullMethodName             = "/api.public.compute.Compute/UseCloud"
	Compute_ListClouds_FullMethodName           = "/api.public.compute.Compute/ListClouds"
	Compute_DeleteCloud_FullMethodName          = "/api.public.compute.Compute/DeleteCloud"
)

// ComputeClient is the client API for Compute service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ComputeClient interface {
	// LaunchSatellite starts a new Earthly Satellite instance on the latest version.
	// The instance can be used by users to build their local, Cloud, or 3rd-party CI builds.
	LaunchSatellite(ctx context.Context, in *LaunchSatelliteRequest, opts ...grpc.CallOption) (*LaunchSatelliteResponse, error)
	// ListSatellites returns a list of Earthly Satellite instances available in the organization.
	ListSatellites(ctx context.Context, in *ListSatellitesRequest, opts ...grpc.CallOption) (*ListSatellitesResponse, error)
	// UpdateSatellite updates a Satellite instance to the latest version.
	// (I.e. the latest AMI we have in AWS).
	// Calling this may result in some down-time on the instance while it updates.
	UpdateSatellite(ctx context.Context, in *UpdateSatelliteRequest, opts ...grpc.CallOption) (*UpdateSatelliteResponse, error)
	// DeleteSatellite decommissions a Satellite instance.
	DeleteSatellite(ctx context.Context, in *DeleteSatelliteRequest, opts ...grpc.CallOption) (*DeleteSatelliteResponse, error)
	// GetSatellite retrieves the details of a particular Satellite instance.
	// Mainly intended for use by Buildkit Proxy when establishing a new connection to an instance.
	GetSatellite(ctx context.Context, in *GetSatelliteRequest, opts ...grpc.CallOption) (*GetSatelliteResponse, error)
	// RegisterSatellite is called by a satellite once it is online and ready to accept builds.
	// The registration contains the satellite's connection info.
	// A registration token is returned, which must be passed-in to other endpoints related to registration,
	// such as DeregisterSatellite and SatelliteHeartbeat.
	RegisterSatellite(ctx context.Context, in *RegisterSatelliteRequest, opts ...grpc.CallOption) (*RegisterSatelliteResponse, error)
	// DeregisterSatellite immediately removes the satellite from the organization.
	DeregisterSatellite(ctx context.Context, in *DeregisterSatelliteRequest, opts ...grpc.CallOption) (*DeregisterSatelliteResponse, error)
	// SatelliteHeartbeat must be called periodically while a satellite is online.
	// The heartbeat request may also contain useful information about the satellite's state,
	// such as its op-load, or (in the future) session history.
	// If the compute service stops receiving heartbeats unexpectedly,
	// the satellite is automatically deregistered.
	SatelliteHeartbeat(ctx context.Context, in *SatelliteHeartbeatRequest, opts ...grpc.CallOption) (*SatelliteHeartbeatResponse, error)
	// WakeSatellite wakes a satellite that is in a sleep state.
	// The response returns a stream that sends updates as the satellite wakes up.
	// For example, the stream may send the following statuses:
	//
	//	SLEEP -> STARTING -> ... -> STARTING -> OPERATIONAL -> EOF
	WakeSatellite(ctx context.Context, in *WakeSatelliteRequest, opts ...grpc.CallOption) (Compute_WakeSatelliteClient, error)
	// SleepSatellite puts a satellite to sleep when it is awake.
	// The response is a stream which looks like the inverse of a WakeSatellite response.
	// Example when satellite is awake:
	//
	//	OPERATIONAL -> STOPPING -> ... -> STOPPING -> SLEEP -> EOF
	//
	// Example when satellite is already asleep:
	//
	//	SLEEP -> EOF
	SleepSatellite(ctx context.Context, in *SleepSatelliteRequest, opts ...grpc.CallOption) (Compute_SleepSatelliteClient, error)
	// ReserveSatellite both wakes the instance (if necessary) and calls reserve on buildkit.
	// It is a streaming call which returns status updates during the wake up process,
	// which can take a few moments. Some examples:
	// When the satellite is already awake, a single event is emitted before closing the stream:
	//
	//	OPERATIONAL -> EOF
	//
	// When the satellite is asleep, several events are emitted in the following sequence:
	//
	//	SLEEP -> STARTING -> ... -> STARTING -> OPERATIONAL -> EOF
	//
	// When the satellite is already being woken up, or launching for the first time:
	//
	//	STARTING -> ... -> STARTING -> OPERATIONAL -> EOF
	//
	// When the satellite is actively being put to sleep and needs to finish that process first:
	//
	//	STOPPING -> ... -> STARTING -> ... -> OPERATIONAL -> EOF
	ReserveSatellite(ctx context.Context, in *ReserveSatelliteRequest, opts ...grpc.CallOption) (Compute_ReserveSatelliteClient, error)
	// Deprecated: Do not use.
	// deprecated. Use CreateGHAIntegration instead.
	SetGithubToken(ctx context.Context, in *SetGithubTokenRequest, opts ...grpc.CallOption) (*SetGithubTokenResponse, error)
	// CreateGHAIntegration creates an integration to enable triggering satellite builds from GHA (GitHub Actions).
	CreateGHAIntegration(ctx context.Context, in *CreateGHAIntegrationRequest, opts ...grpc.CallOption) (*CreateGHAIntegrationResponse, error)
	// RemoveGHAIntegration deletes a GHA integration, previously created via CreateGHAIntegration().
	RemoveGHAIntegration(ctx context.Context, in *RemoveGHAIntegrationRequest, opts ...grpc.CallOption) (*RemoveGHAIntegrationResponse, error)
	// ListGHAIntegrations lists organization GHA integrations.
	ListGHAIntegrations(ctx context.Context, in *ListGHAIntegrationsRequest, opts ...grpc.CallOption) (*ListGHAIntegrationsResponse, error)
	// PickGithubJobs lets satellites retrieve the GHA job information and run a JIT runner
	// Jobs returned are marked as picked, and won't be returned in another request for a limited period of time.
	PickGithubJobs(ctx context.Context, in *PickGithubJobsRequest, opts ...grpc.CallOption) (Compute_PickGithubJobsClient, error)
	// ConfigureCloud sets up (or re-does the setup) for the cloud with the given name. The setup validates we can access
	// the other account, and that the other account has all the pieces we need to manage satellites in it. Not a stream
	// because it should be a couple rather quick API calls on our end.
	ConfigureCloud(ctx context.Context, in *ConfigureCloudRequest, opts ...grpc.CallOption) (*ConfigureCloudResponse, error)
	// UseCloud sets the cloud with the given name as default, assuming it passes validation.
	UseCloud(ctx context.Context, in *UseCloudRequest, opts ...grpc.CallOption) (*UseCloudResponse, error)
	// ListClouds lists all the clouds available. Listing the clouds also checks the status of each cloud.
	ListClouds(ctx context.Context, in *ListCloudsRequest, opts ...grpc.CallOption) (*ListCloudsResponse, error)
	// DeleteCloud removes the named cloud, as long as it has no satellites in it. Not a stream because it should be quick.
	DeleteCloud(ctx context.Context, in *DeleteCloudRequest, opts ...grpc.CallOption) (*DeleteCloudResponse, error)
}

type computeClient struct {
	cc grpc.ClientConnInterface
}

func NewComputeClient(cc grpc.ClientConnInterface) ComputeClient {
	return &computeClient{cc}
}

func (c *computeClient) LaunchSatellite(ctx context.Context, in *LaunchSatelliteRequest, opts ...grpc.CallOption) (*LaunchSatelliteResponse, error) {
	out := new(LaunchSatelliteResponse)
	err := c.cc.Invoke(ctx, Compute_LaunchSatellite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) ListSatellites(ctx context.Context, in *ListSatellitesRequest, opts ...grpc.CallOption) (*ListSatellitesResponse, error) {
	out := new(ListSatellitesResponse)
	err := c.cc.Invoke(ctx, Compute_ListSatellites_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) UpdateSatellite(ctx context.Context, in *UpdateSatelliteRequest, opts ...grpc.CallOption) (*UpdateSatelliteResponse, error) {
	out := new(UpdateSatelliteResponse)
	err := c.cc.Invoke(ctx, Compute_UpdateSatellite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) DeleteSatellite(ctx context.Context, in *DeleteSatelliteRequest, opts ...grpc.CallOption) (*DeleteSatelliteResponse, error) {
	out := new(DeleteSatelliteResponse)
	err := c.cc.Invoke(ctx, Compute_DeleteSatellite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) GetSatellite(ctx context.Context, in *GetSatelliteRequest, opts ...grpc.CallOption) (*GetSatelliteResponse, error) {
	out := new(GetSatelliteResponse)
	err := c.cc.Invoke(ctx, Compute_GetSatellite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) RegisterSatellite(ctx context.Context, in *RegisterSatelliteRequest, opts ...grpc.CallOption) (*RegisterSatelliteResponse, error) {
	out := new(RegisterSatelliteResponse)
	err := c.cc.Invoke(ctx, Compute_RegisterSatellite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) DeregisterSatellite(ctx context.Context, in *DeregisterSatelliteRequest, opts ...grpc.CallOption) (*DeregisterSatelliteResponse, error) {
	out := new(DeregisterSatelliteResponse)
	err := c.cc.Invoke(ctx, Compute_DeregisterSatellite_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) SatelliteHeartbeat(ctx context.Context, in *SatelliteHeartbeatRequest, opts ...grpc.CallOption) (*SatelliteHeartbeatResponse, error) {
	out := new(SatelliteHeartbeatResponse)
	err := c.cc.Invoke(ctx, Compute_SatelliteHeartbeat_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) WakeSatellite(ctx context.Context, in *WakeSatelliteRequest, opts ...grpc.CallOption) (Compute_WakeSatelliteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Compute_ServiceDesc.Streams[0], Compute_WakeSatellite_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &computeWakeSatelliteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Compute_WakeSatelliteClient interface {
	Recv() (*WakeSatelliteResponse, error)
	grpc.ClientStream
}

type computeWakeSatelliteClient struct {
	grpc.ClientStream
}

func (x *computeWakeSatelliteClient) Recv() (*WakeSatelliteResponse, error) {
	m := new(WakeSatelliteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *computeClient) SleepSatellite(ctx context.Context, in *SleepSatelliteRequest, opts ...grpc.CallOption) (Compute_SleepSatelliteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Compute_ServiceDesc.Streams[1], Compute_SleepSatellite_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &computeSleepSatelliteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Compute_SleepSatelliteClient interface {
	Recv() (*SleepSatelliteResponse, error)
	grpc.ClientStream
}

type computeSleepSatelliteClient struct {
	grpc.ClientStream
}

func (x *computeSleepSatelliteClient) Recv() (*SleepSatelliteResponse, error) {
	m := new(SleepSatelliteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *computeClient) ReserveSatellite(ctx context.Context, in *ReserveSatelliteRequest, opts ...grpc.CallOption) (Compute_ReserveSatelliteClient, error) {
	stream, err := c.cc.NewStream(ctx, &Compute_ServiceDesc.Streams[2], Compute_ReserveSatellite_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &computeReserveSatelliteClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Compute_ReserveSatelliteClient interface {
	Recv() (*ReserveSatelliteResponse, error)
	grpc.ClientStream
}

type computeReserveSatelliteClient struct {
	grpc.ClientStream
}

func (x *computeReserveSatelliteClient) Recv() (*ReserveSatelliteResponse, error) {
	m := new(ReserveSatelliteResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Deprecated: Do not use.
func (c *computeClient) SetGithubToken(ctx context.Context, in *SetGithubTokenRequest, opts ...grpc.CallOption) (*SetGithubTokenResponse, error) {
	out := new(SetGithubTokenResponse)
	err := c.cc.Invoke(ctx, Compute_SetGithubToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) CreateGHAIntegration(ctx context.Context, in *CreateGHAIntegrationRequest, opts ...grpc.CallOption) (*CreateGHAIntegrationResponse, error) {
	out := new(CreateGHAIntegrationResponse)
	err := c.cc.Invoke(ctx, Compute_CreateGHAIntegration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) RemoveGHAIntegration(ctx context.Context, in *RemoveGHAIntegrationRequest, opts ...grpc.CallOption) (*RemoveGHAIntegrationResponse, error) {
	out := new(RemoveGHAIntegrationResponse)
	err := c.cc.Invoke(ctx, Compute_RemoveGHAIntegration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) ListGHAIntegrations(ctx context.Context, in *ListGHAIntegrationsRequest, opts ...grpc.CallOption) (*ListGHAIntegrationsResponse, error) {
	out := new(ListGHAIntegrationsResponse)
	err := c.cc.Invoke(ctx, Compute_ListGHAIntegrations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) PickGithubJobs(ctx context.Context, in *PickGithubJobsRequest, opts ...grpc.CallOption) (Compute_PickGithubJobsClient, error) {
	stream, err := c.cc.NewStream(ctx, &Compute_ServiceDesc.Streams[3], Compute_PickGithubJobs_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &computePickGithubJobsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Compute_PickGithubJobsClient interface {
	Recv() (*PickGithubJobsResponse, error)
	grpc.ClientStream
}

type computePickGithubJobsClient struct {
	grpc.ClientStream
}

func (x *computePickGithubJobsClient) Recv() (*PickGithubJobsResponse, error) {
	m := new(PickGithubJobsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *computeClient) ConfigureCloud(ctx context.Context, in *ConfigureCloudRequest, opts ...grpc.CallOption) (*ConfigureCloudResponse, error) {
	out := new(ConfigureCloudResponse)
	err := c.cc.Invoke(ctx, Compute_ConfigureCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) UseCloud(ctx context.Context, in *UseCloudRequest, opts ...grpc.CallOption) (*UseCloudResponse, error) {
	out := new(UseCloudResponse)
	err := c.cc.Invoke(ctx, Compute_UseCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) ListClouds(ctx context.Context, in *ListCloudsRequest, opts ...grpc.CallOption) (*ListCloudsResponse, error) {
	out := new(ListCloudsResponse)
	err := c.cc.Invoke(ctx, Compute_ListClouds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *computeClient) DeleteCloud(ctx context.Context, in *DeleteCloudRequest, opts ...grpc.CallOption) (*DeleteCloudResponse, error) {
	out := new(DeleteCloudResponse)
	err := c.cc.Invoke(ctx, Compute_DeleteCloud_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ComputeServer is the server API for Compute service.
// All implementations must embed UnimplementedComputeServer
// for forward compatibility
type ComputeServer interface {
	// LaunchSatellite starts a new Earthly Satellite instance on the latest version.
	// The instance can be used by users to build their local, Cloud, or 3rd-party CI builds.
	LaunchSatellite(context.Context, *LaunchSatelliteRequest) (*LaunchSatelliteResponse, error)
	// ListSatellites returns a list of Earthly Satellite instances available in the organization.
	ListSatellites(context.Context, *ListSatellitesRequest) (*ListSatellitesResponse, error)
	// UpdateSatellite updates a Satellite instance to the latest version.
	// (I.e. the latest AMI we have in AWS).
	// Calling this may result in some down-time on the instance while it updates.
	UpdateSatellite(context.Context, *UpdateSatelliteRequest) (*UpdateSatelliteResponse, error)
	// DeleteSatellite decommissions a Satellite instance.
	DeleteSatellite(context.Context, *DeleteSatelliteRequest) (*DeleteSatelliteResponse, error)
	// GetSatellite retrieves the details of a particular Satellite instance.
	// Mainly intended for use by Buildkit Proxy when establishing a new connection to an instance.
	GetSatellite(context.Context, *GetSatelliteRequest) (*GetSatelliteResponse, error)
	// RegisterSatellite is called by a satellite once it is online and ready to accept builds.
	// The registration contains the satellite's connection info.
	// A registration token is returned, which must be passed-in to other endpoints related to registration,
	// such as DeregisterSatellite and SatelliteHeartbeat.
	RegisterSatellite(context.Context, *RegisterSatelliteRequest) (*RegisterSatelliteResponse, error)
	// DeregisterSatellite immediately removes the satellite from the organization.
	DeregisterSatellite(context.Context, *DeregisterSatelliteRequest) (*DeregisterSatelliteResponse, error)
	// SatelliteHeartbeat must be called periodically while a satellite is online.
	// The heartbeat request may also contain useful information about the satellite's state,
	// such as its op-load, or (in the future) session history.
	// If the compute service stops receiving heartbeats unexpectedly,
	// the satellite is automatically deregistered.
	SatelliteHeartbeat(context.Context, *SatelliteHeartbeatRequest) (*SatelliteHeartbeatResponse, error)
	// WakeSatellite wakes a satellite that is in a sleep state.
	// The response returns a stream that sends updates as the satellite wakes up.
	// For example, the stream may send the following statuses:
	//
	//	SLEEP -> STARTING -> ... -> STARTING -> OPERATIONAL -> EOF
	WakeSatellite(*WakeSatelliteRequest, Compute_WakeSatelliteServer) error
	// SleepSatellite puts a satellite to sleep when it is awake.
	// The response is a stream which looks like the inverse of a WakeSatellite response.
	// Example when satellite is awake:
	//
	//	OPERATIONAL -> STOPPING -> ... -> STOPPING -> SLEEP -> EOF
	//
	// Example when satellite is already asleep:
	//
	//	SLEEP -> EOF
	SleepSatellite(*SleepSatelliteRequest, Compute_SleepSatelliteServer) error
	// ReserveSatellite both wakes the instance (if necessary) and calls reserve on buildkit.
	// It is a streaming call which returns status updates during the wake up process,
	// which can take a few moments. Some examples:
	// When the satellite is already awake, a single event is emitted before closing the stream:
	//
	//	OPERATIONAL -> EOF
	//
	// When the satellite is asleep, several events are emitted in the following sequence:
	//
	//	SLEEP -> STARTING -> ... -> STARTING -> OPERATIONAL -> EOF
	//
	// When the satellite is already being woken up, or launching for the first time:
	//
	//	STARTING -> ... -> STARTING -> OPERATIONAL -> EOF
	//
	// When the satellite is actively being put to sleep and needs to finish that process first:
	//
	//	STOPPING -> ... -> STARTING -> ... -> OPERATIONAL -> EOF
	ReserveSatellite(*ReserveSatelliteRequest, Compute_ReserveSatelliteServer) error
	// Deprecated: Do not use.
	// deprecated. Use CreateGHAIntegration instead.
	SetGithubToken(context.Context, *SetGithubTokenRequest) (*SetGithubTokenResponse, error)
	// CreateGHAIntegration creates an integration to enable triggering satellite builds from GHA (GitHub Actions).
	CreateGHAIntegration(context.Context, *CreateGHAIntegrationRequest) (*CreateGHAIntegrationResponse, error)
	// RemoveGHAIntegration deletes a GHA integration, previously created via CreateGHAIntegration().
	RemoveGHAIntegration(context.Context, *RemoveGHAIntegrationRequest) (*RemoveGHAIntegrationResponse, error)
	// ListGHAIntegrations lists organization GHA integrations.
	ListGHAIntegrations(context.Context, *ListGHAIntegrationsRequest) (*ListGHAIntegrationsResponse, error)
	// PickGithubJobs lets satellites retrieve the GHA job information and run a JIT runner
	// Jobs returned are marked as picked, and won't be returned in another request for a limited period of time.
	PickGithubJobs(*PickGithubJobsRequest, Compute_PickGithubJobsServer) error
	// ConfigureCloud sets up (or re-does the setup) for the cloud with the given name. The setup validates we can access
	// the other account, and that the other account has all the pieces we need to manage satellites in it. Not a stream
	// because it should be a couple rather quick API calls on our end.
	ConfigureCloud(context.Context, *ConfigureCloudRequest) (*ConfigureCloudResponse, error)
	// UseCloud sets the cloud with the given name as default, assuming it passes validation.
	UseCloud(context.Context, *UseCloudRequest) (*UseCloudResponse, error)
	// ListClouds lists all the clouds available. Listing the clouds also checks the status of each cloud.
	ListClouds(context.Context, *ListCloudsRequest) (*ListCloudsResponse, error)
	// DeleteCloud removes the named cloud, as long as it has no satellites in it. Not a stream because it should be quick.
	DeleteCloud(context.Context, *DeleteCloudRequest) (*DeleteCloudResponse, error)
	mustEmbedUnimplementedComputeServer()
}

// UnimplementedComputeServer must be embedded to have forward compatible implementations.
type UnimplementedComputeServer struct {
}

func (UnimplementedComputeServer) LaunchSatellite(context.Context, *LaunchSatelliteRequest) (*LaunchSatelliteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LaunchSatellite not implemented")
}
func (UnimplementedComputeServer) ListSatellites(context.Context, *ListSatellitesRequest) (*ListSatellitesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSatellites not implemented")
}
func (UnimplementedComputeServer) UpdateSatellite(context.Context, *UpdateSatelliteRequest) (*UpdateSatelliteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSatellite not implemented")
}
func (UnimplementedComputeServer) DeleteSatellite(context.Context, *DeleteSatelliteRequest) (*DeleteSatelliteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSatellite not implemented")
}
func (UnimplementedComputeServer) GetSatellite(context.Context, *GetSatelliteRequest) (*GetSatelliteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSatellite not implemented")
}
func (UnimplementedComputeServer) RegisterSatellite(context.Context, *RegisterSatelliteRequest) (*RegisterSatelliteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterSatellite not implemented")
}
func (UnimplementedComputeServer) DeregisterSatellite(context.Context, *DeregisterSatelliteRequest) (*DeregisterSatelliteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeregisterSatellite not implemented")
}
func (UnimplementedComputeServer) SatelliteHeartbeat(context.Context, *SatelliteHeartbeatRequest) (*SatelliteHeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SatelliteHeartbeat not implemented")
}
func (UnimplementedComputeServer) WakeSatellite(*WakeSatelliteRequest, Compute_WakeSatelliteServer) error {
	return status.Errorf(codes.Unimplemented, "method WakeSatellite not implemented")
}
func (UnimplementedComputeServer) SleepSatellite(*SleepSatelliteRequest, Compute_SleepSatelliteServer) error {
	return status.Errorf(codes.Unimplemented, "method SleepSatellite not implemented")
}
func (UnimplementedComputeServer) ReserveSatellite(*ReserveSatelliteRequest, Compute_ReserveSatelliteServer) error {
	return status.Errorf(codes.Unimplemented, "method ReserveSatellite not implemented")
}
func (UnimplementedComputeServer) SetGithubToken(context.Context, *SetGithubTokenRequest) (*SetGithubTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetGithubToken not implemented")
}
func (UnimplementedComputeServer) CreateGHAIntegration(context.Context, *CreateGHAIntegrationRequest) (*CreateGHAIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGHAIntegration not implemented")
}
func (UnimplementedComputeServer) RemoveGHAIntegration(context.Context, *RemoveGHAIntegrationRequest) (*RemoveGHAIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveGHAIntegration not implemented")
}
func (UnimplementedComputeServer) ListGHAIntegrations(context.Context, *ListGHAIntegrationsRequest) (*ListGHAIntegrationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGHAIntegrations not implemented")
}
func (UnimplementedComputeServer) PickGithubJobs(*PickGithubJobsRequest, Compute_PickGithubJobsServer) error {
	return status.Errorf(codes.Unimplemented, "method PickGithubJobs not implemented")
}
func (UnimplementedComputeServer) ConfigureCloud(context.Context, *ConfigureCloudRequest) (*ConfigureCloudResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureCloud not implemented")
}
func (UnimplementedComputeServer) UseCloud(context.Context, *UseCloudRequest) (*UseCloudResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UseCloud not implemented")
}
func (UnimplementedComputeServer) ListClouds(context.Context, *ListCloudsRequest) (*ListCloudsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClouds not implemented")
}
func (UnimplementedComputeServer) DeleteCloud(context.Context, *DeleteCloudRequest) (*DeleteCloudResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCloud not implemented")
}
func (UnimplementedComputeServer) mustEmbedUnimplementedComputeServer() {}

// UnsafeComputeServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ComputeServer will
// result in compilation errors.
type UnsafeComputeServer interface {
	mustEmbedUnimplementedComputeServer()
}

func RegisterComputeServer(s grpc.ServiceRegistrar, srv ComputeServer) {
	s.RegisterService(&Compute_ServiceDesc, srv)
}

func _Compute_LaunchSatellite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LaunchSatelliteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).LaunchSatellite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_LaunchSatellite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).LaunchSatellite(ctx, req.(*LaunchSatelliteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_ListSatellites_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSatellitesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).ListSatellites(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_ListSatellites_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).ListSatellites(ctx, req.(*ListSatellitesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_UpdateSatellite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSatelliteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).UpdateSatellite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_UpdateSatellite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).UpdateSatellite(ctx, req.(*UpdateSatelliteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_DeleteSatellite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSatelliteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).DeleteSatellite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_DeleteSatellite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).DeleteSatellite(ctx, req.(*DeleteSatelliteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_GetSatellite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSatelliteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).GetSatellite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_GetSatellite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).GetSatellite(ctx, req.(*GetSatelliteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_RegisterSatellite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterSatelliteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).RegisterSatellite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_RegisterSatellite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).RegisterSatellite(ctx, req.(*RegisterSatelliteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_DeregisterSatellite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeregisterSatelliteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).DeregisterSatellite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_DeregisterSatellite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).DeregisterSatellite(ctx, req.(*DeregisterSatelliteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_SatelliteHeartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SatelliteHeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).SatelliteHeartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_SatelliteHeartbeat_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).SatelliteHeartbeat(ctx, req.(*SatelliteHeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_WakeSatellite_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WakeSatelliteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ComputeServer).WakeSatellite(m, &computeWakeSatelliteServer{stream})
}

type Compute_WakeSatelliteServer interface {
	Send(*WakeSatelliteResponse) error
	grpc.ServerStream
}

type computeWakeSatelliteServer struct {
	grpc.ServerStream
}

func (x *computeWakeSatelliteServer) Send(m *WakeSatelliteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Compute_SleepSatellite_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SleepSatelliteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ComputeServer).SleepSatellite(m, &computeSleepSatelliteServer{stream})
}

type Compute_SleepSatelliteServer interface {
	Send(*SleepSatelliteResponse) error
	grpc.ServerStream
}

type computeSleepSatelliteServer struct {
	grpc.ServerStream
}

func (x *computeSleepSatelliteServer) Send(m *SleepSatelliteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Compute_ReserveSatellite_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReserveSatelliteRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ComputeServer).ReserveSatellite(m, &computeReserveSatelliteServer{stream})
}

type Compute_ReserveSatelliteServer interface {
	Send(*ReserveSatelliteResponse) error
	grpc.ServerStream
}

type computeReserveSatelliteServer struct {
	grpc.ServerStream
}

func (x *computeReserveSatelliteServer) Send(m *ReserveSatelliteResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Compute_SetGithubToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetGithubTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).SetGithubToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_SetGithubToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).SetGithubToken(ctx, req.(*SetGithubTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_CreateGHAIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGHAIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).CreateGHAIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_CreateGHAIntegration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).CreateGHAIntegration(ctx, req.(*CreateGHAIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_RemoveGHAIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveGHAIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).RemoveGHAIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_RemoveGHAIntegration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).RemoveGHAIntegration(ctx, req.(*RemoveGHAIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_ListGHAIntegrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGHAIntegrationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).ListGHAIntegrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_ListGHAIntegrations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).ListGHAIntegrations(ctx, req.(*ListGHAIntegrationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_PickGithubJobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(PickGithubJobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ComputeServer).PickGithubJobs(m, &computePickGithubJobsServer{stream})
}

type Compute_PickGithubJobsServer interface {
	Send(*PickGithubJobsResponse) error
	grpc.ServerStream
}

type computePickGithubJobsServer struct {
	grpc.ServerStream
}

func (x *computePickGithubJobsServer) Send(m *PickGithubJobsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Compute_ConfigureCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).ConfigureCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_ConfigureCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).ConfigureCloud(ctx, req.(*ConfigureCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_UseCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UseCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).UseCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_UseCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).UseCloud(ctx, req.(*UseCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_ListClouds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCloudsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).ListClouds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_ListClouds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).ListClouds(ctx, req.(*ListCloudsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Compute_DeleteCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ComputeServer).DeleteCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Compute_DeleteCloud_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ComputeServer).DeleteCloud(ctx, req.(*DeleteCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Compute_ServiceDesc is the grpc.ServiceDesc for Compute service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Compute_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "api.public.compute.Compute",
	HandlerType: (*ComputeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "LaunchSatellite",
			Handler:    _Compute_LaunchSatellite_Handler,
		},
		{
			MethodName: "ListSatellites",
			Handler:    _Compute_ListSatellites_Handler,
		},
		{
			MethodName: "UpdateSatellite",
			Handler:    _Compute_UpdateSatellite_Handler,
		},
		{
			MethodName: "DeleteSatellite",
			Handler:    _Compute_DeleteSatellite_Handler,
		},
		{
			MethodName: "GetSatellite",
			Handler:    _Compute_GetSatellite_Handler,
		},
		{
			MethodName: "RegisterSatellite",
			Handler:    _Compute_RegisterSatellite_Handler,
		},
		{
			MethodName: "DeregisterSatellite",
			Handler:    _Compute_DeregisterSatellite_Handler,
		},
		{
			MethodName: "SatelliteHeartbeat",
			Handler:    _Compute_SatelliteHeartbeat_Handler,
		},
		{
			MethodName: "SetGithubToken",
			Handler:    _Compute_SetGithubToken_Handler,
		},
		{
			MethodName: "CreateGHAIntegration",
			Handler:    _Compute_CreateGHAIntegration_Handler,
		},
		{
			MethodName: "RemoveGHAIntegration",
			Handler:    _Compute_RemoveGHAIntegration_Handler,
		},
		{
			MethodName: "ListGHAIntegrations",
			Handler:    _Compute_ListGHAIntegrations_Handler,
		},
		{
			MethodName: "ConfigureCloud",
			Handler:    _Compute_ConfigureCloud_Handler,
		},
		{
			MethodName: "UseCloud",
			Handler:    _Compute_UseCloud_Handler,
		},
		{
			MethodName: "ListClouds",
			Handler:    _Compute_ListClouds_Handler,
		},
		{
			MethodName: "DeleteCloud",
			Handler:    _Compute_DeleteCloud_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WakeSatellite",
			Handler:       _Compute_WakeSatellite_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "SleepSatellite",
			Handler:       _Compute_SleepSatellite_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ReserveSatellite",
			Handler:       _Compute_ReserveSatellite_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "PickGithubJobs",
			Handler:       _Compute_PickGithubJobs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "compute.proto",
}
