// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/model_service.proto

#include "google/cloud/aiplatform/v1/internal/model_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/model_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<aiplatform_v1::ModelServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<aiplatform_v1::ModelServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<aiplatform_v1::ModelServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<aiplatform_v1::ModelServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<aiplatform_v1::ModelServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<aiplatform_v1::ModelServicePollingPolicyOption>()->clone();
}

}  // namespace

ModelServiceConnectionImpl::ModelServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<aiplatform_v1_internal::ModelServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      ModelServiceConnection::options())) {}

future<StatusOr<google::cloud::aiplatform::v1::UploadModelResponse>>
ModelServiceConnectionImpl::UploadModel(
    google::cloud::aiplatform::v1::UploadModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::UploadModelResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::UploadModelRequest const& request) {
        return stub->AsyncUploadModel(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::UploadModelResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UploadModel(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceConnectionImpl::GetModel(
    google::cloud::aiplatform::v1::GetModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetModel(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::GetModelRequest const& request) {
        return stub_->GetModel(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::Model>
ModelServiceConnectionImpl::ListModels(
    google::cloud::aiplatform::v1::ListModelsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListModels(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Model>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::ModelServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListModelsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::ListModelsRequest const&
                       request) { return stub->ListModels(context, request); },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListModelsResponse r) {
        std::vector<google::cloud::aiplatform::v1::Model> result(
            r.models().size());
        auto& messages = *r.mutable_models();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::aiplatform::v1::Model>
ModelServiceConnectionImpl::ListModelVersions(
    google::cloud::aiplatform::v1::ListModelVersionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListModelVersions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Model>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::ModelServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListModelVersionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::aiplatform::v1::ListModelVersionsRequest const&
                    request) {
              return stub->ListModelVersions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListModelVersionsResponse r) {
        std::vector<google::cloud::aiplatform::v1::Model> result(
            r.models().size());
        auto& messages = *r.mutable_models();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceConnectionImpl::UpdateModel(
    google::cloud::aiplatform::v1::UpdateModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateModel(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::UpdateModelRequest const& request) {
        return stub_->UpdateModel(context, request);
      },
      request, __func__);
}

future<
    StatusOr<google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>>
ModelServiceConnectionImpl::UpdateExplanationDataset(
    google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&
              request) {
        return stub->AsyncUpdateExplanationDataset(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateExplanationDataset(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceConnectionImpl::DeleteModel(
    google::cloud::aiplatform::v1::DeleteModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeleteModelRequest const& request) {
        return stub->AsyncDeleteModel(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteModel(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceConnectionImpl::DeleteModelVersion(
    google::cloud::aiplatform::v1::DeleteModelVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::DeleteOperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::DeleteModelVersionRequest const&
              request) {
        return stub->AsyncDeleteModelVersion(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::aiplatform::v1::DeleteOperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteModelVersion(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceConnectionImpl::MergeVersionAliases(
    google::cloud::aiplatform::v1::MergeVersionAliasesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->MergeVersionAliases(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::MergeVersionAliasesRequest const&
                 request) {
        return stub_->MergeVersionAliases(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::ExportModelResponse>>
ModelServiceConnectionImpl::ExportModel(
    google::cloud::aiplatform::v1::ExportModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::ExportModelResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::ExportModelRequest const& request) {
        return stub->AsyncExportModel(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::ExportModelResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExportModel(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::aiplatform::v1::CopyModelResponse>>
ModelServiceConnectionImpl::CopyModel(
    google::cloud::aiplatform::v1::CopyModelRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::aiplatform::v1::CopyModelResponse>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::aiplatform::v1::CopyModelRequest const& request) {
        return stub->AsyncCopyModel(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::aiplatform::v1::CopyModelResponse>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CopyModel(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceConnectionImpl::ImportModelEvaluation(
    google::cloud::aiplatform::v1::ImportModelEvaluationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ImportModelEvaluation(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::ImportModelEvaluationRequest const&
                 request) {
        return stub_->ImportModelEvaluation(context, request);
      },
      request, __func__);
}

StatusOr<
    google::cloud::aiplatform::v1::BatchImportModelEvaluationSlicesResponse>
ModelServiceConnectionImpl::BatchImportModelEvaluationSlices(
    google::cloud::aiplatform::v1::
        BatchImportModelEvaluationSlicesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchImportModelEvaluationSlices(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::
                 BatchImportModelEvaluationSlicesRequest const& request) {
        return stub_->BatchImportModelEvaluationSlices(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::BatchImportEvaluatedAnnotationsResponse>
ModelServiceConnectionImpl::BatchImportEvaluatedAnnotations(
    google::cloud::aiplatform::v1::BatchImportEvaluatedAnnotationsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchImportEvaluatedAnnotations(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::
                 BatchImportEvaluatedAnnotationsRequest const& request) {
        return stub_->BatchImportEvaluatedAnnotations(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceConnectionImpl::GetModelEvaluation(
    google::cloud::aiplatform::v1::GetModelEvaluationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetModelEvaluation(request),
      [this](grpc::ClientContext& context,
             google::cloud::aiplatform::v1::GetModelEvaluationRequest const&
                 request) {
        return stub_->GetModelEvaluation(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceConnectionImpl::ListModelEvaluations(
    google::cloud::aiplatform::v1::ListModelEvaluationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListModelEvaluations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::ModelEvaluation>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::ModelServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListModelEvaluationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::
                       ListModelEvaluationsRequest const& request) {
              return stub->ListModelEvaluations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListModelEvaluationsResponse r) {
        std::vector<google::cloud::aiplatform::v1::ModelEvaluation> result(
            r.model_evaluations().size());
        auto& messages = *r.mutable_model_evaluations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluationSlice>
ModelServiceConnectionImpl::GetModelEvaluationSlice(
    google::cloud::aiplatform::v1::GetModelEvaluationSliceRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetModelEvaluationSlice(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::aiplatform::v1::GetModelEvaluationSliceRequest const&
              request) {
        return stub_->GetModelEvaluationSlice(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::aiplatform::v1::ModelEvaluationSlice>
ModelServiceConnectionImpl::ListModelEvaluationSlices(
    google::cloud::aiplatform::v1::ListModelEvaluationSlicesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListModelEvaluationSlices(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::aiplatform::v1::ModelEvaluationSlice>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<aiplatform_v1::ModelServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::aiplatform::v1::ListModelEvaluationSlicesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::aiplatform::v1::
                       ListModelEvaluationSlicesRequest const& request) {
              return stub->ListModelEvaluationSlices(context, request);
            },
            r, function_name);
      },
      [](google::cloud::aiplatform::v1::ListModelEvaluationSlicesResponse r) {
        std::vector<google::cloud::aiplatform::v1::ModelEvaluationSlice> result(
            r.model_evaluation_slices().size());
        auto& messages = *r.mutable_model_evaluation_slices();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
