// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#include "google/cloud/bigquery/biglake/v1/metastore_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetastoreServiceClient::MetastoreServiceClient(
    std::shared_ptr<MetastoreServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
MetastoreServiceClient::~MetastoreServiceClient() = default;

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::CreateCatalog(
    std::string const& parent,
    google::cloud::bigquery::biglake::v1::Catalog const& catalog,
    std::string const& catalog_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::CreateCatalogRequest request;
  request.set_parent(parent);
  *request.mutable_catalog() = catalog;
  request.set_catalog_id(catalog_id);
  return connection_->CreateCatalog(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::CreateCatalog(
    google::cloud::bigquery::biglake::v1::CreateCatalogRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCatalog(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::DeleteCatalog(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::DeleteCatalogRequest request;
  request.set_name(name);
  return connection_->DeleteCatalog(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::DeleteCatalog(
    google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCatalog(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::GetCatalog(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::GetCatalogRequest request;
  request.set_name(name);
  return connection_->GetCatalog(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::GetCatalog(
    google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCatalog(request);
}

StreamRange<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::ListCatalogs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::ListCatalogsRequest request;
  request.set_parent(parent);
  return connection_->ListCatalogs(request);
}

StreamRange<google::cloud::bigquery::biglake::v1::Catalog>
MetastoreServiceClient::ListCatalogs(
    google::cloud::bigquery::biglake::v1::ListCatalogsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCatalogs(std::move(request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::CreateDatabase(
    std::string const& parent,
    google::cloud::bigquery::biglake::v1::Database const& database,
    std::string const& database_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::CreateDatabaseRequest request;
  request.set_parent(parent);
  *request.mutable_database() = database;
  request.set_database_id(database_id);
  return connection_->CreateDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::CreateDatabase(
    google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::DeleteDatabase(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest request;
  request.set_name(name);
  return connection_->DeleteDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::DeleteDatabase(
    google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::UpdateDatabase(
    google::cloud::bigquery::biglake::v1::Database const& database,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest request;
  *request.mutable_database() = database;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::UpdateDatabase(
    google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::GetDatabase(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::GetDatabaseRequest request;
  request.set_name(name);
  return connection_->GetDatabase(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::GetDatabase(
    google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDatabase(request);
}

StreamRange<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::ListDatabases(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::ListDatabasesRequest request;
  request.set_parent(parent);
  return connection_->ListDatabases(request);
}

StreamRange<google::cloud::bigquery::biglake::v1::Database>
MetastoreServiceClient::ListDatabases(
    google::cloud::bigquery::biglake::v1::ListDatabasesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDatabases(std::move(request));
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::CreateTable(
    std::string const& parent,
    google::cloud::bigquery::biglake::v1::Table const& table,
    std::string const& table_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::CreateTableRequest request;
  request.set_parent(parent);
  *request.mutable_table() = table;
  request.set_table_id(table_id);
  return connection_->CreateTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::CreateTable(
    google::cloud::bigquery::biglake::v1::CreateTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::DeleteTable(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::DeleteTableRequest request;
  request.set_name(name);
  return connection_->DeleteTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::DeleteTable(
    google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::UpdateTable(
    google::cloud::bigquery::biglake::v1::Table const& table,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::UpdateTableRequest request;
  *request.mutable_table() = table;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::UpdateTable(
    google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::RenameTable(std::string const& name,
                                    std::string const& new_name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::RenameTableRequest request;
  request.set_name(name);
  request.set_new_name(new_name);
  return connection_->RenameTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::RenameTable(
    google::cloud::bigquery::biglake::v1::RenameTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RenameTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::GetTable(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::GetTableRequest request;
  request.set_name(name);
  return connection_->GetTable(request);
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::GetTable(
    google::cloud::bigquery::biglake::v1::GetTableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTable(request);
}

StreamRange<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::ListTables(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::bigquery::biglake::v1::ListTablesRequest request;
  request.set_parent(parent);
  return connection_->ListTables(request);
}

StreamRange<google::cloud::bigquery::biglake::v1::Table>
MetastoreServiceClient::ListTables(
    google::cloud::bigquery::biglake::v1::ListTablesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTables(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1
}  // namespace cloud
}  // namespace google
