// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

#include "google/cloud/bigquery/datatransfer/v1/internal/data_transfer_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/datatransfer/v1/datatransfer.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_datatransfer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataTransferServiceStub::~DataTransferServiceStub() = default;

StatusOr<google::cloud::bigquery::datatransfer::v1::DataSource>
DefaultDataTransferServiceStub::GetDataSource(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::GetDataSourceRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::DataSource response;
  auto status = grpc_stub_->GetDataSource(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::ListDataSourcesResponse>
DefaultDataTransferServiceStub::ListDataSources(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::ListDataSourcesRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::ListDataSourcesResponse response;
  auto status = grpc_stub_->ListDataSources(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DefaultDataTransferServiceStub::CreateTransferConfig(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::
        CreateTransferConfigRequest const& request) {
  google::cloud::bigquery::datatransfer::v1::TransferConfig response;
  auto status = grpc_stub_->CreateTransferConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DefaultDataTransferServiceStub::UpdateTransferConfig(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::
        UpdateTransferConfigRequest const& request) {
  google::cloud::bigquery::datatransfer::v1::TransferConfig response;
  auto status = grpc_stub_->UpdateTransferConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDataTransferServiceStub::DeleteTransferConfig(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::
        DeleteTransferConfigRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteTransferConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
DefaultDataTransferServiceStub::GetTransferConfig(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::GetTransferConfigRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::TransferConfig response;
  auto status = grpc_stub_->GetTransferConfig(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::ListTransferConfigsResponse>
DefaultDataTransferServiceStub::ListTransferConfigs(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::ListTransferConfigsRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::ListTransferConfigsResponse
      response;
  auto status = grpc_stub_->ListTransferConfigs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::bigquery::datatransfer::v1::ScheduleTransferRunsResponse>
DefaultDataTransferServiceStub::ScheduleTransferRuns(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::
        ScheduleTransferRunsRequest const& request) {
  google::cloud::bigquery::datatransfer::v1::ScheduleTransferRunsResponse
      response;
  auto status = grpc_stub_->ScheduleTransferRuns(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::bigquery::datatransfer::v1::StartManualTransferRunsResponse>
DefaultDataTransferServiceStub::StartManualTransferRuns(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::
        StartManualTransferRunsRequest const& request) {
  google::cloud::bigquery::datatransfer::v1::StartManualTransferRunsResponse
      response;
  auto status =
      grpc_stub_->StartManualTransferRuns(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::TransferRun>
DefaultDataTransferServiceStub::GetTransferRun(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::GetTransferRunRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::TransferRun response;
  auto status = grpc_stub_->GetTransferRun(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDataTransferServiceStub::DeleteTransferRun(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::DeleteTransferRunRequest const&
        request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteTransferRun(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::bigquery::datatransfer::v1::ListTransferRunsResponse>
DefaultDataTransferServiceStub::ListTransferRuns(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::ListTransferRunsRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::ListTransferRunsResponse response;
  auto status = grpc_stub_->ListTransferRuns(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::ListTransferLogsResponse>
DefaultDataTransferServiceStub::ListTransferLogs(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::ListTransferLogsRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::ListTransferLogsResponse response;
  auto status = grpc_stub_->ListTransferLogs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::datatransfer::v1::CheckValidCredsResponse>
DefaultDataTransferServiceStub::CheckValidCreds(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::CheckValidCredsRequest const&
        request) {
  google::cloud::bigquery::datatransfer::v1::CheckValidCredsResponse response;
  auto status = grpc_stub_->CheckValidCreds(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultDataTransferServiceStub::EnrollDataSources(
    grpc::ClientContext& context,
    google::cloud::bigquery::datatransfer::v1::EnrollDataSourcesRequest const&
        request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->EnrollDataSources(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_datatransfer_v1_internal
}  // namespace cloud
}  // namespace google
