// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/storage/v1/storage.proto

#include "google/cloud/bigquery/storage/v1/internal/bigquery_write_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_storage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BigQueryWriteTracingConnection::BigQueryWriteTracingConnection(
    std::shared_ptr<bigquery_storage_v1::BigQueryWriteConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::bigquery::storage::v1::WriteStream>
BigQueryWriteTracingConnection::CreateWriteStream(
    google::cloud::bigquery::storage::v1::CreateWriteStreamRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryWriteConnection::CreateWriteStream");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateWriteStream(request));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::bigquery::storage::v1::AppendRowsRequest,
    google::cloud::bigquery::storage::v1::AppendRowsResponse>>
BigQueryWriteTracingConnection::AsyncAppendRows() {
  return child_->AsyncAppendRows();
}

StatusOr<google::cloud::bigquery::storage::v1::WriteStream>
BigQueryWriteTracingConnection::GetWriteStream(
    google::cloud::bigquery::storage::v1::GetWriteStreamRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryWriteConnection::GetWriteStream");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWriteStream(request));
}

StatusOr<google::cloud::bigquery::storage::v1::FinalizeWriteStreamResponse>
BigQueryWriteTracingConnection::FinalizeWriteStream(
    google::cloud::bigquery::storage::v1::FinalizeWriteStreamRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryWriteConnection::FinalizeWriteStream");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FinalizeWriteStream(request));
}

StatusOr<google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsResponse>
BigQueryWriteTracingConnection::BatchCommitWriteStreams(
    google::cloud::bigquery::storage::v1::BatchCommitWriteStreamsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryWriteConnection::BatchCommitWriteStreams");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BatchCommitWriteStreams(request));
}

StatusOr<google::cloud::bigquery::storage::v1::FlushRowsResponse>
BigQueryWriteTracingConnection::FlushRows(
    google::cloud::bigquery::storage::v1::FlushRowsRequest const& request) {
  auto span = internal::MakeSpan(
      "bigquery_storage_v1::BigQueryWriteConnection::FlushRows");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FlushRows(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<bigquery_storage_v1::BigQueryWriteConnection>
MakeBigQueryWriteTracingConnection(
    std::shared_ptr<bigquery_storage_v1::BigQueryWriteConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<BigQueryWriteTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_storage_v1_internal
}  // namespace cloud
}  // namespace google
