// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/binaryauthorization/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_V1_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_V1_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_H

#include "google/cloud/binaryauthorization/v1/binauthz_management_service_v1_connection_idempotency_policy.h"
#include "google/cloud/binaryauthorization/v1/internal/binauthz_management_service_v1_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/binaryauthorization/v1/service.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace binaryauthorization_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `BinauthzManagementServiceV1Connection`.
class BinauthzManagementServiceV1RetryPolicy
    : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<BinauthzManagementServiceV1RetryPolicy> clone()
      const = 0;
};

/**
 * A retry policy for `BinauthzManagementServiceV1Connection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class BinauthzManagementServiceV1LimitedErrorCountRetryPolicy
    : public BinauthzManagementServiceV1RetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit BinauthzManagementServiceV1LimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  BinauthzManagementServiceV1LimitedErrorCountRetryPolicy(
      BinauthzManagementServiceV1LimitedErrorCountRetryPolicy&& rhs) noexcept
      : BinauthzManagementServiceV1LimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  BinauthzManagementServiceV1LimitedErrorCountRetryPolicy(
      BinauthzManagementServiceV1LimitedErrorCountRetryPolicy const&
          rhs) noexcept
      : BinauthzManagementServiceV1LimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<BinauthzManagementServiceV1RetryPolicy> clone()
      const override {
    return std::make_unique<
        BinauthzManagementServiceV1LimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = BinauthzManagementServiceV1RetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      binaryauthorization_v1_internal::BinauthzManagementServiceV1RetryTraits>
      impl_;
};

/**
 * A retry policy for `BinauthzManagementServiceV1Connection` based on elapsed
 * time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class BinauthzManagementServiceV1LimitedTimeRetryPolicy
    : public BinauthzManagementServiceV1RetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit BinauthzManagementServiceV1LimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  BinauthzManagementServiceV1LimitedTimeRetryPolicy(
      BinauthzManagementServiceV1LimitedTimeRetryPolicy&& rhs) noexcept
      : BinauthzManagementServiceV1LimitedTimeRetryPolicy(
            rhs.maximum_duration()) {}
  BinauthzManagementServiceV1LimitedTimeRetryPolicy(
      BinauthzManagementServiceV1LimitedTimeRetryPolicy const& rhs) noexcept
      : BinauthzManagementServiceV1LimitedTimeRetryPolicy(
            rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<BinauthzManagementServiceV1RetryPolicy> clone()
      const override {
    return std::make_unique<BinauthzManagementServiceV1LimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = BinauthzManagementServiceV1RetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      binaryauthorization_v1_internal::BinauthzManagementServiceV1RetryTraits>
      impl_;
};

/**
 * The `BinauthzManagementServiceV1Connection` object for
 * `BinauthzManagementServiceV1Client`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `BinauthzManagementServiceV1Client`. This allows users to inject
 * custom behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `BinauthzManagementServiceV1Client`.
 *
 * To create a concrete instance, see
 * `MakeBinauthzManagementServiceV1Connection()`.
 *
 * For mocking, see
 * `binaryauthorization_v1_mocks::MockBinauthzManagementServiceV1Connection`.
 */
class BinauthzManagementServiceV1Connection {
 public:
  virtual ~BinauthzManagementServiceV1Connection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::binaryauthorization::v1::Policy> GetPolicy(
      google::cloud::binaryauthorization::v1::GetPolicyRequest const& request);

  virtual StatusOr<google::cloud::binaryauthorization::v1::Policy> UpdatePolicy(
      google::cloud::binaryauthorization::v1::UpdatePolicyRequest const&
          request);

  virtual StatusOr<google::cloud::binaryauthorization::v1::Attestor>
  CreateAttestor(
      google::cloud::binaryauthorization::v1::CreateAttestorRequest const&
          request);

  virtual StatusOr<google::cloud::binaryauthorization::v1::Attestor>
  GetAttestor(google::cloud::binaryauthorization::v1::GetAttestorRequest const&
                  request);

  virtual StatusOr<google::cloud::binaryauthorization::v1::Attestor>
  UpdateAttestor(
      google::cloud::binaryauthorization::v1::UpdateAttestorRequest const&
          request);

  virtual StreamRange<google::cloud::binaryauthorization::v1::Attestor>
  ListAttestors(
      google::cloud::binaryauthorization::v1::ListAttestorsRequest request);

  virtual Status DeleteAttestor(
      google::cloud::binaryauthorization::v1::DeleteAttestorRequest const&
          request);
};

/**
 * A factory function to construct an object of type
 * `BinauthzManagementServiceV1Connection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * BinauthzManagementServiceV1Client.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `BinauthzManagementServiceV1Connection`. Expected options are any of
 * the types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * -
 * `google::cloud::binaryauthorization_v1::BinauthzManagementServiceV1PolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the
 * `BinauthzManagementServiceV1Connection` created by this function.
 */
std::shared_ptr<BinauthzManagementServiceV1Connection>
MakeBinauthzManagementServiceV1Connection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace binaryauthorization_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BINARYAUTHORIZATION_V1_BINAUTHZ_MANAGEMENT_SERVICE_V1_CONNECTION_H
