// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/backend_buckets/v1/backend_buckets.proto

#include "google/cloud/compute/backend_buckets/v1/backend_buckets_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_backend_buckets_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

BackendBucketsConnectionIdempotencyPolicy::
    ~BackendBucketsConnectionIdempotencyPolicy() = default;

std::unique_ptr<BackendBucketsConnectionIdempotencyPolicy>
BackendBucketsConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<BackendBucketsConnectionIdempotencyPolicy>(*this);
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::AddSignedUrlKey(
    google::cloud::cpp::compute::backend_buckets::v1::
        AddSignedUrlKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::DeleteBackendBucket(
    google::cloud::cpp::compute::backend_buckets::v1::
        DeleteBackendBucketRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::DeleteSignedUrlKey(
    google::cloud::cpp::compute::backend_buckets::v1::
        DeleteSignedUrlKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::GetBackendBucket(
    google::cloud::cpp::compute::backend_buckets::v1::
        GetBackendBucketRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::GetIamPolicy(
    google::cloud::cpp::compute::backend_buckets::v1::
        GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::InsertBackendBucket(
    google::cloud::cpp::compute::backend_buckets::v1::
        InsertBackendBucketRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::ListBackendBuckets(
    google::cloud::cpp::compute::backend_buckets::v1::
        ListBackendBucketsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::PatchBackendBucket(
    google::cloud::cpp::compute::backend_buckets::v1::
        PatchBackendBucketRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::SetEdgeSecurityPolicy(
    google::cloud::cpp::compute::backend_buckets::v1::
        SetEdgeSecurityPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::SetIamPolicy(
    google::cloud::cpp::compute::backend_buckets::v1::
        SetIamPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::TestIamPermissions(
    google::cloud::cpp::compute::backend_buckets::v1::
        TestIamPermissionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency BackendBucketsConnectionIdempotencyPolicy::UpdateBackendBucket(
    google::cloud::cpp::compute::backend_buckets::v1::
        UpdateBackendBucketRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<BackendBucketsConnectionIdempotencyPolicy>
MakeDefaultBackendBucketsConnectionIdempotencyPolicy() {
  return std::make_unique<BackendBucketsConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_backend_buckets_v1
}  // namespace cloud
}  // namespace google
