// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/snapshots/v1/snapshots.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SNAPSHOTS_V1_INTERNAL_SNAPSHOTS_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SNAPSHOTS_V1_INTERNAL_SNAPSHOTS_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/snapshots/v1/internal/snapshots_rest_stub.h"
#include "google/cloud/compute/snapshots/v1/internal/snapshots_retry_traits.h"
#include "google/cloud/compute/snapshots/v1/snapshots_connection.h"
#include "google/cloud/compute/snapshots/v1/snapshots_connection_idempotency_policy.h"
#include "google/cloud/compute/snapshots/v1/snapshots_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_snapshots_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SnapshotsRestConnectionImpl
    : public compute_snapshots_v1::SnapshotsConnection {
 public:
  ~SnapshotsRestConnectionImpl() override = default;

  SnapshotsRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<compute_snapshots_v1_internal::SnapshotsRestStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> DeleteSnapshot(
      google::cloud::cpp::compute::snapshots::v1::DeleteSnapshotRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Snapshot> GetSnapshot(
      google::cloud::cpp::compute::snapshots::v1::GetSnapshotRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> GetIamPolicy(
      google::cloud::cpp::compute::snapshots::v1::GetIamPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> InsertSnapshot(
      google::cloud::cpp::compute::snapshots::v1::InsertSnapshotRequest const&
          request) override;

  StreamRange<google::cloud::cpp::compute::v1::Snapshot> ListSnapshots(
      google::cloud::cpp::compute::snapshots::v1::ListSnapshotsRequest request)
      override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> SetIamPolicy(
      google::cloud::cpp::compute::snapshots::v1::SetIamPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetLabels(
      google::cloud::cpp::compute::snapshots::v1::SetLabelsRequest const&
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::snapshots::v1::
                         TestIamPermissionsRequest const& request) override;

 private:
  static std::unique_ptr<compute_snapshots_v1::SnapshotsRetryPolicy>
  retry_policy(Options const& options) {
    return options.get<compute_snapshots_v1::SnapshotsRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options.get<compute_snapshots_v1::SnapshotsBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      compute_snapshots_v1::SnapshotsConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_snapshots_v1::SnapshotsConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options.get<compute_snapshots_v1::SnapshotsPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<compute_snapshots_v1_internal::SnapshotsRestStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_snapshots_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SNAPSHOTS_V1_INTERNAL_SNAPSHOTS_REST_CONNECTION_IMPL_H
