// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/target_http_proxies/v1/target_http_proxies.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_HTTP_PROXIES_V1_INTERNAL_TARGET_HTTP_PROXIES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_HTTP_PROXIES_V1_INTERNAL_TARGET_HTTP_PROXIES_TRACING_CONNECTION_H

#include "google/cloud/compute/target_http_proxies/v1/target_http_proxies_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_target_http_proxies_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class TargetHttpProxiesTracingConnection
    : public compute_target_http_proxies_v1::TargetHttpProxiesConnection {
 public:
  ~TargetHttpProxiesTracingConnection() override = default;

  explicit TargetHttpProxiesTracingConnection(
      std::shared_ptr<
          compute_target_http_proxies_v1::TargetHttpProxiesConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::TargetHttpProxiesScopedList>>
  AggregatedListTargetHttpProxies(
      google::cloud::cpp::compute::target_http_proxies::v1::
          AggregatedListTargetHttpProxiesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteTargetHttpProxy(
      google::cloud::cpp::compute::target_http_proxies::v1::
          DeleteTargetHttpProxyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TargetHttpProxy> GetTargetHttpProxy(
      google::cloud::cpp::compute::target_http_proxies::v1::
          GetTargetHttpProxyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertTargetHttpProxy(
      google::cloud::cpp::compute::target_http_proxies::v1::
          InsertTargetHttpProxyRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::TargetHttpProxy>
  ListTargetHttpProxies(google::cloud::cpp::compute::target_http_proxies::v1::
                            ListTargetHttpProxiesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchTargetHttpProxy(google::cloud::cpp::compute::target_http_proxies::v1::
                           PatchTargetHttpProxyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetUrlMap(
      google::cloud::cpp::compute::target_http_proxies::v1::
          SetUrlMapRequest const& request) override;

 private:
  std::shared_ptr<compute_target_http_proxies_v1::TargetHttpProxiesConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_target_http_proxies_v1::TargetHttpProxiesConnection>
MakeTargetHttpProxiesTracingConnection(
    std::shared_ptr<compute_target_http_proxies_v1::TargetHttpProxiesConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_target_http_proxies_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_TARGET_HTTP_PROXIES_V1_INTERNAL_TARGET_HTTP_PROXIES_TRACING_CONNECTION_H
