// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: grafeas/v1/grafeas.proto

#include "google/cloud/containeranalysis/v1/internal/grafeas_connection_impl.h"
#include "google/cloud/containeranalysis/v1/internal/grafeas_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace containeranalysis_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<containeranalysis_v1::GrafeasRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<containeranalysis_v1::GrafeasRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<containeranalysis_v1::GrafeasBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<containeranalysis_v1::GrafeasConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<containeranalysis_v1::GrafeasConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

GrafeasConnectionImpl::GrafeasConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<containeranalysis_v1_internal::GrafeasStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      GrafeasConnection::options())) {}

StatusOr<grafeas::v1::Occurrence> GrafeasConnectionImpl::GetOccurrence(
    grafeas::v1::GetOccurrenceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOccurrence(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::GetOccurrenceRequest const& request) {
        return stub_->GetOccurrence(context, request);
      },
      request, __func__);
}

StreamRange<grafeas::v1::Occurrence> GrafeasConnectionImpl::ListOccurrences(
    grafeas::v1::ListOccurrencesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOccurrences(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<grafeas::v1::Occurrence>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<containeranalysis_v1::GrafeasRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          grafeas::v1::ListOccurrencesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   grafeas::v1::ListOccurrencesRequest const& request) {
              return stub->ListOccurrences(context, request);
            },
            r, function_name);
      },
      [](grafeas::v1::ListOccurrencesResponse r) {
        std::vector<grafeas::v1::Occurrence> result(r.occurrences().size());
        auto& messages = *r.mutable_occurrences();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status GrafeasConnectionImpl::DeleteOccurrence(
    grafeas::v1::DeleteOccurrenceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOccurrence(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::DeleteOccurrenceRequest const& request) {
        return stub_->DeleteOccurrence(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::Occurrence> GrafeasConnectionImpl::CreateOccurrence(
    grafeas::v1::CreateOccurrenceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateOccurrence(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::CreateOccurrenceRequest const& request) {
        return stub_->CreateOccurrence(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::BatchCreateOccurrencesResponse>
GrafeasConnectionImpl::BatchCreateOccurrences(
    grafeas::v1::BatchCreateOccurrencesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchCreateOccurrences(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::BatchCreateOccurrencesRequest const& request) {
        return stub_->BatchCreateOccurrences(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::Occurrence> GrafeasConnectionImpl::UpdateOccurrence(
    grafeas::v1::UpdateOccurrenceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateOccurrence(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::UpdateOccurrenceRequest const& request) {
        return stub_->UpdateOccurrence(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::Note> GrafeasConnectionImpl::GetOccurrenceNote(
    grafeas::v1::GetOccurrenceNoteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOccurrenceNote(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::GetOccurrenceNoteRequest const& request) {
        return stub_->GetOccurrenceNote(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::Note> GrafeasConnectionImpl::GetNote(
    grafeas::v1::GetNoteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetNote(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::GetNoteRequest const& request) {
        return stub_->GetNote(context, request);
      },
      request, __func__);
}

StreamRange<grafeas::v1::Note> GrafeasConnectionImpl::ListNotes(
    grafeas::v1::ListNotesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNotes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<grafeas::v1::Note>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<containeranalysis_v1::GrafeasRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          grafeas::v1::ListNotesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   grafeas::v1::ListNotesRequest const& request) {
              return stub->ListNotes(context, request);
            },
            r, function_name);
      },
      [](grafeas::v1::ListNotesResponse r) {
        std::vector<grafeas::v1::Note> result(r.notes().size());
        auto& messages = *r.mutable_notes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status GrafeasConnectionImpl::DeleteNote(
    grafeas::v1::DeleteNoteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteNote(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::DeleteNoteRequest const& request) {
        return stub_->DeleteNote(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::Note> GrafeasConnectionImpl::CreateNote(
    grafeas::v1::CreateNoteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateNote(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::CreateNoteRequest const& request) {
        return stub_->CreateNote(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::BatchCreateNotesResponse>
GrafeasConnectionImpl::BatchCreateNotes(
    grafeas::v1::BatchCreateNotesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchCreateNotes(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::BatchCreateNotesRequest const& request) {
        return stub_->BatchCreateNotes(context, request);
      },
      request, __func__);
}

StatusOr<grafeas::v1::Note> GrafeasConnectionImpl::UpdateNote(
    grafeas::v1::UpdateNoteRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateNote(request),
      [this](grpc::ClientContext& context,
             grafeas::v1::UpdateNoteRequest const& request) {
        return stub_->UpdateNote(context, request);
      },
      request, __func__);
}

StreamRange<grafeas::v1::Occurrence> GrafeasConnectionImpl::ListNoteOccurrences(
    grafeas::v1::ListNoteOccurrencesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListNoteOccurrences(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<grafeas::v1::Occurrence>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<containeranalysis_v1::GrafeasRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          grafeas::v1::ListNoteOccurrencesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   grafeas::v1::ListNoteOccurrencesRequest const& request) {
              return stub->ListNoteOccurrences(context, request);
            },
            r, function_name);
      },
      [](grafeas::v1::ListNoteOccurrencesResponse r) {
        std::vector<grafeas::v1::Occurrence> result(r.occurrences().size());
        auto& messages = *r.mutable_occurrences();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace containeranalysis_v1_internal
}  // namespace cloud
}  // namespace google
