// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/policytagmanager.proto

#include "google/cloud/datacatalog/v1/policy_tag_manager_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyTagManagerClient::PolicyTagManagerClient(
    std::shared_ptr<PolicyTagManagerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
PolicyTagManagerClient::~PolicyTagManagerClient() = default;

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::CreateTaxonomy(
    std::string const& parent,
    google::cloud::datacatalog::v1::Taxonomy const& taxonomy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::CreateTaxonomyRequest request;
  request.set_parent(parent);
  *request.mutable_taxonomy() = taxonomy;
  return connection_->CreateTaxonomy(request);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::CreateTaxonomy(
    google::cloud::datacatalog::v1::CreateTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTaxonomy(request);
}

Status PolicyTagManagerClient::DeleteTaxonomy(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::DeleteTaxonomyRequest request;
  request.set_name(name);
  return connection_->DeleteTaxonomy(request);
}

Status PolicyTagManagerClient::DeleteTaxonomy(
    google::cloud::datacatalog::v1::DeleteTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTaxonomy(request);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::UpdateTaxonomy(
    google::cloud::datacatalog::v1::Taxonomy const& taxonomy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::UpdateTaxonomyRequest request;
  *request.mutable_taxonomy() = taxonomy;
  return connection_->UpdateTaxonomy(request);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::UpdateTaxonomy(
    google::cloud::datacatalog::v1::UpdateTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTaxonomy(request);
}

StreamRange<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::ListTaxonomies(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::ListTaxonomiesRequest request;
  request.set_parent(parent);
  return connection_->ListTaxonomies(request);
}

StreamRange<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::ListTaxonomies(
    google::cloud::datacatalog::v1::ListTaxonomiesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTaxonomies(std::move(request));
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::GetTaxonomy(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::GetTaxonomyRequest request;
  request.set_name(name);
  return connection_->GetTaxonomy(request);
}

StatusOr<google::cloud::datacatalog::v1::Taxonomy>
PolicyTagManagerClient::GetTaxonomy(
    google::cloud::datacatalog::v1::GetTaxonomyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTaxonomy(request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::CreatePolicyTag(
    std::string const& parent,
    google::cloud::datacatalog::v1::PolicyTag const& policy_tag, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::CreatePolicyTagRequest request;
  request.set_parent(parent);
  *request.mutable_policy_tag() = policy_tag;
  return connection_->CreatePolicyTag(request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::CreatePolicyTag(
    google::cloud::datacatalog::v1::CreatePolicyTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePolicyTag(request);
}

Status PolicyTagManagerClient::DeletePolicyTag(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::DeletePolicyTagRequest request;
  request.set_name(name);
  return connection_->DeletePolicyTag(request);
}

Status PolicyTagManagerClient::DeletePolicyTag(
    google::cloud::datacatalog::v1::DeletePolicyTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePolicyTag(request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::UpdatePolicyTag(
    google::cloud::datacatalog::v1::PolicyTag const& policy_tag, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::UpdatePolicyTagRequest request;
  *request.mutable_policy_tag() = policy_tag;
  return connection_->UpdatePolicyTag(request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::UpdatePolicyTag(
    google::cloud::datacatalog::v1::UpdatePolicyTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePolicyTag(request);
}

StreamRange<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::ListPolicyTags(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::ListPolicyTagsRequest request;
  request.set_parent(parent);
  return connection_->ListPolicyTags(request);
}

StreamRange<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::ListPolicyTags(
    google::cloud::datacatalog::v1::ListPolicyTagsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPolicyTags(std::move(request));
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::GetPolicyTag(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::datacatalog::v1::GetPolicyTagRequest request;
  request.set_name(name);
  return connection_->GetPolicyTag(request);
}

StatusOr<google::cloud::datacatalog::v1::PolicyTag>
PolicyTagManagerClient::GetPolicyTag(
    google::cloud::datacatalog::v1::GetPolicyTagRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPolicyTag(request);
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> PolicyTagManagerClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PolicyTagManagerClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1
}  // namespace cloud
}  // namespace google
