// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/security_settings.proto

#include "google/cloud/dialogflow_cx/internal/security_settings_connection_impl.h"
#include "google/cloud/dialogflow_cx/internal/security_settings_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dialogflow_cx::SecuritySettingsServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dialogflow_cx::SecuritySettingsServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<dialogflow_cx::SecuritySettingsServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    dialogflow_cx::SecuritySettingsServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dialogflow_cx::
               SecuritySettingsServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

SecuritySettingsServiceConnectionImpl::SecuritySettingsServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dialogflow_cx_internal::SecuritySettingsServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), SecuritySettingsServiceConnection::options())) {}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceConnectionImpl::CreateSecuritySettings(
    google::cloud::dialogflow::cx::v3::CreateSecuritySettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSecuritySettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::dialogflow::cx::v3::
                 CreateSecuritySettingsRequest const& request) {
        return stub_->CreateSecuritySettings(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceConnectionImpl::GetSecuritySettings(
    google::cloud::dialogflow::cx::v3::GetSecuritySettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSecuritySettings(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::dialogflow::cx::v3::GetSecuritySettingsRequest const&
              request) { return stub_->GetSecuritySettings(context, request); },
      request, __func__);
}

StatusOr<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceConnectionImpl::UpdateSecuritySettings(
    google::cloud::dialogflow::cx::v3::UpdateSecuritySettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSecuritySettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::dialogflow::cx::v3::
                 UpdateSecuritySettingsRequest const& request) {
        return stub_->UpdateSecuritySettings(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dialogflow::cx::v3::SecuritySettings>
SecuritySettingsServiceConnectionImpl::ListSecuritySettings(
    google::cloud::dialogflow::cx::v3::ListSecuritySettingsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListSecuritySettings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dialogflow::cx::v3::SecuritySettings>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry =
           std::shared_ptr<dialogflow_cx::SecuritySettingsServiceRetryPolicy>(
               retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dialogflow::cx::v3::ListSecuritySettingsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dialogflow::cx::v3::
                       ListSecuritySettingsRequest const& request) {
              return stub->ListSecuritySettings(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dialogflow::cx::v3::ListSecuritySettingsResponse r) {
        std::vector<google::cloud::dialogflow::cx::v3::SecuritySettings> result(
            r.security_settings().size());
        auto& messages = *r.mutable_security_settings();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status SecuritySettingsServiceConnectionImpl::DeleteSecuritySettings(
    google::cloud::dialogflow::cx::v3::DeleteSecuritySettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSecuritySettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::dialogflow::cx::v3::
                 DeleteSecuritySettingsRequest const& request) {
        return stub_->DeleteSecuritySettings(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
