// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#include "google/cloud/migrationcenter/v1/internal/migration_center_connection_impl.h"
#include "google/cloud/migrationcenter/v1/internal/migration_center_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace migrationcenter_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<migrationcenter_v1::MigrationCenterRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<migrationcenter_v1::MigrationCenterRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<migrationcenter_v1::MigrationCenterBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<migrationcenter_v1::MigrationCenterConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<migrationcenter_v1::
               MigrationCenterConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<migrationcenter_v1::MigrationCenterPollingPolicyOption>()
      ->clone();
}

}  // namespace

MigrationCenterConnectionImpl::MigrationCenterConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<migrationcenter_v1_internal::MigrationCenterStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      MigrationCenterConnection::options())) {}

StreamRange<google::cloud::migrationcenter::v1::Asset>
MigrationCenterConnectionImpl::ListAssets(
    google::cloud::migrationcenter::v1::ListAssetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::Asset>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::ListAssetsRequest const&
                       request) { return stub->ListAssets(context, request); },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListAssetsResponse r) {
        std::vector<google::cloud::migrationcenter::v1::Asset> result(
            r.assets().size());
        auto& messages = *r.mutable_assets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterConnectionImpl::GetAsset(
    google::cloud::migrationcenter::v1::GetAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAsset(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::migrationcenter::v1::GetAssetRequest const& request) {
        return stub_->GetAsset(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterConnectionImpl::UpdateAsset(
    google::cloud::migrationcenter::v1::UpdateAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAsset(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::UpdateAssetRequest const&
                 request) { return stub_->UpdateAsset(context, request); },
      request, __func__);
}

StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
MigrationCenterConnectionImpl::BatchUpdateAssets(
    google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchUpdateAssets(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
                 request) {
        return stub_->BatchUpdateAssets(context, request);
      },
      request, __func__);
}

Status MigrationCenterConnectionImpl::DeleteAsset(
    google::cloud::migrationcenter::v1::DeleteAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAsset(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::DeleteAssetRequest const&
                 request) { return stub_->DeleteAsset(context, request); },
      request, __func__);
}

Status MigrationCenterConnectionImpl::BatchDeleteAssets(
    google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchDeleteAssets(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
                 request) {
        return stub_->BatchDeleteAssets(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>
MigrationCenterConnectionImpl::ReportAssetFrames(
    google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ReportAssetFrames(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
                 request) {
        return stub_->ReportAssetFrames(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>
MigrationCenterConnectionImpl::AggregateAssetsValues(
    google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AggregateAssetsValues(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::
                 AggregateAssetsValuesRequest const& request) {
        return stub_->AggregateAssetsValues(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterConnectionImpl::CreateImportJob(
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::ImportJob>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreateImportJobRequest const&
              request) {
        return stub->AsyncCreateImportJob(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::ImportJob>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateImportJob(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterConnectionImpl::ListImportJobs(
    google::cloud::migrationcenter::v1::ListImportJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListImportJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::ImportJob>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListImportJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::migrationcenter::v1::ListImportJobsRequest const&
                    request) { return stub->ListImportJobs(context, request); },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListImportJobsResponse r) {
        std::vector<google::cloud::migrationcenter::v1::ImportJob> result(
            r.import_jobs().size());
        auto& messages = *r.mutable_import_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterConnectionImpl::GetImportJob(
    google::cloud::migrationcenter::v1::GetImportJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetImportJob(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::GetImportJobRequest const&
                 request) { return stub_->GetImportJob(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeleteImportJob(
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteImportJobRequest const&
              request) {
        return stub->AsyncDeleteImportJob(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteImportJob(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterConnectionImpl::UpdateImportJob(
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::ImportJob>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::UpdateImportJobRequest const&
              request) {
        return stub->AsyncUpdateImportJob(cq, std::move(context), options,
                                          request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::ImportJob>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateImportJob(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::ValidateImportJob(
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
              request) {
        return stub->AsyncValidateImportJob(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ValidateImportJob(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::RunImportJob(
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::RunImportJobRequest const&
              request) {
        return stub->AsyncRunImportJob(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunImportJob(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterConnectionImpl::GetImportDataFile(
    google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetImportDataFile(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
                 request) {
        return stub_->GetImportDataFile(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterConnectionImpl::ListImportDataFiles(
    google::cloud::migrationcenter::v1::ListImportDataFilesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListImportDataFiles(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListImportDataFilesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::
                       ListImportDataFilesRequest const& request) {
              return stub->ListImportDataFiles(context, request);
            },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListImportDataFilesResponse r) {
        std::vector<google::cloud::migrationcenter::v1::ImportDataFile> result(
            r.import_data_files().size());
        auto& messages = *r.mutable_import_data_files();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
MigrationCenterConnectionImpl::CreateImportDataFile(
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::ImportDataFile>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
              request) {
        return stub->AsyncCreateImportDataFile(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::ImportDataFile>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateImportDataFile(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeleteImportDataFile(
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
              request) {
        return stub->AsyncDeleteImportDataFile(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteImportDataFile(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::migrationcenter::v1::Group>
MigrationCenterConnectionImpl::ListGroups(
    google::cloud::migrationcenter::v1::ListGroupsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListGroups(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::Group>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListGroupsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::ListGroupsRequest const&
                       request) { return stub->ListGroups(context, request); },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListGroupsResponse r) {
        std::vector<google::cloud::migrationcenter::v1::Group> result(
            r.groups().size());
        auto& messages = *r.mutable_groups();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::migrationcenter::v1::Group>
MigrationCenterConnectionImpl::GetGroup(
    google::cloud::migrationcenter::v1::GetGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGroup(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::migrationcenter::v1::GetGroupRequest const& request) {
        return stub_->GetGroup(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterConnectionImpl::CreateGroup(
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Group>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreateGroupRequest const&
              request) {
        return stub->AsyncCreateGroup(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Group>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGroup(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterConnectionImpl::UpdateGroup(
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Group>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::UpdateGroupRequest const&
              request) {
        return stub->AsyncUpdateGroup(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Group>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateGroup(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeleteGroup(
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteGroupRequest const&
              request) {
        return stub->AsyncDeleteGroup(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteGroup(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterConnectionImpl::AddAssetsToGroup(
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Group>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
              request) {
        return stub->AsyncAddAssetsToGroup(cq, std::move(context), options,
                                           request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Group>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->AddAssetsToGroup(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterConnectionImpl::RemoveAssetsFromGroup(
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Group>(
      background_->cq(), current, request,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::cloud::migrationcenter::v1::
                         RemoveAssetsFromGroupRequest const& request) {
        return stub->AsyncRemoveAssetsFromGroup(cq, std::move(context), options,
                                                request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Group>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RemoveAssetsFromGroup(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterConnectionImpl::ListErrorFrames(
    google::cloud::migrationcenter::v1::ListErrorFramesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListErrorFrames(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::ErrorFrame>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListErrorFramesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::
                       ListErrorFramesRequest const& request) {
              return stub->ListErrorFrames(context, request);
            },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListErrorFramesResponse r) {
        std::vector<google::cloud::migrationcenter::v1::ErrorFrame> result(
            r.error_frames().size());
        auto& messages = *r.mutable_error_frames();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterConnectionImpl::GetErrorFrame(
    google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetErrorFrame(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::GetErrorFrameRequest const&
                 request) { return stub_->GetErrorFrame(context, request); },
      request, __func__);
}

StreamRange<google::cloud::migrationcenter::v1::Source>
MigrationCenterConnectionImpl::ListSources(
    google::cloud::migrationcenter::v1::ListSourcesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSources(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::Source>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListSourcesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::ListSourcesRequest const&
                       request) { return stub->ListSources(context, request); },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListSourcesResponse r) {
        std::vector<google::cloud::migrationcenter::v1::Source> result(
            r.sources().size());
        auto& messages = *r.mutable_sources();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::migrationcenter::v1::Source>
MigrationCenterConnectionImpl::GetSource(
    google::cloud::migrationcenter::v1::GetSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSource(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::migrationcenter::v1::GetSourceRequest const& request) {
        return stub_->GetSource(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterConnectionImpl::CreateSource(
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Source>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreateSourceRequest const&
              request) {
        return stub->AsyncCreateSource(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Source>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSource(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterConnectionImpl::UpdateSource(
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Source>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::UpdateSourceRequest const&
              request) {
        return stub->AsyncUpdateSource(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Source>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSource(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeleteSource(
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteSourceRequest const&
              request) {
        return stub->AsyncDeleteSource(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSource(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterConnectionImpl::ListPreferenceSets(
    google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPreferenceSets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListPreferenceSetsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::
                       ListPreferenceSetsRequest const& request) {
              return stub->ListPreferenceSets(context, request);
            },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListPreferenceSetsResponse r) {
        std::vector<google::cloud::migrationcenter::v1::PreferenceSet> result(
            r.preference_sets().size());
        auto& messages = *r.mutable_preference_sets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterConnectionImpl::GetPreferenceSet(
    google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPreferenceSet(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
                 request) { return stub_->GetPreferenceSet(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterConnectionImpl::CreatePreferenceSet(
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::PreferenceSet>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
              request) {
        return stub->AsyncCreatePreferenceSet(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::PreferenceSet>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePreferenceSet(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterConnectionImpl::UpdatePreferenceSet(
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::PreferenceSet>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
              request) {
        return stub->AsyncUpdatePreferenceSet(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::PreferenceSet>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePreferenceSet(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeletePreferenceSet(
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
              request) {
        return stub->AsyncDeletePreferenceSet(cq, std::move(context), options,
                                              request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePreferenceSet(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::migrationcenter::v1::Settings>
MigrationCenterConnectionImpl::GetSettings(
    google::cloud::migrationcenter::v1::GetSettingsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSettings(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::GetSettingsRequest const&
                 request) { return stub_->GetSettings(context, request); },
      request, __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Settings>>
MigrationCenterConnectionImpl::UpdateSettings(
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Settings>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::UpdateSettingsRequest const&
              request) {
        return stub->AsyncUpdateSettings(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Settings>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSettings(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
MigrationCenterConnectionImpl::CreateReportConfig(
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::ReportConfig>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
              request) {
        return stub->AsyncCreateReportConfig(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::ReportConfig>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateReportConfig(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterConnectionImpl::GetReportConfig(
    google::cloud::migrationcenter::v1::GetReportConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetReportConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::migrationcenter::v1::GetReportConfigRequest const&
                 request) { return stub_->GetReportConfig(context, request); },
      request, __func__);
}

StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterConnectionImpl::ListReportConfigs(
    google::cloud::migrationcenter::v1::ListReportConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReportConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::ReportConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListReportConfigsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::
                       ListReportConfigsRequest const& request) {
              return stub->ListReportConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListReportConfigsResponse r) {
        std::vector<google::cloud::migrationcenter::v1::ReportConfig> result(
            r.report_configs().size());
        auto& messages = *r.mutable_report_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeleteReportConfig(
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
              request) {
        return stub->AsyncDeleteReportConfig(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteReportConfig(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::migrationcenter::v1::Report>>
MigrationCenterConnectionImpl::CreateReport(
    google::cloud::migrationcenter::v1::CreateReportRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::Report>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::CreateReportRequest const&
              request) {
        return stub->AsyncCreateReport(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::migrationcenter::v1::Report>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateReport(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::migrationcenter::v1::Report>
MigrationCenterConnectionImpl::GetReport(
    google::cloud::migrationcenter::v1::GetReportRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetReport(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::migrationcenter::v1::GetReportRequest const& request) {
        return stub_->GetReport(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::migrationcenter::v1::Report>
MigrationCenterConnectionImpl::ListReports(
    google::cloud::migrationcenter::v1::ListReportsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListReports(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::migrationcenter::v1::Report>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<migrationcenter_v1::MigrationCenterRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::migrationcenter::v1::ListReportsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::migrationcenter::v1::ListReportsRequest const&
                       request) { return stub->ListReports(context, request); },
            r, function_name);
      },
      [](google::cloud::migrationcenter::v1::ListReportsResponse r) {
        std::vector<google::cloud::migrationcenter::v1::Report> result(
            r.reports().size());
        auto& messages = *r.mutable_reports();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterConnectionImpl::DeleteReport(
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::migrationcenter::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::migrationcenter::v1::DeleteReportRequest const&
              request) {
        return stub->AsyncDeleteReport(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::migrationcenter::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteReport(request),
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1_internal
}  // namespace cloud
}  // namespace google
