// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_ZONAL_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_ZONAL_CONNECTION_IMPL_H

#include "google/cloud/osconfig/v1/internal/os_config_zonal_retry_traits.h"
#include "google/cloud/osconfig/v1/internal/os_config_zonal_stub.h"
#include "google/cloud/osconfig/v1/os_config_zonal_connection.h"
#include "google/cloud/osconfig/v1/os_config_zonal_connection_idempotency_policy.h"
#include "google/cloud/osconfig/v1/os_config_zonal_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class OsConfigZonalServiceConnectionImpl
    : public osconfig_v1::OsConfigZonalServiceConnection {
 public:
  ~OsConfigZonalServiceConnectionImpl() override = default;

  OsConfigZonalServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<osconfig_v1_internal::OsConfigZonalServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  CreateOSPolicyAssignment(
      google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
          request) override;

  future<StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>>
  UpdateOSPolicyAssignment(
      google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
          request) override;

  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignment>
  GetOSPolicyAssignment(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const& request)
      override;

  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignments(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request)
      override;

  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignment>
  ListOSPolicyAssignmentRevisions(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
          request) override;

  future<StatusOr<
      google::cloud::osconfig::v1::OSPolicyAssignmentOperationMetadata>>
  DeleteOSPolicyAssignment(
      google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
          request) override;

  StatusOr<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  GetOSPolicyAssignmentReport(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
          request) override;

  StreamRange<google::cloud::osconfig::v1::OSPolicyAssignmentReport>
  ListOSPolicyAssignmentReports(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest request)
      override;

  StatusOr<google::cloud::osconfig::v1::Inventory> GetInventory(
      google::cloud::osconfig::v1::GetInventoryRequest const& request) override;

  StreamRange<google::cloud::osconfig::v1::Inventory> ListInventories(
      google::cloud::osconfig::v1::ListInventoriesRequest request) override;

  StatusOr<google::cloud::osconfig::v1::VulnerabilityReport>
  GetVulnerabilityReport(
      google::cloud::osconfig::v1::GetVulnerabilityReportRequest const& request)
      override;

  StreamRange<google::cloud::osconfig::v1::VulnerabilityReport>
  ListVulnerabilityReports(
      google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request)
      override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<osconfig_v1_internal::OsConfigZonalServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_INTERNAL_OS_CONFIG_ZONAL_CONNECTION_IMPL_H
