// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_ADMIN_INTERNAL_SUBSCRIPTION_ADMIN_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_ADMIN_INTERNAL_SUBSCRIPTION_ADMIN_TRACING_CONNECTION_H

#include "google/cloud/pubsub/admin/subscription_admin_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace pubsub_admin_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class SubscriptionAdminTracingConnection
    : public pubsub_admin::SubscriptionAdminConnection {
 public:
  ~SubscriptionAdminTracingConnection() override = default;

  explicit SubscriptionAdminTracingConnection(
      std::shared_ptr<pubsub_admin::SubscriptionAdminConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::pubsub::v1::Subscription> CreateSubscription(
      google::pubsub::v1::Subscription const& request) override;

  StatusOr<google::pubsub::v1::Subscription> GetSubscription(
      google::pubsub::v1::GetSubscriptionRequest const& request) override;

  StatusOr<google::pubsub::v1::Subscription> UpdateSubscription(
      google::pubsub::v1::UpdateSubscriptionRequest const& request) override;

  StreamRange<google::pubsub::v1::Subscription> ListSubscriptions(
      google::pubsub::v1::ListSubscriptionsRequest request) override;

  Status DeleteSubscription(
      google::pubsub::v1::DeleteSubscriptionRequest const& request) override;

  Status ModifyPushConfig(
      google::pubsub::v1::ModifyPushConfigRequest const& request) override;

  StatusOr<google::pubsub::v1::Snapshot> GetSnapshot(
      google::pubsub::v1::GetSnapshotRequest const& request) override;

  StreamRange<google::pubsub::v1::Snapshot> ListSnapshots(
      google::pubsub::v1::ListSnapshotsRequest request) override;

  StatusOr<google::pubsub::v1::Snapshot> CreateSnapshot(
      google::pubsub::v1::CreateSnapshotRequest const& request) override;

  StatusOr<google::pubsub::v1::Snapshot> UpdateSnapshot(
      google::pubsub::v1::UpdateSnapshotRequest const& request) override;

  Status DeleteSnapshot(
      google::pubsub::v1::DeleteSnapshotRequest const& request) override;

  StatusOr<google::pubsub::v1::SeekResponse> Seek(
      google::pubsub::v1::SeekRequest const& request) override;

 private:
  std::shared_ptr<pubsub_admin::SubscriptionAdminConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<pubsub_admin::SubscriptionAdminConnection>
MakeSubscriptionAdminTracingConnection(
    std::shared_ptr<pubsub_admin::SubscriptionAdminConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_admin_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_ADMIN_INTERNAL_SUBSCRIPTION_ADMIN_TRACING_CONNECTION_H
