// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#include "google/cloud/servicedirectory/v1/internal/registration_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/servicedirectory/v1/registration_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegistrationServiceLogging::RegistrationServiceLogging(
    std::shared_ptr<RegistrationServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceLogging::CreateNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
                 request) { return child_->CreateNamespace(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::ListNamespacesResponse>
RegistrationServiceLogging::ListNamespaces(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::ListNamespacesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::ListNamespacesRequest const&
                 request) { return child_->ListNamespaces(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceLogging::GetNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::GetNamespaceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::GetNamespaceRequest const&
                 request) { return child_->GetNamespace(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
RegistrationServiceLogging::UpdateNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
                 request) { return child_->UpdateNamespace(context, request); },
      context, request, __func__, tracing_options_);
}

Status RegistrationServiceLogging::DeleteNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
                 request) { return child_->DeleteNamespace(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceLogging::CreateService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::CreateServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::CreateServiceRequest const&
                 request) { return child_->CreateService(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::ListServicesResponse>
RegistrationServiceLogging::ListServices(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::ListServicesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::ListServicesRequest const&
                 request) { return child_->ListServices(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceLogging::GetService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::GetServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::GetServiceRequest const&
                 request) { return child_->GetService(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Service>
RegistrationServiceLogging::UpdateService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::UpdateServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::UpdateServiceRequest const&
                 request) { return child_->UpdateService(context, request); },
      context, request, __func__, tracing_options_);
}

Status RegistrationServiceLogging::DeleteService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::DeleteServiceRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::DeleteServiceRequest const&
                 request) { return child_->DeleteService(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceLogging::CreateEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::CreateEndpointRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::CreateEndpointRequest const&
                 request) { return child_->CreateEndpoint(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::ListEndpointsResponse>
RegistrationServiceLogging::ListEndpoints(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::ListEndpointsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::ListEndpointsRequest const&
                 request) { return child_->ListEndpoints(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceLogging::GetEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::GetEndpointRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::GetEndpointRequest const&
                 request) { return child_->GetEndpoint(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
RegistrationServiceLogging::UpdateEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::UpdateEndpointRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::UpdateEndpointRequest const&
                 request) { return child_->UpdateEndpoint(context, request); },
      context, request, __func__, tracing_options_);
}

Status RegistrationServiceLogging::DeleteEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::DeleteEndpointRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::DeleteEndpointRequest const&
                 request) { return child_->DeleteEndpoint(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> RegistrationServiceLogging::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return child_->GetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::Policy> RegistrationServiceLogging::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return child_->SetIamPolicy(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
RegistrationServiceLogging::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return child_->TestIamPermissions(context, request);
      },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1_internal
}  // namespace cloud
}  // namespace google
