// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/registration_service.proto

#include "google/cloud/servicedirectory/v1/internal/registration_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/servicedirectory/v1/registration_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegistrationServiceStub::~RegistrationServiceStub() = default;

StatusOr<google::cloud::servicedirectory::v1::Namespace>
DefaultRegistrationServiceStub::CreateNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::CreateNamespaceRequest const&
        request) {
  google::cloud::servicedirectory::v1::Namespace response;
  auto status = grpc_stub_->CreateNamespace(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::ListNamespacesResponse>
DefaultRegistrationServiceStub::ListNamespaces(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::ListNamespacesRequest const& request) {
  google::cloud::servicedirectory::v1::ListNamespacesResponse response;
  auto status = grpc_stub_->ListNamespaces(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
DefaultRegistrationServiceStub::GetNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::GetNamespaceRequest const& request) {
  google::cloud::servicedirectory::v1::Namespace response;
  auto status = grpc_stub_->GetNamespace(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::Namespace>
DefaultRegistrationServiceStub::UpdateNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::UpdateNamespaceRequest const&
        request) {
  google::cloud::servicedirectory::v1::Namespace response;
  auto status = grpc_stub_->UpdateNamespace(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultRegistrationServiceStub::DeleteNamespace(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::DeleteNamespaceRequest const&
        request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteNamespace(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::servicedirectory::v1::Service>
DefaultRegistrationServiceStub::CreateService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::CreateServiceRequest const& request) {
  google::cloud::servicedirectory::v1::Service response;
  auto status = grpc_stub_->CreateService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::ListServicesResponse>
DefaultRegistrationServiceStub::ListServices(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::ListServicesRequest const& request) {
  google::cloud::servicedirectory::v1::ListServicesResponse response;
  auto status = grpc_stub_->ListServices(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::Service>
DefaultRegistrationServiceStub::GetService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::GetServiceRequest const& request) {
  google::cloud::servicedirectory::v1::Service response;
  auto status = grpc_stub_->GetService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::Service>
DefaultRegistrationServiceStub::UpdateService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::UpdateServiceRequest const& request) {
  google::cloud::servicedirectory::v1::Service response;
  auto status = grpc_stub_->UpdateService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultRegistrationServiceStub::DeleteService(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::DeleteServiceRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteService(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
DefaultRegistrationServiceStub::CreateEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::CreateEndpointRequest const& request) {
  google::cloud::servicedirectory::v1::Endpoint response;
  auto status = grpc_stub_->CreateEndpoint(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::ListEndpointsResponse>
DefaultRegistrationServiceStub::ListEndpoints(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::ListEndpointsRequest const& request) {
  google::cloud::servicedirectory::v1::ListEndpointsResponse response;
  auto status = grpc_stub_->ListEndpoints(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
DefaultRegistrationServiceStub::GetEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::GetEndpointRequest const& request) {
  google::cloud::servicedirectory::v1::Endpoint response;
  auto status = grpc_stub_->GetEndpoint(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::servicedirectory::v1::Endpoint>
DefaultRegistrationServiceStub::UpdateEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::UpdateEndpointRequest const& request) {
  google::cloud::servicedirectory::v1::Endpoint response;
  auto status = grpc_stub_->UpdateEndpoint(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultRegistrationServiceStub::DeleteEndpoint(
    grpc::ClientContext& context,
    google::cloud::servicedirectory::v1::DeleteEndpointRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteEndpoint(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::iam::v1::Policy> DefaultRegistrationServiceStub::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->GetIamPolicy(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::Policy> DefaultRegistrationServiceStub::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  google::iam::v1::Policy response;
  auto status = grpc_stub_->SetIamPolicy(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DefaultRegistrationServiceStub::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  google::iam::v1::TestIamPermissionsResponse response;
  auto status = grpc_stub_->TestIamPermissions(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1_internal
}  // namespace cloud
}  // namespace google
