// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/sql/v1/cloud_sql_databases.proto

#include "google/cloud/sql/v1/internal/sql_databases_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace sql_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SqlDatabasesServiceTracingConnection::SqlDatabasesServiceTracingConnection(
    std::shared_ptr<sql_v1::SqlDatabasesServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceTracingConnection::Delete(
    google::cloud::sql::v1::SqlDatabasesDeleteRequest const& request) {
  auto span =
      internal::MakeSpan("sql_v1::SqlDatabasesServiceConnection::Delete");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Delete(request));
}

StatusOr<google::cloud::sql::v1::Database>
SqlDatabasesServiceTracingConnection::Get(
    google::cloud::sql::v1::SqlDatabasesGetRequest const& request) {
  auto span = internal::MakeSpan("sql_v1::SqlDatabasesServiceConnection::Get");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Get(request));
}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceTracingConnection::Insert(
    google::cloud::sql::v1::SqlDatabasesInsertRequest const& request) {
  auto span =
      internal::MakeSpan("sql_v1::SqlDatabasesServiceConnection::Insert");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Insert(request));
}

StatusOr<google::cloud::sql::v1::DatabasesListResponse>
SqlDatabasesServiceTracingConnection::List(
    google::cloud::sql::v1::SqlDatabasesListRequest const& request) {
  auto span = internal::MakeSpan("sql_v1::SqlDatabasesServiceConnection::List");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->List(request));
}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceTracingConnection::Patch(
    google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request) {
  auto span =
      internal::MakeSpan("sql_v1::SqlDatabasesServiceConnection::Patch");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Patch(request));
}

StatusOr<google::cloud::sql::v1::Operation>
SqlDatabasesServiceTracingConnection::Update(
    google::cloud::sql::v1::SqlDatabasesUpdateRequest const& request) {
  auto span =
      internal::MakeSpan("sql_v1::SqlDatabasesServiceConnection::Update");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Update(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<sql_v1::SqlDatabasesServiceConnection>
MakeSqlDatabasesServiceTracingConnection(
    std::shared_ptr<sql_v1::SqlDatabasesServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<SqlDatabasesServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace sql_v1_internal
}  // namespace cloud
}  // namespace google
