// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tasks/v2/cloudtasks.proto

#include "google/cloud/tasks/v2/cloud_tasks_client.h"
#include "google/cloud/tasks/v2/cloud_tasks_options.h"
#include <memory>
#include <thread>

namespace google {
namespace cloud {
namespace tasks_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudTasksClient::CloudTasksClient(
    std::shared_ptr<CloudTasksConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CloudTasksClient::~CloudTasksClient() = default;

StreamRange<google::cloud::tasks::v2::Queue> CloudTasksClient::ListQueues(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::ListQueuesRequest request;
  request.set_parent(parent);
  return connection_->ListQueues(request);
}

StreamRange<google::cloud::tasks::v2::Queue> CloudTasksClient::ListQueues(
    google::cloud::tasks::v2::ListQueuesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListQueues(std::move(request));
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::GetQueue(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::GetQueueRequest request;
  request.set_name(name);
  return connection_->GetQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::GetQueue(
    google::cloud::tasks::v2::GetQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::CreateQueue(
    std::string const& parent, google::cloud::tasks::v2::Queue const& queue,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::CreateQueueRequest request;
  request.set_parent(parent);
  *request.mutable_queue() = queue;
  return connection_->CreateQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::CreateQueue(
    google::cloud::tasks::v2::CreateQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::UpdateQueue(
    google::cloud::tasks::v2::Queue const& queue,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::UpdateQueueRequest request;
  *request.mutable_queue() = queue;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::UpdateQueue(
    google::cloud::tasks::v2::UpdateQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateQueue(request);
}

Status CloudTasksClient::DeleteQueue(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::DeleteQueueRequest request;
  request.set_name(name);
  return connection_->DeleteQueue(request);
}

Status CloudTasksClient::DeleteQueue(
    google::cloud::tasks::v2::DeleteQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::PurgeQueue(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::PurgeQueueRequest request;
  request.set_name(name);
  return connection_->PurgeQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::PurgeQueue(
    google::cloud::tasks::v2::PurgeQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PurgeQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::PauseQueue(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::PauseQueueRequest request;
  request.set_name(name);
  return connection_->PauseQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::PauseQueue(
    google::cloud::tasks::v2::PauseQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PauseQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::ResumeQueue(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::ResumeQueueRequest request;
  request.set_name(name);
  return connection_->ResumeQueue(request);
}

StatusOr<google::cloud::tasks::v2::Queue> CloudTasksClient::ResumeQueue(
    google::cloud::tasks::v2::ResumeQueueRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeQueue(request);
}

StatusOr<google::iam::v1::Policy> CloudTasksClient::GetIamPolicy(
    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest request;
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> CloudTasksClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> CloudTasksClient::SetIamPolicy(
    std::string const& resource, google::iam::v1::Policy const& policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::SetIamPolicyRequest request;
  request.set_resource(resource);
  *request.mutable_policy() = policy;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> CloudTasksClient::SetIamPolicy(
    std::string const& resource, IamUpdater const& updater, Options opts) {
  internal::CheckExpectedOptions<CloudTasksBackoffPolicyOption>(opts, __func__);
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest get_request;
  get_request.set_resource(resource);
  google::iam::v1::SetIamPolicyRequest set_request;
  set_request.set_resource(resource);
  auto backoff_policy =
      internal::CurrentOptions().get<CloudTasksBackoffPolicyOption>();
  if (backoff_policy != nullptr) {
    backoff_policy = backoff_policy->clone();
  }
  for (;;) {
    auto recent = connection_->GetIamPolicy(get_request);
    if (!recent) {
      return recent.status();
    }
    auto policy = updater(*std::move(recent));
    if (!policy) {
      return Status(StatusCode::kCancelled, "updater did not yield a policy");
    }
    *set_request.mutable_policy() = *std::move(policy);
    auto result = connection_->SetIamPolicy(set_request);
    if (result || result.status().code() != StatusCode::kAborted ||
        backoff_policy == nullptr) {
      return result;
    }
    std::this_thread::sleep_for(backoff_policy->OnCompletion());
  }
}

StatusOr<google::iam::v1::Policy> CloudTasksClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudTasksClient::TestIamPermissions(
    std::string const& resource, std::vector<std::string> const& permissions,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::TestIamPermissionsRequest request;
  request.set_resource(resource);
  *request.mutable_permissions() = {permissions.begin(), permissions.end()};
  return connection_->TestIamPermissions(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudTasksClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::cloud::tasks::v2::Task> CloudTasksClient::ListTasks(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::ListTasksRequest request;
  request.set_parent(parent);
  return connection_->ListTasks(request);
}

StreamRange<google::cloud::tasks::v2::Task> CloudTasksClient::ListTasks(
    google::cloud::tasks::v2::ListTasksRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTasks(std::move(request));
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksClient::GetTask(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::GetTaskRequest request;
  request.set_name(name);
  return connection_->GetTask(request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksClient::GetTask(
    google::cloud::tasks::v2::GetTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTask(request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksClient::CreateTask(
    std::string const& parent, google::cloud::tasks::v2::Task const& task,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::CreateTaskRequest request;
  request.set_parent(parent);
  *request.mutable_task() = task;
  return connection_->CreateTask(request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksClient::CreateTask(
    google::cloud::tasks::v2::CreateTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTask(request);
}

Status CloudTasksClient::DeleteTask(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::DeleteTaskRequest request;
  request.set_name(name);
  return connection_->DeleteTask(request);
}

Status CloudTasksClient::DeleteTask(
    google::cloud::tasks::v2::DeleteTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTask(request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksClient::RunTask(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::tasks::v2::RunTaskRequest request;
  request.set_name(name);
  return connection_->RunTask(request);
}

StatusOr<google::cloud::tasks::v2::Task> CloudTasksClient::RunTask(
    google::cloud::tasks::v2::RunTaskRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunTask(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tasks_v2
}  // namespace cloud
}  // namespace google
