// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

#include "google/cloud/video/stitcher/v1/internal/video_stitcher_option_defaults.h"
#include "google/cloud/video/stitcher/v1/video_stitcher_connection.h"
#include "google/cloud/video/stitcher/v1/video_stitcher_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace video_stitcher_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options VideoStitcherServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_VIDEO_STITCHER_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_VIDEO_STITCHER_SERVICE_AUTHORITY",
      "videostitcher.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options
           .has<video_stitcher_v1::VideoStitcherServiceRetryPolicyOption>()) {
    options.set<video_stitcher_v1::VideoStitcherServiceRetryPolicyOption>(
        video_stitcher_v1::VideoStitcherServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<video_stitcher_v1::VideoStitcherServiceBackoffPolicyOption>()) {
    options.set<video_stitcher_v1::VideoStitcherServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<video_stitcher_v1::VideoStitcherServicePollingPolicyOption>()) {
    options.set<video_stitcher_v1::VideoStitcherServicePollingPolicyOption>(
        GenericPollingPolicy<
            video_stitcher_v1::VideoStitcherServiceRetryPolicyOption::Type,
            video_stitcher_v1::VideoStitcherServiceBackoffPolicyOption::Type>(
            options
                .get<video_stitcher_v1::VideoStitcherServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<video_stitcher_v1::
                    VideoStitcherServiceConnectionIdempotencyPolicyOption>()) {
    options.set<video_stitcher_v1::
                    VideoStitcherServiceConnectionIdempotencyPolicyOption>(
        video_stitcher_v1::
            MakeDefaultVideoStitcherServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_stitcher_v1_internal
}  // namespace cloud
}  // namespace google
