// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#include "google/cloud/websecurityscanner/v1/web_security_scanner_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WebSecurityScannerClient::WebSecurityScannerClient(
    std::shared_ptr<WebSecurityScannerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
WebSecurityScannerClient::~WebSecurityScannerClient() = default;

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerClient::CreateScanConfig(
    google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateScanConfig(request);
}

Status WebSecurityScannerClient::DeleteScanConfig(
    google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteScanConfig(request);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerClient::GetScanConfig(
    google::cloud::websecurityscanner::v1::GetScanConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetScanConfig(request);
}

StreamRange<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerClient::ListScanConfigs(
    google::cloud::websecurityscanner::v1::ListScanConfigsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListScanConfigs(std::move(request));
}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerClient::UpdateScanConfig(
    google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateScanConfig(request);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerClient::StartScanRun(
    google::cloud::websecurityscanner::v1::StartScanRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartScanRun(request);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerClient::GetScanRun(
    google::cloud::websecurityscanner::v1::GetScanRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetScanRun(request);
}

StreamRange<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerClient::ListScanRuns(
    google::cloud::websecurityscanner::v1::ListScanRunsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListScanRuns(std::move(request));
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerClient::StopScanRun(
    google::cloud::websecurityscanner::v1::StopScanRunRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopScanRun(request);
}

StreamRange<google::cloud::websecurityscanner::v1::CrawledUrl>
WebSecurityScannerClient::ListCrawledUrls(
    google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCrawledUrls(std::move(request));
}

StatusOr<google::cloud::websecurityscanner::v1::Finding>
WebSecurityScannerClient::GetFinding(
    google::cloud::websecurityscanner::v1::GetFindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFinding(request);
}

StreamRange<google::cloud::websecurityscanner::v1::Finding>
WebSecurityScannerClient::ListFindings(
    google::cloud::websecurityscanner::v1::ListFindingsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFindings(std::move(request));
}

StatusOr<google::cloud::websecurityscanner::v1::ListFindingTypeStatsResponse>
WebSecurityScannerClient::ListFindingTypeStats(
    google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFindingTypeStats(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner_v1
}  // namespace cloud
}  // namespace google
