/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.io.IOException;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.Vector;
import org.jrobin.mrtg.server.Poller;
import org.jrobin.mrtg.server.Port;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Device {
    private String host = "";
    private String community = "";
    private String descr = "";
    private boolean active = true;
    private Vector links = new Vector();

    Device() {
    }

    Device(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            Node node3 = node2.getFirstChild();
            String string3 = string = node3 != null ? node3.getNodeValue().trim() : null;
            if (string2.equals("host")) {
                this.setHost(string);
                continue;
            }
            if (string2.equals("community")) {
                this.setCommunity(string);
                continue;
            }
            if (string2.equals("description")) {
                this.setDescr(string);
                continue;
            }
            if (string2.equals("active")) {
                this.setActive(new Boolean(node2.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (!string2.equals("interface")) continue;
            this.links.add(new Port(node2));
        }
    }

    String getHost() {
        return this.host;
    }

    void setHost(String string) {
        if (string != null) {
            this.host = string;
        }
    }

    String getCommunity() {
        return this.community;
    }

    void setCommunity(String string) {
        if (string != null) {
            this.community = string;
        }
    }

    String getDescr() {
        return this.descr;
    }

    void setDescr(String string) {
        if (string != null) {
            this.descr = string;
        }
    }

    boolean isActive() {
        return this.active;
    }

    boolean getActive() {
        return this.active;
    }

    void setActive(boolean bl) {
        this.active = bl;
    }

    Vector getLinks() {
        return this.links;
    }

    void setLinks(Vector vector) {
        this.links = vector;
    }

    public String toString() {
        String string = new String();
        string = string + "Router: " + this.host + " -- " + "community=" + this.community + ", ";
        string = string + "descr=" + this.descr + ", ";
        string = string + "active=" + this.active + "\n";
        for (int i = 0; i < this.links.size(); ++i) {
            Port port = (Port)this.links.get(i);
            string = string + "  Link: " + port + "\n";
        }
        return string;
    }

    Port getLinkByIfDescr(String string) {
        for (int i = 0; i < this.links.size(); ++i) {
            Port port = (Port)this.links.get(i);
            if (!port.getIfDescr().equalsIgnoreCase(string)) continue;
            return port;
        }
        return null;
    }

    void addLink(Port port) {
        this.links.add(port);
    }

    void removeLink(Port port) {
        this.links.remove(port);
    }

    int getLinkCount() {
        return this.links.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAvailableLinks() throws IOException {
        Poller poller = null;
        try {
            poller = new Poller(this.host, this.community);
            SortedMap sortedMap = poller.walkIfDescr();
            String[] stringArray = sortedMap.values().toArray(new String[0]);
            return stringArray;
        }
        finally {
            if (poller != null) {
                poller.close();
            }
        }
    }

    Hashtable getRouterInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("host", this.host);
        hashtable.put("community", this.community);
        hashtable.put("descr", this.descr);
        hashtable.put("active", new Boolean(this.active));
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.links.size(); ++i) {
            Port port = (Port)this.links.get(i);
            vector.add(port.getLinkInfo());
        }
        hashtable.put("links", vector);
        return hashtable;
    }

    void appendXml(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("router");
        element.appendChild(element2);
        Element element3 = document.createElement("host");
        element3.appendChild(document.createTextNode(this.host));
        element2.appendChild(element3);
        Element element4 = document.createElement("community");
        element4.appendChild(document.createTextNode(this.community));
        element2.appendChild(element4);
        Element element5 = document.createElement("description");
        element5.appendChild(document.createTextNode(this.descr));
        element2.appendChild(element5);
        Element element6 = document.createElement("active");
        element6.appendChild(document.createTextNode("" + this.active));
        element2.appendChild(element6);
        for (int i = 0; i < this.links.size(); ++i) {
            Port port = (Port)this.links.elementAt(i);
            port.appendXml(element2);
        }
    }
}

