//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationcurve?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAnimationCurve(pub NSUInteger);
impl NSAnimationCurve {
    #[doc(alias = "NSAnimationEaseInOut")]
    pub const EaseInOut: Self = Self(0);
    #[doc(alias = "NSAnimationEaseIn")]
    pub const EaseIn: Self = Self(1);
    #[doc(alias = "NSAnimationEaseOut")]
    pub const EaseOut: Self = Self(2);
    #[doc(alias = "NSAnimationLinear")]
    pub const Linear: Self = Self(3);
}

unsafe impl Encode for NSAnimationCurve {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSAnimationCurve {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationblockingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAnimationBlockingMode(pub NSUInteger);
impl NSAnimationBlockingMode {
    #[doc(alias = "NSAnimationBlocking")]
    pub const Blocking: Self = Self(0);
    #[doc(alias = "NSAnimationNonblocking")]
    pub const Nonblocking: Self = Self(1);
    #[doc(alias = "NSAnimationNonblockingThreaded")]
    pub const NonblockingThreaded: Self = Self(2);
}

unsafe impl Encode for NSAnimationBlockingMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSAnimationBlockingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationprogress?language=objc)
pub type NSAnimationProgress = c_float;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationprogressmarknotification?language=objc)
    pub static NSAnimationProgressMarkNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationprogressmark?language=objc)
    pub static NSAnimationProgressMark: &'static NSString;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimation?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSAnimation;
);

extern_conformance!(
    unsafe impl NSCoding for NSAnimation {}
);

extern_conformance!(
    unsafe impl NSCopying for NSAnimation {}
);

unsafe impl CopyingHelper for NSAnimation {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSAnimation {}
);

impl NSAnimation {
    extern_methods!(
        #[unsafe(method(initWithDuration:animationCurve:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDuration_animationCurve(
            this: Allocated<Self>,
            duration: NSTimeInterval,
            animation_curve: NSAnimationCurve,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(startAnimation))]
        #[unsafe(method_family = none)]
        pub unsafe fn startAnimation(&self);

        #[unsafe(method(stopAnimation))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopAnimation(&self);

        #[unsafe(method(isAnimating))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAnimating(&self) -> bool;

        #[unsafe(method(currentProgress))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentProgress(&self) -> NSAnimationProgress;

        /// Setter for [`currentProgress`][Self::currentProgress].
        #[unsafe(method(setCurrentProgress:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCurrentProgress(&self, current_progress: NSAnimationProgress);

        #[unsafe(method(duration))]
        #[unsafe(method_family = none)]
        pub unsafe fn duration(&self) -> NSTimeInterval;

        /// Setter for [`duration`][Self::duration].
        #[unsafe(method(setDuration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDuration(&self, duration: NSTimeInterval);

        #[unsafe(method(animationBlockingMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn animationBlockingMode(&self) -> NSAnimationBlockingMode;

        /// Setter for [`animationBlockingMode`][Self::animationBlockingMode].
        #[unsafe(method(setAnimationBlockingMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationBlockingMode(
            &self,
            animation_blocking_mode: NSAnimationBlockingMode,
        );

        #[unsafe(method(frameRate))]
        #[unsafe(method_family = none)]
        pub unsafe fn frameRate(&self) -> c_float;

        /// Setter for [`frameRate`][Self::frameRate].
        #[unsafe(method(setFrameRate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFrameRate(&self, frame_rate: c_float);

        #[unsafe(method(animationCurve))]
        #[unsafe(method_family = none)]
        pub unsafe fn animationCurve(&self) -> NSAnimationCurve;

        /// Setter for [`animationCurve`][Self::animationCurve].
        #[unsafe(method(setAnimationCurve:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAnimationCurve(&self, animation_curve: NSAnimationCurve);

        #[unsafe(method(currentValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentValue(&self) -> c_float;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSAnimationDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSAnimationDelegate>>,
        );

        #[unsafe(method(progressMarks))]
        #[unsafe(method_family = none)]
        pub unsafe fn progressMarks(&self) -> Retained<NSArray<NSNumber>>;

        /// Setter for [`progressMarks`][Self::progressMarks].
        #[unsafe(method(setProgressMarks:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProgressMarks(&self, progress_marks: &NSArray<NSNumber>);

        #[unsafe(method(addProgressMark:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addProgressMark(&self, progress_mark: NSAnimationProgress);

        #[unsafe(method(removeProgressMark:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeProgressMark(&self, progress_mark: NSAnimationProgress);

        #[unsafe(method(startWhenAnimation:reachesProgress:))]
        #[unsafe(method_family = none)]
        pub unsafe fn startWhenAnimation_reachesProgress(
            &self,
            animation: &NSAnimation,
            start_progress: NSAnimationProgress,
        );

        #[unsafe(method(stopWhenAnimation:reachesProgress:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stopWhenAnimation_reachesProgress(
            &self,
            animation: &NSAnimation,
            stop_progress: NSAnimationProgress,
        );

        #[unsafe(method(clearStartAnimation))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearStartAnimation(&self);

        #[unsafe(method(clearStopAnimation))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearStopAnimation(&self);

        #[unsafe(method(runLoopModesForAnimating))]
        #[unsafe(method_family = none)]
        pub unsafe fn runLoopModesForAnimating(&self) -> Option<Retained<NSArray<NSRunLoopMode>>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSAnimation {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationdelegate?language=objc)
    pub unsafe trait NSAnimationDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(animationShouldStart:))]
        #[unsafe(method_family = none)]
        unsafe fn animationShouldStart(&self, animation: &NSAnimation) -> bool;

        #[optional]
        #[unsafe(method(animationDidStop:))]
        #[unsafe(method_family = none)]
        unsafe fn animationDidStop(&self, animation: &NSAnimation);

        #[optional]
        #[unsafe(method(animationDidEnd:))]
        #[unsafe(method_family = none)]
        unsafe fn animationDidEnd(&self, animation: &NSAnimation);

        #[optional]
        #[unsafe(method(animation:valueForProgress:))]
        #[unsafe(method_family = none)]
        unsafe fn animation_valueForProgress(
            &self,
            animation: &NSAnimation,
            progress: NSAnimationProgress,
        ) -> c_float;

        #[optional]
        #[unsafe(method(animation:didReachProgressMark:))]
        #[unsafe(method_family = none)]
        unsafe fn animation_didReachProgressMark(
            &self,
            animation: &NSAnimation,
            progress: NSAnimationProgress,
        );
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationkey?language=objc)
// NS_TYPED_ENUM
pub type NSViewAnimationKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationtargetkey?language=objc)
    pub static NSViewAnimationTargetKey: &'static NSViewAnimationKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationstartframekey?language=objc)
    pub static NSViewAnimationStartFrameKey: &'static NSViewAnimationKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationendframekey?language=objc)
    pub static NSViewAnimationEndFrameKey: &'static NSViewAnimationKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationeffectkey?language=objc)
    pub static NSViewAnimationEffectKey: &'static NSViewAnimationKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationeffectname?language=objc)
// NS_TYPED_ENUM
pub type NSViewAnimationEffectName = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationfadeineffect?language=objc)
    pub static NSViewAnimationFadeInEffect: &'static NSViewAnimationEffectName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimationfadeouteffect?language=objc)
    pub static NSViewAnimationFadeOutEffect: &'static NSViewAnimationEffectName;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsviewanimation?language=objc)
    #[unsafe(super(NSAnimation, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSViewAnimation;
);

extern_conformance!(
    unsafe impl NSCoding for NSViewAnimation {}
);

extern_conformance!(
    unsafe impl NSCopying for NSViewAnimation {}
);

unsafe impl CopyingHelper for NSViewAnimation {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSViewAnimation {}
);

impl NSViewAnimation {
    extern_methods!(
        #[unsafe(method(initWithViewAnimations:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithViewAnimations(
            this: Allocated<Self>,
            view_animations: &NSArray<NSDictionary<NSViewAnimationKey, AnyObject>>,
        ) -> Retained<Self>;

        #[unsafe(method(viewAnimations))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewAnimations(
            &self,
        ) -> Retained<NSArray<NSDictionary<NSViewAnimationKey, AnyObject>>>;

        /// Setter for [`viewAnimations`][Self::viewAnimations].
        #[unsafe(method(setViewAnimations:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setViewAnimations(
            &self,
            view_animations: &NSArray<NSDictionary<NSViewAnimationKey, AnyObject>>,
        );
    );
}

/// Methods declared on superclass `NSAnimation`.
impl NSViewAnimation {
    extern_methods!(
        #[unsafe(method(initWithDuration:animationCurve:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDuration_animationCurve(
            this: Allocated<Self>,
            duration: NSTimeInterval,
            animation_curve: NSAnimationCurve,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSViewAnimation {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimatablepropertykey?language=objc)
pub type NSAnimatablePropertyKey = NSString;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimatablepropertycontainer?language=objc)
    pub unsafe trait NSAnimatablePropertyContainer {
        #[unsafe(method(animator))]
        #[unsafe(method_family = none)]
        unsafe fn animator(&self) -> Retained<Self>;

        #[unsafe(method(animations))]
        #[unsafe(method_family = none)]
        unsafe fn animations(&self) -> Retained<NSDictionary<NSAnimatablePropertyKey, AnyObject>>;

        /// Setter for [`animations`][Self::animations].
        #[unsafe(method(setAnimations:))]
        #[unsafe(method_family = none)]
        unsafe fn setAnimations(
            &self,
            animations: &NSDictionary<NSAnimatablePropertyKey, AnyObject>,
        );

        #[unsafe(method(animationForKey:))]
        #[unsafe(method_family = none)]
        unsafe fn animationForKey(
            &self,
            key: &NSAnimatablePropertyKey,
        ) -> Option<Retained<AnyObject>>;

        #[unsafe(method(defaultAnimationForKey:))]
        #[unsafe(method_family = none)]
        unsafe fn defaultAnimationForKey(
            key: &NSAnimatablePropertyKey,
        ) -> Option<Retained<AnyObject>>;
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationtriggerorderin?language=objc)
    pub static NSAnimationTriggerOrderIn: &'static NSAnimatablePropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsanimationtriggerorderout?language=objc)
    pub static NSAnimationTriggerOrderOut: &'static NSAnimatablePropertyKey;
}
