/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math;

import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.parser.Token;
import net.gcalc.calc.parser.VariableToken;

public class RungeKutta {
    private static final Token X = VariableToken.X_VAR;
    private static final Token Y = VariableToken.Y_VAR;
    private double k1;
    private double k2;
    private double k3;
    private double k4;
    private double p1;
    private double p2;
    private double p3;
    private double p4;

    public static double[] singleStep(Function F, Function G, double xn, double yn, double h, ValueTable vt, SymbolTable st, double[] ret) {
        return new RungeKutta().oneStep(F, G, xn, yn, h, vt, st, ret);
    }

    public synchronized double[] oneStep(Function F, Function G, double xn, double yn, double h, ValueTable vt, SymbolTable st, double[] ret) {
        double[] u = ret;
        if (u == null) {
            u = new double[2];
        }
        vt.setValue(X, xn);
        vt.setValue(Y, yn);
        this.k1 = F.evaluate(st, vt);
        this.p1 = G.evaluate(st, vt);
        vt.setValue(X, xn + 0.5 * h * this.k1);
        vt.setValue(Y, yn + 0.5 * h * this.p1);
        this.k2 = F.evaluate(st, vt);
        this.p2 = G.evaluate(st, vt);
        vt.setValue(X, xn + 0.5 * h * this.k2);
        vt.setValue(Y, yn + 0.5 * h * this.p2);
        this.k3 = F.evaluate(st, vt);
        this.p3 = G.evaluate(st, vt);
        vt.setValue(X, xn + h * this.k3);
        vt.setValue(Y, yn + h * this.p3);
        this.k4 = F.evaluate(st, vt);
        this.p4 = G.evaluate(st, vt);
        u[0] = xn + h / 6.0 * (this.k1 + 2.0 * (this.k2 + this.k3) + this.k4);
        u[1] = yn + h / 6.0 * (this.p1 + 2.0 * (this.p2 + this.p3) + this.p4);
        return u;
    }
}

