/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.BinaryOperation;
import net.gcalc.calc.math.functions.Constant;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;

public class Addition
extends BinaryOperation {
    public Addition(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        return this.L.evaluate(st, vt) + this.R.evaluate(st, vt);
    }

    public Function derivative(Vector vars) {
        Vector<Function> v = new Vector<Function>();
        v.add(this.L.derivative(vars));
        v.add(this.R.derivative(vars));
        return FunctionFactory.getFunction(new ParseTree(this.getRoot(), v));
    }

    public Function simplify() {
        if (this.simpleVersion != null) {
            return this.simpleVersion;
        }
        if (this.isConstant()) {
            this.simpleVersion = new Constant(this.evaluate());
            return this.simpleVersion;
        }
        if (this.L.isZero()) {
            this.simpleVersion = this.R.simplify();
            return this.simpleVersion;
        }
        if (this.R.isZero()) {
            this.simpleVersion = this.L.simplify();
            return this.simpleVersion;
        }
        return super.simplify();
    }
}

