/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.BinaryOperation;
import net.gcalc.calc.math.functions.Constant;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;

public class Division
extends BinaryOperation {
    public Division(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        return this.L.evaluate(st, vt) / this.R.evaluate(st, vt);
    }

    public Function derivative(Vector vars) {
        Function TL = FunctionFactory.getFunction(MULT_TOKEN, this.L.derivative(vars), this.R);
        Function TR = FunctionFactory.getFunction(MULT_TOKEN, this.L, this.R.derivative(vars));
        Function NUM = FunctionFactory.getFunction(MINUS_TOKEN, TL, TR);
        Function DEN = FunctionFactory.getFunction(MULT_TOKEN, this.R, this.R);
        return FunctionFactory.getFunction(this.getRoot(), NUM, DEN);
    }

    public Function simplify() {
        if (this.simpleVersion != null) {
            return this.simpleVersion;
        }
        if (this.isConstant()) {
            this.simpleVersion = new Constant(this.evaluate());
            return this.simpleVersion;
        }
        if (this.R.isZero()) {
            this.simpleVersion = NOT_A_NUMBER;
            return this.simpleVersion;
        }
        if (this.L.isZero()) {
            this.simpleVersion = ZERO;
            return this.simpleVersion;
        }
        return super.simplify();
    }
}

