/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.math.functions.VariableArityFunction;
import net.gcalc.calc.parser.ParseTree;

public class Maximum
extends VariableArityFunction {
    public Maximum(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        if (this.getNumberOfArgs() == 0) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        Vector args = this.getArgs();
        int i = 0;
        while (i < args.size()) {
            double t = ((Function)args.elementAt(i)).evaluate(st, vt);
            if (Double.isNaN(t)) {
                return t;
            }
            if (max < t) {
                max = t;
            }
            ++i;
        }
        return max;
    }

    public Function derivative(Vector vars) {
        if (this.getNumberOfArgs() == 1) {
            return ((Function)this.getArgs().elementAt(0)).derivative(vars);
        }
        Function f = this.maximum(0, (this.getNumberOfArgs() - 1) / 2);
        Function g = this.maximum((this.getNumberOfArgs() - 1) / 2 + 1, this.getNumberOfArgs() - 1);
        Function df = f.derivative(vars);
        Function dg = g.derivative(vars);
        Function derDiff = FunctionFactory.getFunction(MINUS_TOKEN, df, dg);
        Function derSum = FunctionFactory.getFunction(PLUS_TOKEN, df, dg);
        Function diff = FunctionFactory.getFunction(MINUS_TOKEN, f, g);
        Function der = FunctionFactory.getFunction(DIV_TOKEN, FunctionFactory.getFunction(PLUS_TOKEN, derSum, FunctionFactory.getFunction(MULT_TOKEN, FunctionFactory.getFunction(SGN_TOKEN, diff), derDiff)), TWO);
        return der;
    }

    private Function maximum(int a, int b) {
        Vector<ParseTree> v = new Vector<ParseTree>();
        int i = a;
        while (i <= b) {
            v.add(this.getArg(i));
            ++i;
        }
        return FunctionFactory.getFunction(MAX_TOKEN, v);
    }
}

