/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.parser;

import java.util.Vector;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.calc.parser.Token;

public class CalcTokenizer {
    private static final String[] OPS = new String[]{"&&", "||", "<=", ">=", "!=", "==", "+", "-", "*", "/", "^", "=", "<", ">"};
    private static final String DELIMCHARS = "(),";
    private String input;
    private int pos;
    private static final int BAD_STATE = -1;
    private static final int START = 1;
    private static final int JUST_DOT = 2;
    private static final int ACCEPTABLE_DECIMAL = 3;
    private static final int SIGNED_EXPONENT = 4;
    private static final int ACCEPTABLE_INTEGER = 5;
    private static final int START_EXPONENT = 6;
    private static final int ACCEPTABLE_EXPONENT = 7;

    public static void main(String[] args) throws BadSyntaxException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            sb.append(args[i]);
            sb.append(" ");
            ++i;
        }
        System.out.println(new CalcTokenizer(sb.toString()).tokenize());
    }

    public CalcTokenizer(String s) {
        this.input = s;
        this.pos = 0;
    }

    public Vector tokenize() throws BadSyntaxException {
        Vector<Token> tokens = new Vector<Token>();
        while (this.pos < this.input.length()) {
            char c = this.input.charAt(this.pos);
            if (!Character.isWhitespace(c)) {
                if (Character.isDigit(c) || c == '.') {
                    tokens.addElement(this.parseDouble());
                } else if (this.isOperationPrefix(c)) {
                    tokens.addElement(this.parseOperation());
                } else if (this.isDelimeter(c)) {
                    tokens.addElement(this.parseDelimeter());
                } else if (Character.isLetter(c)) {
                    tokens.addElement(this.parseKeyword());
                } else {
                    throw new BadSyntaxException("Unrecognized character " + c, this.pos);
                }
            }
            ++this.pos;
        }
        return tokens;
    }

    private boolean isOperationPrefix(char c) {
        int i = 0;
        while (i < OPS.length) {
            if (OPS[i].charAt(0) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDelimeter(char c) {
        return DELIMCHARS.indexOf(c) >= 0;
    }

    private Token parseDouble() throws BadSyntaxException {
        StringBuffer sb = new StringBuffer();
        StringBuffer cache = new StringBuffer();
        boolean exit = false;
        int state = 1;
        int p1 = this.pos;
        do {
            char c = this.input.charAt(this.pos);
            switch (state) {
                case 1: {
                    if (Character.isDigit(c)) {
                        state = 5;
                        break;
                    }
                    if (c == '.') {
                        state = 2;
                        break;
                    }
                    exit = true;
                    break;
                }
                case 2: {
                    if (Character.isDigit(c)) {
                        state = 3;
                        break;
                    }
                    exit = true;
                    break;
                }
                case 3: {
                    if (Character.isDigit(c)) {
                        state = 3;
                        break;
                    }
                    if (c == 'E') {
                        state = 6;
                        break;
                    }
                    exit = true;
                    break;
                }
                case 4: {
                    if (Character.isDigit(c)) {
                        state = 7;
                        break;
                    }
                    exit = true;
                    break;
                }
                case 5: {
                    if (Character.isDigit(c)) {
                        state = 5;
                        break;
                    }
                    if (c == '.') {
                        state = 3;
                        break;
                    }
                    if (c == 'E') {
                        state = 6;
                        break;
                    }
                    exit = true;
                    break;
                }
                case 6: {
                    if (Character.isDigit(c)) {
                        state = 7;
                        break;
                    }
                    if (c == '+' || c == '-') {
                        state = 4;
                        break;
                    }
                    exit = true;
                    break;
                }
                case 7: {
                    if (Character.isDigit(c)) {
                        state = 7;
                        break;
                    }
                    exit = true;
                    break;
                }
                default: {
                    state = -1;
                    exit = true;
                }
            }
            if (!exit) {
                if (state == 3 || state == 5 || state == 7) {
                    sb.append(cache.toString());
                    sb.append(c);
                    cache.setLength(0);
                } else if (state == 1 || state == 2 || state == 4 || state == 6) {
                    cache.append(c);
                }
            }
            ++this.pos;
        } while (!exit && this.pos < this.input.length());
        if (state == 2 && exit) {
            throw new BadSyntaxException("Extraneous Dot", this.pos);
        }
        this.pos = p1 + sb.length() - 1;
        return new Token(sb.toString(), 0, p1);
    }

    private Token parseKeyword() {
        char c;
        int p1 = this.pos;
        int p2 = this.pos;
        while (p2 < this.input.length() && (Character.isLetter(c = this.input.charAt(p2)) || Character.isDigit(c))) {
            ++p2;
        }
        String word = this.input.substring(p1, p2);
        int type = 3;
        if (FunctionFactory.isFunctionName(word)) {
            type = 1;
        }
        this.pos = p2 - 1;
        return new Token(word, type, p1);
    }

    private Token parseOperation() throws BadSyntaxException {
        String s = null;
        int i = 0;
        while (s == null && i < OPS.length) {
            if (this.input.substring(this.pos).startsWith(OPS[i])) {
                s = OPS[i];
            }
            ++i;
        }
        if (s == null) {
            throw new BadSyntaxException("Cannot parse!");
        }
        this.pos += s.length() - 1;
        return new Token(s, 1, this.pos);
    }

    private Token parseDelimeter() {
        return new Token(this.input.charAt(this.pos), 2, this.pos);
    }
}

