/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.gcalc.calc.main.HackHack;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.plugin.gui.AbstractCartesianGraphPlugin;
import net.gcalc.plugin.gui.ModelEditingDialog;
import net.gcalc.plugin.plane.graph.GraphCanvas;
import net.gcalc.plugin.properties.GraphProperties;

public class ModelListPanel
extends JPanel
implements ListDataListener {
    private GraphProperties properties;
    private JList list;
    private JButton removeButton;
    private JButton editButton;

    public ModelListPanel(GraphProperties gp) {
        this(gp, true, true);
    }

    public ModelListPanel(GraphProperties gp, boolean edit, boolean remove) {
        this.properties = gp;
        ModelList modelList = (ModelList)this.properties.get(GraphProperties.MODEL_LIST);
        this.list = new JList(modelList);
        modelList.addListDataListener(this);
        JScrollPane sp = new JScrollPane(this.list, 22, 32);
        sp.setPreferredSize(new Dimension(200, 200));
        Box buttonBox = Box.createHorizontalBox();
        if (edit) {
            this.editButton = new JButton("Edit");
            buttonBox.add(this.editButton);
            this.editButton.addActionListener(new EditAction());
        }
        if (remove) {
            this.removeButton = new JButton("Remove");
            buttonBox.add(this.removeButton);
            this.removeButton.addActionListener(new RemoveAction());
        }
        Box box = Box.createVerticalBox();
        box.add(sp);
        box.add(buttonBox);
        this.add(box);
        this.list.setCellRenderer(new CustomCellRenderer());
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void contentsChanged(ListDataEvent e) {
        ModelList modelList = this.getModelList();
        if (modelList != null) {
            this.list.setListData(modelList.getModelArray());
        }
    }

    private ModelList getModelList() {
        return (ModelList)this.properties.get(GraphProperties.MODEL_LIST);
    }

    class EditAction
    extends AbstractAction {
        EditAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int selected = ModelListPanel.this.list.getSelectedIndex();
            if (selected != -1) {
                RenderableModel model = (RenderableModel)ModelListPanel.this.getModelList().getModelAt(selected);
                ModelEditingDialog editDialog = model.getEditingDialog((AbstractCartesianGraphPlugin)ModelListPanel.this.properties.get(GraphProperties.PLUGIN));
                editDialog.setVisible(true);
                RenderableModel newModel = editDialog.getNewModel();
                if (newModel != null) {
                    ModelListPanel.this.getModelList().setModelAt(newModel, selected);
                }
            }
            GraphCanvas graph = (GraphCanvas)ModelListPanel.this.properties.get(GraphProperties.GRAPH_CANVAS);
            graph.redrawAll();
        }
    }

    class RemoveAction
    extends AbstractAction {
        RemoveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int[] selected = ModelListPanel.this.list.getSelectedIndices();
            int i = selected.length - 1;
            while (i >= 0) {
                ModelListPanel.this.getModelList().removeElementAt(selected[i]);
                --i;
            }
            GraphCanvas graph = (GraphCanvas)ModelListPanel.this.properties.get(GraphProperties.GRAPH_CANVAS);
            graph.redrawAll();
        }
    }

    class CustomCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final int SIZE = 30;

        CustomCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (value instanceof RenderableModel) {
                RenderableModel model = (RenderableModel)value;
                Color c = model.getColor();
                float[] rgb = c.getRGBColorComponents(null);
                int i = 0;
                while (i < 3) {
                    rgb[i] = (rgb[i] + 6.0f) / 7.0f;
                    ++i;
                }
                c = new Color(rgb[0], rgb[1], rgb[2]);
                BufferedImage iconImage = HackHack.checkeredImage(Color.white, c, 30, 30, 3);
                Graphics iconGraphics = ((Image)iconImage).getGraphics();
                Image image = model.getThumbnailImage(32, 32);
                if (image != null) {
                    iconGraphics.drawImage(image, 0, 0, null);
                }
                this.setIcon(new ImageIcon(iconImage));
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setMinimumSize(new Dimension(30, 30));
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            return this;
        }
    }
}

