/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FileInfo;
import java.io.File;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonPathResolver {
    private static final char PATH_SEPARATOR = File.separatorChar;
    private final List<FileInfo> files;

    public CommonPathResolver(List<FileInfo> files) {
        this.files = files;
    }

    public String resolve() {
        if (this.files.isEmpty()) {
            return "";
        }
        if (this.files.size() == 1) {
            return new File(this.files.get(0).getFilePath()).getParent() + PATH_SEPARATOR;
        }
        Iterator<FileInfo> iterator = this.files.iterator();
        String longestPath = iterator.next().getFilePath();
        do {
            longestPath = this.getLongestCommonPath(longestPath, iterator.next().getFilePath());
        } while (iterator.hasNext());
        return longestPath;
    }

    private String getLongestCommonPath(String longestPath, String currentPath) {
        char[] longestPathChar = longestPath.toCharArray();
        char[] currentPathChar = currentPath.toCharArray();
        int lastPathSeparatorIndex = 0;
        for (int i = 0; i < longestPathChar.length && i < currentPathChar.length && longestPathChar[i] == currentPathChar[i]; ++i) {
            if (longestPathChar[i] != PATH_SEPARATOR || currentPathChar[i] != PATH_SEPARATOR) continue;
            lastPathSeparatorIndex = i;
        }
        return longestPath.substring(0, lastPathSeparatorIndex + 1);
    }
}

