/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.model.JstdTestCase;
import com.google.jstestdriver.model.JstdTestCaseFactory;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunData {
    private final List<ResponseStream> responses;
    private final List<JstdTestCase> testCases;
    private final JstdTestCaseFactory testCaseFactory;

    public RunData(List<ResponseStream> responses, List<JstdTestCase> testCases, JstdTestCaseFactory testCaseFactory) {
        this.responses = responses;
        this.testCases = testCases;
        this.testCaseFactory = testCaseFactory;
    }

    public RunData recordResponse(ResponseStream responseStream) {
        LinkedList<ResponseStream> newResponses = Lists.newLinkedList(this.responses);
        newResponses.add(responseStream);
        return new RunData(newResponses, this.testCases, this.testCaseFactory);
    }

    public RunData aggregateResponses(RunData runData) {
        LinkedList<ResponseStream> newResponses = Lists.newLinkedList(this.responses);
        newResponses.addAll(runData.responses);
        return new RunData(newResponses, this.testCases, this.testCaseFactory);
    }

    public Set<FileInfo> getFileSet() {
        LinkedHashSet<FileInfo> fileSet = Sets.newLinkedHashSet();
        for (JstdTestCase testCase : this.testCases) {
            fileSet.addAll(testCase.toFileSet());
        }
        return fileSet;
    }

    public void finish() {
        for (ResponseStream response : this.responses) {
            response.finish();
        }
    }

    @Deprecated
    public RunData updateFileSet(Set<FileInfo> fileSet) {
        return new RunData(this.responses, this.testCaseFactory.updateCases(fileSet, this.testCases), this.testCaseFactory);
    }

    public RunData updateTestCases(List<JstdTestCase> testCases) {
        return new RunData(this.responses, testCases, this.testCaseFactory);
    }

    public String toString() {
        return "RunData [responses=" + this.responses + ", testCaseFactory=" + this.testCaseFactory + ", testCases=" + this.testCases + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.responses == null ? 0 : ((Object)this.responses).hashCode());
        result = 31 * result + (this.testCaseFactory == null ? 0 : this.testCaseFactory.hashCode());
        result = 31 * result + (this.testCases == null ? 0 : ((Object)this.testCases).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunData other = (RunData)obj;
        if (this.responses == null ? other.responses != null : !((Object)this.responses).equals(other.responses)) {
            return false;
        }
        if (this.testCaseFactory == null ? other.testCaseFactory != null : !this.testCaseFactory.equals(other.testCaseFactory)) {
            return false;
        }
        return !(this.testCases == null ? other.testCases != null : !((Object)this.testCases).equals(other.testCases));
    }

    public List<JstdTestCase> getTestCases() {
        return this.testCases;
    }
}

