/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestParameters;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.annotations.ResponseWriter;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeartbeatPostHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatPostHandler.class);
    private final CapturedBrowsers capturedBrowsers;
    private final Map<String, String[]> parameters;
    private final PrintWriter writer;
    private final HttpServletResponse response;

    @Inject
    public HeartbeatPostHandler(CapturedBrowsers capturedBrowsers, @RequestParameters Map<String, String[]> parameters, @ResponseWriter PrintWriter writer, HttpServletResponse response) {
        this.capturedBrowsers = capturedBrowsers;
        this.parameters = parameters;
        this.writer = writer;
        this.response = response;
    }

    @Override
    public void handleIt() throws IOException {
        this.response.setContentType("text/plain; charset=utf-8");
        String[] ids = this.parameters.get("id");
        if (ids != null && ids[0] != null) {
            String id = ids[0];
            SlaveBrowser browser = this.capturedBrowsers.getBrowser(id);
            if (browser != null) {
                browser.heartBeat();
                logger.trace("browser heartbeat {}", browser);
                if (browser.getCommandRunning() == null) {
                    this.writer.write("Waiting...");
                } else {
                    this.writer.write("Running: " + browser.getCommandRunning());
                }
            } else {
                this.writer.write("UNKNOWN");
            }
            this.writer.flush();
        }
    }
}

