/* mainTest.h was originally generated by the autoSql program, which also 
 * generated mainTest.c and mainTest.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef MAINTEST_H
#define MAINTEST_H

#define PT_NUM_COLS 2

struct pt
/* Two dimensional point */
    {
    int x;	/* x coor */
    int y;	/* y coor */
    };

struct pt *ptLoad(char **row);
/* Load a pt from row fetched with select * from pt
 * from database.  Dispose of this with ptFree(). */

struct pt *ptLoadAll(char *fileName);
/* Load all pt from whitespace-separated file.
 * Dispose of this with ptFreeList(). */

struct pt *ptLoadAllByChar(char *fileName, char chopper);
/* Load all pt from chopper separated file.
 * Dispose of this with ptFreeList(). */

#define ptLoadAllByTab(a) ptLoadAllByChar(a, '\t');
/* Load all pt from tab separated file.
 * Dispose of this with ptFreeList(). */

struct pt *ptCommaIn(char **pS, struct pt *ret);
/* Create a pt out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pt */

void ptOutput(struct pt *el, FILE *f, char sep, char lastSep);
/* Print out pt.  Separate fields with sep. Follow last field with lastSep. */

#define ptTabOut(el,f) ptOutput(el,f,'\t','\n');
/* Print out pt as a line in a tab-separated file. */

#define ptCommaOut(el,f) ptOutput(el,f,',',',');
/* Print out pt as a comma separated list including final comma. */

#define POINT_NUM_COLS 5

struct point
/* Three dimensional point */
    {
    struct point *next;  /* Next in singly linked list. */
    char acc[13];	/* GenBank Accession sequence */
    int x;	/* x coor */
    int y;	/* y coor */
    int z;	/* z coor */
    struct pt pt;	/* Transformed point. */
    };

struct point *pointLoad(char **row);
/* Load a point from row fetched with select * from point
 * from database.  Dispose of this with pointFree(). */

struct point *pointLoadAll(char *fileName);
/* Load all point from whitespace-separated file.
 * Dispose of this with pointFreeList(). */

struct point *pointLoadAllByChar(char *fileName, char chopper);
/* Load all point from chopper separated file.
 * Dispose of this with pointFreeList(). */

#define pointLoadAllByTab(a) pointLoadAllByChar(a, '\t');
/* Load all point from tab separated file.
 * Dispose of this with pointFreeList(). */

struct point *pointCommaIn(char **pS, struct point *ret);
/* Create a point out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new point */

void pointFree(struct point **pEl);
/* Free a single dynamically allocated point such as created
 * with pointLoad(). */

void pointFreeList(struct point **pList);
/* Free a list of dynamically allocated point's */

void pointOutput(struct point *el, FILE *f, char sep, char lastSep);
/* Print out point.  Separate fields with sep. Follow last field with lastSep. */

#define pointTabOut(el,f) pointOutput(el,f,'\t','\n');
/* Print out point as a line in a tab-separated file. */

#define pointCommaOut(el,f) pointOutput(el,f,',',',');
/* Print out point as a comma separated list including final comma. */

#define POLYGON_NUM_COLS 4

struct polygon
/* A face */
    {
    struct polygon *next;  /* Next in singly linked list. */
    unsigned id;	/* Unique ID */
    int pointCount;	/* point count */
    struct point *points;	/* Points list */
    struct pt *persp;	/* Points after perspective transformation */
    };

struct polygon *polygonLoad(char **row);
/* Load a polygon from row fetched with select * from polygon
 * from database.  Dispose of this with polygonFree(). */

struct polygon *polygonLoadAll(char *fileName);
/* Load all polygon from whitespace-separated file.
 * Dispose of this with polygonFreeList(). */

struct polygon *polygonLoadAllByChar(char *fileName, char chopper);
/* Load all polygon from chopper separated file.
 * Dispose of this with polygonFreeList(). */

#define polygonLoadAllByTab(a) polygonLoadAllByChar(a, '\t');
/* Load all polygon from tab separated file.
 * Dispose of this with polygonFreeList(). */

struct polygon *polygonCommaIn(char **pS, struct polygon *ret);
/* Create a polygon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polygon */

void polygonFree(struct polygon **pEl);
/* Free a single dynamically allocated polygon such as created
 * with polygonLoad(). */

void polygonFreeList(struct polygon **pList);
/* Free a list of dynamically allocated polygon's */

void polygonOutput(struct polygon *el, FILE *f, char sep, char lastSep);
/* Print out polygon.  Separate fields with sep. Follow last field with lastSep. */

#define polygonTabOut(el,f) polygonOutput(el,f,'\t','\n');
/* Print out polygon as a line in a tab-separated file. */

#define polygonCommaOut(el,f) polygonOutput(el,f,',',',');
/* Print out polygon as a comma separated list including final comma. */

#define POLYHEDRON_NUM_COLS 5

struct polyhedron
/* A 3-d object */
    {
    struct polyhedron *next;  /* Next in singly linked list. */
    unsigned id;	/* Unique ID */
    char *names[2];	/* Name of this figure */
    int polygonCount;	/* Polygon count */
    struct polygon *polygons;	/* Polygons */
    struct pt screenBox[2];	/* Bounding box in screen coordinates */
    };

struct polyhedron *polyhedronLoad(char **row);
/* Load a polyhedron from row fetched with select * from polyhedron
 * from database.  Dispose of this with polyhedronFree(). */

struct polyhedron *polyhedronLoadAll(char *fileName);
/* Load all polyhedron from whitespace-separated file.
 * Dispose of this with polyhedronFreeList(). */

struct polyhedron *polyhedronLoadAllByChar(char *fileName, char chopper);
/* Load all polyhedron from chopper separated file.
 * Dispose of this with polyhedronFreeList(). */

#define polyhedronLoadAllByTab(a) polyhedronLoadAllByChar(a, '\t');
/* Load all polyhedron from tab separated file.
 * Dispose of this with polyhedronFreeList(). */

struct polyhedron *polyhedronCommaIn(char **pS, struct polyhedron *ret);
/* Create a polyhedron out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new polyhedron */

void polyhedronFree(struct polyhedron **pEl);
/* Free a single dynamically allocated polyhedron such as created
 * with polyhedronLoad(). */

void polyhedronFreeList(struct polyhedron **pList);
/* Free a list of dynamically allocated polyhedron's */

void polyhedronOutput(struct polyhedron *el, FILE *f, char sep, char lastSep);
/* Print out polyhedron.  Separate fields with sep. Follow last field with lastSep. */

#define polyhedronTabOut(el,f) polyhedronOutput(el,f,'\t','\n');
/* Print out polyhedron as a line in a tab-separated file. */

#define polyhedronCommaOut(el,f) polyhedronOutput(el,f,',',',');
/* Print out polyhedron as a comma separated list including final comma. */

#define TWOPOINT_NUM_COLS 4

struct twoPoint
/* Two points back to back */
    {
    char name[13];	/* name of points */
    struct pt a;	/* point a */
    struct pt b;	/* point b */
    struct pt points[2];	/* points as array */
    };

struct twoPoint *twoPointLoad(char **row);
/* Load a twoPoint from row fetched with select * from twoPoint
 * from database.  Dispose of this with twoPointFree(). */

struct twoPoint *twoPointLoadAll(char *fileName);
/* Load all twoPoint from whitespace-separated file.
 * Dispose of this with twoPointFreeList(). */

struct twoPoint *twoPointLoadAllByChar(char *fileName, char chopper);
/* Load all twoPoint from chopper separated file.
 * Dispose of this with twoPointFreeList(). */

#define twoPointLoadAllByTab(a) twoPointLoadAllByChar(a, '\t');
/* Load all twoPoint from tab separated file.
 * Dispose of this with twoPointFreeList(). */

struct twoPoint *twoPointCommaIn(char **pS, struct twoPoint *ret);
/* Create a twoPoint out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new twoPoint */

void twoPointOutput(struct twoPoint *el, FILE *f, char sep, char lastSep);
/* Print out twoPoint.  Separate fields with sep. Follow last field with lastSep. */

#define twoPointTabOut(el,f) twoPointOutput(el,f,'\t','\n');
/* Print out twoPoint as a line in a tab-separated file. */

#define twoPointCommaOut(el,f) twoPointOutput(el,f,',',',');
/* Print out twoPoint as a comma separated list including final comma. */

#define STRINGARRAY_NUM_COLS 2

struct stringArray
/* An array of strings */
    {
    struct stringArray *next;  /* Next in singly linked list. */
    short numNames;	/* Number of names */
    char **names;	/* Array of names */
    };

struct stringArray *stringArrayLoad(char **row);
/* Load a stringArray from row fetched with select * from stringArray
 * from database.  Dispose of this with stringArrayFree(). */

struct stringArray *stringArrayLoadAll(char *fileName);
/* Load all stringArray from whitespace-separated file.
 * Dispose of this with stringArrayFreeList(). */

struct stringArray *stringArrayLoadAllByChar(char *fileName, char chopper);
/* Load all stringArray from chopper separated file.
 * Dispose of this with stringArrayFreeList(). */

#define stringArrayLoadAllByTab(a) stringArrayLoadAllByChar(a, '\t');
/* Load all stringArray from tab separated file.
 * Dispose of this with stringArrayFreeList(). */

struct stringArray *stringArrayCommaIn(char **pS, struct stringArray *ret);
/* Create a stringArray out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new stringArray */

void stringArrayFree(struct stringArray **pEl);
/* Free a single dynamically allocated stringArray such as created
 * with stringArrayLoad(). */

void stringArrayFreeList(struct stringArray **pList);
/* Free a list of dynamically allocated stringArray's */

void stringArrayOutput(struct stringArray *el, FILE *f, char sep, char lastSep);
/* Print out stringArray.  Separate fields with sep. Follow last field with lastSep. */

#define stringArrayTabOut(el,f) stringArrayOutput(el,f,'\t','\n');
/* Print out stringArray as a line in a tab-separated file. */

#define stringArrayCommaOut(el,f) stringArrayOutput(el,f,',',',');
/* Print out stringArray as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* MAINTEST_H */

