/* bToBeCfg.h was originally generated by the autoSql program, which also 
 * generated bToBeCfg.c and bToBeCfg.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BTOBECFG_H
#define BTOBECFG_H

#define BTOBECFG_NUM_COLS 7

struct bToBeCfg
/* Helper to convert bed files to bed+exp file. */
    {
    struct bToBeCfg *next;  /* Next in singly linked list. */
    char *factor;	/* Protein factor, antibody, etc. */
    char *source;	/* Cell line, tissue, etc. */
    char *sourceId;	/* Short ID (one letter usually) for source */
    char *dataSource;	/* Either 'file' or a database name */
    int scoreCol;	/* Score column Index */
    float multiplier;	/* Multiply by this to get score close to 0-1 range. */
    char *dataTable;	/* File name or table name */
    };

void bToBeCfgStaticLoad(char **row, struct bToBeCfg *ret);
/* Load a row from bToBeCfg table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct bToBeCfg *bToBeCfgLoad(char **row);
/* Load a bToBeCfg from row fetched with select * from bToBeCfg
 * from database.  Dispose of this with bToBeCfgFree(). */

struct bToBeCfg *bToBeCfgLoadAll(char *fileName);
/* Load all bToBeCfg from whitespace-separated file.
 * Dispose of this with bToBeCfgFreeList(). */

struct bToBeCfg *bToBeCfgLoadAllByChar(char *fileName, char chopper);
/* Load all bToBeCfg from chopper separated file.
 * Dispose of this with bToBeCfgFreeList(). */

#define bToBeCfgLoadAllByTab(a) bToBeCfgLoadAllByChar(a, '\t');
/* Load all bToBeCfg from tab separated file.
 * Dispose of this with bToBeCfgFreeList(). */

struct bToBeCfg *bToBeCfgCommaIn(char **pS, struct bToBeCfg *ret);
/* Create a bToBeCfg out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bToBeCfg */

void bToBeCfgFree(struct bToBeCfg **pEl);
/* Free a single dynamically allocated bToBeCfg such as created
 * with bToBeCfgLoad(). */

void bToBeCfgFreeList(struct bToBeCfg **pList);
/* Free a list of dynamically allocated bToBeCfg's */

void bToBeCfgOutput(struct bToBeCfg *el, FILE *f, char sep, char lastSep);
/* Print out bToBeCfg.  Separate fields with sep. Follow last field with lastSep. */

#define bToBeCfgTabOut(el,f) bToBeCfgOutput(el,f,'\t','\n');
/* Print out bToBeCfg as a line in a tab-separated file. */

#define bToBeCfgCommaOut(el,f) bToBeCfgOutput(el,f,',',',');
/* Print out bToBeCfg as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* BTOBECFG_H */

