/* jobDb.c was originally generated by the autoSql program, which also 
 * generated jobDb.h and jobDb.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "sqlList.h"
#include "jobDb.h"


struct submission *submissionCommaIn(char **pS, struct submission *ret)
/* Create a submission out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new submission */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlStringComma(&s);
ret->host = sqlStringComma(&s);
ret->cpuTime = sqlFloatComma(&s);
ret->submitTime = sqlUnsignedComma(&s);
ret->startTime = sqlUnsignedComma(&s);
ret->endTime = sqlUnsignedComma(&s);
ret->status = sqlSignedComma(&s);
ret->gotStatus = sqlUnsignedComma(&s);
ret->submitError = sqlUnsignedComma(&s);
ret->inQueue = sqlUnsignedComma(&s);
ret->queueError = sqlUnsignedComma(&s);
ret->trackingError = sqlUnsignedComma(&s);
ret->running = sqlUnsignedComma(&s);
ret->crashed = sqlUnsignedComma(&s);
ret->slow = sqlUnsignedComma(&s);
ret->hung = sqlUnsignedComma(&s);
ret->ranOk = sqlUnsignedComma(&s);
ret->errFile = sqlStringComma(&s);
*pS = s;
return ret;
}

void submissionFree(struct submission **pEl)
/* Free a single dynamically allocated submission such as created
 * with submissionLoad(). */
{
struct submission *el;

if ((el = *pEl) == NULL) return;
freeMem(el->id);
freeMem(el->host);
freeMem(el->errFile);
freez(pEl);
}

void submissionFreeList(struct submission **pList)
/* Free a list of dynamically allocated submission's */
{
struct submission *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    submissionFree(&el);
    }
*pList = NULL;
}

void submissionOutput(struct submission *el, FILE *f, char sep, char lastSep) 
/* Print out submission.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->id);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->host);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->cpuTime);
fputc(sep,f);
fprintf(f, "%u", el->submitTime);
fputc(sep,f);
fprintf(f, "%u", el->startTime);
fputc(sep,f);
fprintf(f, "%u", el->endTime);
fputc(sep,f);
fprintf(f, "%d", el->status);
fputc(sep,f);
fprintf(f, "%u", el->gotStatus);
fputc(sep,f);
fprintf(f, "%u", el->submitError);
fputc(sep,f);
fprintf(f, "%u", el->inQueue);
fputc(sep,f);
fprintf(f, "%u", el->queueError);
fputc(sep,f);
fprintf(f, "%u", el->trackingError);
fputc(sep,f);
fprintf(f, "%u", el->running);
fputc(sep,f);
fprintf(f, "%u", el->crashed);
fputc(sep,f);
fprintf(f, "%u", el->slow);
fputc(sep,f);
fprintf(f, "%u", el->hung);
fputc(sep,f);
fprintf(f, "%u", el->ranOk);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errFile);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

struct check *checkCommaIn(char **pS, struct check *ret)
/* Create a check out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new check */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->when = sqlStringComma(&s);
ret->what = sqlStringComma(&s);
ret->file = sqlStringComma(&s);
*pS = s;
return ret;
}

void checkFree(struct check **pEl)
/* Free a single dynamically allocated check such as created
 * with checkLoad(). */
{
struct check *el;

if ((el = *pEl) == NULL) return;
freeMem(el->when);
freeMem(el->what);
freeMem(el->file);
freez(pEl);
}

void checkFreeList(struct check **pList)
/* Free a list of dynamically allocated check's */
{
struct check *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    checkFree(&el);
    }
*pList = NULL;
}

void checkOutput(struct check *el, FILE *f, char sep, char lastSep) 
/* Print out check.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->when);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->what);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->file);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

struct job *jobCommaIn(char **pS, struct job *ret)
/* Create a job out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new job */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->command = sqlStringComma(&s);
ret->cpusUsed = sqlFloatComma(&s);
ret->ramUsed = sqlLongLongComma(&s);
ret->checkCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->checkCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->checkList, checkCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->checkList);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->submissionCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->submissionCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->submissionList, submissionCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->submissionList);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->spec = sqlStringComma(&s);
*pS = s;
return ret;
}

void jobFree(struct job **pEl)
/* Free a single dynamically allocated job such as created
 * with jobLoad(). */
{
struct job *el;

if ((el = *pEl) == NULL) return;
freeMem(el->command);
checkFreeList(&el->checkList);
submissionFreeList(&el->submissionList);
freeMem(el->spec);
freez(pEl);
}

void jobFreeList(struct job **pList)
/* Free a list of dynamically allocated job's */
{
struct job *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jobFree(&el);
    }
*pList = NULL;
}

void jobOutput(struct job *el, FILE *f, char sep, char lastSep) 
/* Print out job.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->command);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->cpusUsed);
fputc(sep,f);
fprintf(f, "%lld", el->ramUsed);
fputc(sep,f);
fprintf(f, "%d", el->checkCount);
fputc(sep,f);
{
int i;
/* Loading check list. */
    {
    struct check *it = el->checkList;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->checkCount; ++i)
        {
        fputc('{',f);
        checkCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(sep,f);
fprintf(f, "%d", el->submissionCount);
fputc(sep,f);
{
int i;
/* Loading submission list. */
    {
    struct submission *it = el->submissionList;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->submissionCount; ++i)
        {
        fputc('{',f);
        submissionCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spec);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

struct jobDb *jobDbCommaIn(char **pS, struct jobDb *ret)
/* Create a jobDb out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jobDb */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->jobCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
for (i=0; i<ret->jobCount; ++i)
    {
    s = sqlEatChar(s, '{');
    if(s[0] != '}')        slSafeAddHead(&ret->jobList, jobCommaIn(&s,NULL));
    s = sqlEatChar(s, '}');
    s = sqlEatChar(s, ',');
    }
slReverse(&ret->jobList);
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void jobDbFree(struct jobDb **pEl)
/* Free a single dynamically allocated jobDb such as created
 * with jobDbLoad(). */
{
struct jobDb *el;

if ((el = *pEl) == NULL) return;
jobFreeList(&el->jobList);
freez(pEl);
}

void jobDbFreeList(struct jobDb **pList)
/* Free a list of dynamically allocated jobDb's */
{
struct jobDb *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jobDbFree(&el);
    }
*pList = NULL;
}

void jobDbOutput(struct jobDb *el, FILE *f, char sep, char lastSep) 
/* Print out jobDb.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->jobCount);
fputc(sep,f);
{
int i;
/* Loading job list. */
    {
    struct job *it = el->jobList;
    if (sep == ',') fputc('{',f);
    for (i=0; i<el->jobCount; ++i)
        {
        fputc('{',f);
        jobCommaOut(it,f);
        it = it->next;
        fputc('}',f);
        fputc(',',f);
        }
    if (sep == ',') fputc('}',f);
    }
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

