(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.

Axiom t : Type.
Parameter t_WhyType : WhyType t.
Existing Instance t_WhyType.

Axiom structure : Type.
Parameter structure_WhyType : WhyType structure.
Existing Instance structure_WhyType.

Parameter infix_breq: structure -> t -> Prop.

Parameter ffalse: t.

Parameter ttrue: t.

Parameter prefix_tl: t -> t.

Parameter infix_et: t -> t -> t.

Parameter infix_plpl: t -> t -> t.

Parameter infix_eqgt: t -> t -> t.

Parameter infix_breqeq: t -> t -> Prop.

Axiom model_extensionality : forall (f1:t) (f2:t), (infix_breqeq f1 f2) <->
  forall (m:structure), (infix_breq m f1) -> (infix_breq m f2).

Axiom extensionality : forall (f1:t) (f2:t), (forall (m:structure),
  (infix_breq m f1) <-> (infix_breq m f2)) -> (f1 = f2).

Axiom structure_exists : exists m:structure, exists f:t, (infix_breq m f).

Axiom true_false : ~ (ttrue = ffalse).

Axiom model_true : forall (m:structure), (infix_breq m ttrue).

Axiom model_false : forall (m:structure), ~ (infix_breq m ffalse).

Axiom model_neg : forall (m:structure), forall (f:t), (infix_breq m
  (prefix_tl f)) <-> ~ (infix_breq m f).

Axiom model_and : forall (m:structure), forall (f1:t) (f2:t), (infix_breq m
  (infix_et f1 f2)) <-> ((infix_breq m f1) /\ (infix_breq m f2)).

Axiom model_or : forall (m:structure), forall (f1:t) (f2:t), (infix_breq m
  (infix_plpl f1 f2)) <-> ((infix_breq m f1) \/ (infix_breq m f2)).

(* Why3 assumption *)
Definition sat (f:t): Prop := exists m:structure, (infix_breq m f).

(* Why3 assumption *)
Definition valid (f:t): Prop := ~ (sat (prefix_tl f)).

Axiom valid_def : forall (f:t), (valid f) <-> forall (m:structure),
  (infix_breq m f).

Axiom imply_def : forall (f1:t) (f2:t), ((infix_eqgt f1
  f2) = (infix_plpl (prefix_tl f1) f2)).

Axiom imply_models : forall (f1:t) (f2:t), (valid (infix_eqgt f1 f2)) <->
  (infix_breqeq f1 f2).

Axiom negneg : forall (f:t), ((prefix_tl (prefix_tl f)) = f).

Axiom and_a : forall (f1:t) (f2:t) (f3:t), ((infix_et (infix_et f1 f2)
  f3) = (infix_et f1 (infix_et f2 f3))).

Axiom and_c : forall (f1:t) (f2:t), ((infix_et f1 f2) = (infix_et f2 f1)).

Axiom or_a : forall (f1:t) (f2:t) (f3:t), ((infix_plpl (infix_plpl f1 f2)
  f3) = (infix_plpl f1 (infix_plpl f2 f3))).

Axiom or_c : forall (f1:t) (f2:t), ((infix_plpl f1 f2) = (infix_plpl f2 f1)).

Axiom distr_and : forall (f1:t) (f2:t) (f3:t), ((infix_et f1 (infix_plpl f2
  f3)) = (infix_plpl (infix_et f1 f2) (infix_et f1 f3))).

Axiom distr_or : forall (f1:t) (f2:t) (f3:t), ((infix_plpl f1 (infix_et f2
  f3)) = (infix_et (infix_plpl f1 f2) (infix_plpl f1 f3))).

Axiom neutral_and : forall (f:t), ((infix_et f ttrue) = f).

Axiom neutral_or : forall (f:t), ((infix_plpl f ffalse) = f).

Axiom absorb_and : forall (f:t), ((infix_et f ffalse) = ffalse).

Axiom absorb_or : forall (f:t), ((infix_plpl f ttrue) = ttrue).

Axiom sat_def : forall (f:t), (sat f) <-> ~ (valid (prefix_tl f)).

Axiom unsat_invalid : forall (f:t), (~ (valid f)) -> (sat (prefix_tl f)).

Axiom valid_sat : forall (f:t), (valid f) -> (sat f).

Axiom ttrue_valid : (valid ttrue).

Axiom ffaslse_invalid : ~ (valid ffalse).

Axiom ttrue_sat : (sat ttrue).

Axiom ffalse_unsat : ~ (sat ffalse).

Axiom sat_neg : forall (f:t), (~ (sat f)) -> (sat (prefix_tl f)).

Axiom valid_neg : forall (f:t), (valid (prefix_tl f)) -> ~ (valid f).

Axiom sat_or : forall (f1:t) (f2:t), (sat (infix_plpl f1 f2)) <-> ((sat
  f1) \/ (sat f2)).

Axiom valid_and : forall (f1:t) (f2:t), (valid (infix_et f1 f2)) <-> ((valid
  f1) /\ (valid f2)).

Axiom valid_or : forall (f1:t) (f2:t), ((valid f1) \/ (valid f2)) -> (valid
  (infix_plpl f1 f2)).

Axiom sat_and : forall (f1:t) (f2:t), (sat (infix_et f1 f2)) -> ((sat f1) /\
  (sat f2)).

(* Why3 goal *)
Theorem forget_subsumed : forall (f:t) (v:t), (infix_breqeq f v) ->
  ((infix_plpl f v) = v).
(* Why3 intros f v h1. *)
intros f v h1.

Notation "A & B" := (infix_et A B) (at level 80, right associativity).
Notation "A | B" := (infix_plpl A B) (at level 85, right associativity).
Notation "-- A" := (prefix_tl A) (at level 75, right associativity).
Notation "A => B" := (infix_eqgt A B) (at level 70, right associativity).
Notation "A |= B" := (infix_breq A B) (at level 65, right associativity).
Notation "A |== B" := (infix_breqeq A B) (at level 64, right associativity).

rewrite model_extensionality in h1.
apply extensionality. intro.
assert (m |= f -> m |= v).
auto.
split.
intro.
apply model_or in H0.
destruct H0.
apply H. auto. auto.
intro. apply model_or.
right; assumption.
Qed.


