// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/metrics.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Metrics data.
type Metrics struct {
	// The percent of your ad impressions that are shown as the very first ad
	// above the organic search results.
	AbsoluteTopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,95,opt,name=absolute_top_impression_percentage,json=absoluteTopImpressionPercentage,proto3" json:"absolute_top_impression_percentage,omitempty"`
	// Average cost of viewable impressions (`active_view_impressions`).
	ActiveViewCpm *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=active_view_cpm,json=activeViewCpm,proto3" json:"active_view_cpm,omitempty"`
	// Active view measurable clicks divided by active view viewable impressions.
	// This metric is reported only for display network.
	ActiveViewCtr *wrappers.DoubleValue `protobuf:"bytes,79,opt,name=active_view_ctr,json=activeViewCtr,proto3" json:"active_view_ctr,omitempty"`
	// A measurement of how often your ad has become viewable on a Display
	// Network site.
	ActiveViewImpressions *wrappers.Int64Value `protobuf:"bytes,2,opt,name=active_view_impressions,json=activeViewImpressions,proto3" json:"active_view_impressions,omitempty"`
	// The ratio of impressions that could be measured by Active View over the
	// number of served impressions.
	ActiveViewMeasurability *wrappers.DoubleValue `protobuf:"bytes,96,opt,name=active_view_measurability,json=activeViewMeasurability,proto3" json:"active_view_measurability,omitempty"`
	// The cost of the impressions you received that were measurable by Active
	// View.
	ActiveViewMeasurableCostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=active_view_measurable_cost_micros,json=activeViewMeasurableCostMicros,proto3" json:"active_view_measurable_cost_micros,omitempty"`
	// The number of times your ads are appearing on placements in positions
	// where they can be seen.
	ActiveViewMeasurableImpressions *wrappers.Int64Value `protobuf:"bytes,4,opt,name=active_view_measurable_impressions,json=activeViewMeasurableImpressions,proto3" json:"active_view_measurable_impressions,omitempty"`
	// The percentage of time when your ad appeared on an Active View enabled site
	// (measurable impressions) and was viewable (viewable impressions).
	ActiveViewViewability *wrappers.DoubleValue `protobuf:"bytes,97,opt,name=active_view_viewability,json=activeViewViewability,proto3" json:"active_view_viewability,omitempty"`
	// All conversions from interactions (as oppose to view through conversions)
	// divided by the number of ad interactions.
	AllConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,65,opt,name=all_conversions_from_interactions_rate,json=allConversionsFromInteractionsRate,proto3" json:"all_conversions_from_interactions_rate,omitempty"`
	// The total value of all conversions.
	AllConversionsValue *wrappers.DoubleValue `protobuf:"bytes,66,opt,name=all_conversions_value,json=allConversionsValue,proto3" json:"all_conversions_value,omitempty"`
	// The total number of conversions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	AllConversions *wrappers.DoubleValue `protobuf:"bytes,7,opt,name=all_conversions,json=allConversions,proto3" json:"all_conversions,omitempty"`
	// The value of all conversions divided by the total cost of ad interactions
	// (such as clicks for text ads or views for video ads).
	AllConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,62,opt,name=all_conversions_value_per_cost,json=allConversionsValuePerCost,proto3" json:"all_conversions_value_per_cost,omitempty"`
	// The number of times people clicked the "Call" button to call a store during
	// or after clicking an ad. This number doesn't include whether or not calls
	// were connected, or the duration of any calls.
	// This metric applies to feed items only.
	AllConversionsFromClickToCall *wrappers.DoubleValue `protobuf:"bytes,118,opt,name=all_conversions_from_click_to_call,json=allConversionsFromClickToCall,proto3" json:"all_conversions_from_click_to_call,omitempty"`
	// The number of times people clicked a "Get directions" button to navigate to
	// a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromDirections *wrappers.DoubleValue `protobuf:"bytes,119,opt,name=all_conversions_from_directions,json=allConversionsFromDirections,proto3" json:"all_conversions_from_directions,omitempty"`
	// The value of all conversions from interactions divided by the total number
	// of interactions.
	AllConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,67,opt,name=all_conversions_from_interactions_value_per_interaction,json=allConversionsFromInteractionsValuePerInteraction,proto3" json:"all_conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of times people clicked a link to view a store's menu after
	// clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromMenu *wrappers.DoubleValue `protobuf:"bytes,120,opt,name=all_conversions_from_menu,json=allConversionsFromMenu,proto3" json:"all_conversions_from_menu,omitempty"`
	// The number of times people placed an order at a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromOrder *wrappers.DoubleValue `protobuf:"bytes,121,opt,name=all_conversions_from_order,json=allConversionsFromOrder,proto3" json:"all_conversions_from_order,omitempty"`
	// The number of other conversions (for example, posting a review or saving a
	// location for a store) that occurred after people clicked an ad.
	// This metric applies to feed items only.
	AllConversionsFromOtherEngagement *wrappers.DoubleValue `protobuf:"bytes,122,opt,name=all_conversions_from_other_engagement,json=allConversionsFromOtherEngagement,proto3" json:"all_conversions_from_other_engagement,omitempty"`
	// Estimated number of times people visited a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromStoreVisit *wrappers.DoubleValue `protobuf:"bytes,123,opt,name=all_conversions_from_store_visit,json=allConversionsFromStoreVisit,proto3" json:"all_conversions_from_store_visit,omitempty"`
	// The number of times that people were taken to a store's URL after clicking
	// an ad.
	// This metric applies to feed items only.
	AllConversionsFromStoreWebsite *wrappers.DoubleValue `protobuf:"bytes,124,opt,name=all_conversions_from_store_website,json=allConversionsFromStoreWebsite,proto3" json:"all_conversions_from_store_website,omitempty"`
	// The average amount you pay per interaction. This amount is the total cost
	// of your ads divided by the total number of interactions.
	AverageCost *wrappers.DoubleValue `protobuf:"bytes,8,opt,name=average_cost,json=averageCost,proto3" json:"average_cost,omitempty"`
	// The total cost of all clicks divided by the total number of clicks
	// received.
	AverageCpc *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// The average amount that you've been charged for an ad engagement. This
	// amount is the total cost of all ad engagements divided by the total number
	// of ad engagements.
	AverageCpe *wrappers.DoubleValue `protobuf:"bytes,98,opt,name=average_cpe,json=averageCpe,proto3" json:"average_cpe,omitempty"`
	// Average cost-per-thousand impressions (CPM).
	AverageCpm *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=average_cpm,json=averageCpm,proto3" json:"average_cpm,omitempty"`
	// The average amount you pay each time someone views your ad.
	// The average CPV is defined by the total cost of all ad views divided by
	// the number of views.
	AverageCpv *wrappers.DoubleValue `protobuf:"bytes,11,opt,name=average_cpv,json=averageCpv,proto3" json:"average_cpv,omitempty"`
	// Average number of times a unique cookie was exposed to your ad
	// over a given time period. Imported from Google Analytics.
	AverageFrequency *wrappers.DoubleValue `protobuf:"bytes,12,opt,name=average_frequency,json=averageFrequency,proto3" json:"average_frequency,omitempty"`
	// Average number of pages viewed per session.
	AveragePageViews *wrappers.DoubleValue `protobuf:"bytes,99,opt,name=average_page_views,json=averagePageViews,proto3" json:"average_page_views,omitempty"`
	// Your ad's position relative to those of other advertisers.
	AveragePosition *wrappers.DoubleValue `protobuf:"bytes,13,opt,name=average_position,json=averagePosition,proto3" json:"average_position,omitempty"`
	// Total duration of all sessions (in seconds) / number of sessions. Imported
	// from Google Analytics.
	AverageTimeOnSite *wrappers.DoubleValue `protobuf:"bytes,84,opt,name=average_time_on_site,json=averageTimeOnSite,proto3" json:"average_time_on_site,omitempty"`
	// An indication of how other advertisers are bidding on similar products.
	BenchmarkAverageMaxCpc *wrappers.DoubleValue `protobuf:"bytes,14,opt,name=benchmark_average_max_cpc,json=benchmarkAverageMaxCpc,proto3" json:"benchmark_average_max_cpc,omitempty"`
	// An indication on how other advertisers' Shopping ads for similar products
	// are performing based on how often people who see their ad click on it.
	BenchmarkCtr *wrappers.DoubleValue `protobuf:"bytes,77,opt,name=benchmark_ctr,json=benchmarkCtr,proto3" json:"benchmark_ctr,omitempty"`
	// Percentage of clicks where the user only visited a single page on your
	// site. Imported from Google Analytics.
	BounceRate *wrappers.DoubleValue `protobuf:"bytes,15,opt,name=bounce_rate,json=bounceRate,proto3" json:"bounce_rate,omitempty"`
	// The number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,19,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// The number of times your ad or your site's listing in the unpaid
	// results was clicked. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	CombinedClicks *wrappers.Int64Value `protobuf:"bytes,115,opt,name=combined_clicks,json=combinedClicks,proto3" json:"combined_clicks,omitempty"`
	// The number of times your ad or your site's listing in the unpaid
	// results was clicked (combined_clicks) divided by combined_queries. See the
	// help page at https://support.google.com/google-ads/answer/3097241 for
	// details.
	CombinedClicksPerQuery *wrappers.DoubleValue `protobuf:"bytes,116,opt,name=combined_clicks_per_query,json=combinedClicksPerQuery,proto3" json:"combined_clicks_per_query,omitempty"`
	// The number of searches that returned pages from your site in the unpaid
	// results or showed one of your text ads. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	CombinedQueries *wrappers.Int64Value `protobuf:"bytes,117,opt,name=combined_queries,json=combinedQueries,proto3" json:"combined_queries,omitempty"`
	// The estimated percent of times that your ad was eligible to show
	// on the Display Network but didn't because your budget was too low.
	// Note: Content budget lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,20,opt,name=content_budget_lost_impression_share,json=contentBudgetLostImpressionShare,proto3" json:"content_budget_lost_impression_share,omitempty"`
	// The impressions you've received on the Display Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Content impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	ContentImpressionShare *wrappers.DoubleValue `protobuf:"bytes,21,opt,name=content_impression_share,json=contentImpressionShare,proto3" json:"content_impression_share,omitempty"`
	// The last date/time a conversion tag for this conversion action successfully
	// fired and was seen by Google Ads. This firing event may not have been the
	// result of an attributable conversion (e.g. because the tag was fired from a
	// browser that did not previously click an ad from an appropriate
	// advertiser). The date/time is in the customer's time zone.
	ConversionLastReceivedRequestDateTime *wrappers.StringValue `protobuf:"bytes,73,opt,name=conversion_last_received_request_date_time,json=conversionLastReceivedRequestDateTime,proto3" json:"conversion_last_received_request_date_time,omitempty"`
	// The date of the most recent conversion for this conversion action. The date
	// is in the customer's time zone.
	ConversionLastConversionDate *wrappers.StringValue `protobuf:"bytes,74,opt,name=conversion_last_conversion_date,json=conversionLastConversionDate,proto3" json:"conversion_last_conversion_date,omitempty"`
	// The estimated percentage of impressions on the Display Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Content rank lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,22,opt,name=content_rank_lost_impression_share,json=contentRankLostImpressionShare,proto3" json:"content_rank_lost_impression_share,omitempty"`
	// Conversions from interactions divided by the number of ad interactions
	// (such as clicks for text ads or views for video ads). This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	ConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,69,opt,name=conversions_from_interactions_rate,json=conversionsFromInteractionsRate,proto3" json:"conversions_from_interactions_rate,omitempty"`
	// The total value of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsValue *wrappers.DoubleValue `protobuf:"bytes,70,opt,name=conversions_value,json=conversionsValue,proto3" json:"conversions_value,omitempty"`
	// The value of conversions divided by the cost of ad interactions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,71,opt,name=conversions_value_per_cost,json=conversionsValuePerCost,proto3" json:"conversions_value_per_cost,omitempty"`
	// The value of conversions from interactions divided by the number of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,72,opt,name=conversions_from_interactions_value_per_interaction,json=conversionsFromInteractionsValuePerInteraction,proto3" json:"conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,25,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// The sum of your cost-per-click (CPC) and cost-per-thousand impressions
	// (CPM) costs during this period.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,26,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// The cost of ad interactions divided by all conversions.
	CostPerAllConversions *wrappers.DoubleValue `protobuf:"bytes,68,opt,name=cost_per_all_conversions,json=costPerAllConversions,proto3" json:"cost_per_all_conversions,omitempty"`
	// The cost of ad interactions divided by conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CostPerConversion *wrappers.DoubleValue `protobuf:"bytes,28,opt,name=cost_per_conversion,json=costPerConversion,proto3" json:"cost_per_conversion,omitempty"`
	// The cost of ad interactions divided by current model attributed
	// conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CostPerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,106,opt,name=cost_per_current_model_attributed_conversion,json=costPerCurrentModelAttributedConversion,proto3" json:"cost_per_current_model_attributed_conversion,omitempty"`
	// Conversions from when a customer clicks on a Google Ads ad on one device,
	// then converts on a different device or browser.
	// Cross-device conversions are already included in all_conversions.
	CrossDeviceConversions *wrappers.DoubleValue `protobuf:"bytes,29,opt,name=cross_device_conversions,json=crossDeviceConversions,proto3" json:"cross_device_conversions,omitempty"`
	// The number of clicks your ad receives (Clicks) divided by the number
	// of times your ad is shown (Impressions).
	Ctr *wrappers.DoubleValue `protobuf:"bytes,30,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// Shows how your historic conversions data would look under the attribution
	// model you've currently selected. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversions *wrappers.DoubleValue `protobuf:"bytes,101,opt,name=current_model_attributed_conversions,json=currentModelAttributedConversions,proto3" json:"current_model_attributed_conversions,omitempty"`
	// Current model attributed conversions from interactions divided by the
	// number of ad interactions (such as clicks for text ads or views for video
	// ads). This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,102,opt,name=current_model_attributed_conversions_from_interactions_rate,json=currentModelAttributedConversionsFromInteractionsRate,proto3" json:"current_model_attributed_conversions_from_interactions_rate,omitempty"`
	// The value of current model attributed conversions from interactions divided
	// by the number of ad interactions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,103,opt,name=current_model_attributed_conversions_from_interactions_value_per_interaction,json=currentModelAttributedConversionsFromInteractionsValuePerInteraction,proto3" json:"current_model_attributed_conversions_from_interactions_value_per_interaction,omitempty"`
	// The total value of current model attributed conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CurrentModelAttributedConversionsValue *wrappers.DoubleValue `protobuf:"bytes,104,opt,name=current_model_attributed_conversions_value,json=currentModelAttributedConversionsValue,proto3" json:"current_model_attributed_conversions_value,omitempty"`
	// The value of current model attributed conversions divided by the cost of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,105,opt,name=current_model_attributed_conversions_value_per_cost,json=currentModelAttributedConversionsValuePerCost,proto3" json:"current_model_attributed_conversions_value_per_cost,omitempty"`
	// How often people engage with your ad after it's shown to them. This is the
	// number of ad expansions divided by the number of times your ad is shown.
	EngagementRate *wrappers.DoubleValue `protobuf:"bytes,31,opt,name=engagement_rate,json=engagementRate,proto3" json:"engagement_rate,omitempty"`
	// The number of engagements.
	// An engagement occurs when a viewer expands your Lightbox ad. Also, in the
	// future, other ad types may support engagement metrics.
	Engagements *wrappers.Int64Value `protobuf:"bytes,32,opt,name=engagements,proto3" json:"engagements,omitempty"`
	// Average lead value of hotel.
	HotelAverageLeadValueMicros *wrappers.DoubleValue `protobuf:"bytes,75,opt,name=hotel_average_lead_value_micros,json=hotelAverageLeadValueMicros,proto3" json:"hotel_average_lead_value_micros,omitempty"`
	// The creative historical quality score.
	HistoricalCreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,80,opt,name=historical_creative_quality_score,json=historicalCreativeQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_creative_quality_score,omitempty"`
	// The quality of historical landing page experience.
	HistoricalLandingPageQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,81,opt,name=historical_landing_page_quality_score,json=historicalLandingPageQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_landing_page_quality_score,omitempty"`
	// The historical quality score.
	HistoricalQualityScore *wrappers.Int64Value `protobuf:"bytes,82,opt,name=historical_quality_score,json=historicalQualityScore,proto3" json:"historical_quality_score,omitempty"`
	// The historical search predicted click through rate (CTR).
	HistoricalSearchPredictedCtr enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,83,opt,name=historical_search_predicted_ctr,json=historicalSearchPredictedCtr,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_search_predicted_ctr,omitempty"`
	// The number of times the ad was forwarded to someone else as a message.
	GmailForwards *wrappers.Int64Value `protobuf:"bytes,85,opt,name=gmail_forwards,json=gmailForwards,proto3" json:"gmail_forwards,omitempty"`
	// The number of times someone has saved your Gmail ad to their inbox as a
	// message.
	GmailSaves *wrappers.Int64Value `protobuf:"bytes,86,opt,name=gmail_saves,json=gmailSaves,proto3" json:"gmail_saves,omitempty"`
	// The number of clicks to the landing page on the expanded state of Gmail
	// ads.
	GmailSecondaryClicks *wrappers.Int64Value `protobuf:"bytes,87,opt,name=gmail_secondary_clicks,json=gmailSecondaryClicks,proto3" json:"gmail_secondary_clicks,omitempty"`
	// Number of unique cookies that were exposed to your ad over a given time
	// period.
	ImpressionReach *wrappers.Int64Value `protobuf:"bytes,36,opt,name=impression_reach,json=impressionReach,proto3" json:"impression_reach,omitempty"`
	// The number of times a store's location-based ad was shown.
	// This metric applies to feed items only.
	ImpressionsFromStoreReach *wrappers.Int64Value `protobuf:"bytes,125,opt,name=impressions_from_store_reach,json=impressionsFromStoreReach,proto3" json:"impressions_from_store_reach,omitempty"`
	// Count of how often your ad has appeared on a search results page or
	// website on the Google Network.
	Impressions *wrappers.Int64Value `protobuf:"bytes,37,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// How often people interact with your ad after it is shown to them.
	// This is the number of interactions divided by the number of times your ad
	// is shown.
	InteractionRate *wrappers.DoubleValue `protobuf:"bytes,38,opt,name=interaction_rate,json=interactionRate,proto3" json:"interaction_rate,omitempty"`
	// The number of interactions.
	// An interaction is the main user action associated with an ad format-clicks
	// for text and shopping ads, views for video ads, and so on.
	Interactions *wrappers.Int64Value `protobuf:"bytes,39,opt,name=interactions,proto3" json:"interactions,omitempty"`
	// The types of payable and free interactions.
	InteractionEventTypes []enums.InteractionEventTypeEnum_InteractionEventType `protobuf:"varint,100,rep,packed,name=interaction_event_types,json=interactionEventTypes,proto3,enum=google.ads.googleads.v1.enums.InteractionEventTypeEnum_InteractionEventType" json:"interaction_event_types,omitempty"`
	// The percentage of clicks filtered out of your total number of clicks
	// (filtered + non-filtered clicks) during the reporting period.
	InvalidClickRate *wrappers.DoubleValue `protobuf:"bytes,40,opt,name=invalid_click_rate,json=invalidClickRate,proto3" json:"invalid_click_rate,omitempty"`
	// Number of clicks Google considers illegitimate and doesn't charge you for.
	InvalidClicks *wrappers.Int64Value `protobuf:"bytes,41,opt,name=invalid_clicks,json=invalidClicks,proto3" json:"invalid_clicks,omitempty"`
	// The percentage of mobile clicks that go to a mobile-friendly page.
	MobileFriendlyClicksPercentage *wrappers.DoubleValue `protobuf:"bytes,109,opt,name=mobile_friendly_clicks_percentage,json=mobileFriendlyClicksPercentage,proto3" json:"mobile_friendly_clicks_percentage,omitempty"`
	// The number of times someone clicked your site's listing in the unpaid
	// results for a particular query. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicClicks *wrappers.Int64Value `protobuf:"bytes,110,opt,name=organic_clicks,json=organicClicks,proto3" json:"organic_clicks,omitempty"`
	// The number of times someone clicked your site's listing in the unpaid
	// results (organic_clicks) divided by the total number of searches that
	// returned pages from your site (organic_queries). See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicClicksPerQuery *wrappers.DoubleValue `protobuf:"bytes,111,opt,name=organic_clicks_per_query,json=organicClicksPerQuery,proto3" json:"organic_clicks_per_query,omitempty"`
	// The number of listings for your site in the unpaid search results. See the
	// help page at https://support.google.com/google-ads/answer/3097241 for
	// details.
	OrganicImpressions *wrappers.Int64Value `protobuf:"bytes,112,opt,name=organic_impressions,json=organicImpressions,proto3" json:"organic_impressions,omitempty"`
	// The number of times a page from your site was listed in the unpaid search
	// results (organic_impressions) divided by the number of searches returning
	// your site's listing in the unpaid results (organic_queries). See the help
	// page at https://support.google.com/google-ads/answer/3097241 for details.
	OrganicImpressionsPerQuery *wrappers.DoubleValue `protobuf:"bytes,113,opt,name=organic_impressions_per_query,json=organicImpressionsPerQuery,proto3" json:"organic_impressions_per_query,omitempty"`
	// The total number of searches that returned your site's listing in the
	// unpaid results. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicQueries *wrappers.Int64Value `protobuf:"bytes,114,opt,name=organic_queries,json=organicQueries,proto3" json:"organic_queries,omitempty"`
	// Percentage of first-time sessions (from people who had never visited your
	// site before). Imported from Google Analytics.
	PercentNewVisitors *wrappers.DoubleValue `protobuf:"bytes,42,opt,name=percent_new_visitors,json=percentNewVisitors,proto3" json:"percent_new_visitors,omitempty"`
	// Number of offline phone calls.
	PhoneCalls *wrappers.Int64Value `protobuf:"bytes,43,opt,name=phone_calls,json=phoneCalls,proto3" json:"phone_calls,omitempty"`
	// Number of offline phone impressions.
	PhoneImpressions *wrappers.Int64Value `protobuf:"bytes,44,opt,name=phone_impressions,json=phoneImpressions,proto3" json:"phone_impressions,omitempty"`
	// Number of phone calls received (phone_calls) divided by the number of
	// times your phone number is shown (phone_impressions).
	PhoneThroughRate *wrappers.DoubleValue `protobuf:"bytes,45,opt,name=phone_through_rate,json=phoneThroughRate,proto3" json:"phone_through_rate,omitempty"`
	// Your clickthrough rate (Ctr) divided by the average clickthrough rate of
	// all advertisers on the websites that show your ads. Measures how your ads
	// perform on Display Network sites compared to other ads on the same sites.
	RelativeCtr *wrappers.DoubleValue `protobuf:"bytes,46,opt,name=relative_ctr,json=relativeCtr,proto3" json:"relative_ctr,omitempty"`
	// The percentage of the customer's Shopping or Search ad impressions that are
	// shown in the most prominent Shopping position. See
	// <a href="https://support.google.com/adwords/answer/7501826">this Merchant
	// Center article</a> for details. Any value below 0.1 is reported as 0.0999.
	SearchAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,78,opt,name=search_absolute_top_impression_share,json=searchAbsoluteTopImpressionShare,proto3" json:"search_absolute_top_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to a low budget. Note: Search
	// budget lost absolute top impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchBudgetLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,88,opt,name=search_budget_lost_absolute_top_impression_share,json=searchBudgetLostAbsoluteTopImpressionShare,proto3" json:"search_budget_lost_absolute_top_impression_share,omitempty"`
	// The estimated percent of times that your ad was eligible to show on the
	// Search Network but didn't because your budget was too low. Note: Search
	// budget lost impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,47,opt,name=search_budget_lost_impression_share,json=searchBudgetLostImpressionShare,proto3" json:"search_budget_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to a low budget. Note: Search
	// budget lost top impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,89,opt,name=search_budget_lost_top_impression_share,json=searchBudgetLostTopImpressionShare,proto3" json:"search_budget_lost_top_impression_share,omitempty"`
	// The number of clicks you've received on the Search Network
	// divided by the estimated number of clicks you were eligible to receive.
	// Note: Search click share is reported in the range of 0.1 to 1. Any value
	// below 0.1 is reported as 0.0999.
	SearchClickShare *wrappers.DoubleValue `protobuf:"bytes,48,opt,name=search_click_share,json=searchClickShare,proto3" json:"search_click_share,omitempty"`
	// The impressions you've received divided by the estimated number of
	// impressions you were eligible to receive on the Search Network for search
	// terms that matched your keywords exactly (or were close variants of your
	// keyword), regardless of your keyword match types. Note: Search exact match
	// impression share is reported in the range of 0.1 to 1. Any value below 0.1
	// is reported as 0.0999.
	SearchExactMatchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,49,opt,name=search_exact_match_impression_share,json=searchExactMatchImpressionShare,proto3" json:"search_exact_match_impression_share,omitempty"`
	// The impressions you've received on the Search Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Search impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,50,opt,name=search_impression_share,json=searchImpressionShare,proto3" json:"search_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost absolute top impression share is reported in the
	// range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,90,opt,name=search_rank_lost_absolute_top_impression_share,json=searchRankLostAbsoluteTopImpressionShare,proto3" json:"search_rank_lost_absolute_top_impression_share,omitempty"`
	// The estimated percentage of impressions on the Search Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Search rank lost impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,51,opt,name=search_rank_lost_impression_share,json=searchRankLostImpressionShare,proto3" json:"search_rank_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost top impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,91,opt,name=search_rank_lost_top_impression_share,json=searchRankLostTopImpressionShare,proto3" json:"search_rank_lost_top_impression_share,omitempty"`
	// The impressions you've received in the top location (anywhere above the
	// organic search results) compared to the estimated number of impressions you
	// were eligible to receive in the top location.
	// Note: Search top impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,92,opt,name=search_top_impression_share,json=searchTopImpressionShare,proto3" json:"search_top_impression_share,omitempty"`
	// A measure of how quickly your page loads after clicks on your mobile ads.
	// The score is a range from 1 to 10, 10 being the fastest.
	SpeedScore *wrappers.Int64Value `protobuf:"bytes,107,opt,name=speed_score,json=speedScore,proto3" json:"speed_score,omitempty"`
	// The percent of your ad impressions that are shown anywhere above the
	// organic search results.
	TopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,93,opt,name=top_impression_percentage,json=topImpressionPercentage,proto3" json:"top_impression_percentage,omitempty"`
	// The percentage of ad clicks to Accelerated Mobile Pages (AMP) landing pages
	// that reach a valid AMP page.
	ValidAcceleratedMobilePagesClicksPercentage *wrappers.DoubleValue `protobuf:"bytes,108,opt,name=valid_accelerated_mobile_pages_clicks_percentage,json=validAcceleratedMobilePagesClicksPercentage,proto3" json:"valid_accelerated_mobile_pages_clicks_percentage,omitempty"`
	// The value of all conversions divided by the number of all conversions.
	ValuePerAllConversions *wrappers.DoubleValue `protobuf:"bytes,52,opt,name=value_per_all_conversions,json=valuePerAllConversions,proto3" json:"value_per_all_conversions,omitempty"`
	// The value of conversions divided by the number of conversions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ValuePerConversion *wrappers.DoubleValue `protobuf:"bytes,53,opt,name=value_per_conversion,json=valuePerConversion,proto3" json:"value_per_conversion,omitempty"`
	// The value of current model attributed conversions divided by the number of
	// the conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ValuePerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,94,opt,name=value_per_current_model_attributed_conversion,json=valuePerCurrentModelAttributedConversion,proto3" json:"value_per_current_model_attributed_conversion,omitempty"`
	// Percentage of impressions where the viewer watched all of your video.
	VideoQuartile_100Rate *wrappers.DoubleValue `protobuf:"bytes,54,opt,name=video_quartile_100_rate,json=videoQuartile100Rate,proto3" json:"video_quartile_100_rate,omitempty"`
	// Percentage of impressions where the viewer watched 25% of your video.
	VideoQuartile_25Rate *wrappers.DoubleValue `protobuf:"bytes,55,opt,name=video_quartile_25_rate,json=videoQuartile25Rate,proto3" json:"video_quartile_25_rate,omitempty"`
	// Percentage of impressions where the viewer watched 50% of your video.
	VideoQuartile_50Rate *wrappers.DoubleValue `protobuf:"bytes,56,opt,name=video_quartile_50_rate,json=videoQuartile50Rate,proto3" json:"video_quartile_50_rate,omitempty"`
	// Percentage of impressions where the viewer watched 75% of your video.
	VideoQuartile_75Rate *wrappers.DoubleValue `protobuf:"bytes,57,opt,name=video_quartile_75_rate,json=videoQuartile75Rate,proto3" json:"video_quartile_75_rate,omitempty"`
	// The number of views your TrueView video ad receives divided by its number
	// of impressions, including thumbnail impressions for TrueView in-display
	// ads.
	VideoViewRate *wrappers.DoubleValue `protobuf:"bytes,58,opt,name=video_view_rate,json=videoViewRate,proto3" json:"video_view_rate,omitempty"`
	// The number of times your video ads were viewed.
	VideoViews *wrappers.Int64Value `protobuf:"bytes,59,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	// The total number of view-through conversions.
	// These happen when a customer sees an image or rich media ad, then later
	// completes a conversion on your site without interacting with (e.g.,
	// clicking on) another ad.
	ViewThroughConversions *wrappers.Int64Value `protobuf:"bytes,60,opt,name=view_through_conversions,json=viewThroughConversions,proto3" json:"view_through_conversions,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_1ce737312db00b98, []int{0}
}

func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (m *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(m, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetAbsoluteTopImpressionPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.AbsoluteTopImpressionPercentage
	}
	return nil
}

func (m *Metrics) GetActiveViewCpm() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewCpm
	}
	return nil
}

func (m *Metrics) GetActiveViewCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewCtr
	}
	return nil
}

func (m *Metrics) GetActiveViewImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewImpressions
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurability() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewMeasurability
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurableCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewMeasurableCostMicros
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurableImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewMeasurableImpressions
	}
	return nil
}

func (m *Metrics) GetActiveViewViewability() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewViewability
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetAllConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsValue
	}
	return nil
}

func (m *Metrics) GetAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversions
	}
	return nil
}

func (m *Metrics) GetAllConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromClickToCall() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromClickToCall
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromDirections() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromDirections
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromMenu() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromMenu
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromOrder() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromOrder
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromOtherEngagement() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromOtherEngagement
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromStoreVisit() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromStoreVisit
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromStoreWebsite() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromStoreWebsite
	}
	return nil
}

func (m *Metrics) GetAverageCost() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCost
	}
	return nil
}

func (m *Metrics) GetAverageCpc() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpc
	}
	return nil
}

func (m *Metrics) GetAverageCpe() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpe
	}
	return nil
}

func (m *Metrics) GetAverageCpm() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpm
	}
	return nil
}

func (m *Metrics) GetAverageCpv() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpv
	}
	return nil
}

func (m *Metrics) GetAverageFrequency() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageFrequency
	}
	return nil
}

func (m *Metrics) GetAveragePageViews() *wrappers.DoubleValue {
	if m != nil {
		return m.AveragePageViews
	}
	return nil
}

func (m *Metrics) GetAveragePosition() *wrappers.DoubleValue {
	if m != nil {
		return m.AveragePosition
	}
	return nil
}

func (m *Metrics) GetAverageTimeOnSite() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageTimeOnSite
	}
	return nil
}

func (m *Metrics) GetBenchmarkAverageMaxCpc() *wrappers.DoubleValue {
	if m != nil {
		return m.BenchmarkAverageMaxCpc
	}
	return nil
}

func (m *Metrics) GetBenchmarkCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.BenchmarkCtr
	}
	return nil
}

func (m *Metrics) GetBounceRate() *wrappers.DoubleValue {
	if m != nil {
		return m.BounceRate
	}
	return nil
}

func (m *Metrics) GetClicks() *wrappers.Int64Value {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *Metrics) GetCombinedClicks() *wrappers.Int64Value {
	if m != nil {
		return m.CombinedClicks
	}
	return nil
}

func (m *Metrics) GetCombinedClicksPerQuery() *wrappers.DoubleValue {
	if m != nil {
		return m.CombinedClicksPerQuery
	}
	return nil
}

func (m *Metrics) GetCombinedQueries() *wrappers.Int64Value {
	if m != nil {
		return m.CombinedQueries
	}
	return nil
}

func (m *Metrics) GetContentBudgetLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentBudgetLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetContentImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentImpressionShare
	}
	return nil
}

func (m *Metrics) GetConversionLastReceivedRequestDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ConversionLastReceivedRequestDateTime
	}
	return nil
}

func (m *Metrics) GetConversionLastConversionDate() *wrappers.StringValue {
	if m != nil {
		return m.ConversionLastConversionDate
	}
	return nil
}

func (m *Metrics) GetContentRankLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentRankLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsValue
	}
	return nil
}

func (m *Metrics) GetConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *Metrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *Metrics) GetCostPerAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerAllConversions
	}
	return nil
}

func (m *Metrics) GetCostPerConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerConversion
	}
	return nil
}

func (m *Metrics) GetCostPerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerCurrentModelAttributedConversion
	}
	return nil
}

func (m *Metrics) GetCrossDeviceConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CrossDeviceConversions
	}
	return nil
}

func (m *Metrics) GetCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.Ctr
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversions
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsValue
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetEngagementRate() *wrappers.DoubleValue {
	if m != nil {
		return m.EngagementRate
	}
	return nil
}

func (m *Metrics) GetEngagements() *wrappers.Int64Value {
	if m != nil {
		return m.Engagements
	}
	return nil
}

func (m *Metrics) GetHotelAverageLeadValueMicros() *wrappers.DoubleValue {
	if m != nil {
		return m.HotelAverageLeadValueMicros
	}
	return nil
}

func (m *Metrics) GetHistoricalCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalCreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetHistoricalLandingPageQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalLandingPageQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetHistoricalQualityScore() *wrappers.Int64Value {
	if m != nil {
		return m.HistoricalQualityScore
	}
	return nil
}

func (m *Metrics) GetHistoricalSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalSearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetGmailForwards() *wrappers.Int64Value {
	if m != nil {
		return m.GmailForwards
	}
	return nil
}

func (m *Metrics) GetGmailSaves() *wrappers.Int64Value {
	if m != nil {
		return m.GmailSaves
	}
	return nil
}

func (m *Metrics) GetGmailSecondaryClicks() *wrappers.Int64Value {
	if m != nil {
		return m.GmailSecondaryClicks
	}
	return nil
}

func (m *Metrics) GetImpressionReach() *wrappers.Int64Value {
	if m != nil {
		return m.ImpressionReach
	}
	return nil
}

func (m *Metrics) GetImpressionsFromStoreReach() *wrappers.Int64Value {
	if m != nil {
		return m.ImpressionsFromStoreReach
	}
	return nil
}

func (m *Metrics) GetImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *Metrics) GetInteractionRate() *wrappers.DoubleValue {
	if m != nil {
		return m.InteractionRate
	}
	return nil
}

func (m *Metrics) GetInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.Interactions
	}
	return nil
}

func (m *Metrics) GetInteractionEventTypes() []enums.InteractionEventTypeEnum_InteractionEventType {
	if m != nil {
		return m.InteractionEventTypes
	}
	return nil
}

func (m *Metrics) GetInvalidClickRate() *wrappers.DoubleValue {
	if m != nil {
		return m.InvalidClickRate
	}
	return nil
}

func (m *Metrics) GetInvalidClicks() *wrappers.Int64Value {
	if m != nil {
		return m.InvalidClicks
	}
	return nil
}

func (m *Metrics) GetMobileFriendlyClicksPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.MobileFriendlyClicksPercentage
	}
	return nil
}

func (m *Metrics) GetOrganicClicks() *wrappers.Int64Value {
	if m != nil {
		return m.OrganicClicks
	}
	return nil
}

func (m *Metrics) GetOrganicClicksPerQuery() *wrappers.DoubleValue {
	if m != nil {
		return m.OrganicClicksPerQuery
	}
	return nil
}

func (m *Metrics) GetOrganicImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.OrganicImpressions
	}
	return nil
}

func (m *Metrics) GetOrganicImpressionsPerQuery() *wrappers.DoubleValue {
	if m != nil {
		return m.OrganicImpressionsPerQuery
	}
	return nil
}

func (m *Metrics) GetOrganicQueries() *wrappers.Int64Value {
	if m != nil {
		return m.OrganicQueries
	}
	return nil
}

func (m *Metrics) GetPercentNewVisitors() *wrappers.DoubleValue {
	if m != nil {
		return m.PercentNewVisitors
	}
	return nil
}

func (m *Metrics) GetPhoneCalls() *wrappers.Int64Value {
	if m != nil {
		return m.PhoneCalls
	}
	return nil
}

func (m *Metrics) GetPhoneImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.PhoneImpressions
	}
	return nil
}

func (m *Metrics) GetPhoneThroughRate() *wrappers.DoubleValue {
	if m != nil {
		return m.PhoneThroughRate
	}
	return nil
}

func (m *Metrics) GetRelativeCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.RelativeCtr
	}
	return nil
}

func (m *Metrics) GetSearchAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchClickShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchClickShare
	}
	return nil
}

func (m *Metrics) GetSearchExactMatchImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchExactMatchImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSpeedScore() *wrappers.Int64Value {
	if m != nil {
		return m.SpeedScore
	}
	return nil
}

func (m *Metrics) GetTopImpressionPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.TopImpressionPercentage
	}
	return nil
}

func (m *Metrics) GetValidAcceleratedMobilePagesClicksPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.ValidAcceleratedMobilePagesClicksPercentage
	}
	return nil
}

func (m *Metrics) GetValuePerAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerAllConversions
	}
	return nil
}

func (m *Metrics) GetValuePerConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerConversion
	}
	return nil
}

func (m *Metrics) GetValuePerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerCurrentModelAttributedConversion
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_100Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_100Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_25Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_25Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_50Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_50Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_75Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_75Rate
	}
	return nil
}

func (m *Metrics) GetVideoViewRate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoViewRate
	}
	return nil
}

func (m *Metrics) GetVideoViews() *wrappers.Int64Value {
	if m != nil {
		return m.VideoViews
	}
	return nil
}

func (m *Metrics) GetViewThroughConversions() *wrappers.Int64Value {
	if m != nil {
		return m.ViewThroughConversions
	}
	return nil
}

func init() {
	proto.RegisterType((*Metrics)(nil), "google.ads.googleads.v1.common.Metrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/metrics.proto", fileDescriptor_1ce737312db00b98)
}

var fileDescriptor_1ce737312db00b98 = []byte{
	// 2556 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x9a, 0xdb, 0x72, 0x14, 0xc7,
	0x19, 0xc7, 0x6b, 0x21, 0x65, 0x27, 0x9f, 0x40, 0xc2, 0x83, 0x80, 0x96, 0x2c, 0x4b, 0x42, 0x01,
	0x43, 0x30, 0xac, 0x0e, 0x58, 0xc6, 0x11, 0x60, 0xd7, 0xea, 0x04, 0x22, 0x12, 0xe8, 0x84, 0x04,
	0xb6, 0x92, 0x71, 0xef, 0x4c, 0x6b, 0x77, 0xac, 0x39, 0x2c, 0xdd, 0xbd, 0x2b, 0x14, 0xc7, 0xb9,
	0x48, 0x72, 0x91, 0x5c, 0x25, 0x55, 0xb9, 0x49, 0xe5, 0x32, 0x97, 0x79, 0x82, 0x3c, 0x43, 0x9e,
	0x21, 0xf7, 0xa9, 0xca, 0x53, 0xa4, 0xfa, 0x30, 0x33, 0xbd, 0xbb, 0xb3, 0xda, 0x16, 0xe5, 0x1b,
	0x58, 0x86, 0xfe, 0xff, 0xfe, 0xdf, 0xf4, 0xf4, 0xe1, 0xeb, 0x6f, 0x06, 0xee, 0xd6, 0x92, 0xa4,
	0x16, 0x92, 0x69, 0xec, 0xb3, 0x69, 0xf5, 0x53, 0xfc, 0x6a, 0xcd, 0x4e, 0x7b, 0x49, 0x14, 0x25,
	0xf1, 0x74, 0x44, 0x38, 0x0d, 0x3c, 0x56, 0x6e, 0xd0, 0x84, 0x27, 0xce, 0xb8, 0x6a, 0x52, 0xc6,
	0x3e, 0x2b, 0x67, 0xad, 0xcb, 0xad, 0xd9, 0xb2, 0x6a, 0x3d, 0xba, 0xd0, 0x8b, 0x46, 0xe2, 0x66,
	0xc4, 0xa6, 0x83, 0x98, 0x13, 0x8a, 0x3d, 0x1e, 0x24, 0xb1, 0x4b, 0x5a, 0x24, 0xe6, 0x2e, 0x3f,
	0x69, 0x10, 0xc5, 0x1e, 0xfd, 0xfc, 0x74, 0xed, 0x9b, 0x26, 0x0e, 0x03, 0x7e, 0xe2, 0x32, 0x2f,
	0xa1, 0xc4, 0xad, 0x36, 0xbd, 0x23, 0xc2, 0xb5, 0x72, 0x2c, 0x55, 0x36, 0x82, 0x69, 0x1c, 0xc7,
	0x09, 0xc7, 0xc2, 0x41, 0xc7, 0x3c, 0xaa, 0x63, 0x9e, 0x96, 0xff, 0xaa, 0x36, 0x0f, 0xa7, 0x8f,
	0x29, 0x6e, 0x34, 0x08, 0xd5, 0xff, 0x3f, 0xf5, 0x9f, 0xe7, 0xf0, 0xfe, 0x86, 0xba, 0x4b, 0x27,
	0x80, 0x29, 0x5c, 0x65, 0x49, 0xd8, 0xe4, 0xc4, 0xe5, 0x49, 0xc3, 0x0d, 0xa2, 0x06, 0x25, 0x8c,
	0x89, 0x78, 0x1b, 0x84, 0x7a, 0x24, 0xe6, 0xb8, 0x46, 0x90, 0x3b, 0x59, 0xba, 0x3d, 0x30, 0x37,
	0xa6, 0x7b, 0xa0, 0x9c, 0x82, 0xcb, 0xcb, 0x49, 0xb3, 0x1a, 0x92, 0x3d, 0x1c, 0x36, 0xc9, 0xf6,
	0x44, 0xca, 0xd9, 0x4d, 0x1a, 0x6b, 0x19, 0x65, 0x33, 0x83, 0x38, 0xcb, 0x30, 0x24, 0x7a, 0xa2,
	0x45, 0xdc, 0x56, 0x40, 0x8e, 0x5d, 0xaf, 0x11, 0xa1, 0x92, 0x05, 0xf7, 0xa2, 0x12, 0xed, 0x05,
	0xe4, 0x78, 0xa9, 0x11, 0x75, 0x51, 0x38, 0x45, 0x2f, 0xce, 0x48, 0xe1, 0xd4, 0xd9, 0x81, 0x6b,
	0x26, 0x25, 0xbf, 0x6b, 0x86, 0xce, 0x49, 0xda, 0x87, 0x5d, 0xb4, 0xb5, 0x98, 0x7f, 0xf6, 0xa9,
	0x82, 0x5d, 0xc9, 0x61, 0xf9, 0x9d, 0x32, 0xe7, 0x15, 0x8c, 0x98, 0xd0, 0x88, 0x60, 0xd6, 0xa4,
	0xb8, 0x1a, 0x88, 0xa7, 0x88, 0xbe, 0xb1, 0x08, 0xf2, 0x5a, 0xce, 0xdd, 0x30, 0xc5, 0x4e, 0x0d,
	0xa6, 0x8a, 0xc8, 0x21, 0x71, 0xbd, 0x84, 0x71, 0x37, 0x0a, 0x3c, 0x9a, 0x30, 0x74, 0xbe, 0x7f,
	0xe4, 0xe3, 0xdd, 0x0e, 0x21, 0x59, 0x4a, 0x18, 0xdf, 0x90, 0x08, 0xa7, 0xde, 0xd3, 0xc8, 0xec,
	0xa2, 0x1f, 0xf5, 0x37, 0x9a, 0x28, 0x32, 0x32, 0x3b, 0x6b, 0xb7, 0xfd, 0x09, 0x88, 0x3f, 0xd2,
	0xae, 0xc2, 0x16, 0x5d, 0x65, 0x3c, 0x82, 0xbd, 0x5c, 0xea, 0x34, 0xe0, 0x63, 0x1c, 0x86, 0xae,
	0x97, 0xc4, 0x2d, 0x42, 0xa5, 0x91, 0x7b, 0x48, 0x93, 0xc8, 0x35, 0xe6, 0x21, 0x73, 0x29, 0xe6,
	0x04, 0x55, 0x2c, 0x4c, 0xa6, 0x70, 0x18, 0x2e, 0xe5, 0xa8, 0x55, 0x9a, 0x44, 0x6b, 0x06, 0x68,
	0x1b, 0x73, 0xe2, 0x6c, 0xc2, 0x95, 0x4e, 0xc7, 0x96, 0x10, 0xa3, 0x45, 0x0b, 0x83, 0xcb, 0xed,
	0x06, 0xf2, 0xa2, 0xb3, 0x02, 0x43, 0x1d, 0x44, 0xf4, 0xbe, 0x05, 0x6b, 0xb0, 0x9d, 0xe5, 0x7c,
	0x03, 0xe3, 0x85, 0x81, 0x89, 0x79, 0x2d, 0x87, 0x0d, 0xfa, 0xc2, 0x82, 0x3a, 0x5a, 0x10, 0xe1,
	0x26, 0xa1, 0x62, 0xc8, 0xc8, 0x51, 0x59, 0xd4, 0xd9, 0x5e, 0x18, 0x78, 0x47, 0x2e, 0x4f, 0x5c,
	0x0f, 0x87, 0x21, 0x6a, 0x59, 0xb8, 0x7c, 0xd4, 0xdd, 0xd1, 0x4b, 0x02, 0xb2, 0x9b, 0x2c, 0xe1,
	0x30, 0x74, 0x3c, 0x98, 0x28, 0x34, 0xf2, 0x03, 0x4a, 0xd4, 0xa3, 0x40, 0xc7, 0x16, 0x2e, 0x63,
	0xdd, 0x2e, 0xcb, 0x19, 0xc1, 0xf9, 0x4b, 0x09, 0x1e, 0xf4, 0x1f, 0x3b, 0x79, 0x17, 0x1a, 0x97,
	0xd1, 0x92, 0x85, 0xfb, 0xec, 0xe9, 0x83, 0x29, 0xed, 0x59, 0xe3, 0x9a, 0xb3, 0x0f, 0x23, 0x85,
	0x11, 0x45, 0x24, 0x6e, 0xa2, 0xb7, 0x16, 0x9e, 0x57, 0xbb, 0x3d, 0x37, 0x48, 0xdc, 0x74, 0x5e,
	0xc3, 0x68, 0x21, 0x38, 0xa1, 0x3e, 0xa1, 0xe8, 0xc4, 0x6a, 0xa9, 0xea, 0x22, 0xbf, 0x10, 0x62,
	0x27, 0x86, 0x9b, 0xc5, 0x68, 0x5e, 0x27, 0xd4, 0x25, 0x71, 0x0d, 0xd7, 0x48, 0x44, 0x62, 0x8e,
	0x7e, 0x6d, 0xe1, 0x72, 0xbd, 0xc0, 0x45, 0x70, 0x56, 0x32, 0x8c, 0xe3, 0xc3, 0x64, 0xa1, 0x1f,
	0xe3, 0x62, 0xd7, 0x6c, 0x05, 0x2c, 0xe0, 0xe8, 0xbb, 0x77, 0x1b, 0x1c, 0x3b, 0x02, 0xb1, 0x27,
	0x08, 0x72, 0x5d, 0xec, 0xed, 0x72, 0x4c, 0xaa, 0x2c, 0xe0, 0x04, 0xfd, 0xc6, 0xc2, 0x67, 0xbc,
	0x87, 0xcf, 0xbe, 0x62, 0x38, 0x5f, 0xc2, 0x05, 0xdc, 0x22, 0x14, 0xd7, 0xd4, 0xda, 0x8e, 0x7e,
	0x6c, 0xc1, 0x1c, 0xd0, 0x0a, 0x39, 0x2b, 0x1f, 0xc3, 0x40, 0x06, 0x68, 0x78, 0xe8, 0x27, 0x16,
	0x7a, 0x48, 0xf5, 0x0d, 0xaf, 0x5d, 0x4e, 0x50, 0xf5, 0x4c, 0x72, 0xd2, 0x2e, 0x8f, 0x10, 0x9c,
	0x49, 0x1e, 0xb5, 0xcb, 0x5b, 0x68, 0xe0, 0x4c, 0xf2, 0x96, 0xb3, 0x06, 0x1f, 0xa4, 0xf2, 0x43,
	0x4a, 0xde, 0x34, 0x49, 0xec, 0x9d, 0xa0, 0x0b, 0x16, 0x90, 0x4b, 0x5a, 0xb6, 0x9a, 0xaa, 0x9c,
	0x67, 0xe0, 0xa4, 0xa8, 0x86, 0xf8, 0x43, 0x6c, 0x50, 0x0c, 0x79, 0x67, 0x60, 0x6d, 0xe2, 0x9a,
	0xdc, 0x9f, 0x98, 0xf3, 0x04, 0x2e, 0x65, 0xac, 0x84, 0x05, 0x72, 0xc9, 0xb8, 0x68, 0x41, 0x1a,
	0x4a, 0x49, 0x5a, 0xe4, 0x6c, 0xc0, 0x70, 0x0a, 0xe2, 0x41, 0x44, 0xdc, 0x24, 0x76, 0xe5, 0xc0,
	0xdb, 0xb5, 0x80, 0xa5, 0x3d, 0xb3, 0x1b, 0x44, 0xe4, 0x45, 0xbc, 0x23, 0xc6, 0xda, 0x3e, 0x8c,
	0x54, 0x49, 0xec, 0xd5, 0x23, 0x4c, 0x8f, 0xdc, 0x14, 0x1c, 0xe1, 0xb7, 0x72, 0xe0, 0x0c, 0xda,
	0xac, 0x2f, 0x99, 0xbc, 0xa2, 0xd4, 0x1b, 0xf8, 0xad, 0x18, 0x44, 0x15, 0xb8, 0x98, 0x83, 0x45,
	0x8a, 0xb6, 0x61, 0x01, 0xbb, 0x90, 0x49, 0x44, 0x86, 0xf6, 0x18, 0x06, 0xaa, 0x49, 0x33, 0xf6,
	0x88, 0xda, 0xae, 0x87, 0x6c, 0x46, 0x82, 0x12, 0xc8, 0x6d, 0xf9, 0x3e, 0xbc, 0x27, 0xb7, 0x21,
	0x86, 0x2e, 0xf7, 0x4f, 0x56, 0x74, 0x53, 0x91, 0x5b, 0x7a, 0x49, 0x54, 0x0d, 0x62, 0xe2, 0xbb,
	0x5a, 0xcd, 0xfa, 0xab, 0x07, 0x53, 0xcd, 0x92, 0xa2, 0xec, 0xc3, 0x48, 0x07, 0x45, 0xee, 0x17,
	0x6f, 0x9a, 0x84, 0x9e, 0x20, 0x6e, 0xd3, 0xab, 0xed, 0xc0, 0x4d, 0x42, 0xb7, 0x84, 0xd6, 0x59,
	0x85, 0x4b, 0x19, 0x58, 0xd0, 0x02, 0xc2, 0x50, 0xb3, 0x7f, 0x7c, 0xd9, 0x3d, 0x6d, 0x29, 0x8d,
	0x13, 0xc2, 0x0d, 0x2f, 0x89, 0xb9, 0x38, 0x8d, 0x54, 0x9b, 0x7e, 0x8d, 0x70, 0x37, 0x14, 0x59,
	0xa4, 0x91, 0xfa, 0xb3, 0x3a, 0xa6, 0x04, 0x0d, 0x5b, 0xc4, 0x3a, 0xa9, 0x49, 0x8b, 0x12, 0xb4,
	0x9e, 0x30, 0x9e, 0x27, 0x79, 0x3b, 0x82, 0xe2, 0xec, 0x01, 0x4a, 0xdd, 0xba, 0x1c, 0xae, 0xd8,
	0xf5, 0x86, 0x54, 0x77, 0x72, 0x8f, 0xe1, 0x4e, 0xbe, 0x1c, 0xbb, 0x21, 0x66, 0xdc, 0xa5, 0xc4,
	0x23, 0x41, 0x8b, 0xf8, 0xae, 0x9c, 0xc5, 0x8c, 0xbb, 0x3e, 0xe6, 0x6a, 0xa6, 0xa0, 0xb5, 0x1e,
	0x4e, 0x3b, 0x9c, 0x06, 0x71, 0x4d, 0x39, 0xdd, 0xcc, 0x79, 0xeb, 0x98, 0xf1, 0x6d, 0x4d, 0xdb,
	0x56, 0xb0, 0x65, 0xcc, 0xe5, 0xdc, 0x11, 0xd9, 0x48, 0xa7, 0xb1, 0xf1, 0x6f, 0x61, 0x89, 0x9e,
	0x59, 0xb8, 0x8d, 0xb5, 0xbb, 0xe5, 0x7b, 0x82, 0x30, 0x12, 0x1b, 0x4e, 0xda, 0x6b, 0x14, 0xc7,
	0x47, 0x3d, 0x9e, 0xd0, 0x55, 0x9b, 0x0d, 0x47, 0x73, 0xb6, 0x71, 0x7c, 0x54, 0xf4, 0x7c, 0x02,
	0xe9, 0xd4, 0x2f, 0x5d, 0x5e, 0xb1, 0x39, 0x01, 0x7a, 0x7d, 0x72, 0xe5, 0x35, 0xf8, 0xa0, 0x3b,
	0x4f, 0x5e, 0xb5, 0x59, 0x52, 0xbd, 0xce, 0x24, 0xf9, 0x35, 0x8c, 0x9e, 0x92, 0xd9, 0x3e, 0xb1,
	0xc9, 0x60, 0xbc, 0x1e, 0x69, 0xed, 0x9f, 0x4a, 0x70, 0xff, 0x5d, 0x92, 0xc0, 0xa7, 0x16, 0xa6,
	0x65, 0xef, 0x6c, 0x19, 0xe0, 0x17, 0x30, 0x60, 0x9e, 0x03, 0x46, 0x6c, 0x92, 0x01, 0x43, 0xe0,
	0x3c, 0x12, 0xfa, 0xfc, 0x84, 0x38, 0xda, 0x7f, 0xb5, 0x00, 0x2f, 0x3f, 0x0d, 0xbe, 0x14, 0x53,
	0x97, 0x71, 0x79, 0xa7, 0x9d, 0x47, 0x92, 0x65, 0x9b, 0x43, 0x9a, 0x50, 0x6f, 0x12, 0x5a, 0x69,
	0x3f, 0x99, 0xac, 0xc3, 0xe5, 0x0c, 0x9b, 0x23, 0xd1, 0x98, 0xcd, 0x26, 0xa6, 0x89, 0x39, 0xce,
	0xf9, 0x0e, 0xee, 0xe6, 0xb4, 0x26, 0xa5, 0x62, 0xca, 0x44, 0x89, 0x4f, 0x42, 0x17, 0x73, 0x4e,
	0x83, 0x6a, 0x93, 0x8b, 0x75, 0x38, 0xb7, 0xf9, 0xd6, 0xc2, 0xe6, 0x56, 0x6a, 0xa3, 0x78, 0x1b,
	0x02, 0x57, 0xc9, 0x68, 0x86, 0xb9, 0x58, 0xdc, 0x68, 0xc2, 0x98, 0xeb, 0x93, 0x56, 0xe0, 0x91,
	0xb6, 0x1e, 0xfa, 0xc8, 0x6a, 0x71, 0x13, 0xea, 0x65, 0x29, 0x36, 0xbb, 0xa8, 0x0c, 0xe7, 0xc5,
	0xb6, 0x39, 0x6e, 0x81, 0x10, 0x0d, 0x9d, 0x08, 0x6e, 0x58, 0xdc, 0x3b, 0x43, 0xc4, 0x26, 0xe9,
	0xf6, 0xfa, 0xdc, 0x35, 0x73, 0xfe, 0x56, 0x82, 0x87, 0x36, 0x7e, 0xbd, 0x56, 0x93, 0x43, 0x8b,
	0x30, 0xe6, 0xfb, 0x86, 0x51, 0xb8, 0xc6, 0xfc, 0xab, 0x04, 0xeb, 0xef, 0x18, 0x5a, 0xf1, 0xb4,
	0xae, 0x59, 0xc4, 0xba, 0x7c, 0xe6, 0x58, 0x8b, 0x26, 0xfb, 0x5b, 0xb8, 0x63, 0x15, 0xb9, 0x5a,
	0x37, 0xeb, 0x16, 0x71, 0x7d, 0xdc, 0x37, 0x2e, 0xb5, 0x9a, 0xfe, 0x51, 0x2c, 0x79, 0xd6, 0xd6,
	0xf9, 0x3a, 0x1b, 0x58, 0xc4, 0x70, 0xcf, 0x2e, 0x86, 0x74, 0xf5, 0x5d, 0x81, 0xa1, 0xfc, 0x90,
	0xa8, 0x46, 0xcb, 0x84, 0x4d, 0xf5, 0x23, 0x17, 0xc9, 0x61, 0xf0, 0x18, 0x06, 0xf2, 0x2b, 0x0c,
	0x4d, 0xf6, 0x5f, 0xf8, 0xcc, 0xf6, 0x4e, 0x15, 0x26, 0xea, 0x09, 0x17, 0xfd, 0xa0, 0xb3, 0xe2,
	0x90, 0x60, 0x5f, 0xdf, 0xbd, 0x5e, 0x4b, 0x7f, 0x61, 0x11, 0xd5, 0x87, 0x12, 0xa2, 0x73, 0xe3,
	0x75, 0x82, 0x7d, 0x79, 0x59, 0xaf, 0xae, 0x7f, 0x2d, 0xc1, 0xf5, 0x7a, 0x20, 0x4e, 0x90, 0x81,
	0x87, 0x43, 0xd7, 0xa3, 0x04, 0xcb, 0x7a, 0x58, 0x5b, 0xdd, 0x17, 0x6d, 0x4e, 0x96, 0x6e, 0x0f,
	0xce, 0x3d, 0x2d, 0xf7, 0xaa, 0x43, 0xcb, 0x5a, 0x71, 0x79, 0x4b, 0x69, 0x76, 0x84, 0x64, 0x51,
	0x56, 0x8a, 0x57, 0xe2, 0x66, 0x54, 0x70, 0x79, 0x7b, 0x3c, 0xb7, 0x5c, 0xd2, 0x8e, 0x66, 0x2b,
	0xe7, 0xef, 0x25, 0xb8, 0x69, 0x44, 0x15, 0xe2, 0xd8, 0x0f, 0xe2, 0x9a, 0x3a, 0x03, 0xb5, 0x47,
	0xb6, 0xf5, 0x03, 0x47, 0x66, 0x74, 0xc6, 0xba, 0x72, 0x15, 0x27, 0xa8, 0xb6, 0xe0, 0x5e, 0x02,
	0x32, 0x62, 0x6b, 0x0f, 0x67, 0xbb, 0xff, 0x23, 0xbe, 0x9a, 0x8b, 0xdb, 0xb0, 0x7f, 0x2e, 0xc1,
	0x84, 0xc1, 0x65, 0x04, 0x53, 0xaf, 0xee, 0x36, 0x28, 0xf1, 0x03, 0x4f, 0xce, 0x00, 0x4e, 0xd1,
	0xce, 0x0f, 0x7c, 0xb7, 0x63, 0xb9, 0xe1, 0x8e, 0xf4, 0xdb, 0x4c, 0xed, 0xc4, 0xe9, 0x67, 0x11,
	0x06, 0x6b, 0x11, 0x0e, 0x42, 0xf7, 0x30, 0xa1, 0xc7, 0x98, 0xfa, 0x0c, 0xbd, 0xec, 0x7f, 0x7b,
	0x17, 0xa5, 0x64, 0x55, 0x2b, 0xc4, 0xde, 0xaf, 0x18, 0x0c, 0xb7, 0x08, 0x43, 0x7b, 0x16, 0x7b,
	0xbf, 0x6c, 0xbf, 0x23, 0x9a, 0x3b, 0x5b, 0x70, 0x55, 0xab, 0x89, 0x97, 0xc4, 0x3e, 0xa6, 0x27,
	0xe9, 0x91, 0x68, 0xbf, 0x3f, 0x68, 0x58, 0x81, 0x52, 0xa5, 0x3e, 0x18, 0xad, 0xc2, 0x25, 0x23,
	0x83, 0xa5, 0x04, 0x7b, 0x75, 0x74, 0xc3, 0xe2, 0xfc, 0x92, 0x8b, 0xb6, 0x85, 0xc6, 0x39, 0x80,
	0x31, 0xa3, 0x1a, 0x6d, 0x16, 0x62, 0x14, 0xf3, 0xfb, 0xfe, 0xcc, 0x11, 0x03, 0x90, 0x95, 0x60,
	0x14, 0xfd, 0x31, 0x0c, 0x98, 0xb5, 0xee, 0x9b, 0x16, 0x2b, 0x87, 0xd1, 0x5e, 0x9c, 0xf5, 0xcd,
	0x97, 0x3e, 0x72, 0x01, 0xfb, 0xd8, 0xe6, 0xac, 0x6f, 0xa8, 0xe4, 0x0a, 0xf6, 0x25, 0x5c, 0x30,
	0x77, 0x27, 0x74, 0xab, 0x7f, 0x20, 0x6d, 0x02, 0xe7, 0x0f, 0x25, 0xb8, 0x56, 0xfc, 0xfe, 0x89,
	0x21, 0x7f, 0xf2, 0xfc, 0xed, 0xc1, 0xb9, 0xf5, 0x3e, 0xa3, 0xd9, 0xd8, 0x9c, 0x56, 0x84, 0x78,
	0xf7, 0xa4, 0x41, 0xe4, 0x78, 0x2e, 0xfa, 0x8f, 0xed, 0x2b, 0x41, 0xc1, 0x55, 0xe6, 0x3c, 0x03,
	0x27, 0x88, 0x5b, 0x38, 0x0c, 0xf4, 0x69, 0x58, 0x75, 0xc9, 0x6d, 0x9b, 0xac, 0x5f, 0xeb, 0xe4,
	0xf0, 0x91, 0x7d, 0xb2, 0x08, 0x83, 0x6d, 0x2c, 0x86, 0x7e, 0x66, 0x31, 0x2d, 0x4c, 0x0c, 0x73,
	0x6a, 0x70, 0x3d, 0x4a, 0xaa, 0x41, 0x48, 0xdc, 0x43, 0x1a, 0x90, 0xd8, 0x0f, 0x4f, 0x8c, 0x53,
	0x7a, 0xfa, 0xc2, 0x2b, 0xb2, 0x39, 0x58, 0x29, 0xcc, 0xaa, 0xa6, 0x64, 0x87, 0xf5, 0xf4, 0x7d,
	0xd7, 0x22, 0x0c, 0x26, 0xb4, 0x86, 0xe3, 0xc0, 0x4b, 0x83, 0x8d, 0x2d, 0x82, 0xd5, 0x12, 0x1d,
	0xec, 0x4b, 0x40, 0xed, 0x0c, 0xa3, 0x94, 0x90, 0xd8, 0x64, 0xe0, 0x6d, 0xb8, 0xac, 0x92, 0xb0,
	0x0e, 0x97, 0x53, 0xac, 0x39, 0xd6, 0x1b, 0xfd, 0xe3, 0x73, 0xb4, 0xce, 0x7c, 0x95, 0xe3, 0xc2,
	0x47, 0x05, 0x34, 0x23, 0xd2, 0x37, 0x36, 0x2f, 0x1a, 0xba, 0xc1, 0x59, 0xb8, 0xcb, 0x30, 0x94,
	0x1a, 0xa4, 0x75, 0x0f, 0x6a, 0x51, 0x97, 0xd1, 0x9a, 0xb4, 0xec, 0xf1, 0x1c, 0x86, 0xf5, 0x13,
	0x76, 0x63, 0xf9, 0xc6, 0x89, 0x05, 0x3c, 0xa1, 0x0c, 0xdd, 0xb1, 0x88, 0xce, 0xd1, 0xca, 0xe7,
	0xe4, 0x78, 0x4f, 0xeb, 0xc4, 0xfa, 0xda, 0xa8, 0x27, 0x31, 0x91, 0xaf, 0x39, 0x18, 0xfa, 0xc4,
	0x62, 0x7d, 0x95, 0xed, 0x97, 0x44, 0x73, 0xe7, 0x29, 0x7c, 0xa0, 0xd4, 0xe6, 0x03, 0xb8, 0xdb,
	0x9f, 0x71, 0x49, 0xaa, 0xcc, 0xee, 0x7f, 0x06, 0x8e, 0x22, 0xf1, 0x3a, 0x4d, 0x9a, 0xb5, 0xba,
	0x9a, 0x60, 0xf7, 0x6c, 0x26, 0x98, 0xd4, 0xed, 0x2a, 0x59, 0xba, 0xe8, 0x50, 0x12, 0xaa, 0x3c,
	0x44, 0xec, 0x7a, 0x65, 0x9b, 0x03, 0x67, 0xaa, 0x10, 0x1b, 0x57, 0x08, 0x37, 0xf4, 0xf6, 0xd9,
	0xeb, 0xb5, 0xb2, 0xaa, 0x5c, 0x3c, 0xb7, 0xa9, 0x2d, 0x29, 0x52, 0xa5, 0xe8, 0xbd, 0xb2, 0xaa,
	0x5d, 0xfc, 0xae, 0x04, 0x33, 0xda, 0xce, 0xac, 0x64, 0x9d, 0x6e, 0xfd, 0xca, 0xc2, 0xfa, 0x8e,
	0xa2, 0xe6, 0x55, 0xad, 0x53, 0x82, 0xf8, 0x16, 0x7e, 0x5a, 0x10, 0x43, 0x97, 0xed, 0xb4, 0x4d,
	0x05, 0xa5, 0xd3, 0xb6, 0xd3, 0xeb, 0x0d, 0xdc, 0x2a, 0xf0, 0x2a, 0xbc, 0xcd, 0xd7, 0x36, 0x2f,
	0x38, 0x3b, 0xfd, 0x0a, 0x6e, 0xef, 0x19, 0x38, 0xda, 0x52, 0x2d, 0xdf, 0x8a, 0x3e, 0x63, 0x33,
	0xbc, 0x94, 0x4e, 0xae, 0x3d, 0x9d, 0x5d, 0x45, 0xde, 0x62, 0x8f, 0xbb, 0x11, 0xe6, 0x5e, 0xbd,
	0x3b, 0xf4, 0x59, 0xfb, 0xae, 0x5a, 0x11, 0x9c, 0x0d, 0x81, 0xe9, 0x8c, 0x7b, 0x17, 0xae, 0x69,
	0xaf, 0x2e, 0xfe, 0x9c, 0xcd, 0xca, 0xa9, 0xc4, 0x9d, 0xd4, 0xdf, 0x42, 0x59, 0x53, 0xf3, 0xb2,
	0xdc, 0xe9, 0xc3, 0xed, 0x2b, 0x0b, 0xb3, 0xdb, 0x8a, 0x99, 0x96, 0xe8, 0x4e, 0x19, 0x6c, 0x87,
	0x70, 0xbd, 0xcb, 0xbf, 0xcb, 0xf2, 0xbe, 0xcd, 0x2b, 0xd7, 0x76, 0xcb, 0x4e, 0x9f, 0x08, 0x6e,
	0x76, 0xf9, 0x14, 0xde, 0xde, 0xd7, 0xf6, 0x13, 0x39, 0xf5, 0x2a, 0xb8, 0xad, 0xaf, 0xe1, 0x43,
	0x6d, 0x57, 0x68, 0x72, 0x60, 0x61, 0x82, 0x14, 0xa0, 0x00, 0xfe, 0x08, 0x06, 0x58, 0x83, 0x10,
	0x5f, 0x1f, 0x14, 0x8e, 0x2c, 0x16, 0x6a, 0xd9, 0x5e, 0x1d, 0x0e, 0x5e, 0xc1, 0x48, 0xef, 0x0f,
	0x63, 0x7e, 0x69, 0x53, 0x68, 0xe4, 0x3d, 0x3e, 0x88, 0xf9, 0x7d, 0x09, 0x66, 0x54, 0x32, 0x83,
	0x3d, 0x8f, 0x84, 0x44, 0xac, 0xdb, 0xbe, 0xab, 0x93, 0x13, 0x71, 0xe0, 0x62, 0x05, 0x99, 0x49,
	0x68, 0xe1, 0xf8, 0x89, 0xa4, 0x56, 0x72, 0xe8, 0x86, 0x64, 0x8a, 0xe3, 0x14, 0xeb, 0x4a, 0x53,
	0xf6, 0x61, 0x24, 0x3f, 0xd5, 0x77, 0x56, 0xf9, 0x3e, 0xb5, 0xa9, 0x61, 0xb5, 0xf4, 0xf9, 0xbd,
	0xa3, 0xcc, 0xf7, 0x1c, 0x86, 0xcd, 0x72, 0x41, 0x56, 0x80, 0x9b, 0xb7, 0xd9, 0x6f, 0x5b, 0x59,
	0x4d, 0x20, 0xab, 0xb5, 0x7d, 0x0f, 0xf7, 0x0c, 0x9e, 0x45, 0xa5, 0xef, 0x57, 0x36, 0x33, 0x2f,
	0x33, 0xea, 0x57, 0xea, 0xdb, 0x81, 0x6b, 0xad, 0xc0, 0x27, 0x89, 0x38, 0x76, 0x52, 0x2e, 0x1e,
	0xd1, 0xec, 0xcc, 0x8c, 0xda, 0x6b, 0x3f, 0xb3, 0x30, 0x1a, 0x96, 0xe2, 0x2d, 0xad, 0x9d, 0x9d,
	0x99, 0x91, 0xfb, 0xed, 0x16, 0x5c, 0xed, 0x80, 0xce, 0xcd, 0x2b, 0xe6, 0x03, 0x9b, 0xcf, 0x47,
	0xda, 0x98, 0x73, 0xf3, 0x3d, 0x90, 0xf3, 0x3a, 0xcc, 0xcf, 0xcf, 0x8c, 0x9c, 0xef, 0x15, 0xe5,
	0x03, 0x1d, 0xe5, 0xcf, 0xcf, 0x8c, 0x7c, 0xa0, 0xa2, 0x5c, 0x86, 0x21, 0x85, 0x94, 0x5f, 0xff,
	0x48, 0xd6, 0x82, 0xcd, 0x67, 0x5c, 0x52, 0xb4, 0x17, 0x90, 0x63, 0x49, 0x79, 0x04, 0x03, 0x39,
	0x85, 0xa1, 0x87, 0x16, 0x33, 0x3b, 0x03, 0xc8, 0xe4, 0x5a, 0xba, 0xa7, 0x79, 0x93, 0x39, 0xf0,
	0x1f, 0x59, 0x54, 0x13, 0x84, 0x58, 0x27, 0x4f, 0xc6, 0xb8, 0x5f, 0xfc, 0x6f, 0x09, 0xa6, 0xbc,
	0x24, 0x2a, 0x9f, 0xfe, 0xe5, 0xe0, 0xe2, 0x05, 0xfd, 0x09, 0xde, 0xa6, 0x40, 0x6f, 0x96, 0xbe,
	0x5a, 0xd6, 0xed, 0x6b, 0x49, 0x88, 0xe3, 0x5a, 0x39, 0xa1, 0xb5, 0xe9, 0x1a, 0x89, 0xa5, 0x71,
	0xfa, 0x75, 0x60, 0x23, 0x60, 0xbd, 0x3e, 0x5b, 0x7c, 0xa8, 0xfe, 0xfa, 0xc7, 0xb9, 0xf3, 0x4f,
	0x2a, 0x95, 0x7f, 0x9e, 0x1b, 0x7f, 0xa2, 0x60, 0x15, 0x9f, 0x95, 0xd5, 0x4f, 0xf1, 0x6b, 0x6f,
	0xb6, 0xbc, 0x24, 0x9b, 0xfd, 0x3b, 0x6d, 0x70, 0x50, 0xf1, 0xd9, 0x41, 0xd6, 0xe0, 0x60, 0x6f,
	0xf6, 0x40, 0x35, 0xf8, 0xdf, 0xb9, 0x29, 0x75, 0x75, 0x61, 0xa1, 0xe2, 0xb3, 0x85, 0x85, 0xac,
	0xc9, 0xc2, 0xc2, 0xde, 0xec, 0xc2, 0x82, 0x6a, 0x54, 0x7d, 0x4f, 0x46, 0x77, 0xff, 0xff, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x00, 0x96, 0x43, 0xb4, 0x53, 0x29, 0x00, 0x00,
}
