// DO NOT EDIT: This file is autogenerated via the builtin command.

package universe

import (
	flux "github.com/influxdata/flux"
	ast "github.com/influxdata/flux/ast"
)

func init() {
	flux.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Errors: nil,
		Loc:    nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Errors: nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 89,
					Line:   314,
				},
				File:   "universe.flux",
				Source: "package universe\n\nimport \"system\"\nimport \"date\"\nimport \"math\"\nimport \"strings\"\nimport \"regexp\"\n\n// now is a function option whose default behaviour is to return the current system time\noption now = system.time\n\n// Booleans\nbuiltin true\nbuiltin false\n\n// Transformation functions\nbuiltin chandeMomentumOscillator\nbuiltin columns\nbuiltin count\nbuiltin covariance\nbuiltin cumulativeSum\nbuiltin derivative\nbuiltin difference\nbuiltin distinct\nbuiltin drop\nbuiltin duplicate\nbuiltin elapsed\nbuiltin exponentialMovingAverage\nbuiltin fill\nbuiltin filter\nbuiltin first\nbuiltin group\nbuiltin histogram\nbuiltin histogramQuantile\nbuiltin holtWinters\nbuiltin hourSelection\nbuiltin integral\nbuiltin join\nbuiltin kaufmansAMA\nbuiltin keep\nbuiltin keyValues\nbuiltin keys\nbuiltin last\nbuiltin limit\nbuiltin map\nbuiltin max\nbuiltin mean\nbuiltin min\nbuiltin mode\nbuiltin movingAverage\nbuiltin quantile\nbuiltin pivot\nbuiltin range\nbuiltin reduce\nbuiltin relativeStrengthIndex\nbuiltin rename\nbuiltin sample\nbuiltin set\nbuiltin tail\nbuiltin timeShift\nbuiltin skew\nbuiltin spread\nbuiltin sort\nbuiltin stateTracking\nbuiltin stddev\nbuiltin sum\nbuiltin tripleExponentialDerivative\nbuiltin union\nbuiltin unique\nbuiltin window\nbuiltin yield\n\n// stream/table index functions\nbuiltin tableFind\nbuiltin getColumn\nbuiltin getRecord\n\n// type conversion functions\nbuiltin bool\nbuiltin bytes\nbuiltin duration\nbuiltin float\nbuiltin int\nbuiltin string\nbuiltin time\nbuiltin uint\n\n// contains function\nbuiltin contains\n\n// other builtins\nbuiltin inf\nbuiltin length // length function for arrays\nbuiltin linearBins\nbuiltin logarithmicBins\nbuiltin sleep // sleep is the identity function with the side effect of delaying execution by a specified duration\n\n// covariance function with automatic join\ncov = (x,y,on,pearsonr=false) =>\n    join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])\n\npearsonr = (x,y,on) => cov(x:x, y:y, on:on, pearsonr:true)\n\n// AggregateWindow applies an aggregate function to fixed windows of time.\n// The procedure is to window the data, perform an aggregate operation,\n// and then undo the windowing to produce an output table for every input table.\naggregateWindow = (every, fn, column=\"_value\", timeSrc=\"_stop\",timeDst=\"_time\", createEmpty=true, tables=<-) =>\n    tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)\n\n// Increase returns the total non-negative difference between values in a table.\n// A main usage case is tracking changes in counter values which may wrap over time when they hit\n// a threshold or are reset. In the case of a wrap/reset,\n// we can assume that the absolute delta between two points will be at least their non-negative difference.\nincrease = (tables=<-, columns=[\"_value\"]) =>\n    tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)\n\n// median returns the 50th percentile.\nmedian = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) =>\n    tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)\n\n// stateCount computes the number of consecutive records in a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state count will be incremented\n// When a point evaluates as false, the state count is reset.\n//\n// The state count will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state count.\nstateCount = (fn, column=\"stateCount\", tables=<-) =>\n    tables\n        |> stateTracking(countColumn:column, fn:fn)\n\n// stateDuration computes the duration of a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state duration will be\n// incremented by the duration between points. When a point evaluates as false,\n// the state duration is reset.\n//\n// The state duration will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state duration.\n//\n// Note that as the first point in the given state has no previous point, its\n// state duration will be 0.\n//\n// The duration is represented as an integer in the units specified.\nstateDuration = (fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) =>\n    tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)\n\n// _sortLimit is a helper function, which sorts and limits a table.\n_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)\n\n// top sorts a table by columns and keeps only the top n records.\ntop = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:true)\n\n// top sorts a table by columns and keeps only the bottom n records.\nbottom = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:false)\n\n// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n// then it selects the highest or lowest records based on the column and the _sortLimit function.\n// The default reducer assumes no reducing needs to be performed.\n_highestOrLowest = (n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])\n\n// highestMax returns the top N records from all groups using the maximum of each group.\nhighestMax = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )\n\n// highestAverage returns the top N records from all groups using the average of each group.\nhighestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )\n\n// highestCurrent returns the top N records from all groups using the last value of each group.\nhighestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )\n\n// lowestMin returns the bottom N records from all groups using the minimum of each group.\nlowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )\n\n// lowestAverage returns the bottom N records from all groups using the average of each group.\nlowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )\n\n// lowestCurrent returns the bottom N records from all groups using the last value of each group.\nlowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )\n\n// timedMovingAverage constructs a simple moving average over windows of 'period' duration\n// eg: A 5 year moving average would be called as such:\n//    movingAverage(1y, 5y)\ntimedMovingAverage = (every, period, column=\"_value\", tables=<-) =>\n    tables\n        |> window(every: every, period: period)\n        |> mean(column:column)\n        |> duplicate(column: \"_stop\", as: \"_time\")\n        |> window(every: inf)\n\n// Double Exponential Moving Average computes the double exponential moving averages of the `_value` column.\n// eg: A 5 point double exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> doubleEMA(n: 5)\ndoubleEMA = (n, tables=<-) =>\n    tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")\n          |> exponentialMovingAverage(n:n)\n          |> map(fn: (r) => ({r with _value: 2.0*r.__ema - r._value}))\n          |> drop(columns: [\"__ema\"])\n\n\n// Triple Exponential Moving Average computes the triple exponential moving averages of the `_value` column.\n// eg: A 5 point triple exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> tripleEMA(n: 5)\ntripleEMA = (n, tables=<-) =>\n\ttables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> map(fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}))\n\t\t|> drop(columns: [\"__ema1\", \"__ema2\"])\n\n// truncateTimeColumn takes in a time column t and a Duration unit and truncates each value of t to the given unit via map\n// Change from _time to timeColumn once Flux Issue 1122 is resolved\ntruncateTimeColumn = (timeColumn=\"_time\", unit, tables=<-) =>\n    tables\n        |> map(fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))\n\n// kaufmansER computes Kaufman's Efficiency Ratios of the `_value` column\nkaufmansER = (n, tables=<-) =>\n    tables\n        |> chandeMomentumOscillator(n: n)\n        |> map(fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)}))\n\ntoString   = (tables=<-) => tables |> map(fn:(r) => ({r with _value: string(v:r._value)}))\ntoInt      = (tables=<-) => tables |> map(fn:(r) => ({r with _value: int(v:r._value)}))\ntoUInt     = (tables=<-) => tables |> map(fn:(r) => ({r with _value: uint(v:r._value)}))\ntoFloat    = (tables=<-) => tables |> map(fn:(r) => ({r with _value: float(v:r._value)}))\ntoBool     = (tables=<-) => tables |> map(fn:(r) => ({r with _value: bool(v:r._value)}))\ntoTime     = (tables=<-) => tables |> map(fn:(r) => ({r with _value: time(v:r._value)}))",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   10,
						},
						File:   "universe.flux",
						Source: "now = system.time",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   10,
							},
							File:   "universe.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   10,
							},
							File:   "universe.flux",
							Source: "system.time",
							Start: ast.Position{
								Column: 14,
								Line:   10,
							},
						},
					},
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   10,
								},
								File:   "universe.flux",
								Source: "system",
								Start: ast.Position{
									Column: 14,
									Line:   10,
								},
							},
						},
						Name: "system",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   10,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 21,
									Line:   10,
								},
							},
						},
						Name: "time",
					},
				},
			},
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   10,
					},
					File:   "universe.flux",
					Source: "option now = system.time",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   13,
					},
					File:   "universe.flux",
					Source: "builtin true",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   13,
						},
						File:   "universe.flux",
						Source: "true",
						Start: ast.Position{
							Column: 9,
							Line:   13,
						},
					},
				},
				Name: "true",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   14,
					},
					File:   "universe.flux",
					Source: "builtin false",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   14,
						},
						File:   "universe.flux",
						Source: "false",
						Start: ast.Position{
							Column: 9,
							Line:   14,
						},
					},
				},
				Name: "false",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   17,
					},
					File:   "universe.flux",
					Source: "builtin chandeMomentumOscillator",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   17,
						},
						File:   "universe.flux",
						Source: "chandeMomentumOscillator",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "chandeMomentumOscillator",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   18,
					},
					File:   "universe.flux",
					Source: "builtin columns",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "columns",
						Start: ast.Position{
							Column: 9,
							Line:   18,
						},
					},
				},
				Name: "columns",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   19,
					},
					File:   "universe.flux",
					Source: "builtin count",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "count",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "count",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   20,
					},
					File:   "universe.flux",
					Source: "builtin covariance",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "covariance",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "covariance",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   21,
					},
					File:   "universe.flux",
					Source: "builtin cumulativeSum",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   21,
						},
						File:   "universe.flux",
						Source: "cumulativeSum",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Name: "cumulativeSum",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   22,
					},
					File:   "universe.flux",
					Source: "builtin derivative",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   22,
						},
						File:   "universe.flux",
						Source: "derivative",
						Start: ast.Position{
							Column: 9,
							Line:   22,
						},
					},
				},
				Name: "derivative",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   23,
					},
					File:   "universe.flux",
					Source: "builtin difference",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   23,
						},
						File:   "universe.flux",
						Source: "difference",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Name: "difference",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   24,
					},
					File:   "universe.flux",
					Source: "builtin distinct",
					Start: ast.Position{
						Column: 1,
						Line:   24,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   24,
						},
						File:   "universe.flux",
						Source: "distinct",
						Start: ast.Position{
							Column: 9,
							Line:   24,
						},
					},
				},
				Name: "distinct",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   25,
					},
					File:   "universe.flux",
					Source: "builtin drop",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   25,
						},
						File:   "universe.flux",
						Source: "drop",
						Start: ast.Position{
							Column: 9,
							Line:   25,
						},
					},
				},
				Name: "drop",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   26,
					},
					File:   "universe.flux",
					Source: "builtin duplicate",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   26,
						},
						File:   "universe.flux",
						Source: "duplicate",
						Start: ast.Position{
							Column: 9,
							Line:   26,
						},
					},
				},
				Name: "duplicate",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   27,
					},
					File:   "universe.flux",
					Source: "builtin elapsed",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   27,
						},
						File:   "universe.flux",
						Source: "elapsed",
						Start: ast.Position{
							Column: 9,
							Line:   27,
						},
					},
				},
				Name: "elapsed",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   28,
					},
					File:   "universe.flux",
					Source: "builtin exponentialMovingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   28,
						},
						File:   "universe.flux",
						Source: "exponentialMovingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   28,
						},
					},
				},
				Name: "exponentialMovingAverage",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   29,
					},
					File:   "universe.flux",
					Source: "builtin fill",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   29,
						},
						File:   "universe.flux",
						Source: "fill",
						Start: ast.Position{
							Column: 9,
							Line:   29,
						},
					},
				},
				Name: "fill",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   30,
					},
					File:   "universe.flux",
					Source: "builtin filter",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   30,
						},
						File:   "universe.flux",
						Source: "filter",
						Start: ast.Position{
							Column: 9,
							Line:   30,
						},
					},
				},
				Name: "filter",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   31,
					},
					File:   "universe.flux",
					Source: "builtin first",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   31,
						},
						File:   "universe.flux",
						Source: "first",
						Start: ast.Position{
							Column: 9,
							Line:   31,
						},
					},
				},
				Name: "first",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   32,
					},
					File:   "universe.flux",
					Source: "builtin group",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   32,
						},
						File:   "universe.flux",
						Source: "group",
						Start: ast.Position{
							Column: 9,
							Line:   32,
						},
					},
				},
				Name: "group",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   33,
					},
					File:   "universe.flux",
					Source: "builtin histogram",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "histogram",
						Start: ast.Position{
							Column: 9,
							Line:   33,
						},
					},
				},
				Name: "histogram",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   34,
					},
					File:   "universe.flux",
					Source: "builtin histogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "histogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   34,
						},
					},
				},
				Name: "histogramQuantile",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   35,
					},
					File:   "universe.flux",
					Source: "builtin holtWinters",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "holtWinters",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Name: "holtWinters",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   36,
					},
					File:   "universe.flux",
					Source: "builtin hourSelection",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "hourSelection",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Name: "hourSelection",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   37,
					},
					File:   "universe.flux",
					Source: "builtin integral",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "integral",
						Start: ast.Position{
							Column: 9,
							Line:   37,
						},
					},
				},
				Name: "integral",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   38,
					},
					File:   "universe.flux",
					Source: "builtin join",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "join",
						Start: ast.Position{
							Column: 9,
							Line:   38,
						},
					},
				},
				Name: "join",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   39,
					},
					File:   "universe.flux",
					Source: "builtin kaufmansAMA",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "kaufmansAMA",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Name: "kaufmansAMA",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   40,
					},
					File:   "universe.flux",
					Source: "builtin keep",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "keep",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "keep",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   41,
					},
					File:   "universe.flux",
					Source: "builtin keyValues",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "keyValues",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "keyValues",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   42,
					},
					File:   "universe.flux",
					Source: "builtin keys",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   42,
						},
						File:   "universe.flux",
						Source: "keys",
						Start: ast.Position{
							Column: 9,
							Line:   42,
						},
					},
				},
				Name: "keys",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   43,
					},
					File:   "universe.flux",
					Source: "builtin last",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   43,
						},
						File:   "universe.flux",
						Source: "last",
						Start: ast.Position{
							Column: 9,
							Line:   43,
						},
					},
				},
				Name: "last",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   44,
					},
					File:   "universe.flux",
					Source: "builtin limit",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   44,
						},
						File:   "universe.flux",
						Source: "limit",
						Start: ast.Position{
							Column: 9,
							Line:   44,
						},
					},
				},
				Name: "limit",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   45,
					},
					File:   "universe.flux",
					Source: "builtin map",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   45,
						},
						File:   "universe.flux",
						Source: "map",
						Start: ast.Position{
							Column: 9,
							Line:   45,
						},
					},
				},
				Name: "map",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   46,
					},
					File:   "universe.flux",
					Source: "builtin max",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   46,
						},
						File:   "universe.flux",
						Source: "max",
						Start: ast.Position{
							Column: 9,
							Line:   46,
						},
					},
				},
				Name: "max",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   47,
					},
					File:   "universe.flux",
					Source: "builtin mean",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   47,
						},
						File:   "universe.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 9,
							Line:   47,
						},
					},
				},
				Name: "mean",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   48,
					},
					File:   "universe.flux",
					Source: "builtin min",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   48,
						},
						File:   "universe.flux",
						Source: "min",
						Start: ast.Position{
							Column: 9,
							Line:   48,
						},
					},
				},
				Name: "min",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   49,
					},
					File:   "universe.flux",
					Source: "builtin mode",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   49,
						},
						File:   "universe.flux",
						Source: "mode",
						Start: ast.Position{
							Column: 9,
							Line:   49,
						},
					},
				},
				Name: "mode",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   50,
					},
					File:   "universe.flux",
					Source: "builtin movingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   50,
						},
						File:   "universe.flux",
						Source: "movingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   50,
						},
					},
				},
				Name: "movingAverage",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   51,
					},
					File:   "universe.flux",
					Source: "builtin quantile",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   51,
						},
						File:   "universe.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 9,
							Line:   51,
						},
					},
				},
				Name: "quantile",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   52,
					},
					File:   "universe.flux",
					Source: "builtin pivot",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   52,
						},
						File:   "universe.flux",
						Source: "pivot",
						Start: ast.Position{
							Column: 9,
							Line:   52,
						},
					},
				},
				Name: "pivot",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   53,
					},
					File:   "universe.flux",
					Source: "builtin range",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   53,
						},
						File:   "universe.flux",
						Source: "range",
						Start: ast.Position{
							Column: 9,
							Line:   53,
						},
					},
				},
				Name: "range",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   54,
					},
					File:   "universe.flux",
					Source: "builtin reduce",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   54,
						},
						File:   "universe.flux",
						Source: "reduce",
						Start: ast.Position{
							Column: 9,
							Line:   54,
						},
					},
				},
				Name: "reduce",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   55,
					},
					File:   "universe.flux",
					Source: "builtin relativeStrengthIndex",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   55,
						},
						File:   "universe.flux",
						Source: "relativeStrengthIndex",
						Start: ast.Position{
							Column: 9,
							Line:   55,
						},
					},
				},
				Name: "relativeStrengthIndex",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   56,
					},
					File:   "universe.flux",
					Source: "builtin rename",
					Start: ast.Position{
						Column: 1,
						Line:   56,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   56,
						},
						File:   "universe.flux",
						Source: "rename",
						Start: ast.Position{
							Column: 9,
							Line:   56,
						},
					},
				},
				Name: "rename",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   57,
					},
					File:   "universe.flux",
					Source: "builtin sample",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   57,
						},
						File:   "universe.flux",
						Source: "sample",
						Start: ast.Position{
							Column: 9,
							Line:   57,
						},
					},
				},
				Name: "sample",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   58,
					},
					File:   "universe.flux",
					Source: "builtin set",
					Start: ast.Position{
						Column: 1,
						Line:   58,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   58,
						},
						File:   "universe.flux",
						Source: "set",
						Start: ast.Position{
							Column: 9,
							Line:   58,
						},
					},
				},
				Name: "set",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   59,
					},
					File:   "universe.flux",
					Source: "builtin tail",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   59,
						},
						File:   "universe.flux",
						Source: "tail",
						Start: ast.Position{
							Column: 9,
							Line:   59,
						},
					},
				},
				Name: "tail",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   60,
					},
					File:   "universe.flux",
					Source: "builtin timeShift",
					Start: ast.Position{
						Column: 1,
						Line:   60,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   60,
						},
						File:   "universe.flux",
						Source: "timeShift",
						Start: ast.Position{
							Column: 9,
							Line:   60,
						},
					},
				},
				Name: "timeShift",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   61,
					},
					File:   "universe.flux",
					Source: "builtin skew",
					Start: ast.Position{
						Column: 1,
						Line:   61,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   61,
						},
						File:   "universe.flux",
						Source: "skew",
						Start: ast.Position{
							Column: 9,
							Line:   61,
						},
					},
				},
				Name: "skew",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   62,
					},
					File:   "universe.flux",
					Source: "builtin spread",
					Start: ast.Position{
						Column: 1,
						Line:   62,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   62,
						},
						File:   "universe.flux",
						Source: "spread",
						Start: ast.Position{
							Column: 9,
							Line:   62,
						},
					},
				},
				Name: "spread",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   63,
					},
					File:   "universe.flux",
					Source: "builtin sort",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   63,
						},
						File:   "universe.flux",
						Source: "sort",
						Start: ast.Position{
							Column: 9,
							Line:   63,
						},
					},
				},
				Name: "sort",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   64,
					},
					File:   "universe.flux",
					Source: "builtin stateTracking",
					Start: ast.Position{
						Column: 1,
						Line:   64,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   64,
						},
						File:   "universe.flux",
						Source: "stateTracking",
						Start: ast.Position{
							Column: 9,
							Line:   64,
						},
					},
				},
				Name: "stateTracking",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   65,
					},
					File:   "universe.flux",
					Source: "builtin stddev",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   65,
						},
						File:   "universe.flux",
						Source: "stddev",
						Start: ast.Position{
							Column: 9,
							Line:   65,
						},
					},
				},
				Name: "stddev",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   66,
					},
					File:   "universe.flux",
					Source: "builtin sum",
					Start: ast.Position{
						Column: 1,
						Line:   66,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   66,
						},
						File:   "universe.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 9,
							Line:   66,
						},
					},
				},
				Name: "sum",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   67,
					},
					File:   "universe.flux",
					Source: "builtin tripleExponentialDerivative",
					Start: ast.Position{
						Column: 1,
						Line:   67,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   67,
						},
						File:   "universe.flux",
						Source: "tripleExponentialDerivative",
						Start: ast.Position{
							Column: 9,
							Line:   67,
						},
					},
				},
				Name: "tripleExponentialDerivative",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   68,
					},
					File:   "universe.flux",
					Source: "builtin union",
					Start: ast.Position{
						Column: 1,
						Line:   68,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   68,
						},
						File:   "universe.flux",
						Source: "union",
						Start: ast.Position{
							Column: 9,
							Line:   68,
						},
					},
				},
				Name: "union",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   69,
					},
					File:   "universe.flux",
					Source: "builtin unique",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   69,
						},
						File:   "universe.flux",
						Source: "unique",
						Start: ast.Position{
							Column: 9,
							Line:   69,
						},
					},
				},
				Name: "unique",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   70,
					},
					File:   "universe.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   70,
						},
						File:   "universe.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   70,
						},
					},
				},
				Name: "window",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   71,
					},
					File:   "universe.flux",
					Source: "builtin yield",
					Start: ast.Position{
						Column: 1,
						Line:   71,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   71,
						},
						File:   "universe.flux",
						Source: "yield",
						Start: ast.Position{
							Column: 9,
							Line:   71,
						},
					},
				},
				Name: "yield",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   74,
					},
					File:   "universe.flux",
					Source: "builtin tableFind",
					Start: ast.Position{
						Column: 1,
						Line:   74,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   74,
						},
						File:   "universe.flux",
						Source: "tableFind",
						Start: ast.Position{
							Column: 9,
							Line:   74,
						},
					},
				},
				Name: "tableFind",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   75,
					},
					File:   "universe.flux",
					Source: "builtin getColumn",
					Start: ast.Position{
						Column: 1,
						Line:   75,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   75,
						},
						File:   "universe.flux",
						Source: "getColumn",
						Start: ast.Position{
							Column: 9,
							Line:   75,
						},
					},
				},
				Name: "getColumn",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   76,
					},
					File:   "universe.flux",
					Source: "builtin getRecord",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   76,
						},
						File:   "universe.flux",
						Source: "getRecord",
						Start: ast.Position{
							Column: 9,
							Line:   76,
						},
					},
				},
				Name: "getRecord",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   79,
					},
					File:   "universe.flux",
					Source: "builtin bool",
					Start: ast.Position{
						Column: 1,
						Line:   79,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   79,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 9,
							Line:   79,
						},
					},
				},
				Name: "bool",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   80,
					},
					File:   "universe.flux",
					Source: "builtin bytes",
					Start: ast.Position{
						Column: 1,
						Line:   80,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   80,
						},
						File:   "universe.flux",
						Source: "bytes",
						Start: ast.Position{
							Column: 9,
							Line:   80,
						},
					},
				},
				Name: "bytes",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   81,
					},
					File:   "universe.flux",
					Source: "builtin duration",
					Start: ast.Position{
						Column: 1,
						Line:   81,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   81,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 9,
							Line:   81,
						},
					},
				},
				Name: "duration",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   82,
					},
					File:   "universe.flux",
					Source: "builtin float",
					Start: ast.Position{
						Column: 1,
						Line:   82,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   82,
						},
						File:   "universe.flux",
						Source: "float",
						Start: ast.Position{
							Column: 9,
							Line:   82,
						},
					},
				},
				Name: "float",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   83,
					},
					File:   "universe.flux",
					Source: "builtin int",
					Start: ast.Position{
						Column: 1,
						Line:   83,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   83,
						},
						File:   "universe.flux",
						Source: "int",
						Start: ast.Position{
							Column: 9,
							Line:   83,
						},
					},
				},
				Name: "int",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   84,
					},
					File:   "universe.flux",
					Source: "builtin string",
					Start: ast.Position{
						Column: 1,
						Line:   84,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   84,
						},
						File:   "universe.flux",
						Source: "string",
						Start: ast.Position{
							Column: 9,
							Line:   84,
						},
					},
				},
				Name: "string",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   85,
					},
					File:   "universe.flux",
					Source: "builtin time",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   85,
						},
						File:   "universe.flux",
						Source: "time",
						Start: ast.Position{
							Column: 9,
							Line:   85,
						},
					},
				},
				Name: "time",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   86,
					},
					File:   "universe.flux",
					Source: "builtin uint",
					Start: ast.Position{
						Column: 1,
						Line:   86,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   86,
						},
						File:   "universe.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 9,
							Line:   86,
						},
					},
				},
				Name: "uint",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   89,
					},
					File:   "universe.flux",
					Source: "builtin contains",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "contains",
						Start: ast.Position{
							Column: 9,
							Line:   89,
						},
					},
				},
				Name: "contains",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   92,
					},
					File:   "universe.flux",
					Source: "builtin inf",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "inf",
						Start: ast.Position{
							Column: 9,
							Line:   92,
						},
					},
				},
				Name: "inf",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   93,
					},
					File:   "universe.flux",
					Source: "builtin length",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "length",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Name: "length",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   94,
					},
					File:   "universe.flux",
					Source: "builtin linearBins",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "linearBins",
						Start: ast.Position{
							Column: 9,
							Line:   94,
						},
					},
				},
				Name: "linearBins",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   95,
					},
					File:   "universe.flux",
					Source: "builtin logarithmicBins",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "logarithmicBins",
						Start: ast.Position{
							Column: 9,
							Line:   95,
						},
					},
				},
				Name: "logarithmicBins",
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   96,
					},
					File:   "universe.flux",
					Source: "builtin sleep",
					Start: ast.Position{
						Column: 1,
						Line:   96,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "sleep",
						Start: ast.Position{
							Column: 9,
							Line:   96,
						},
					},
				},
				Name: "sleep",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   104,
					},
					File:   "universe.flux",
					Source: "cov = (x,y,on,pearsonr=false) =>\n    join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
					Start: ast.Position{
						Column: 1,
						Line:   99,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   99,
						},
						File:   "universe.flux",
						Source: "cov",
						Start: ast.Position{
							Column: 1,
							Line:   99,
						},
					},
				},
				Name: "cov",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   104,
						},
						File:   "universe.flux",
						Source: "(x,y,on,pearsonr=false) =>\n    join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
						Start: ast.Position{
							Column: 7,
							Line:   99,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   102,
									},
									File:   "universe.flux",
									Source: "tables:{x:x, y:y},\n        on:on",
									Start: ast.Position{
										Column: 9,
										Line:   101,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "tables:{x:x, y:y}",
										Start: ast.Position{
											Column: 9,
											Line:   101,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   101,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 9,
												Line:   101,
											},
										},
									},
									Name: "tables",
								},
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   101,
											},
											File:   "universe.flux",
											Source: "{x:x, y:y}",
											Start: ast.Position{
												Column: 16,
												Line:   101,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   101,
												},
												File:   "universe.flux",
												Source: "x:x",
												Start: ast.Position{
													Column: 17,
													Line:   101,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   101,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 17,
														Line:   101,
													},
												},
											},
											Name: "x",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   101,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 19,
														Line:   101,
													},
												},
											},
											Name: "x",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   101,
												},
												File:   "universe.flux",
												Source: "y:y",
												Start: ast.Position{
													Column: 22,
													Line:   101,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   101,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 22,
														Line:   101,
													},
												},
											},
											Name: "y",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   101,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 24,
														Line:   101,
													},
												},
											},
											Name: "y",
										},
									}},
									With: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   102,
										},
										File:   "universe.flux",
										Source: "on:on",
										Start: ast.Position{
											Column: 9,
											Line:   102,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   102,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 9,
												Line:   102,
											},
										},
									},
									Name: "on",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   102,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 12,
												Line:   102,
											},
										},
									},
									Name: "on",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   103,
								},
								File:   "universe.flux",
								Source: "join(\n        tables:{x:x, y:y},\n        on:on,\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   100,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "join",
									Start: ast.Position{
										Column: 5,
										Line:   100,
									},
								},
							},
							Name: "join",
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   104,
							},
							File:   "universe.flux",
							Source: "join(\n        tables:{x:x, y:y},\n        on:on,\n    )\n    |> covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
							Start: ast.Position{
								Column: 5,
								Line:   100,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"]",
									Start: ast.Position{
										Column: 19,
										Line:   104,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   104,
										},
										File:   "universe.flux",
										Source: "pearsonr:pearsonr",
										Start: ast.Position{
											Column: 19,
											Line:   104,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   104,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 19,
												Line:   104,
											},
										},
									},
									Name: "pearsonr",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   104,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 28,
												Line:   104,
											},
										},
									},
									Name: "pearsonr",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   104,
										},
										File:   "universe.flux",
										Source: "columns:[\"_value_x\",\"_value_y\"]",
										Start: ast.Position{
											Column: 38,
											Line:   104,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   104,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 38,
												Line:   104,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   104,
											},
											File:   "universe.flux",
											Source: "[\"_value_x\",\"_value_y\"]",
											Start: ast.Position{
												Column: 46,
												Line:   104,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   104,
												},
												File:   "universe.flux",
												Source: "\"_value_x\"",
												Start: ast.Position{
													Column: 47,
													Line:   104,
												},
											},
										},
										Value: "_value_x",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   104,
												},
												File:   "universe.flux",
												Source: "\"_value_y\"",
												Start: ast.Position{
													Column: 58,
													Line:   104,
												},
											},
										},
										Value: "_value_y",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "covariance(pearsonr:pearsonr, columns:[\"_value_x\",\"_value_y\"])",
								Start: ast.Position{
									Column: 8,
									Line:   104,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "covariance",
									Start: ast.Position{
										Column: 8,
										Line:   104,
									},
								},
							},
							Name: "covariance",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   99,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 8,
								Line:   99,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 8,
									Line:   99,
								},
							},
						},
						Name: "x",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   99,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 10,
								Line:   99,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 10,
									Line:   99,
								},
							},
						},
						Name: "y",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   99,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 12,
								Line:   99,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 12,
									Line:   99,
								},
							},
						},
						Name: "on",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   99,
							},
							File:   "universe.flux",
							Source: "pearsonr=false",
							Start: ast.Position{
								Column: 15,
								Line:   99,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "pearsonr",
								Start: ast.Position{
									Column: 15,
									Line:   99,
								},
							},
						},
						Name: "pearsonr",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   99,
								},
								File:   "universe.flux",
								Source: "false",
								Start: ast.Position{
									Column: 24,
									Line:   99,
								},
							},
						},
						Name: "false",
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   106,
					},
					File:   "universe.flux",
					Source: "pearsonr = (x,y,on) => cov(x:x, y:y, on:on, pearsonr:true)",
					Start: ast.Position{
						Column: 1,
						Line:   106,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   106,
						},
						File:   "universe.flux",
						Source: "pearsonr",
						Start: ast.Position{
							Column: 1,
							Line:   106,
						},
					},
				},
				Name: "pearsonr",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   106,
						},
						File:   "universe.flux",
						Source: "(x,y,on) => cov(x:x, y:y, on:on, pearsonr:true)",
						Start: ast.Position{
							Column: 12,
							Line:   106,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "x:x, y:y, on:on, pearsonr:true",
								Start: ast.Position{
									Column: 28,
									Line:   106,
								},
							},
						},
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "x:x",
									Start: ast.Position{
										Column: 28,
										Line:   106,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 28,
											Line:   106,
										},
									},
								},
								Name: "x",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 30,
											Line:   106,
										},
									},
								},
								Name: "x",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "y:y",
									Start: ast.Position{
										Column: 33,
										Line:   106,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 33,
											Line:   106,
										},
									},
								},
								Name: "y",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 35,
											Line:   106,
										},
									},
								},
								Name: "y",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "on:on",
									Start: ast.Position{
										Column: 38,
										Line:   106,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 38,
											Line:   106,
										},
									},
								},
								Name: "on",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 41,
											Line:   106,
										},
									},
								},
								Name: "on",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   106,
									},
									File:   "universe.flux",
									Source: "pearsonr:true",
									Start: ast.Position{
										Column: 45,
										Line:   106,
									},
								},
							},
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "pearsonr",
										Start: ast.Position{
											Column: 45,
											Line:   106,
										},
									},
								},
								Name: "pearsonr",
							},
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   106,
										},
										File:   "universe.flux",
										Source: "true",
										Start: ast.Position{
											Column: 54,
											Line:   106,
										},
									},
								},
								Name: "true",
							},
						}},
						With: nil,
					}},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   106,
							},
							File:   "universe.flux",
							Source: "cov(x:x, y:y, on:on, pearsonr:true)",
							Start: ast.Position{
								Column: 24,
								Line:   106,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "cov",
								Start: ast.Position{
									Column: 24,
									Line:   106,
								},
							},
						},
						Name: "cov",
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   106,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 13,
								Line:   106,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 13,
									Line:   106,
								},
							},
						},
						Name: "x",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   106,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 15,
								Line:   106,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 15,
									Line:   106,
								},
							},
						},
						Name: "y",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   106,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 17,
								Line:   106,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 17,
									Line:   106,
								},
							},
						},
						Name: "on",
					},
					Value: nil,
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 49,
						Line:   116,
					},
					File:   "universe.flux",
					Source: "aggregateWindow = (every, fn, column=\"_value\", timeSrc=\"_stop\",timeDst=\"_time\", createEmpty=true, tables=<-) =>\n    tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)",
					Start: ast.Position{
						Column: 1,
						Line:   111,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   111,
						},
						File:   "universe.flux",
						Source: "aggregateWindow",
						Start: ast.Position{
							Column: 1,
							Line:   111,
						},
					},
				},
				Name: "aggregateWindow",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   116,
						},
						File:   "universe.flux",
						Source: "(every, fn, column=\"_value\", timeSrc=\"_stop\",timeDst=\"_time\", createEmpty=true, tables=<-) =>\n    tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)",
						Start: ast.Position{
							Column: 19,
							Line:   111,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   112,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   112,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   113,
										},
										File:   "universe.flux",
										Source: "tables\n        |> window(every:every, createEmpty: createEmpty)",
										Start: ast.Position{
											Column: 5,
											Line:   112,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   113,
												},
												File:   "universe.flux",
												Source: "every:every, createEmpty: createEmpty",
												Start: ast.Position{
													Column: 19,
													Line:   113,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   113,
													},
													File:   "universe.flux",
													Source: "every:every",
													Start: ast.Position{
														Column: 19,
														Line:   113,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   113,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 19,
															Line:   113,
														},
													},
												},
												Name: "every",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   113,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 25,
															Line:   113,
														},
													},
												},
												Name: "every",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   113,
													},
													File:   "universe.flux",
													Source: "createEmpty: createEmpty",
													Start: ast.Position{
														Column: 32,
														Line:   113,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   113,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 32,
															Line:   113,
														},
													},
												},
												Name: "createEmpty",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   113,
														},
														File:   "universe.flux",
														Source: "createEmpty",
														Start: ast.Position{
															Column: 45,
															Line:   113,
														},
													},
												},
												Name: "createEmpty",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   113,
											},
											File:   "universe.flux",
											Source: "window(every:every, createEmpty: createEmpty)",
											Start: ast.Position{
												Column: 12,
												Line:   113,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   113,
												},
												File:   "universe.flux",
												Source: "window",
												Start: ast.Position{
													Column: 12,
													Line:   113,
												},
											},
										},
										Name: "window",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   114,
									},
									File:   "universe.flux",
									Source: "tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)",
									Start: ast.Position{
										Column: 5,
										Line:   112,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   114,
											},
											File:   "universe.flux",
											Source: "column:column",
											Start: ast.Position{
												Column: 15,
												Line:   114,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   114,
												},
												File:   "universe.flux",
												Source: "column:column",
												Start: ast.Position{
													Column: 15,
													Line:   114,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   114,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 15,
														Line:   114,
													},
												},
											},
											Name: "column",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   114,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 22,
														Line:   114,
													},
												},
											},
											Name: "column",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   114,
										},
										File:   "universe.flux",
										Source: "fn(column:column)",
										Start: ast.Position{
											Column: 12,
											Line:   114,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   114,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   114,
											},
										},
									},
									Name: "fn",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   115,
								},
								File:   "universe.flux",
								Source: "tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)",
								Start: ast.Position{
									Column: 5,
									Line:   112,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "column:timeSrc,as:timeDst",
										Start: ast.Position{
											Column: 22,
											Line:   115,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "column:timeSrc",
											Start: ast.Position{
												Column: 22,
												Line:   115,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 22,
													Line:   115,
												},
											},
										},
										Name: "column",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "timeSrc",
												Start: ast.Position{
													Column: 29,
													Line:   115,
												},
											},
										},
										Name: "timeSrc",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "as:timeDst",
											Start: ast.Position{
												Column: 37,
												Line:   115,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "as",
												Start: ast.Position{
													Column: 37,
													Line:   115,
												},
											},
										},
										Name: "as",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "timeDst",
												Start: ast.Position{
													Column: 40,
													Line:   115,
												},
											},
										},
										Name: "timeDst",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   115,
									},
									File:   "universe.flux",
									Source: "duplicate(column:timeSrc,as:timeDst)",
									Start: ast.Position{
										Column: 12,
										Line:   115,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "duplicate",
										Start: ast.Position{
											Column: 12,
											Line:   115,
										},
									},
								},
								Name: "duplicate",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   116,
							},
							File:   "universe.flux",
							Source: "tables\n        |> window(every:every, createEmpty: createEmpty)\n        |> fn(column:column)\n        |> duplicate(column:timeSrc,as:timeDst)\n        |> window(every:inf, timeColumn:timeDst)",
							Start: ast.Position{
								Column: 5,
								Line:   112,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "every:inf, timeColumn:timeDst",
									Start: ast.Position{
										Column: 19,
										Line:   116,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "every:inf",
										Start: ast.Position{
											Column: 19,
											Line:   116,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "every",
											Start: ast.Position{
												Column: 19,
												Line:   116,
											},
										},
									},
									Name: "every",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "inf",
											Start: ast.Position{
												Column: 25,
												Line:   116,
											},
										},
									},
									Name: "inf",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "timeColumn:timeDst",
										Start: ast.Position{
											Column: 30,
											Line:   116,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 30,
												Line:   116,
											},
										},
									},
									Name: "timeColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "timeDst",
											Start: ast.Position{
												Column: 41,
												Line:   116,
											},
										},
									},
									Name: "timeDst",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   116,
								},
								File:   "universe.flux",
								Source: "window(every:inf, timeColumn:timeDst)",
								Start: ast.Position{
									Column: 12,
									Line:   116,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   116,
									},
									File:   "universe.flux",
									Source: "window",
									Start: ast.Position{
										Column: 12,
										Line:   116,
									},
								},
							},
							Name: "window",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "every",
							Start: ast.Position{
								Column: 20,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "every",
								Start: ast.Position{
									Column: 20,
									Line:   111,
								},
							},
						},
						Name: "every",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 27,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 27,
									Line:   111,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 31,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 31,
									Line:   111,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 38,
									Line:   111,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "timeSrc=\"_stop\"",
							Start: ast.Position{
								Column: 48,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "timeSrc",
								Start: ast.Position{
									Column: 48,
									Line:   111,
								},
							},
						},
						Name: "timeSrc",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "\"_stop\"",
								Start: ast.Position{
									Column: 56,
									Line:   111,
								},
							},
						},
						Value: "_stop",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 79,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "timeDst=\"_time\"",
							Start: ast.Position{
								Column: 64,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "timeDst",
								Start: ast.Position{
									Column: 64,
									Line:   111,
								},
							},
						},
						Name: "timeDst",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 72,
									Line:   111,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "createEmpty=true",
							Start: ast.Position{
								Column: 81,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 81,
									Line:   111,
								},
							},
						},
						Name: "createEmpty",
					},
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "true",
								Start: ast.Position{
									Column: 93,
									Line:   111,
								},
							},
						},
						Name: "true",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 99,
								Line:   111,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 99,
									Line:   111,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   111,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 106,
								Line:   111,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   125,
					},
					File:   "universe.flux",
					Source: "increase = (tables=<-, columns=[\"_value\"]) =>\n    tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)",
					Start: ast.Position{
						Column: 1,
						Line:   122,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "increase",
						Start: ast.Position{
							Column: 1,
							Line:   122,
						},
					},
				},
				Name: "increase",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "(tables=<-, columns=[\"_value\"]) =>\n    tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)",
						Start: ast.Position{
							Column: 12,
							Line:   122,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   123,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "tables\n        |> difference(nonNegative: true, columns:columns)",
								Start: ast.Position{
									Column: 5,
									Line:   123,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "nonNegative: true, columns:columns",
										Start: ast.Position{
											Column: 23,
											Line:   124,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "nonNegative: true",
											Start: ast.Position{
												Column: 23,
												Line:   124,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   124,
												},
												File:   "universe.flux",
												Source: "nonNegative",
												Start: ast.Position{
													Column: 23,
													Line:   124,
												},
											},
										},
										Name: "nonNegative",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   124,
												},
												File:   "universe.flux",
												Source: "true",
												Start: ast.Position{
													Column: 36,
													Line:   124,
												},
											},
										},
										Name: "true",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "columns:columns",
											Start: ast.Position{
												Column: 42,
												Line:   124,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   124,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 42,
													Line:   124,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   124,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 50,
													Line:   124,
												},
											},
										},
										Name: "columns",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "difference(nonNegative: true, columns:columns)",
									Start: ast.Position{
										Column: 12,
										Line:   124,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "difference",
										Start: ast.Position{
											Column: 12,
											Line:   124,
										},
									},
								},
								Name: "difference",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   125,
							},
							File:   "universe.flux",
							Source: "tables\n        |> difference(nonNegative: true, columns:columns)\n        |> cumulativeSum(columns: columns)",
							Start: ast.Position{
								Column: 5,
								Line:   123,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "columns: columns",
									Start: ast.Position{
										Column: 26,
										Line:   125,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 26,
											Line:   125,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 26,
												Line:   125,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 35,
												Line:   125,
											},
										},
									},
									Name: "columns",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "cumulativeSum(columns: columns)",
								Start: ast.Position{
									Column: 12,
									Line:   125,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "cumulativeSum",
									Start: ast.Position{
										Column: 12,
										Line:   125,
									},
								},
							},
							Name: "cumulativeSum",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   122,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   122,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   122,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   122,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   122,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   122,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   122,
									},
								},
							},
							Value: "_value",
						}},
					},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   130,
					},
					File:   "universe.flux",
					Source: "median = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) =>\n    tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)",
					Start: ast.Position{
						Column: 1,
						Line:   128,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   128,
						},
						File:   "universe.flux",
						Source: "median",
						Start: ast.Position{
							Column: 1,
							Line:   128,
						},
					},
				},
				Name: "median",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   130,
						},
						File:   "universe.flux",
						Source: "(method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) =>\n    tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)",
						Start: ast.Position{
							Column: 10,
							Line:   128,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   129,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   129,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   130,
							},
							File:   "universe.flux",
							Source: "tables\n        |> quantile(q:0.5, method: method, compression: compression, column: column)",
							Start: ast.Position{
								Column: 5,
								Line:   129,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "q:0.5, method: method, compression: compression, column: column",
									Start: ast.Position{
										Column: 21,
										Line:   130,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "q:0.5",
										Start: ast.Position{
											Column: 21,
											Line:   130,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "q",
											Start: ast.Position{
												Column: 21,
												Line:   130,
											},
										},
									},
									Name: "q",
								},
								Value: &ast.FloatLiteral{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "0.5",
											Start: ast.Position{
												Column: 23,
												Line:   130,
											},
										},
									},
									Value: 0.5,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "method: method",
										Start: ast.Position{
											Column: 28,
											Line:   130,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 28,
												Line:   130,
											},
										},
									},
									Name: "method",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 36,
												Line:   130,
											},
										},
									},
									Name: "method",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "compression: compression",
										Start: ast.Position{
											Column: 44,
											Line:   130,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 44,
												Line:   130,
											},
										},
									},
									Name: "compression",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 57,
												Line:   130,
											},
										},
									},
									Name: "compression",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 70,
											Line:   130,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 70,
												Line:   130,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 78,
												Line:   130,
											},
										},
									},
									Name: "column",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "quantile(q:0.5, method: method, compression: compression, column: column)",
								Start: ast.Position{
									Column: 12,
									Line:   130,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 12,
										Line:   130,
									},
								},
							},
							Name: "quantile",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "method=\"estimate_tdigest\"",
							Start: ast.Position{
								Column: 11,
								Line:   128,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "method",
								Start: ast.Position{
									Column: 11,
									Line:   128,
								},
							},
						},
						Name: "method",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "\"estimate_tdigest\"",
								Start: ast.Position{
									Column: 18,
									Line:   128,
								},
							},
						},
						Value: "estimate_tdigest",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "compression=0.0",
							Start: ast.Position{
								Column: 38,
								Line:   128,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "compression",
								Start: ast.Position{
									Column: 38,
									Line:   128,
								},
							},
						},
						Name: "compression",
					},
					Value: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 50,
									Line:   128,
								},
							},
						},
						Value: 0.0,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 55,
								Line:   128,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 55,
									Line:   128,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 62,
									Line:   128,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 72,
								Line:   128,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 72,
									Line:   128,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 79,
								Line:   128,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 52,
						Line:   143,
					},
					File:   "universe.flux",
					Source: "stateCount = (fn, column=\"stateCount\", tables=<-) =>\n    tables\n        |> stateTracking(countColumn:column, fn:fn)",
					Start: ast.Position{
						Column: 1,
						Line:   141,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   141,
						},
						File:   "universe.flux",
						Source: "stateCount",
						Start: ast.Position{
							Column: 1,
							Line:   141,
						},
					},
				},
				Name: "stateCount",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 52,
							Line:   143,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateCount\", tables=<-) =>\n    tables\n        |> stateTracking(countColumn:column, fn:fn)",
						Start: ast.Position{
							Column: 14,
							Line:   141,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   142,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 52,
								Line:   143,
							},
							File:   "universe.flux",
							Source: "tables\n        |> stateTracking(countColumn:column, fn:fn)",
							Start: ast.Position{
								Column: 5,
								Line:   142,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "countColumn:column, fn:fn",
									Start: ast.Position{
										Column: 26,
										Line:   143,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "countColumn:column",
										Start: ast.Position{
											Column: 26,
											Line:   143,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   143,
											},
											File:   "universe.flux",
											Source: "countColumn",
											Start: ast.Position{
												Column: 26,
												Line:   143,
											},
										},
									},
									Name: "countColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   143,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   143,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "fn:fn",
										Start: ast.Position{
											Column: 46,
											Line:   143,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   143,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 46,
												Line:   143,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   143,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 49,
												Line:   143,
											},
										},
									},
									Name: "fn",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "stateTracking(countColumn:column, fn:fn)",
								Start: ast.Position{
									Column: 12,
									Line:   143,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 12,
										Line:   143,
									},
								},
							},
							Name: "stateTracking",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 15,
								Line:   141,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 15,
									Line:   141,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "column=\"stateCount\"",
							Start: ast.Position{
								Column: 19,
								Line:   141,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 19,
									Line:   141,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "\"stateCount\"",
								Start: ast.Position{
									Column: 26,
									Line:   141,
								},
							},
						},
						Value: "stateCount",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 40,
								Line:   141,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 40,
									Line:   141,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 47,
								Line:   141,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 97,
						Line:   162,
					},
					File:   "universe.flux",
					Source: "stateDuration = (fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) =>\n    tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
					Start: ast.Position{
						Column: 1,
						Line:   160,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   160,
						},
						File:   "universe.flux",
						Source: "stateDuration",
						Start: ast.Position{
							Column: 1,
							Line:   160,
						},
					},
				},
				Name: "stateDuration",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   162,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateDuration\", timeColumn=\"_time\", unit=1s, tables=<-) =>\n    tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
						Start: ast.Position{
							Column: 17,
							Line:   160,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   161,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   162,
							},
							File:   "universe.flux",
							Source: "tables\n        |> stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
							Start: ast.Position{
								Column: 5,
								Line:   161,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit",
									Start: ast.Position{
										Column: 26,
										Line:   162,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "durationColumn:column",
										Start: ast.Position{
											Column: 26,
											Line:   162,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "durationColumn",
											Start: ast.Position{
												Column: 26,
												Line:   162,
											},
										},
									},
									Name: "durationColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 41,
												Line:   162,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "timeColumn:timeColumn",
										Start: ast.Position{
											Column: 49,
											Line:   162,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 49,
												Line:   162,
											},
										},
									},
									Name: "timeColumn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 60,
												Line:   162,
											},
										},
									},
									Name: "timeColumn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "fn:fn",
										Start: ast.Position{
											Column: 72,
											Line:   162,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 72,
												Line:   162,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 75,
												Line:   162,
											},
										},
									},
									Name: "fn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "durationUnit:unit",
										Start: ast.Position{
											Column: 79,
											Line:   162,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "durationUnit",
											Start: ast.Position{
												Column: 79,
												Line:   162,
											},
										},
									},
									Name: "durationUnit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "unit",
											Start: ast.Position{
												Column: 92,
												Line:   162,
											},
										},
									},
									Name: "unit",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "stateTracking(durationColumn:column, timeColumn:timeColumn, fn:fn, durationUnit:unit)",
								Start: ast.Position{
									Column: 12,
									Line:   162,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 12,
										Line:   162,
									},
								},
							},
							Name: "stateTracking",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 18,
								Line:   160,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 18,
									Line:   160,
								},
							},
						},
						Name: "fn",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "column=\"stateDuration\"",
							Start: ast.Position{
								Column: 22,
								Line:   160,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   160,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "\"stateDuration\"",
								Start: ast.Position{
									Column: 29,
									Line:   160,
								},
							},
						},
						Value: "stateDuration",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "timeColumn=\"_time\"",
							Start: ast.Position{
								Column: 46,
								Line:   160,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "timeColumn",
								Start: ast.Position{
									Column: 46,
									Line:   160,
								},
							},
						},
						Name: "timeColumn",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 57,
									Line:   160,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "unit=1s",
							Start: ast.Position{
								Column: 66,
								Line:   160,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 66,
									Line:   160,
								},
							},
						},
						Name: "unit",
					},
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "1s",
								Start: ast.Position{
									Column: 71,
									Line:   160,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(1),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 75,
								Line:   160,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   160,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 75,
									Line:   160,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   160,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 82,
								Line:   160,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   168,
					},
					File:   "universe.flux",
					Source: "_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)",
					Start: ast.Position{
						Column: 1,
						Line:   165,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "_sortLimit",
						Start: ast.Position{
							Column: 1,
							Line:   165,
						},
					},
				},
				Name: "_sortLimit",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "(n, desc, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)",
						Start: ast.Position{
							Column: 14,
							Line:   165,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   166,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   166,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   167,
								},
								File:   "universe.flux",
								Source: "tables\n        |> sort(columns:columns, desc:desc)",
								Start: ast.Position{
									Column: 5,
									Line:   166,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "columns:columns, desc:desc",
										Start: ast.Position{
											Column: 17,
											Line:   167,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "columns:columns",
											Start: ast.Position{
												Column: 17,
												Line:   167,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   167,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 25,
													Line:   167,
												},
											},
										},
										Name: "columns",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   167,
											},
											File:   "universe.flux",
											Source: "desc:desc",
											Start: ast.Position{
												Column: 34,
												Line:   167,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 34,
													Line:   167,
												},
											},
										},
										Name: "desc",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   167,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 39,
													Line:   167,
												},
											},
										},
										Name: "desc",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   167,
									},
									File:   "universe.flux",
									Source: "sort(columns:columns, desc:desc)",
									Start: ast.Position{
										Column: 12,
										Line:   167,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   167,
										},
										File:   "universe.flux",
										Source: "sort",
										Start: ast.Position{
											Column: 12,
											Line:   167,
										},
									},
								},
								Name: "sort",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   168,
							},
							File:   "universe.flux",
							Source: "tables\n        |> sort(columns:columns, desc:desc)\n        |> limit(n:n)",
							Start: ast.Position{
								Column: 5,
								Line:   166,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "n:n",
									Start: ast.Position{
										Column: 18,
										Line:   168,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 18,
											Line:   168,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 18,
												Line:   168,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   168,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 20,
												Line:   168,
											},
										},
									},
									Name: "n",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "limit(n:n)",
								Start: ast.Position{
									Column: 12,
									Line:   168,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "limit",
									Start: ast.Position{
										Column: 12,
										Line:   168,
									},
								},
							},
							Name: "limit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   165,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "desc",
							Start: ast.Position{
								Column: 18,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "desc",
								Start: ast.Position{
									Column: 18,
									Line:   165,
								},
							},
						},
						Name: "desc",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   165,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   165,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   165,
									},
								},
							},
							Value: "_value",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 44,
								Line:   165,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 44,
									Line:   165,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 51,
								Line:   165,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 55,
						Line:   173,
					},
					File:   "universe.flux",
					Source: "top = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:true)",
					Start: ast.Position{
						Column: 1,
						Line:   171,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   171,
						},
						File:   "universe.flux",
						Source: "top",
						Start: ast.Position{
							Column: 1,
							Line:   171,
						},
					},
				},
				Name: "top",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   173,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:true)",
						Start: ast.Position{
							Column: 7,
							Line:   171,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   172,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _sortLimit(n:n, columns:columns, desc:true)",
							Start: ast.Position{
								Column: 5,
								Line:   172,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "n:n, columns:columns, desc:true",
									Start: ast.Position{
										Column: 23,
										Line:   173,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   173,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 23,
											Line:   173,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   173,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 23,
												Line:   173,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   173,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 25,
												Line:   173,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   173,
										},
										File:   "universe.flux",
										Source: "columns:columns",
										Start: ast.Position{
											Column: 28,
											Line:   173,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   173,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 28,
												Line:   173,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   173,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 36,
												Line:   173,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   173,
										},
										File:   "universe.flux",
										Source: "desc:true",
										Start: ast.Position{
											Column: 45,
											Line:   173,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   173,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 45,
												Line:   173,
											},
										},
									},
									Name: "desc",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   173,
											},
											File:   "universe.flux",
											Source: "true",
											Start: ast.Position{
												Column: 50,
												Line:   173,
											},
										},
									},
									Name: "true",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n:n, columns:columns, desc:true)",
								Start: ast.Position{
									Column: 12,
									Line:   173,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 12,
										Line:   173,
									},
								},
							},
							Name: "_sortLimit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   171,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 8,
								Line:   171,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 8,
									Line:   171,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   171,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 11,
								Line:   171,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 11,
									Line:   171,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 19,
									Line:   171,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 20,
										Line:   171,
									},
								},
							},
							Value: "_value",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   171,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 31,
								Line:   171,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 31,
									Line:   171,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   171,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   171,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 56,
						Line:   178,
					},
					File:   "universe.flux",
					Source: "bottom = (n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:false)",
					Start: ast.Position{
						Column: 1,
						Line:   176,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   176,
						},
						File:   "universe.flux",
						Source: "bottom",
						Start: ast.Position{
							Column: 1,
							Line:   176,
						},
					},
				},
				Name: "bottom",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) =>\n    tables\n        |> _sortLimit(n:n, columns:columns, desc:false)",
						Start: ast.Position{
							Column: 10,
							Line:   176,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   177,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   177,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   178,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _sortLimit(n:n, columns:columns, desc:false)",
							Start: ast.Position{
								Column: 5,
								Line:   177,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "n:n, columns:columns, desc:false",
									Start: ast.Position{
										Column: 23,
										Line:   178,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 23,
											Line:   178,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 23,
												Line:   178,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 25,
												Line:   178,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "columns:columns",
										Start: ast.Position{
											Column: 28,
											Line:   178,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 28,
												Line:   178,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 36,
												Line:   178,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "desc:false",
										Start: ast.Position{
											Column: 45,
											Line:   178,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 45,
												Line:   178,
											},
										},
									},
									Name: "desc",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "false",
											Start: ast.Position{
												Column: 50,
												Line:   178,
											},
										},
									},
									Name: "false",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n:n, columns:columns, desc:false)",
								Start: ast.Position{
									Column: 12,
									Line:   178,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 12,
										Line:   178,
									},
								},
							},
							Name: "_sortLimit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   176,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 11,
								Line:   176,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 11,
									Line:   176,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   176,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 14,
								Line:   176,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 14,
									Line:   176,
								},
							},
						},
						Name: "columns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 22,
									Line:   176,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   176,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 23,
										Line:   176,
									},
								},
							},
							Value: "_value",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   176,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 34,
								Line:   176,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   176,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 34,
									Line:   176,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   176,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   176,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 45,
						Line:   188,
					},
					File:   "universe.flux",
					Source: "_highestOrLowest = (n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])",
					Start: ast.Position{
						Column: 1,
						Line:   183,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   183,
						},
						File:   "universe.flux",
						Source: "_highestOrLowest",
						Start: ast.Position{
							Column: 1,
							Line:   183,
						},
					},
				},
				Name: "_highestOrLowest",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   188,
						},
						File:   "universe.flux",
						Source: "(n, _sortLimit, reducer, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])",
						Start: ast.Position{
							Column: 20,
							Line:   183,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   184,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   184,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   185,
										},
										File:   "universe.flux",
										Source: "tables\n        |> group(columns:groupColumns)",
										Start: ast.Position{
											Column: 5,
											Line:   184,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   185,
												},
												File:   "universe.flux",
												Source: "columns:groupColumns",
												Start: ast.Position{
													Column: 18,
													Line:   185,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   185,
													},
													File:   "universe.flux",
													Source: "columns:groupColumns",
													Start: ast.Position{
														Column: 18,
														Line:   185,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   185,
														},
														File:   "universe.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 18,
															Line:   185,
														},
													},
												},
												Name: "columns",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   185,
														},
														File:   "universe.flux",
														Source: "groupColumns",
														Start: ast.Position{
															Column: 26,
															Line:   185,
														},
													},
												},
												Name: "groupColumns",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   185,
											},
											File:   "universe.flux",
											Source: "group(columns:groupColumns)",
											Start: ast.Position{
												Column: 12,
												Line:   185,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   185,
												},
												File:   "universe.flux",
												Source: "group",
												Start: ast.Position{
													Column: 12,
													Line:   185,
												},
											},
										},
										Name: "group",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   186,
									},
									File:   "universe.flux",
									Source: "tables\n        |> group(columns:groupColumns)\n        |> reducer()",
									Start: ast.Position{
										Column: 5,
										Line:   184,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   186,
										},
										File:   "universe.flux",
										Source: "reducer()",
										Start: ast.Position{
											Column: 12,
											Line:   186,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   186,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 12,
												Line:   186,
											},
										},
									},
									Name: "reducer",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])",
								Start: ast.Position{
									Column: 5,
									Line:   184,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "columns:[]",
										Start: ast.Position{
											Column: 18,
											Line:   187,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   187,
											},
											File:   "universe.flux",
											Source: "columns:[]",
											Start: ast.Position{
												Column: 18,
												Line:   187,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   187,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 18,
													Line:   187,
												},
											},
										},
										Name: "columns",
									},
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   187,
												},
												File:   "universe.flux",
												Source: "[]",
												Start: ast.Position{
													Column: 26,
													Line:   187,
												},
											},
										},
										Elements: nil,
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "group(columns:[])",
									Start: ast.Position{
										Column: 12,
										Line:   187,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "group",
										Start: ast.Position{
											Column: 12,
											Line:   187,
										},
									},
								},
								Name: "group",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   188,
							},
							File:   "universe.flux",
							Source: "tables\n        |> group(columns:groupColumns)\n        |> reducer()\n        |> group(columns:[])\n        |> _sortLimit(n:n, columns:[column])",
							Start: ast.Position{
								Column: 5,
								Line:   184,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   188,
									},
									File:   "universe.flux",
									Source: "n:n, columns:[column]",
									Start: ast.Position{
										Column: 23,
										Line:   188,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   188,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 23,
											Line:   188,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 23,
												Line:   188,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 25,
												Line:   188,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   188,
										},
										File:   "universe.flux",
										Source: "columns:[column]",
										Start: ast.Position{
											Column: 28,
											Line:   188,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 28,
												Line:   188,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   188,
											},
											File:   "universe.flux",
											Source: "[column]",
											Start: ast.Position{
												Column: 36,
												Line:   188,
											},
										},
									},
									Elements: []ast.Expression{&ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   188,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 37,
													Line:   188,
												},
											},
										},
										Name: "column",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   188,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n:n, columns:[column])",
								Start: ast.Position{
									Column: 12,
									Line:   188,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   188,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 12,
										Line:   188,
									},
								},
							},
							Name: "_sortLimit",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 21,
								Line:   183,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 21,
									Line:   183,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "_sortLimit",
							Start: ast.Position{
								Column: 24,
								Line:   183,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "_sortLimit",
								Start: ast.Position{
									Column: 24,
									Line:   183,
								},
							},
						},
						Name: "_sortLimit",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "reducer",
							Start: ast.Position{
								Column: 36,
								Line:   183,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "reducer",
								Start: ast.Position{
									Column: 36,
									Line:   183,
								},
							},
						},
						Name: "reducer",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 45,
								Line:   183,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 45,
									Line:   183,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 52,
									Line:   183,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 62,
								Line:   183,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 62,
									Line:   183,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 75,
									Line:   183,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 79,
								Line:   183,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 79,
									Line:   183,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 86,
								Line:   183,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   200,
					},
					File:   "universe.flux",
					Source: "highestMax = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   191,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   191,
						},
						File:   "universe.flux",
						Source: "highestMax",
						Start: ast.Position{
							Column: 1,
							Line:   191,
						},
					},
				},
				Name: "highestMax",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   200,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
						Start: ast.Position{
							Column: 14,
							Line:   191,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   192,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   200,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   192,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   199,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top",
									Start: ast.Position{
										Column: 17,
										Line:   194,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   194,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   194,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   194,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   194,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   194,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   194,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   195,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   195,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   195,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   195,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   195,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   195,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   196,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   196,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   196,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   196,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   198,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> max(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   198,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   198,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   198,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   198,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> max(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   198,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   198,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   198,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   198,
												},
												File:   "universe.flux",
												Source: "tables |> max(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   198,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   198,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 55,
															Line:   198,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   198,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 55,
																Line:   198,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   198,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 55,
																	Line:   198,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   198,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 62,
																	Line:   198,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   198,
													},
													File:   "universe.flux",
													Source: "max(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   198,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   198,
														},
														File:   "universe.flux",
														Source: "max",
														Start: ast.Position{
															Column: 51,
															Line:   198,
														},
													},
												},
												Name: "max",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   198,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   198,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   198,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   198,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   198,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   198,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   199,
										},
										File:   "universe.flux",
										Source: "_sortLimit: top",
										Start: ast.Position{
											Column: 17,
											Line:   199,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   199,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "top",
											Start: ast.Position{
												Column: 29,
												Line:   199,
											},
										},
									},
									Name: "top",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   200,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> max(column:column),\n                _sortLimit: top,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   193,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   193,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   193,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   191,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   191,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   191,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   191,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 18,
								Line:   191,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 18,
									Line:   191,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 25,
									Line:   191,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   191,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 35,
								Line:   191,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 35,
									Line:   191,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 48,
									Line:   191,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   191,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 52,
								Line:   191,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 52,
									Line:   191,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   191,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 59,
								Line:   191,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   211,
					},
					File:   "universe.flux",
					Source: "highestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   203,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   203,
						},
						File:   "universe.flux",
						Source: "highestAverage",
						Start: ast.Position{
							Column: 1,
							Line:   203,
						},
					},
				},
				Name: "highestAverage",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   211,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
						Start: ast.Position{
							Column: 18,
							Line:   203,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   204,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   204,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   211,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   204,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   210,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top",
									Start: ast.Position{
										Column: 17,
										Line:   206,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   206,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   206,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   206,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   206,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   206,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   206,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   207,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   207,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   207,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   207,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   207,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   207,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   208,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   208,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   208,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   208,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   208,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   208,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   209,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> mean(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   209,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   209,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   209,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   209,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> mean(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   209,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   209,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   209,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   209,
												},
												File:   "universe.flux",
												Source: "tables |> mean(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   209,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   209,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   209,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   209,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   209,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   209,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   209,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   209,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   209,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   209,
													},
													File:   "universe.flux",
													Source: "mean(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   209,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   209,
														},
														File:   "universe.flux",
														Source: "mean",
														Start: ast.Position{
															Column: 51,
															Line:   209,
														},
													},
												},
												Name: "mean",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   209,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   209,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   209,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   209,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   209,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   209,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   210,
										},
										File:   "universe.flux",
										Source: "_sortLimit: top",
										Start: ast.Position{
											Column: 17,
											Line:   210,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   210,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   210,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   210,
											},
											File:   "universe.flux",
											Source: "top",
											Start: ast.Position{
												Column: 29,
												Line:   210,
											},
										},
									},
									Name: "top",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   211,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: top,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   205,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   205,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   205,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   203,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 19,
								Line:   203,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   203,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 19,
									Line:   203,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   203,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 22,
								Line:   203,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   203,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   203,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   203,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 29,
									Line:   203,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   203,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 39,
								Line:   203,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   203,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 39,
									Line:   203,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   203,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 52,
									Line:   203,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   203,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 56,
								Line:   203,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   203,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 56,
									Line:   203,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   203,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 63,
								Line:   203,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   222,
					},
					File:   "universe.flux",
					Source: "highestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   214,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   214,
						},
						File:   "universe.flux",
						Source: "highestCurrent",
						Start: ast.Position{
							Column: 1,
							Line:   214,
						},
					},
				},
				Name: "highestCurrent",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   222,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
						Start: ast.Position{
							Column: 18,
							Line:   214,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   215,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   215,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   222,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   215,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   221,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top",
									Start: ast.Position{
										Column: 17,
										Line:   217,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   217,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   217,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   217,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   217,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   217,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   217,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   218,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   218,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   218,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   218,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   218,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   219,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   219,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   219,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   219,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   219,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   219,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   220,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> last(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   220,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   220,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   220,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   220,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> last(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   220,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   220,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   220,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   220,
												},
												File:   "universe.flux",
												Source: "tables |> last(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   220,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   220,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   220,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   220,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   220,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   220,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   220,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   220,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   220,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   220,
													},
													File:   "universe.flux",
													Source: "last(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   220,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   220,
														},
														File:   "universe.flux",
														Source: "last",
														Start: ast.Position{
															Column: 51,
															Line:   220,
														},
													},
												},
												Name: "last",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   220,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   220,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   220,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   220,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   220,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   220,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   221,
										},
										File:   "universe.flux",
										Source: "_sortLimit: top",
										Start: ast.Position{
											Column: 17,
											Line:   221,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   221,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   221,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   221,
											},
											File:   "universe.flux",
											Source: "top",
											Start: ast.Position{
												Column: 29,
												Line:   221,
											},
										},
									},
									Name: "top",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   222,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: top,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   216,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   216,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   216,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 19,
								Line:   214,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 19,
									Line:   214,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 22,
								Line:   214,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 22,
									Line:   214,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 29,
									Line:   214,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 39,
								Line:   214,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 39,
									Line:   214,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 52,
									Line:   214,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 56,
								Line:   214,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 56,
									Line:   214,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 63,
								Line:   214,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   234,
					},
					File:   "universe.flux",
					Source: "lowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   225,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   225,
						},
						File:   "universe.flux",
						Source: "lowestMin",
						Start: ast.Position{
							Column: 1,
							Line:   225,
						},
					},
				},
				Name: "lowestMin",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   234,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
						Start: ast.Position{
							Column: 13,
							Line:   225,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   226,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   226,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   234,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   226,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   233,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom",
									Start: ast.Position{
										Column: 17,
										Line:   228,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   228,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   228,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   228,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   228,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   228,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   228,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   229,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   229,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   229,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   229,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   229,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   229,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   230,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   230,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   230,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   230,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   230,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   230,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   232,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> min(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   232,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   232,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   232,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   232,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> min(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   232,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   232,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   232,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "tables |> min(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   232,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   232,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 55,
															Line:   232,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   232,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 55,
																Line:   232,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   232,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 55,
																	Line:   232,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   232,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 62,
																	Line:   232,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   232,
													},
													File:   "universe.flux",
													Source: "min(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   232,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   232,
														},
														File:   "universe.flux",
														Source: "min",
														Start: ast.Position{
															Column: 51,
															Line:   232,
														},
													},
												},
												Name: "min",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   232,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   232,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   232,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   232,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   233,
										},
										File:   "universe.flux",
										Source: "_sortLimit: bottom",
										Start: ast.Position{
											Column: 17,
											Line:   233,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   233,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   233,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   233,
											},
											File:   "universe.flux",
											Source: "bottom",
											Start: ast.Position{
												Column: 29,
												Line:   233,
											},
										},
									},
									Name: "bottom",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   234,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n                reducer: (tables=<-) => tables |> min(column:column),\n                _sortLimit: bottom,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   227,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   227,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   227,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   225,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 14,
								Line:   225,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 14,
									Line:   225,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   225,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 17,
								Line:   225,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 17,
									Line:   225,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 24,
									Line:   225,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   225,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 34,
								Line:   225,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 34,
									Line:   225,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 47,
									Line:   225,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   225,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 51,
								Line:   225,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 51,
									Line:   225,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   225,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 58,
								Line:   225,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   245,
					},
					File:   "universe.flux",
					Source: "lowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   237,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   237,
						},
						File:   "universe.flux",
						Source: "lowestAverage",
						Start: ast.Position{
							Column: 1,
							Line:   237,
						},
					},
				},
				Name: "lowestAverage",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   245,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
						Start: ast.Position{
							Column: 17,
							Line:   237,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   238,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   238,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   245,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   238,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   244,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom",
									Start: ast.Position{
										Column: 17,
										Line:   240,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   240,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   240,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   240,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   240,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   240,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   240,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   241,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   241,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   241,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   241,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   241,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   241,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   242,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   242,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   242,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   242,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   242,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   242,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   243,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> mean(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   243,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   243,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   243,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   243,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> mean(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   243,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   243,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   243,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   243,
												},
												File:   "universe.flux",
												Source: "tables |> mean(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   243,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   243,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   243,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   243,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   243,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   243,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   243,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   243,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   243,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   243,
													},
													File:   "universe.flux",
													Source: "mean(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   243,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   243,
														},
														File:   "universe.flux",
														Source: "mean",
														Start: ast.Position{
															Column: 51,
															Line:   243,
														},
													},
												},
												Name: "mean",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   243,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   243,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   243,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   243,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   243,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   243,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   244,
										},
										File:   "universe.flux",
										Source: "_sortLimit: bottom",
										Start: ast.Position{
											Column: 17,
											Line:   244,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   244,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   244,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   244,
											},
											File:   "universe.flux",
											Source: "bottom",
											Start: ast.Position{
												Column: 29,
												Line:   244,
											},
										},
									},
									Name: "bottom",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   245,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> mean(column:column),\n                _sortLimit: bottom,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   239,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   239,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   239,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   237,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 18,
								Line:   237,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 18,
									Line:   237,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   237,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 21,
								Line:   237,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 21,
									Line:   237,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 28,
									Line:   237,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   237,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 38,
								Line:   237,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 38,
									Line:   237,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 51,
									Line:   237,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   237,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 55,
								Line:   237,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 55,
									Line:   237,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   237,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 62,
								Line:   237,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   256,
					},
					File:   "universe.flux",
					Source: "lowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
					Start: ast.Position{
						Column: 1,
						Line:   248,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   248,
						},
						File:   "universe.flux",
						Source: "lowestCurrent",
						Start: ast.Position{
							Column: 1,
							Line:   248,
						},
					},
				},
				Name: "lowestCurrent",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   256,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) =>\n    tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
						Start: ast.Position{
							Column: 17,
							Line:   248,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   249,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   249,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   256,
							},
							File:   "universe.flux",
							Source: "tables\n        |> _highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
							Start: ast.Position{
								Column: 5,
								Line:   249,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   255,
									},
									File:   "universe.flux",
									Source: "n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom",
									Start: ast.Position{
										Column: 17,
										Line:   251,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   251,
										},
										File:   "universe.flux",
										Source: "n:n",
										Start: ast.Position{
											Column: 17,
											Line:   251,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   251,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   251,
											},
										},
									},
									Name: "n",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   251,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   251,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   252,
										},
										File:   "universe.flux",
										Source: "column:column",
										Start: ast.Position{
											Column: 17,
											Line:   252,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   252,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 17,
												Line:   252,
											},
										},
									},
									Name: "column",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   252,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 24,
												Line:   252,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   253,
										},
										File:   "universe.flux",
										Source: "groupColumns:groupColumns",
										Start: ast.Position{
											Column: 17,
											Line:   253,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   253,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 17,
												Line:   253,
											},
										},
									},
									Name: "groupColumns",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   253,
											},
											File:   "universe.flux",
											Source: "groupColumns",
											Start: ast.Position{
												Column: 30,
												Line:   253,
											},
										},
									},
									Name: "groupColumns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   254,
										},
										File:   "universe.flux",
										Source: "reducer: (tables=<-) => tables |> last(column:column)",
										Start: ast.Position{
											Column: 17,
											Line:   254,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   254,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 17,
												Line:   254,
											},
										},
									},
									Name: "reducer",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   254,
											},
											File:   "universe.flux",
											Source: "(tables=<-) => tables |> last(column:column)",
											Start: ast.Position{
												Column: 26,
												Line:   254,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   254,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 41,
														Line:   254,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   254,
												},
												File:   "universe.flux",
												Source: "tables |> last(column:column)",
												Start: ast.Position{
													Column: 41,
													Line:   254,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   254,
														},
														File:   "universe.flux",
														Source: "column:column",
														Start: ast.Position{
															Column: 56,
															Line:   254,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   254,
															},
															File:   "universe.flux",
															Source: "column:column",
															Start: ast.Position{
																Column: 56,
																Line:   254,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   254,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 56,
																	Line:   254,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 69,
																	Line:   254,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 63,
																	Line:   254,
																},
															},
														},
														Name: "column",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   254,
													},
													File:   "universe.flux",
													Source: "last(column:column)",
													Start: ast.Position{
														Column: 51,
														Line:   254,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   254,
														},
														File:   "universe.flux",
														Source: "last",
														Start: ast.Position{
															Column: 51,
															Line:   254,
														},
													},
												},
												Name: "last",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   254,
												},
												File:   "universe.flux",
												Source: "tables=<-",
												Start: ast.Position{
													Column: 27,
													Line:   254,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   254,
													},
													File:   "universe.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 27,
														Line:   254,
													},
												},
											},
											Name: "tables",
										},
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   254,
												},
												File:   "universe.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 34,
													Line:   254,
												},
											},
										}},
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   255,
										},
										File:   "universe.flux",
										Source: "_sortLimit: bottom",
										Start: ast.Position{
											Column: 17,
											Line:   255,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   255,
											},
											File:   "universe.flux",
											Source: "_sortLimit",
											Start: ast.Position{
												Column: 17,
												Line:   255,
											},
										},
									},
									Name: "_sortLimit",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   255,
											},
											File:   "universe.flux",
											Source: "bottom",
											Start: ast.Position{
												Column: 29,
												Line:   255,
											},
										},
									},
									Name: "bottom",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   256,
								},
								File:   "universe.flux",
								Source: "_highestOrLowest(\n                n:n,\n                column:column,\n                groupColumns:groupColumns,\n                reducer: (tables=<-) => tables |> last(column:column),\n                _sortLimit: bottom,\n            )",
								Start: ast.Position{
									Column: 12,
									Line:   250,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   250,
									},
									File:   "universe.flux",
									Source: "_highestOrLowest",
									Start: ast.Position{
										Column: 12,
										Line:   250,
									},
								},
							},
							Name: "_highestOrLowest",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 18,
								Line:   248,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 18,
									Line:   248,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 21,
								Line:   248,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 21,
									Line:   248,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 28,
									Line:   248,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 38,
								Line:   248,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 38,
									Line:   248,
								},
							},
						},
						Name: "groupColumns",
					},
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 51,
									Line:   248,
								},
							},
						},
						Elements: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 55,
								Line:   248,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 55,
									Line:   248,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 62,
								Line:   248,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   266,
					},
					File:   "universe.flux",
					Source: "timedMovingAverage = (every, period, column=\"_value\", tables=<-) =>\n    tables\n        |> window(every: every, period: period)\n        |> mean(column:column)\n        |> duplicate(column: \"_stop\", as: \"_time\")\n        |> window(every: inf)",
					Start: ast.Position{
						Column: 1,
						Line:   261,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   261,
						},
						File:   "universe.flux",
						Source: "timedMovingAverage",
						Start: ast.Position{
							Column: 1,
							Line:   261,
						},
					},
				},
				Name: "timedMovingAverage",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   266,
						},
						File:   "universe.flux",
						Source: "(every, period, column=\"_value\", tables=<-) =>\n    tables\n        |> window(every: every, period: period)\n        |> mean(column:column)\n        |> duplicate(column: \"_stop\", as: \"_time\")\n        |> window(every: inf)",
						Start: ast.Position{
							Column: 22,
							Line:   261,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   262,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   262,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   263,
										},
										File:   "universe.flux",
										Source: "tables\n        |> window(every: every, period: period)",
										Start: ast.Position{
											Column: 5,
											Line:   262,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   263,
												},
												File:   "universe.flux",
												Source: "every: every, period: period",
												Start: ast.Position{
													Column: 19,
													Line:   263,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   263,
													},
													File:   "universe.flux",
													Source: "every: every",
													Start: ast.Position{
														Column: 19,
														Line:   263,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   263,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 19,
															Line:   263,
														},
													},
												},
												Name: "every",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   263,
														},
														File:   "universe.flux",
														Source: "every",
														Start: ast.Position{
															Column: 26,
															Line:   263,
														},
													},
												},
												Name: "every",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   263,
													},
													File:   "universe.flux",
													Source: "period: period",
													Start: ast.Position{
														Column: 33,
														Line:   263,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   263,
														},
														File:   "universe.flux",
														Source: "period",
														Start: ast.Position{
															Column: 33,
															Line:   263,
														},
													},
												},
												Name: "period",
											},
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   263,
														},
														File:   "universe.flux",
														Source: "period",
														Start: ast.Position{
															Column: 41,
															Line:   263,
														},
													},
												},
												Name: "period",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   263,
											},
											File:   "universe.flux",
											Source: "window(every: every, period: period)",
											Start: ast.Position{
												Column: 12,
												Line:   263,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   263,
												},
												File:   "universe.flux",
												Source: "window",
												Start: ast.Position{
													Column: 12,
													Line:   263,
												},
											},
										},
										Name: "window",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   264,
									},
									File:   "universe.flux",
									Source: "tables\n        |> window(every: every, period: period)\n        |> mean(column:column)",
									Start: ast.Position{
										Column: 5,
										Line:   262,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   264,
											},
											File:   "universe.flux",
											Source: "column:column",
											Start: ast.Position{
												Column: 17,
												Line:   264,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   264,
												},
												File:   "universe.flux",
												Source: "column:column",
												Start: ast.Position{
													Column: 17,
													Line:   264,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   264,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 17,
														Line:   264,
													},
												},
											},
											Name: "column",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   264,
													},
													File:   "universe.flux",
													Source: "column",
													Start: ast.Position{
														Column: 24,
														Line:   264,
													},
												},
											},
											Name: "column",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   264,
										},
										File:   "universe.flux",
										Source: "mean(column:column)",
										Start: ast.Position{
											Column: 12,
											Line:   264,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   264,
											},
											File:   "universe.flux",
											Source: "mean",
											Start: ast.Position{
												Column: 12,
												Line:   264,
											},
										},
									},
									Name: "mean",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   265,
								},
								File:   "universe.flux",
								Source: "tables\n        |> window(every: every, period: period)\n        |> mean(column:column)\n        |> duplicate(column: \"_stop\", as: \"_time\")",
								Start: ast.Position{
									Column: 5,
									Line:   262,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   265,
										},
										File:   "universe.flux",
										Source: "column: \"_stop\", as: \"_time\"",
										Start: ast.Position{
											Column: 22,
											Line:   265,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   265,
											},
											File:   "universe.flux",
											Source: "column: \"_stop\"",
											Start: ast.Position{
												Column: 22,
												Line:   265,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   265,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 22,
													Line:   265,
												},
											},
										},
										Name: "column",
									},
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   265,
												},
												File:   "universe.flux",
												Source: "\"_stop\"",
												Start: ast.Position{
													Column: 30,
													Line:   265,
												},
											},
										},
										Value: "_stop",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   265,
											},
											File:   "universe.flux",
											Source: "as: \"_time\"",
											Start: ast.Position{
												Column: 39,
												Line:   265,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   265,
												},
												File:   "universe.flux",
												Source: "as",
												Start: ast.Position{
													Column: 39,
													Line:   265,
												},
											},
										},
										Name: "as",
									},
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   265,
												},
												File:   "universe.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 43,
													Line:   265,
												},
											},
										},
										Value: "_time",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   265,
									},
									File:   "universe.flux",
									Source: "duplicate(column: \"_stop\", as: \"_time\")",
									Start: ast.Position{
										Column: 12,
										Line:   265,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   265,
										},
										File:   "universe.flux",
										Source: "duplicate",
										Start: ast.Position{
											Column: 12,
											Line:   265,
										},
									},
								},
								Name: "duplicate",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   266,
							},
							File:   "universe.flux",
							Source: "tables\n        |> window(every: every, period: period)\n        |> mean(column:column)\n        |> duplicate(column: \"_stop\", as: \"_time\")\n        |> window(every: inf)",
							Start: ast.Position{
								Column: 5,
								Line:   262,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   266,
									},
									File:   "universe.flux",
									Source: "every: inf",
									Start: ast.Position{
										Column: 19,
										Line:   266,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   266,
										},
										File:   "universe.flux",
										Source: "every: inf",
										Start: ast.Position{
											Column: 19,
											Line:   266,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   266,
											},
											File:   "universe.flux",
											Source: "every",
											Start: ast.Position{
												Column: 19,
												Line:   266,
											},
										},
									},
									Name: "every",
								},
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   266,
											},
											File:   "universe.flux",
											Source: "inf",
											Start: ast.Position{
												Column: 26,
												Line:   266,
											},
										},
									},
									Name: "inf",
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   266,
								},
								File:   "universe.flux",
								Source: "window(every: inf)",
								Start: ast.Position{
									Column: 12,
									Line:   266,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   266,
									},
									File:   "universe.flux",
									Source: "window",
									Start: ast.Position{
										Column: 12,
										Line:   266,
									},
								},
							},
							Name: "window",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   261,
							},
							File:   "universe.flux",
							Source: "every",
							Start: ast.Position{
								Column: 23,
								Line:   261,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   261,
								},
								File:   "universe.flux",
								Source: "every",
								Start: ast.Position{
									Column: 23,
									Line:   261,
								},
							},
						},
						Name: "every",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   261,
							},
							File:   "universe.flux",
							Source: "period",
							Start: ast.Position{
								Column: 30,
								Line:   261,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   261,
								},
								File:   "universe.flux",
								Source: "period",
								Start: ast.Position{
									Column: 30,
									Line:   261,
								},
							},
						},
						Name: "period",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   261,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 38,
								Line:   261,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   261,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 38,
									Line:   261,
								},
							},
						},
						Name: "column",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   261,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 45,
									Line:   261,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   261,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 55,
								Line:   261,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   261,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 55,
									Line:   261,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   261,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 62,
								Line:   261,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   279,
					},
					File:   "universe.flux",
					Source: "doubleEMA = (n, tables=<-) =>\n    tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")\n          |> exponentialMovingAverage(n:n)\n          |> map(fn: (r) => ({r with _value: 2.0*r.__ema - r._value}))\n          |> drop(columns: [\"__ema\"])",
					Start: ast.Position{
						Column: 1,
						Line:   273,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   273,
						},
						File:   "universe.flux",
						Source: "doubleEMA",
						Start: ast.Position{
							Column: 1,
							Line:   273,
						},
					},
				},
				Name: "doubleEMA",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   279,
						},
						File:   "universe.flux",
						Source: "(n, tables=<-) =>\n    tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")\n          |> exponentialMovingAverage(n:n)\n          |> map(fn: (r) => ({r with _value: 2.0*r.__ema - r._value}))\n          |> drop(columns: [\"__ema\"])",
						Start: ast.Position{
							Column: 13,
							Line:   273,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   274,
												},
												File:   "universe.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 5,
													Line:   274,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   275,
											},
											File:   "universe.flux",
											Source: "tables\n          |> exponentialMovingAverage(n:n)",
											Start: ast.Position{
												Column: 5,
												Line:   274,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   275,
													},
													File:   "universe.flux",
													Source: "n:n",
													Start: ast.Position{
														Column: 39,
														Line:   275,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   275,
														},
														File:   "universe.flux",
														Source: "n:n",
														Start: ast.Position{
															Column: 39,
															Line:   275,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   275,
															},
															File:   "universe.flux",
															Source: "n",
															Start: ast.Position{
																Column: 39,
																Line:   275,
															},
														},
													},
													Name: "n",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   275,
															},
															File:   "universe.flux",
															Source: "n",
															Start: ast.Position{
																Column: 41,
																Line:   275,
															},
														},
													},
													Name: "n",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   275,
												},
												File:   "universe.flux",
												Source: "exponentialMovingAverage(n:n)",
												Start: ast.Position{
													Column: 14,
													Line:   275,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   275,
													},
													File:   "universe.flux",
													Source: "exponentialMovingAverage",
													Start: ast.Position{
														Column: 14,
														Line:   275,
													},
												},
											},
											Name: "exponentialMovingAverage",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   276,
										},
										File:   "universe.flux",
										Source: "tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")",
										Start: ast.Position{
											Column: 5,
											Line:   274,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   276,
												},
												File:   "universe.flux",
												Source: "column:\"_value\", as:\"__ema\"",
												Start: ast.Position{
													Column: 24,
													Line:   276,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   276,
													},
													File:   "universe.flux",
													Source: "column:\"_value\"",
													Start: ast.Position{
														Column: 24,
														Line:   276,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   276,
														},
														File:   "universe.flux",
														Source: "column",
														Start: ast.Position{
															Column: 24,
															Line:   276,
														},
													},
												},
												Name: "column",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   276,
														},
														File:   "universe.flux",
														Source: "\"_value\"",
														Start: ast.Position{
															Column: 31,
															Line:   276,
														},
													},
												},
												Value: "_value",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   276,
													},
													File:   "universe.flux",
													Source: "as:\"__ema\"",
													Start: ast.Position{
														Column: 41,
														Line:   276,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   276,
														},
														File:   "universe.flux",
														Source: "as",
														Start: ast.Position{
															Column: 41,
															Line:   276,
														},
													},
												},
												Name: "as",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   276,
														},
														File:   "universe.flux",
														Source: "\"__ema\"",
														Start: ast.Position{
															Column: 44,
															Line:   276,
														},
													},
												},
												Value: "__ema",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   276,
											},
											File:   "universe.flux",
											Source: "duplicate(column:\"_value\", as:\"__ema\")",
											Start: ast.Position{
												Column: 14,
												Line:   276,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   276,
												},
												File:   "universe.flux",
												Source: "duplicate",
												Start: ast.Position{
													Column: 14,
													Line:   276,
												},
											},
										},
										Name: "duplicate",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   277,
									},
									File:   "universe.flux",
									Source: "tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")\n          |> exponentialMovingAverage(n:n)",
									Start: ast.Position{
										Column: 5,
										Line:   274,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   277,
											},
											File:   "universe.flux",
											Source: "n:n",
											Start: ast.Position{
												Column: 39,
												Line:   277,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   277,
												},
												File:   "universe.flux",
												Source: "n:n",
												Start: ast.Position{
													Column: 39,
													Line:   277,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   277,
													},
													File:   "universe.flux",
													Source: "n",
													Start: ast.Position{
														Column: 39,
														Line:   277,
													},
												},
											},
											Name: "n",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   277,
													},
													File:   "universe.flux",
													Source: "n",
													Start: ast.Position{
														Column: 41,
														Line:   277,
													},
												},
											},
											Name: "n",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   277,
										},
										File:   "universe.flux",
										Source: "exponentialMovingAverage(n:n)",
										Start: ast.Position{
											Column: 14,
											Line:   277,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   277,
											},
											File:   "universe.flux",
											Source: "exponentialMovingAverage",
											Start: ast.Position{
												Column: 14,
												Line:   277,
											},
										},
									},
									Name: "exponentialMovingAverage",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   278,
								},
								File:   "universe.flux",
								Source: "tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")\n          |> exponentialMovingAverage(n:n)\n          |> map(fn: (r) => ({r with _value: 2.0*r.__ema - r._value}))",
								Start: ast.Position{
									Column: 5,
									Line:   274,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   278,
										},
										File:   "universe.flux",
										Source: "fn: (r) => ({r with _value: 2.0*r.__ema - r._value})",
										Start: ast.Position{
											Column: 18,
											Line:   278,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   278,
											},
											File:   "universe.flux",
											Source: "fn: (r) => ({r with _value: 2.0*r.__ema - r._value})",
											Start: ast.Position{
												Column: 18,
												Line:   278,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   278,
												},
												File:   "universe.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 18,
													Line:   278,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   278,
												},
												File:   "universe.flux",
												Source: "(r) => ({r with _value: 2.0*r.__ema - r._value})",
												Start: ast.Position{
													Column: 22,
													Line:   278,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   278,
													},
													File:   "universe.flux",
													Source: "({r with _value: 2.0*r.__ema - r._value})",
													Start: ast.Position{
														Column: 29,
														Line:   278,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   278,
														},
														File:   "universe.flux",
														Source: "{r with _value: 2.0*r.__ema - r._value}",
														Start: ast.Position{
															Column: 30,
															Line:   278,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   278,
															},
															File:   "universe.flux",
															Source: "_value: 2.0*r.__ema - r._value",
															Start: ast.Position{
																Column: 38,
																Line:   278,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   278,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 38,
																	Line:   278,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 68,
																	Line:   278,
																},
																File:   "universe.flux",
																Source: "2.0*r.__ema - r._value",
																Start: ast.Position{
																	Column: 46,
																	Line:   278,
																},
															},
														},
														Left: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   278,
																	},
																	File:   "universe.flux",
																	Source: "2.0*r.__ema",
																	Start: ast.Position{
																		Column: 46,
																		Line:   278,
																	},
																},
															},
															Left: &ast.FloatLiteral{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   278,
																		},
																		File:   "universe.flux",
																		Source: "2.0",
																		Start: ast.Position{
																			Column: 46,
																			Line:   278,
																		},
																	},
																},
																Value: 2.0,
															},
															Operator: 1,
															Right: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   278,
																		},
																		File:   "universe.flux",
																		Source: "r.__ema",
																		Start: ast.Position{
																			Column: 50,
																			Line:   278,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   278,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 50,
																				Line:   278,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   278,
																			},
																			File:   "universe.flux",
																			Source: "__ema",
																			Start: ast.Position{
																				Column: 52,
																				Line:   278,
																			},
																		},
																	},
																	Name: "__ema",
																},
															},
														},
														Operator: 6,
														Right: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   278,
																	},
																	File:   "universe.flux",
																	Source: "r._value",
																	Start: ast.Position{
																		Column: 60,
																		Line:   278,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   278,
																		},
																		File:   "universe.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 60,
																			Line:   278,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   278,
																		},
																		File:   "universe.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 62,
																			Line:   278,
																		},
																	},
																},
																Name: "_value",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   278,
															},
															File:   "universe.flux",
															Source: "r",
															Start: ast.Position{
																Column: 31,
																Line:   278,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   278,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 23,
														Line:   278,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   278,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 23,
															Line:   278,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   278,
									},
									File:   "universe.flux",
									Source: "map(fn: (r) => ({r with _value: 2.0*r.__ema - r._value}))",
									Start: ast.Position{
										Column: 14,
										Line:   278,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   278,
										},
										File:   "universe.flux",
										Source: "map",
										Start: ast.Position{
											Column: 14,
											Line:   278,
										},
									},
								},
								Name: "map",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   279,
							},
							File:   "universe.flux",
							Source: "tables\n          |> exponentialMovingAverage(n:n)\n          |> duplicate(column:\"_value\", as:\"__ema\")\n          |> exponentialMovingAverage(n:n)\n          |> map(fn: (r) => ({r with _value: 2.0*r.__ema - r._value}))\n          |> drop(columns: [\"__ema\"])",
							Start: ast.Position{
								Column: 5,
								Line:   274,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   279,
									},
									File:   "universe.flux",
									Source: "columns: [\"__ema\"]",
									Start: ast.Position{
										Column: 19,
										Line:   279,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   279,
										},
										File:   "universe.flux",
										Source: "columns: [\"__ema\"]",
										Start: ast.Position{
											Column: 19,
											Line:   279,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   279,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 19,
												Line:   279,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   279,
											},
											File:   "universe.flux",
											Source: "[\"__ema\"]",
											Start: ast.Position{
												Column: 28,
												Line:   279,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   279,
												},
												File:   "universe.flux",
												Source: "\"__ema\"",
												Start: ast.Position{
													Column: 29,
													Line:   279,
												},
											},
										},
										Value: "__ema",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   279,
								},
								File:   "universe.flux",
								Source: "drop(columns: [\"__ema\"])",
								Start: ast.Position{
									Column: 14,
									Line:   279,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   279,
									},
									File:   "universe.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 14,
										Line:   279,
									},
								},
							},
							Name: "drop",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   273,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 14,
								Line:   273,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   273,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 14,
									Line:   273,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   273,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   273,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   273,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   273,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   273,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   273,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   295,
					},
					File:   "universe.flux",
					Source: "tripleEMA = (n, tables=<-) =>\n\ttables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> map(fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}))\n\t\t|> drop(columns: [\"__ema1\", \"__ema2\"])",
					Start: ast.Position{
						Column: 1,
						Line:   287,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   287,
						},
						File:   "universe.flux",
						Source: "tripleEMA",
						Start: ast.Position{
							Column: 1,
							Line:   287,
						},
					},
				},
				Name: "tripleEMA",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   295,
						},
						File:   "universe.flux",
						Source: "(n, tables=<-) =>\n\ttables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> map(fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}))\n\t\t|> drop(columns: [\"__ema1\", \"__ema2\"])",
						Start: ast.Position{
							Column: 13,
							Line:   287,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 8,
															Line:   288,
														},
														File:   "universe.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 2,
															Line:   288,
														},
													},
												},
												Name: "tables",
											},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   289,
													},
													File:   "universe.flux",
													Source: "tables\n\t\t|> exponentialMovingAverage(n:n)",
													Start: ast.Position{
														Column: 2,
														Line:   288,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   289,
															},
															File:   "universe.flux",
															Source: "n:n",
															Start: ast.Position{
																Column: 31,
																Line:   289,
															},
														},
													},
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   289,
																},
																File:   "universe.flux",
																Source: "n:n",
																Start: ast.Position{
																	Column: 31,
																	Line:   289,
																},
															},
														},
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   289,
																	},
																	File:   "universe.flux",
																	Source: "n",
																	Start: ast.Position{
																		Column: 31,
																		Line:   289,
																	},
																},
															},
															Name: "n",
														},
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   289,
																	},
																	File:   "universe.flux",
																	Source: "n",
																	Start: ast.Position{
																		Column: 33,
																		Line:   289,
																	},
																},
															},
															Name: "n",
														},
													}},
													With: nil,
												}},
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   289,
														},
														File:   "universe.flux",
														Source: "exponentialMovingAverage(n:n)",
														Start: ast.Position{
															Column: 6,
															Line:   289,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   289,
															},
															File:   "universe.flux",
															Source: "exponentialMovingAverage",
															Start: ast.Position{
																Column: 6,
																Line:   289,
															},
														},
													},
													Name: "exponentialMovingAverage",
												},
											},
										},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   290,
												},
												File:   "universe.flux",
												Source: "tables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")",
												Start: ast.Position{
													Column: 2,
													Line:   288,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   290,
														},
														File:   "universe.flux",
														Source: "column:\"_value\", as:\"__ema1\"",
														Start: ast.Position{
															Column: 16,
															Line:   290,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   290,
															},
															File:   "universe.flux",
															Source: "column:\"_value\"",
															Start: ast.Position{
																Column: 16,
																Line:   290,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   290,
																},
																File:   "universe.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 16,
																	Line:   290,
																},
															},
														},
														Name: "column",
													},
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   290,
																},
																File:   "universe.flux",
																Source: "\"_value\"",
																Start: ast.Position{
																	Column: 23,
																	Line:   290,
																},
															},
														},
														Value: "_value",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   290,
															},
															File:   "universe.flux",
															Source: "as:\"__ema1\"",
															Start: ast.Position{
																Column: 33,
																Line:   290,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   290,
																},
																File:   "universe.flux",
																Source: "as",
																Start: ast.Position{
																	Column: 33,
																	Line:   290,
																},
															},
														},
														Name: "as",
													},
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   290,
																},
																File:   "universe.flux",
																Source: "\"__ema1\"",
																Start: ast.Position{
																	Column: 36,
																	Line:   290,
																},
															},
														},
														Value: "__ema1",
													},
												}},
												With: nil,
											}},
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   290,
													},
													File:   "universe.flux",
													Source: "duplicate(column:\"_value\", as:\"__ema1\")",
													Start: ast.Position{
														Column: 6,
														Line:   290,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   290,
														},
														File:   "universe.flux",
														Source: "duplicate",
														Start: ast.Position{
															Column: 6,
															Line:   290,
														},
													},
												},
												Name: "duplicate",
											},
										},
									},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   291,
											},
											File:   "universe.flux",
											Source: "tables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)",
											Start: ast.Position{
												Column: 2,
												Line:   288,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   291,
													},
													File:   "universe.flux",
													Source: "n:n",
													Start: ast.Position{
														Column: 31,
														Line:   291,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   291,
														},
														File:   "universe.flux",
														Source: "n:n",
														Start: ast.Position{
															Column: 31,
															Line:   291,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 32,
																Line:   291,
															},
															File:   "universe.flux",
															Source: "n",
															Start: ast.Position{
																Column: 31,
																Line:   291,
															},
														},
													},
													Name: "n",
												},
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   291,
															},
															File:   "universe.flux",
															Source: "n",
															Start: ast.Position{
																Column: 33,
																Line:   291,
															},
														},
													},
													Name: "n",
												},
											}},
											With: nil,
										}},
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   291,
												},
												File:   "universe.flux",
												Source: "exponentialMovingAverage(n:n)",
												Start: ast.Position{
													Column: 6,
													Line:   291,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   291,
													},
													File:   "universe.flux",
													Source: "exponentialMovingAverage",
													Start: ast.Position{
														Column: 6,
														Line:   291,
													},
												},
											},
											Name: "exponentialMovingAverage",
										},
									},
								},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   292,
										},
										File:   "universe.flux",
										Source: "tables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")",
										Start: ast.Position{
											Column: 2,
											Line:   288,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   292,
												},
												File:   "universe.flux",
												Source: "column:\"_value\", as:\"__ema2\"",
												Start: ast.Position{
													Column: 16,
													Line:   292,
												},
											},
										},
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   292,
													},
													File:   "universe.flux",
													Source: "column:\"_value\"",
													Start: ast.Position{
														Column: 16,
														Line:   292,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   292,
														},
														File:   "universe.flux",
														Source: "column",
														Start: ast.Position{
															Column: 16,
															Line:   292,
														},
													},
												},
												Name: "column",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   292,
														},
														File:   "universe.flux",
														Source: "\"_value\"",
														Start: ast.Position{
															Column: 23,
															Line:   292,
														},
													},
												},
												Value: "_value",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   292,
													},
													File:   "universe.flux",
													Source: "as:\"__ema2\"",
													Start: ast.Position{
														Column: 33,
														Line:   292,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   292,
														},
														File:   "universe.flux",
														Source: "as",
														Start: ast.Position{
															Column: 33,
															Line:   292,
														},
													},
												},
												Name: "as",
											},
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   292,
														},
														File:   "universe.flux",
														Source: "\"__ema2\"",
														Start: ast.Position{
															Column: 36,
															Line:   292,
														},
													},
												},
												Value: "__ema2",
											},
										}},
										With: nil,
									}},
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   292,
											},
											File:   "universe.flux",
											Source: "duplicate(column:\"_value\", as:\"__ema2\")",
											Start: ast.Position{
												Column: 6,
												Line:   292,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   292,
												},
												File:   "universe.flux",
												Source: "duplicate",
												Start: ast.Position{
													Column: 6,
													Line:   292,
												},
											},
										},
										Name: "duplicate",
									},
								},
							},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   293,
									},
									File:   "universe.flux",
									Source: "tables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")\n\t\t|> exponentialMovingAverage(n:n)",
									Start: ast.Position{
										Column: 2,
										Line:   288,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   293,
											},
											File:   "universe.flux",
											Source: "n:n",
											Start: ast.Position{
												Column: 31,
												Line:   293,
											},
										},
									},
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   293,
												},
												File:   "universe.flux",
												Source: "n:n",
												Start: ast.Position{
													Column: 31,
													Line:   293,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   293,
													},
													File:   "universe.flux",
													Source: "n",
													Start: ast.Position{
														Column: 31,
														Line:   293,
													},
												},
											},
											Name: "n",
										},
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   293,
													},
													File:   "universe.flux",
													Source: "n",
													Start: ast.Position{
														Column: 33,
														Line:   293,
													},
												},
											},
											Name: "n",
										},
									}},
									With: nil,
								}},
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   293,
										},
										File:   "universe.flux",
										Source: "exponentialMovingAverage(n:n)",
										Start: ast.Position{
											Column: 6,
											Line:   293,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   293,
											},
											File:   "universe.flux",
											Source: "exponentialMovingAverage",
											Start: ast.Position{
												Column: 6,
												Line:   293,
											},
										},
									},
									Name: "exponentialMovingAverage",
								},
							},
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   294,
								},
								File:   "universe.flux",
								Source: "tables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> map(fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}))",
								Start: ast.Position{
									Column: 2,
									Line:   288,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   294,
										},
										File:   "universe.flux",
										Source: "fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value})",
										Start: ast.Position{
											Column: 10,
											Line:   294,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   294,
											},
											File:   "universe.flux",
											Source: "fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value})",
											Start: ast.Position{
												Column: 10,
												Line:   294,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   294,
												},
												File:   "universe.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   294,
												},
											},
										},
										Name: "fn",
									},
									Value: &ast.FunctionExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   294,
												},
												File:   "universe.flux",
												Source: "(r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value})",
												Start: ast.Position{
													Column: 14,
													Line:   294,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   294,
													},
													File:   "universe.flux",
													Source: "({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value})",
													Start: ast.Position{
														Column: 21,
														Line:   294,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   294,
														},
														File:   "universe.flux",
														Source: "{r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}",
														Start: ast.Position{
															Column: 22,
															Line:   294,
														},
													},
												},
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   294,
															},
															File:   "universe.flux",
															Source: "_value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value",
															Start: ast.Position{
																Column: 30,
																Line:   294,
															},
														},
													},
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   294,
																},
																File:   "universe.flux",
																Source: "_value",
																Start: ast.Position{
																	Column: 30,
																	Line:   294,
																},
															},
														},
														Name: "_value",
													},
													Value: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   294,
																},
																File:   "universe.flux",
																Source: "3.0*r.__ema1 - 3.0*r.__ema2 + r._value",
																Start: ast.Position{
																	Column: 38,
																	Line:   294,
																},
															},
														},
														Left: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   294,
																	},
																	File:   "universe.flux",
																	Source: "3.0*r.__ema1 - 3.0*r.__ema2",
																	Start: ast.Position{
																		Column: 38,
																		Line:   294,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   294,
																		},
																		File:   "universe.flux",
																		Source: "3.0*r.__ema1",
																		Start: ast.Position{
																			Column: 38,
																			Line:   294,
																		},
																	},
																},
																Left: &ast.FloatLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   294,
																			},
																			File:   "universe.flux",
																			Source: "3.0",
																			Start: ast.Position{
																				Column: 38,
																				Line:   294,
																			},
																		},
																	},
																	Value: 3.0,
																},
																Operator: 1,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 50,
																				Line:   294,
																			},
																			File:   "universe.flux",
																			Source: "r.__ema1",
																			Start: ast.Position{
																				Column: 42,
																				Line:   294,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 43,
																					Line:   294,
																				},
																				File:   "universe.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 42,
																					Line:   294,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 50,
																					Line:   294,
																				},
																				File:   "universe.flux",
																				Source: "__ema1",
																				Start: ast.Position{
																					Column: 44,
																					Line:   294,
																				},
																			},
																		},
																		Name: "__ema1",
																	},
																},
															},
															Operator: 6,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 65,
																			Line:   294,
																		},
																		File:   "universe.flux",
																		Source: "3.0*r.__ema2",
																		Start: ast.Position{
																			Column: 53,
																			Line:   294,
																		},
																	},
																},
																Left: &ast.FloatLiteral{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   294,
																			},
																			File:   "universe.flux",
																			Source: "3.0",
																			Start: ast.Position{
																				Column: 53,
																				Line:   294,
																			},
																		},
																	},
																	Value: 3.0,
																},
																Operator: 1,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   294,
																			},
																			File:   "universe.flux",
																			Source: "r.__ema2",
																			Start: ast.Position{
																				Column: 57,
																				Line:   294,
																			},
																		},
																	},
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   294,
																				},
																				File:   "universe.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 57,
																					Line:   294,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 65,
																					Line:   294,
																				},
																				File:   "universe.flux",
																				Source: "__ema2",
																				Start: ast.Position{
																					Column: 59,
																					Line:   294,
																				},
																			},
																		},
																		Name: "__ema2",
																	},
																},
															},
														},
														Operator: 5,
														Right: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   294,
																	},
																	File:   "universe.flux",
																	Source: "r._value",
																	Start: ast.Position{
																		Column: 68,
																		Line:   294,
																	},
																},
															},
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   294,
																		},
																		File:   "universe.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 68,
																			Line:   294,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   294,
																		},
																		File:   "universe.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 70,
																			Line:   294,
																		},
																	},
																},
																Name: "_value",
															},
														},
													},
												}},
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   294,
															},
															File:   "universe.flux",
															Source: "r",
															Start: ast.Position{
																Column: 23,
																Line:   294,
															},
														},
													},
													Name: "r",
												},
											},
										},
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   294,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   294,
													},
												},
											},
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   294,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 15,
															Line:   294,
														},
													},
												},
												Name: "r",
											},
											Value: nil,
										}},
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   294,
									},
									File:   "universe.flux",
									Source: "map(fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}))",
									Start: ast.Position{
										Column: 6,
										Line:   294,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   294,
										},
										File:   "universe.flux",
										Source: "map",
										Start: ast.Position{
											Column: 6,
											Line:   294,
										},
									},
								},
								Name: "map",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   295,
							},
							File:   "universe.flux",
							Source: "tables\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema1\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> duplicate(column:\"_value\", as:\"__ema2\")\n\t\t|> exponentialMovingAverage(n:n)\n\t\t|> map(fn: (r) => ({r with _value: 3.0*r.__ema1 - 3.0*r.__ema2 + r._value}))\n\t\t|> drop(columns: [\"__ema1\", \"__ema2\"])",
							Start: ast.Position{
								Column: 2,
								Line:   288,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   295,
									},
									File:   "universe.flux",
									Source: "columns: [\"__ema1\", \"__ema2\"]",
									Start: ast.Position{
										Column: 11,
										Line:   295,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   295,
										},
										File:   "universe.flux",
										Source: "columns: [\"__ema1\", \"__ema2\"]",
										Start: ast.Position{
											Column: 11,
											Line:   295,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   295,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 11,
												Line:   295,
											},
										},
									},
									Name: "columns",
								},
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   295,
											},
											File:   "universe.flux",
											Source: "[\"__ema1\", \"__ema2\"]",
											Start: ast.Position{
												Column: 20,
												Line:   295,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   295,
												},
												File:   "universe.flux",
												Source: "\"__ema1\"",
												Start: ast.Position{
													Column: 21,
													Line:   295,
												},
											},
										},
										Value: "__ema1",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   295,
												},
												File:   "universe.flux",
												Source: "\"__ema2\"",
												Start: ast.Position{
													Column: 31,
													Line:   295,
												},
											},
										},
										Value: "__ema2",
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   295,
								},
								File:   "universe.flux",
								Source: "drop(columns: [\"__ema1\", \"__ema2\"])",
								Start: ast.Position{
									Column: 6,
									Line:   295,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   295,
									},
									File:   "universe.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 6,
										Line:   295,
									},
								},
							},
							Name: "drop",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   287,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 14,
								Line:   287,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   287,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 14,
									Line:   287,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   287,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   287,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   287,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   287,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   287,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   287,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   301,
					},
					File:   "universe.flux",
					Source: "truncateTimeColumn = (timeColumn=\"_time\", unit, tables=<-) =>\n    tables\n        |> map(fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))",
					Start: ast.Position{
						Column: 1,
						Line:   299,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   299,
						},
						File:   "universe.flux",
						Source: "truncateTimeColumn",
						Start: ast.Position{
							Column: 1,
							Line:   299,
						},
					},
				},
				Name: "truncateTimeColumn",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   301,
						},
						File:   "universe.flux",
						Source: "(timeColumn=\"_time\", unit, tables=<-) =>\n    tables\n        |> map(fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))",
						Start: ast.Position{
							Column: 22,
							Line:   299,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   300,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   300,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   301,
							},
							File:   "universe.flux",
							Source: "tables\n        |> map(fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))",
							Start: ast.Position{
								Column: 5,
								Line:   300,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   301,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)})",
									Start: ast.Position{
										Column: 16,
										Line:   301,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   301,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)})",
										Start: ast.Position{
											Column: 16,
											Line:   301,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 16,
												Line:   301,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _time: date.truncate(t: r._time, unit: unit)})",
											Start: ast.Position{
												Column: 19,
												Line:   301,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 81,
													Line:   301,
												},
												File:   "universe.flux",
												Source: "({r with _time: date.truncate(t: r._time, unit: unit)})",
												Start: ast.Position{
													Column: 26,
													Line:   301,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   301,
													},
													File:   "universe.flux",
													Source: "{r with _time: date.truncate(t: r._time, unit: unit)}",
													Start: ast.Position{
														Column: 27,
														Line:   301,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   301,
														},
														File:   "universe.flux",
														Source: "_time: date.truncate(t: r._time, unit: unit)",
														Start: ast.Position{
															Column: 35,
															Line:   301,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   301,
															},
															File:   "universe.flux",
															Source: "_time",
															Start: ast.Position{
																Column: 35,
																Line:   301,
															},
														},
													},
													Name: "_time",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   301,
																},
																File:   "universe.flux",
																Source: "t: r._time, unit: unit",
																Start: ast.Position{
																	Column: 56,
																	Line:   301,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   301,
																	},
																	File:   "universe.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 56,
																		Line:   301,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   301,
																		},
																		File:   "universe.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 56,
																			Line:   301,
																		},
																	},
																},
																Name: "t",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   301,
																		},
																		File:   "universe.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 59,
																			Line:   301,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   301,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 59,
																				Line:   301,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   301,
																			},
																			File:   "universe.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 61,
																				Line:   301,
																			},
																		},
																	},
																	Name: "_time",
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 78,
																		Line:   301,
																	},
																	File:   "universe.flux",
																	Source: "unit: unit",
																	Start: ast.Position{
																		Column: 68,
																		Line:   301,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   301,
																		},
																		File:   "universe.flux",
																		Source: "unit",
																		Start: ast.Position{
																			Column: 68,
																			Line:   301,
																		},
																	},
																},
																Name: "unit",
															},
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   301,
																		},
																		File:   "universe.flux",
																		Source: "unit",
																		Start: ast.Position{
																			Column: 74,
																			Line:   301,
																		},
																	},
																},
																Name: "unit",
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 79,
																Line:   301,
															},
															File:   "universe.flux",
															Source: "date.truncate(t: r._time, unit: unit)",
															Start: ast.Position{
																Column: 42,
																Line:   301,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   301,
																},
																File:   "universe.flux",
																Source: "date.truncate",
																Start: ast.Position{
																	Column: 42,
																	Line:   301,
																},
															},
														},
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   301,
																	},
																	File:   "universe.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 42,
																		Line:   301,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   301,
																	},
																	File:   "universe.flux",
																	Source: "truncate",
																	Start: ast.Position{
																		Column: 47,
																		Line:   301,
																	},
																},
															},
															Name: "truncate",
														},
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   301,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 28,
															Line:   301,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   301,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   301,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   301,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   301,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   301,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))",
								Start: ast.Position{
									Column: 12,
									Line:   301,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   301,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 12,
										Line:   301,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   299,
							},
							File:   "universe.flux",
							Source: "timeColumn=\"_time\"",
							Start: ast.Position{
								Column: 23,
								Line:   299,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   299,
								},
								File:   "universe.flux",
								Source: "timeColumn",
								Start: ast.Position{
									Column: 23,
									Line:   299,
								},
							},
						},
						Name: "timeColumn",
					},
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   299,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 34,
									Line:   299,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   299,
							},
							File:   "universe.flux",
							Source: "unit",
							Start: ast.Position{
								Column: 43,
								Line:   299,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   299,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 43,
									Line:   299,
								},
							},
						},
						Name: "unit",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   299,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 49,
								Line:   299,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   299,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 49,
									Line:   299,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   299,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 56,
								Line:   299,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 75,
						Line:   307,
					},
					File:   "universe.flux",
					Source: "kaufmansER = (n, tables=<-) =>\n    tables\n        |> chandeMomentumOscillator(n: n)\n        |> map(fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)}))",
					Start: ast.Position{
						Column: 1,
						Line:   304,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   304,
						},
						File:   "universe.flux",
						Source: "kaufmansER",
						Start: ast.Position{
							Column: 1,
							Line:   304,
						},
					},
				},
				Name: "kaufmansER",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 75,
							Line:   307,
						},
						File:   "universe.flux",
						Source: "(n, tables=<-) =>\n    tables\n        |> chandeMomentumOscillator(n: n)\n        |> map(fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)}))",
						Start: ast.Position{
							Column: 14,
							Line:   304,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   305,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   305,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   306,
								},
								File:   "universe.flux",
								Source: "tables\n        |> chandeMomentumOscillator(n: n)",
								Start: ast.Position{
									Column: 5,
									Line:   305,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   306,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 37,
											Line:   306,
										},
									},
								},
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   306,
											},
											File:   "universe.flux",
											Source: "n: n",
											Start: ast.Position{
												Column: 37,
												Line:   306,
											},
										},
									},
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   306,
												},
												File:   "universe.flux",
												Source: "n",
												Start: ast.Position{
													Column: 37,
													Line:   306,
												},
											},
										},
										Name: "n",
									},
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   306,
												},
												File:   "universe.flux",
												Source: "n",
												Start: ast.Position{
													Column: 40,
													Line:   306,
												},
											},
										},
										Name: "n",
									},
								}},
								With: nil,
							}},
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   306,
									},
									File:   "universe.flux",
									Source: "chandeMomentumOscillator(n: n)",
									Start: ast.Position{
										Column: 12,
										Line:   306,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   306,
										},
										File:   "universe.flux",
										Source: "chandeMomentumOscillator",
										Start: ast.Position{
											Column: 12,
											Line:   306,
										},
									},
								},
								Name: "chandeMomentumOscillator",
							},
						},
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   307,
							},
							File:   "universe.flux",
							Source: "tables\n        |> chandeMomentumOscillator(n: n)\n        |> map(fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)}))",
							Start: ast.Position{
								Column: 5,
								Line:   305,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   307,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)})",
									Start: ast.Position{
										Column: 16,
										Line:   307,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   307,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)})",
										Start: ast.Position{
											Column: 16,
											Line:   307,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   307,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 16,
												Line:   307,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   307,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: (math.abs(x: r._value)/100.0)})",
											Start: ast.Position{
												Column: 19,
												Line:   307,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   307,
												},
												File:   "universe.flux",
												Source: "({r with _value: (math.abs(x: r._value)/100.0)})",
												Start: ast.Position{
													Column: 26,
													Line:   307,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   307,
													},
													File:   "universe.flux",
													Source: "{r with _value: (math.abs(x: r._value)/100.0)}",
													Start: ast.Position{
														Column: 27,
														Line:   307,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   307,
														},
														File:   "universe.flux",
														Source: "_value: (math.abs(x: r._value)/100.0)",
														Start: ast.Position{
															Column: 35,
															Line:   307,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   307,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 35,
																Line:   307,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   307,
															},
															File:   "universe.flux",
															Source: "(math.abs(x: r._value)/100.0)",
															Start: ast.Position{
																Column: 43,
																Line:   307,
															},
														},
													},
													Expression: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 71,
																	Line:   307,
																},
																File:   "universe.flux",
																Source: "math.abs(x: r._value)/100.0",
																Start: ast.Position{
																	Column: 44,
																	Line:   307,
																},
															},
														},
														Left: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   307,
																		},
																		File:   "universe.flux",
																		Source: "x: r._value",
																		Start: ast.Position{
																			Column: 53,
																			Line:   307,
																		},
																	},
																},
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   307,
																			},
																			File:   "universe.flux",
																			Source: "x: r._value",
																			Start: ast.Position{
																				Column: 53,
																				Line:   307,
																			},
																		},
																	},
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   307,
																				},
																				File:   "universe.flux",
																				Source: "x",
																				Start: ast.Position{
																					Column: 53,
																					Line:   307,
																				},
																			},
																		},
																		Name: "x",
																	},
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Errors: nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 64,
																					Line:   307,
																				},
																				File:   "universe.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 56,
																					Line:   307,
																				},
																			},
																		},
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 57,
																						Line:   307,
																					},
																					File:   "universe.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 56,
																						Line:   307,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Errors: nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   307,
																					},
																					File:   "universe.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 58,
																						Line:   307,
																					},
																				},
																			},
																			Name: "_value",
																		},
																	},
																}},
																With: nil,
															}},
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 65,
																		Line:   307,
																	},
																	File:   "universe.flux",
																	Source: "math.abs(x: r._value)",
																	Start: ast.Position{
																		Column: 44,
																		Line:   307,
																	},
																},
															},
															Callee: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 52,
																			Line:   307,
																		},
																		File:   "universe.flux",
																		Source: "math.abs",
																		Start: ast.Position{
																			Column: 44,
																			Line:   307,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   307,
																			},
																			File:   "universe.flux",
																			Source: "math",
																			Start: ast.Position{
																				Column: 44,
																				Line:   307,
																			},
																		},
																	},
																	Name: "math",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 52,
																				Line:   307,
																			},
																			File:   "universe.flux",
																			Source: "abs",
																			Start: ast.Position{
																				Column: 49,
																				Line:   307,
																			},
																		},
																	},
																	Name: "abs",
																},
															},
														},
														Operator: 2,
														Right: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 71,
																		Line:   307,
																	},
																	File:   "universe.flux",
																	Source: "100.0",
																	Start: ast.Position{
																		Column: 66,
																		Line:   307,
																	},
																},
															},
															Value: 100.0,
														},
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   307,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 28,
															Line:   307,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   307,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   307,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   307,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   307,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   307,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: (math.abs(x: r._value)/100.0)}))",
								Start: ast.Position{
									Column: 12,
									Line:   307,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   307,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 12,
										Line:   307,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   304,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   304,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   304,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   304,
								},
							},
						},
						Name: "n",
					},
					Value: nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   304,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 18,
								Line:   304,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   304,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 18,
									Line:   304,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   304,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   304,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 91,
						Line:   309,
					},
					File:   "universe.flux",
					Source: "toString   = (tables=<-) => tables |> map(fn:(r) => ({r with _value: string(v:r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   309,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   309,
						},
						File:   "universe.flux",
						Source: "toString",
						Start: ast.Position{
							Column: 1,
							Line:   309,
						},
					},
				},
				Name: "toString",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 91,
							Line:   309,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => ({r with _value: string(v:r._value)}))",
						Start: ast.Position{
							Column: 14,
							Line:   309,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   309,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   309,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 91,
								Line:   309,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => ({r with _value: string(v:r._value)}))",
							Start: ast.Position{
								Column: 29,
								Line:   309,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 90,
										Line:   309,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: string(v:r._value)})",
									Start: ast.Position{
										Column: 43,
										Line:   309,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   309,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: string(v:r._value)})",
										Start: ast.Position{
											Column: 43,
											Line:   309,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   309,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   309,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   309,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: string(v:r._value)})",
											Start: ast.Position{
												Column: 46,
												Line:   309,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   309,
												},
												File:   "universe.flux",
												Source: "({r with _value: string(v:r._value)})",
												Start: ast.Position{
													Column: 53,
													Line:   309,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   309,
													},
													File:   "universe.flux",
													Source: "{r with _value: string(v:r._value)}",
													Start: ast.Position{
														Column: 54,
														Line:   309,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   309,
														},
														File:   "universe.flux",
														Source: "_value: string(v:r._value)",
														Start: ast.Position{
															Column: 62,
															Line:   309,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   309,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 62,
																Line:   309,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   309,
																},
																File:   "universe.flux",
																Source: "v:r._value",
																Start: ast.Position{
																	Column: 77,
																	Line:   309,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   309,
																	},
																	File:   "universe.flux",
																	Source: "v:r._value",
																	Start: ast.Position{
																		Column: 77,
																		Line:   309,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   309,
																		},
																		File:   "universe.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 77,
																			Line:   309,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   309,
																		},
																		File:   "universe.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 79,
																			Line:   309,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   309,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 79,
																				Line:   309,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 87,
																				Line:   309,
																			},
																			File:   "universe.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 81,
																				Line:   309,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   309,
															},
															File:   "universe.flux",
															Source: "string(v:r._value)",
															Start: ast.Position{
																Column: 70,
																Line:   309,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   309,
																},
																File:   "universe.flux",
																Source: "string",
																Start: ast.Position{
																	Column: 70,
																	Line:   309,
																},
															},
														},
														Name: "string",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   309,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 55,
															Line:   309,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   309,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   309,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   309,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   309,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   309,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: string(v:r._value)}))",
								Start: ast.Position{
									Column: 39,
									Line:   309,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   309,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   309,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   309,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   309,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   309,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   309,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   309,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   309,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 88,
						Line:   310,
					},
					File:   "universe.flux",
					Source: "toInt      = (tables=<-) => tables |> map(fn:(r) => ({r with _value: int(v:r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   310,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   310,
						},
						File:   "universe.flux",
						Source: "toInt",
						Start: ast.Position{
							Column: 1,
							Line:   310,
						},
					},
				},
				Name: "toInt",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 88,
							Line:   310,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => ({r with _value: int(v:r._value)}))",
						Start: ast.Position{
							Column: 14,
							Line:   310,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   310,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   310,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   310,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => ({r with _value: int(v:r._value)}))",
							Start: ast.Position{
								Column: 29,
								Line:   310,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 87,
										Line:   310,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: int(v:r._value)})",
									Start: ast.Position{
										Column: 43,
										Line:   310,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 87,
											Line:   310,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: int(v:r._value)})",
										Start: ast.Position{
											Column: 43,
											Line:   310,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   310,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   310,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   310,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: int(v:r._value)})",
											Start: ast.Position{
												Column: 46,
												Line:   310,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   310,
												},
												File:   "universe.flux",
												Source: "({r with _value: int(v:r._value)})",
												Start: ast.Position{
													Column: 53,
													Line:   310,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   310,
													},
													File:   "universe.flux",
													Source: "{r with _value: int(v:r._value)}",
													Start: ast.Position{
														Column: 54,
														Line:   310,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   310,
														},
														File:   "universe.flux",
														Source: "_value: int(v:r._value)",
														Start: ast.Position{
															Column: 62,
															Line:   310,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   310,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 62,
																Line:   310,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   310,
																},
																File:   "universe.flux",
																Source: "v:r._value",
																Start: ast.Position{
																	Column: 74,
																	Line:   310,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 84,
																		Line:   310,
																	},
																	File:   "universe.flux",
																	Source: "v:r._value",
																	Start: ast.Position{
																		Column: 74,
																		Line:   310,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   310,
																		},
																		File:   "universe.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 74,
																			Line:   310,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 84,
																			Line:   310,
																		},
																		File:   "universe.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 76,
																			Line:   310,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   310,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 76,
																				Line:   310,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   310,
																			},
																			File:   "universe.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 78,
																				Line:   310,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   310,
															},
															File:   "universe.flux",
															Source: "int(v:r._value)",
															Start: ast.Position{
																Column: 70,
																Line:   310,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 73,
																	Line:   310,
																},
																File:   "universe.flux",
																Source: "int",
																Start: ast.Position{
																	Column: 70,
																	Line:   310,
																},
															},
														},
														Name: "int",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   310,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 55,
															Line:   310,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   310,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   310,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   310,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   310,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   310,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: int(v:r._value)}))",
								Start: ast.Position{
									Column: 39,
									Line:   310,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   310,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   310,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   310,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   310,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   310,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   310,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   310,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   310,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   311,
					},
					File:   "universe.flux",
					Source: "toUInt     = (tables=<-) => tables |> map(fn:(r) => ({r with _value: uint(v:r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   311,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   311,
						},
						File:   "universe.flux",
						Source: "toUInt",
						Start: ast.Position{
							Column: 1,
							Line:   311,
						},
					},
				},
				Name: "toUInt",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   311,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => ({r with _value: uint(v:r._value)}))",
						Start: ast.Position{
							Column: 14,
							Line:   311,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   311,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   311,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   311,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => ({r with _value: uint(v:r._value)}))",
							Start: ast.Position{
								Column: 29,
								Line:   311,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   311,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: uint(v:r._value)})",
									Start: ast.Position{
										Column: 43,
										Line:   311,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   311,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: uint(v:r._value)})",
										Start: ast.Position{
											Column: 43,
											Line:   311,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   311,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   311,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   311,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: uint(v:r._value)})",
											Start: ast.Position{
												Column: 46,
												Line:   311,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   311,
												},
												File:   "universe.flux",
												Source: "({r with _value: uint(v:r._value)})",
												Start: ast.Position{
													Column: 53,
													Line:   311,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   311,
													},
													File:   "universe.flux",
													Source: "{r with _value: uint(v:r._value)}",
													Start: ast.Position{
														Column: 54,
														Line:   311,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 86,
															Line:   311,
														},
														File:   "universe.flux",
														Source: "_value: uint(v:r._value)",
														Start: ast.Position{
															Column: 62,
															Line:   311,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   311,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 62,
																Line:   311,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   311,
																},
																File:   "universe.flux",
																Source: "v:r._value",
																Start: ast.Position{
																	Column: 75,
																	Line:   311,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   311,
																	},
																	File:   "universe.flux",
																	Source: "v:r._value",
																	Start: ast.Position{
																		Column: 75,
																		Line:   311,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   311,
																		},
																		File:   "universe.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 75,
																			Line:   311,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   311,
																		},
																		File:   "universe.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 77,
																			Line:   311,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   311,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 77,
																				Line:   311,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 85,
																				Line:   311,
																			},
																			File:   "universe.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 79,
																				Line:   311,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 86,
																Line:   311,
															},
															File:   "universe.flux",
															Source: "uint(v:r._value)",
															Start: ast.Position{
																Column: 70,
																Line:   311,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   311,
																},
																File:   "universe.flux",
																Source: "uint",
																Start: ast.Position{
																	Column: 70,
																	Line:   311,
																},
															},
														},
														Name: "uint",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   311,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 55,
															Line:   311,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   311,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   311,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   311,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   311,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   311,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: uint(v:r._value)}))",
								Start: ast.Position{
									Column: 39,
									Line:   311,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   311,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   311,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   311,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   311,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   311,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   311,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   311,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   311,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 90,
						Line:   312,
					},
					File:   "universe.flux",
					Source: "toFloat    = (tables=<-) => tables |> map(fn:(r) => ({r with _value: float(v:r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   312,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   312,
						},
						File:   "universe.flux",
						Source: "toFloat",
						Start: ast.Position{
							Column: 1,
							Line:   312,
						},
					},
				},
				Name: "toFloat",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   312,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => ({r with _value: float(v:r._value)}))",
						Start: ast.Position{
							Column: 14,
							Line:   312,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   312,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   312,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   312,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => ({r with _value: float(v:r._value)}))",
							Start: ast.Position{
								Column: 29,
								Line:   312,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   312,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: float(v:r._value)})",
									Start: ast.Position{
										Column: 43,
										Line:   312,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   312,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: float(v:r._value)})",
										Start: ast.Position{
											Column: 43,
											Line:   312,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   312,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   312,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 89,
												Line:   312,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: float(v:r._value)})",
											Start: ast.Position{
												Column: 46,
												Line:   312,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   312,
												},
												File:   "universe.flux",
												Source: "({r with _value: float(v:r._value)})",
												Start: ast.Position{
													Column: 53,
													Line:   312,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   312,
													},
													File:   "universe.flux",
													Source: "{r with _value: float(v:r._value)}",
													Start: ast.Position{
														Column: 54,
														Line:   312,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   312,
														},
														File:   "universe.flux",
														Source: "_value: float(v:r._value)",
														Start: ast.Position{
															Column: 62,
															Line:   312,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   312,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 62,
																Line:   312,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 86,
																	Line:   312,
																},
																File:   "universe.flux",
																Source: "v:r._value",
																Start: ast.Position{
																	Column: 76,
																	Line:   312,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 86,
																		Line:   312,
																	},
																	File:   "universe.flux",
																	Source: "v:r._value",
																	Start: ast.Position{
																		Column: 76,
																		Line:   312,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   312,
																		},
																		File:   "universe.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 76,
																			Line:   312,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   312,
																		},
																		File:   "universe.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 78,
																			Line:   312,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   312,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 78,
																				Line:   312,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 86,
																				Line:   312,
																			},
																			File:   "universe.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 80,
																				Line:   312,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 87,
																Line:   312,
															},
															File:   "universe.flux",
															Source: "float(v:r._value)",
															Start: ast.Position{
																Column: 70,
																Line:   312,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   312,
																},
																File:   "universe.flux",
																Source: "float",
																Start: ast.Position{
																	Column: 70,
																	Line:   312,
																},
															},
														},
														Name: "float",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   312,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 55,
															Line:   312,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   312,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   312,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   312,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   312,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   312,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: float(v:r._value)}))",
								Start: ast.Position{
									Column: 39,
									Line:   312,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   312,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   312,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   312,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   312,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   312,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   312,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   312,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   312,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   313,
					},
					File:   "universe.flux",
					Source: "toBool     = (tables=<-) => tables |> map(fn:(r) => ({r with _value: bool(v:r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   313,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   313,
						},
						File:   "universe.flux",
						Source: "toBool",
						Start: ast.Position{
							Column: 1,
							Line:   313,
						},
					},
				},
				Name: "toBool",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   313,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => ({r with _value: bool(v:r._value)}))",
						Start: ast.Position{
							Column: 14,
							Line:   313,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   313,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   313,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   313,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => ({r with _value: bool(v:r._value)}))",
							Start: ast.Position{
								Column: 29,
								Line:   313,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   313,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: bool(v:r._value)})",
									Start: ast.Position{
										Column: 43,
										Line:   313,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   313,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: bool(v:r._value)})",
										Start: ast.Position{
											Column: 43,
											Line:   313,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   313,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   313,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   313,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: bool(v:r._value)})",
											Start: ast.Position{
												Column: 46,
												Line:   313,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   313,
												},
												File:   "universe.flux",
												Source: "({r with _value: bool(v:r._value)})",
												Start: ast.Position{
													Column: 53,
													Line:   313,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   313,
													},
													File:   "universe.flux",
													Source: "{r with _value: bool(v:r._value)}",
													Start: ast.Position{
														Column: 54,
														Line:   313,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 86,
															Line:   313,
														},
														File:   "universe.flux",
														Source: "_value: bool(v:r._value)",
														Start: ast.Position{
															Column: 62,
															Line:   313,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   313,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 62,
																Line:   313,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   313,
																},
																File:   "universe.flux",
																Source: "v:r._value",
																Start: ast.Position{
																	Column: 75,
																	Line:   313,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   313,
																	},
																	File:   "universe.flux",
																	Source: "v:r._value",
																	Start: ast.Position{
																		Column: 75,
																		Line:   313,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   313,
																		},
																		File:   "universe.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 75,
																			Line:   313,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   313,
																		},
																		File:   "universe.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 77,
																			Line:   313,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   313,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 77,
																				Line:   313,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 85,
																				Line:   313,
																			},
																			File:   "universe.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 79,
																				Line:   313,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 86,
																Line:   313,
															},
															File:   "universe.flux",
															Source: "bool(v:r._value)",
															Start: ast.Position{
																Column: 70,
																Line:   313,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   313,
																},
																File:   "universe.flux",
																Source: "bool",
																Start: ast.Position{
																	Column: 70,
																	Line:   313,
																},
															},
														},
														Name: "bool",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   313,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 55,
															Line:   313,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   313,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   313,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   313,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   313,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   313,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: bool(v:r._value)}))",
								Start: ast.Position{
									Column: 39,
									Line:   313,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   313,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   313,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   313,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   313,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   313,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   313,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   313,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   313,
							},
						},
					}},
				}},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   314,
					},
					File:   "universe.flux",
					Source: "toTime     = (tables=<-) => tables |> map(fn:(r) => ({r with _value: time(v:r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   314,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   314,
						},
						File:   "universe.flux",
						Source: "toTime",
						Start: ast.Position{
							Column: 1,
							Line:   314,
						},
					},
				},
				Name: "toTime",
			},
			Init: &ast.FunctionExpression{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   314,
						},
						File:   "universe.flux",
						Source: "(tables=<-) => tables |> map(fn:(r) => ({r with _value: time(v:r._value)}))",
						Start: ast.Position{
							Column: 14,
							Line:   314,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   314,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 29,
									Line:   314,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   314,
							},
							File:   "universe.flux",
							Source: "tables |> map(fn:(r) => ({r with _value: time(v:r._value)}))",
							Start: ast.Position{
								Column: 29,
								Line:   314,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   314,
									},
									File:   "universe.flux",
									Source: "fn:(r) => ({r with _value: time(v:r._value)})",
									Start: ast.Position{
										Column: 43,
										Line:   314,
									},
								},
							},
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Errors: nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   314,
										},
										File:   "universe.flux",
										Source: "fn:(r) => ({r with _value: time(v:r._value)})",
										Start: ast.Position{
											Column: 43,
											Line:   314,
										},
									},
								},
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   314,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   314,
											},
										},
									},
									Name: "fn",
								},
								Value: &ast.FunctionExpression{
									BaseNode: ast.BaseNode{
										Errors: nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   314,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: time(v:r._value)})",
											Start: ast.Position{
												Column: 46,
												Line:   314,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   314,
												},
												File:   "universe.flux",
												Source: "({r with _value: time(v:r._value)})",
												Start: ast.Position{
													Column: 53,
													Line:   314,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   314,
													},
													File:   "universe.flux",
													Source: "{r with _value: time(v:r._value)}",
													Start: ast.Position{
														Column: 54,
														Line:   314,
													},
												},
											},
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 86,
															Line:   314,
														},
														File:   "universe.flux",
														Source: "_value: time(v:r._value)",
														Start: ast.Position{
															Column: 62,
															Line:   314,
														},
													},
												},
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   314,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 62,
																Line:   314,
															},
														},
													},
													Name: "_value",
												},
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   314,
																},
																File:   "universe.flux",
																Source: "v:r._value",
																Start: ast.Position{
																	Column: 75,
																	Line:   314,
																},
															},
														},
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Errors: nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   314,
																	},
																	File:   "universe.flux",
																	Source: "v:r._value",
																	Start: ast.Position{
																		Column: 75,
																		Line:   314,
																	},
																},
															},
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   314,
																		},
																		File:   "universe.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 75,
																			Line:   314,
																		},
																	},
																},
																Name: "v",
															},
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Errors: nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   314,
																		},
																		File:   "universe.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 77,
																			Line:   314,
																		},
																	},
																},
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   314,
																			},
																			File:   "universe.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 77,
																				Line:   314,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Errors: nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 85,
																				Line:   314,
																			},
																			File:   "universe.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 79,
																				Line:   314,
																			},
																		},
																	},
																	Name: "_value",
																},
															},
														}},
														With: nil,
													}},
													BaseNode: ast.BaseNode{
														Errors: nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 86,
																Line:   314,
															},
															File:   "universe.flux",
															Source: "time(v:r._value)",
															Start: ast.Position{
																Column: 70,
																Line:   314,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Errors: nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   314,
																},
																File:   "universe.flux",
																Source: "time",
																Start: ast.Position{
																	Column: 70,
																	Line:   314,
																},
															},
														},
														Name: "time",
													},
												},
											}},
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Errors: nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   314,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 55,
															Line:   314,
														},
													},
												},
												Name: "r",
											},
										},
									},
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Errors: nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   314,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 47,
													Line:   314,
												},
											},
										},
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Errors: nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   314,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   314,
													},
												},
											},
											Name: "r",
										},
										Value: nil,
									}},
								},
							}},
							With: nil,
						}},
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   314,
								},
								File:   "universe.flux",
								Source: "map(fn:(r) => ({r with _value: time(v:r._value)}))",
								Start: ast.Position{
									Column: 39,
									Line:   314,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Errors: nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   314,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 39,
										Line:   314,
									},
								},
							},
							Name: "map",
						},
					},
				},
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   314,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   314,
							},
						},
					},
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Errors: nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   314,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   314,
								},
							},
						},
						Name: "tables",
					},
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Errors: nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   314,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   314,
							},
						},
					}},
				}},
			},
		}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   3,
					},
					File:   "universe.flux",
					Source: "import \"system\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   3,
						},
						File:   "universe.flux",
						Source: "\"system\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "system",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "universe.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "universe.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "date",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "universe.flux",
					Source: "import \"math\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "universe.flux",
						Source: "\"math\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "math",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "universe.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "universe.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   7,
					},
					File:   "universe.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   7,
						},
						File:   "universe.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=go",
		Name:     "universe.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Errors: nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "universe.flux",
					Source: "package universe",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Errors: nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "universe.flux",
						Source: "universe",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe",
			},
		},
	}},
	Package: "universe",
	Path:    "universe",
}
