// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/visualinspection/v1beta1/module.proto

package visualinspection

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A Module applies a computer vision algorithm to a subproblem of a visual
// inspection task.
type Module struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the module.
	//
	// Types that are assignable to Type:
	//	*Module_AnomalyDetection
	//	*Module_SparseAlignmentLocalization
	//	*Module_LocalizationRefinement
	//	*Module_ObjectDetection
	//	*Module_Segmentation
	//	*Module_Classification
	Type isModule_Type `protobuf_oneof:"type"`
	// Output only. Resource name for Module generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when this Module was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when Module was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. A user friendly display name for the Module.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description for this Module.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Configuration for this Module. Each Module may define its own
	// configuration options.
	Config *structpb.Struct `protobuf:"bytes,6,opt,name=config,proto3" json:"config,omitempty"`
	// The labels with user-defined metadata to organize your Modules.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label keys must start with a letter.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Module) Reset() {
	*x = Module{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Module) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Module) ProtoMessage() {}

func (x *Module) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Module.ProtoReflect.Descriptor instead.
func (*Module) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{0}
}

func (m *Module) GetType() isModule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Module) GetAnomalyDetection() *AnomalyDetectionModule {
	if x, ok := x.GetType().(*Module_AnomalyDetection); ok {
		return x.AnomalyDetection
	}
	return nil
}

func (x *Module) GetSparseAlignmentLocalization() *SparseAlignmentLocalizationModule {
	if x, ok := x.GetType().(*Module_SparseAlignmentLocalization); ok {
		return x.SparseAlignmentLocalization
	}
	return nil
}

func (x *Module) GetLocalizationRefinement() *LocalizationRefinementModule {
	if x, ok := x.GetType().(*Module_LocalizationRefinement); ok {
		return x.LocalizationRefinement
	}
	return nil
}

func (x *Module) GetObjectDetection() *ObjectDetectionModule {
	if x, ok := x.GetType().(*Module_ObjectDetection); ok {
		return x.ObjectDetection
	}
	return nil
}

func (x *Module) GetSegmentation() *SegmentationModule {
	if x, ok := x.GetType().(*Module_Segmentation); ok {
		return x.Segmentation
	}
	return nil
}

func (x *Module) GetClassification() *ClassificationModule {
	if x, ok := x.GetType().(*Module_Classification); ok {
		return x.Classification
	}
	return nil
}

func (x *Module) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Module) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Module) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Module) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Module) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Module) GetConfig() *structpb.Struct {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Module) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isModule_Type interface {
	isModule_Type()
}

type Module_AnomalyDetection struct {
	// Anomaly detection.
	AnomalyDetection *AnomalyDetectionModule `protobuf:"bytes,8,opt,name=anomaly_detection,json=anomalyDetection,proto3,oneof"`
}

type Module_SparseAlignmentLocalization struct {
	// Sparse alignment localization.
	SparseAlignmentLocalization *SparseAlignmentLocalizationModule `protobuf:"bytes,9,opt,name=sparse_alignment_localization,json=sparseAlignmentLocalization,proto3,oneof"`
}

type Module_LocalizationRefinement struct {
	// Localization refinement.
	LocalizationRefinement *LocalizationRefinementModule `protobuf:"bytes,10,opt,name=localization_refinement,json=localizationRefinement,proto3,oneof"`
}

type Module_ObjectDetection struct {
	// Object detection.
	ObjectDetection *ObjectDetectionModule `protobuf:"bytes,11,opt,name=object_detection,json=objectDetection,proto3,oneof"`
}

type Module_Segmentation struct {
	// Segmentation.
	Segmentation *SegmentationModule `protobuf:"bytes,12,opt,name=segmentation,proto3,oneof"`
}

type Module_Classification struct {
	// Classification.
	Classification *ClassificationModule `protobuf:"bytes,13,opt,name=classification,proto3,oneof"`
}

func (*Module_AnomalyDetection) isModule_Type() {}

func (*Module_SparseAlignmentLocalization) isModule_Type() {}

func (*Module_LocalizationRefinement) isModule_Type() {}

func (*Module_ObjectDetection) isModule_Type() {}

func (*Module_Segmentation) isModule_Type() {}

func (*Module_Classification) isModule_Type() {}

// Detailed input and output information of an anomaly detection Module.
type AnomalyDetectionModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input regions within which to detect anomalies. If not provided, the full
	// image is used as input.
	QueryRegions []*AnnotationInput `protobuf:"bytes,1,rep,name=query_regions,json=queryRegions,proto3" json:"query_regions,omitempty"`
	// Required. Classification labels to train the model.
	ClassificationLabels []*AnnotationInput `protobuf:"bytes,2,rep,name=classification_labels,json=classificationLabels,proto3" json:"classification_labels,omitempty"`
	// Required. Classification predictions by the model.
	ClassificationPredictions []*AnnotationOutput `protobuf:"bytes,3,rep,name=classification_predictions,json=classificationPredictions,proto3" json:"classification_predictions,omitempty"`
}

func (x *AnomalyDetectionModule) Reset() {
	*x = AnomalyDetectionModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnomalyDetectionModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnomalyDetectionModule) ProtoMessage() {}

func (x *AnomalyDetectionModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnomalyDetectionModule.ProtoReflect.Descriptor instead.
func (*AnomalyDetectionModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{1}
}

func (x *AnomalyDetectionModule) GetQueryRegions() []*AnnotationInput {
	if x != nil {
		return x.QueryRegions
	}
	return nil
}

func (x *AnomalyDetectionModule) GetClassificationLabels() []*AnnotationInput {
	if x != nil {
		return x.ClassificationLabels
	}
	return nil
}

func (x *AnomalyDetectionModule) GetClassificationPredictions() []*AnnotationOutput {
	if x != nil {
		return x.ClassificationPredictions
	}
	return nil
}

// Detailed input and output information of a sparse alignment localization
// module.
type SparseAlignmentLocalizationModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regions within the query image to align. Multiple regions could be aligned
	// per Image.
	QueryRegions []*AnnotationInput `protobuf:"bytes,1,rep,name=query_regions,json=queryRegions,proto3" json:"query_regions,omitempty"`
	// Regions within the template image to transfer to the query image.
	TargetRegions []*AnnotationInput `protobuf:"bytes,2,rep,name=target_regions,json=targetRegions,proto3" json:"target_regions,omitempty"`
	// Regions that define the portion of the template image from which to extract
	// local features. These have both include/exclude Annotations, distinguished
	// by labels on the AnnotationSpec.
	InspectionRegions []*AnnotationInput `protobuf:"bytes,3,rep,name=inspection_regions,json=inspectionRegions,proto3" json:"inspection_regions,omitempty"`
	// The target regions transformed by the module.
	TargetRegionPredictions []*AnnotationOutput `protobuf:"bytes,4,rep,name=target_region_predictions,json=targetRegionPredictions,proto3" json:"target_region_predictions,omitempty"`
	// The inspection regions transformed by the module.
	InspectionRegionPredictions []*AnnotationOutput `protobuf:"bytes,5,rep,name=inspection_region_predictions,json=inspectionRegionPredictions,proto3" json:"inspection_region_predictions,omitempty"`
}

func (x *SparseAlignmentLocalizationModule) Reset() {
	*x = SparseAlignmentLocalizationModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparseAlignmentLocalizationModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparseAlignmentLocalizationModule) ProtoMessage() {}

func (x *SparseAlignmentLocalizationModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparseAlignmentLocalizationModule.ProtoReflect.Descriptor instead.
func (*SparseAlignmentLocalizationModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{2}
}

func (x *SparseAlignmentLocalizationModule) GetQueryRegions() []*AnnotationInput {
	if x != nil {
		return x.QueryRegions
	}
	return nil
}

func (x *SparseAlignmentLocalizationModule) GetTargetRegions() []*AnnotationInput {
	if x != nil {
		return x.TargetRegions
	}
	return nil
}

func (x *SparseAlignmentLocalizationModule) GetInspectionRegions() []*AnnotationInput {
	if x != nil {
		return x.InspectionRegions
	}
	return nil
}

func (x *SparseAlignmentLocalizationModule) GetTargetRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.TargetRegionPredictions
	}
	return nil
}

func (x *SparseAlignmentLocalizationModule) GetInspectionRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.InspectionRegionPredictions
	}
	return nil
}

// Detailed input and output information of a localization refinment module.
type LocalizationRefinementModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regions within the query image to align. Multiple regions could
	// be aligned per Image.
	QueryRegions []*AnnotationInput `protobuf:"bytes,1,rep,name=query_regions,json=queryRegions,proto3" json:"query_regions,omitempty"`
	// Regions within the template image to transfer to the query image.
	TargetRegions []*AnnotationInput `protobuf:"bytes,2,rep,name=target_regions,json=targetRegions,proto3" json:"target_regions,omitempty"`
	// Regions which customize the search process for each target region.
	LocalSearchRegions []*AnnotationInput `protobuf:"bytes,3,rep,name=local_search_regions,json=localSearchRegions,proto3" json:"local_search_regions,omitempty"`
	// The target regions transformed by the module.
	TargetRegionPredictions []*AnnotationOutput `protobuf:"bytes,4,rep,name=target_region_predictions,json=targetRegionPredictions,proto3" json:"target_region_predictions,omitempty"`
	// The inspection regions transformed by the module.
	LocalSearchRegionPredictions []*AnnotationOutput `protobuf:"bytes,5,rep,name=local_search_region_predictions,json=localSearchRegionPredictions,proto3" json:"local_search_region_predictions,omitempty"`
}

func (x *LocalizationRefinementModule) Reset() {
	*x = LocalizationRefinementModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalizationRefinementModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalizationRefinementModule) ProtoMessage() {}

func (x *LocalizationRefinementModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalizationRefinementModule.ProtoReflect.Descriptor instead.
func (*LocalizationRefinementModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{3}
}

func (x *LocalizationRefinementModule) GetQueryRegions() []*AnnotationInput {
	if x != nil {
		return x.QueryRegions
	}
	return nil
}

func (x *LocalizationRefinementModule) GetTargetRegions() []*AnnotationInput {
	if x != nil {
		return x.TargetRegions
	}
	return nil
}

func (x *LocalizationRefinementModule) GetLocalSearchRegions() []*AnnotationInput {
	if x != nil {
		return x.LocalSearchRegions
	}
	return nil
}

func (x *LocalizationRefinementModule) GetTargetRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.TargetRegionPredictions
	}
	return nil
}

func (x *LocalizationRefinementModule) GetLocalSearchRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.LocalSearchRegionPredictions
	}
	return nil
}

// Detailed input and output information of an object detection module.
type ObjectDetectionModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regions to search on for the query image, anything outside of these regions
	// will not be considered from the module. These regions are defined in the
	// template image and applied "as is" to each query image. If query_regions
	// are not specified, the full image will be used as a single query region.
	QueryRegions []*AnnotationInput `protobuf:"bytes,1,rep,name=query_regions,json=queryRegions,proto3" json:"query_regions,omitempty"`
	// Regions within the template image to transfer to the query image.
	TargetRegions []*AnnotationInput `protobuf:"bytes,2,rep,name=target_regions,json=targetRegions,proto3" json:"target_regions,omitempty"`
	// Required. The regions for each object to learn the representation of.
	ObjectRegions []*AnnotationInput `protobuf:"bytes,3,rep,name=object_regions,json=objectRegions,proto3" json:"object_regions,omitempty"`
	// The target regions transformed by the module.
	TargetRegionPredictions []*AnnotationOutput `protobuf:"bytes,4,rep,name=target_region_predictions,json=targetRegionPredictions,proto3" json:"target_region_predictions,omitempty"`
	// Required. The objects regions detected by the module.
	ObjectRegionPredictions []*AnnotationOutput `protobuf:"bytes,5,rep,name=object_region_predictions,json=objectRegionPredictions,proto3" json:"object_region_predictions,omitempty"`
}

func (x *ObjectDetectionModule) Reset() {
	*x = ObjectDetectionModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionModule) ProtoMessage() {}

func (x *ObjectDetectionModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionModule.ProtoReflect.Descriptor instead.
func (*ObjectDetectionModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{4}
}

func (x *ObjectDetectionModule) GetQueryRegions() []*AnnotationInput {
	if x != nil {
		return x.QueryRegions
	}
	return nil
}

func (x *ObjectDetectionModule) GetTargetRegions() []*AnnotationInput {
	if x != nil {
		return x.TargetRegions
	}
	return nil
}

func (x *ObjectDetectionModule) GetObjectRegions() []*AnnotationInput {
	if x != nil {
		return x.ObjectRegions
	}
	return nil
}

func (x *ObjectDetectionModule) GetTargetRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.TargetRegionPredictions
	}
	return nil
}

func (x *ObjectDetectionModule) GetObjectRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.ObjectRegionPredictions
	}
	return nil
}

// Detailed input and output information of an image segmentation module.
type SegmentationModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regions to search on for the query image, anything outside of these regions
	// will not be considered from the module. The query images can be defined in
	// the template image or predicted per image from other modules.  If
	// query_regions are not specified, the full image will be used as a single
	// query region.
	QueryRegions []*AnnotationInput `protobuf:"bytes,1,rep,name=query_regions,json=queryRegions,proto3" json:"query_regions,omitempty"`
	// Regions within the template image to transfer to the query image.
	InspectionRegions []*AnnotationInput `protobuf:"bytes,2,rep,name=inspection_regions,json=inspectionRegions,proto3" json:"inspection_regions,omitempty"`
	// Required. The segmentation regions to learn the representation of.
	SegmentationRegions []*AnnotationInput `protobuf:"bytes,3,rep,name=segmentation_regions,json=segmentationRegions,proto3" json:"segmentation_regions,omitempty"`
	// The segmentation predictions in inspection regions by the module.
	InspectionRegionPredictions []*AnnotationOutput `protobuf:"bytes,4,rep,name=inspection_region_predictions,json=inspectionRegionPredictions,proto3" json:"inspection_region_predictions,omitempty"`
	// Required. The segmentation predictions by the module.
	SegmentationPredictions []*AnnotationOutput `protobuf:"bytes,5,rep,name=segmentation_predictions,json=segmentationPredictions,proto3" json:"segmentation_predictions,omitempty"`
}

func (x *SegmentationModule) Reset() {
	*x = SegmentationModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentationModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentationModule) ProtoMessage() {}

func (x *SegmentationModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentationModule.ProtoReflect.Descriptor instead.
func (*SegmentationModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{5}
}

func (x *SegmentationModule) GetQueryRegions() []*AnnotationInput {
	if x != nil {
		return x.QueryRegions
	}
	return nil
}

func (x *SegmentationModule) GetInspectionRegions() []*AnnotationInput {
	if x != nil {
		return x.InspectionRegions
	}
	return nil
}

func (x *SegmentationModule) GetSegmentationRegions() []*AnnotationInput {
	if x != nil {
		return x.SegmentationRegions
	}
	return nil
}

func (x *SegmentationModule) GetInspectionRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.InspectionRegionPredictions
	}
	return nil
}

func (x *SegmentationModule) GetSegmentationPredictions() []*AnnotationOutput {
	if x != nil {
		return x.SegmentationPredictions
	}
	return nil
}

// Detailed input and output information of an image classification module.
type ClassificationModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Regions to search on for the query image, anything outside of these regions
	// will not be considered from the module. The query images can be defined in
	// the template image or predicted per image from other modules.  If
	// query_regions are not specified, the full image will be used as a single
	// query region.
	QueryRegions []*AnnotationInput `protobuf:"bytes,1,rep,name=query_regions,json=queryRegions,proto3" json:"query_regions,omitempty"`
	// Regions within the template image to transfer to the query image.
	InspectionRegions []*AnnotationInput `protobuf:"bytes,2,rep,name=inspection_regions,json=inspectionRegions,proto3" json:"inspection_regions,omitempty"`
	// Required. Classification labels to train the module.
	ClassificationLabels []*AnnotationInput `protobuf:"bytes,3,rep,name=classification_labels,json=classificationLabels,proto3" json:"classification_labels,omitempty"`
	// Classification predictions in inspection regions by the module.
	InspectionRegionPredictions []*AnnotationOutput `protobuf:"bytes,4,rep,name=inspection_region_predictions,json=inspectionRegionPredictions,proto3" json:"inspection_region_predictions,omitempty"`
	// Required. Classification predictions by the module.
	ClassificationPredictions []*AnnotationOutput `protobuf:"bytes,5,rep,name=classification_predictions,json=classificationPredictions,proto3" json:"classification_predictions,omitempty"`
}

func (x *ClassificationModule) Reset() {
	*x = ClassificationModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationModule) ProtoMessage() {}

func (x *ClassificationModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationModule.ProtoReflect.Descriptor instead.
func (*ClassificationModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{6}
}

func (x *ClassificationModule) GetQueryRegions() []*AnnotationInput {
	if x != nil {
		return x.QueryRegions
	}
	return nil
}

func (x *ClassificationModule) GetInspectionRegions() []*AnnotationInput {
	if x != nil {
		return x.InspectionRegions
	}
	return nil
}

func (x *ClassificationModule) GetClassificationLabels() []*AnnotationInput {
	if x != nil {
		return x.ClassificationLabels
	}
	return nil
}

func (x *ClassificationModule) GetInspectionRegionPredictions() []*AnnotationOutput {
	if x != nil {
		return x.InspectionRegionPredictions
	}
	return nil
}

func (x *ClassificationModule) GetClassificationPredictions() []*AnnotationOutput {
	if x != nil {
		return x.ClassificationPredictions
	}
	return nil
}

// Specifies the source of Annotations for a Module input.
type AnnotationInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AnnotationSet ID containing input Annotations. The expected
	// AnnotationType of this AnnotationSet will depend on the Module.
	//
	// Deprecated: Do not use.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId,proto3" json:"annotation_set_id,omitempty"`
	// Required. The AnnotationSet containing input Annotations. The expected
	// AnnotationType of this AnnotationSet will depend on the Module.
	AnnotationSet string `protobuf:"bytes,3,opt,name=annotation_set,json=annotationSet,proto3" json:"annotation_set,omitempty"`
	// A list of AnnotationSpecs to subselect Annotations in this AnnotationSet.
	// If specified, only Annotations which have an AnnotationSpec in the list are
	// used as input to the Module.
	AnnotationSpecAllowlist []string `protobuf:"bytes,2,rep,name=annotation_spec_allowlist,json=annotationSpecAllowlist,proto3" json:"annotation_spec_allowlist,omitempty"`
}

func (x *AnnotationInput) Reset() {
	*x = AnnotationInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationInput) ProtoMessage() {}

func (x *AnnotationInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationInput.ProtoReflect.Descriptor instead.
func (*AnnotationInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{7}
}

// Deprecated: Do not use.
func (x *AnnotationInput) GetAnnotationSetId() string {
	if x != nil {
		return x.AnnotationSetId
	}
	return ""
}

func (x *AnnotationInput) GetAnnotationSet() string {
	if x != nil {
		return x.AnnotationSet
	}
	return ""
}

func (x *AnnotationInput) GetAnnotationSpecAllowlist() []string {
	if x != nil {
		return x.AnnotationSpecAllowlist
	}
	return nil
}

// Specifies the output for Annotations produced by a Module.
type AnnotationOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The AnnotationSet ID containing output Annotations. The expected
	// AnnotationType of this AnnotationSet will depend on the Module.
	//
	// Deprecated: Do not use.
	AnnotationSetId string `protobuf:"bytes,1,opt,name=annotation_set_id,json=annotationSetId,proto3" json:"annotation_set_id,omitempty"`
	// Required. The AnnotationSet containing output Annotations. The expected
	// AnnotationType of this AnnotationSet will depend on the Module.
	AnnotationSet string `protobuf:"bytes,2,opt,name=annotation_set,json=annotationSet,proto3" json:"annotation_set,omitempty"`
}

func (x *AnnotationOutput) Reset() {
	*x = AnnotationOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationOutput) ProtoMessage() {}

func (x *AnnotationOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationOutput.ProtoReflect.Descriptor instead.
func (*AnnotationOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP(), []int{8}
}

// Deprecated: Do not use.
func (x *AnnotationOutput) GetAnnotationSetId() string {
	if x != nil {
		return x.AnnotationSetId
	}
	return ""
}

func (x *AnnotationOutput) GetAnnotationSet() string {
	if x != nil {
		return x.AnnotationSet
	}
	return ""
}

var File_google_cloud_visualinspection_v1beta1_module_proto protoreflect.FileDescriptor

var file_google_cloud_visualinspection_v1beta1_module_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe4, 0x09, 0x0a, 0x06, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x6c, 0x0a, 0x11, 0x61, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x10, 0x61, 0x6e, 0x6f,
	0x6d, 0x61, 0x6c, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01,
	0x0a, 0x1d, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x72, 0x73, 0x65, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x1b, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e,
	0x0a, 0x17, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x16, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x69,
	0x0a, 0x10, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x0c, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x0e, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x0e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x7a, 0xea, 0x41, 0x77, 0x0a, 0x26, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xe4, 0x02, 0x0a, 0x16,
	0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x70, 0x0a, 0x15, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x14, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x7b, 0x0a, 0x1a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0xb8, 0x04, 0x0a, 0x21, 0x53, 0x70, 0x61, 0x72, 0x73, 0x65, 0x41, 0x6c, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x73, 0x0a, 0x19, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x7b, 0x0a, 0x1d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x1b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb9, 0x04,
	0x0a, 0x1c, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5b,
	0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x0e, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x68, 0x0a, 0x14, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x52, 0x12, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x73, 0x0a, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x52, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7e, 0x0a, 0x1f, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x1c, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa6, 0x04, 0x0a, 0x15, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x5d, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x62, 0x0a, 0x0e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x73, 0x0a, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52,
	0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x78, 0x0a, 0x19, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0xbe, 0x04, 0x0a, 0x12, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a,
	0x14, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7b, 0x0a,
	0x1d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x1b, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x77, 0x0a, 0x18, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xc6, 0x04, 0x0a, 0x14, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0d,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x12, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x11, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x70, 0x0a, 0x15, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x7b, 0x0a, 0x1d, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x1b, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x7b, 0x0a, 0x1a, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x19, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xde, 0x01, 0x0a,
	0x0f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x31, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18, 0x01, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x52, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x12, 0x3a, 0x0a, 0x19, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x17, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x22, 0xa3, 0x01,
	0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x31, 0x0a, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0x18,
	0x01, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x5c, 0x0a, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x52, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x42, 0xff, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x50, 0x01, 0x5a, 0x55, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x49, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visualinspection_v1beta1_module_proto_rawDescOnce sync.Once
	file_google_cloud_visualinspection_v1beta1_module_proto_rawDescData = file_google_cloud_visualinspection_v1beta1_module_proto_rawDesc
)

func file_google_cloud_visualinspection_v1beta1_module_proto_rawDescGZIP() []byte {
	file_google_cloud_visualinspection_v1beta1_module_proto_rawDescOnce.Do(func() {
		file_google_cloud_visualinspection_v1beta1_module_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visualinspection_v1beta1_module_proto_rawDescData)
	})
	return file_google_cloud_visualinspection_v1beta1_module_proto_rawDescData
}

var file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_visualinspection_v1beta1_module_proto_goTypes = []interface{}{
	(*Module)(nil),                            // 0: google.cloud.visualinspection.v1beta1.Module
	(*AnomalyDetectionModule)(nil),            // 1: google.cloud.visualinspection.v1beta1.AnomalyDetectionModule
	(*SparseAlignmentLocalizationModule)(nil), // 2: google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule
	(*LocalizationRefinementModule)(nil),      // 3: google.cloud.visualinspection.v1beta1.LocalizationRefinementModule
	(*ObjectDetectionModule)(nil),             // 4: google.cloud.visualinspection.v1beta1.ObjectDetectionModule
	(*SegmentationModule)(nil),                // 5: google.cloud.visualinspection.v1beta1.SegmentationModule
	(*ClassificationModule)(nil),              // 6: google.cloud.visualinspection.v1beta1.ClassificationModule
	(*AnnotationInput)(nil),                   // 7: google.cloud.visualinspection.v1beta1.AnnotationInput
	(*AnnotationOutput)(nil),                  // 8: google.cloud.visualinspection.v1beta1.AnnotationOutput
	nil,                                       // 9: google.cloud.visualinspection.v1beta1.Module.LabelsEntry
	(*timestamppb.Timestamp)(nil),             // 10: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                   // 11: google.protobuf.Struct
}
var file_google_cloud_visualinspection_v1beta1_module_proto_depIdxs = []int32{
	1,  // 0: google.cloud.visualinspection.v1beta1.Module.anomaly_detection:type_name -> google.cloud.visualinspection.v1beta1.AnomalyDetectionModule
	2,  // 1: google.cloud.visualinspection.v1beta1.Module.sparse_alignment_localization:type_name -> google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule
	3,  // 2: google.cloud.visualinspection.v1beta1.Module.localization_refinement:type_name -> google.cloud.visualinspection.v1beta1.LocalizationRefinementModule
	4,  // 3: google.cloud.visualinspection.v1beta1.Module.object_detection:type_name -> google.cloud.visualinspection.v1beta1.ObjectDetectionModule
	5,  // 4: google.cloud.visualinspection.v1beta1.Module.segmentation:type_name -> google.cloud.visualinspection.v1beta1.SegmentationModule
	6,  // 5: google.cloud.visualinspection.v1beta1.Module.classification:type_name -> google.cloud.visualinspection.v1beta1.ClassificationModule
	10, // 6: google.cloud.visualinspection.v1beta1.Module.create_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.cloud.visualinspection.v1beta1.Module.update_time:type_name -> google.protobuf.Timestamp
	11, // 8: google.cloud.visualinspection.v1beta1.Module.config:type_name -> google.protobuf.Struct
	9,  // 9: google.cloud.visualinspection.v1beta1.Module.labels:type_name -> google.cloud.visualinspection.v1beta1.Module.LabelsEntry
	7,  // 10: google.cloud.visualinspection.v1beta1.AnomalyDetectionModule.query_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 11: google.cloud.visualinspection.v1beta1.AnomalyDetectionModule.classification_labels:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	8,  // 12: google.cloud.visualinspection.v1beta1.AnomalyDetectionModule.classification_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	7,  // 13: google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule.query_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 14: google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule.target_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 15: google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule.inspection_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	8,  // 16: google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule.target_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	8,  // 17: google.cloud.visualinspection.v1beta1.SparseAlignmentLocalizationModule.inspection_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	7,  // 18: google.cloud.visualinspection.v1beta1.LocalizationRefinementModule.query_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 19: google.cloud.visualinspection.v1beta1.LocalizationRefinementModule.target_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 20: google.cloud.visualinspection.v1beta1.LocalizationRefinementModule.local_search_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	8,  // 21: google.cloud.visualinspection.v1beta1.LocalizationRefinementModule.target_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	8,  // 22: google.cloud.visualinspection.v1beta1.LocalizationRefinementModule.local_search_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	7,  // 23: google.cloud.visualinspection.v1beta1.ObjectDetectionModule.query_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 24: google.cloud.visualinspection.v1beta1.ObjectDetectionModule.target_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 25: google.cloud.visualinspection.v1beta1.ObjectDetectionModule.object_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	8,  // 26: google.cloud.visualinspection.v1beta1.ObjectDetectionModule.target_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	8,  // 27: google.cloud.visualinspection.v1beta1.ObjectDetectionModule.object_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	7,  // 28: google.cloud.visualinspection.v1beta1.SegmentationModule.query_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 29: google.cloud.visualinspection.v1beta1.SegmentationModule.inspection_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 30: google.cloud.visualinspection.v1beta1.SegmentationModule.segmentation_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	8,  // 31: google.cloud.visualinspection.v1beta1.SegmentationModule.inspection_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	8,  // 32: google.cloud.visualinspection.v1beta1.SegmentationModule.segmentation_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	7,  // 33: google.cloud.visualinspection.v1beta1.ClassificationModule.query_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 34: google.cloud.visualinspection.v1beta1.ClassificationModule.inspection_regions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	7,  // 35: google.cloud.visualinspection.v1beta1.ClassificationModule.classification_labels:type_name -> google.cloud.visualinspection.v1beta1.AnnotationInput
	8,  // 36: google.cloud.visualinspection.v1beta1.ClassificationModule.inspection_region_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	8,  // 37: google.cloud.visualinspection.v1beta1.ClassificationModule.classification_predictions:type_name -> google.cloud.visualinspection.v1beta1.AnnotationOutput
	38, // [38:38] is the sub-list for method output_type
	38, // [38:38] is the sub-list for method input_type
	38, // [38:38] is the sub-list for extension type_name
	38, // [38:38] is the sub-list for extension extendee
	0,  // [0:38] is the sub-list for field type_name
}

func init() { file_google_cloud_visualinspection_v1beta1_module_proto_init() }
func file_google_cloud_visualinspection_v1beta1_module_proto_init() {
	if File_google_cloud_visualinspection_v1beta1_module_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Module); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnomalyDetectionModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparseAlignmentLocalizationModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalizationRefinementModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentationModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassificationModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Module_AnomalyDetection)(nil),
		(*Module_SparseAlignmentLocalization)(nil),
		(*Module_LocalizationRefinement)(nil),
		(*Module_ObjectDetection)(nil),
		(*Module_Segmentation)(nil),
		(*Module_Classification)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visualinspection_v1beta1_module_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_visualinspection_v1beta1_module_proto_goTypes,
		DependencyIndexes: file_google_cloud_visualinspection_v1beta1_module_proto_depIdxs,
		MessageInfos:      file_google_cloud_visualinspection_v1beta1_module_proto_msgTypes,
	}.Build()
	File_google_cloud_visualinspection_v1beta1_module_proto = out.File
	file_google_cloud_visualinspection_v1beta1_module_proto_rawDesc = nil
	file_google_cloud_visualinspection_v1beta1_module_proto_goTypes = nil
	file_google_cloud_visualinspection_v1beta1_module_proto_depIdxs = nil
}
