package rpmdb

func intRef(i ...int) *int {
	if len(i) == 0 {
		return nil
	}
	return &i[0]
}

var (
	// docker run --rm -it centos:5 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\"\, \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"\", nil, nil, nil\},\n" | sed "s/(none)/0/g"
	CentOS5Plain = []*PackageInfo{
		{intRef(), "setup", "2.5.58", "9.el5", "noarch", "setup-2.5.58-9.el5.src.rpm", 381527, "public domain", "CentOS", "", "A set of system configuration and setup files.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "8.0", "5.1.1.el5.centos", "noarch", "basesystem-8.0-5.1.1.el5.centos.src.rpm", 0, "public domain", "CentOS", "", "The skeleton package which defines a simple CentOS system.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.8.9", "3.3", "x86_64", "cracklib-2.8.9-3.3.src.rpm", 8043753, "Artistic", "CentOS", "", "The standard CrackLib dictionaries.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2016c", "1.el5", "x86_64", "tzdata-2016c-1.el5.src.rpm", 1796593, "Public Domain", "CentOS", "", "Timezone data", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.5", "123.el5_11.3", "x86_64", "glibc-2.5-123.el5_11.3.src.rpm", 11690192, "LGPL", "CentOS", "", "The GNU libc libraries.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.3", "7.el5", "x86_64", "zlib-1.2.3-7.el5.src.rpm", 88976, "BSD", "CentOS", "", "The zlib compression and decompression library.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.10.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 142842, "GPLv2+", "CentOS", "", "A C library for parsing command line parameters.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.12.3", "4.el5_3.1", "x86_64", "glib2-2.12.3-4.el5_3.1.src.rpm", 2429701, "LGPL", "CentOS", "", "A library of handy utility functions", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "1.8", "2.el5", "x86_64", "audit-1.8-2.el5.src.rpm", 156639, "LGPL", "CentOS", "", "Dynamic library for libaudit", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "3.2", "33.el5_11.4", "x86_64", "bash-3.2-33.el5_11.4.src.rpm", 5235475, "GPLv2+", "CentOS", "", "The GNU Bourne Again shell (bash) version 3.2", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "4.8", "14.el5", "x86_64", "texinfo-4.8-14.el5.src.rpm", 285963, "GPL", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "5.1", "3.el5", "x86_64", "readline-5.1-3.el5.src.rpm", 384289, "GPL", "CentOS", "", "A library for editing typed command lines.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.19.1", "4.el5_11", "x86_64", "nss-3.19.1-4.el5_11.src.rpm", 3568632, "MPLv2.0", "CentOS", "", "Network Security Services", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.137", "3.el5", "x86_64", "elfutils-0.137-3.el5.src.rpm", 76000, "GPLv2 with exceptions", "CentOS", "", "Library to read and write ELF files", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.32", "1.1", "x86_64", "attr-2.4.32-1.1.src.rpm", 15560, "LGPL", "CentOS", "", "Dynamic library for extended attribute support.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.1.2", "55.el5", "x86_64", "gcc-4.1.2-55.el5.src.rpm", 973680, "GPL", "CentOS", "", "GNU Standard C++ Library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iproute", "2.6.18", "15.el5", "x86_64", "iproute-2.6.18-15.el5.src.rpm", 2165603, "GNU GPL", "CentOS", "", "Advanced IP routing and network device configuration tools.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.5.1", "55.el5", "x86_64", "grep-2.5.1-55.el5.src.rpm", 443427, "GPL", "CentOS", "", "The GNU versions of grep pattern matching utilities.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "2.8.1", "16.el5", "x86_64", "diffutils-2.8.1-16.el5.src.rpm", 568548, "GPL", "CentOS", "", "A GNU collection of diff utilities.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "3.1.5", "16.el5", "x86_64", "gawk-3.1.5-16.el5.src.rpm", 4384895, "GPL", "CentOS", "", "The GNU version of the awk text processing utility.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "436", "9.el5", "x86_64", "less-436-9.el5.src.rpm", 191053, "GPL", "CentOS", "", "A text file browser similar to more, but better.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps", "3.2.7", "26.el5", "x86_64", "procps-3.2.7-26.el5.src.rpm", 413100, "GPL", "CentOS", "", "System and process monitoring utilities.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "crontabs", "1.10", "11.el5", "noarch", "crontabs-1.10-11.el5.src.rpm", 2056, "Public Domain", "CentOS", "", "Root crontab files used to schedule the execution of programs.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.6.26", "2.1.25.el5_11", "x86_64", "libxml2-2.6.26-2.1.25.el5_11.src.rpm", 1646329, "MIT", "CentOS", "", "Library providing XML and HTML support", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sgpio", "1.2.0_10", "2.el5", "x86_64", "sgpio-1.2.0_10-2.el5.src.rpm", 15901, "GPLv2+", "CentOS", "", "SGPIO captive backplane tool", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mingetty", "1.07", "5.2.2", "x86_64", "mingetty-1.07-5.2.2.src.rpm", 32432, "GPL", "CentOS", "", "A compact getty program for virtual consoles only.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "1.10", "26", "x86_64", "libcap-1.10-26.src.rpm", 56330, "BSD-like and LGPL", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.2", "1.el5", "x86_64", "keyutils-1.2-1.el5.src.rpm", 33608, "GPL/LGPL", "CentOS", "", "Key utilities library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(10), "centos-release", "5", "11.el5.centos", "x86_64", "centos-release-5-11.el5.centos.src.rpm", 45731, "GPL", "CentOS", "", "CentOS release file", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.4.3", "56.el5", "x86_64", "python-2.4.3-56.el5.src.rpm", 22018736, "PSF - see LICENSE", "CentOS", "", "The libraries for python runtime", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.8.9", "3.3", "x86_64", "cracklib-2.8.9-3.3.src.rpm", 176409, "Artistic", "CentOS", "", "A password-checking library.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "device-mapper-event", "1.02.67", "2.el5_11.1", "x86_64", "device-mapper-1.02.67-2.el5_11.1.src.rpm", 32432, "GPL", "CentOS", "", "Device-mapper event daemon", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "net-tools", "1.60", "83.el5_10", "x86_64", "net-tools-1.60-83.el5_10.src.rpm", 798220, "GPL", "CentOS", "", "Basic networking tools.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.4", "4.el5", "x86_64", "libutempter-1.1.4-4.el5.src.rpm", 40484, "LGPL", "CentOS", "", "A privileged helper for utmp/wtmp updates", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.15.1", "32.el5_8", "x86_64", "tar-1.15.1-32.el5_8.src.rpm", 1671798, "GPL", "CentOS", "", "A GNU file archiving program", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "SysVinit", "2.86", "17.el5", "x86_64", "SysVinit-2.86-17.el5.src.rpm", 226009, "GPL", "CentOS", "", "Programs which control basic system processes.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "e2fsprogs", "1.39", "37.el5", "x86_64", "e2fsprogs-1.39-37.el5.src.rpm", 1985776, "GPL", "CentOS", "", "Utilities for managing the second and third extended (ext2/ext3) filesystems", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kpartx", "0.4.7", "64.el5_11", "x86_64", "device-mapper-multipath-0.4.7-64.el5_11.src.rpm", 983150, "GPL", "CentOS", "", "Partition device manager for device-mapper devices.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "device-mapper-multipath", "0.4.7", "64.el5_11", "x86_64", "device-mapper-multipath-0.4.7-64.el5_11.src.rpm", 7193153, "GPL", "CentOS", "", "Tools to manage multipath devices using device-mapper.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "logrotate", "3.7.4", "14", "x86_64", "logrotate-3.7.4-14.src.rpm", 59821, "GPL", "CentOS", "", "Rotates, compresses, removes and mails system log files.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "MAKEDEV", "3.23", "1.2", "x86_64", "MAKEDEV-3.23-1.2.src.rpm", 660343, "GPL", "CentOS", "", "A program used for creating device files in /dev.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "5.97", "34.el5_8.1", "x86_64", "coreutils-5.97-34.el5_8.1.src.rpm", 9045871, "GPLv2+", "CentOS", "", "The GNU core utilities: a set of tools commonly used in shell scripts", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "udev", "095", "14.33.el5_11", "x86_64", "udev-095-14.33.el5_11.src.rpm", 5627184, "GPL", "CentOS", "", "A userspace implementation of devfs", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "module-init-tools", "3.3", "0.pre3.1.63.el5", "x86_64", "module-init-tools-3.3-0.pre3.1.63.el5.src.rpm", 907394, "GPL", "CentOS", "", "Kernel module management utilities.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mcstrans", "0.2.11", "3.el5", "x86_64", "mcstrans-0.2.11-3.el5.src.rpm", 23099, "GPL", "CentOS", "", "SELinux Translation Daemon", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "initscripts", "8.45.45", "1.el5.centos", "x86_64", "initscripts-8.45.45-1.el5.centos.src.rpm", 5509410, "GPLv2 and GPLv2+", "CentOS", "", "The inittab file and the /etc/init.d scripts.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.4.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 2080256, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(30), "bind-libs", "9.3.6", "25.P1.el5_11.8", "x86_64", "bind-9.3.6-25.P1.el5_11.8.src.rpm", 2023624, "BSD-like", "CentOS", "", "Libraries used by the BIND DNS packages", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-elementtree", "1.2.6", "5", "x86_64", "python-elementtree-1.2.6-5.src.rpm", 311637, "PSF", "CentOS", "", "Fast XML parser and writer", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m2crypto", "0.16", "9.el5", "x86_64", "m2crypto-0.16-9.el5.src.rpm", 1829395, "BSDish", "CentOS", "", "Support for using OpenSSL in python scripts", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.2", "4.el5", "x86_64", "yum-metadata-parser-1.1.2-4.el5.src.rpm", 55883, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.2.22", "40.el5.centos", "noarch", "yum-3.2.22-40.el5.centos.src.rpm", 3429595, "GPLv2+", "CentOS", "", "RPM installer/updater", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.54.7", "3.el5", "x86_64", "libuser-0.54.7-3.el5.src.rpm", 1647843, "LGPL", "CentOS", "", "A user and group account administration library.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(30), "bind-utils", "9.3.6", "25.P1.el5_11.8", "x86_64", "bind-9.3.6-25.P1.el5_11.8.src.rpm", 300911, "BSD-like", "CentOS", "", "Utilities for querying DNS name servers.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.0.109", "7.2.el5", "x86_64", "vim-7.0.109-7.2.el5.src.rpm", 630565, "freeware", "CentOS", "", "A minimal version of the VIM editor.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "1.1.1", "noarch", "rootfiles-8.1-1.1.1.src.rpm", 620, "Public Domain", "CentOS", "", "The basic required files for the root user's directory.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.1.2", "55.el5", "x86_64", "gcc-4.1.2-55.el5.src.rpm", 84728, "GPL", "CentOS", "", "GCC version 4.1 shared support library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "2.4.0", "3.el5.centos", "x86_64", "filesystem-2.4.0-3.el5.centos.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nash", "5.1.19.6", "82.el5", "x86_64", "mkinitrd-5.1.19.6-82.el5.src.rpm", 2455441, "GPL", "CentOS", "", "nash shell", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "termcap", "5.5", "1.20060701.1", "noarch", "termcap-5.5-1.20060701.1.src.rpm", 807103, "Public Domain", "CentOS", "", "The terminal feature database used by certain applications.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.5", "123.el5_11.3", "x86_64", "glibc-2.5-123.el5_11.3.src.rpm", 66738287, "LGPL", "CentOS", "", "Common binaries and locale data for glibc", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(3), "mktemp", "1.5", "24.el5", "x86_64", "mktemp-1.5-24.el5.src.rpm", 15432, "BSD", "CentOS", "", "A small utility for safely making /tmp files.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.3.30.2", "2.el5", "x86_64", "chkconfig-1.3.30.2-2.el5.src.rpm", 596588, "GPL", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.10.8", "2.el5_11", "x86_64", "nspr-4.10.8-2.el5_11.src.rpm", 258472, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.3", "6.el5_5", "x86_64", "bzip2-1.0.3-6.el5_5.src.rpm", 65528, "BSD", "CentOS", "", "Libraries for applications using bzip2", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtermcap", "2.0.8", "46.1", "x86_64", "libtermcap-2.0.8-46.1.src.rpm", 13320, "LGPL", "CentOS", "", "A basic system library for accessing the termcap database.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.5", "24.20060715", "x86_64", "ncurses-5.5-24.20060715.src.rpm", 3022251, "distributable", "CentOS", "", "A terminal handling library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "1.15.2", "3.el5", "x86_64", "libsepol-1.15.2-3.el5.src.rpm", 245232, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.3.6", "7", "x86_64", "sqlite-3.3.6-7.src.rpm", 411302, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.1.5", "8.el5", "x86_64", "sed-4.1.5-8.el5.src.rpm", 335348, "GPL", "CentOS", "", "A GNU stream text editor.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "1.95.8", "11.el5_8", "x86_64", "expat-1.95.8-11.el5_8.src.rpm", 173262, "BSD", "CentOS", "", "A library for parsing XML.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.39", "8.el5", "x86_64", "acl-2.2.39-8.el5.src.rpm", 25624, "LGPL", "CentOS", "", "Dynamic library for access control list support.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4", "4.3.29", "10.el5_5.2", "x86_64", "db4-4.3.29-10.el5_5.2.src.rpm", 2118874, "GPL", "CentOS", "", "The Berkeley DB database library (version 4) for C.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "6.6", "9.el5", "x86_64", "pcre-6.6-9.el5.src.rpm", 244957, "BSD", "CentOS", "", "Perl-compatible regular expression library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hmaccalc", "0.9.6", "4.el5", "x86_64", "hmaccalc-0.9.6-4.el5.src.rpm", 93006, "MIT", "CentOS", "", "Tools for computing and checking HMAC values for files", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.17.50.0.6", "26.el5", "x86_64", "binutils-2.17.50.0.6-26.el5.src.rpm", 7416670, "GPL", "CentOS", "", "A GNU collection of binary utilities.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.6", "26.el5", "x86_64", "cpio-2.6-26.el5.src.rpm", 285951, "GPL", "CentOS", "", "A GNU archiving program.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.3.5", "13.el5.centos", "x86_64", "gzip-1.3.5-13.el5.centos.src.rpm", 181411, "GPL", "CentOS", "", "The GNU data compression program.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20020927", "46.el5", "x86_64", "iputils-20020927-46.el5.src.rpm", 284557, "BSD", "CentOS", "", "Network monitoring tools including ping.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsysfs", "2.1.0", "1.el5", "x86_64", "sysfsutils-2.1.0-1.el5.src.rpm", 144141, "LGPL", "CentOS", "", "Shared library for interfacing with sysfs", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.22", "7.el5_8.1", "x86_64", "cyrus-sasl-2.1.22-7.el5_8.1.src.rpm", 303193, "Freely Distributable", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.8.0", "28.el5", "x86_64", "gdbm-1.8.0-28.el5.src.rpm", 47658, "GPL", "CentOS", "", "A GNU set of database routines which use extensible hashing.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ethtool", "6", "4.el5", "x86_64", "ethtool-6-4.el5.src.rpm", 152180, "GPL", "CentOS", "", "Ethernet settings tool for PCI ethernet cards", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release-notes", "5.11", "0", "x86_64", "centos-release-notes-5.11-0.src.rpm", 52622, "GPL", "CentOS", "", "CentOS release notes files", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssl", "0.9.8e", "39.el5_11", "x86_64", "openssl-0.9.8e-39.el5_11.src.rpm", 4171441, "BSDish", "CentOS", "", "The OpenSSL toolkit", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.4.3", "56.el5", "x86_64", "python-2.4.3-56.el5.src.rpm", 74377, "PSF - see LICENSE", "CentOS", "", "An interpreted, interactive, object-oriented programming language.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iscsi-initiator-utils", "6.2.0.872", "16.el5", "x86_64", "iscsi-initiator-utils-6.2.0.872-16.el5.src.rpm", 3137545, "GPL", "CentOS", "", "iSCSI daemon and utility programs", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dmraid-events", "1.0.0.rc13", "65.el5", "x86_64", "dmraid-1.0.0.rc13-65.el5.src.rpm", 8788, "GPL", "CentOS", "", "dmevent_tool (Device-mapper event tool) and DSO", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.0.17", "23.el5", "x86_64", "shadow-utils-4.0.17-23.el5.src.rpm", 2785766, "BSD", "CentOS", "", "Utilities for managing accounts and shadow password files.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "psmisc", "22.2", "11", "x86_64", "psmisc-22.2-11.src.rpm", 162941, "BSD/GPL", "CentOS", "", "Utilities for managing processes on your system.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.2.27", "6.el5", "x86_64", "findutils-4.2.27-6.el5.src.rpm", 686644, "GPL", "CentOS", "", "The GNU versions of find utilities (find and xargs).", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "e2fsprogs-libs", "1.39", "37.el5", "x86_64", "e2fsprogs-1.39-37.el5.src.rpm", 233240, "GPL", "CentOS", "", "Ext2/3 filesystem-specific static libraries and headers", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lvm2", "2.02.88", "13.el5", "x86_64", "lvm2-2.02.88-13.el5.src.rpm", 9619149, "GPL", "CentOS", "", "Userland logical volume management tools", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dmraid", "1.0.0.rc13", "65.el5", "x86_64", "dmraid-1.0.0.rc13-65.el5.src.rpm", 1697084, "GPL", "CentOS", "", "dmraid (Device-mapper RAID tool and library)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "device-mapper", "1.02.67", "2.el5_11.1", "x86_64", "device-mapper-1.02.67-2.el5_11.1.src.rpm", 2173856, "GPL", "CentOS", "", "device mapper library", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "1.33.4", "5.7.el5.centos", "x86_64", "libselinux-1.33.4-5.7.el5.centos.src.rpm", 92976, "Public domain (uncopyrighted)", "CentOS", "", "SELinux library and simple utilities", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.6.1", "80.el5_11", "x86_64", "krb5-1.6.1-80.el5_11.src.rpm", 1467909, "MIT, freely distributable.", "CentOS", "", "The shared libraries used by Kerberos 5.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "0.99.6.2", "14.el5_11", "x86_64", "pam-0.99.6.2-14.el5_11.src.rpm", 2590520, "GPL or BSD", "CentOS", "", "A security tool which provides authentication for applications", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.13", "0.59.el5_8", "x86_64", "util-linux-2.13-0.59.el5_8.src.rpm", 4813548, "distributable", "CentOS", "", "A collection of basic system utilities.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mkinitrd", "5.1.19.6", "82.el5", "x86_64", "mkinitrd-5.1.19.6-82.el5.src.rpm", 955929, "GPL", "CentOS", "", "Creates an initial ramdisk image for preloading modules.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rsyslog", "3.22.1", "7.el5", "x86_64", "rsyslog-3.22.1-7.el5.src.rpm", 1277211, "GPLv3+", "CentOS", "", "Enhanced system logging and kernel message trapping daemon", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.4.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 3754335, "GPLv2+", "CentOS", "", "The RPM package management system", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.4.2.3", "36.el5_11", "x86_64", "rpm-4.4.2.3-36.el5_11.src.rpm", 133812, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.2.3", "6.el5", "noarch", "python-iniparse-0.2.3-6.el5.src.rpm", 134606, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-sqlite", "1.1.7", "1.2.1", "x86_64", "python-sqlite-1.1.7-1.2.1.src.rpm", 120728, "GPL", "CentOS", "", "Python bindings for sqlite.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.1.0", "6.el5", "noarch", "python-urlgrabber-3.1.0-6.el5.src.rpm", 478912, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-fastestmirror", "1.1.16", "21.el5.centos", "noarch", "yum-utils-1.1.16-21.el5.centos.src.rpm", 48064, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.3.43", "29.el5_11", "x86_64", "openldap-2.3.43-29.el5_11.src.rpm", 618899, "OpenLDAP", "CentOS", "", "The configuration files, libraries, and documentation for OpenLDAP.", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.73", "2", "x86_64", "passwd-0.73-2.src.rpm", 27293, "BSD", "CentOS", "", "The passwd utility for setting/changing passwords using PAM", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "1.33.4", "5.7.el5.centos", "x86_64", "libselinux-1.33.4-5.7.el5.centos.src.rpm", 52008, "Public domain (uncopyrighted)", "CentOS", "", "SELinux libselinux utilies", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:6 bash
	// yum groupinstall -y "Development tools"
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS6DevTools = []*PackageInfo{
		{intRef(), "iproute", "2.6.32", "57.el6", "x86_64", "iproute-2.6.32-57.el6.src.rpm", 963477, "GPLv2+ and Public Domain", "CentOS", "", "Advanced IP routing and network device configuration tools", "RSA/SHA1, Wed Jun 20 11:37:15 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.14", "23.el6", "noarch", "setup-2.8.14-23.el6.src.rpm", 666669, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA1, Thu Mar 23 15:02:51 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20071127", "24.el6", "x86_64", "iputils-20071127-24.el6.src.rpm", 297243, "BSD with advertising and GPLv2+ and Rdisc", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA1, Thu Mar 23 15:04:12 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "4.el6", "noarch", "basesystem-10.0-4.el6.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple Red Hat Enterprise Linux system", "RSA/SHA256, Sun Jul  3 04:00:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux-ng", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 6139437, "GPLv1+ and GPLv2 and GPLv2+ and LGPLv2+ and MIT and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018e", "3.el6", "noarch", "tzdata-2018e-3.el6.src.rpm", 1961609, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA1, Wed May  9 22:47:10 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "udev", "147", "2.73.el6_8.2", "x86_64", "udev-147-2.73.el6_8.2.src.rpm", 1280842, "GPLv2", "CentOS", "", "A userspace implementation of devfs", "RSA/SHA1, Tue Sep  6 16:49:50 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh-clients", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 1352442, "BSD", "CentOS", "", "An open source SSH client applications", "RSA/SHA1, Tue Apr  9 19:55:39 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git", "1.7.1", "9.el6_9", "x86_64", "git-1.7.1-9.el6_9.src.rpm", 15290753, "GPLv2", "CentOS", "", "Fast Version Control System", "RSA/SHA1, Thu Aug 17 10:25:25 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.1.2", "48.el6", "x86_64", "bash-4.1.2-48.el6.src.rpm", 3142529, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA1, Thu Mar 23 14:59:39 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-devel", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 6327079, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - development headers, tools", "RSA/SHA1, Wed Jun 20 11:42:34 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.16", "5.5.el6", "x86_64", "libcap-2.16-5.5.el6.src.rpm", 64437, "LGPLv2+ or BSD", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA1, Thu Dec  8 20:15:52 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hicolor-icon-theme", "0.11", "1.1.el6", "noarch", "hicolor-icon-theme-0.11-1.1.el6.src.rpm", 45406, "GPL+", "CentOS", "", "Basic requirement for icon themes", "RSA/SHA256, Sun Jul  3 04:13:15 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "4.13a", "8.el6", "x86_64", "texinfo-4.13a-8.el6.src.rpm", 329482, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Sun Jul  3 04:24:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcj", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 65012480, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Java runtime library for gcc", "RSA/SHA1, Wed Jun 20 11:35:45 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.49", "7.el6_9.1", "x86_64", "acl-2.2.49-7.el6_9.1.src.rpm", 31280, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA1, Wed Aug 23 18:02:40 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "intltool", "0.41.0", "1.1.el6", "noarch", "intltool-0.41.0-1.1.el6.src.rpm", 167585, "GPLv2 with exceptions", "CentOS", "", "Utility for internationalizing various kinds of data files", "RSA/SHA256, Sun Jul  3 04:16:01 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el6", "x86_64", "nspr-4.19.0-1.el6.src.rpm", 281968, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA1, Wed Jun 20 11:40:25 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subversion", "1.6.11", "15.el6_7", "x86_64", "subversion-1.6.11-15.el6_7.src.rpm", 12105530, "ASL 1.1", "CentOS", "", "A Modern Concurrent Version Control System", "RSA/SHA1, Mon Aug 17 15:28:40 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.41.12", "24.el6", "x86_64", "e2fsprogs-1.41.12-24.el6.src.rpm", 59233, "MIT", "CentOS", "", "Common error description library", "RSA/SHA1, Wed Jun 20 11:35:17 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-gfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 14473805, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Fortran support", "RSA/SHA1, Wed Jun 20 11:35:49 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.0.41", "4.el6", "x86_64", "libsepol-2.0.41-4.el6.src.rpm", 248680, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA1, Thu Dec  8 20:24:54 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 323213, "GPLv2+", "CentOS", "", "Scripts and executable programs used to build packages", "RSA/SHA1, Wed Jun 20 11:41:14 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.3.49.5", "1.el6", "x86_64", "chkconfig-1.3.49.5-1.el6.src.rpm", 670580, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA1, Thu May 12 10:46:23 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "flex", "2.5.35", "9.el6", "x86_64", "flex-2.5.35-9.el6.src.rpm", 736081, "BSD", "CentOS", "", "A tool for creating scanners (text pattern recognizers)", "RSA/SHA1, Fri Oct 17 20:02:30 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 235282, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA1, Thu Mar 23 14:59:31 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cscope", "15.6", "7.el6", "x86_64", "cscope-15.6-7.el6.src.rpm", 466265, "BSD", "CentOS", "", "C source code tree search and browse tool", "RSA/SHA1, Thu May 12 10:50:09 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.0", "4.el6", "x86_64", "readline-6.0-4.el6.src.rpm", 433957, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA1, Sun Jun 24 22:18:23 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rcs", "5.7", "37.el6", "x86_64", "rcs-5.7-37.el6.src.rpm", 709927, "GPLv2+", "CentOS", "", "Revision Control System (RCS) file version management tools", "RSA/SHA256, Sun Jul  3 05:00:06 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 2486624, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA1, Thu May 12 10:46:22 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffstat", "1.51", "2.el6", "x86_64", "diffstat-1.51-2.el6.src.rpm", 45568, "MIT", "CentOS", "", "A utility which provides statistics based on the output of diff", "RSA/SHA256, Sun Jul  3 04:10:09 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 265736, "GPLv2+ or AFL", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA1, Wed Jun 20 11:34:38 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "doxygen", "1.6.1", "6.el6", "x86_64", "doxygen-1.6.1-6.el6.src.rpm", 9446190, "GPL+", "CentOS", "", "A documentation system for C/C++", "RSA/SHA1, Mon Sep 26 04:17:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.6.20", "1.el6_7.2", "x86_64", "sqlite-3.6.20-1.el6_7.2.src.rpm", 640060, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA1, Mon Aug 17 15:29:10 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 16304, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 214490, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.7", "4.el6", "x86_64", "libgpg-error-1.7-4.el6.src.rpm", 214321, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA1, Thu Dec  8 20:17:43 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "7.8", "7.el6", "x86_64", "pcre-7.8-7.el6.src.rpm", 529027, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA1, Fri Jul 24 20:42:33 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.4.2", "9.el6", "x86_64", "findutils-4.4.2-9.el6.src.rpm", 1442912, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA1, Tue Mar  1 13:06:19 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.0.1", "13.el6_8", "x86_64", "expat-2.0.1-13.el6_8.src.rpm", 197794, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA1, Mon Nov 28 22:28:33 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 262669, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA1, Tue Jan 28 09:43:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.4.5", "12.el6_8", "x86_64", "libgcrypt-1.4.5-12.el6_8.src.rpm", 536622, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA1, Sat Nov 12 06:30:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libusb", "0.1.12", "23.el6", "x86_64", "libusb-0.1.12-23.el6.src.rpm", 54440, "LGPLv2+", "CentOS", "", "A library which allows userspace access to USB devices", "RSA/SHA256, Sun Jul  3 04:40:22 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.7.6", "8.el6", "x86_64", "pinentry-0.7.6-8.el6.src.rpm", 147023, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA1, Mon Mar 30 13:24:38 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps", "3.2.8", "45.el6_9.3", "x86_64", "procps-3.2.8-45.el6_9.3.src.rpm", 475526, "GPLv2+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA1, Fri Jun  1 15:12:06 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.23", "15.el6_8", "x86_64", "tar-1.23-15.el6_8.src.rpm", 2616465, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA1, Tue Jul 12 17:11:45 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "checkpolicy", "2.0.22", "1.el6", "x86_64", "checkpolicy-2.0.22-1.el6.src.rpm", 870239, "GPLv2", "CentOS", "", "SELinux policy compiler", "RSA/SHA256, Sun Jul  3 04:06:47 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4-utils", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 416398, "Sleepycat and BSD", "CentOS", "", "Command line tools for managing Berkeley DB (version 4) databases", "RSA/SHA1, Thu Mar 23 15:01:47 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "which", "2.19", "6.el6", "x86_64", "which-2.19-6.el6.src.rpm", 73004, "GPLv3", "CentOS", "", "Displays where a particular program in your path is located", "RSA/SHA1, Mon Sep 26 04:26:13 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dash", "0.5.5.1", "4.el6", "x86_64", "dash-0.5.5.1-4.el6.src.rpm", 127277, "BSD", "CentOS", "", "Small and fast POSIX-compliant shell", "RSA/SHA1, Wed Oct 17 10:45:23 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff", "1.18.1.4", "21.el6", "x86_64", "groff-1.18.1.4-21.el6.src.rpm", 5318766, "GPLv2 and GFDL", "CentOS", "", "A document formatting system", "RSA/SHA256, Sun Jul  3 04:19:43 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-libs", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 5576, "GPLv3+", "CentOS", "", "Libraries for coreutils", "RSA/SHA1, Wed Jun 20 11:34:12 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 187265, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Wed Jul  6 01:37:30 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 12873065, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA1, Wed Jun 20 11:34:12 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "module-init-tools", "3.9", "26.el6", "x86_64", "module-init-tools-3.9-26.el6.src.rpm", 1216834, "GPLv2+", "CentOS", "", "Kernel module management utilities.", "RSA/SHA1, Thu Mar 23 15:00:22 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2660886, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2052883, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mingetty", "1.08", "5.el6", "x86_64", "mingetty-1.08-5.el6.src.rpm", 34586, "GPLv2+", "CentOS", "", "A compact getty program for virtual consoles only", "RSA/SHA1, Mon Sep 26 04:21:55 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.10.3", "65.el6", "x86_64", "krb5-1.10.3-65.el6.src.rpm", 1813468, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA1, Thu Mar 23 15:01:43 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.2", "2.el6_7.1", "x86_64", "libssh2-1.4.2-2.el6_7.1.src.rpm", 325165, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA1, Thu Mar 10 12:04:29 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 777656, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 2034245, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.14", "9.el6_10", "x86_64", "gnupg2-2.0.14-9.el6_10.src.rpm", 6087540, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA1, Fri Jul 13 16:08:36 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-libs", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 2340720, "ISC", "CentOS", "", "Libraries used by the BIND DNS packages", "RSA/SHA1, Tue Aug 28 15:39:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.0.43", "5.1.el6", "x86_64", "libsemanage-2.0.43-5.1.el6.src.rpm", 204223, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA1, Fri Jul 24 20:40:14 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.5", "4.1.el6", "x86_64", "libutempter-1.1.5-4.1.el6.src.rpm", 40785, "LGPLv2", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Sun Jul  3 04:40:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth-core-libs", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 177760, "GPLv2+", "CentOS", "", "Plymouth libraries", "RSA/SHA1, Thu Mar 23 14:59:05 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.5", "3.2.el6", "x86_64", "libffi-3.0.5-3.2.el6.src.rpm", 42881, "BSD", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Jul  3 04:33:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 22979382, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA1, Thu Aug 18 17:21:24 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.1", "18.20090824bzr68.el6", "x86_64", "pygpgme-0.1-18.20090824bzr68.el6.src.rpm", 251432, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Sun Jul  3 04:58:12 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.9.1", "11.el6", "noarch", "python-urlgrabber-3.9.1-11.el6.src.rpm", 323137, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA1, Thu May 12 10:50:34 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.23", "9.1.el6", "x86_64", "pkgconfig-0.23-9.1.el6.src.rpm", 140091, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Sun Jul  3 04:57:05 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.28.8", "10.el6", "x86_64", "glib2-2.28.8-10.el6.src.rpm", 8061476, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA1, Wed Jun 20 11:36:18 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.2", "16.el6", "x86_64", "yum-metadata-parser-1.1.2-16.el6.src.rpm", 58327, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA1, Mon Sep 26 04:26:27 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.2.29", "81.el6.centos", "noarch", "yum-3.2.29-81.el6.centos.src.rpm", 4832194, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA1, Thu Mar 23 15:04:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.77", "7.el6", "x86_64", "passwd-0.77-7.el6.src.rpm", 357699, "BSD or GPLv2+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA1, Wed Dec  2 14:02:45 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-utils", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 451000, "ISC", "CentOS", "", "Utilities for querying DNS name servers", "RSA/SHA1, Tue Aug 28 15:39:45 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.629", "5.el6_8.1", "x86_64", "vim-7.4.629-5.el6_8.1.src.rpm", 909230, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA1, Wed Dec 21 17:40:06 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "c105b9de", "4e0fd3a3", "", "", 0, "pubkey", "", "", "gpg(CentOS-6 Key (CentOS 6 Official Signing Key) <centos-6-key@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 112434659, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA1, Tue Apr  9 19:55:38 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontconfig", "2.8.0", "5.el6", "x86_64", "fontconfig-2.8.0-5.el6.src.rpm", 450597, "MIT", "CentOS", "", "Font configuration and customization library", "RSA/SHA1, Tue May 27 11:48:58 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy-bin", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 6800, "LGPLv2+", "CentOS", "", "Binary to test libproxy", "RSA/SHA1, Sat Oct 18 00:47:34 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 118439, "LGPLv2+", "CentOS", "", "A library handling all the details of proxy configuration", "RSA/SHA1, Sat Oct 18 00:47:35 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "2.4.1", "6.el6", "x86_64", "mpfr-2.4.1-6.el6.src.rpm", 377376, "LGPLv2+ and GPLv2+ and GFDL", "CentOS", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Sun Jul  3 04:45:47 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libpng", "1.2.49", "2.el6_7", "x86_64", "libpng-1.2.49-2.el6_7.src.rpm", 654803, "zlib", "CentOS", "", "A library of functions for manipulating PNG image format files", "RSA/SHA1, Wed Dec  9 14:32:24 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtiff", "3.9.4", "21.el6_8", "x86_64", "libtiff-3.9.4-21.el6_8.src.rpm", 966899, "libtiff", "CentOS", "", "Library of functions for manipulating TIFF format image files", "RSA/SHA1, Wed Feb  1 12:47:19 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zip", "3.0", "1.el6_7.1", "x86_64", "zip-3.0-1.el6_7.1.src.rpm", 823164, "BSD", "CentOS", "", "A file compression and packaging utility compatible with PKZIP", "RSA/SHA1, Tue Nov 10 12:42:06 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr", "1.3.9", "5.el6_9.1", "x86_64", "apr-1.3.9-5.el6_9.1.src.rpm", 303173, "ASL 2.0", "CentOS", "", "Apache Portable Runtime library", "RSA/SHA1, Tue Nov 28 22:08:47 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sysvinit-tools", "2.87", "6.dsf.el6", "x86_64", "sysvinit-2.87-6.dsf.el6.src.rpm", 114115, "GPLv2+", "CentOS", "", "Tools used for process and utmp management.", "RSA/SHA1, Fri Jul 24 20:42:14 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "atk", "1.30.0", "1.el6", "x86_64", "atk-1.30.0-1.el6.src.rpm", 957484, "LGPLv2+", "CentOS", "", "Interfaces for accessibility support", "RSA/SHA1, Sun Nov 24 19:31:06 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libICE", "1.0.6", "1.el6", "x86_64", "libICE-1.0.6-1.el6.src.rpm", 117691, "MIT", "CentOS", "", "X.Org X11 ICE runtime library", "RSA/SHA256, Sun Jul  3 04:35:49 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hwdata", "0.233", "20.1.el6", "noarch", "hwdata-0.233-20.1.el6.src.rpm", 5894683, "GPLv2+", "CentOS", "", "Hardware identification and configuration data", "RSA/SHA1, Wed Jun 20 11:36:50 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libSM", "1.2.1", "2.el6", "x86_64", "libSM-1.2.1-2.el6.src.rpm", 78264, "MIT", "CentOS", "", "X.Org X11 SM runtime library", "RSA/SHA1, Sat Feb 23 17:41:20 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-lzma-compat", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 21146, "GPLv2+ and LGPLv2+", "CentOS", "", "Older LZMA format compatibility binaries", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 677800, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", "A collection of utilities and DSOs to handle compiled objects", "RSA/SHA1, Thu May 12 10:51:54 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jasper-libs", "1.900.1", "22.el6", "x86_64", "jasper-1.900.1-22.el6.src.rpm", 341232, "JasPer", "CentOS", "", "Runtime libraries for jasper", "RSA/SHA1, Wed Jun 20 11:37:32 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "neon", "0.29.3", "3.el6_4", "x86_64", "neon-0.29.3-3.el6_4.src.rpm", 297415, "LGPLv2+", "CentOS", "", "An HTTP and WebDAV client library", "RSA/SHA1, Tue Sep  3 09:12:17 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "alsa-lib", "1.1.0", "4.el6", "x86_64", "alsa-lib-1.1.0-4.el6.src.rpm", 1277969, "LGPLv2+", "CentOS", "", "The Advanced Linux Sound Architecture (ALSA) library", "RSA/SHA1, Thu May 12 10:46:31 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libart_lgpl", "2.3.20", "5.1.el6", "x86_64", "libart_lgpl-2.3.20-5.1.el6.src.rpm", 129211, "LGPLv2+", "CentOS", "", "Library of graphics routines used by libgnomecanvas", "RSA/SHA256, Sun Jul  3 04:31:40 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 28163, "BSD", "CentOS", "", "A library for integrity verification of FIPS validated modules", "RSA/SHA1, Thu Dec  8 19:58:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.04", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 21092, "GPL+ or Artistic", "CentOS", "", "Perl module for resolving POD escape sequences", "RSA/SHA1, Thu Mar 23 15:01:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.13", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 476776, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA1, Thu Mar 23 15:03:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(3), "perl-version", "0.77", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 51960, "GPL+ or Artistic", "CentOS", "", "Perl extension for Version Objects", "RSA/SHA1, Thu Mar 23 15:03:02 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-URI", "1.40", "2.el6", "noarch", "perl-URI-1.40-2.el6.src.rpm", 256097, "GPL+ or Artistic", "CentOS", "", "A Perl module implementing URI parsing and manipulation", "RSA/SHA256, Sun Jul  3 04:39:35 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "autoconf", "2.63", "5.1.el6", "noarch", "autoconf-2.63-5.1.el6.src.rpm", 2605343, "GPLv3+ and GFDL", "CentOS", "", "A GNU tool for automatically configuring source code", "RSA/SHA256, Sun Jul  3 04:00:14 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Compress-Raw-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 146581, "GPL+ or Artistic", "CentOS", "", "Low-Level Interface to the zlib compression library", "RSA/SHA1, Thu Mar 23 15:02:36 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-IO-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 372202, "GPL+ or Artistic", "CentOS", "", "Perl interface to allow reading and writing of gzip and zip data", "RSA/SHA1, Thu Mar 23 15:02:51 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-rpm-config", "9.0.3", "51.el6.centos", "noarch", "redhat-rpm-config-9.0.3-51.el6.centos.src.rpm", 138592, "GPL+", "CentOS", "", "Red Hat specific rpm configuration files", "RSA/SHA1, Thu May 12 10:51:05 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTML-Parser", "3.64", "2.el6", "x86_64", "perl-HTML-Parser-3.64-2.el6.src.rpm", 226598, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing HTML", "RSA/SHA256, Sun Jul  3 04:55:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 6369345, "GPLv3 and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA1, Mon Jun  2 11:16:57 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcb", "1.12", "4.el6", "x86_64", "libxcb-1.12-4.el6.src.rpm", 886960, "MIT", "CentOS", "", "A C binding to the X11 protocol", "RSA/SHA1, Thu Mar 23 14:59:07 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ppl", "0.10.2", "11.el6", "x86_64", "ppl-0.10.2-11.el6.src.rpm", 4637284, "GPLv3+", "CentOS", "", "The Parma Polyhedra Library: a library of numerical abstractions", "RSA/SHA256, Sun Jul  3 04:57:44 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rsync", "3.0.6", "12.el6", "x86_64", "rsync-3.0.6-12.el6.src.rpm", 698678, "GPLv3+", "CentOS", "", "A program for synchronizing files over a network", "RSA/SHA1, Wed Apr 30 13:29:10 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 278832, "LGPLv2+", "CentOS", "", "Libraries for gettext", "RSA/SHA1, Mon Jun  2 11:16:57 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 988064, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Fortran runtime", "RSA/SHA1, Wed Jun 20 11:35:49 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-headers", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 2776718, "GPLv2", "CentOS", "", "Header files for the Linux kernel for use by glibc", "RSA/SHA1, Tue Apr  9 19:55:37 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-devel", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 990251, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Object files for development using standard C libraries.", "RSA/SHA1, Tue Apr  9 19:55:37 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++-devel", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 9728819, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Header files and libraries for C++ development", "RSA/SHA1, Wed Jun 20 11:35:47 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11", "1.6.4", "3.el6", "x86_64", "libX11-1.6.4-3.el6.src.rpm", 1301928, "MIT", "CentOS", "", "Core X11 protocol client library", "RSA/SHA1, Thu Mar 23 15:01:37 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXext", "1.3.3", "1.el6", "x86_64", "libXext-1.3.3-1.el6.src.rpm", 85590, "MIT", "CentOS", "", "X.Org X11 libXext runtime library", "RSA/SHA1, Thu May 12 10:52:24 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXfixes", "5.0.3", "1.el6", "x86_64", "libXfixes-5.0.3-1.el6.src.rpm", 23375, "MIT", "CentOS", "", "X Fixes library", "RSA/SHA1, Thu Mar 23 15:00:46 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXi", "1.7.8", "1.el6", "x86_64", "libXi-1.7.8-1.el6.src.rpm", 66523, "MIT", "CentOS", "", "X.Org X11 libXi runtime library", "RSA/SHA1, Thu Mar 23 15:01:34 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXtst", "1.2.3", "1.el6", "x86_64", "libXtst-1.2.3-1.el6.src.rpm", 27778, "MIT", "CentOS", "", "X.Org X11 libXtst runtime library", "RSA/SHA1, Thu Mar 23 15:00:57 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcursor", "1.1.14", "2.1.el6", "x86_64", "libXcursor-1.1.14-2.1.el6.src.rpm", 41934, "MIT", "CentOS", "", "Cursor management library", "RSA/SHA1, Fri Oct 17 20:00:41 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXft", "2.3.2", "1.el6", "x86_64", "libXft-2.3.2-1.el6.src.rpm", 120045, "MIT", "CentOS", "", "X.Org X11 libXft runtime library", "RSA/SHA1, Thu May 12 10:50:04 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcomposite", "0.4.3", "4.el6", "x86_64", "libXcomposite-0.4.3-4.el6.src.rpm", 31878, "MIT", "CentOS", "", "X Composite Extension library", "RSA/SHA1, Sat Feb 23 17:41:25 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-libwww-perl", "5.833", "5.el6", "noarch", "perl-libwww-perl-5.833-5.el6.src.rpm", 903654, "GPL+ or Artistic", "CentOS", "", "A Perl interface to the World-Wide Web", "RSA/SHA1, Thu Mar 23 15:01:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-logos", "60.0.14", "12.el6.centos", "noarch", "redhat-logos-60.0.14-12.el6.centos.src.rpm", 15816517, "Copyright 1999-2010 the CentOS Project.  All rights reserved.", "CentOS", "", "CentOS-related icons and pictures", "RSA/SHA1, Thu Aug 16 13:08:48 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iptables", "1.4.7", "19.el6", "x86_64", "iptables-1.4.7-19.el6.src.rpm", 861752, "GPLv2", "CentOS", "", "Tools for managing Linux kernel packet filtering capabilities", "RSA/SHA1, Wed Jun 20 11:37:20 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 117352, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GCC version 4.4 shared support library", "RSA/SHA1, Wed Jun 20 11:35:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdrm", "2.4.65", "2.el6", "x86_64", "libdrm-2.4.65-2.el6.src.rpm", 306787, "MIT", "CentOS", "", "Direct Rendering Manager runtime library", "RSA/SHA1, Thu May 12 10:51:42 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "2.4.30", "3.el6", "x86_64", "filesystem-2.4.30-3.el6.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA1, Mon Sep 26 04:18:23 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 193924, "GPLv2+", "CentOS", "", "Graphical Boot Animation and Logger", "RSA/SHA1, Thu Mar 23 15:02:06 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "initscripts", "9.03.61", "1.el6.centos", "x86_64", "initscripts-9.03.61-1.el6.centos.src.rpm", 5735427, "GPLv2 and GPLv2+", "CentOS", "", "The inittab file and the /etc/init.d scripts", "RSA/SHA1, Wed Jun 20 11:37:06 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 193090, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA1, Mon Mar 16 14:43:09 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 787618, "BSD", "CentOS", "", "An open source implementation of SSH protocol versions 1 and 2", "RSA/SHA1, Tue Apr  9 19:55:39 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 490290, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA1, Tue Jul 12 17:09:41 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Git", "1.7.1", "9.el6_9", "noarch", "git-1.7.1-9.el6_9.src.rpm", 35913, "GPLv2", "CentOS", "", "Perl interface to Git", "RSA/SHA1, Thu Aug 17 10:25:23 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 752304, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA1, Mon Mar 16 14:43:08 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-devel", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 27015877, "GPLv2", "CentOS", "", "Development package for building kernel modules to match the kernel", "RSA/SHA1, Tue Apr  9 19:55:40 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.44", "7.el6", "x86_64", "attr-2.4.44-7.el6.src.rpm", 18712, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA1, Mon Sep 26 04:20:08 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-client", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 12275931, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - client", "RSA/SHA1, Wed Jun 20 11:42:32 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 152305, "zlib and Boost", "CentOS", "", "The zlib compression and decompression library", "RSA/SHA1, Sat Feb 23 17:41:52 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gtk2", "2.24.23", "9.el6", "x86_64", "gtk2-2.24.23-9.el6.src.rpm", 12426003, "LGPLv2+", "CentOS", "", "The GIMP ToolKit (GTK+), a library for creating GUIs for X", "RSA/SHA1, Thu Mar 23 15:01:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "7.el6", "x86_64", "popt-1.13-7.el6.src.rpm", 83420, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Sun Jul  3 04:57:35 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-devel", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 635713, "LGPLv2+", "CentOS", "", "Development files for gettext", "RSA/SHA1, Mon Jun  2 11:16:57 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1533095, "Sleepycat and BSD", "CentOS", "", "The Berkeley DB database library (version 4) for C", "RSA/SHA1, Thu Mar 23 15:00:27 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 30373, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system", "RSA/SHA1, Wed Jun 20 11:42:33 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.el6", "x86_64", "nss-util-3.36.0-1.el6.src.rpm", 191928, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA1, Wed Jun 20 11:40:37 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-c++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 11429003, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "C++ support for GCC", "RSA/SHA1, Wed Jun 20 11:35:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 67592, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Jul  6 01:37:18 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool", "2.2.6", "15.5.el6", "x86_64", "libtool-2.2.6-15.5.el6.src.rpm", 1998350, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", "The GNU Portable Library Tool", "RSA/SHA256, Sun Jul  3 04:40:10 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 130336, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA1, Thu May 12 10:46:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patchutils", "0.3.1", "3.1.el6", "x86_64", "patchutils-0.3.1-3.1.el6.src.rpm", 241488, "GPLv2+", "CentOS", "", "A collection of programs for manipulating patch files", "RSA/SHA256, Sun Jul  3 04:54:08 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.1", "10.el6", "x86_64", "sed-4.2.1-10.el6.src.rpm", 542324, "GPLv2+", "CentOS", "", "A GNU stream text editor", "RSA/SHA1, Sun Jun 24 22:20:22 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bison", "2.4.1", "5.el6", "x86_64", "bison-2.4.1-5.el6.src.rpm", 2081518, "GPLv3+", "CentOS", "", "A GNU general-purpose parser generator", "RSA/SHA256, Sun Jul  3 04:05:00 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.18", "2.el6", "x86_64", "libidn-1.18-2.el6.src.rpm", 567612, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Sun Jul  3 04:36:02 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ctags", "5.8", "2.el6", "x86_64", "ctags-5.8-2.el6.src.rpm", 347508, "GPLv2+ or Public Domain", "CentOS", "", "A C programming language indexing and/or cross-reference tool", "RSA/SHA256, Sun Jul  3 04:08:30 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.7.6", "21.el6_8.1", "x86_64", "libxml2-2.7.6-21.el6_8.1.src.rpm", 1779163, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA1, Thu Jun 23 14:20:59 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "swig", "1.3.40", "6.el6", "x86_64", "swig-1.3.40-6.el6.src.rpm", 4290828, "GPLv2+ and LGPLv2+ and BSD", "CentOS", "", "Connects C/C++/Objective C to some high-level programming languages", "RSA/SHA1, Mon Sep 26 04:25:34 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 987096, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA1, Wed Jun 20 11:35:48 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "indent", "2.2.10", "7.el6", "x86_64", "indent-2.2.10-7.el6.src.rpm", 252872, "GPLv3+", "CentOS", "", "A GNU program for formatting C code", "RSA/SHA1, Sun Jun 24 22:20:08 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "4.1.el6", "x86_64", "lua-5.1.4-4.1.el6.src.rpm", 617799, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Jul  3 04:43:34 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "byacc", "1.9.20070509", "7.el6", "x86_64", "byacc-1.9.20070509-7.el6.src.rpm", 87968, "Public Domain", "CentOS", "", "Berkeley Yacc, a parser generator", "RSA/SHA1, Sun Jun 24 22:18:50 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "3.1.7", "10.el6_7.3", "x86_64", "gawk-3.1.7-10.el6_7.3.src.rpm", 2038650, "GPLv3+", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA1, Tue Nov 10 12:38:59 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 136136, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 1011166, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA1, Thu May 12 10:51:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 1103062, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA1, Tue Jul 12 17:09:40 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "6.el6", "x86_64", "grep-2.20-6.el6.src.rpm", 1197904, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA1, Thu Mar 23 15:00:30 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.10", "13.el6", "x86_64", "cpio-2.10-13.el6.src.rpm", 650433, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA1, Thu Mar 23 15:02:20 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "9.3.el6", "x86_64", "pth-2.0.7-9.3.el6.src.rpm", 261931, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Sun Jul  3 04:57:59 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "2.3", "6.el6_5", "x86_64", "libtasn1-2.3-6.el6_5.src.rpm", 443140, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA1, Wed Jun  4 10:02:50 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 178775, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA1, Tue Jan 28 09:43:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnih", "1.0.1", "8.el6", "x86_64", "libnih-1.0.1-8.el6.src.rpm", 490926, "GPLv2", "CentOS", "", "Lightweight application development library", "RSA/SHA1, Wed Jun 20 11:39:43 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gmp", "4.3.1", "13.el6", "x86_64", "gmp-4.3.1-13.el6.src.rpm", 657883, "LGPLv2+ and  GPLv3+ and LGPLv3+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA1, Wed Jun 20 11:36:35 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 56567, "BSD", "CentOS", "", "A utility for determining file types", "RSA/SHA1, Thu May 12 10:45:47 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "net-tools", "1.60", "114.el6", "x86_64", "net-tools-1.60-114.el6.src.rpm", 778260, "GPL+", "CentOS", "", "Basic networking tools", "RSA/SHA1, Thu Mar 23 15:00:33 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "psmisc", "22.6", "24.el6", "x86_64", "psmisc-22.6-24.el6.src.rpm", 222569, "GPLv2+", "CentOS", "", "Utilities for managing processes on your system", "RSA/SHA1, Thu Mar 23 15:03:14 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 62739, "Public Domain", "CentOS", "", "SELinux libselinux utilies", "RSA/SHA1, Thu May 12 10:47:15 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 79087, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Wed Jul  6 01:37:17 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.23", "15.el6_6.2", "x86_64", "cyrus-sasl-2.1.23-15.el6_6.2.src.rpm", 357710, "BSD", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA1, Wed Mar 25 18:07:46 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.81", "23.el6", "x86_64", "make-3.81-23.el6.src.rpm", 1079569, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA1, Thu May 12 10:46:30 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "2.8.1", "28.el6", "x86_64", "diffutils-2.8.1-28.el6.src.rpm", 588813, "GPLv2+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Sun Jul  3 04:10:10 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 386371, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA1, Mon Mar 16 14:43:07 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "436", "13.el6", "x86_64", "less-436-13.el6.src.rpm", 201909, "GPLv3+", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA1, Mon Jun 16 12:52:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.3.12", "24.el6", "x86_64", "gzip-1.3.12-24.el6.src.rpm", 225924, "GPLv2+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA1, Thu Mar 23 15:00:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 9327207, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Wed Jul  6 01:37:32 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.1", "24.el6", "x86_64", "pam-1.1.1-24.el6.src.rpm", 2419646, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA1, Thu Mar 23 15:01:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth-scripts", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 11006, "GPLv2+", "CentOS", "", "Plymouth related scripts", "RSA/SHA1, Thu Mar 23 15:03:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "65.1.el6", "noarch", "ca-certificates-2018.2.22-65.1.el6.src.rpm", 2675229, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA1, Wed Jun 20 11:33:52 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 32822, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "ethtool", "3.5", "6.el6", "x86_64", "ethtool-3.5-6.el6.src.rpm", 283910, "GPLv2", "CentOS", "", "Ethernet settings tool for PCI ethernet cards", "RSA/SHA1, Fri Jul 24 20:38:43 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.4", "5.el6", "x86_64", "keyutils-1.4-5.el6.src.rpm", 36624, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA1, Fri Oct 17 20:01:07 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssl", "1.0.1e", "57.el6", "x86_64", "openssl-1.0.1e-57.el6.src.rpm", 4248338, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA1, Thu Mar 23 15:04:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 347536, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA1, Tue Apr  4 16:34:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 357074, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA1, Tue Apr  4 16:34:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.40", "16.el6", "x86_64", "openldap-2.4.40-16.el6.src.rpm", 859518, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA1, Thu Mar 23 14:58:56 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.1.8", "3.el6", "x86_64", "gpgme-1.1.8-3.el6.src.rpm", 729658, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Sun Jul  3 04:19:20 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "9.1.el6", "x86_64", "ustr-1.0.4-9.1.el6.src.rpm", 273983, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Sun Jul  3 05:04:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "5.el6", "x86_64", "shadow-utils-4.1.5.1-5.el6.src.rpm", 3466724, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA1, Thu May 12 10:48:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "MAKEDEV", "3.24", "6.el6", "x86_64", "MAKEDEV-3.24-6.el6.src.rpm", 227290, "GPLv2", "CentOS", "", "A program used for creating device files in /dev", "RSA/SHA256, Sun Jul  3 04:44:39 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 48770, "GPLv2+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA1, Thu May 12 10:46:07 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 79603, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA1, Thu Aug 18 17:21:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 120906, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "9.el6", "x86_64", "python-pycurl-7.19.0-9.el6.src.rpm", 236939, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA1, Thu May 12 10:47:30 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.3.1", "2.1.el6", "noarch", "python-iniparse-0.3.1-2.1.el6.src.rpm", 109284, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Sun Jul  3 04:42:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gamin", "0.1.10", "9.el6", "x86_64", "gamin-0.1.10-9.el6.src.rpm", 416440, "LGPLv2", "CentOS", "", "Library providing the FAM File Alteration Monitor API", "RSA/SHA256, Sun Jul  3 04:15:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "0.70", "6.el6", "x86_64", "shared-mime-info-0.70-6.el6.src.rpm", 1411396, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA1, Tue May 27 11:48:01 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.56.13", "8.el6_7", "x86_64", "libuser-0.56.13-8.el6_7.src.rpm", 1882055, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA1, Sat Jul 25 16:02:31 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 53961, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA1, Thu Aug  9 15:06:22 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "6", "10.el6.centos.12.3", "x86_64", "centos-release-6-10.el6.centos.12.3.src.rpm", 38232, "GPLv2", "CentOS", "", "CentOS release file", "RSA/SHA1, Tue Jun 26 15:35:30 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 22350, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA1, Thu Aug  9 15:06:21 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "6.1.el6", "noarch", "rootfiles-8.1-6.1.el6.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Sun Jul  3 04:45:28 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 13117447, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA1, Tue Apr  9 19:55:39 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "freetype", "2.3.11", "17.el6", "x86_64", "freetype-2.3.11-17.el6.src.rpm", 836907, "FTL or GPLv2+", "CentOS", "", "A free and portable font rendering engine", "RSA/SHA1, Thu May 12 10:50:28 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libjpeg-turbo", "1.2.1", "3.el6_5", "x86_64", "libjpeg-turbo-1.2.1-3.el6_5.src.rpm", 476782, "wxWidgets", "CentOS", "", "A MMX/SSE2 accelerated library for manipulating JPEG image files", "RSA/SHA1, Tue Dec 10 01:01:18 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy-python", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 8320, "LGPLv2+", "CentOS", "", "Binding for libproxy and python", "RSA/SHA1, Sat Oct 18 00:47:36 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m4", "1.4.13", "5.el6", "x86_64", "m4-1.4.13-5.el6.src.rpm", 560949, "GPLv3+", "CentOS", "", "The GNU macro processor", "RSA/SHA256, Sun Jul  3 04:44:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 648199, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA1, Thu May 12 10:51:01 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "avahi-libs", "0.6.25", "17.el6", "x86_64", "avahi-0.6.25-17.el6.src.rpm", 114824, "LGPLv2", "CentOS", "", "Libraries for avahi run-time use", "RSA/SHA1, Thu Mar 23 15:01:20 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "2.12.23", "22.el6", "x86_64", "gnutls-2.12.23-22.el6.src.rpm", 1167530, "GPLv3+ and LGPLv2+", "CentOS", "", "A TLS protocol implementation", "RSA/SHA1, Wed Jun 20 11:36:41 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 488160, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.20.51.0.2", "5.48.el6_10.1", "x86_64", "binutils-2.20.51.0.2-5.48.el6_10.1.src.rpm", 9831328, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA1, Tue Feb 26 17:18:14 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "5.el6", "x86_64", "unzip-6.0-5.el6.src.rpm", 331766, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA1, Thu Mar 23 15:02:42 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 127982, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GCC OpenMP v3.0 shared support library", "RSA/SHA1, Wed Jun 20 11:35:44 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patch", "2.6", "8.el6_9", "x86_64", "patch-2.6-8.el6_9.src.rpm", 179790, "GPLv2+", "CentOS", "", "Utility for modifying/upgrading files", "RSA/SHA1, Wed May  2 12:03:44 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpciaccess", "0.13.4", "1.el6", "x86_64", "libpciaccess-0.13.4-1.el6.src.rpm", 40777, "MIT", "CentOS", "", "PCI access library", "RSA/SHA1, Thu May 12 10:47:57 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util", "1.3.9", "3.el6_0.1", "x86_64", "apr-util-1.3.9-3.el6_0.1.src.rpm", 202360, "ASL 2.0", "CentOS", "", "Apache Portable Runtime Utility library", "RSA/SHA256, Wed Jul  6 01:37:03 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "cups-libs", "1.4.2", "81.el6_10", "x86_64", "cups-1.4.2-81.el6_10.src.rpm", 667768, "LGPLv2", "CentOS", "", "Common Unix Printing System - libraries", "RSA/SHA1, Tue Apr  9 19:55:40 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 10012603, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "The C Preprocessor", "RSA/SHA1, Wed Jun 20 11:35:48 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pakchois", "0.4", "3.2.el6", "x86_64", "pakchois-0.4-3.2.el6.src.rpm", 50156, "LGPLv2+", "CentOS", "", "A wrapper library for PKCS#11", "RSA/SHA256, Sun Jul  3 04:53:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.86", "6.el6", "x86_64", "dbus-glib-0.86-6.el6.src.rpm", 579611, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA1, Wed Feb 27 10:59:02 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-runtime", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 616098, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - runtime", "RSA/SHA1, Wed Jun 20 11:42:34 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck-lib", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 10353, "BSD", "CentOS", "", "Library files for fipscheck", "RSA/SHA1, Thu Dec  8 19:58:46 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pixman", "0.32.8", "1.el6", "x86_64", "pixman-0.32.8-1.el6.src.rpm", 721560, "MIT", "CentOS", "", "Pixel manipulation library", "RSA/SHA1, Thu May 12 10:45:42 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 1485896, "GPL+ or Artistic", "CentOS", "", "The libraries for the perl runtime", "RSA/SHA1, Thu Mar 23 15:04:17 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Module-Pluggable", "3.90", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 31033, "GPL+ or Artistic", "CentOS", "", "Automatically give your module the ability to have plugins", "RSA/SHA1, Thu Mar 23 15:02:55 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 35282834, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", "Practical Extraction and Report Language", "RSA/SHA1, Thu Mar 23 14:59:46 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Error", "0.17015", "4.el6", "noarch", "perl-Error-0.17015-4.el6.src.rpm", 47372, "GPL+ or Artistic", "CentOS", "", "Error/exception handling in an OO-ish way", "RSA/SHA256, Sun Jul  3 04:37:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "automake", "1.11.1", "4.el6", "noarch", "automake-1.11.1-4.el6.src.rpm", 1520636, "GPLv2+ and GFDL", "CentOS", "", "A GNU tool for automatically creating Makefiles", "RSA/SHA1, Sat Feb 23 17:50:34 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-IO-Compress-Base", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 138661, "GPL+ or Artistic", "CentOS", "", "Base Class for IO::Compress modules", "RSA/SHA1, Thu Mar 23 15:02:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 52519, "GPL+ or Artistic", "CentOS", "", "A module providing Perl interfaces to the zlib compression library", "RSA/SHA1, Thu Mar 23 14:59:19 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTML-Tagset", "3.20", "4.el6", "noarch", "perl-HTML-Tagset-3.20-4.el6.src.rpm", 19692, "GPL+ or Artistic", "CentOS", "", "HTML::Tagset - data tables useful in parsing HTML", "RSA/SHA256, Sun Jul  3 04:37:57 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cvs", "1.11.23", "16.el6", "x86_64", "cvs-1.11.23-16.el6.src.rpm", 1590583, "GPL+ and GPLv2+ and LGPL+", "CentOS", "", "A version control system", "RSA/SHA1, Sun Nov 24 19:31:18 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXau", "1.0.6", "4.el6", "x86_64", "libXau-1.0.6-4.el6.src.rpm", 40009, "MIT", "CentOS", "", "Sample Authorization Protocol for X", "RSA/SHA1, Sat Feb 23 17:40:25 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "upstart", "0.6.5", "17.el6", "x86_64", "upstart-0.6.5-17.el6.src.rpm", 567729, "GPLv2 and LGPLv2+", "CentOS", "", "An event-driven init system", "RSA/SHA1, Wed Jun 20 11:42:38 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cloog-ppl", "0.15.7", "1.2.el6", "x86_64", "cloog-0.15.7-1.2.el6.src.rpm", 185386, "GPLv2+", "CentOS", "", "Parma Polyhedra Library backend (ppl) based version of the Cloog binaries", "RSA/SHA256, Sun Jul  3 04:07:02 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb", "7.2", "92.el6", "x86_64", "gdb-7.2-92.el6.src.rpm", 5545845, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and GFDL and BSD and Public Domain", "CentOS", "", "A GNU source-level debugger for C, C++, Java and other languages", "RSA/SHA1, Thu Mar 23 15:02:13 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libthai", "0.1.12", "3.el6", "x86_64", "libthai-0.1.12-3.el6.src.rpm", 694712, "LGPLv2+", "CentOS", "", "Thai language support routines", "RSA/SHA256, Sun Jul  3 04:39:56 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libedit", "2.11", "4.20080712cvs.1.el6", "x86_64", "libedit-2.11-4.20080712cvs.1.el6.src.rpm", 185648, "BSD", "CentOS", "", "The NetBSD Editline library", "RSA/SHA256, Sun Jul  3 04:33:24 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-headers", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 2146171, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Header files for development using standard C libraries.", "RSA/SHA1, Tue Apr  9 19:55:40 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 19499265, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Various compilers (C, C++, Objective-C, Java, ...)", "RSA/SHA1, Wed Jun 20 11:35:44 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11-common", "1.6.4", "3.el6", "noarch", "libX11-1.6.4-3.el6.src.rpm", 1341368, "MIT", "CentOS", "", "Common data for libX11", "RSA/SHA1, Thu Mar 23 14:59:33 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrender", "0.9.10", "1.el6", "x86_64", "libXrender-0.9.10-1.el6.src.rpm", 40515, "MIT", "CentOS", "", "X.Org X11 libXrender runtime library", "RSA/SHA1, Thu Mar 23 15:02:17 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cairo", "1.8.8", "6.el6_6", "x86_64", "cairo-1.8.8-6.el6_6.src.rpm", 797873, "LGPLv2 or MPLv1.1", "CentOS", "", "A 2D graphics library", "RSA/SHA1, Mon Jun 22 15:01:35 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrandr", "1.5.1", "1.el6", "x86_64", "libXrandr-1.5.1-1.el6.src.rpm", 43834, "MIT", "CentOS", "", "X.Org X11 libXrandr runtime library", "RSA/SHA1, Thu Mar 23 15:02:06 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdk-pixbuf2", "2.24.1", "6.el6_7", "x86_64", "gdk-pixbuf2-2.24.1-6.el6_7.src.rpm", 2637837, "LGPLv2+ and (LGPLv2+ or MPLv1.1) and Public Domain", "CentOS", "", "An image loading library", "RSA/SHA1, Mon Aug 31 16:41:21 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXdamage", "1.1.3", "4.el6", "x86_64", "libXdamage-1.1.3-4.el6.src.rpm", 24896, "MIT", "CentOS", "", "X Damage extension library", "RSA/SHA1, Sat Feb 23 17:40:50 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXinerama", "1.1.3", "2.1.el6", "x86_64", "libXinerama-1.1.3-2.1.el6.src.rpm", 12039, "MIT", "CentOS", "", "X.Org X11 libXinerama runtime library", "RSA/SHA1, Fri Oct 17 20:01:27 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pango", "1.28.1", "11.el6", "x86_64", "pango-1.28.1-11.el6.src.rpm", 1041857, "LGPLv2+", "CentOS", "", "System for layout and rendering of internationalized text", "RSA/SHA1, Thu Feb  4 21:37:46 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mailcap", "2.1.31", "2.el6", "noarch", "mailcap-2.1.31-2.el6.src.rpm", 52877, "Public Domain and MIT", "CentOS", "", "Helper application and MIME type associations for file types", "RSA/SHA1, Mon Sep 26 04:12:20 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-XML-Parser", "2.36", "7.el6", "x86_64", "perl-XML-Parser-2.36-7.el6.src.rpm", 652307, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing XML files", "RSA/SHA256, Sun Jul  3 04:56:39 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils", "2.0.83", "30.1.el6_8", "x86_64", "policycoreutils-2.0.83-30.1.el6_8.src.rpm", 3596110, "GPLv2+", "CentOS", "", "SELinux policy core utilities", "RSA/SHA1, Sat Nov 19 11:15:26 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:6 bash
	// yum groupinstall -y "Development tools"
	// yum install -y rpm-build redhat-rpm-config asciidoc hmaccalc perl-ExtUtils-Embed pesign xmlto
	// yum install -y audit-libs-devel binutils-devel elfutils-devel elfutils-libelf-devel java-devel
	// yum install -y ncurses-devel newt-devel numactl-devel pciutils-devel python-devel zlib-devel
	// yum install -y net-tools bc
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS6Many = []*PackageInfo{
		{intRef(), "iproute", "2.6.32", "57.el6", "x86_64", "iproute-2.6.32-57.el6.src.rpm", 963477, "GPLv2+ and Public Domain", "CentOS", "", "Advanced IP routing and network device configuration tools", "RSA/SHA1, Wed Jun 20 11:37:15 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.14", "23.el6", "noarch", "setup-2.8.14-23.el6.src.rpm", 666669, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA1, Thu Mar 23 15:02:51 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20071127", "24.el6", "x86_64", "iputils-20071127-24.el6.src.rpm", 297243, "BSD with advertising and GPLv2+ and Rdisc", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA1, Thu Mar 23 15:04:12 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "4.el6", "noarch", "basesystem-10.0-4.el6.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple Red Hat Enterprise Linux system", "RSA/SHA256, Sun Jul  3 04:00:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux-ng", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 6139437, "GPLv1+ and GPLv2 and GPLv2+ and LGPLv2+ and MIT and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018e", "3.el6", "noarch", "tzdata-2018e-3.el6.src.rpm", 1961609, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA1, Wed May  9 22:47:10 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "udev", "147", "2.73.el6_8.2", "x86_64", "udev-147-2.73.el6_8.2.src.rpm", 1280842, "GPLv2", "CentOS", "", "A userspace implementation of devfs", "RSA/SHA1, Tue Sep  6 16:49:50 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh-clients", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 1352442, "BSD", "CentOS", "", "An open source SSH client applications", "RSA/SHA1, Tue Apr  9 19:55:39 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git", "1.7.1", "9.el6_9", "x86_64", "git-1.7.1-9.el6_9.src.rpm", 15290753, "GPLv2", "CentOS", "", "Fast Version Control System", "RSA/SHA1, Thu Aug 17 10:25:25 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.1.2", "48.el6", "x86_64", "bash-4.1.2-48.el6.src.rpm", 3142529, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA1, Thu Mar 23 14:59:39 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-devel", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 6327079, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - development headers, tools", "RSA/SHA1, Wed Jun 20 11:42:34 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.16", "5.5.el6", "x86_64", "libcap-2.16-5.5.el6.src.rpm", 64437, "LGPLv2+ or BSD", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA1, Thu Dec  8 20:15:52 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hicolor-icon-theme", "0.11", "1.1.el6", "noarch", "hicolor-icon-theme-0.11-1.1.el6.src.rpm", 45406, "GPL+", "CentOS", "", "Basic requirement for icon themes", "RSA/SHA256, Sun Jul  3 04:13:15 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "4.13a", "8.el6", "x86_64", "texinfo-4.13a-8.el6.src.rpm", 329482, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Sun Jul  3 04:24:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcj", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 65012480, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Java runtime library for gcc", "RSA/SHA1, Wed Jun 20 11:35:45 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.49", "7.el6_9.1", "x86_64", "acl-2.2.49-7.el6_9.1.src.rpm", 31280, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA1, Wed Aug 23 18:02:40 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "intltool", "0.41.0", "1.1.el6", "noarch", "intltool-0.41.0-1.1.el6.src.rpm", 167585, "GPLv2 with exceptions", "CentOS", "", "Utility for internationalizing various kinds of data files", "RSA/SHA256, Sun Jul  3 04:16:01 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el6", "x86_64", "nspr-4.19.0-1.el6.src.rpm", 281968, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA1, Wed Jun 20 11:40:25 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subversion", "1.6.11", "15.el6_7", "x86_64", "subversion-1.6.11-15.el6_7.src.rpm", 12105530, "ASL 1.1", "CentOS", "", "A Modern Concurrent Version Control System", "RSA/SHA1, Mon Aug 17 15:28:40 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.41.12", "24.el6", "x86_64", "e2fsprogs-1.41.12-24.el6.src.rpm", 59233, "MIT", "CentOS", "", "Common error description library", "RSA/SHA1, Wed Jun 20 11:35:17 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-gfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 14473805, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Fortran support", "RSA/SHA1, Wed Jun 20 11:35:49 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.0.41", "4.el6", "x86_64", "libsepol-2.0.41-4.el6.src.rpm", 248680, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA1, Thu Dec  8 20:24:54 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 323213, "GPLv2+", "CentOS", "", "Scripts and executable programs used to build packages", "RSA/SHA1, Wed Jun 20 11:41:14 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.3.49.5", "1.el6", "x86_64", "chkconfig-1.3.49.5-1.el6.src.rpm", 670580, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA1, Thu May 12 10:46:23 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "flex", "2.5.35", "9.el6", "x86_64", "flex-2.5.35-9.el6.src.rpm", 736081, "BSD", "CentOS", "", "A tool for creating scanners (text pattern recognizers)", "RSA/SHA1, Fri Oct 17 20:02:30 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 235282, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA1, Thu Mar 23 14:59:31 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cscope", "15.6", "7.el6", "x86_64", "cscope-15.6-7.el6.src.rpm", 466265, "BSD", "CentOS", "", "C source code tree search and browse tool", "RSA/SHA1, Thu May 12 10:50:09 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.0", "4.el6", "x86_64", "readline-6.0-4.el6.src.rpm", 433957, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA1, Sun Jun 24 22:18:23 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rcs", "5.7", "37.el6", "x86_64", "rcs-5.7-37.el6.src.rpm", 709927, "GPLv2+", "CentOS", "", "Revision Control System (RCS) file version management tools", "RSA/SHA256, Sun Jul  3 05:00:06 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 2486624, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA1, Thu May 12 10:46:22 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffstat", "1.51", "2.el6", "x86_64", "diffstat-1.51-2.el6.src.rpm", 45568, "MIT", "CentOS", "", "A utility which provides statistics based on the output of diff", "RSA/SHA256, Sun Jul  3 04:10:09 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 265736, "GPLv2+ or AFL", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA1, Wed Jun 20 11:34:38 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "doxygen", "1.6.1", "6.el6", "x86_64", "doxygen-1.6.1-6.el6.src.rpm", 9446190, "GPL+", "CentOS", "", "A documentation system for C/C++", "RSA/SHA1, Mon Sep 26 04:17:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.6.20", "1.el6_7.2", "x86_64", "sqlite-3.6.20-1.el6_7.2.src.rpm", 640060, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA1, Mon Aug 17 15:29:10 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxslt", "1.1.26", "2.el6_3.1", "x86_64", "libxslt-1.1.26-2.el6_3.1.src.rpm", 2223955, "MIT", "CentOS", "", "Library providing the Gnome XSLT engine", "RSA/SHA1, Thu Sep 13 18:29:17 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 16304, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4-cxx", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1647216, "Sleepycat and BSD", "CentOS", "", "The Berkeley DB database library (version 4) for C++", "RSA/SHA1, Thu Mar 23 15:01:47 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 214490, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm-devel", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 22251, "GPLv2+", "CentOS", "", "Development libraries and header files for the gdbm library", "RSA/SHA1, Thu May 12 10:47:46 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.7", "4.el6", "x86_64", "libgpg-error-1.7-4.el6.src.rpm", 214321, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA1, Thu Dec  8 20:17:43 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-ExtUtils-ParseXS", "2.2003.0", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 62208, "GPL+ or Artistic", "CentOS", "", "Module and a script for converting Perl XS code into C code", "RSA/SHA1, Thu Mar 23 14:59:10 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "7.8", "7.el6", "x86_64", "pcre-7.8-7.el6.src.rpm", 529027, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA1, Fri Jul 24 20:42:33 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-ExtUtils-MakeMaker", "6.55", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 622462, "GPL+ or Artistic", "CentOS", "", "Create a module Makefile", "RSA/SHA1, Thu Mar 23 15:03:53 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.4.2", "9.el6", "x86_64", "findutils-4.4.2-9.el6.src.rpm", 1442912, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA1, Tue Mar  1 13:06:19 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "docbook-dtds", "1.0", "51.el6", "noarch", "docbook-dtds-1.0-51.el6.src.rpm", 4571574, "Copyright only", "CentOS", "", "SGML and XML document type definitions for DocBook", "RSA/SHA256, Sun Jul  3 04:04:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-indexhtml", "6", "2.el6.centos", "noarch", "centos-indexhtml-6-2.el6.centos.src.rpm", 92560, "Distributable", "CentOS", "", "Browser default start page for CentOS", "RSA/SHA1, Fri Oct 24 12:17:02 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.0.1", "13.el6_8", "x86_64", "expat-2.0.1-13.el6_8.src.rpm", 197794, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA1, Mon Nov 28 22:28:33 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xmlto", "0.0.23", "3.el6", "x86_64", "xmlto-0.0.23-3.el6.src.rpm", 99317, "GPLv2+", "CentOS", "", "A tool for converting XML files to various formats", "RSA/SHA256, Sun Jul  3 05:06:01 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 262669, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA1, Tue Jan 28 09:43:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-ExtUtils-Embed", "1.28", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 17130, "GPL+ or Artistic", "CentOS", "", "Utilities for embedding Perl in C/C++ applications", "RSA/SHA1, Thu Mar 23 15:00:40 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.4.5", "12.el6_8", "x86_64", "libgcrypt-1.4.5-12.el6_8.src.rpm", 536622, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA1, Sat Nov 12 06:30:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libogg", "1.1.4", "2.1.el6", "x86_64", "libogg-1.1.4-2.1.el6.src.rpm", 30454, "BSD", "CentOS", "", "The Ogg bitstream file format library", "RSA/SHA256, Sun Jul  3 04:37:28 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXfont", "1.5.1", "2.el6", "x86_64", "libXfont-1.5.1-2.el6.src.rpm", 336333, "MIT", "CentOS", "", "X.Org X11 libXfont runtime library", "RSA/SHA1, Thu May 12 10:48:28 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libusb", "0.1.12", "23.el6", "x86_64", "libusb-0.1.12-23.el6.src.rpm", 54440, "LGPLv2+", "CentOS", "", "A library which allows userspace access to USB devices", "RSA/SHA256, Sun Jul  3 04:40:22 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "libvorbis", "1.2.3", "5.el6_9.1", "x86_64", "libvorbis-1.2.3-5.el6_9.1.src.rpm", 2152680, "BSD", "CentOS", "", "The Vorbis General Audio Compression Codec.", "RSA/SHA1, Mon Apr  9 23:35:15 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.7.6", "8.el6", "x86_64", "pinentry-0.7.6-8.el6.src.rpm", 147023, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA1, Mon Mar 30 13:24:38 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsndfile", "1.0.20", "5.el6", "x86_64", "libsndfile-1.0.20-5.el6.src.rpm", 770762, "LGPLv2+ and GPLv2+ and BSD", "CentOS", "", "Library for reading and writing sound files", "RSA/SHA1, Mon Sep 26 04:21:05 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps", "3.2.8", "45.el6_9.3", "x86_64", "procps-3.2.8-45.el6_9.3.src.rpm", 475526, "GPLv2+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA1, Fri Jun  1 15:12:06 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "giflib", "4.1.6", "3.1.el6", "x86_64", "giflib-4.1.6-3.1.el6.src.rpm", 81932, "MIT", "CentOS", "", "Library for manipulating GIF format image files", "RSA/SHA256, Sun Jul  3 04:16:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.23", "15.el6_8", "x86_64", "tar-1.23-15.el6_8.src.rpm", 2616465, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA1, Tue Jul 12 17:11:45 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.6.4", "3.el6_0.1", "x86_64", "libcap-ng-0.6.4-3.el6_0.1.src.rpm", 45214, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Wed Jul  6 01:40:42 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "checkpolicy", "2.0.22", "1.el6", "x86_64", "checkpolicy-2.0.22-1.el6.src.rpm", 870239, "GPLv2", "CentOS", "", "SELinux policy compiler", "RSA/SHA256, Sun Jul  3 04:06:47 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ConsoleKit-libs", "0.4.1", "6.el6", "x86_64", "ConsoleKit-0.4.1-6.el6.src.rpm", 22061, "MIT", "CentOS", "", "ConsoleKit libraries", "RSA/SHA1, Thu May 12 10:47:50 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libIDL", "0.8.13", "2.1.el6", "x86_64", "libIDL-0.8.13-2.1.el6.src.rpm", 214847, "LGPLv2+", "CentOS", "", "Library for parsing IDL (Interface Definition Language)", "RSA/SHA256, Sun Jul  3 04:35:59 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4-utils", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 416398, "Sleepycat and BSD", "CentOS", "", "Command line tools for managing Berkeley DB (version 4) databases", "RSA/SHA1, Thu Mar 23 15:01:47 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib-devel", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 117496, "zlib and Boost", "CentOS", "", "Header files and libraries for Zlib development", "RSA/SHA1, Sat Feb 23 17:40:28 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcsc-lite-libs", "1.5.2", "16.el6", "x86_64", "pcsc-lite-1.5.2-16.el6.src.rpm", 44912, "BSD", "CentOS", "", "PC/SC Lite libraries", "RSA/SHA1, Thu Mar 23 15:03:07 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "which", "2.19", "6.el6", "x86_64", "which-2.19-6.el6.src.rpm", 73004, "GPLv3", "CentOS", "", "Displays where a particular program in your path is located", "RSA/SHA1, Mon Sep 26 04:26:13 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ttmkfdir", "3.0.9", "32.1.el6", "x86_64", "ttmkfdir-3.0.9-32.1.el6.src.rpm", 101747, "LGPLv2+", "CentOS", "", "Utility to create fonts.scale files for truetype fonts", "RSA/SHA256, Sun Jul  3 05:04:20 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dash", "0.5.5.1", "4.el6", "x86_64", "dash-0.5.5.1-4.el6.src.rpm", 127277, "BSD", "CentOS", "", "Small and fast POSIX-compliant shell", "RSA/SHA1, Wed Oct 17 10:45:23 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "eggdbus", "0.6", "3.el6", "x86_64", "eggdbus-0.6-3.el6.src.rpm", 321013, "LGPLv2", "CentOS", "", "Experimental D-Bus bindings for GObject", "RSA/SHA256, Sun Jul  3 04:12:39 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff", "1.18.1.4", "21.el6", "x86_64", "groff-1.18.1.4-21.el6.src.rpm", 5318766, "GPLv2 and GFDL", "CentOS", "", "A document formatting system", "RSA/SHA256, Sun Jul  3 04:19:43 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ConsoleKit", "0.4.1", "6.el6", "x86_64", "ConsoleKit-0.4.1-6.el6.src.rpm", 273094, "GPLv2+", "CentOS", "", "System daemon for tracking users, sessions and seats", "RSA/SHA1, Thu May 12 10:45:56 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-libs", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 5576, "GPLv3+", "CentOS", "", "Libraries for coreutils", "RSA/SHA1, Wed Jun 20 11:34:12 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libasyncns", "0.8", "1.1.el6", "x86_64", "libasyncns-0.8-1.1.el6.src.rpm", 52778, "LGPLv2+", "CentOS", "", "Asynchronous Name Service Library", "RSA/SHA256, Sun Jul  3 04:31:45 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 187265, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Wed Jul  6 01:37:30 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata-java", "2019a", "1.el6", "noarch", "tzdata-2019a-1.el6.src.rpm", 374277, "Public Domain", "CentOS", "", "Timezone data for Java", "RSA/SHA1, Mon Apr  1 17:09:54 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 12873065, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA1, Wed Jun 20 11:34:12 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "java-1.7.0-openjdk", "1.7.0.221", "2.6.18.0.el6_10", "x86_64", "java-1.7.0-openjdk-1.7.0.221-2.6.18.0.el6_10.src.rpm", 96821020, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv1.1 and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", "OpenJDK Runtime Environment", "RSA/SHA1, Mon Apr 22 20:19:19 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "module-init-tools", "3.9", "26.el6", "x86_64", "module-init-tools-3.9-26.el6.src.rpm", 1216834, "GPLv2+", "CentOS", "", "Kernel module management utilities.", "RSA/SHA1, Thu Mar 23 15:00:22 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-devel", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 305553, "GPLv2+ or LGPLv3+", "CentOS", "", "Development libraries to handle compiled objects", "RSA/SHA1, Thu May 12 10:52:34 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "slang", "2.2.1", "1.el6", "x86_64", "slang-2.2.1-1.el6.src.rpm", 1800725, "GPLv2+", "CentOS", "", "The shared library for the S-Lang extension language", "RSA/SHA256, Sun Jul  3 05:02:05 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "slang-devel", "2.2.1", "1.el6", "x86_64", "slang-2.2.1-1.el6.src.rpm", 395444, "GPLv2+", "CentOS", "", "Development files for the S-Lang extension language", "RSA/SHA256, Sun Jul  3 05:02:06 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2660886, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "numactl", "2.0.9", "2.el6", "x86_64", "numactl-2.0.9-2.el6.src.rpm", 175404, "LGPLv2/GPLv2", "CentOS", "", "Library for tuning for Non Uniform Memory Access machines", "RSA/SHA1, Fri Oct 17 20:01:46 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2052883, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pciutils-devel", "3.1.10", "4.el6", "x86_64", "pciutils-3.1.10-4.el6.src.rpm", 74324, "GPLv2+", "CentOS", "", "Linux PCI development library", "RSA/SHA1, Tue Aug  5 12:39:17 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mingetty", "1.08", "5.el6", "x86_64", "mingetty-1.08-5.el6.src.rpm", 34586, "GPLv2+", "CentOS", "", "A compact getty program for virtual consoles only", "RSA/SHA1, Mon Sep 26 04:21:55 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-devel", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 467448, "Python", "CentOS", "", "The libraries and header files needed for Python development", "RSA/SHA1, Thu Aug 18 17:21:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.10.3", "65.el6", "x86_64", "krb5-1.10.3-65.el6.src.rpm", 1813468, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA1, Thu Mar 23 15:01:43 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bc", "1.06.95", "1.el6", "x86_64", "bc-1.06.95-1.el6.src.rpm", 217289, "GPLv2+", "CentOS", "", "GNU's bc (a numeric processing language) and dc (a calculator)", "RSA/SHA256, Sun Jul  3 04:04:45 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.2", "2.el6_7.1", "x86_64", "libssh2-1.4.2-2.el6_7.1.src.rpm", 325165, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA1, Thu Mar 10 12:04:29 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 777656, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 2034245, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.14", "9.el6_10", "x86_64", "gnupg2-2.0.14-9.el6_10.src.rpm", 6087540, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA1, Fri Jul 13 16:08:36 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-libs", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 2340720, "ISC", "CentOS", "", "Libraries used by the BIND DNS packages", "RSA/SHA1, Tue Aug 28 15:39:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.0.43", "5.1.el6", "x86_64", "libsemanage-2.0.43-5.1.el6.src.rpm", 204223, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA1, Fri Jul 24 20:40:14 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.5", "4.1.el6", "x86_64", "libutempter-1.1.5-4.1.el6.src.rpm", 40785, "LGPLv2", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Sun Jul  3 04:40:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth-core-libs", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 177760, "GPLv2+", "CentOS", "", "Plymouth libraries", "RSA/SHA1, Thu Mar 23 14:59:05 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.5", "3.2.el6", "x86_64", "libffi-3.0.5-3.2.el6.src.rpm", 42881, "BSD", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Jul  3 04:33:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 22979382, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA1, Thu Aug 18 17:21:24 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.1", "18.20090824bzr68.el6", "x86_64", "pygpgme-0.1-18.20090824bzr68.el6.src.rpm", 251432, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Sun Jul  3 04:58:12 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.9.1", "11.el6", "noarch", "python-urlgrabber-3.9.1-11.el6.src.rpm", 323137, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA1, Thu May 12 10:50:34 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.23", "9.1.el6", "x86_64", "pkgconfig-0.23-9.1.el6.src.rpm", 140091, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Sun Jul  3 04:57:05 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.28.8", "10.el6", "x86_64", "glib2-2.28.8-10.el6.src.rpm", 8061476, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA1, Wed Jun 20 11:36:18 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.2", "16.el6", "x86_64", "yum-metadata-parser-1.1.2-16.el6.src.rpm", 58327, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA1, Mon Sep 26 04:26:27 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.2.29", "81.el6.centos", "noarch", "yum-3.2.29-81.el6.centos.src.rpm", 4832194, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA1, Thu Mar 23 15:04:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.77", "7.el6", "x86_64", "passwd-0.77-7.el6.src.rpm", 357699, "BSD or GPLv2+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA1, Wed Dec  2 14:02:45 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-utils", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 451000, "ISC", "CentOS", "", "Utilities for querying DNS name servers", "RSA/SHA1, Tue Aug 28 15:39:45 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.629", "5.el6_8.1", "x86_64", "vim-7.4.629-5.el6_8.1.src.rpm", 909230, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA1, Wed Dec 21 17:40:06 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "c105b9de", "4e0fd3a3", "", "", 0, "pubkey", "", "", "gpg(CentOS-6 Key (CentOS 6 Official Signing Key) <centos-6-key@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 112434659, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA1, Tue Apr  9 19:55:38 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontconfig", "2.8.0", "5.el6", "x86_64", "fontconfig-2.8.0-5.el6.src.rpm", 450597, "MIT", "CentOS", "", "Font configuration and customization library", "RSA/SHA1, Tue May 27 11:48:58 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy-bin", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 6800, "LGPLv2+", "CentOS", "", "Binary to test libproxy", "RSA/SHA1, Sat Oct 18 00:47:34 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 118439, "LGPLv2+", "CentOS", "", "A library handling all the details of proxy configuration", "RSA/SHA1, Sat Oct 18 00:47:35 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "2.4.1", "6.el6", "x86_64", "mpfr-2.4.1-6.el6.src.rpm", 377376, "LGPLv2+ and GPLv2+ and GFDL", "CentOS", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Sun Jul  3 04:45:47 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libpng", "1.2.49", "2.el6_7", "x86_64", "libpng-1.2.49-2.el6_7.src.rpm", 654803, "zlib", "CentOS", "", "A library of functions for manipulating PNG image format files", "RSA/SHA1, Wed Dec  9 14:32:24 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtiff", "3.9.4", "21.el6_8", "x86_64", "libtiff-3.9.4-21.el6_8.src.rpm", 966899, "libtiff", "CentOS", "", "Library of functions for manipulating TIFF format image files", "RSA/SHA1, Wed Feb  1 12:47:19 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zip", "3.0", "1.el6_7.1", "x86_64", "zip-3.0-1.el6_7.1.src.rpm", 823164, "BSD", "CentOS", "", "A file compression and packaging utility compatible with PKZIP", "RSA/SHA1, Tue Nov 10 12:42:06 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr", "1.3.9", "5.el6_9.1", "x86_64", "apr-1.3.9-5.el6_9.1.src.rpm", 303173, "ASL 2.0", "CentOS", "", "Apache Portable Runtime library", "RSA/SHA1, Tue Nov 28 22:08:47 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sysvinit-tools", "2.87", "6.dsf.el6", "x86_64", "sysvinit-2.87-6.dsf.el6.src.rpm", 114115, "GPLv2+", "CentOS", "", "Tools used for process and utmp management.", "RSA/SHA1, Fri Jul 24 20:42:14 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "atk", "1.30.0", "1.el6", "x86_64", "atk-1.30.0-1.el6.src.rpm", 957484, "LGPLv2+", "CentOS", "", "Interfaces for accessibility support", "RSA/SHA1, Sun Nov 24 19:31:06 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libICE", "1.0.6", "1.el6", "x86_64", "libICE-1.0.6-1.el6.src.rpm", 117691, "MIT", "CentOS", "", "X.Org X11 ICE runtime library", "RSA/SHA256, Sun Jul  3 04:35:49 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hwdata", "0.233", "20.1.el6", "noarch", "hwdata-0.233-20.1.el6.src.rpm", 5894683, "GPLv2+", "CentOS", "", "Hardware identification and configuration data", "RSA/SHA1, Wed Jun 20 11:36:50 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libSM", "1.2.1", "2.el6", "x86_64", "libSM-1.2.1-2.el6.src.rpm", 78264, "MIT", "CentOS", "", "X.Org X11 SM runtime library", "RSA/SHA1, Sat Feb 23 17:41:20 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-lzma-compat", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 21146, "GPLv2+ and LGPLv2+", "CentOS", "", "Older LZMA format compatibility binaries", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 677800, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", "A collection of utilities and DSOs to handle compiled objects", "RSA/SHA1, Thu May 12 10:51:54 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jasper-libs", "1.900.1", "22.el6", "x86_64", "jasper-1.900.1-22.el6.src.rpm", 341232, "JasPer", "CentOS", "", "Runtime libraries for jasper", "RSA/SHA1, Wed Jun 20 11:37:32 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "neon", "0.29.3", "3.el6_4", "x86_64", "neon-0.29.3-3.el6_4.src.rpm", 297415, "LGPLv2+", "CentOS", "", "An HTTP and WebDAV client library", "RSA/SHA1, Tue Sep  3 09:12:17 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "alsa-lib", "1.1.0", "4.el6", "x86_64", "alsa-lib-1.1.0-4.el6.src.rpm", 1277969, "LGPLv2+", "CentOS", "", "The Advanced Linux Sound Architecture (ALSA) library", "RSA/SHA1, Thu May 12 10:46:31 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libart_lgpl", "2.3.20", "5.1.el6", "x86_64", "libart_lgpl-2.3.20-5.1.el6.src.rpm", 129211, "LGPLv2+", "CentOS", "", "Library of graphics routines used by libgnomecanvas", "RSA/SHA256, Sun Jul  3 04:31:40 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 28163, "BSD", "CentOS", "", "A library for integrity verification of FIPS validated modules", "RSA/SHA1, Thu Dec  8 19:58:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.04", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 21092, "GPL+ or Artistic", "CentOS", "", "Perl module for resolving POD escape sequences", "RSA/SHA1, Thu Mar 23 15:01:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.13", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 476776, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA1, Thu Mar 23 15:03:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(3), "perl-version", "0.77", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 51960, "GPL+ or Artistic", "CentOS", "", "Perl extension for Version Objects", "RSA/SHA1, Thu Mar 23 15:03:02 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-URI", "1.40", "2.el6", "noarch", "perl-URI-1.40-2.el6.src.rpm", 256097, "GPL+ or Artistic", "CentOS", "", "A Perl module implementing URI parsing and manipulation", "RSA/SHA256, Sun Jul  3 04:39:35 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "autoconf", "2.63", "5.1.el6", "noarch", "autoconf-2.63-5.1.el6.src.rpm", 2605343, "GPLv3+ and GFDL", "CentOS", "", "A GNU tool for automatically configuring source code", "RSA/SHA256, Sun Jul  3 04:00:14 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Compress-Raw-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 146581, "GPL+ or Artistic", "CentOS", "", "Low-Level Interface to the zlib compression library", "RSA/SHA1, Thu Mar 23 15:02:36 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-IO-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 372202, "GPL+ or Artistic", "CentOS", "", "Perl interface to allow reading and writing of gzip and zip data", "RSA/SHA1, Thu Mar 23 15:02:51 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-rpm-config", "9.0.3", "51.el6.centos", "noarch", "redhat-rpm-config-9.0.3-51.el6.centos.src.rpm", 138592, "GPL+", "CentOS", "", "Red Hat specific rpm configuration files", "RSA/SHA1, Thu May 12 10:51:05 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTML-Parser", "3.64", "2.el6", "x86_64", "perl-HTML-Parser-3.64-2.el6.src.rpm", 226598, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing HTML", "RSA/SHA256, Sun Jul  3 04:55:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 6369345, "GPLv3 and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA1, Mon Jun  2 11:16:57 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcb", "1.12", "4.el6", "x86_64", "libxcb-1.12-4.el6.src.rpm", 886960, "MIT", "CentOS", "", "A C binding to the X11 protocol", "RSA/SHA1, Thu Mar 23 14:59:07 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ppl", "0.10.2", "11.el6", "x86_64", "ppl-0.10.2-11.el6.src.rpm", 4637284, "GPLv3+", "CentOS", "", "The Parma Polyhedra Library: a library of numerical abstractions", "RSA/SHA256, Sun Jul  3 04:57:44 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rsync", "3.0.6", "12.el6", "x86_64", "rsync-3.0.6-12.el6.src.rpm", 698678, "GPLv3+", "CentOS", "", "A program for synchronizing files over a network", "RSA/SHA1, Wed Apr 30 13:29:10 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 278832, "LGPLv2+", "CentOS", "", "Libraries for gettext", "RSA/SHA1, Mon Jun  2 11:16:57 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgfortran", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 988064, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Fortran runtime", "RSA/SHA1, Wed Jun 20 11:35:49 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-headers", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 2776718, "GPLv2", "CentOS", "", "Header files for the Linux kernel for use by glibc", "RSA/SHA1, Tue Apr  9 19:55:37 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-devel", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 990251, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Object files for development using standard C libraries.", "RSA/SHA1, Tue Apr  9 19:55:37 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++-devel", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 9728819, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Header files and libraries for C++ development", "RSA/SHA1, Wed Jun 20 11:35:47 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11", "1.6.4", "3.el6", "x86_64", "libX11-1.6.4-3.el6.src.rpm", 1301928, "MIT", "CentOS", "", "Core X11 protocol client library", "RSA/SHA1, Thu Mar 23 15:01:37 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXext", "1.3.3", "1.el6", "x86_64", "libXext-1.3.3-1.el6.src.rpm", 85590, "MIT", "CentOS", "", "X.Org X11 libXext runtime library", "RSA/SHA1, Thu May 12 10:52:24 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXfixes", "5.0.3", "1.el6", "x86_64", "libXfixes-5.0.3-1.el6.src.rpm", 23375, "MIT", "CentOS", "", "X Fixes library", "RSA/SHA1, Thu Mar 23 15:00:46 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXi", "1.7.8", "1.el6", "x86_64", "libXi-1.7.8-1.el6.src.rpm", 66523, "MIT", "CentOS", "", "X.Org X11 libXi runtime library", "RSA/SHA1, Thu Mar 23 15:01:34 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXtst", "1.2.3", "1.el6", "x86_64", "libXtst-1.2.3-1.el6.src.rpm", 27778, "MIT", "CentOS", "", "X.Org X11 libXtst runtime library", "RSA/SHA1, Thu Mar 23 15:00:57 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcursor", "1.1.14", "2.1.el6", "x86_64", "libXcursor-1.1.14-2.1.el6.src.rpm", 41934, "MIT", "CentOS", "", "Cursor management library", "RSA/SHA1, Fri Oct 17 20:00:41 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXft", "2.3.2", "1.el6", "x86_64", "libXft-2.3.2-1.el6.src.rpm", 120045, "MIT", "CentOS", "", "X.Org X11 libXft runtime library", "RSA/SHA1, Thu May 12 10:50:04 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcomposite", "0.4.3", "4.el6", "x86_64", "libXcomposite-0.4.3-4.el6.src.rpm", 31878, "MIT", "CentOS", "", "X Composite Extension library", "RSA/SHA1, Sat Feb 23 17:41:25 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-libwww-perl", "5.833", "5.el6", "noarch", "perl-libwww-perl-5.833-5.el6.src.rpm", 903654, "GPL+ or Artistic", "CentOS", "", "A Perl interface to the World-Wide Web", "RSA/SHA1, Thu Mar 23 15:01:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-logos", "60.0.14", "12.el6.centos", "noarch", "redhat-logos-60.0.14-12.el6.centos.src.rpm", 15816517, "Copyright 1999-2010 the CentOS Project.  All rights reserved.", "CentOS", "", "CentOS-related icons and pictures", "RSA/SHA1, Thu Aug 16 13:08:48 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iptables", "1.4.7", "19.el6", "x86_64", "iptables-1.4.7-19.el6.src.rpm", 861752, "GPLv2", "CentOS", "", "Tools for managing Linux kernel packet filtering capabilities", "RSA/SHA1, Wed Jun 20 11:37:20 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 117352, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GCC version 4.4 shared support library", "RSA/SHA1, Wed Jun 20 11:35:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdrm", "2.4.65", "2.el6", "x86_64", "libdrm-2.4.65-2.el6.src.rpm", 306787, "MIT", "CentOS", "", "Direct Rendering Manager runtime library", "RSA/SHA1, Thu May 12 10:51:42 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "2.4.30", "3.el6", "x86_64", "filesystem-2.4.30-3.el6.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA1, Mon Sep 26 04:18:23 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 193924, "GPLv2+", "CentOS", "", "Graphical Boot Animation and Logger", "RSA/SHA1, Thu Mar 23 15:02:06 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "initscripts", "9.03.61", "1.el6.centos", "x86_64", "initscripts-9.03.61-1.el6.centos.src.rpm", 5735427, "GPLv2 and GPLv2+", "CentOS", "", "The inittab file and the /etc/init.d scripts", "RSA/SHA1, Wed Jun 20 11:37:06 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 193090, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA1, Mon Mar 16 14:43:09 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh", "5.3p1", "124.el6_10", "x86_64", "openssh-5.3p1-124.el6_10.src.rpm", 787618, "BSD", "CentOS", "", "An open source implementation of SSH protocol versions 1 and 2", "RSA/SHA1, Tue Apr  9 19:55:39 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 490290, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA1, Tue Jul 12 17:09:41 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Git", "1.7.1", "9.el6_9", "noarch", "git-1.7.1-9.el6_9.src.rpm", 35913, "GPLv2", "CentOS", "", "Perl interface to Git", "RSA/SHA1, Thu Aug 17 10:25:23 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 752304, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA1, Mon Mar 16 14:43:08 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-devel", "2.6.32", "754.12.1.el6", "x86_64", "kernel-2.6.32-754.12.1.el6.src.rpm", 27015877, "GPLv2", "CentOS", "", "Development package for building kernel modules to match the kernel", "RSA/SHA1, Tue Apr  9 19:55:40 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.44", "7.el6", "x86_64", "attr-2.4.44-7.el6.src.rpm", 18712, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA1, Mon Sep 26 04:20:08 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-client", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 12275931, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - client", "RSA/SHA1, Wed Jun 20 11:42:32 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 152305, "zlib and Boost", "CentOS", "", "The zlib compression and decompression library", "RSA/SHA1, Sat Feb 23 17:41:52 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gtk2", "2.24.23", "9.el6", "x86_64", "gtk2-2.24.23-9.el6.src.rpm", 12426003, "LGPLv2+", "CentOS", "", "The GIMP ToolKit (GTK+), a library for creating GUIs for X", "RSA/SHA1, Thu Mar 23 15:01:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "7.el6", "x86_64", "popt-1.13-7.el6.src.rpm", 83420, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Sun Jul  3 04:57:35 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-devel", "0.17", "18.el6", "x86_64", "gettext-0.17-18.el6.src.rpm", 635713, "LGPLv2+", "CentOS", "", "Development files for gettext", "RSA/SHA1, Mon Jun  2 11:16:57 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1533095, "Sleepycat and BSD", "CentOS", "", "The Berkeley DB database library (version 4) for C", "RSA/SHA1, Thu Mar 23 15:00:27 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 30373, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system", "RSA/SHA1, Wed Jun 20 11:42:33 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.el6", "x86_64", "nss-util-3.36.0-1.el6.src.rpm", 191928, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA1, Wed Jun 20 11:40:37 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-c++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 11429003, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "C++ support for GCC", "RSA/SHA1, Wed Jun 20 11:35:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 67592, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Jul  6 01:37:18 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool", "2.2.6", "15.5.el6", "x86_64", "libtool-2.2.6-15.5.el6.src.rpm", 1998350, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", "The GNU Portable Library Tool", "RSA/SHA256, Sun Jul  3 04:40:10 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 130336, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA1, Thu May 12 10:46:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patchutils", "0.3.1", "3.1.el6", "x86_64", "patchutils-0.3.1-3.1.el6.src.rpm", 241488, "GPLv2+", "CentOS", "", "A collection of programs for manipulating patch files", "RSA/SHA256, Sun Jul  3 04:54:08 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.1", "10.el6", "x86_64", "sed-4.2.1-10.el6.src.rpm", 542324, "GPLv2+", "CentOS", "", "A GNU stream text editor", "RSA/SHA1, Sun Jun 24 22:20:22 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bison", "2.4.1", "5.el6", "x86_64", "bison-2.4.1-5.el6.src.rpm", 2081518, "GPLv3+", "CentOS", "", "A GNU general-purpose parser generator", "RSA/SHA256, Sun Jul  3 04:05:00 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.18", "2.el6", "x86_64", "libidn-1.18-2.el6.src.rpm", 567612, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Sun Jul  3 04:36:02 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ctags", "5.8", "2.el6", "x86_64", "ctags-5.8-2.el6.src.rpm", 347508, "GPLv2+ or Public Domain", "CentOS", "", "A C programming language indexing and/or cross-reference tool", "RSA/SHA256, Sun Jul  3 04:08:30 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.7.6", "21.el6_8.1", "x86_64", "libxml2-2.7.6-21.el6_8.1.src.rpm", 1779163, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA1, Thu Jun 23 14:20:59 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "swig", "1.3.40", "6.el6", "x86_64", "swig-1.3.40-6.el6.src.rpm", 4290828, "GPLv2+ and LGPLv2+ and BSD", "CentOS", "", "Connects C/C++/Objective C to some high-level programming languages", "RSA/SHA1, Mon Sep 26 04:25:34 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 987096, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA1, Wed Jun 20 11:35:48 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "indent", "2.2.10", "7.el6", "x86_64", "indent-2.2.10-7.el6.src.rpm", 252872, "GPLv3+", "CentOS", "", "A GNU program for formatting C code", "RSA/SHA1, Sun Jun 24 22:20:08 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "4.1.el6", "x86_64", "lua-5.1.4-4.1.el6.src.rpm", 617799, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Jul  3 04:43:34 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "byacc", "1.9.20070509", "7.el6", "x86_64", "byacc-1.9.20070509-7.el6.src.rpm", 87968, "Public Domain", "CentOS", "", "Berkeley Yacc, a parser generator", "RSA/SHA1, Sun Jun 24 22:18:50 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "3.1.7", "10.el6_7.3", "x86_64", "gawk-3.1.7-10.el6_7.3.src.rpm", 2038650, "GPLv3+", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA1, Tue Nov 10 12:38:59 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xml-common", "0.6.3", "33.el6", "noarch", "sgml-common-0.6.3-33.el6.src.rpm", 20624, "GPL+", "CentOS", "", "Common XML catalog and DTD files", "RSA/SHA1, Tue May 27 11:47:04 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 136136, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4-devel", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 25205066, "Sleepycat and BSD", "CentOS", "", "C development files for the Berkeley DB (version 4) library", "RSA/SHA1, Thu Mar 23 14:59:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 1011166, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA1, Thu May 12 10:51:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-Test-Harness", "3.17", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 408795, "GPL+ or Artistic", "CentOS", "", "Run Perl standard test scripts with statistics", "RSA/SHA1, Thu Mar 23 15:00:32 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 1103062, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA1, Tue Jul 12 17:09:40 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-devel", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 1870563, "GPL+ or Artistic", "CentOS", "", "Header files for use in perl development", "RSA/SHA1, Thu Mar 23 15:00:37 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "6.el6", "x86_64", "grep-2.20-6.el6.src.rpm", 1197904, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA1, Thu Mar 23 15:00:30 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sgml-common", "0.6.3", "33.el6", "noarch", "sgml-common-0.6.3-33.el6.src.rpm", 135735, "GPL+", "CentOS", "", "Common SGML catalog and DTD files", "RSA/SHA1, Tue May 27 11:47:04 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.10", "13.el6", "x86_64", "cpio-2.10-13.el6.src.rpm", 650433, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA1, Thu Mar 23 15:02:20 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "docbook-style-xsl", "1.75.2", "6.el6", "noarch", "docbook-style-xsl-1.75.2-6.el6.src.rpm", 16030288, "Copyright only", "CentOS", "", "Norman Walsh's XSL stylesheets for DocBook XML", "RSA/SHA256, Sun Jul  3 04:04:50 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "9.3.el6", "x86_64", "pth-2.0.7-9.3.el6.src.rpm", 261931, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Sun Jul  3 04:57:59 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lynx", "2.8.6", "27.el6", "x86_64", "lynx-2.8.6-27.el6.src.rpm", 4934856, "GPLv2", "CentOS", "", "A text-based Web browser", "RSA/SHA256, Sun Jul  3 04:43:45 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "2.3", "6.el6_5", "x86_64", "libtasn1-2.3-6.el6_5.src.rpm", 443140, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA1, Wed Jun  4 10:02:50 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "asciidoc", "8.4.5", "4.1.el6", "noarch", "asciidoc-8.4.5-4.1.el6.src.rpm", 645180, "GPL+ and GPLv2+", "CentOS", "", "Text based document generation", "RSA/SHA256, Sun Jul  3 03:59:57 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 178775, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA1, Tue Jan 28 09:43:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hmaccalc", "0.9.12", "2.el6", "x86_64", "hmaccalc-0.9.12-2.el6.src.rpm", 86101, "MIT", "CentOS", "", "Tools for computing and checking HMAC values for files", "RSA/SHA1, Fri Oct 17 19:59:50 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnih", "1.0.1", "8.el6", "x86_64", "libnih-1.0.1-8.el6.src.rpm", 490926, "GPLv2", "CentOS", "", "Lightweight application development library", "RSA/SHA1, Wed Jun 20 11:39:43 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfontenc", "1.1.2", "3.el6", "x86_64", "libfontenc-1.1.2-3.el6.src.rpm", 50316, "MIT", "CentOS", "", "X.Org X11 libfontenc runtime library", "RSA/SHA1, Thu May 12 10:48:32 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gmp", "4.3.1", "13.el6", "x86_64", "gmp-4.3.1-13.el6.src.rpm", 657883, "LGPLv2+ and  GPLv3+ and LGPLv3+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA1, Wed Jun 20 11:36:35 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "xorg-x11-font-utils", "7.2", "11.el6", "x86_64", "xorg-x11-font-utils-7.2-11.el6.src.rpm", 300562, "MIT", "CentOS", "", "X.Org X11 font utilities", "RSA/SHA1, Thu Dec  8 21:42:58 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 56567, "BSD", "CentOS", "", "A utility for determining file types", "RSA/SHA1, Thu May 12 10:45:47 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "flac", "1.2.1", "7.el6_6", "x86_64", "flac-1.2.1-7.el6_6.src.rpm", 722062, "BSD and GPLv2+", "CentOS", "", "An encoder/decoder for the Free Lossless Audio Codec", "RSA/SHA1, Tue Mar 31 23:41:37 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "net-tools", "1.60", "114.el6", "x86_64", "net-tools-1.60-114.el6.src.rpm", 778260, "GPL+", "CentOS", "", "Basic networking tools", "RSA/SHA1, Thu Mar 23 15:00:33 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "jpackage-utils", "1.7.5", "3.16.el6", "noarch", "jpackage-utils-1.7.5-3.16.el6.src.rpm", 168662, "BSD", "CentOS", "", "JPackage utilities", "RSA/SHA1, Thu May 12 10:51:44 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "psmisc", "22.6", "24.el6", "x86_64", "psmisc-22.6-24.el6.src.rpm", 222569, "GPLv2+", "CentOS", "", "Utilities for managing processes on your system", "RSA/SHA1, Thu Mar 23 15:03:14 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf-devel", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 26454, "GPLv2+ or LGPLv3+", "CentOS", "", "Development support for libelf", "RSA/SHA1, Thu May 12 10:48:49 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 62739, "Public Domain", "CentOS", "", "SELinux libselinux utilies", "RSA/SHA1, Thu May 12 10:47:15 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 498105, "GPLv2+ or AFL", "CentOS", "", "D-BUS message bus", "RSA/SHA1, Wed Jun 20 11:34:38 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 79087, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Wed Jul  6 01:37:17 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tcp_wrappers-libs", "7.6", "58.el6", "x86_64", "tcp_wrappers-7.6-58.el6.src.rpm", 131475, "BSD", "CentOS", "", "Libraries for tcp_wrappers", "RSA/SHA1, Thu May 12 10:51:24 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ORBit2", "2.14.17", "7.el6", "x86_64", "ORBit2-2.14.17-7.el6.src.rpm", 603232, "LGPLv2+ and GPLv2+", "CentOS", "", "A high-performance CORBA Object Request Broker", "RSA/SHA1, Wed Jun 20 11:40:41 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.23", "15.el6_6.2", "x86_64", "cyrus-sasl-2.1.23-15.el6_6.2.src.rpm", 357710, "BSD", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA1, Wed Mar 25 18:07:46 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lksctp-tools", "1.0.10", "7.el6", "x86_64", "lksctp-tools-1.0.10-7.el6.src.rpm", 210697, "GPLv2 and GPLv2+ and LGPLv2 and BSD", "CentOS", "", "User-space access to Linux Kernel SCTP", "RSA/SHA1, Sun Nov 24 19:32:36 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.81", "23.el6", "x86_64", "make-3.81-23.el6.src.rpm", 1079569, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA1, Thu May 12 10:46:30 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "copy-jdk-configs", "3.3", "9.el6", "noarch", "copy-jdk-configs-3.3-9.el6.src.rpm", 16172, "BSD", "CentOS", "", "JDKs configuration files copier", "RSA/SHA1, Wed Jun 20 11:34:07 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "2.8.1", "28.el6", "x86_64", "diffutils-2.8.1-28.el6.src.rpm", 588813, "GPLv2+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Sun Jul  3 04:10:10 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xorg-x11-fonts-Type1", "7.2", "11.el6", "noarch", "xorg-x11-fonts-7.2-11.el6.src.rpm", 883992, "MIT and Lucida and Public Domain", "CentOS", "", "Type1 fonts provided by the X Window System", "RSA/SHA1, Fri Jul 24 20:36:44 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 386371, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA1, Mon Mar 16 14:43:07 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "polkit", "0.96", "11.el6_10.1", "x86_64", "polkit-0.96-11.el6_10.1.src.rpm", 646341, "LGPLv2+", "CentOS", "", "PolicyKit Authorization Framework", "RSA/SHA1, Tue Feb 26 18:21:14 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "436", "13.el6", "x86_64", "less-436-13.el6.src.rpm", 201909, "GPLv3+", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA1, Mon Jun 16 12:52:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "GConf2", "2.28.0", "7.el6", "x86_64", "GConf2-2.28.0-7.el6.src.rpm", 6076626, "LGPLv2+", "CentOS", "", "A process-transparent configuration system", "RSA/SHA1, Thu Mar 23 14:59:07 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.3.12", "24.el6", "x86_64", "gzip-1.3.12-24.el6.src.rpm", 225924, "GPLv2+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA1, Thu Mar 23 15:00:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pulseaudio-libs", "0.9.21", "26.el6", "x86_64", "pulseaudio-0.9.21-26.el6.src.rpm", 2700180, "LGPLv2+", "CentOS", "", "Libraries for PulseAudio clients", "RSA/SHA1, Thu Mar 23 15:01:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 9327207, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Wed Jul  6 01:37:32 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "java-1.7.0-openjdk-devel", "1.7.0.221", "2.6.18.0.el6_10", "x86_64", "java-1.7.0-openjdk-1.7.0.221-2.6.18.0.el6_10.src.rpm", 37629764, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv1.1 and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", "OpenJDK Development Environment", "RSA/SHA1, Mon Apr 22 20:19:19 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.1", "24.el6", "x86_64", "pam-1.1.1-24.el6.src.rpm", 2419646, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA1, Thu Mar 23 15:01:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils-devel", "2.20.51.0.2", "5.48.el6_10.1", "x86_64", "binutils-2.20.51.0.2-5.48.el6_10.1.src.rpm", 3125929, "GPLv3+", "CentOS", "", "BFD and opcodes static libraries and header files", "RSA/SHA1, Tue Feb 26 17:18:14 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs-devel", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 78382, "LGPLv2+", "CentOS", "", "Header files for libaudit", "RSA/SHA1, Thu Mar 23 15:01:42 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth-scripts", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 11006, "GPLv2+", "CentOS", "", "Plymouth related scripts", "RSA/SHA1, Thu Mar 23 15:03:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "newt", "0.52.11", "4.el6", "x86_64", "newt-0.52.11-4.el6.src.rpm", 173237, "LGPLv2", "CentOS", "", "A library for text mode user interfaces", "RSA/SHA1, Thu Mar 23 15:01:03 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "65.1.el6", "noarch", "ca-certificates-2018.2.22-65.1.el6.src.rpm", 2675229, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA1, Wed Jun 20 11:33:52 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pciutils-libs", "3.1.10", "4.el6", "x86_64", "pciutils-3.1.10-4.el6.src.rpm", 48992, "GPLv2+", "CentOS", "", "Linux PCI library", "RSA/SHA1, Tue Aug  5 12:39:17 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 32822, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "numactl-devel", "2.0.9", "2.el6", "x86_64", "numactl-2.0.9-2.el6.src.rpm", 98470, "LGPLv2/GPLv2", "CentOS", "", "Development package for building Applications that use numa", "RSA/SHA1, Fri Oct 17 20:02:13 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "ethtool", "3.5", "6.el6", "x86_64", "ethtool-3.5-6.el6.src.rpm", 283910, "GPLv2", "CentOS", "", "Ethernet settings tool for PCI ethernet cards", "RSA/SHA1, Fri Jul 24 20:38:43 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "newt-devel", "0.52.11", "4.el6", "x86_64", "newt-0.52.11-4.el6.src.rpm", 127322, "LGPLv2", "CentOS", "", "Newt windowing toolkit development files", "RSA/SHA1, Thu Mar 23 15:02:27 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.4", "5.el6", "x86_64", "keyutils-1.4-5.el6.src.rpm", 36624, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA1, Fri Oct 17 20:01:07 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-devel", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 1795830, "MIT", "CentOS", "", "Development files for the ncurses library", "RSA/SHA1, Mon Mar 16 14:43:08 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssl", "1.0.1e", "57.el6", "x86_64", "openssl-1.0.1e-57.el6.src.rpm", 4248338, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA1, Thu Mar 23 15:04:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 347536, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA1, Tue Apr  4 16:34:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 357074, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA1, Tue Apr  4 16:34:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.40", "16.el6", "x86_64", "openldap-2.4.40-16.el6.src.rpm", 859518, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA1, Thu Mar 23 14:58:56 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.1.8", "3.el6", "x86_64", "gpgme-1.1.8-3.el6.src.rpm", 729658, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Sun Jul  3 04:19:20 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "9.1.el6", "x86_64", "ustr-1.0.4-9.1.el6.src.rpm", 273983, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Sun Jul  3 05:04:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "5.el6", "x86_64", "shadow-utils-4.1.5.1-5.el6.src.rpm", 3466724, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA1, Thu May 12 10:48:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "MAKEDEV", "3.24", "6.el6", "x86_64", "MAKEDEV-3.24-6.el6.src.rpm", 227290, "GPLv2", "CentOS", "", "A program used for creating device files in /dev", "RSA/SHA256, Sun Jul  3 04:44:39 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 48770, "GPLv2+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA1, Thu May 12 10:46:07 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 79603, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA1, Thu Aug 18 17:21:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 120906, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "9.el6", "x86_64", "python-pycurl-7.19.0-9.el6.src.rpm", 236939, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA1, Thu May 12 10:47:30 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.3.1", "2.1.el6", "noarch", "python-iniparse-0.3.1-2.1.el6.src.rpm", 109284, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Sun Jul  3 04:42:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gamin", "0.1.10", "9.el6", "x86_64", "gamin-0.1.10-9.el6.src.rpm", 416440, "LGPLv2", "CentOS", "", "Library providing the FAM File Alteration Monitor API", "RSA/SHA256, Sun Jul  3 04:15:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "0.70", "6.el6", "x86_64", "shared-mime-info-0.70-6.el6.src.rpm", 1411396, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA1, Tue May 27 11:48:01 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.56.13", "8.el6_7", "x86_64", "libuser-0.56.13-8.el6_7.src.rpm", 1882055, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA1, Sat Jul 25 16:02:31 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 53961, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA1, Thu Aug  9 15:06:22 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "6", "10.el6.centos.12.3", "x86_64", "centos-release-6-10.el6.centos.12.3.src.rpm", 38232, "GPLv2", "CentOS", "", "CentOS release file", "RSA/SHA1, Tue Jun 26 15:35:30 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 22350, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA1, Thu Aug  9 15:06:21 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "6.1.el6", "noarch", "rootfiles-8.1-6.1.el6.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Sun Jul  3 04:45:28 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 13117447, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA1, Tue Apr  9 19:55:39 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "freetype", "2.3.11", "17.el6", "x86_64", "freetype-2.3.11-17.el6.src.rpm", 836907, "FTL or GPLv2+", "CentOS", "", "A free and portable font rendering engine", "RSA/SHA1, Thu May 12 10:50:28 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libjpeg-turbo", "1.2.1", "3.el6_5", "x86_64", "libjpeg-turbo-1.2.1-3.el6_5.src.rpm", 476782, "wxWidgets", "CentOS", "", "A MMX/SSE2 accelerated library for manipulating JPEG image files", "RSA/SHA1, Tue Dec 10 01:01:18 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy-python", "0.3.0", "10.el6", "x86_64", "libproxy-0.3.0-10.el6.src.rpm", 8320, "LGPLv2+", "CentOS", "", "Binding for libproxy and python", "RSA/SHA1, Sat Oct 18 00:47:36 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m4", "1.4.13", "5.el6", "x86_64", "m4-1.4.13-5.el6.src.rpm", 560949, "GPLv3+", "CentOS", "", "The GNU macro processor", "RSA/SHA256, Sun Jul  3 04:44:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 648199, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA1, Thu May 12 10:51:01 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "avahi-libs", "0.6.25", "17.el6", "x86_64", "avahi-0.6.25-17.el6.src.rpm", 114824, "LGPLv2", "CentOS", "", "Libraries for avahi run-time use", "RSA/SHA1, Thu Mar 23 15:01:20 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "2.12.23", "22.el6", "x86_64", "gnutls-2.12.23-22.el6.src.rpm", 1167530, "GPLv3+ and LGPLv2+", "CentOS", "", "A TLS protocol implementation", "RSA/SHA1, Wed Jun 20 11:36:41 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 488160, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.20.51.0.2", "5.48.el6_10.1", "x86_64", "binutils-2.20.51.0.2-5.48.el6_10.1.src.rpm", 9831328, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA1, Tue Feb 26 17:18:14 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "5.el6", "x86_64", "unzip-6.0-5.el6.src.rpm", 331766, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA1, Thu Mar 23 15:02:42 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 127982, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GCC OpenMP v3.0 shared support library", "RSA/SHA1, Wed Jun 20 11:35:44 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patch", "2.6", "8.el6_9", "x86_64", "patch-2.6-8.el6_9.src.rpm", 179790, "GPLv2+", "CentOS", "", "Utility for modifying/upgrading files", "RSA/SHA1, Wed May  2 12:03:44 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpciaccess", "0.13.4", "1.el6", "x86_64", "libpciaccess-0.13.4-1.el6.src.rpm", 40777, "MIT", "CentOS", "", "PCI access library", "RSA/SHA1, Thu May 12 10:47:57 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util", "1.3.9", "3.el6_0.1", "x86_64", "apr-util-1.3.9-3.el6_0.1.src.rpm", 202360, "ASL 2.0", "CentOS", "", "Apache Portable Runtime Utility library", "RSA/SHA256, Wed Jul  6 01:37:03 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "cups-libs", "1.4.2", "81.el6_10", "x86_64", "cups-1.4.2-81.el6_10.src.rpm", 667768, "LGPLv2", "CentOS", "", "Common Unix Printing System - libraries", "RSA/SHA1, Tue Apr  9 19:55:40 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpp", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 10012603, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "The C Preprocessor", "RSA/SHA1, Wed Jun 20 11:35:48 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pakchois", "0.4", "3.2.el6", "x86_64", "pakchois-0.4-3.2.el6.src.rpm", 50156, "LGPLv2+", "CentOS", "", "A wrapper library for PKCS#11", "RSA/SHA256, Sun Jul  3 04:53:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.86", "6.el6", "x86_64", "dbus-glib-0.86-6.el6.src.rpm", 579611, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA1, Wed Feb 27 10:59:02 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-runtime", "2.9", "9.el6", "x86_64", "systemtap-2.9-9.el6.src.rpm", 616098, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - runtime", "RSA/SHA1, Wed Jun 20 11:42:34 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck-lib", "1.2.0", "7.el6", "x86_64", "fipscheck-1.2.0-7.el6.src.rpm", 10353, "BSD", "CentOS", "", "Library files for fipscheck", "RSA/SHA1, Thu Dec  8 19:58:46 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pixman", "0.32.8", "1.el6", "x86_64", "pixman-0.32.8-1.el6.src.rpm", 721560, "MIT", "CentOS", "", "Pixel manipulation library", "RSA/SHA1, Thu May 12 10:45:42 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 1485896, "GPL+ or Artistic", "CentOS", "", "The libraries for the perl runtime", "RSA/SHA1, Thu Mar 23 15:04:17 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Module-Pluggable", "3.90", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 31033, "GPL+ or Artistic", "CentOS", "", "Automatically give your module the ability to have plugins", "RSA/SHA1, Thu Mar 23 15:02:55 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl", "5.10.1", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 35282834, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", "Practical Extraction and Report Language", "RSA/SHA1, Thu Mar 23 14:59:46 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Error", "0.17015", "4.el6", "noarch", "perl-Error-0.17015-4.el6.src.rpm", 47372, "GPL+ or Artistic", "CentOS", "", "Error/exception handling in an OO-ish way", "RSA/SHA256, Sun Jul  3 04:37:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "automake", "1.11.1", "4.el6", "noarch", "automake-1.11.1-4.el6.src.rpm", 1520636, "GPLv2+ and GFDL", "CentOS", "", "A GNU tool for automatically creating Makefiles", "RSA/SHA1, Sat Feb 23 17:50:34 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-IO-Compress-Base", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 138661, "GPL+ or Artistic", "CentOS", "", "Base Class for IO::Compress modules", "RSA/SHA1, Thu Mar 23 15:02:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-Compress-Zlib", "2.021", "144.el6", "x86_64", "perl-5.10.1-144.el6.src.rpm", 52519, "GPL+ or Artistic", "CentOS", "", "A module providing Perl interfaces to the zlib compression library", "RSA/SHA1, Thu Mar 23 14:59:19 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTML-Tagset", "3.20", "4.el6", "noarch", "perl-HTML-Tagset-3.20-4.el6.src.rpm", 19692, "GPL+ or Artistic", "CentOS", "", "HTML::Tagset - data tables useful in parsing HTML", "RSA/SHA256, Sun Jul  3 04:37:57 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cvs", "1.11.23", "16.el6", "x86_64", "cvs-1.11.23-16.el6.src.rpm", 1590583, "GPL+ and GPLv2+ and LGPL+", "CentOS", "", "A version control system", "RSA/SHA1, Sun Nov 24 19:31:18 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXau", "1.0.6", "4.el6", "x86_64", "libXau-1.0.6-4.el6.src.rpm", 40009, "MIT", "CentOS", "", "Sample Authorization Protocol for X", "RSA/SHA1, Sat Feb 23 17:40:25 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "upstart", "0.6.5", "17.el6", "x86_64", "upstart-0.6.5-17.el6.src.rpm", 567729, "GPLv2 and LGPLv2+", "CentOS", "", "An event-driven init system", "RSA/SHA1, Wed Jun 20 11:42:38 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cloog-ppl", "0.15.7", "1.2.el6", "x86_64", "cloog-0.15.7-1.2.el6.src.rpm", 185386, "GPLv2+", "CentOS", "", "Parma Polyhedra Library backend (ppl) based version of the Cloog binaries", "RSA/SHA256, Sun Jul  3 04:07:02 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb", "7.2", "92.el6", "x86_64", "gdb-7.2-92.el6.src.rpm", 5545845, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and GFDL and BSD and Public Domain", "CentOS", "", "A GNU source-level debugger for C, C++, Java and other languages", "RSA/SHA1, Thu Mar 23 15:02:13 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libthai", "0.1.12", "3.el6", "x86_64", "libthai-0.1.12-3.el6.src.rpm", 694712, "LGPLv2+", "CentOS", "", "Thai language support routines", "RSA/SHA256, Sun Jul  3 04:39:56 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libedit", "2.11", "4.20080712cvs.1.el6", "x86_64", "libedit-2.11-4.20080712cvs.1.el6.src.rpm", 185648, "BSD", "CentOS", "", "The NetBSD Editline library", "RSA/SHA256, Sun Jul  3 04:33:24 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-headers", "2.12", "1.212.el6_10.3", "x86_64", "glibc-2.12-1.212.el6_10.3.src.rpm", 2146171, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Header files for development using standard C libraries.", "RSA/SHA1, Tue Apr  9 19:55:40 2019, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 19499265, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "Various compilers (C, C++, Objective-C, Java, ...)", "RSA/SHA1, Wed Jun 20 11:35:44 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11-common", "1.6.4", "3.el6", "noarch", "libX11-1.6.4-3.el6.src.rpm", 1341368, "MIT", "CentOS", "", "Common data for libX11", "RSA/SHA1, Thu Mar 23 14:59:33 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrender", "0.9.10", "1.el6", "x86_64", "libXrender-0.9.10-1.el6.src.rpm", 40515, "MIT", "CentOS", "", "X.Org X11 libXrender runtime library", "RSA/SHA1, Thu Mar 23 15:02:17 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cairo", "1.8.8", "6.el6_6", "x86_64", "cairo-1.8.8-6.el6_6.src.rpm", 797873, "LGPLv2 or MPLv1.1", "CentOS", "", "A 2D graphics library", "RSA/SHA1, Mon Jun 22 15:01:35 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrandr", "1.5.1", "1.el6", "x86_64", "libXrandr-1.5.1-1.el6.src.rpm", 43834, "MIT", "CentOS", "", "X.Org X11 libXrandr runtime library", "RSA/SHA1, Thu Mar 23 15:02:06 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdk-pixbuf2", "2.24.1", "6.el6_7", "x86_64", "gdk-pixbuf2-2.24.1-6.el6_7.src.rpm", 2637837, "LGPLv2+ and (LGPLv2+ or MPLv1.1) and Public Domain", "CentOS", "", "An image loading library", "RSA/SHA1, Mon Aug 31 16:41:21 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXdamage", "1.1.3", "4.el6", "x86_64", "libXdamage-1.1.3-4.el6.src.rpm", 24896, "MIT", "CentOS", "", "X Damage extension library", "RSA/SHA1, Sat Feb 23 17:40:50 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXinerama", "1.1.3", "2.1.el6", "x86_64", "libXinerama-1.1.3-2.1.el6.src.rpm", 12039, "MIT", "CentOS", "", "X.Org X11 libXinerama runtime library", "RSA/SHA1, Fri Oct 17 20:01:27 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pango", "1.28.1", "11.el6", "x86_64", "pango-1.28.1-11.el6.src.rpm", 1041857, "LGPLv2+", "CentOS", "", "System for layout and rendering of internationalized text", "RSA/SHA1, Thu Feb  4 21:37:46 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mailcap", "2.1.31", "2.el6", "noarch", "mailcap-2.1.31-2.el6.src.rpm", 52877, "Public Domain and MIT", "CentOS", "", "Helper application and MIME type associations for file types", "RSA/SHA1, Mon Sep 26 04:12:20 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-XML-Parser", "2.36", "7.el6", "x86_64", "perl-XML-Parser-2.36-7.el6.src.rpm", 652307, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing XML files", "RSA/SHA256, Sun Jul  3 04:56:39 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils", "2.0.83", "30.1.el6_8", "x86_64", "policycoreutils-2.0.83-30.1.el6_8.src.rpm", 3596110, "GPLv2+", "CentOS", "", "SELinux policy core utilities", "RSA/SHA1, Sat Nov 19 11:15:26 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:6 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\"\, \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", nil\},\n" | sed "s/(none)/0/g"
	CentOS6Plain = []*PackageInfo{
		{intRef(), "setup", "2.8.14", "23.el6", "noarch", "setup-2.8.14-23.el6.src.rpm", 666669, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA1, Thu Mar 23 15:02:51 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "4.el6", "noarch", "basesystem-10.0-4.el6.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple Red Hat Enterprise Linux system", "RSA/SHA256, Sun Jul  3 04:00:48 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018e", "3.el6", "noarch", "tzdata-2018e-3.el6.src.rpm", 1961609, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA1, Wed May  9 22:47:10 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.12", "1.212.el6", "x86_64", "glibc-2.12-1.212.el6.src.rpm", 112436133, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA1, Wed Jun 20 11:36:27 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.12", "1.212.el6", "x86_64", "glibc-2.12-1.212.el6.src.rpm", 13117447, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA1, Wed Jun 20 11:36:27 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.1.2", "48.el6", "x86_64", "bash-4.1.2-48.el6.src.rpm", 3142529, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA1, Thu Mar 23 14:59:39 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.16", "5.5.el6", "x86_64", "libcap-2.16-5.5.el6.src.rpm", 64437, "LGPLv2+ or BSD", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA1, Thu Dec  8 20:15:52 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "4.13a", "8.el6", "x86_64", "texinfo-4.13a-8.el6.src.rpm", 329482, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Sun Jul  3 04:24:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.49", "7.el6_9.1", "x86_64", "acl-2.2.49-7.el6_9.1.src.rpm", 31280, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA1, Wed Aug 23 18:02:40 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el6", "x86_64", "nspr-4.19.0-1.el6.src.rpm", 281968, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA1, Wed Jun 20 11:40:25 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.41.12", "24.el6", "x86_64", "e2fsprogs-1.41.12-24.el6.src.rpm", 59233, "MIT", "CentOS", "", "Common error description library", "RSA/SHA1, Wed Jun 20 11:35:17 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.0.41", "4.el6", "x86_64", "libsepol-2.0.41-4.el6.src.rpm", 248680, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA1, Thu Dec  8 20:24:54 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.3.49.5", "1.el6", "x86_64", "chkconfig-1.3.49.5-1.el6.src.rpm", 670580, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA1, Thu May 12 10:46:23 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.4.5", "6.el6", "x86_64", "audit-2.4.5-6.el6.src.rpm", 235282, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA1, Thu Mar 23 14:59:31 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.0", "4.el6", "x86_64", "readline-6.0-4.el6.src.rpm", 433957, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA1, Sun Jun 24 22:18:23 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 2486624, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA1, Thu May 12 10:46:22 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.2.24", "9.el6", "x86_64", "dbus-1.2.24-9.el6.src.rpm", 265736, "GPLv2+ or AFL", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA1, Wed Jun 20 11:34:38 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.6.20", "1.el6_7.2", "x86_64", "sqlite-3.6.20-1.el6_7.2.src.rpm", 640060, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA1, Mon Aug 17 15:29:10 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 16304, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "4.999.9", "0.5.beta.20091007git.el6", "x86_64", "xz-4.999.9-0.5.beta.20091007git.el6.src.rpm", 214490, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA1, Thu Jun 19 11:21:06 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.7", "4.el6", "x86_64", "libgpg-error-1.7-4.el6.src.rpm", 214321, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA1, Thu Dec  8 20:17:43 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "7.8", "7.el6", "x86_64", "pcre-7.8-7.el6.src.rpm", 529027, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA1, Fri Jul 24 20:42:33 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.4.2", "9.el6", "x86_64", "findutils-4.4.2-9.el6.src.rpm", 1442912, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA1, Tue Mar  1 13:06:19 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.0.1", "13.el6_8", "x86_64", "expat-2.0.1-13.el6_8.src.rpm", 197794, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA1, Mon Nov 28 22:28:33 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 262669, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA1, Tue Jan 28 09:43:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.4.5", "12.el6_8", "x86_64", "libgcrypt-1.4.5-12.el6_8.src.rpm", 536622, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA1, Sat Nov 12 06:30:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libusb", "0.1.12", "23.el6", "x86_64", "libusb-0.1.12-23.el6.src.rpm", 54440, "LGPLv2+", "CentOS", "", "A library which allows userspace access to USB devices", "RSA/SHA256, Sun Jul  3 04:40:22 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.7.6", "8.el6", "x86_64", "pinentry-0.7.6-8.el6.src.rpm", 147023, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA1, Mon Mar 30 13:24:38 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps", "3.2.8", "45.el6_9.3", "x86_64", "procps-3.2.8-45.el6_9.3.src.rpm", 475526, "GPLv2+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA1, Fri Jun  1 15:12:06 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.23", "15.el6_8", "x86_64", "tar-1.23-15.el6_8.src.rpm", 2616465, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA1, Tue Jul 12 17:11:45 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "checkpolicy", "2.0.22", "1.el6", "x86_64", "checkpolicy-2.0.22-1.el6.src.rpm", 870239, "GPLv2", "CentOS", "", "SELinux policy compiler", "RSA/SHA256, Sun Jul  3 04:06:47 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4-utils", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 416398, "Sleepycat and BSD", "CentOS", "", "Command line tools for managing Berkeley DB (version 4) databases", "RSA/SHA1, Thu Mar 23 15:01:47 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.20.51.0.2", "5.48.el6", "x86_64", "binutils-2.20.51.0.2-5.48.el6.src.rpm", 9831289, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA1, Wed Jun 20 11:33:48 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "which", "2.19", "6.el6", "x86_64", "which-2.19-6.el6.src.rpm", 73004, "GPLv3", "CentOS", "", "Displays where a particular program in your path is located", "RSA/SHA1, Mon Sep 26 04:26:13 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dash", "0.5.5.1", "4.el6", "x86_64", "dash-0.5.5.1-4.el6.src.rpm", 127277, "BSD", "CentOS", "", "Small and fast POSIX-compliant shell", "RSA/SHA1, Wed Oct 17 10:45:23 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff", "1.18.1.4", "21.el6", "x86_64", "groff-1.18.1.4-21.el6.src.rpm", 5318766, "GPLv2 and GFDL", "CentOS", "", "A document formatting system", "RSA/SHA256, Sun Jul  3 04:19:43 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-libs", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 5576, "GPLv3+", "CentOS", "", "Libraries for coreutils", "RSA/SHA1, Wed Jun 20 11:34:12 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 187265, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Wed Jul  6 01:37:30 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.4", "47.el6", "x86_64", "coreutils-8.4-47.el6.src.rpm", 12873065, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA1, Wed Jun 20 11:34:12 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "module-init-tools", "3.9", "26.el6", "x86_64", "module-init-tools-3.9-26.el6.src.rpm", 1216834, "GPLv2+", "CentOS", "", "Kernel module management utilities.", "RSA/SHA1, Thu Mar 23 15:00:22 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2660886, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 2052883, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mingetty", "1.08", "5.el6", "x86_64", "mingetty-1.08-5.el6.src.rpm", 34586, "GPLv2+", "CentOS", "", "A compact getty program for virtual consoles only", "RSA/SHA1, Mon Sep 26 04:21:55 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.10.3", "65.el6", "x86_64", "krb5-1.10.3-65.el6.src.rpm", 1813468, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA1, Thu Mar 23 15:01:43 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.2", "2.el6_7.1", "x86_64", "libssh2-1.4.2-2.el6_7.1.src.rpm", 325165, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA1, Thu Mar 10 12:04:29 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 777656, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 2034245, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.14", "9.el6_10", "x86_64", "gnupg2-2.0.14-9.el6_10.src.rpm", 6087540, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA1, Fri Jul 13 16:08:36 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-libs", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 2340720, "ISC", "CentOS", "", "Libraries used by the BIND DNS packages", "RSA/SHA1, Tue Aug 28 15:39:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.0.43", "5.1.el6", "x86_64", "libsemanage-2.0.43-5.1.el6.src.rpm", 204223, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA1, Fri Jul 24 20:40:14 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.5", "4.1.el6", "x86_64", "libutempter-1.1.5-4.1.el6.src.rpm", 40785, "LGPLv2", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Sun Jul  3 04:40:33 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth-core-libs", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 177760, "GPLv2+", "CentOS", "", "Plymouth libraries", "RSA/SHA1, Thu Mar 23 14:59:05 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.5", "3.2.el6", "x86_64", "libffi-3.0.5-3.2.el6.src.rpm", 42881, "BSD", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Jul  3 04:33:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 22979382, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA1, Thu Aug 18 17:21:24 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.1", "18.20090824bzr68.el6", "x86_64", "pygpgme-0.1-18.20090824bzr68.el6.src.rpm", 251432, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Sun Jul  3 04:58:12 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.9.1", "11.el6", "noarch", "python-urlgrabber-3.9.1-11.el6.src.rpm", 323137, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA1, Thu May 12 10:50:34 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.23", "9.1.el6", "x86_64", "pkgconfig-0.23-9.1.el6.src.rpm", 140091, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Sun Jul  3 04:57:05 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.28.8", "10.el6", "x86_64", "glib2-2.28.8-10.el6.src.rpm", 8061476, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA1, Wed Jun 20 11:36:18 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.2", "16.el6", "x86_64", "yum-metadata-parser-1.1.2-16.el6.src.rpm", 58327, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA1, Mon Sep 26 04:26:27 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.2.29", "81.el6.centos", "noarch", "yum-3.2.29-81.el6.centos.src.rpm", 4832194, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA1, Thu Mar 23 15:04:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.77", "7.el6", "x86_64", "passwd-0.77-7.el6.src.rpm", 357699, "BSD or GPLv2+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA1, Wed Dec  2 14:02:45 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-utils", "9.8.2", "0.68.rc1.el6_10.1", "x86_64", "bind-9.8.2-0.68.rc1.el6_10.1.src.rpm", 451000, "ISC", "CentOS", "", "Utilities for querying DNS name servers", "RSA/SHA1, Tue Aug 28 15:39:45 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.629", "5.el6_8.1", "x86_64", "vim-7.4.629-5.el6_8.1.src.rpm", 909230, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA1, Wed Dec 21 17:40:06 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 117352, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GCC version 4.4 shared support library", "RSA/SHA1, Wed Jun 20 11:35:46 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "2.4.30", "3.el6", "x86_64", "filesystem-2.4.30-3.el6.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA1, Mon Sep 26 04:18:23 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 193090, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA1, Mon Mar 16 14:43:09 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 490290, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA1, Tue Jul 12 17:09:41 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 752304, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA1, Mon Mar 16 14:43:08 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.44", "7.el6", "x86_64", "attr-2.4.44-7.el6.src.rpm", 18712, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA1, Mon Sep 26 04:20:08 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.3", "29.el6", "x86_64", "zlib-1.2.3-29.el6.src.rpm", 152305, "zlib and Boost", "CentOS", "", "The zlib compression and decompression library", "RSA/SHA1, Sat Feb 23 17:41:52 2013, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "7.el6", "x86_64", "popt-1.13-7.el6.src.rpm", 83420, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Sun Jul  3 04:57:35 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "db4", "4.7.25", "22.el6", "x86_64", "db4-4.7.25-22.el6.src.rpm", 1533095, "Sleepycat and BSD", "CentOS", "", "The Berkeley DB database library (version 4) for C", "RSA/SHA1, Thu Mar 23 15:00:27 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.el6", "x86_64", "nss-util-3.36.0-1.el6.src.rpm", 191928, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA1, Wed Jun 20 11:40:37 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 67592, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Jul  6 01:37:18 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 130336, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA1, Thu May 12 10:46:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.1", "10.el6", "x86_64", "sed-4.2.1-10.el6.src.rpm", 542324, "GPLv2+", "CentOS", "", "A GNU stream text editor", "RSA/SHA1, Sun Jun 24 22:20:22 2012, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.18", "2.el6", "x86_64", "libidn-1.18-2.el6.src.rpm", 567612, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Sun Jul  3 04:36:02 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.7.6", "21.el6_8.1", "x86_64", "libxml2-2.7.6-21.el6_8.1.src.rpm", 1779163, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA1, Thu Jun 23 14:20:59 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.4.7", "23.el6", "x86_64", "gcc-4.4.7-23.el6.src.rpm", 987096, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA1, Wed Jun 20 11:35:48 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "4.1.el6", "x86_64", "lua-5.1.4-4.1.el6.src.rpm", 617799, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Jul  3 04:43:34 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "3.1.7", "10.el6_7.3", "x86_64", "gawk-3.1.7-10.el6_7.3.src.rpm", 2038650, "GPLv3+", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA1, Tue Nov 10 12:38:59 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.17.2", "12.28.el6_9.2", "x86_64", "util-linux-ng-2.17.2-12.28.el6_9.2.src.rpm", 136136, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA1, Fri Jan 26 15:13:54 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.164", "2.el6", "x86_64", "elfutils-0.164-2.el6.src.rpm", 1011166, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA1, Thu May 12 10:51:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.14.3", "23.3.el6_8", "x86_64", "nss-softokn-3.14.3-23.3.el6_8.src.rpm", 1103062, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA1, Tue Jul 12 17:09:40 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "6.el6", "x86_64", "grep-2.20-6.el6.src.rpm", 1197904, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA1, Thu Mar 23 15:00:30 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.10", "13.el6", "x86_64", "cpio-2.10-13.el6.src.rpm", 650433, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA1, Thu Mar 23 15:02:20 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "9.3.el6", "x86_64", "pth-2.0.7-9.3.el6.src.rpm", 261931, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Sun Jul  3 04:57:59 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "2.3", "6.el6_5", "x86_64", "libtasn1-2.3-6.el6_5.src.rpm", 443140, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA1, Wed Jun  4 10:02:50 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.18.5", "2.el6_5.2", "x86_64", "p11-kit-0.18.5-2.el6_5.2.src.rpm", 178775, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA1, Tue Jan 28 09:43:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnih", "1.0.1", "8.el6", "x86_64", "libnih-1.0.1-8.el6.src.rpm", 490926, "GPLv2", "CentOS", "", "Lightweight application development library", "RSA/SHA1, Wed Jun 20 11:39:43 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gmp", "4.3.1", "13.el6", "x86_64", "gmp-4.3.1-13.el6.src.rpm", 657883, "LGPLv2+ and  GPLv3+ and LGPLv3+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA1, Wed Jun 20 11:36:35 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file", "5.04", "30.el6", "x86_64", "file-5.04-30.el6.src.rpm", 56567, "BSD", "CentOS", "", "A utility for determining file types", "RSA/SHA1, Thu May 12 10:45:47 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "net-tools", "1.60", "114.el6", "x86_64", "net-tools-1.60-114.el6.src.rpm", 778260, "GPL+", "CentOS", "", "Basic networking tools", "RSA/SHA1, Thu Mar 23 15:00:33 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "psmisc", "22.6", "24.el6", "x86_64", "psmisc-22.6-24.el6.src.rpm", 222569, "GPLv2+", "CentOS", "", "Utilities for managing processes on your system", "RSA/SHA1, Thu Mar 23 15:03:14 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "2.0.94", "7.el6", "x86_64", "libselinux-2.0.94-7.el6.src.rpm", 62739, "Public Domain", "CentOS", "", "SELinux libselinux utilies", "RSA/SHA1, Thu May 12 10:47:15 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.5", "7.el6_0", "x86_64", "bzip2-1.0.5-7.el6_0.src.rpm", 79087, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Wed Jul  6 01:37:17 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.23", "15.el6_6.2", "x86_64", "cyrus-sasl-2.1.23-15.el6_6.2.src.rpm", 357710, "BSD", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA1, Wed Mar 25 18:07:46 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.81", "23.el6", "x86_64", "make-3.81-23.el6.src.rpm", 1079569, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA1, Thu May 12 10:46:30 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "2.8.1", "28.el6", "x86_64", "diffutils-2.8.1-28.el6.src.rpm", 588813, "GPLv2+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Sun Jul  3 04:10:10 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.7", "4.20090207.el6", "x86_64", "ncurses-5.7-4.20090207.el6.src.rpm", 386371, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA1, Mon Mar 16 14:43:07 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "436", "13.el6", "x86_64", "less-436-13.el6.src.rpm", 201909, "GPLv3+", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA1, Mon Jun 16 12:52:22 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.3.12", "24.el6", "x86_64", "gzip-1.3.12-24.el6.src.rpm", 225924, "GPLv2+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA1, Thu Mar 23 15:00:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.8.16", "4.el6", "x86_64", "cracklib-2.8.16-4.el6.src.rpm", 9327207, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Wed Jul  6 01:37:32 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.1", "24.el6", "x86_64", "pam-1.1.1-24.el6.src.rpm", 2419646, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA1, Thu Mar 23 15:01:04 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "plymouth-scripts", "0.8.3", "29.el6.centos", "x86_64", "plymouth-0.8.3-29.el6.centos.src.rpm", 11006, "GPLv2+", "CentOS", "", "Plymouth related scripts", "RSA/SHA1, Thu Mar 23 15:03:48 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "65.1.el6", "noarch", "ca-certificates-2018.2.22-65.1.el6.src.rpm", 2675229, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA1, Wed Jun 20 11:33:52 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "8.el6", "x86_64", "nss-3.36.0-8.el6.src.rpm", 32822, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA1, Wed Jun 20 11:40:31 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "ethtool", "3.5", "6.el6", "x86_64", "ethtool-3.5-6.el6.src.rpm", 283910, "GPLv2", "CentOS", "", "Ethernet settings tool for PCI ethernet cards", "RSA/SHA1, Fri Jul 24 20:38:43 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.4", "5.el6", "x86_64", "keyutils-1.4-5.el6.src.rpm", 36624, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA1, Fri Oct 17 20:01:07 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssl", "1.0.1e", "57.el6", "x86_64", "openssl-1.0.1e-57.el6.src.rpm", 4248338, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA1, Thu Mar 23 15:04:09 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 347536, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA1, Tue Apr  4 16:34:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.19.7", "53.el6_9", "x86_64", "curl-7.19.7-53.el6_9.src.rpm", 357074, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA1, Tue Apr  4 16:34:15 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.40", "16.el6", "x86_64", "openldap-2.4.40-16.el6.src.rpm", 859518, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA1, Thu Mar 23 14:58:56 2017, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.1.8", "3.el6", "x86_64", "gpgme-1.1.8-3.el6.src.rpm", 729658, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Sun Jul  3 04:19:20 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "9.1.el6", "x86_64", "ustr-1.0.4-9.1.el6.src.rpm", 273983, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Sun Jul  3 05:04:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "5.el6", "x86_64", "shadow-utils-4.1.5.1-5.el6.src.rpm", 3466724, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA1, Thu May 12 10:48:16 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "MAKEDEV", "3.24", "6.el6", "x86_64", "MAKEDEV-3.24-6.el6.src.rpm", 227290, "GPLv2", "CentOS", "", "A program used for creating device files in /dev", "RSA/SHA256, Sun Jul  3 04:44:39 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.8.0", "39.el6", "x86_64", "gdbm-1.8.0-39.el6.src.rpm", 48770, "GPLv2+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA1, Thu May 12 10:46:07 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.6.6", "66.el6_8", "x86_64", "python-2.6.6-66.el6_8.src.rpm", 79603, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA1, Thu Aug 18 17:21:25 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.8.0", "59.el6", "x86_64", "rpm-4.8.0-59.el6.src.rpm", 120906, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA1, Wed Jun 20 11:41:13 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "9.el6", "x86_64", "python-pycurl-7.19.0-9.el6.src.rpm", 236939, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA1, Thu May 12 10:47:30 2016, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.3.1", "2.1.el6", "noarch", "python-iniparse-0.3.1-2.1.el6.src.rpm", 109284, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Sun Jul  3 04:42:38 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gamin", "0.1.10", "9.el6", "x86_64", "gamin-0.1.10-9.el6.src.rpm", 416440, "LGPLv2", "CentOS", "", "Library providing the FAM File Alteration Monitor API", "RSA/SHA256, Sun Jul  3 04:15:37 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "0.70", "6.el6", "x86_64", "shared-mime-info-0.70-6.el6.src.rpm", 1411396, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA1, Tue May 27 11:48:01 2014, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.56.13", "8.el6_7", "x86_64", "libuser-0.56.13-8.el6_7.src.rpm", 1882055, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA1, Sat Jul 25 16:02:31 2015, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 53961, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA1, Thu Aug  9 15:06:22 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "6", "10.el6.centos.12.3", "x86_64", "centos-release-6-10.el6.centos.12.3.src.rpm", 38232, "GPLv2", "CentOS", "", "CentOS release file", "RSA/SHA1, Tue Jun 26 15:35:30 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.30", "42.el6_10", "noarch", "yum-utils-1.1.30-42.el6_10.src.rpm", 22350, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA1, Thu Aug  9 15:06:21 2018, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "6.1.el6", "noarch", "rootfiles-8.1-6.1.el6.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Sun Jul  3 04:45:28 2011, Key ID 0946fca2c105b9de", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:7 bash
	// yum groupinstall -y "Development tools"
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS7DevTools = []*PackageInfo{
		{intRef(), "libproxy", "0.4.11", "11.el7", "x86_64", "libproxy-0.4.11-11.el7.src.rpm", 164014, "LGPLv2+", "CentOS", "", "A library handling all the details of proxy configuration", "RSA/SHA256, Wed Apr 25 11:17:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018e", "3.el7", "noarch", "tzdata-2018e-3.el7.src.rpm", 1966505, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA256, Thu May 10 01:44:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "3.3.29", "9.el7_6", "x86_64", "gnutls-3.3.29-9.el7_6.src.rpm", 2097819, "GPLv3+ and LGPLv2+", "CentOS", "", "A TLS protocol implementation", "RSA/SHA256, Tue Mar 19 19:51:33 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA256, Thu May 17 13:25:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA256, Sun Nov 20 19:23:44 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA256, Thu Sep  7 12:43:10 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh-clients", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 2651616, "BSD", "CentOS", "", "An open source SSH client applications", "RSA/SHA256, Wed Apr 25 11:32:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git", "1.8.3.1", "20.el7", "x86_64", "git-1.8.3.1-20.el7.src.rpm", 23232282, "GPLv2", "CentOS", "", "Fast Version Control System", "RSA/SHA256, Tue Nov 20 20:34:29 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA256, Wed Apr 25 10:59:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "neon", "0.30.0", "3.el7", "x86_64", "neon-0.30.0-3.el7.src.rpm", 567772, "LGPLv2+", "CentOS", "", "An HTTP and WebDAV client library", "RSA/SHA256, Fri Jul  4 03:54:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 83791, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Wed Nov 25 14:18:37 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA256, Thu May 17 13:25:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mokutil", "15", "2.el7.centos", "x86_64", "shim-signed-15-2.el7.centos.src.rpm", 83521, "BSD", "CentOS", "", "Utilities for managing Secure Boot/MoK keys.", "RSA/SHA256, Mon Feb 25 15:48:16 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Fri Jul  4 04:33:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "emacs-filesystem", "24.3", "22.el7", "noarch", "emacs-24.3-22.el7.src.rpm", 0, "GPLv3+", "CentOS", "", "Emacs filesystem layout", "RSA/SHA256, Mon Nov 12 15:16:01 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Nov 20 18:39:28 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-headers", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 2338328, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Header files for development using standard C libraries.", "RSA/SHA256, Tue Apr  9 20:22:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Thu Aug 10 17:02:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 39238921, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Various compilers (C, C++, Objective-C, Java, ...)", "RSA/SHA256, Tue Mar 19 19:51:11 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.5", "8.1.el7", "x86_64", "libsepol-2.5-8.1.el7.src.rpm", 686568, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Apr 25 11:22:09 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-devel", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 7910669, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - development headers, tools", "RSA/SHA256, Mon Nov 12 14:47:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA256, Thu Sep  7 12:43:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-rpm-config", "9.1.0", "87.el7.centos", "noarch", "redhat-rpm-config-9.1.0-87.el7.centos.src.rpm", 174572, "GPL+", "CentOS", "", "CentOS specific rpm configuration files", "RSA/SHA256, Mon Nov 12 15:19:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA256, Thu Jun 29 12:40:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-devel", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1492653, "LGPLv2+ and GPLv3+", "CentOS", "", "Development files for gettext", "RSA/SHA256, Thu Aug 10 16:07:56 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.5", "12.el7", "x86_64", "libselinux-2.5-12.el7.src.rpm", 217874, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA256, Thu Apr 26 12:47:14 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 328409, "GPLv2+", "CentOS", "", "Scripts and executable programs used to build packages", "RSA/SHA256, Mon Nov 12 14:45:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA256, Thu Aug 10 16:26:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-gfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 16443248, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Fortran support", "RSA/SHA256, Tue Mar 19 19:51:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA256, Fri Jul  4 02:30:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-c++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 17257523, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "C++ support for GCC", "RSA/SHA256, Tue Mar 19 19:51:13 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", "Main loop abstraction library", "RSA/SHA256, Fri Jul  4 03:23:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subversion", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 4844082, "ASL 2.0", "CentOS", "", "A Modern Concurrent Version Control System", "RSA/SHA256, Wed Apr 25 11:47:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA256, Thu Aug 10 18:44:50 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "flex", "2.5.37", "6.el7", "x86_64", "flex-2.5.37-6.el7.src.rpm", 757468, "BSD and LGPLv2+", "CentOS", "", "A tool for creating scanners (text pattern recognizers)", "RSA/SHA256, Mon Nov 12 14:25:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.0.2k", "12.el7", "x86_64", "openssl-1.0.2k-12.el7.src.rpm", 3200172, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Wed Apr 25 11:33:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA256, Mon Nov 12 14:45:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "7", "5.1804.4.el7.centos", "x86_64", "centos-release-7-5.1804.4.el7.centos.src.rpm", 40338, "GPLv2", "CentOS", "", "CentOS Linux release file", "RSA/SHA256, Mon Aug 13 15:10:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "doxygen", "1.8.5", "3.el7", "x86_64", "doxygen-1.8.5-3.el7.src.rpm", 15389684, "GPL+", "CentOS", "", "A documentation system for C/C++", "RSA/SHA256, Fri Jul  4 01:09:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Sun Nov 20 21:02:51 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffstat", "1.57", "4.el7", "x86_64", "diffstat-1.57-4.el7.src.rpm", 54065, "MIT", "CentOS", "", "A utility which provides statistics based on the output of diff", "RSA/SHA256, Fri Jul  4 01:08:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Apr 25 11:12:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "byacc", "1.9.20130304", "3.el7", "x86_64", "byacc-1.9.20130304-3.el7.src.rpm", 135161, "Public Domain", "CentOS", "", "Berkeley Yacc, a parser generator", "RSA/SHA256, Fri Jul  4 00:54:37 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA256, Fri Jul  4 02:49:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "indent", "2.2.11", "13.el7", "x86_64", "indent-2.2.11-13.el7.src.rpm", 359131, "GPLv3+", "CentOS", "", "A GNU program for formatting C code", "RSA/SHA256, Fri Jul  4 02:06:41 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA256, Thu Aug 10 17:08:59 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Nov 20 19:22:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 20326, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Mon Aug 20 14:15:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 273965, "LGPLv2+", "CentOS", "", "Device mounting library", "RSA/SHA256, Mon Aug 20 14:15:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA256, Wed Apr 25 11:46:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA256, Wed Apr 25 11:04:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.5.11", "5.el7", "x86_64", "findutils-4.5.11-5.el7.src.rpm", 1855626, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Wed Nov 25 14:29:59 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Fri Jul  4 01:08:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA256, Mon Nov 28 22:32:05 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.8.1", "3.el7_5.1", "x86_64", "audit-2.8.1-3.el7_5.1.src.rpm", 256370, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA256, Mon Aug 20 14:14:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Wed Apr 25 11:33:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA256, Thu May 17 13:25:42 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2424993, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA256, Fri Sep 28 11:34:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", "GnuPG IPC library", "RSA/SHA256, Fri Jul  4 02:35:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Fri Jul  4 04:28:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Wed Apr 25 10:56:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.27", "28.base.el7_5.1", "x86_64", "binutils-2.27-28.base.el7_5.1.src.rpm", 25149789, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA256, Tue Jul  3 14:31:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 435192, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA256, Wed Apr 25 11:12:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.44", "15.el7_5", "x86_64", "openldap-2.4.44-15.el7_5.src.rpm", 1037299, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA256, Thu May 17 13:26:00 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA256, Sun Nov 20 20:05:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.5", "11.el7", "x86_64", "libsemanage-2.5-11.el7.src.rpm", 302369, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Apr 25 11:22:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Fri Jul  4 03:23:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", "QR Code encoding library - Shared libraries", "RSA/SHA256, Fri Jul  4 04:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 338922, "GPLv2", "CentOS", "", "Device mapper utility", "RSA/SHA256, Wed Apr 25 10:57:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps-ng", "3.3.10", "17.el7_5.2", "x86_64", "procps-ng-3.3.10-17.el7_5.2.src.rpm", 760500, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA256, Fri May 25 00:56:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 243127, "GPLv2+", "CentOS", "", "Linux kernel module management utilities", "RSA/SHA256, Wed Apr 25 11:10:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 595223, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Wed Apr 25 10:57:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA256, Thu Aug 10 16:47:33 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Fri Jul  4 01:27:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 80907, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA256, Fri Jul 13 15:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", "D-Bus Python Bindings", "RSA/SHA256, Fri Jul  4 01:06:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", "Python bindings for lzma", "RSA/SHA256, Fri Jul  4 04:37:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.10", "8.el7", "noarch", "python-urlgrabber-3.10-8.el7.src.rpm", 500670, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA256, Sun Nov 20 20:18:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", "Extended attributes library wrapper for Python", "RSA/SHA256, Fri Jul  4 04:43:07 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", "Small, useful pieces of code to make python coding easier", "RSA/SHA256, Fri Jul  4 04:39:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA256, Fri Jul 13 15:56:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Fri Jul  4 04:36:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.4.3", "158.el7.centos", "noarch", "yum-3.4.3-158.el7.centos.src.rpm", 5814102, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA256, Wed Apr 25 11:52:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-utils", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 343422, "GPLv2+", "CentOS", "", "Utilities based around the yum package manager", "RSA/SHA256, Thu Aug  2 09:01:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.160", "4.el7", "x86_64", "vim-7.4.160-4.el7.src.rpm", 917640, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA256, Wed Apr 25 11:50:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", "gpg(CentOS-7 Key (CentOS 7 Official Signing Key) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 120497983, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA256, Tue Apr  9 20:22:34 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA256, Tue Mar 19 19:52:58 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA256, Mon Nov 12 14:45:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA256, Mon Nov 12 14:25:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "3.1.1", "4.el7", "x86_64", "mpfr-3.1.1-4.el7.src.rpm", 554279, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Fri Jul  4 03:49:45 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Mon Nov 12 14:45:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck-lib", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 11466, "BSD", "CentOS", "", "Library files for fipscheck", "RSA/SHA256, Thu Aug 10 15:53:57 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", "Apache Portable Runtime library", "RSA/SHA256, Tue Nov 28 22:16:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libquadmath", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 282811, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC __float128 shared support library", "RSA/SHA256, Tue Mar 19 19:52:54 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-system", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 32538, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost system support library", "RSA/SHA256, Thu Aug 10 15:12:51 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA256, Wed Apr 25 11:50:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "avahi-libs", "0.6.31", "19.el7", "x86_64", "avahi-0.6.31-19.el7.src.rpm", 123808, "LGPLv2+", "CentOS", "", "Libraries for avahi run-time use", "RSA/SHA256, Wed Apr 25 10:53:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", "Libraries for gettext", "RSA/SHA256, Thu Aug 10 16:08:05 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", "A JSON implementation in C", "RSA/SHA256, Sat Jul  5 15:25:00 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", "Cryptsetup shared library", "RSA/SHA256, Mon Nov 12 14:23:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", "Establish an ISA relationship with base classes at compile time", "RSA/SHA256, Fri Jul  4 04:21:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", "Format POD source into various output formats", "RSA/SHA256, Fri Jul  4 04:22:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", "Perl module for resolving POD escape sequences", "RSA/SHA256, Thu Jan 24 13:22:34 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", "Character encodings in Perl", "RSA/SHA256, Fri Jul  4 04:17:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", "The libraries for the perl runtime", "RSA/SHA256, Thu Jan 24 13:22:16 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", "Persistence for Perl data structures", "RSA/SHA256, Fri Jul  4 04:23:18 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", "Perl interpreter-based threads", "RSA/SHA256, Fri Jul  4 04:25:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", "Perl source filters", "RSA/SHA256, Fri Jul  4 04:18:19 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", "Perl pragma to declare constants", "RSA/SHA256, Fri Jul  4 04:15:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", "Macros for rpmbuild", "RSA/SHA256, Thu Jan 24 13:22:17 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", "Return name and handle of a temporary file safely", "RSA/SHA256, Fri Jul  4 04:18:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", "PathTools Perl module (Cwd, File::Spec)", "RSA/SHA256, Fri Jul  4 04:22:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA256, Fri Jul  4 04:22:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", "Practical Extraction and Report Language", "RSA/SHA256, Thu Jan 24 13:22:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Error", "0.17020", "2.el7", "noarch", "perl-Error-0.17020-2.el7.src.rpm", 50015, "(GPL+ or Artistic) and MIT", "CentOS", "", "Error/exception handling in an OO-ish way", "RSA/SHA256, Fri Jul  4 04:17:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Data-Dumper", "2.145", "3.el7", "x86_64", "perl-Data-Dumper-2.145-3.el7.src.rpm", 99287, "GPL+ or Artistic", "CentOS", "", "Stringify perl data structures, suitable for printing and eval", "RSA/SHA256, Fri Jul  4 04:16:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-XML-Parser", "2.41", "10.el7", "x86_64", "perl-XML-Parser-2.41-10.el7.src.rpm", 642973, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing XML documents", "RSA/SHA256, Fri Jul  4 04:26:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "automake", "1.13.4", "3.el7", "noarch", "automake-1.13.4-3.el7.src.rpm", 1731909, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", "A GNU tool for automatically creating Makefiles", "RSA/SHA256, Fri Jul  4 00:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "458", "9.el7", "x86_64", "less-458-9.el7.src.rpm", 215376, "GPLv3+", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA256, Thu Jul 30 23:52:46 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1186168, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Fortran runtime", "RSA/SHA256, Tue Mar 19 19:52:13 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 15644861, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "The C Preprocessor", "RSA/SHA256, Tue Mar 19 19:51:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", "systemd libraries", "RSA/SHA256, Wed Feb 20 17:14:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "trousers", "0.3.14", "2.el7", "x86_64", "trousers-0.3.14-2.el7.src.rpm", 836873, "BSD", "CentOS", "", "TCG's Software Stack v1.2", "RSA/SHA256, Thu Aug 10 20:09:49 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-sysv", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 3979, "LGPLv2+", "CentOS", "", "SysV tools for systemd", "RSA/SHA256, Wed Feb 20 17:14:08 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdwarf", "20130207", "4.el7", "x86_64", "libdwarf-20130207-4.el7.src.rpm", 291679, "LGPLv2", "CentOS", "", "Library to access the DWARF Debugging file format", "RSA/SHA256, Sat Mar 14 08:00:51 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-date-time", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 139706, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost date-time library", "RSA/SHA256, Thu Aug 10 15:09:08 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-runtime", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 1142954, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - runtime", "RSA/SHA256, Mon Nov 12 14:47:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmodman", "2.0.1", "8.el7", "x86_64", "libmodman-2.0.1-8.el7.src.rpm", 58871, "LGPLv2+", "CentOS", "", "A simple library for managing C++ modules (plug-ins)", "RSA/SHA256, Fri Jul  4 02:59:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nettle", "2.7.1", "8.el7", "x86_64", "nettle-2.7.1-8.el7.src.rpm", 765042, "LGPLv2+", "CentOS", "", "A low-level cryptographic library", "RSA/SHA256, Sun Nov 20 19:36:42 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA256, Thu Sep  7 12:43:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb", "7.6.1", "114.el7", "x86_64", "gdb-7.6.1-114.el7.src.rpm", 7371507, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and BSD and Public Domain", "CentOS", "", "A GNU source-level debugger for C, C++, Fortran, Go and other languages", "RSA/SHA256, Mon Nov 12 14:25:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.2.46", "30.el7", "x86_64", "bash-4.2.46-30.el7.src.rpm", 3667709, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA256, Wed Apr 25 10:54:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libedit", "3.0", "12.20121213cvs.el7", "x86_64", "libedit-3.0-12.20121213cvs.el7.src.rpm", 244257, "BSD", "CentOS", "", "The NetBSD Editline library", "RSA/SHA256, Fri Jul  4 02:44:30 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Thu Aug 10 15:17:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Git", "1.8.3.1", "20.el7", "noarch", "git-1.8.3.1-20.el7.src.rpm", 58567, "GPLv2", "CentOS", "", "Perl interface to Git", "RSA/SHA256, Tue Nov 20 20:42:15 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.71", "9.el7", "noarch", "setup-2.8.71-9.el7.src.rpm", 696925, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA256, Wed Apr 25 11:46:38 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pakchois", "0.4", "10.el7", "x86_64", "pakchois-0.4-10.el7.src.rpm", 29489, "LGPLv2+", "CentOS", "", "A wrapper library for PKCS#11", "RSA/SHA256, Fri Jul  4 04:11:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple CentOS Linux system", "RSA/SHA256, Fri Jul  4 00:46:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subversion-libs", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 2615823, "ASL 2.0", "CentOS", "", "Libraries for Subversion Version Control system", "RSA/SHA256, Wed Apr 25 11:47:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.7", "17.el7", "x86_64", "zlib-1.2.7-17.el7.src.rpm", 185710, "zlib and Boost", "CentOS", "", "The compression and decompression library", "RSA/SHA256, Sun Nov 20 21:05:07 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "efivar-libs", "36", "11.el7_6.1", "x86_64", "efivar-36-11.el7_6.1.src.rpm", 252096, "LGPLv2+", "CentOS", "", "Library to manage UEFI variables", "RSA/SHA256, Fri Feb  1 16:18:59 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.el7_5", "x86_64", "nss-util-3.36.0-1.el7_5.src.rpm", 194944, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA256, Thu May 17 13:25:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-client", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 10146436, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - client", "RSA/SHA256, Mon Nov 12 14:47:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.42.9", "12.el7_5", "x86_64", "e2fsprogs-1.42.9-12.el7_5.src.rpm", 60489, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Thu May 17 13:22:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-headers", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 3823832, "GPLv2", "CentOS", "", "Header files for the Linux kernel for use by glibc", "RSA/SHA256, Mon Mar 18 15:45:45 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA256, Wed Apr 25 11:11:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-devel", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 1066078, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Object files for development using standard C libraries.", "RSA/SHA256, Tue Apr  9 20:22:35 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA256, Wed Apr 25 11:10:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libquadmath-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 18514, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC __float128 support", "RSA/SHA256, Tue Mar 19 19:52:54 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-srpm-macros", "1", "8.el7", "noarch", "perl-srpm-macros-1-8.el7.src.rpm", 794, "GPLv3+", "CentOS", "", "RPM macros for building Perl source package from source repository", "RSA/SHA256, Fri Jul  4 04:23:16 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Wed Apr 25 11:05:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-common-devel", "0.19.8.1", "2.el7", "noarch", "gettext-0.19.8.1-2.el7.src.rpm", 397912, "GPLv3+", "CentOS", "", "Common development files for gettext", "RSA/SHA256, Thu Aug 10 16:07:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Thu Aug 10 19:04:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "intltool", "0.50.2", "7.el7", "noarch", "intltool-0.50.2-7.el7.src.rpm", 170106, "GPLv2 with exceptions", "CentOS", "", "Utility for internationalizing various kinds of data files", "RSA/SHA256, Thu Aug 10 16:44:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", "A GNU stream text editor", "RSA/SHA256, Fri Jul  4 04:58:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 206577, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system", "RSA/SHA256, Mon Nov 12 14:47:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Thu Aug 10 18:44:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 2323761, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", "The GNU Portable Library Tool", "RSA/SHA256, Thu Apr 13 01:26:19 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA256, Thu Aug 10 16:14:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cscope", "15.8", "10.el7", "x86_64", "cscope-15.8-10.el7.src.rpm", 939744, "BSD and GPLv2+", "CentOS", "", "C source code tree search and browse tool", "RSA/SHA256, Thu Aug 10 15:28:54 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Thu Aug 10 17:58:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patchutils", "0.3.3", "4.el7", "x86_64", "patchutils-0.3.3-4.el7.src.rpm", 260135, "GPLv2+", "CentOS", "", "A collection of programs for manipulating patch files", "RSA/SHA256, Fri Jul  4 04:12:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Thu May 17 13:16:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bison", "3.0.4", "2.el7", "x86_64", "bison-3.0.4-2.el7.src.rpm", 2154174, "GPLv3+", "CentOS", "", "A GNU general-purpose parser generator", "RSA/SHA256, Mon Nov 12 14:22:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.22", "21.el7", "x86_64", "coreutils-8.22-21.el7.src.rpm", 14588989, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Wed Apr 25 10:55:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-sign", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 17397, "GPLv2+", "CentOS", "", "Package signing support", "RSA/SHA256, Mon Nov 12 14:45:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.15.1", "19.el7", "x86_64", "krb5-1.15.1-19.el7.src.rpm", 1984782, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Thu May 10 02:35:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "swig", "2.0.10", "5.el7", "x86_64", "swig-2.0.10-5.el7.src.rpm", 4926232, "GPLv3+ and BSD", "CentOS", "", "Connects C/C++/Objective C to some high-level programming languages", "RSA/SHA256, Sun Nov 20 20:49:25 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Nov 25 14:18:43 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rcs", "5.9.0", "5.el7", "x86_64", "rcs-5.9.0-5.el7.src.rpm", 624710, "GPLv3+", "CentOS", "", "Revision Control System (RCS) file version management tools", "RSA/SHA256, Fri Jul  4 04:47:23 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ctags", "5.8", "13.el7", "x86_64", "ctags-5.8-13.el7.src.rpm", 359724, "GPLv2+ and LGPLv2+ and Public Domain", "CentOS", "", "A C programming language indexing and/or cross-reference tool", "RSA/SHA256, Fri Jul  4 01:03:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA256, Thu Jun 23 20:07:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA256, Thu Aug 10 19:38:52 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA256, Wed Apr 25 10:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 261837, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA256, Mon Aug 20 14:15:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.54.2", "2.el7", "x86_64", "glib2-2.54.2-2.el7.src.rpm", 11986873, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA256, Wed Apr 25 11:01:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA256, Wed Nov 25 15:40:39 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Fri Jul  4 01:02:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Wed Nov 25 14:58:28 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Wed Nov 25 14:52:00 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Fri Jul  4 01:02:17 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", "A library for password generation and password quality checking", "RSA/SHA256, Wed Apr 25 11:17:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 14061, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA256, Fri Sep 28 11:34:18 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-pem", "1.0.3", "4.el7", "x86_64", "nss-pem-1.0.3-4.el7.src.rpm", 201219, "MPLv1.1", "CentOS", "", "PEM file reader for Network Security Services (NSS)", "RSA/SHA256, Thu Aug 10 18:33:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA256, Sun Nov 20 21:02:26 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", "Extremely fast compression algorithm", "RSA/SHA256, Wed Apr 25 11:26:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2069571, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA256, Fri Sep 28 11:34:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.50.0", "1.el7", "x86_64", "gobject-introspection-1.50.0-1.el7.src.rpm", 834149, "GPLv2+, LGPLv2+, MIT", "CentOS", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Thu Aug 10 16:25:03 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Wed Apr 25 11:13:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 91800, "LGPLv2+", "CentOS", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Wed Apr 25 11:10:17 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.3", "10.el7_2.1", "x86_64", "libssh2-1.4.3-10.el7_2.1.src.rpm", 341782, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA256, Thu Mar 10 12:07:48 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 540259, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Wed Apr 25 10:56:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA256, Wed Apr 25 11:23:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.26", "34.el7", "x86_64", "tar-1.26-34.el7.src.rpm", 2838271, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA256, Wed Apr 25 11:48:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", "Access control list utilities", "RSA/SHA256, Wed Apr 25 10:52:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Fri Jul  4 05:39:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "24.el7", "x86_64", "shadow-utils-4.1.5.1-24.el7.src.rpm", 3534490, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Sun Nov 20 20:44:19 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", "Create a tree of hardlinks", "RSA/SHA256, Fri Jul  4 01:53:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 8642769, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA256, Mon Aug 20 14:17:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kpartx", "0.4.9", "119.el7_5.1", "x86_64", "device-mapper-multipath-0.4.9-119.el7_5.1.src.rpm", 41363, "GPL+", "CentOS", "", "Partition device manager for device-mapper devices", "RSA/SHA256, Mon Aug 20 14:15:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper-libs", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 400551, "LGPLv2", "CentOS", "", "Device-mapper shared library", "RSA/SHA256, Wed Apr 25 10:57:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut", "033", "535.el7_5.1", "x86_64", "dracut-033-535.el7_5.1.src.rpm", 898198, "GPLv2+ and LGPLv2+", "CentOS", "", "Initramfs generator using udev", "RSA/SHA256, Mon Aug 20 14:14:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 362584, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA256, Wed Apr 25 10:57:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.170", "4.el7", "noarch", "elfutils-0.170-4.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Wed Apr 25 10:57:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA256, Fri Jul  4 01:06:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 24713084, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA256, Fri Jul 13 15:56:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", "Python bindings for the libxml2 library", "RSA/SHA256, Thu Jun 23 20:08:06 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", "Python 2 bindings for GObject Introspection base package", "RSA/SHA256, Tue Nov 21 14:17:15 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA256, Fri Jul  4 05:53:04 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA256, Sun Nov 20 20:16:57 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Fri Jul  4 04:39:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", "Character encoding auto-detection in Python", "RSA/SHA256, Wed Jul 22 20:25:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", "Utility to set/show the host name or domain name", "RSA/SHA256, Fri Jul  4 01:54:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Wed Nov 25 15:32:05 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Fri Jul  4 01:44:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 53895, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA256, Thu Aug  2 09:00:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-license", "9.9.4", "61.el7_5.1", "noarch", "bind-9.9.4-61.el7_5.1.src.rpm", 26831, "ISC", "CentOS", "", "License of the BIND DNS suite", "RSA/SHA256, Tue Aug 28 12:22:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 22399, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA256, Thu Aug  2 09:00:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA256, Fri Jul  4 04:12:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Fri Jul  4 04:50:28 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC version 4.8 shared support library", "RSA/SHA256, Tue Mar 19 19:52:12 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 14346480, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA256, Tue Apr  9 20:22:27 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA256, Mon Nov 12 14:24:07 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Mon Nov 12 14:45:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA256, Mon Nov 12 14:24:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmpc", "1.0.1", "3.el7", "x86_64", "libmpc-1.0.1-3.el7.src.rpm", 113833, "LGPLv3+ and GFDL", "CentOS", "", "C library for multiple precision complex arithmetic", "RSA/SHA256, Fri Jul  4 02:59:41 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 38839, "BSD", "CentOS", "", "A library for integrity verification of FIPS validated modules", "RSA/SHA256, Thu Aug 10 15:53:42 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC OpenMP v3.0 shared support library", "RSA/SHA256, Tue Mar 19 19:52:30 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m4", "1.4.16", "10.el7", "x86_64", "m4-1.4.16-10.el7.src.rpm", 525707, "GPLv3+", "CentOS", "", "The GNU macro processor", "RSA/SHA256, Wed Nov 25 15:16:04 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", "Apache Portable Runtime Utility library", "RSA/SHA256, Fri Jul  4 00:39:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", "Parts of the groff formatting system required to display manual pages", "RSA/SHA256, Fri Jul  4 01:45:51 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", "GNU Unicode string library", "RSA/SHA256, Fri Jul  4 03:22:35 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", "A CSS2 parsing library", "RSA/SHA256, Mon Nov 12 14:31:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patch", "2.7.1", "10.el7_5", "x86_64", "patch-2.7.1-10.el7_5.src.rpm", 215449, "GPLv3+", "CentOS", "", "Utility for modifying/upgrading files", "RSA/SHA256, Thu May 10 02:36:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zip", "3.0", "11.el7", "x86_64", "zip-3.0-11.el7.src.rpm", 815173, "BSD", "CentOS", "", "A file compression and packaging utility compatible with PKZIP", "RSA/SHA256, Sun Nov 20 21:04:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA256, Thu Aug 10 16:07:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", "Small, simple, correct HTTP/1.1 client", "RSA/SHA256, Fri Jul  4 04:19:08 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", "Look up Perl documentation in Pod format", "RSA/SHA256, Fri Jul  4 04:22:38 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", "Parse text into an array of tokens or array of arrays", "RSA/SHA256, Fri Jul  4 04:25:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", "Print a usage message from embedded POD documentation", "RSA/SHA256, Fri Jul  4 04:22:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", "Networking constants and support functions", "RSA/SHA256, Sun Nov 20 20:02:40 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", "High resolution alarm, sleep, gettimeofday, interval timers", "RSA/SHA256, Fri Jul  4 04:25:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", "Alternative warn and die for modules", "RSA/SHA256, Fri Jul  4 04:15:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", "Implements default import method for modules", "RSA/SHA256, Fri Jul  4 04:17:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", "Efficiently compute time from local and GMT time", "RSA/SHA256, Fri Jul  4 04:25:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", "Perl extension for sharing data structures between threads", "RSA/SHA256, Fri Jul  4 04:25:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", "Create or remove directory trees", "RSA/SHA256, Fri Jul  4 04:18:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", "A selection of general-utility scalar and list subroutines", "RSA/SHA256, Fri Jul  4 04:23:05 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", "Extended processing of command line options", "RSA/SHA256, Wed Apr 25 11:36:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Thread-Queue", "3.02", "2.el7", "noarch", "perl-Thread-Queue-3.02-2.el7.src.rpm", 27642, "GPL+ or Artistic", "CentOS", "", "Thread-safe queues", "RSA/SHA256, Fri Jul  4 04:25:23 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-TermReadKey", "2.30", "20.el7", "x86_64", "perl-TermReadKey-2.30-20.el7.src.rpm", 59999, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", "A perl module for simple terminal control", "RSA/SHA256, Fri Jul  4 04:23:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "autoconf", "2.69", "11.el7", "noarch", "autoconf-2.69-11.el7.src.rpm", 2320371, "GPLv2+ and GFDL", "CentOS", "", "A GNU tool for automatically configuring source code", "RSA/SHA256, Fri Jul  4 00:42:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Test-Harness", "3.28", "3.el7", "noarch", "perl-Test-Harness-3.28-3.el7.src.rpm", 607239, "GPL+ or Artistic", "CentOS", "", "Run Perl standard test scripts with statistics", "RSA/SHA256, Wed Aug 12 14:33:49 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-debug-devel", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 39270753, "GPLv2", "CentOS", "", "Development package for building kernel modules to match the debug kernel", "RSA/SHA256, Mon Mar 18 15:45:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-thread", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 95658, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost thread library", "RSA/SHA256, Thu Aug 10 15:13:07 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 1995364, "BSD", "CentOS", "", "An open source implementation of SSH protocol versions 1 and 2", "RSA/SHA256, Wed Apr 25 11:32:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 811817, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", "A collection of utilities and DSOs to handle ELF files and DWARF data", "RSA/SHA256, Mon Nov 12 14:24:05 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "A System and Service Manager", "RSA/SHA256, Wed Feb 20 17:14:02 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rsync", "3.1.2", "4.el7", "x86_64", "rsync-3.1.2-4.el7.src.rpm", 834618, "GPLv3+", "CentOS", "", "A program for synchronizing files over a network", "RSA/SHA256, Wed Apr 25 11:44:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 67448, "BSD", "CentOS", "", "A utility for determining file types", "RSA/SHA256, Mon Nov 12 14:25:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dwz", "0.11", "3.el7", "x86_64", "dwz-0.11-3.el7.src.rpm", 225103, "GPLv2+ and GPLv3+", "CentOS", "", "DWARF optimization and duplicate removal tool", "RSA/SHA256, Fri Jul  4 01:10:42 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dyninst", "9.3.1", "2.el7", "x86_64", "dyninst-9.3.1-2.el7.src.rpm", 13049000, "LGPLv2+", "CentOS", "", "An API for Run-time Code Generation", "RSA/SHA256, Mon Nov 12 14:23:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 8436804, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Header files and libraries for C++ development", "RSA/SHA256, Tue Mar 19 19:52:58 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos/httpd-24-centos7 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS7Httpd24 = []*PackageInfo{
		{intRef(32), "bind-license", "9.9.4", "73.el7_6", "noarch", "bind-9.9.4-73.el7_6.src.rpm", 26831, "ISC", "CentOS", "", "License of the BIND DNS suite", "RSA/SHA256, Fri Feb  1 16:26:11 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.2.46", "31.el7", "x86_64", "bash-4.2.46-31.el7.src.rpm", 3667773, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA256, Mon Nov 12 14:21:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 120499441, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA256, Fri Feb  1 16:19:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA256, Thu May 17 13:25:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA256, Wed Apr 25 10:59:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 14346456, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA256, Fri Feb  1 16:19:40 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA256, Thu May 17 13:25:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Fri Jul  4 04:33:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.42.9", "13.el7", "x86_64", "e2fsprogs-1.42.9-13.el7.src.rpm", 60489, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Mon Nov 12 14:31:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Thu Aug 10 17:02:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.8.5", "36.el7", "x86_64", "gcc-4.8.5-36.el7.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA256, Mon Nov 12 14:37:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Wed Apr 25 11:05:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA256, Thu Jun 29 12:40:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 217874, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA256, Mon Nov 12 14:37:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA256, Thu Aug 10 16:26:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA256, Fri Jul  4 02:30:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", "Main loop abstraction library", "RSA/SHA256, Fri Jul  4 03:23:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA256, Thu Aug 10 18:44:50 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 2200985, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Fri Feb  1 16:20:18 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Sun Nov 20 21:02:51 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Apr 25 11:12:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA256, Fri Jul  4 02:49:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA256, Thu Aug 10 17:08:59 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Nov 20 19:22:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 20326, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Mon Nov 12 14:38:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 278173, "LGPLv2+", "CentOS", "", "Device mounting library", "RSA/SHA256, Mon Nov 12 14:33:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA256, Wed Apr 25 11:46:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA256, Wed Apr 25 11:04:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.5.11", "6.el7", "x86_64", "findutils-4.5.11-6.el7.src.rpm", 1855882, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Mon Nov 12 14:25:15 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Fri Jul  4 01:08:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA256, Mon Nov 28 22:32:05 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 256362, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA256, Mon Nov 12 14:21:41 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Wed Apr 25 11:33:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA256, Thu May 17 13:25:42 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2425024, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA256, Fri Feb  1 16:21:33 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", "GnuPG IPC library", "RSA/SHA256, Fri Jul  4 02:35:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2069587, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA256, Fri Feb  1 16:21:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.56.1", "1.el7", "x86_64", "gobject-introspection-1.56.1-1.el7.src.rpm", 854207, "GPLv2+, LGPLv2+, MIT", "CentOS", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Mon Nov 12 14:28:00 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Wed Apr 25 11:13:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 91848, "LGPLv2+", "CentOS", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Mon Nov 12 14:31:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.3", "12.el7", "x86_64", "libssh2-1.4.3-12.el7.src.rpm", 341886, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA256, Mon Nov 12 14:37:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 540293, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Mon Nov 12 14:23:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA256, Mon Nov 12 14:45:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA256, Wed Apr 25 11:23:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.26", "35.el7", "x86_64", "tar-1.26-35.el7.src.rpm", 2838510, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA256, Mon Nov 12 14:47:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", "Access control list utilities", "RSA/SHA256, Wed Apr 25 10:52:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsmartcols", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 164608, "LGPLv2+", "CentOS", "", "Formatting library for ls-like programs.", "RSA/SHA256, Mon Nov 12 14:37:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 302329, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Mon Nov 12 14:37:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Fri Jul  4 03:23:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", "QR Code encoding library - Shared libraries", "RSA/SHA256, Fri Jul  4 04:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 24713067, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA256, Mon Nov 12 14:45:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", "Python 2 bindings for GObject Introspection base package", "RSA/SHA256, Tue Nov 21 14:17:15 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", "Python bindings for lzma", "RSA/SHA256, Fri Jul  4 04:37:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.10", "9.el7", "noarch", "python-urlgrabber-3.10-9.el7.src.rpm", 503349, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA256, Mon Nov 12 15:19:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", "Extended attributes library wrapper for Python", "RSA/SHA256, Fri Jul  4 04:43:07 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", "Small, useful pieces of code to make python coding easier", "RSA/SHA256, Fri Jul  4 04:39:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", "A JSON implementation in C", "RSA/SHA256, Sat Jul  5 15:25:00 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps-ng", "3.3.10", "23.el7", "x86_64", "procps-ng-3.3.10-23.el7.src.rpm", 760565, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA256, Mon Nov 12 14:44:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 339987, "GPLv2", "CentOS", "", "Device mapper utility", "RSA/SHA256, Fri Feb  1 16:18:53 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", "Cryptsetup shared library", "RSA/SHA256, Mon Nov 12 14:23:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 243559, "GPLv2+", "CentOS", "", "Linux kernel module management utilities", "RSA/SHA256, Mon Nov 12 14:30:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", "systemd libraries", "RSA/SHA256, Wed Feb 20 17:14:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "A System and Service Manager", "RSA/SHA256, Wed Feb 20 17:14:02 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.172", "2.el7", "noarch", "elfutils-0.172-2.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Mon Nov 12 15:15:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA256, Thu Aug 10 16:47:33 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA256, Fri Jul  4 01:06:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Wed Nov 25 15:32:05 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Mon Nov 12 14:45:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Fri Jul  4 01:44:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 53895, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA256, Mon Nov 12 15:27:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-utils", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 345277, "GPLv2+", "CentOS", "", "Utilities based around the yum package manager", "RSA/SHA256, Mon Nov 12 15:27:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA256, Fri Jul  4 04:12:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.160", "5.el7", "x86_64", "vim-7.4.160-5.el7.src.rpm", 917744, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA256, Mon Nov 12 14:48:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", "gpg(CentOS-7 Key (CentOS 7 Official Signing Key) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lzo", "2.06", "8.el7", "x86_64", "lzo-2.06-8.el7.src.rpm", 165360, "GPLv2+", "CentOS", "", "Data compression library with very fast (de)compression", "RSA/SHA256, Wed Nov 25 15:15:42 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", "A CSS2 parsing library", "RSA/SHA256, Mon Nov 12 14:31:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libarchive", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 745291, "BSD", "CentOS", "", "A library for handling streaming archive formats", "RSA/SHA256, Thu Sep 15 23:28:35 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA256, Thu Aug 10 16:07:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", "Parts of the groff formatting system required to display manual pages", "RSA/SHA256, Fri Jul  4 01:45:51 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release-scl-rh", "2", "3.el7.centos", "noarch", "centos-release-scl-rh-2-3.el7.centos.src.rpm", 20015, "GPLv2", "CentOS", "", "Software collections from the CentOS SCLo SIG (upstream scl only)", "RSA/SHA256, Mon Apr  1 12:41:53 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "epel-release", "7", "11", "noarch", "epel-release-7-11.src.rpm", 24834, "GPLv2", "Fedora Project", "", "Extra Packages for Enterprise Linux repository configuration", "RSA/SHA256, Fri May 11 12:21:29 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "352c64e5", "52ae6884", "", "", 0, "pubkey", "", "", "gpg(Fedora EPEL (7) <epel@fedoraproject.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", "Apache Portable Runtime library", "RSA/SHA256, Tue Nov 28 22:16:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool-ltdl", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 67814, "LGPLv2+", "CentOS", "", "Runtime libraries for GNU Libtool Dynamic Module Loader", "RSA/SHA256, Thu Apr 13 01:26:27 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", "Apache Portable Runtime Utility library", "RSA/SHA256, Fri Jul  4 00:39:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-libs", "9.9.4", "73.el7_6", "x86_64", "bind-9.9.4-73.el7_6.src.rpm", 2720960, "ISC", "CentOS", "", "Libraries used by the BIND DNS packages", "RSA/SHA256, Fri Feb  1 16:18:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lasso", "2.5.1", "2.el7", "x86_64", "lasso-2.5.1-2.el7.src.rpm", 570546, "GPLv2+", "CentOS", "", "Liberty Alliance Single Sign On", "RSA/SHA256, Sun Nov 20 18:33:03 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", "Small, simple, correct HTTP/1.1 client", "RSA/SHA256, Fri Jul  4 04:19:08 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", "Look up Perl documentation in Pod format", "RSA/SHA256, Fri Jul  4 04:22:38 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", "Parse text into an array of tokens or array of arrays", "RSA/SHA256, Fri Jul  4 04:25:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", "Print a usage message from embedded POD documentation", "RSA/SHA256, Fri Jul  4 04:22:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", "Macros for rpmbuild", "RSA/SHA256, Thu Jan 24 13:22:17 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", "Implements default import method for modules", "RSA/SHA256, Fri Jul  4 04:17:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", "Efficiently compute time from local and GMT time", "RSA/SHA256, Fri Jul  4 04:25:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", "Alternative warn and die for modules", "RSA/SHA256, Fri Jul  4 04:15:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", "Perl extension for sharing data structures between threads", "RSA/SHA256, Fri Jul  4 04:25:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", "A selection of general-utility scalar and list subroutines", "RSA/SHA256, Fri Jul  4 04:23:05 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", "Return name and handle of a temporary file safely", "RSA/SHA256, Fri Jul  4 04:18:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", "Perl source filters", "RSA/SHA256, Fri Jul  4 04:18:19 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", "Extended processing of command line options", "RSA/SHA256, Wed Apr 25 11:36:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA256, Sun Nov 20 19:23:44 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcgroup", "0.41", "20.el7", "x86_64", "libcgroup-0.41-20.el7.src.rpm", 137210, "LGPLv2+", "CentOS", "", "Library to control and monitor control groups", "RSA/SHA256, Mon Nov 12 14:31:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jansson", "2.10", "1.el7", "x86_64", "jansson-2.10-1.el7.src.rpm", 74998, "MIT", "CentOS", "", "C library for encoding, decoding and manipulating JSON data", "RSA/SHA256, Thu Aug 10 16:50:09 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 172645, "Public Domain", "CentOS", "", "SELinux libselinux utilies", "RSA/SHA256, Mon Nov 12 14:37:31 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage-python", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 451817, "LGPLv2+", "CentOS", "", "semanage python bindings for libsemanage", "RSA/SHA256, Mon Nov 12 14:37:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-IPy", "0.75", "6.el7", "noarch", "python-IPy-0.75-6.el7.src.rpm", 121946, "BSD", "CentOS", "", "Python module for handling IPv4 and IPv6 Addresses and Networks", "RSA/SHA256, Fri Jul  4 04:39:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-logos", "70.0.6", "3.el7.centos", "noarch", "centos-logos-70.0.6-3.el7.centos.src.rpm", 22548401, "Copyright © 2014 The CentOS Project.  All rights reserved.", "CentOS", "", "CentOS-related icons and pictures", "RSA/SHA256, Wed Sep 30 20:10:38 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs-python", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 327265, "LGPLv2+", "CentOS", "", "Python bindings for libaudit", "RSA/SHA256, Mon Nov 12 14:21:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-runtime", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 20989, "GPLv2+", "CentOS", "", "Package that handles httpd24 Software Collection.", "RSA/SHA1, Mon Nov 27 10:19:25 2017, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-libnghttp2", "1.7.1", "7.el7", "x86_64", "httpd24-nghttp2-1.7.1-7.el7.src.rpm", 142738, "MIT", "CentOS", "", "A library implementing the HTTP/2 protocol", "RSA/SHA1, Wed Nov 28 22:38:16 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-httpd", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 4739300, "ASL 2.0", "CentOS", "", "Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:14 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "httpd24-mod_ssl", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 241612, "ASL 2.0", "CentOS", "", "SSL/TLS module for the Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:18 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss_wrapper", "1.1.5", "1.el7", "x86_64", "nss_wrapper-1.1.5-1.el7.src.rpm", 75009, "BSD", "Fedora Project", "", "A wrapper for the user, group and hosts NSS API", "RSA/SHA256, Fri Nov  2 10:20:55 2018, Key ID 6a2faea2352c64e5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.8.5", "36.el7", "x86_64", "gcc-4.8.5-36.el7.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC version 4.8 shared support library", "RSA/SHA256, Mon Nov 12 14:32:09 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018i", "1.el7", "noarch", "tzdata-2018i-1.el7.src.rpm", 2007607, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA256, Thu Jan 10 16:43:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA256, Thu Sep  7 12:43:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Thu Aug 10 15:17:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA256, Thu Sep  7 12:43:10 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.71", "10.el7", "noarch", "setup-2.8.71-10.el7.src.rpm", 696893, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA256, Mon Nov 12 15:19:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple CentOS Linux system", "RSA/SHA256, Fri Jul  4 00:46:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 185294, "zlib and Boost", "CentOS", "", "The compression and decompression library", "RSA/SHA256, Mon Nov 12 14:49:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.1.el7_6", "x86_64", "nss-util-3.36.0-1.1.el7_6.src.rpm", 199008, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA256, Fri Feb  1 16:21:37 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Nov 20 18:39:28 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA256, Wed Apr 25 11:11:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA256, Wed Apr 25 11:10:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA256, Thu Sep  7 12:43:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.5", "10.el7", "x86_64", "libsepol-2.5-10.el7.src.rpm", 686640, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Mon Nov 12 14:37:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Thu Aug 10 19:04:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", "A GNU stream text editor", "RSA/SHA256, Fri Jul  4 04:58:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Thu Aug 10 18:44:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA256, Thu Aug 10 16:14:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Thu Aug 10 17:58:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Thu May 17 13:16:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.22", "23.el7", "x86_64", "coreutils-8.22-23.el7.src.rpm", 14588674, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Mon Nov 12 14:22:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "7", "6.1810.2.el7.centos", "x86_64", "centos-release-7-6.1810.2.el7.centos.src.rpm", 41271, "GPLv2", "CentOS", "", "CentOS Linux release file", "RSA/SHA256, Fri Nov 23 13:35:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Nov 25 14:18:43 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA256, Mon Nov 12 14:24:07 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA256, Thu Jun 23 20:07:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA256, Thu Aug 10 19:38:52 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA256, Wed Apr 25 10:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 265973, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA256, Mon Nov 12 14:31:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.56.1", "2.el7", "x86_64", "glib2-2.56.1-2.el7.src.rpm", 12166425, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA256, Mon Nov 12 14:26:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA256, Wed Nov 25 15:40:39 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Fri Jul  4 01:02:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Wed Nov 25 14:58:28 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Wed Nov 25 14:52:00 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Fri Jul  4 01:02:17 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", "A library for password generation and password quality checking", "RSA/SHA256, Wed Apr 25 11:17:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-pem", "1.0.3", "5.el7", "x86_64", "nss-pem-1.0.3-5.el7.src.rpm", 205539, "MPLv1.1", "CentOS", "", "PEM file reader for Network Security Services (NSS)", "RSA/SHA256, Mon Nov 12 14:41:18 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 14067, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA256, Fri Feb  1 16:21:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA256, Sun Nov 20 21:02:26 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA256, Mon Nov 12 14:25:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", "Extremely fast compression algorithm", "RSA/SHA256, Wed Apr 25 11:26:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Fri Jul  4 04:28:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Wed Apr 25 10:56:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 25150000, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA256, Mon Nov 12 14:22:05 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 435192, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA256, Mon Nov 12 14:31:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Mon Nov 12 14:45:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.44", "21.el7_6", "x86_64", "openldap-2.4.44-21.el7_6.src.rpm", 1037424, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA256, Fri Feb  1 16:21:40 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA256, Sun Nov 20 20:05:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Fri Jul  4 05:39:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "25.el7", "x86_64", "shadow-utils-4.1.5.1-25.el7.src.rpm", 3540592, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Mon Nov 12 14:46:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", "Create a tree of hardlinks", "RSA/SHA256, Fri Jul  4 01:53:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Fri Jul  4 01:27:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 80907, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA256, Mon Nov 12 14:44:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", "Python bindings for the libxml2 library", "RSA/SHA256, Thu Jun 23 20:08:06 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA256, Fri Jul  4 05:53:04 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA256, Sun Nov 20 20:16:57 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Fri Jul  4 04:39:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", "Character encoding auto-detection in Python", "RSA/SHA256, Wed Jul 22 20:25:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", "Utility to set/show the host name or domain name", "RSA/SHA256, Fri Jul  4 01:54:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.23.2", "59.el7", "x86_64", "util-linux-2.23.2-59.el7.src.rpm", 8447471, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA256, Mon Nov 12 14:48:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kpartx", "0.4.9", "123.el7", "x86_64", "device-mapper-multipath-0.4.9-123.el7.src.rpm", 41363, "GPL+", "CentOS", "", "Partition device manager for device-mapper devices", "RSA/SHA256, Mon Nov 12 14:31:04 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper-libs", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 400607, "LGPLv2", "CentOS", "", "Device-mapper shared library", "RSA/SHA256, Fri Feb  1 16:18:57 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut", "033", "554.el7", "x86_64", "dracut-033-554.el7.src.rpm", 903230, "GPLv2+ and LGPLv2+", "CentOS", "", "Initramfs generator using udev", "RSA/SHA256, Mon Nov 12 14:23:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA256, Mon Nov 12 14:24:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 362560, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA256, Mon Nov 12 14:23:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 595210, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Mon Nov 12 14:23:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", "D-Bus Python Bindings", "RSA/SHA256, Fri Jul  4 01:06:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA256, Fri Jul 13 15:56:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA256, Mon Nov 12 14:45:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Fri Jul  4 04:36:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.4.3", "161.el7.centos", "noarch", "yum-3.4.3-161.el7.centos.src.rpm", 5824869, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA256, Mon Nov 12 15:27:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 22399, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA256, Mon Nov 12 15:27:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Fri Jul  4 04:50:28 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC OpenMP v3.0 shared support library", "RSA/SHA256, Tue Mar 19 19:52:30 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", "GNU Unicode string library", "RSA/SHA256, Fri Jul  4 03:22:35 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", "Libraries for gettext", "RSA/SHA256, Thu Aug 10 16:08:05 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bsdtar", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 110459, "BSD", "CentOS", "", "Manipulate tape archives", "RSA/SHA256, Thu Sep 15 23:18:53 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA256, Wed Apr 25 11:50:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "scl-utils", "20130529", "19.el7", "x86_64", "scl-utils-20130529-19.el7.src.rpm", 25141, "GPLv2+", "CentOS", "", "Utilities for alternative packaging", "RSA/SHA256, Mon Nov 12 14:46:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release-scl", "2", "3.el7.centos", "noarch", "centos-release-scl-2-3.el7.centos.src.rpm", 20042, "GPLv2", "CentOS", "", "Software collections from the CentOS SCLo SIG", "RSA/SHA256, Mon Apr  1 15:32:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "f2ee9d55", "560cfc0a", "", "", 0, "pubkey", "", "", "gpg(CentOS SoftwareCollections SIG (https://wiki.centos.org/SpecialInterestGroup/SCLo) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 3204708, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Mon Mar 18 15:45:52 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxslt", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 497582, "MIT", "CentOS", "", "Library providing the Gnome XSLT engine", "RSA/SHA256, Fri Jul  4 03:32:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xmlsec1", "1.2.20", "7.el7_4", "x86_64", "xmlsec1-1.2.20-7.el7_4.src.rpm", 568638, "MIT", "CentOS", "", "Library providing support for \"XML Signature\" and \"XML Encryption\" standards", "RSA/SHA256, Thu Aug 31 16:00:11 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "GeoIP", "1.5.0", "13.el7", "x86_64", "GeoIP-1.5.0-13.el7.src.rpm", 3912607, "LGPLv2+ and GPLv2+ and CC-BY-SA", "CentOS", "", "Library for country/city/organization to IP address or hostname mapping", "RSA/SHA256, Mon Nov 12 14:26:31 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xmlsec1-openssl", "1.2.20", "7.el7_4", "x86_64", "xmlsec1-1.2.20-7.el7_4.src.rpm", 245128, "MIT", "CentOS", "", "OpenSSL crypto plugin for XML Security Library", "RSA/SHA256, Thu Aug 31 16:01:12 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", "Establish an ISA relationship with base classes at compile time", "RSA/SHA256, Fri Jul  4 04:21:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", "Format POD source into various output formats", "RSA/SHA256, Fri Jul  4 04:22:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", "Perl module for resolving POD escape sequences", "RSA/SHA256, Thu Jan 24 13:22:34 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", "Character encodings in Perl", "RSA/SHA256, Fri Jul  4 04:17:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", "The libraries for the perl runtime", "RSA/SHA256, Thu Jan 24 13:22:16 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", "Perl interpreter-based threads", "RSA/SHA256, Fri Jul  4 04:25:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", "Perl pragma to declare constants", "RSA/SHA256, Fri Jul  4 04:15:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", "Networking constants and support functions", "RSA/SHA256, Sun Nov 20 20:02:40 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", "High resolution alarm, sleep, gettimeofday, interval timers", "RSA/SHA256, Fri Jul  4 04:25:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", "PathTools Perl module (Cwd, File::Spec)", "RSA/SHA256, Fri Jul  4 04:22:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", "Persistence for Perl data structures", "RSA/SHA256, Fri Jul  4 04:23:18 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", "Create or remove directory trees", "RSA/SHA256, Fri Jul  4 04:18:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA256, Fri Jul  4 04:22:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", "Practical Extraction and Report Language", "RSA/SHA256, Thu Jan 24 13:22:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 833657, "OpenSSL", "CentOS", "", "Utilities from the general purpose cryptography library with TLS implementation", "RSA/SHA256, Mon Mar 18 15:45:50 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cmake", "2.8.12.2", "2.el7", "x86_64", "cmake-2.8.12.2-2.el7.src.rpm", 28036363, "BSD and MIT and zlib", "CentOS", "", "Cross-platform make system", "RSA/SHA256, Sun Nov 20 17:24:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-python", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 603236, "Public Domain", "CentOS", "", "SELinux python bindings for libselinux", "RSA/SHA256, Mon Nov 12 14:37:29 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 5321515, "GPLv2", "CentOS", "", "SELinux policy core utilities", "RSA/SHA256, Fri Feb  1 16:21:56 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setools-libs", "3.3.8", "4.el7", "x86_64", "setools-3.3.8-4.el7.src.rpm", 1917790, "LGPLv2", "CentOS", "", "Policy analysis support libraries for SELinux", "RSA/SHA256, Mon Nov 12 14:46:38 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "checkpolicy", "2.5", "8.el7", "x86_64", "checkpolicy-2.5-8.el7.src.rpm", 1288327, "GPLv2", "CentOS", "", "SELinux policy compiler", "RSA/SHA256, Mon Nov 12 14:22:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mailcap", "2.1.41", "2.el7", "noarch", "mailcap-2.1.41-2.el7.src.rpm", 63360, "Public Domain and MIT", "CentOS", "", "Helper application and MIME type associations for file types", "RSA/SHA256, Fri Jul  4 03:37:01 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils-python", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 1299284, "GPLv2", "CentOS", "", "SELinux policy core python utilities", "RSA/SHA256, Fri Feb  1 16:22:00 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-libcurl", "7.61.1", "1.el7", "x86_64", "httpd24-curl-7.61.1-1.el7.src.rpm", 545704, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA1, Wed Nov 28 22:38:15 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-httpd-tools", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 177148, "ASL 2.0", "CentOS", "", "Tools for use with the Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:15 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-mod_auth_mellon", "0.13.1", "2.el7", "x86_64", "httpd24-mod_auth_mellon-0.13.1-2.el7.src.rpm", 1108011, "GPLv2+", "CentOS", "", "A SAML 2.0 authentication module for the Apache Httpd Server", "RSA/SHA1, Thu May 24 11:30:18 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 0, "GPLv2+", "CentOS", "", "Package that installs httpd24", "RSA/SHA1, Mon Nov 27 10:19:20 2017, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-utils", "9.9.4", "73.el7_6", "x86_64", "bind-9.9.4-73.el7_6.src.rpm", 441412, "ISC", "CentOS", "", "Utilities for querying DNS name servers", "RSA/SHA256, Fri Feb  1 16:18:49 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:7 bash
	// yum groupinstall -y "Development tools"
	// yum install -y rpm-build redhat-rpm-config asciidoc hmaccalc perl-ExtUtils-Embed pesign xmlto
	// yum install -y audit-libs-devel binutils-devel elfutils-devel elfutils-libelf-devel java-devel
	// yum install -y ncurses-devel newt-devel numactl-devel pciutils-devel python-devel zlib-devel
	// yum install -y net-tools bc
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS7Many = []*PackageInfo{
		{intRef(), "gnutls", "3.3.29", "9.el7_6", "x86_64", "gnutls-3.3.29-9.el7_6.src.rpm", 2097819, "GPLv3+ and LGPLv2+", "CentOS", "", "A TLS protocol implementation", "RSA/SHA256, Tue Mar 19 19:51:33 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA256, Thu May 17 13:25:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh-clients", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 2651616, "BSD", "CentOS", "", "An open source SSH client applications", "RSA/SHA256, Wed Apr 25 11:32:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "neon", "0.30.0", "3.el7", "x86_64", "neon-0.30.0-3.el7.src.rpm", 567772, "LGPLv2+", "CentOS", "", "An HTTP and WebDAV client library", "RSA/SHA256, Fri Jul  4 03:54:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mokutil", "15", "2.el7.centos", "x86_64", "shim-signed-15-2.el7.centos.src.rpm", 83521, "BSD", "CentOS", "", "Utilities for managing Secure Boot/MoK keys.", "RSA/SHA256, Mon Feb 25 15:48:16 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Fri Jul  4 04:33:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-headers", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 2338328, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Header files for development using standard C libraries.", "RSA/SHA256, Tue Apr  9 20:22:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Thu Aug 10 17:02:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-devel", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 7910669, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - development headers, tools", "RSA/SHA256, Mon Nov 12 14:47:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA256, Thu Sep  7 12:43:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-devel", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1492653, "LGPLv2+ and GPLv3+", "CentOS", "", "Development files for gettext", "RSA/SHA256, Thu Aug 10 16:07:56 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.5", "12.el7", "x86_64", "libselinux-2.5-12.el7.src.rpm", 217874, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA256, Thu Apr 26 12:47:14 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-gfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 16443248, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Fortran support", "RSA/SHA256, Tue Mar 19 19:51:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA256, Fri Jul  4 02:30:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subversion", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 4844082, "ASL 2.0", "CentOS", "", "A Modern Concurrent Version Control System", "RSA/SHA256, Wed Apr 25 11:47:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA256, Thu Aug 10 18:44:50 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA256, Mon Nov 12 14:45:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "7", "5.1804.4.el7.centos", "x86_64", "centos-release-7-5.1804.4.el7.centos.src.rpm", 40338, "GPLv2", "CentOS", "", "CentOS Linux release file", "RSA/SHA256, Mon Aug 13 15:10:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffstat", "1.57", "4.el7", "x86_64", "diffstat-1.57-4.el7.src.rpm", 54065, "MIT", "CentOS", "", "A utility which provides statistics based on the output of diff", "RSA/SHA256, Fri Jul  4 01:08:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Apr 25 11:12:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "indent", "2.2.11", "13.el7", "x86_64", "indent-2.2.11-13.el7.src.rpm", 359131, "GPLv3+", "CentOS", "", "A GNU program for formatting C code", "RSA/SHA256, Fri Jul  4 02:06:41 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA256, Thu Aug 10 17:08:59 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libICE", "1.0.9", "9.el7", "x86_64", "libICE-1.0.9-9.el7.src.rpm", 152213, "MIT", "CentOS", "", "X.Org X11 ICE runtime library", "RSA/SHA256, Thu Aug 10 17:17:23 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 20326, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Mon Aug 20 14:15:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "cups-libs", "1.6.3", "35.el7", "x86_64", "cups-1.6.3-35.el7.src.rpm", 734207, "LGPLv2 and zlib", "CentOS", "", "CUPS printing system - libraries", "RSA/SHA256, Wed Apr 25 10:56:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA256, Wed Apr 25 11:46:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "atk", "2.28.1", "1.el7", "x86_64", "atk-2.28.1-1.el7.src.rpm", 1273762, "LGPLv2+", "CentOS", "", "Interfaces for accessibility support", "RSA/SHA256, Mon Nov 12 14:21:34 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.5.11", "5.el7", "x86_64", "findutils-4.5.11-5.el7.src.rpm", 1855626, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Wed Nov 25 14:29:59 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dejavu-fonts-common", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 130455, "Bitstream Vera and Public Domain", "CentOS", "", "Common files for the Dejavu font set", "RSA/SHA256, Fri Jul  4 01:06:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA256, Mon Nov 28 22:32:05 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfontenc", "1.1.3", "3.el7", "x86_64", "libfontenc-1.1.3-3.el7.src.rpm", 55701, "MIT", "CentOS", "", "X.Org X11 libfontenc runtime library", "RSA/SHA256, Thu Aug 10 17:08:19 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Wed Apr 25 11:33:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-filesystem", "7.4.160", "5.el7", "x86_64", "vim-7.4.160-5.el7.src.rpm", 0, "Vim", "CentOS", "", "VIM filesystem layout", "RSA/SHA256, Mon Nov 12 14:48:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2424993, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA256, Fri Sep 28 11:34:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libusbx", "1.0.21", "1.el7", "x86_64", "libusbx-1.0.21-1.el7.src.rpm", 143429, "LGPLv2+", "CentOS", "", "Library for accessing USB devices", "RSA/SHA256, Wed Apr 25 11:23:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "opensc", "0.16.0", "10.20170227git777e2a3.el7", "x86_64", "opensc-0.16.0-10.20170227git777e2a3.el7.src.rpm", 3260615, "LGPLv2+", "CentOS", "", "Smart card library and applications", "RSA/SHA256, Mon Nov 12 14:41:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "poppler-data", "0.4.6", "3.el7", "noarch", "poppler-data-0.4.6-3.el7.src.rpm", 12013394, "BSD and GPLv2 and GPLv3+", "CentOS", "", "Encoding files", "RSA/SHA256, Fri Jul  4 04:32:33 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hicolor-icon-theme", "0.12", "7.el7", "noarch", "hicolor-icon-theme-0.12-7.el7.src.rpm", 45788, "GPL+", "CentOS", "", "Basic requirement for icon themes", "RSA/SHA256, Fri Jul  4 01:54:10 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11-common", "1.6.5", "2.el7", "noarch", "libX11-1.6.5-2.el7.src.rpm", 1335662, "MIT", "CentOS", "", "Common data for libX11", "RSA/SHA256, Mon Nov 12 15:18:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lynx", "2.8.8", "0.3.dev15.el7", "x86_64", "lynx-2.8.8-0.3.dev15.el7.src.rpm", 5618384, "GPLv2", "CentOS", "", "A text-based Web browser", "RSA/SHA256, Fri Jul  4 03:36:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdrm", "2.4.91", "3.el7", "x86_64", "libdrm-2.4.91-3.el7.src.rpm", 371903, "MIT", "CentOS", "", "Direct Rendering Manager runtime library", "RSA/SHA256, Mon Nov 12 14:32:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "docbook-style-xsl", "1.78.1", "3.el7", "noarch", "docbook-style-xsl-1.78.1-3.el7.src.rpm", 16671587, "DMIT", "CentOS", "", "Norman Walsh's XSL stylesheets for DocBook XML", "RSA/SHA256, Fri Jul  4 01:09:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXext", "1.3.3", "3.el7", "x86_64", "libXext-1.3.3-3.el7.src.rpm", 87102, "MIT", "CentOS", "", "X.Org X11 libXext runtime library", "RSA/SHA256, Wed Nov 25 15:13:57 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Fri Jul  4 03:23:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXt", "1.1.5", "3.el7", "x86_64", "libXt-1.1.5-3.el7.src.rpm", 430105, "MIT", "CentOS", "", "X.Org X11 libXt runtime library", "RSA/SHA256, Thu Aug 10 18:13:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 338922, "GPLv2", "CentOS", "", "Device mapper utility", "RSA/SHA256, Wed Apr 25 10:57:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXaw", "1.0.13", "4.el7", "x86_64", "libXaw-1.0.13-4.el7.src.rpm", 498789, "MIT", "CentOS", "", "X Athena Widget Set", "RSA/SHA256, Thu Aug 10 18:09:13 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcursor", "1.1.15", "1.el7", "x86_64", "libXcursor-1.1.15-1.el7.src.rpm", 47039, "MIT", "CentOS", "", "Cursor management library", "RSA/SHA256, Mon Nov 12 14:39:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXinerama", "1.1.3", "2.1.el7", "x86_64", "libXinerama-1.1.3-2.1.el7.src.rpm", 14967, "MIT", "CentOS", "", "X.Org X11 libXinerama runtime library", "RSA/SHA256, Fri Jul  4 03:30:47 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 595223, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Wed Apr 25 10:57:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcomposite", "0.4.4", "4.1.el7", "x86_64", "libXcomposite-0.4.4-4.1.el7.src.rpm", 35184, "MIT", "CentOS", "", "X Composite Extension library", "RSA/SHA256, Fri Jul  4 03:29:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Fri Jul  4 01:27:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fribidi", "1.0.2", "1.el7", "x86_64", "fribidi-1.0.2-1.el7.src.rpm", 309831, "LGPLv2+ and UCD", "CentOS", "", "Library implementing the Unicode Bidirectional Algorithm", "RSA/SHA256, Mon Nov 12 14:25:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", "D-Bus Python Bindings", "RSA/SHA256, Fri Jul  4 01:06:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool-ltdl", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 67814, "LGPLv2+", "CentOS", "", "Runtime libraries for GNU Libtool Dynamic Module Loader", "RSA/SHA256, Thu Apr 13 01:26:27 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-ExtUtils-MakeMaker", "6.68", "3.el7", "noarch", "perl-ExtUtils-MakeMaker-6.68-3.el7.src.rpm", 650532, "GPL+ or Artistic", "CentOS", "", "Create a module Makefile", "RSA/SHA256, Fri Jul  4 04:17:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", "Python bindings for lzma", "RSA/SHA256, Fri Jul  4 04:37:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "asciidoc", "8.6.8", "5.el7", "noarch", "asciidoc-8.6.8-5.el7.src.rpm", 976747, "GPL+ and GPLv2+", "CentOS", "", "Text based document generation", "RSA/SHA256, Fri Jul  4 00:40:08 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", "Extended attributes library wrapper for Python", "RSA/SHA256, Fri Jul  4 04:43:07 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 185294, "zlib and Boost", "CentOS", "", "The compression and decompression library", "RSA/SHA256, Mon Nov 12 14:49:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-javapackages", "3.4.1", "11.el7", "noarch", "javapackages-tools-3.4.1-11.el7.src.rpm", 66505, "BSD", "CentOS", "", "Module for handling various files for Java packaging", "RSA/SHA256, Wed Nov 25 15:33:32 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 25150000, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA256, Mon Nov 12 14:22:05 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.4.3", "158.el7.centos", "noarch", "yum-3.4.3-158.el7.centos.src.rpm", 5814102, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA256, Wed Apr 25 11:52:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXtst", "1.2.3", "1.el7", "x86_64", "libXtst-1.2.3-1.el7.src.rpm", 29938, "MIT", "CentOS", "", "X.Org X11 libXtst runtime library", "RSA/SHA256, Thu Aug 10 18:13:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "alsa-lib", "1.1.6", "2.el7", "x86_64", "alsa-lib-1.1.6-2.el7.src.rpm", 1433094, "LGPLv2+", "CentOS", "", "The Advanced Linux Sound Architecture (ALSA) library", "RSA/SHA256, Mon Nov 12 14:21:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-utils", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 343422, "GPLv2+", "CentOS", "", "Utilities based around the yum package manager", "RSA/SHA256, Thu Aug  2 09:01:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs-devel", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 88847, "LGPLv2+", "CentOS", "", "Header files for libaudit", "RSA/SHA256, Mon Nov 12 14:21:42 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.160", "4.el7", "x86_64", "vim-7.4.160-4.el7.src.rpm", 917640, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA256, Wed Apr 25 11:50:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.7.5", "77.el7_6", "x86_64", "python-2.7.5-77.el7_6.src.rpm", 24714266, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA256, Tue Apr  9 20:22:42 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 120497983, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA256, Tue Apr  9 20:22:34 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "slang-devel", "2.2.4", "11.el7", "x86_64", "slang-2.2.4-11.el7.src.rpm", 356429, "GPLv2+", "CentOS", "", "Development files for the S-Lang extension language", "RSA/SHA256, Fri Jul  4 05:01:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA256, Mon Nov 12 14:45:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "newt-devel", "0.52.15", "4.el7", "x86_64", "newt-0.52.15-4.el7.src.rpm", 127322, "LGPLv2", "CentOS", "", "Newt windowing toolkit development files", "RSA/SHA256, Fri Jul  4 03:56:58 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "3.1.1", "4.el7", "x86_64", "mpfr-3.1.1-4.el7.src.rpm", 554279, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Fri Jul  4 03:49:45 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bc", "1.06.95", "13.el7", "x86_64", "bc-1.06.95-13.el7.src.rpm", 219830, "GPLv2+", "CentOS", "", "GNU's bc (a numeric processing language) and dc (a calculator)", "RSA/SHA256, Fri Jul  4 00:47:28 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck-lib", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 11466, "BSD", "CentOS", "", "Library files for fipscheck", "RSA/SHA256, Thu Aug 10 15:53:57 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libquadmath", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 282811, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC __float128 shared support library", "RSA/SHA256, Tue Mar 19 19:52:54 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA256, Wed Apr 25 11:50:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", "Libraries for gettext", "RSA/SHA256, Thu Aug 10 16:08:05 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", "Cryptsetup shared library", "RSA/SHA256, Mon Nov 12 14:23:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", "Format POD source into various output formats", "RSA/SHA256, Fri Jul  4 04:22:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", "Character encodings in Perl", "RSA/SHA256, Fri Jul  4 04:17:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", "Persistence for Perl data structures", "RSA/SHA256, Fri Jul  4 04:23:18 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", "Perl source filters", "RSA/SHA256, Fri Jul  4 04:18:19 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", "Macros for rpmbuild", "RSA/SHA256, Thu Jan 24 13:22:17 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", "PathTools Perl module (Cwd, File::Spec)", "RSA/SHA256, Fri Jul  4 04:22:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", "Practical Extraction and Report Language", "RSA/SHA256, Thu Jan 24 13:22:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Data-Dumper", "2.145", "3.el7", "x86_64", "perl-Data-Dumper-2.145-3.el7.src.rpm", 99287, "GPL+ or Artistic", "CentOS", "", "Stringify perl data structures, suitable for printing and eval", "RSA/SHA256, Fri Jul  4 04:16:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "automake", "1.13.4", "3.el7", "noarch", "automake-1.13.4-3.el7.src.rpm", 1731909, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", "A GNU tool for automatically creating Makefiles", "RSA/SHA256, Fri Jul  4 00:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1186168, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Fortran runtime", "RSA/SHA256, Tue Mar 19 19:52:13 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", "systemd libraries", "RSA/SHA256, Wed Feb 20 17:14:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-sysv", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 3979, "LGPLv2+", "CentOS", "", "SysV tools for systemd", "RSA/SHA256, Wed Feb 20 17:14:08 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-date-time", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 139706, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost date-time library", "RSA/SHA256, Thu Aug 10 15:09:08 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmodman", "2.0.1", "8.el7", "x86_64", "libmodman-2.0.1-8.el7.src.rpm", 58871, "LGPLv2+", "CentOS", "", "A simple library for managing C++ modules (plug-ins)", "RSA/SHA256, Fri Jul  4 02:59:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nettle", "2.7.1", "8.el7", "x86_64", "nettle-2.7.1-8.el7.src.rpm", 765042, "LGPLv2+", "CentOS", "", "A low-level cryptographic library", "RSA/SHA256, Sun Nov 20 19:36:42 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA256, Thu Sep  7 12:43:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb", "7.6.1", "114.el7", "x86_64", "gdb-7.6.1-114.el7.src.rpm", 7371507, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and BSD and Public Domain", "CentOS", "", "A GNU source-level debugger for C, C++, Fortran, Go and other languages", "RSA/SHA256, Mon Nov 12 14:25:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.2.46", "30.el7", "x86_64", "bash-4.2.46-30.el7.src.rpm", 3667709, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA256, Wed Apr 25 10:54:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libedit", "3.0", "12.20121213cvs.el7", "x86_64", "libedit-3.0-12.20121213cvs.el7.src.rpm", 244257, "BSD", "CentOS", "", "The NetBSD Editline library", "RSA/SHA256, Fri Jul  4 02:44:30 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Thu Aug 10 15:17:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Git", "1.8.3.1", "20.el7", "noarch", "git-1.8.3.1-20.el7.src.rpm", 58567, "GPLv2", "CentOS", "", "Perl interface to Git", "RSA/SHA256, Tue Nov 20 20:42:15 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.71", "9.el7", "noarch", "setup-2.8.71-9.el7.src.rpm", 696925, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA256, Wed Apr 25 11:46:38 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pakchois", "0.4", "10.el7", "x86_64", "pakchois-0.4-10.el7.src.rpm", 29489, "LGPLv2+", "CentOS", "", "A wrapper library for PKCS#11", "RSA/SHA256, Fri Jul  4 04:11:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple CentOS Linux system", "RSA/SHA256, Fri Jul  4 00:46:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subversion-libs", "1.7.14", "14.el7", "x86_64", "subversion-1.7.14-14.el7.src.rpm", 2615823, "ASL 2.0", "CentOS", "", "Libraries for Subversion Version Control system", "RSA/SHA256, Wed Apr 25 11:47:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "efivar-libs", "36", "11.el7_6.1", "x86_64", "efivar-36-11.el7_6.1.src.rpm", 252096, "LGPLv2+", "CentOS", "", "Library to manage UEFI variables", "RSA/SHA256, Fri Feb  1 16:18:59 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.el7_5", "x86_64", "nss-util-3.36.0-1.el7_5.src.rpm", 194944, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA256, Thu May 17 13:25:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-client", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 10146436, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - client", "RSA/SHA256, Mon Nov 12 14:47:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.42.9", "12.el7_5", "x86_64", "e2fsprogs-1.42.9-12.el7_5.src.rpm", 60489, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Thu May 17 13:22:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-headers", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 3823832, "GPLv2", "CentOS", "", "Header files for the Linux kernel for use by glibc", "RSA/SHA256, Mon Mar 18 15:45:45 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA256, Wed Apr 25 11:11:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-devel", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 1066078, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Object files for development using standard C libraries.", "RSA/SHA256, Tue Apr  9 20:22:35 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA256, Wed Apr 25 11:10:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libquadmath-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 18514, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC __float128 support", "RSA/SHA256, Tue Mar 19 19:52:54 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-srpm-macros", "1", "8.el7", "noarch", "perl-srpm-macros-1-8.el7.src.rpm", 794, "GPLv3+", "CentOS", "", "RPM macros for building Perl source package from source repository", "RSA/SHA256, Fri Jul  4 04:23:16 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Wed Apr 25 11:05:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-common-devel", "0.19.8.1", "2.el7", "noarch", "gettext-0.19.8.1-2.el7.src.rpm", 397912, "GPLv3+", "CentOS", "", "Common development files for gettext", "RSA/SHA256, Thu Aug 10 16:07:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Thu Aug 10 19:04:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "intltool", "0.50.2", "7.el7", "noarch", "intltool-0.50.2-7.el7.src.rpm", 170106, "GPLv2 with exceptions", "CentOS", "", "Utility for internationalizing various kinds of data files", "RSA/SHA256, Thu Aug 10 16:44:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", "A GNU stream text editor", "RSA/SHA256, Fri Jul  4 04:58:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 206577, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system", "RSA/SHA256, Mon Nov 12 14:47:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Thu Aug 10 18:44:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 2323761, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", "The GNU Portable Library Tool", "RSA/SHA256, Thu Apr 13 01:26:19 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA256, Thu Aug 10 16:14:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cscope", "15.8", "10.el7", "x86_64", "cscope-15.8-10.el7.src.rpm", 939744, "BSD and GPLv2+", "CentOS", "", "C source code tree search and browse tool", "RSA/SHA256, Thu Aug 10 15:28:54 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Thu Aug 10 17:58:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patchutils", "0.3.3", "4.el7", "x86_64", "patchutils-0.3.3-4.el7.src.rpm", 260135, "GPLv2+", "CentOS", "", "A collection of programs for manipulating patch files", "RSA/SHA256, Fri Jul  4 04:12:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Thu May 17 13:16:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bison", "3.0.4", "2.el7", "x86_64", "bison-3.0.4-2.el7.src.rpm", 2154174, "GPLv3+", "CentOS", "", "A GNU general-purpose parser generator", "RSA/SHA256, Mon Nov 12 14:22:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.22", "21.el7", "x86_64", "coreutils-8.22-21.el7.src.rpm", 14588989, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Wed Apr 25 10:55:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-sign", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 17397, "GPLv2+", "CentOS", "", "Package signing support", "RSA/SHA256, Mon Nov 12 14:45:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.15.1", "19.el7", "x86_64", "krb5-1.15.1-19.el7.src.rpm", 1984782, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Thu May 10 02:35:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "swig", "2.0.10", "5.el7", "x86_64", "swig-2.0.10-5.el7.src.rpm", 4926232, "GPLv3+ and BSD", "CentOS", "", "Connects C/C++/Objective C to some high-level programming languages", "RSA/SHA256, Sun Nov 20 20:49:25 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Nov 25 14:18:43 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rcs", "5.9.0", "5.el7", "x86_64", "rcs-5.9.0-5.el7.src.rpm", 624710, "GPLv3+", "CentOS", "", "Revision Control System (RCS) file version management tools", "RSA/SHA256, Fri Jul  4 04:47:23 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ctags", "5.8", "13.el7", "x86_64", "ctags-5.8-13.el7.src.rpm", 359724, "GPLv2+ and LGPLv2+ and Public Domain", "CentOS", "", "A C programming language indexing and/or cross-reference tool", "RSA/SHA256, Fri Jul  4 01:03:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA256, Thu Jun 23 20:07:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libpng", "1.5.13", "7.el7_2", "x86_64", "libpng-1.5.13-7.el7_2.src.rpm", 616101, "zlib", "CentOS", "", "A library of functions for manipulating PNG image format files", "RSA/SHA256, Wed Dec  9 17:02:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA256, Thu Aug 10 19:38:52 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libjpeg-turbo", "1.2.90", "6.el7", "x86_64", "libjpeg-turbo-1.2.90-6.el7.src.rpm", 350499, "IJG", "CentOS", "", "A MMX/SSE2 accelerated library for manipulating JPEG image files", "RSA/SHA256, Mon Nov 12 14:33:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA256, Wed Apr 25 10:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libSM", "1.2.2", "2.el7", "x86_64", "libSM-1.2.2-2.el7.src.rpm", 81546, "MIT", "CentOS", "", "X.Org X11 SM runtime library", "RSA/SHA256, Wed Nov 25 15:08:11 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 261837, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA256, Mon Aug 20 14:15:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcsc-lite-libs", "1.8.8", "8.el7", "x86_64", "pcsc-lite-1.8.8-8.el7.src.rpm", 46708, "BSD", "CentOS", "", "PC/SC Lite libraries", "RSA/SHA256, Mon Nov 12 14:43:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.54.2", "2.el7", "x86_64", "glib2-2.54.2-2.el7.src.rpm", 11986873, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA256, Wed Apr 25 11:01:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "libglvnd", "1.0.1", "0.8.git5baa1e5.el7", "x86_64", "libglvnd-1.0.1-0.8.git5baa1e5.el7.src.rpm", 666456, "MIT", "CentOS", "", "The GL Vendor-Neutral Dispatch library", "RSA/SHA256, Mon Nov 12 14:32:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA256, Wed Nov 25 15:40:39 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xml-common", "0.6.3", "39.el7", "noarch", "sgml-common-0.6.3-39.el7.src.rpm", 46969, "GPL+", "CentOS", "", "Common XML catalog and DTD files", "RSA/SHA256, Fri Jul  4 05:46:52 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Fri Jul  4 01:02:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxslt", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 497582, "MIT", "CentOS", "", "Library providing the Gnome XSLT engine", "RSA/SHA256, Fri Jul  4 03:32:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Wed Nov 25 14:58:28 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libwayland-server", "1.15.0", "1.el7", "x86_64", "wayland-1.15.0-1.el7.src.rpm", 81084, "MIT", "CentOS", "", "Wayland server library", "RSA/SHA256, Mon Nov 12 14:39:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dejavu-sans-fonts", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 5395167, "Bitstream Vera and Public Domain", "CentOS", "", "Variable-width sans-serif font faces", "RSA/SHA256, Fri Jul  4 01:07:01 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Wed Nov 25 14:52:00 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jasper-libs", "1.900.1", "33.el7", "x86_64", "jasper-1.900.1-33.el7.src.rpm", 350690, "JasPer", "CentOS", "", "Runtime libraries for jasper", "RSA/SHA256, Mon Nov 12 14:29:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Fri Jul  4 01:02:17 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "xorg-x11-font-utils", "7.5", "21.el7", "x86_64", "xorg-x11-font-utils-7.5-21.el7.src.rpm", 361874, "MIT", "CentOS", "", "X.Org X11 font utilities", "RSA/SHA256, Mon Nov 12 14:49:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", "A library for password generation and password quality checking", "RSA/SHA256, Wed Apr 25 11:17:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ghostscript-fonts", "5.50", "32.el7", "noarch", "ghostscript-fonts-5.50-32.el7.src.rpm", 636425, "GPLv2+ and Hershey and MIT and OFL and Public Domain", "CentOS", "", "Fonts for the Ghostscript PostScript interpreter", "RSA/SHA256, Fri Jul  4 01:29:57 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 14061, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA256, Fri Sep 28 11:34:18 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lcms2", "2.6", "3.el7", "x86_64", "lcms2-2.6-3.el7.src.rpm", 377192, "MIT", "CentOS", "", "Color Management Engine", "RSA/SHA256, Sun Nov 20 18:33:23 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-pem", "1.0.3", "4.el7", "x86_64", "nss-pem-1.0.3-4.el7.src.rpm", 201219, "MPLv1.1", "CentOS", "", "PEM file reader for Network Security Services (NSS)", "RSA/SHA256, Thu Aug 10 18:33:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtiff", "4.0.3", "27.el7_3", "x86_64", "libtiff-4.0.3-27.el7_3.src.rpm", 494377, "libtiff", "CentOS", "", "Library of functions for manipulating TIFF format image files", "RSA/SHA256, Wed Feb  1 12:42:01 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA256, Sun Nov 20 21:02:26 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcsc-lite-ccid", "1.4.10", "14.el7", "x86_64", "pcsc-lite-ccid-1.4.10-14.el7.src.rpm", 562872, "LGPLv2+", "CentOS", "", "Generic USB CCID smart card reader driver", "RSA/SHA256, Mon Nov 12 14:43:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coolkey", "1.1.0", "40.el7", "x86_64", "coolkey-1.1.0-40.el7.src.rpm", 304556, "LGPLv2", "CentOS", "", "CoolKey PKCS #11 module", "RSA/SHA256, Mon Nov 12 14:22:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", "Extremely fast compression algorithm", "RSA/SHA256, Wed Apr 25 11:26:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libthai", "0.1.14", "9.el7", "x86_64", "libthai-0.1.14-9.el7.src.rpm", 704340, "LGPLv2+", "CentOS", "", "Thai language support routines", "RSA/SHA256, Fri Jul  4 03:20:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-sdt-devel", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 178425, "GPLv2+ and Public Domain", "CentOS", "", "Static probe support tools", "RSA/SHA256, Mon Nov 12 14:47:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2069571, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA256, Fri Sep 28 11:34:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libicu", "50.1.2", "17.el7", "x86_64", "icu-50.1.2-17.el7.src.rpm", 25217861, "MIT and UCD and Public Domain", "CentOS", "", "International Components for Unicode - libraries", "RSA/SHA256, Mon Nov 12 14:33:07 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "source-highlight", "3.1.6", "6.el7", "x86_64", "source-highlight-3.1.6-6.el7.src.rpm", 3024049, "GPLv3+", "CentOS", "", "Produces a document with syntax highlighting", "RSA/SHA256, Fri Jul  4 05:03:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.50.0", "1.el7", "x86_64", "gobject-introspection-1.50.0-1.el7.src.rpm", 834149, "GPLv2+, LGPLv2+, MIT", "CentOS", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Thu Aug 10 16:25:03 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm-devel", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 42866, "GPLv3+", "CentOS", "", "Development libraries and header files for the gdbm library", "RSA/SHA256, Fri Jul  4 01:27:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Wed Apr 25 11:13:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-ExtUtils-Manifest", "1.61", "244.el7", "noarch", "perl-ExtUtils-Manifest-1.61-244.el7.src.rpm", 85359, "GPL+ or Artistic", "CentOS", "", "Utilities to write and check a MANIFEST file", "RSA/SHA256, Fri Jul  4 04:17:46 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 91800, "LGPLv2+", "CentOS", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Wed Apr 25 11:10:17 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "graphite2", "1.3.10", "1.el7_3", "x86_64", "graphite2-1.3.10-1.el7_3.src.rpm", 254548, "(LGPLv2+ or GPLv2+ or MPL) and (Netscape or GPLv2+ or LGPLv2+)", "CentOS", "", "Font rendering capabilities for complex non-Roman writing systems", "RSA/SHA256, Fri Jul 21 10:48:13 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.3", "10.el7_2.1", "x86_64", "libssh2-1.4.3-10.el7_2.1.src.rpm", 341782, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA256, Thu Mar 10 12:07:48 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-indexhtml", "7", "9.el7.centos", "noarch", "centos-indexhtml-7-9.el7.centos.src.rpm", 92560, "Distributable", "CentOS", "", "Browser default start page for CentOS", "RSA/SHA256, Fri Jul  4 00:56:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 540259, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Wed Apr 25 10:56:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pixman", "0.34.0", "1.el7", "x86_64", "pixman-0.34.0-1.el7.src.rpm", 698744, "MIT", "CentOS", "", "Pixel manipulation library", "RSA/SHA256, Sun Nov 20 20:05:36 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpciaccess", "0.14", "1.el7", "x86_64", "libpciaccess-0.14-1.el7.src.rpm", 45649, "MIT", "CentOS", "", "PCI access library", "RSA/SHA256, Wed Apr 25 11:17:01 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA256, Wed Apr 25 11:23:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mesa-libgbm", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 58336, "MIT", "CentOS", "", "Mesa gbm library", "RSA/SHA256, Fri Feb  1 16:21:19 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.26", "34.el7", "x86_64", "tar-1.26-34.el7.src.rpm", 2838271, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA256, Wed Apr 25 11:48:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "docbook-dtds", "1.0", "60.el7", "noarch", "docbook-dtds-1.0-60.el7.src.rpm", 4634764, "Copyright only", "CentOS", "", "SGML and XML document type definitions for DocBook", "RSA/SHA256, Fri Jul  4 01:09:04 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", "Access control list utilities", "RSA/SHA256, Wed Apr 25 10:52:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXau", "1.0.8", "2.1.el7", "x86_64", "libXau-1.0.8-2.1.el7.src.rpm", 55529, "MIT", "CentOS", "", "Sample Authorization Protocol for X", "RSA/SHA256, Fri Jul  4 03:29:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Fri Jul  4 05:39:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11", "1.6.5", "2.el7", "x86_64", "libX11-1.6.5-2.el7.src.rpm", 1325648, "MIT", "CentOS", "", "Core X11 protocol client library", "RSA/SHA256, Mon Nov 12 14:39:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "24.el7", "x86_64", "shadow-utils-4.1.5.1-24.el7.src.rpm", 3534490, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Sun Nov 20 20:44:19 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrender", "0.9.10", "1.el7", "x86_64", "libXrender-0.9.10-1.el7.src.rpm", 46979, "MIT", "CentOS", "", "X.Org X11 libXrender runtime library", "RSA/SHA256, Thu Aug 10 18:12:58 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", "Create a tree of hardlinks", "RSA/SHA256, Fri Jul  4 01:53:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdk-pixbuf2", "2.36.12", "3.el7", "x86_64", "gdk-pixbuf2-2.36.12-3.el7.src.rpm", 2927994, "LGPLv2+", "CentOS", "", "An image loading library", "RSA/SHA256, Mon Nov 12 14:26:01 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 8642769, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA256, Mon Aug 20 14:17:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXpm", "3.5.12", "1.el7", "x86_64", "libXpm-3.5.12-1.el7.src.rpm", 116599, "MIT", "CentOS", "", "X.Org X11 libXpm runtime library", "RSA/SHA256, Thu Aug 10 18:12:27 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kpartx", "0.4.9", "119.el7_5.1", "x86_64", "device-mapper-multipath-0.4.9-119.el7_5.1.src.rpm", 41363, "GPL+", "CentOS", "", "Partition device manager for device-mapper devices", "RSA/SHA256, Mon Aug 20 14:15:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXdamage", "1.1.4", "4.1.el7", "x86_64", "libXdamage-1.1.4-4.1.el7.src.rpm", 29688, "MIT", "CentOS", "", "X Damage extension library", "RSA/SHA256, Fri Jul  4 03:29:47 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper-libs", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 400551, "LGPLv2", "CentOS", "", "Device-mapper shared library", "RSA/SHA256, Wed Apr 25 10:57:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gd", "2.0.35", "26.el7", "x86_64", "gd-2.0.35-26.el7.src.rpm", 554528, "MIT", "CentOS", "", "A graphics library for quick creation of PNG or JPEG images", "RSA/SHA256, Fri Jul  4 01:27:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut", "033", "535.el7_5.1", "x86_64", "dracut-033-535.el7_5.1.src.rpm", 898198, "GPLv2+ and LGPLv2+", "CentOS", "", "Initramfs generator using udev", "RSA/SHA256, Mon Aug 20 14:14:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gtk-update-icon-cache", "3.22.30", "3.el7", "x86_64", "gtk3-3.22.30-3.el7.src.rpm", 59878, "LGPLv2+", "CentOS", "", "Icon theme caching utility", "RSA/SHA256, Mon Nov 12 14:28:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrandr", "1.5.1", "2.el7", "x86_64", "libXrandr-1.5.1-2.el7.src.rpm", 48626, "MIT", "CentOS", "", "X.Org X11 libXrandr runtime library", "RSA/SHA256, Thu Aug 10 18:12:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 362584, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA256, Wed Apr 25 10:57:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXi", "1.7.9", "1.el7", "x86_64", "libXi-1.7.9-1.el7.src.rpm", 70019, "MIT", "CentOS", "", "X.Org X11 libXi runtime library", "RSA/SHA256, Thu Aug 10 18:11:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.170", "4.el7", "noarch", "elfutils-0.170-4.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Wed Apr 25 10:57:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXxf86vm", "1.1.4", "1.el7", "x86_64", "libXxf86vm-1.1.4-1.el7.src.rpm", 25680, "MIT", "CentOS", "", "X.Org X11 libXxf86vm runtime library", "RSA/SHA256, Thu Aug 10 18:14:17 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mesa-libGL", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 493744, "MIT", "CentOS", "", "Mesa libGL runtime libraries and DRI drivers", "RSA/SHA256, Fri Feb  1 16:21:21 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA256, Fri Jul  4 01:06:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "libglvnd-egl", "1.0.1", "0.8.git5baa1e5.el7", "x86_64", "libglvnd-1.0.1-0.8.git5baa1e5.el7.src.rpm", 84096, "MIT", "CentOS", "", "EGL support for libglvnd", "RSA/SHA256, Mon Nov 12 14:32:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cairo", "1.15.12", "3.el7", "x86_64", "cairo-1.15.12-3.el7.src.rpm", 1894412, "LGPLv2 or MPLv1.1", "CentOS", "", "A 2D graphics library", "RSA/SHA256, Mon Nov 12 14:22:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pango", "1.42.4", "1.el7", "x86_64", "pango-1.42.4-1.el7.src.rpm", 755391, "LGPLv2+", "CentOS", "", "System for layout and rendering of internationalized text", "RSA/SHA256, Mon Nov 12 14:42:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", "Python bindings for the libxml2 library", "RSA/SHA256, Thu Jun 23 20:08:06 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gtk2", "2.24.31", "1.el7", "x86_64", "gtk2-2.24.31-1.el7.src.rpm", 13494501, "LGPLv2+", "CentOS", "", "The GIMP ToolKit (GTK+), a library for creating GUIs for X", "RSA/SHA256, Thu Aug 10 16:30:46 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "graphviz", "2.30.1", "21.el7", "x86_64", "graphviz-2.30.1-21.el7.src.rpm", 4019006, "EPL", "CentOS", "", "Graph Visualization Tools", "RSA/SHA256, Wed Apr 25 11:03:01 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", "Python 2 bindings for GObject Introspection base package", "RSA/SHA256, Tue Nov 21 14:17:15 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-ExtUtils-ParseXS", "3.18", "3.el7", "noarch", "perl-ExtUtils-ParseXS-3.18-3.el7.src.rpm", 178634, "GPL+ or Artistic", "CentOS", "", "Module and a script for converting Perl XS code into C code", "RSA/SHA256, Thu Aug 10 19:06:20 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA256, Fri Jul  4 05:53:04 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-ExtUtils-Install", "1.58", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 76408, "GPL+ or Artistic", "CentOS", "", "Install files from here to there", "RSA/SHA256, Thu Jan 24 13:22:28 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA256, Sun Nov 20 20:16:57 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-ExtUtils-Embed", "1.30", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 17136, "GPL+ or Artistic", "CentOS", "", "Utilities for embedding Perl in C/C++ applications", "RSA/SHA256, Thu Jan 24 13:22:28 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Fri Jul  4 04:39:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xmlto", "0.0.25", "7.el7", "x86_64", "xmlto-0.0.25-7.el7.src.rpm", 108322, "GPLv2+", "CentOS", "", "A tool for converting XML files to various formats", "RSA/SHA256, Fri Jul  4 05:47:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", "Character encoding auto-detection in Python", "RSA/SHA256, Wed Jul 22 20:25:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hmaccalc", "0.9.13", "4.el7", "x86_64", "hmaccalc-0.9.13-4.el7.src.rpm", 102013, "BSD", "CentOS", "", "Tools for computing and checking HMAC values for files", "RSA/SHA256, Fri Jul  4 01:54:33 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", "Utility to set/show the host name or domain name", "RSA/SHA256, Fri Jul  4 01:54:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib-devel", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 135536, "zlib and Boost", "CentOS", "", "Header files and libraries for Zlib development", "RSA/SHA256, Mon Nov 12 14:49:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Wed Nov 25 15:32:05 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-lxml", "3.2.1", "4.el7", "x86_64", "python-lxml-3.2.1-4.el7.src.rpm", 2722705, "BSD", "CentOS", "", "ElementTree-like Python bindings for libxml2 and libxslt", "RSA/SHA256, Fri Jul  4 04:39:58 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "javapackages-tools", "3.4.1", "11.el7", "noarch", "javapackages-tools-3.4.1-11.el7.src.rpm", 160151, "BSD", "CentOS", "", "Macros and scripts for Java packaging support", "RSA/SHA256, Wed Nov 25 14:46:23 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Fri Jul  4 01:44:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xorg-x11-fonts-Type1", "7.5", "9.el7", "noarch", "xorg-x11-fonts-7.5-9.el7.src.rpm", 883992, "MIT and Lucida and Public Domain", "CentOS", "", "Type1 fonts provided by the X Window System", "RSA/SHA256, Fri Jul  4 05:50:09 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 53895, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA256, Thu Aug  2 09:00:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-devel", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 168793, "LGPLv2+", "CentOS", "", "Devel libraries & headers for liblzma", "RSA/SHA256, Sun Nov 20 21:02:43 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-license", "9.9.4", "61.el7_5.1", "noarch", "bind-9.9.4-61.el7_5.1.src.rpm", 26831, "ISC", "CentOS", "", "License of the BIND DNS suite", "RSA/SHA256, Tue Aug 28 12:22:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lksctp-tools", "1.0.17", "2.el7", "x86_64", "lksctp-tools-1.0.17-2.el7.src.rpm", 232487, "GPLv2 and GPLv2+ and LGPLv2 and MIT", "CentOS", "", "User-space access to Linux Kernel SCTP", "RSA/SHA256, Sun Nov 20 19:21:11 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "copy-jdk-configs", "3.3", "10.el7_5", "noarch", "copy-jdk-configs-3.3-10.el7_5.src.rpm", 16264, "BSD", "CentOS", "", "JDKs configuration files copier", "RSA/SHA256, Thu May 10 01:37:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 22399, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA256, Thu Aug  2 09:00:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA256, Fri Jul  4 04:12:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Fri Jul  4 04:50:28 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "slang", "2.2.4", "11.el7", "x86_64", "slang-2.2.4-11.el7.src.rpm", 1881912, "GPLv2+", "CentOS", "", "The shared library for the S-Lang extension language", "RSA/SHA256, Fri Jul  4 05:01:18 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC version 4.8 shared support library", "RSA/SHA256, Tue Mar 19 19:52:12 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.17", "260.el7_6.4", "x86_64", "glibc-2.17-260.el7_6.4.src.rpm", 14346480, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA256, Tue Apr  9 20:22:27 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA256, Mon Nov 12 14:24:07 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Mon Nov 12 14:45:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA256, Mon Nov 12 14:24:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmpc", "1.0.1", "3.el7", "x86_64", "libmpc-1.0.1-3.el7.src.rpm", 113833, "LGPLv3+ and GFDL", "CentOS", "", "C library for multiple precision complex arithmetic", "RSA/SHA256, Fri Jul  4 02:59:41 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 38839, "BSD", "CentOS", "", "A library for integrity verification of FIPS validated modules", "RSA/SHA256, Thu Aug 10 15:53:42 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "net-tools", "2.0", "0.24.20131004git.el7", "x86_64", "net-tools-2.0-0.24.20131004git.el7.src.rpm", 939930, "GPLv2+", "CentOS", "", "Basic networking tools", "RSA/SHA256, Mon Nov 12 14:41:01 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC OpenMP v3.0 shared support library", "RSA/SHA256, Tue Mar 19 19:52:30 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m4", "1.4.16", "10.el7", "x86_64", "m4-1.4.16-10.el7.src.rpm", 525707, "GPLv3+", "CentOS", "", "The GNU macro processor", "RSA/SHA256, Wed Nov 25 15:16:04 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", "Apache Portable Runtime Utility library", "RSA/SHA256, Fri Jul  4 00:39:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", "Parts of the groff formatting system required to display manual pages", "RSA/SHA256, Fri Jul  4 01:45:51 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", "GNU Unicode string library", "RSA/SHA256, Fri Jul  4 03:22:35 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", "A CSS2 parsing library", "RSA/SHA256, Mon Nov 12 14:31:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patch", "2.7.1", "10.el7_5", "x86_64", "patch-2.7.1-10.el7_5.src.rpm", 215449, "GPLv3+", "CentOS", "", "Utility for modifying/upgrading files", "RSA/SHA256, Thu May 10 02:36:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zip", "3.0", "11.el7", "x86_64", "zip-3.0-11.el7.src.rpm", 815173, "BSD", "CentOS", "", "A file compression and packaging utility compatible with PKZIP", "RSA/SHA256, Sun Nov 20 21:04:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA256, Thu Aug 10 16:07:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", "Small, simple, correct HTTP/1.1 client", "RSA/SHA256, Fri Jul  4 04:19:08 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", "Look up Perl documentation in Pod format", "RSA/SHA256, Fri Jul  4 04:22:38 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", "Parse text into an array of tokens or array of arrays", "RSA/SHA256, Fri Jul  4 04:25:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", "Print a usage message from embedded POD documentation", "RSA/SHA256, Fri Jul  4 04:22:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", "Networking constants and support functions", "RSA/SHA256, Sun Nov 20 20:02:40 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", "High resolution alarm, sleep, gettimeofday, interval timers", "RSA/SHA256, Fri Jul  4 04:25:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", "Alternative warn and die for modules", "RSA/SHA256, Fri Jul  4 04:15:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", "Implements default import method for modules", "RSA/SHA256, Fri Jul  4 04:17:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", "Efficiently compute time from local and GMT time", "RSA/SHA256, Fri Jul  4 04:25:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", "Perl extension for sharing data structures between threads", "RSA/SHA256, Fri Jul  4 04:25:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", "Create or remove directory trees", "RSA/SHA256, Fri Jul  4 04:18:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", "A selection of general-utility scalar and list subroutines", "RSA/SHA256, Fri Jul  4 04:23:05 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", "Extended processing of command line options", "RSA/SHA256, Wed Apr 25 11:36:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Thread-Queue", "3.02", "2.el7", "noarch", "perl-Thread-Queue-3.02-2.el7.src.rpm", 27642, "GPL+ or Artistic", "CentOS", "", "Thread-safe queues", "RSA/SHA256, Fri Jul  4 04:25:23 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-TermReadKey", "2.30", "20.el7", "x86_64", "perl-TermReadKey-2.30-20.el7.src.rpm", 59999, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", "A perl module for simple terminal control", "RSA/SHA256, Fri Jul  4 04:23:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "autoconf", "2.69", "11.el7", "noarch", "autoconf-2.69-11.el7.src.rpm", 2320371, "GPLv2+ and GFDL", "CentOS", "", "A GNU tool for automatically configuring source code", "RSA/SHA256, Fri Jul  4 00:42:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Test-Harness", "3.28", "3.el7", "noarch", "perl-Test-Harness-3.28-3.el7.src.rpm", 607239, "GPL+ or Artistic", "CentOS", "", "Run Perl standard test scripts with statistics", "RSA/SHA256, Wed Aug 12 14:33:49 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-debug-devel", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 39270753, "GPLv2", "CentOS", "", "Development package for building kernel modules to match the debug kernel", "RSA/SHA256, Mon Mar 18 15:45:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-thread", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 95658, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost thread library", "RSA/SHA256, Thu Aug 10 15:13:07 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 1995364, "BSD", "CentOS", "", "An open source implementation of SSH protocol versions 1 and 2", "RSA/SHA256, Wed Apr 25 11:32:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 811817, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", "A collection of utilities and DSOs to handle ELF files and DWARF data", "RSA/SHA256, Mon Nov 12 14:24:05 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "A System and Service Manager", "RSA/SHA256, Wed Feb 20 17:14:02 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rsync", "3.1.2", "4.el7", "x86_64", "rsync-3.1.2-4.el7.src.rpm", 834618, "GPLv3+", "CentOS", "", "A program for synchronizing files over a network", "RSA/SHA256, Wed Apr 25 11:44:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 67448, "BSD", "CentOS", "", "A utility for determining file types", "RSA/SHA256, Mon Nov 12 14:25:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dwz", "0.11", "3.el7", "x86_64", "dwz-0.11-3.el7.src.rpm", 225103, "GPLv2+ and GPLv3+", "CentOS", "", "DWARF optimization and duplicate removal tool", "RSA/SHA256, Fri Jul  4 01:10:42 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dyninst", "9.3.1", "2.el7", "x86_64", "dyninst-9.3.1-2.el7.src.rpm", 13049000, "LGPLv2+", "CentOS", "", "An API for Run-time Code Generation", "RSA/SHA256, Mon Nov 12 14:23:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 8436804, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Header files and libraries for C++ development", "RSA/SHA256, Tue Mar 19 19:52:58 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 256362, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA256, Mon Nov 12 14:21:41 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "giflib", "4.1.6", "9.el7", "x86_64", "giflib-4.1.6-9.el7.src.rpm", 90124, "MIT", "CentOS", "", "Library for manipulating GIF format image files", "RSA/SHA256, Fri Jul  4 01:30:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "java-1.8.0-openjdk-devel", "1.8.0.212.b04", "0.el7_6", "x86_64", "java-1.8.0-openjdk-1.8.0.212.b04-0.el7_6.src.rpm", 42212373, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", "OpenJDK Development Environment 8", "RSA/SHA256, Fri Apr 19 14:10:23 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-devel", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 306300, "GPLv2+ or LGPLv3+", "CentOS", "", "Development libraries to handle compiled objects", "RSA/SHA256, Mon Nov 12 14:24:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pciutils-libs", "3.5.1", "3.el7", "x86_64", "pciutils-3.5.1-3.el7.src.rpm", 72691, "GPLv2+", "CentOS", "", "Linux PCI library", "RSA/SHA256, Wed Apr 25 11:34:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.7.5", "77.el7_6", "x86_64", "python-2.7.5-77.el7_6.src.rpm", 80907, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA256, Tue Apr  9 20:22:39 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "newt", "0.52.15", "4.el7", "x86_64", "newt-0.52.15-4.el7.src.rpm", 185196, "LGPLv2", "CentOS", "", "A library for text mode user interfaces", "RSA/SHA256, Fri Jul  4 03:56:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "numactl-devel", "2.0.9", "7.el7", "x86_64", "numactl-2.0.9-7.el7.src.rpm", 25174, "LGPLv2 and GPLv2", "CentOS", "", "Development package for building Applications that use numa", "RSA/SHA256, Wed Apr 25 11:30:25 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-devel", "2.7.5", "77.el7_6", "x86_64", "python-2.7.5-77.el7_6.src.rpm", 1104386, "Python", "CentOS", "", "The libraries and header files needed for Python development", "RSA/SHA256, Tue Apr  9 20:22:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-devel", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 2253171, "MIT", "CentOS", "", "Development files for the ncurses library", "RSA/SHA256, Thu Sep  7 12:43:22 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy", "0.4.11", "11.el7", "x86_64", "libproxy-0.4.11-11.el7.src.rpm", 164014, "LGPLv2+", "CentOS", "", "A library handling all the details of proxy configuration", "RSA/SHA256, Wed Apr 25 11:17:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018e", "3.el7", "noarch", "tzdata-2018e-3.el7.src.rpm", 1966505, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA256, Thu May 10 01:44:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA256, Sun Nov 20 19:23:44 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA256, Thu Sep  7 12:43:10 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git", "1.8.3.1", "20.el7", "x86_64", "git-1.8.3.1-20.el7.src.rpm", 23232282, "GPLv2", "CentOS", "", "Fast Version Control System", "RSA/SHA256, Tue Nov 20 20:34:29 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA256, Wed Apr 25 10:59:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 83791, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Wed Nov 25 14:18:37 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA256, Thu May 17 13:25:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "emacs-filesystem", "24.3", "22.el7", "noarch", "emacs-24.3-22.el7.src.rpm", 0, "GPLv3+", "CentOS", "", "Emacs filesystem layout", "RSA/SHA256, Mon Nov 12 15:16:01 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Nov 20 18:39:28 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 39238921, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Various compilers (C, C++, Objective-C, Java, ...)", "RSA/SHA256, Tue Mar 19 19:51:11 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.5", "8.1.el7", "x86_64", "libsepol-2.5-8.1.el7.src.rpm", 686568, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Apr 25 11:22:09 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-rpm-config", "9.1.0", "87.el7.centos", "noarch", "redhat-rpm-config-9.1.0-87.el7.centos.src.rpm", 174572, "GPL+", "CentOS", "", "CentOS specific rpm configuration files", "RSA/SHA256, Mon Nov 12 15:19:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA256, Thu Jun 29 12:40:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 328409, "GPLv2+", "CentOS", "", "Scripts and executable programs used to build packages", "RSA/SHA256, Mon Nov 12 14:45:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA256, Thu Aug 10 16:26:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-c++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 17257523, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "C++ support for GCC", "RSA/SHA256, Tue Mar 19 19:51:13 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", "Main loop abstraction library", "RSA/SHA256, Fri Jul  4 03:23:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "flex", "2.5.37", "6.el7", "x86_64", "flex-2.5.37-6.el7.src.rpm", 757468, "BSD and LGPLv2+", "CentOS", "", "A tool for creating scanners (text pattern recognizers)", "RSA/SHA256, Mon Nov 12 14:25:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.0.2k", "12.el7", "x86_64", "openssl-1.0.2k-12.el7.src.rpm", 3200172, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Wed Apr 25 11:33:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "doxygen", "1.8.5", "3.el7", "x86_64", "doxygen-1.8.5-3.el7.src.rpm", 15389684, "GPL+", "CentOS", "", "A documentation system for C/C++", "RSA/SHA256, Fri Jul  4 01:09:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Sun Nov 20 21:02:51 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "byacc", "1.9.20130304", "3.el7", "x86_64", "byacc-1.9.20130304-3.el7.src.rpm", 135161, "Public Domain", "CentOS", "", "Berkeley Yacc, a parser generator", "RSA/SHA256, Fri Jul  4 00:54:37 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA256, Fri Jul  4 02:49:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "freetype", "2.8", "12.el7_6.1", "x86_64", "freetype-2.8-12.el7_6.1.src.rpm", 824497, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", "A free and portable font rendering engine", "RSA/SHA256, Fri Feb  1 16:19:35 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Nov 20 19:22:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mesa-libglapi", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 204320, "MIT", "CentOS", "", "Mesa shared glapi", "RSA/SHA256, Fri Feb  1 16:21:22 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 273965, "LGPLv2+", "CentOS", "", "Device mounting library", "RSA/SHA256, Mon Aug 20 14:15:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxshmfence", "1.2", "1.el7", "x86_64", "libxshmfence-1.2-1.el7.src.rpm", 11160, "MIT", "CentOS", "", "X11 shared memory fences", "RSA/SHA256, Wed Nov 25 15:14:50 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA256, Wed Apr 25 11:04:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontpackages-filesystem", "1.44", "8.el7", "noarch", "fontpackages-1.44-8.el7.src.rpm", 0, "Public Domain", "CentOS", "", "Directories used by font packages", "RSA/SHA256, Fri Jul  4 01:22:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Fri Jul  4 01:08:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontconfig", "2.13.0", "4.3.el7", "x86_64", "fontconfig-2.13.0-4.3.el7.src.rpm", 666475, "MIT and Public Domain and UCD", "CentOS", "", "Font configuration and customization library", "RSA/SHA256, Mon Nov 12 14:25:25 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-fonts", "2.4", "16.el7", "noarch", "urw-fonts-2.4-16.el7.src.rpm", 4389400, "GPL+", "CentOS", "", "Free versions of the 35 standard PostScript fonts.", "RSA/SHA256, Fri Jul  4 05:38:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA256, Thu May 17 13:25:42 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jbigkit-libs", "2.0", "11.el7", "x86_64", "jbigkit-2.0-11.el7.src.rpm", 105882, "GPLv2+", "CentOS", "", "JBIG1 lossless image compression library", "RSA/SHA256, Fri Jul  4 02:13:43 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", "GnuPG IPC library", "RSA/SHA256, Fri Jul  4 02:35:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcsc-lite", "1.8.8", "8.el7", "x86_64", "pcsc-lite-1.8.8-8.el7.src.rpm", 634433, "BSD", "CentOS", "", "PC/SC Lite smart card framework and applications", "RSA/SHA256, Mon Nov 12 14:43:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyparsing", "1.5.6", "9.el7", "noarch", "pyparsing-1.5.6-9.el7.src.rpm", 375948, "MIT", "CentOS", "", "An object-oriented approach to text processing", "RSA/SHA256, Fri Jul  4 04:37:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-regex", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 2122578, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost regular expression library", "RSA/SHA256, Thu Aug 10 15:12:15 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Fri Jul  4 04:28:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libwayland-client", "1.15.0", "1.el7", "x86_64", "wayland-1.15.0-1.el7.src.rpm", 64076, "MIT", "CentOS", "", "Wayland client library", "RSA/SHA256, Mon Nov 12 14:39:00 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Wed Apr 25 10:56:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "harfbuzz", "1.7.5", "2.el7", "x86_64", "harfbuzz-1.7.5-2.el7.src.rpm", 709362, "MIT", "CentOS", "", "Text shaping library", "RSA/SHA256, Mon Nov 12 14:28:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 435192, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA256, Wed Apr 25 11:12:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hwdata", "0.252", "9.1.el7", "x86_64", "hwdata-0.252-9.1.el7.src.rpm", 13726739, "GPLv2+", "CentOS", "", "Hardware identification and configuration data", "RSA/SHA256, Mon Nov 12 14:28:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.44", "15.el7_5", "x86_64", "openldap-2.4.44-15.el7_5.src.rpm", 1037299, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA256, Thu May 17 13:26:00 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sgml-common", "0.6.3", "39.el7", "noarch", "sgml-common-0.6.3-39.el7.src.rpm", 170882, "GPL+", "CentOS", "", "Common SGML catalog and DTD files", "RSA/SHA256, Fri Jul  4 04:59:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA256, Sun Nov 20 20:05:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcb", "1.13", "1.el7", "x86_64", "libxcb-1.13-1.el7.src.rpm", 1011680, "MIT", "CentOS", "", "A C binding to the X11 protocol", "RSA/SHA256, Mon Nov 12 14:39:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.5", "11.el7", "x86_64", "libsemanage-2.5-11.el7.src.rpm", 302369, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Apr 25 11:22:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXfixes", "5.0.3", "1.el7", "x86_64", "libXfixes-5.0.3-1.el7.src.rpm", 26903, "MIT", "CentOS", "", "X Fixes library", "RSA/SHA256, Thu Aug 10 18:10:32 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", "QR Code encoding library - Shared libraries", "RSA/SHA256, Fri Jul  4 04:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXmu", "1.1.2", "2.el7", "x86_64", "libXmu-1.1.2-2.el7.src.rpm", 172054, "MIT", "CentOS", "", "X.Org X11 libXmu/libXmuu runtime libraries", "RSA/SHA256, Wed Nov 25 15:14:31 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps-ng", "3.3.10", "17.el7_5.2", "x86_64", "procps-ng-3.3.10-17.el7_5.2.src.rpm", 760500, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA256, Fri May 25 00:56:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ghostscript", "9.07", "31.el7_6.10", "x86_64", "ghostscript-9.07-31.el7_6.10.src.rpm", 17357534, "AGPLv3+ and Redistributable, no modification permitted", "CentOS", "", "A PostScript interpreter and renderer", "RSA/SHA256, Mon Mar 25 11:31:31 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 243127, "GPLv2+", "CentOS", "", "Linux kernel module management utilities", "RSA/SHA256, Wed Apr 25 11:10:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXft", "2.3.2", "2.el7", "x86_64", "libXft-2.3.2-2.el7.src.rpm", 125933, "MIT", "CentOS", "", "X.Org X11 libXft runtime library", "RSA/SHA256, Wed Nov 25 15:14:11 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "libglvnd-glx", "1.0.1", "0.8.git5baa1e5.el7", "x86_64", "libglvnd-1.0.1-0.8.git5baa1e5.el7.src.rpm", 657304, "MIT", "CentOS", "", "GLX support for libglvnd", "RSA/SHA256, Mon Nov 12 14:32:23 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA256, Thu Aug 10 16:47:33 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mesa-libEGL", "18.0.5", "4.el7_6", "x86_64", "mesa-18.0.5-4.el7_6.src.rpm", 232401, "MIT", "CentOS", "", "Mesa libEGL runtime libraries", "RSA/SHA256, Fri Feb  1 16:21:18 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "librsvg2", "2.40.20", "1.el7", "x86_64", "librsvg2-2.40.20-1.el7.src.rpm", 308951, "LGPLv2+", "CentOS", "", "An SVG library based on cairo", "RSA/SHA256, Mon Nov 12 14:37:23 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-devel", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 129076, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "C development files for the Berkeley DB library", "RSA/SHA256, Wed Apr 25 11:12:51 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-devel", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1930081, "GPL+ or Artistic", "CentOS", "", "Header #files for use in perl development", "RSA/SHA256, Thu Jan 24 13:22:15 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.10", "8.el7", "noarch", "python-urlgrabber-3.10-8.el7.src.rpm", 500670, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA256, Sun Nov 20 20:18:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pesign", "0.109", "10.el7", "x86_64", "pesign-0.109-10.el7.src.rpm", 368213, "GPLv2", "CentOS", "", "Signing utility for UEFI binaries", "RSA/SHA256, Sun Nov 20 20:03:01 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", "Small, useful pieces of code to make python coding easier", "RSA/SHA256, Fri Jul  4 04:39:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf-devel", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 32387, "GPLv2+ or LGPLv3+", "CentOS", "", "Development support for libelf", "RSA/SHA256, Mon Nov 12 14:24:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA256, Fri Jul 13 15:56:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ttmkfdir", "3.0.9", "42.el7", "x86_64", "ttmkfdir-3.0.9-42.el7.src.rpm", 105418, "LGPLv2+", "CentOS", "", "Utility to create fonts.scale files for truetype fonts", "RSA/SHA256, Wed Nov 25 16:01:37 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Fri Jul  4 04:36:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata-java", "2019a", "1.el7", "noarch", "tzdata-2019a-1.el7.src.rpm", 374277, "Public Domain", "CentOS", "", "Timezone data for Java", "RSA/SHA256, Mon Apr  1 17:24:26 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "java-1.8.0-openjdk-headless", "1.8.0.212.b04", "0.el7_6", "x86_64", "java-1.8.0-openjdk-1.8.0.212.b04-0.el7_6.src.rpm", 108711819, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", "OpenJDK Headless Runtime Environment 8", "RSA/SHA256, Fri Apr 19 14:10:26 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "java-1.8.0-openjdk", "1.8.0.212.b04", "0.el7_6", "x86_64", "java-1.8.0-openjdk-1.8.0.212.b04-0.el7_6.src.rpm", 541844, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", "OpenJDK Runtime Environment 8", "RSA/SHA256, Fri Apr 19 14:10:17 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils-devel", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 4540848, "GPLv3+", "CentOS", "", "BFD and opcodes static and dynamic libraries and header files", "RSA/SHA256, Mon Nov 12 14:22:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", "gpg(CentOS-7 Key (CentOS 7 Official Signing Key) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pciutils", "3.5.1", "3.el7", "x86_64", "pciutils-3.5.1-3.el7.src.rpm", 200397, "GPLv2+", "CentOS", "", "PCI bus related utilities", "RSA/SHA256, Wed Apr 25 11:34:14 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA256, Tue Mar 19 19:52:58 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "numactl-libs", "2.0.9", "7.el7", "x86_64", "numactl-2.0.9-7.el7.src.rpm", 50752, "LGPLv2 and GPLv2", "CentOS", "", "libnuma libraries", "RSA/SHA256, Wed Apr 25 11:30:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA256, Mon Nov 12 14:25:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pciutils-devel", "3.5.1", "3.el7", "x86_64", "pciutils-3.5.1-3.el7.src.rpm", 78345, "GPLv2+", "CentOS", "", "Linux PCI development library", "RSA/SHA256, Wed Apr 25 11:34:15 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Mon Nov 12 14:45:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", "Apache Portable Runtime library", "RSA/SHA256, Tue Nov 28 22:16:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-system", "1.53.0", "27.el7", "x86_64", "boost-1.53.0-27.el7.src.rpm", 32538, "Boost and MIT and Python", "CentOS", "", "Run-Time component of boost system support library", "RSA/SHA256, Thu Aug 10 15:12:51 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "avahi-libs", "0.6.31", "19.el7", "x86_64", "avahi-0.6.31-19.el7.src.rpm", 123808, "LGPLv2+", "CentOS", "", "Libraries for avahi run-time use", "RSA/SHA256, Wed Apr 25 10:53:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", "A JSON implementation in C", "RSA/SHA256, Sat Jul  5 15:25:00 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", "Establish an ISA relationship with base classes at compile time", "RSA/SHA256, Fri Jul  4 04:21:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", "Perl module for resolving POD escape sequences", "RSA/SHA256, Thu Jan 24 13:22:34 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", "The libraries for the perl runtime", "RSA/SHA256, Thu Jan 24 13:22:16 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", "Perl interpreter-based threads", "RSA/SHA256, Fri Jul  4 04:25:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", "Perl pragma to declare constants", "RSA/SHA256, Fri Jul  4 04:15:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", "Return name and handle of a temporary file safely", "RSA/SHA256, Fri Jul  4 04:18:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA256, Fri Jul  4 04:22:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Error", "0.17020", "2.el7", "noarch", "perl-Error-0.17020-2.el7.src.rpm", 50015, "(GPL+ or Artistic) and MIT", "CentOS", "", "Error/exception handling in an OO-ish way", "RSA/SHA256, Fri Jul  4 04:17:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-XML-Parser", "2.41", "10.el7", "x86_64", "perl-XML-Parser-2.41-10.el7.src.rpm", 642973, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing XML documents", "RSA/SHA256, Fri Jul  4 04:26:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "458", "9.el7", "x86_64", "less-458-9.el7.src.rpm", 215376, "GPLv3+", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA256, Thu Jul 30 23:52:46 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 15644861, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "The C Preprocessor", "RSA/SHA256, Tue Mar 19 19:51:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "trousers", "0.3.14", "2.el7", "x86_64", "trousers-0.3.14-2.el7.src.rpm", 836873, "BSD", "CentOS", "", "TCG's Software Stack v1.2", "RSA/SHA256, Thu Aug 10 20:09:49 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdwarf", "20130207", "4.el7", "x86_64", "libdwarf-20130207-4.el7.src.rpm", 291679, "LGPLv2", "CentOS", "", "Library to access the DWARF Debugging file format", "RSA/SHA256, Sat Mar 14 08:00:51 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-runtime", "3.3", "3.el7", "x86_64", "systemtap-3.3-3.el7.src.rpm", 1142954, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - runtime", "RSA/SHA256, Mon Nov 12 14:47:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:7 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/(none)/0/g"
	CentOS7Plain = []*PackageInfo{
		{intRef(), "tzdata", "2018e", "3.el7", "noarch", "tzdata-2018e-3.el7.src.rpm", 1966505, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA256, Thu May 10 01:44:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA256, Thu May 17 13:25:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA256, Thu Sep  7 12:43:10 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.17", "222.el7", "x86_64", "glibc-2.17-222.el7.src.rpm", 120325207, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA256, Wed Apr 25 11:01:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA256, Wed Apr 25 10:59:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.17", "222.el7", "x86_64", "glibc-2.17-222.el7.src.rpm", 14223248, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA256, Wed Apr 25 11:01:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA256, Thu May 17 13:25:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Fri Jul  4 04:33:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Nov 20 18:39:28 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Thu Aug 10 17:02:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.5", "8.1.el7", "x86_64", "libsepol-2.5-8.1.el7.src.rpm", 686568, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Apr 25 11:22:09 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA256, Thu Sep  7 12:43:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA256, Thu Jun 29 12:40:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.5", "12.el7", "x86_64", "libselinux-2.5-12.el7.src.rpm", 217874, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA256, Thu Apr 26 12:47:14 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA256, Thu Aug 10 16:26:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA256, Fri Jul  4 02:30:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", "Main loop abstraction library", "RSA/SHA256, Fri Jul  4 03:23:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA256, Thu Aug 10 18:44:50 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.0.2k", "12.el7", "x86_64", "openssl-1.0.2k-12.el7.src.rpm", 3200172, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Wed Apr 25 11:33:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "7", "5.1804.4.el7.centos", "x86_64", "centos-release-7-5.1804.4.el7.centos.src.rpm", 40338, "GPLv2", "CentOS", "", "CentOS Linux release file", "RSA/SHA256, Mon Aug 13 15:10:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Sun Nov 20 21:02:51 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Apr 25 11:12:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA256, Fri Jul  4 02:49:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA256, Thu Aug 10 17:08:59 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Nov 20 19:22:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 20326, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Mon Aug 20 14:15:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 273965, "LGPLv2+", "CentOS", "", "Device mounting library", "RSA/SHA256, Mon Aug 20 14:15:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA256, Wed Apr 25 11:46:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA256, Wed Apr 25 11:04:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.5.11", "5.el7", "x86_64", "findutils-4.5.11-5.el7.src.rpm", 1855626, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Wed Nov 25 14:29:59 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Fri Jul  4 01:08:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA256, Mon Nov 28 22:32:05 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.8.1", "3.el7_5.1", "x86_64", "audit-2.8.1-3.el7_5.1.src.rpm", 256370, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA256, Mon Aug 20 14:14:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Wed Apr 25 11:33:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA256, Thu May 17 13:25:42 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2424993, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA256, Fri Sep 28 11:34:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", "GnuPG IPC library", "RSA/SHA256, Fri Jul  4 02:35:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.11", "33.el7", "x86_64", "file-5.11-33.el7.src.rpm", 3077690, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA256, Sun Nov 20 17:42:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Fri Jul  4 04:28:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Wed Apr 25 10:56:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.27", "28.base.el7_5.1", "x86_64", "binutils-2.27-28.base.el7_5.1.src.rpm", 25149789, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA256, Tue Jul  3 14:31:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 435192, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA256, Wed Apr 25 11:12:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 611384, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Wed Apr 25 11:44:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.44", "15.el7_5", "x86_64", "openldap-2.4.44-15.el7_5.src.rpm", 1037299, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA256, Thu May 17 13:26:00 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA256, Sun Nov 20 20:05:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.5", "11.el7", "x86_64", "libsemanage-2.5-11.el7.src.rpm", 302369, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Apr 25 11:22:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Fri Jul  4 03:23:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", "QR Code encoding library - Shared libraries", "RSA/SHA256, Fri Jul  4 04:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 338922, "GPLv2", "CentOS", "", "Device mapper utility", "RSA/SHA256, Wed Apr 25 10:57:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps-ng", "3.3.10", "17.el7_5.2", "x86_64", "procps-ng-3.3.10-17.el7_5.2.src.rpm", 760500, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA256, Fri May 25 00:56:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "1.7.4", "4.el7", "x86_64", "cryptsetup-1.7.4-4.el7.src.rpm", 969908, "GPLv2+ and LGPLv2+", "CentOS", "", "Cryptsetup shared library", "RSA/SHA256, Wed Apr 25 10:56:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 243127, "GPLv2+", "CentOS", "", "Linux kernel module management utilities", "RSA/SHA256, Wed Apr 25 11:10:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "219", "57.el7_5.3", "x86_64", "systemd-219-57.el7_5.3.src.rpm", 1263552, "LGPLv2+ and MIT", "CentOS", "", "systemd libraries", "RSA/SHA256, Fri Sep 28 11:34:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "219", "57.el7_5.3", "x86_64", "systemd-219-57.el7_5.3.src.rpm", 24402038, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "A System and Service Manager", "RSA/SHA256, Fri Sep 28 11:34:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 595223, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Wed Apr 25 10:57:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA256, Thu Aug 10 16:47:33 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Fri Jul  4 01:27:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 80907, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA256, Fri Jul 13 15:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", "D-Bus Python Bindings", "RSA/SHA256, Fri Jul  4 01:06:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", "Python bindings for lzma", "RSA/SHA256, Fri Jul  4 04:37:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.10", "8.el7", "noarch", "python-urlgrabber-3.10-8.el7.src.rpm", 500670, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA256, Sun Nov 20 20:18:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", "Extended attributes library wrapper for Python", "RSA/SHA256, Fri Jul  4 04:43:07 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", "Small, useful pieces of code to make python coding easier", "RSA/SHA256, Fri Jul  4 04:39:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA256, Fri Jul 13 15:56:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 149714, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA256, Wed Apr 25 11:44:57 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Fri Jul  4 04:36:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.4.3", "158.el7.centos", "noarch", "yum-3.4.3-158.el7.centos.src.rpm", 5814102, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA256, Wed Apr 25 11:52:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-utils", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 343422, "GPLv2+", "CentOS", "", "Utilities based around the yum package manager", "RSA/SHA256, Thu Aug  2 09:01:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.160", "4.el7", "x86_64", "vim-7.4.160-4.el7.src.rpm", 917640, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA256, Wed Apr 25 11:50:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.8.5", "28.el7_5.1", "x86_64", "gcc-4.8.5-28.el7_5.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC version 4.8 shared support library", "RSA/SHA256, Thu May 17 13:22:34 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA256, Thu Sep  7 12:43:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.2.46", "30.el7", "x86_64", "bash-4.2.46-30.el7.src.rpm", 3667709, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA256, Wed Apr 25 10:54:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Thu Aug 10 15:17:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.71", "9.el7", "noarch", "setup-2.8.71-9.el7.src.rpm", 696925, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA256, Wed Apr 25 11:46:38 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple CentOS Linux system", "RSA/SHA256, Fri Jul  4 00:46:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.7", "17.el7", "x86_64", "zlib-1.2.7-17.el7.src.rpm", 185710, "zlib and Boost", "CentOS", "", "The compression and decompression library", "RSA/SHA256, Sun Nov 20 21:05:07 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.el7_5", "x86_64", "nss-util-3.36.0-1.el7_5.src.rpm", 194944, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA256, Thu May 17 13:25:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.42.9", "12.el7_5", "x86_64", "e2fsprogs-1.42.9-12.el7_5.src.rpm", 60489, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Thu May 17 13:22:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA256, Wed Apr 25 11:11:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA256, Wed Apr 25 11:10:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.8.5", "28.el7_5.1", "x86_64", "gcc-4.8.5-28.el7_5.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA256, Thu May 17 13:23:40 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Wed Apr 25 11:05:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Thu Aug 10 19:04:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", "A GNU stream text editor", "RSA/SHA256, Fri Jul  4 04:58:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Thu Aug 10 18:44:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA256, Thu Aug 10 16:14:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Thu Aug 10 17:58:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Thu May 17 13:16:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.22", "21.el7", "x86_64", "coreutils-8.22-21.el7.src.rpm", 14588989, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Wed Apr 25 10:55:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.15.1", "19.el7", "x86_64", "krb5-1.15.1-19.el7.src.rpm", 1984782, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Thu May 10 02:35:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Nov 25 14:18:43 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.170", "4.el7", "x86_64", "elfutils-0.170-4.el7.src.rpm", 936931, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA256, Wed Apr 25 10:58:05 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA256, Thu Jun 23 20:07:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA256, Thu Aug 10 19:38:52 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA256, Wed Apr 25 10:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 261837, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA256, Mon Aug 20 14:15:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.54.2", "2.el7", "x86_64", "glib2-2.54.2-2.el7.src.rpm", 11986873, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA256, Wed Apr 25 11:01:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA256, Wed Nov 25 15:40:39 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Fri Jul  4 01:02:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Wed Nov 25 14:58:28 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Wed Nov 25 14:52:00 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Fri Jul  4 01:02:17 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", "A library for password generation and password quality checking", "RSA/SHA256, Wed Apr 25 11:17:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 14061, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA256, Fri Sep 28 11:34:18 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-pem", "1.0.3", "4.el7", "x86_64", "nss-pem-1.0.3-4.el7.src.rpm", 201219, "MPLv1.1", "CentOS", "", "PEM file reader for Network Security Services (NSS)", "RSA/SHA256, Thu Aug 10 18:33:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA256, Sun Nov 20 21:02:26 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", "Extremely fast compression algorithm", "RSA/SHA256, Wed Apr 25 11:26:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "7.el7_5", "x86_64", "nss-3.36.0-7.el7_5.src.rpm", 2069571, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA256, Fri Sep 28 11:34:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.50.0", "1.el7", "x86_64", "gobject-introspection-1.50.0-1.el7.src.rpm", 834149, "GPLv2+, LGPLv2+, MIT", "CentOS", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Thu Aug 10 16:25:03 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Wed Apr 25 11:13:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "20", "21.el7", "x86_64", "kmod-20-21.el7.src.rpm", 91800, "LGPLv2+", "CentOS", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Wed Apr 25 11:10:17 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.3", "10.el7_2.1", "x86_64", "libssh2-1.4.3-10.el7_2.1.src.rpm", 341782, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA256, Thu Mar 10 12:07:48 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.29.0", "46.el7", "x86_64", "curl-7.29.0-46.el7.src.rpm", 540259, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Wed Apr 25 10:56:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 2621900, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA256, Wed Apr 25 11:44:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA256, Wed Apr 25 11:23:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.26", "34.el7", "x86_64", "tar-1.26-34.el7.src.rpm", 2838271, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA256, Wed Apr 25 11:48:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", "Access control list utilities", "RSA/SHA256, Wed Apr 25 10:52:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Fri Jul  4 05:39:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "24.el7", "x86_64", "shadow-utils-4.1.5.1-24.el7.src.rpm", 3534490, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Sun Nov 20 20:44:19 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", "Create a tree of hardlinks", "RSA/SHA256, Fri Jul  4 01:53:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.23.2", "52.el7_5.1", "x86_64", "util-linux-2.23.2-52.el7_5.1.src.rpm", 8642769, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA256, Mon Aug 20 14:17:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kpartx", "0.4.9", "119.el7_5.1", "x86_64", "device-mapper-multipath-0.4.9-119.el7_5.1.src.rpm", 41363, "GPL+", "CentOS", "", "Partition device manager for device-mapper devices", "RSA/SHA256, Mon Aug 20 14:15:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper-libs", "1.02.146", "4.el7", "x86_64", "lvm2-2.02.177-4.el7.src.rpm", 400551, "LGPLv2", "CentOS", "", "Device-mapper shared library", "RSA/SHA256, Wed Apr 25 10:57:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut", "033", "535.el7_5.1", "x86_64", "dracut-033-535.el7_5.1.src.rpm", 898198, "GPLv2+ and LGPLv2+", "CentOS", "", "Initramfs generator using udev", "RSA/SHA256, Mon Aug 20 14:14:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.170", "4.el7", "x86_64", "elfutils-0.170-4.el7.src.rpm", 747527, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA256, Wed Apr 25 10:58:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.10.24", "7.el7", "x86_64", "dbus-1.10.24-7.el7.src.rpm", 362584, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA256, Wed Apr 25 10:57:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.170", "4.el7", "noarch", "elfutils-0.170-4.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Wed Apr 25 10:57:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA256, Fri Jul  4 01:06:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.7.5", "69.el7_5", "x86_64", "python-2.7.5-69.el7_5.src.rpm", 24713084, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA256, Fri Jul 13 15:56:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", "Python bindings for the libxml2 library", "RSA/SHA256, Thu Jun 23 20:08:06 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", "Python 2 bindings for GObject Introspection base package", "RSA/SHA256, Tue Nov 21 14:17:15 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA256, Fri Jul  4 05:53:04 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA256, Sun Nov 20 20:16:57 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Fri Jul  4 04:39:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", "Character encoding auto-detection in Python", "RSA/SHA256, Wed Jul 22 20:25:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", "Utility to set/show the host name or domain name", "RSA/SHA256, Fri Jul  4 01:54:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Wed Nov 25 15:32:05 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.11.3", "32.el7", "x86_64", "rpm-4.11.3-32.el7.src.rpm", 166664, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Wed Apr 25 11:44:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Fri Jul  4 01:44:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 53895, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA256, Thu Aug  2 09:00:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-license", "9.9.4", "61.el7_5.1", "noarch", "bind-9.9.4-61.el7_5.1.src.rpm", 26831, "ISC", "CentOS", "", "License of the BIND DNS suite", "RSA/SHA256, Tue Aug 28 12:22:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.31", "46.el7_5", "noarch", "yum-utils-1.1.31-46.el7_5.src.rpm", 22399, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA256, Thu Aug  2 09:00:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA256, Fri Jul  4 04:12:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Fri Jul  4 04:50:28 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos/python-35-centos7 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS7Python35 = []*PackageInfo{
		{intRef(), "fontconfig-devel", "2.13.0", "4.3.el7", "x86_64", "fontconfig-2.13.0-4.3.el7.src.rpm", 111050, "MIT and Public Domain and UCD", "CentOS", "", "Font configuration and customization library", "RSA/SHA256, Mon Nov 12 14:25:25 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-license", "9.9.4", "73.el7_6", "noarch", "bind-9.9.4-73.el7_6.src.rpm", 26831, "ISC", "CentOS", "", "License of the BIND DNS suite", "RSA/SHA256, Fri Feb  1 16:26:11 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "458", "9.el7", "x86_64", "less-458-9.el7.src.rpm", 215376, "GPLv3+", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA256, Thu Jul 30 23:52:46 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2-devel", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 9213393, "MIT", "CentOS", "", "Libraries, includes, etc. to develop XML and HTML applications", "RSA/SHA256, Thu Jun 23 20:08:02 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.2.46", "31.el7", "x86_64", "bash-4.2.46-31.el7.src.rpm", 3667773, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA256, Mon Nov 12 14:21:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 8460215, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA256, Tue Mar 19 19:54:30 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 120499441, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA256, Fri Feb  1 16:19:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxslt", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 497582, "MIT", "CentOS", "", "Library providing the Gnome XSLT engine", "RSA/SHA256, Fri Jul  4 03:32:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 565628, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA256, Thu May 17 13:25:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-headers", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 2338328, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Header files for development using standard C libraries.", "RSA/SHA256, Fri Feb  1 16:19:43 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.2", "25.el7", "x86_64", "filesystem-3.2-25.el7.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA256, Wed Apr 25 10:59:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 39238921, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Various compilers (C, C++, Objective-C, Java, ...)", "RSA/SHA256, Tue Mar 19 19:51:11 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 14346456, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "The GNU libc libraries", "RSA/SHA256, Fri Feb  1 16:19:40 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "autoconf", "2.69", "11.el7", "noarch", "autoconf-2.69-11.el7.src.rpm", 2320371, "GPLv2+ and GFDL", "CentOS", "", "A GNU tool for automatically configuring source code", "RSA/SHA256, Fri Jul  4 00:42:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.19.0", "1.el7_5", "x86_64", "nspr-4.19.0-1.el7_5.src.rpm", 287728, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA256, Thu May 17 13:25:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11-common", "1.6.5", "2.el7", "noarch", "libX11-1.6.5-2.el7.src.rpm", 1335662, "MIT", "CentOS", "", "Common data for libX11", "RSA/SHA256, Mon Nov 12 15:18:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.13", "16.el7", "x86_64", "popt-1.13-16.el7.src.rpm", 88516, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Fri Jul  4 04:33:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXpm", "3.5.12", "1.el7", "x86_64", "libXpm-3.5.12-1.el7.src.rpm", 116599, "MIT", "CentOS", "", "X.Org X11 libXpm runtime library", "RSA/SHA256, Thu Aug 10 18:12:27 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.42.9", "13.el7", "x86_64", "e2fsprogs-1.42.9-13.el7.src.rpm", 60489, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Mon Nov 12 14:31:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gd", "2.0.35", "26.el7", "x86_64", "gd-2.0.35-26.el7.src.rpm", 554528, "MIT", "CentOS", "", "A graphics library for quick creation of PNG or JPEG images", "RSA/SHA256, Fri Jul  4 01:27:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.22", "9.el7", "x86_64", "libcap-2.22-9.el7.src.rpm", 111445, "LGPLv2+", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Thu Aug 10 17:02:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXt", "1.1.5", "3.el7", "x86_64", "libXt-1.1.5-3.el7.src.rpm", 430105, "MIT", "CentOS", "", "X.Org X11 libXt runtime library", "RSA/SHA256, Thu Aug 10 18:13:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libkadm5", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 221096, "MIT", "CentOS", "", "Kerberos 5 Administrative libraries", "RSA/SHA256, Fri Feb  1 16:20:26 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "5.1", "5.el7", "x86_64", "texinfo-5.1-5.el7.src.rpm", 494630, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Wed Apr 25 11:05:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs-devel", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 29186, "GPLv2+ and LGPLv2+", "CentOS", "", "Development package for building Linux key management utilities", "RSA/SHA256, Fri Jul  4 02:31:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.0.2", "4.el7_3.1", "x86_64", "gawk-4.0.2-4.el7_3.1.src.rpm", 2435978, "GPLv3+ and GPL and LGPLv3+ and LGPL and BSD", "CentOS", "", "The GNU version of the awk text processing utility", "RSA/SHA256, Thu Jun 29 12:40:37 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt-devel", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 220369, "LGPLv2+ and GPLv2+", "CentOS", "", "Development files for the libgcrypt package", "RSA/SHA256, Thu Aug 10 17:09:07 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 217874, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA256, Mon Nov 12 14:37:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh-clients", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 2651616, "BSD", "CentOS", "", "An open source SSH client applications", "RSA/SHA256, Wed Apr 25 11:32:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "2.20", "3.el7", "x86_64", "grep-2.20-3.el7.src.rpm", 1195131, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA256, Thu Aug 10 16:26:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git", "1.8.3.1", "20.el7", "x86_64", "git-1.8.3.1-20.el7.src.rpm", 23232282, "GPLv2", "CentOS", "", "Fast Version Control System", "RSA/SHA256, Tue Nov 20 20:34:29 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.8", "3.el7", "x86_64", "keyutils-1.5.8-3.el7.src.rpm", 42138, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA256, Fri Jul  4 02:30:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-devel", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 194101, "Public Domain", "CentOS", "", "Header files and libraries used to build SELinux", "RSA/SHA256, Mon Nov 12 14:37:28 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 23060, "MIT", "CentOS", "", "Main loop abstraction library", "RSA/SHA256, Fri Jul  4 03:23:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-devel", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 796853, "MIT", "CentOS", "", "Development files needed to compile Kerberos 5 programs", "RSA/SHA256, Fri Feb  1 16:20:17 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 437261, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA256, Thu Aug 10 18:44:50 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "mariadb-devel", "5.5.60", "1.el7_5", "x86_64", "mariadb-5.5.60-1.el7_5.src.rpm", 3478237, "GPLv2 with exceptions and LGPLv2 and BSD", "CentOS", "", "Files for development of MariaDB/MySQL applications", "RSA/SHA256, Mon Aug 20 14:16:23 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gd-devel", "2.0.35", "26.el7", "x86_64", "gd-2.0.35-26.el7.src.rpm", 300168, "MIT", "CentOS", "", "The development libraries and header files for gd", "RSA/SHA256, Fri Jul  4 01:27:35 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.15.1", "37.el7_6", "x86_64", "krb5-1.15.1-37.el7_6.src.rpm", 2200985, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Fri Feb  1 16:20:18 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-c++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 17257523, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "C++ support for GCC", "RSA/SHA256, Tue Mar 19 19:51:13 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 239967, "LGPLv2+", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Sun Nov 20 21:02:51 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb", "7.6.1", "114.el7", "x86_64", "gdb-7.6.1-114.el7.src.rpm", 7371507, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and BSD and Public Domain", "CentOS", "", "A GNU source-level debugger for C, C++, Fortran, Go and other languages", "RSA/SHA256, Mon Nov 12 14:25:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 1858008, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Apr 25 11:12:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lsof", "4.87", "6.el7", "x86_64", "lsof-4.87-6.el7.src.rpm", 949035, "zlib and Sendmail and LGPLv2+", "CentOS", "", "A utility which lists open files on a Linux/UNIX system", "RSA/SHA256, Mon Nov 12 14:39:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 350865, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA256, Fri Jul  4 02:49:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patch", "2.7.1", "10.el7_5", "x86_64", "patch-2.7.1-10.el7_5.src.rpm", 215449, "GPLv3+", "CentOS", "", "Utility for modifying/upgrading files", "RSA/SHA256, Thu May 10 02:36:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.5.3", "14.el7", "x86_64", "libgcrypt-1.5.3-14.el7.src.rpm", 597727, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA256, Thu Aug 10 17:08:59 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 83791, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Wed Nov 25 14:18:37 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.1.4", "15.el7", "x86_64", "lua-5.1.4-15.el7.src.rpm", 640319, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Sun Nov 20 19:22:38 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "which", "2.20", "7.el7", "x86_64", "which-2.20-7.el7.src.rpm", 76962, "GPLv3", "CentOS", "", "Displays where a particular program in your path is located", "RSA/SHA256, Fri Jul  4 05:43:07 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 226686, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", "Apache Portable Runtime library", "RSA/SHA256, Tue Nov 28 22:16:00 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libquadmath", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 282811, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC __float128 shared support library", "RSA/SHA256, Tue Mar 19 19:52:54 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "1.8", "4.el7", "x86_64", "shared-mime-info-1.8-4.el7.src.rpm", 2379317, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA256, Wed Apr 25 11:46:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-devel", "1.4.8", "3.el7_4.1", "x86_64", "apr-1.4.8-3.el7_4.1.src.rpm", 789433, "ASL 2.0 and BSD with advertising and ISC and BSD", "CentOS", "", "APR library development kit", "RSA/SHA256, Tue Nov 28 22:16:02 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.5", "10.el7", "x86_64", "gzip-1.5-10.el7.src.rpm", 250440, "GPLv3+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA256, Wed Apr 25 11:04:30 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-python-libs", "3.5.1", "11.el7", "x86_64", "rh-python35-python-3.5.1-11.el7.src.rpm", 40247447, "Python", "CentOS", "", "Python 3 runtime libraries", "RSA/SHA1, Wed Dec 14 16:11:39 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.5.11", "6.el7", "x86_64", "findutils-4.5.11-6.el7.src.rpm", 1855882, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Mon Nov 12 14:25:15 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-python-pip", "7.1.0", "2.el7", "noarch", "rh-python35-python-pip-7.1.0-2.el7.src.rpm", 8198956, "MIT", "CentOS", "", "A tool for installing and managing Python packages", "RSA/SHA1, Mon Jun 13 09:53:07 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "3.3", "4.el7", "x86_64", "diffutils-3.3-4.el7.src.rpm", 1065157, "GPLv3+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Fri Jul  4 01:08:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmnl", "1.0.3", "7.el7", "x86_64", "libmnl-1.0.3-7.el7.src.rpm", 51847, "LGPLv2+", "CentOS", "", "A minimalistic Netlink library", "RSA/SHA256, Fri Jul  4 02:59:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 208315, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA256, Mon Nov 28 22:32:05 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iptables", "1.4.21", "28.el7", "x86_64", "iptables-1.4.21-28.el7.src.rpm", 1555961, "GPLv2", "CentOS", "", "Tools for managing Linux kernel packet filtering capabilities", "RSA/SHA256, Mon Nov 12 14:29:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 256362, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA256, Mon Nov 12 14:21:41 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "atlas", "3.10.1", "12.el7", "x86_64", "atlas-3.10.1-12.el7.src.rpm", 21813025, "BSD", "CentOS", "", "Automatically Tuned Linear Algebra Software", "RSA/SHA256, Thu Aug 10 14:58:26 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.1.8", "22.el7", "x86_64", "pam-1.1.8-22.el7.src.rpm", 2630324, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Wed Apr 25 11:33:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util-ldap", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 11408, "ASL 2.0", "CentOS", "", "APR utility library LDAP support", "RSA/SHA256, Fri Jul  4 00:39:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.36.0", "5.el7_5", "x86_64", "nss-softokn-3.36.0-5.el7_5.src.rpm", 1130670, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA256, Thu May 17 13:25:42 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hunspell", "1.3.2", "15.el7", "x86_64", "hunspell-1.3.2-15.el7.src.rpm", 583000, "LGPLv2+ or GPLv2+ or MPLv1.1", "CentOS", "", "A spell checker and morphological analyzer library", "RSA/SHA256, Sun Nov 20 18:14:26 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2425024, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA256, Fri Feb  1 16:21:33 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dwz", "0.11", "3.el7", "x86_64", "dwz-0.11-3.el7.src.rpm", 225103, "GPLv2+ and GPLv3+", "CentOS", "", "DWARF optimization and duplicate removal tool", "RSA/SHA256, Fri Jul  4 01:10:42 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.1.0", "3.el7", "x86_64", "libassuan-2.1.0-3.el7.src.rpm", 155391, "LGPLv2+ and GPLv3+", "CentOS", "", "GnuPG IPC library", "RSA/SHA256, Fri Jul  4 02:35:59 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 5321515, "GPLv2", "CentOS", "", "SELinux policy core utilities", "RSA/SHA256, Fri Feb  1 16:21:56 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcgroup", "0.41", "20.el7", "x86_64", "libcgroup-0.41-20.el7.src.rpm", 137210, "LGPLv2+", "CentOS", "", "Library to control and monitor control groups", "RSA/SHA256, Mon Nov 12 14:31:47 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iso-codes", "3.46", "2.el7", "noarch", "iso-codes-3.46-2.el7.src.rpm", 14504447, "LGPLv2+", "CentOS", "", "ISO code lists and translations", "RSA/SHA256, Fri Jul  4 02:09:42 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage-python", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 451817, "LGPLv2+", "CentOS", "", "semanage python bindings for libsemanage", "RSA/SHA256, Mon Nov 12 14:37:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 2069587, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA256, Fri Feb  1 16:21:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jansson", "2.10", "1.el7", "x86_64", "jansson-2.10-1.el7.src.rpm", 74998, "MIT", "CentOS", "", "C library for encoding, decoding and manipulating JSON data", "RSA/SHA256, Thu Aug 10 16:50:09 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-srpm-macros", "1", "8.el7", "noarch", "perl-srpm-macros-1-8.el7.src.rpm", 794, "GPLv3+", "CentOS", "", "RPM macros for building Perl source package from source repository", "RSA/SHA256, Fri Jul  4 04:23:16 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.56.1", "1.el7", "x86_64", "gobject-introspection-1.56.1-1.el7.src.rpm", 854207, "GPLv2+, LGPLv2+, MIT", "CentOS", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Mon Nov 12 14:28:00 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "scl-utils-build", "20130529", "19.el7", "x86_64", "scl-utils-20130529-19.el7.src.rpm", 18361, "GPLv2+", "CentOS", "", "RPM build macros for alternative packaging", "RSA/SHA256, Mon Nov 12 14:46:33 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 326487, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Wed Apr 25 11:13:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-python-virtualenv", "13.1.2", "2.el7", "noarch", "rh-python35-python-virtualenv-13.1.2-2.el7.src.rpm", 2764777, "MIT", "CentOS", "", "Tool to create isolated Python environments", "RSA/SHA1, Wed Dec 14 16:11:41 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 91848, "LGPLv2+", "CentOS", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Mon Nov 12 14:31:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "initscripts", "9.49.46", "1.el7", "x86_64", "initscripts-9.49.46-1.el7.src.rpm", 1519938, "GPLv2 and GPLv2+", "CentOS", "", "The inittab file and the /etc/init.d scripts", "RSA/SHA256, Mon Nov 12 14:29:09 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh2", "1.4.3", "12.el7", "x86_64", "libssh2-1.4.3-12.el7.src.rpm", 341886, "BSD", "CentOS", "", "A library implementing the SSH2 protocol", "RSA/SHA256, Mon Nov 12 14:37:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-devel", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 1024214, "BSD with advertising", "CentOS", "", "Files needed for developing applications with Cyrus SASL", "RSA/SHA256, Wed Apr 25 10:56:41 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 540293, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Mon Nov 12 14:23:06 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-devel", "5.3.21", "24.el7", "x86_64", "libdb-5.3.21-24.el7.src.rpm", 129076, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "C development files for the Berkeley DB library", "RSA/SHA256, Wed Apr 25 11:12:51 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 2622266, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA256, Mon Nov 12 14:45:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mailcap", "2.1.41", "2.el7", "noarch", "mailcap-2.1.41-2.el7.src.rpm", 63360, "Public Domain and MIT", "CentOS", "", "Helper application and MIME type associations for file types", "RSA/SHA256, Fri Jul  4 03:37:01 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.60", "9.el7", "x86_64", "libuser-0.60-9.el7.src.rpm", 1952592, "LGPLv2+", "CentOS", "", "A user and group account administration library", "RSA/SHA256, Wed Apr 25 11:23:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs-python", "2.8.4", "4.el7", "x86_64", "audit-2.8.4-4.el7.src.rpm", 327265, "LGPLv2+", "CentOS", "", "Python bindings for libaudit", "RSA/SHA256, Mon Nov 12 14:21:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.26", "35.el7", "x86_64", "tar-1.26-35.el7.src.rpm", 2838510, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA256, Mon Nov 12 14:47:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-runtime", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 20989, "GPLv2+", "CentOS", "", "Package that handles httpd24 Software Collection.", "RSA/SHA1, Mon Nov 27 10:19:25 2017, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 201225, "GPLv2+", "CentOS", "", "Access control list utilities", "RSA/SHA256, Wed Apr 25 10:52:22 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-libnghttp2", "1.7.1", "7.el7", "x86_64", "httpd24-nghttp2-1.7.1-7.el7.src.rpm", 142738, "MIT", "CentOS", "", "A library implementing the HTTP/2 protocol", "RSA/SHA1, Wed Nov 28 22:38:16 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-httpd", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 4739300, "ASL 2.0", "CentOS", "", "Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:14 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.5", "14.el7", "x86_64", "libsemanage-2.5-14.el7.src.rpm", 302329, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Mon Nov 12 14:37:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "httpd24-mod_ssl", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 241612, "ASL 2.0", "CentOS", "", "SSL/TLS module for the Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:18 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "4.el7", "x86_64", "libutempter-1.1.6-4.el7.src.rpm", 49749, "LGPLv2+", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Fri Jul  4 03:23:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-mod_session", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 110671, "ASL 2.0", "CentOS", "", "Session interface for the Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:18 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "qrencode-libs", "3.4.1", "3.el7", "x86_64", "qrencode-3.4.1-3.el7.src.rpm", 126732, "LGPLv2+", "CentOS", "", "QR Code encoding library - Shared libraries", "RSA/SHA256, Fri Jul  4 04:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-httpd-devel", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 836817, "ASL 2.0", "CentOS", "", "Development interfaces for the Apache HTTP server", "RSA/SHA1, Wed Nov 28 22:38:14 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-libs", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 24713067, "Python", "CentOS", "", "Runtime libraries for Python", "RSA/SHA256, Mon Nov 12 14:45:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "enchant", "1.6.0", "8.el7", "x86_64", "enchant-1.6.0-8.el7.src.rpm", 130894, "LGPLv2+", "CentOS", "", "An Enchanting Spell Checking Library", "RSA/SHA256, Fri Jul  4 01:13:33 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "atlas-devel", "3.10.1", "12.el7", "x86_64", "atlas-3.10.1-12.el7.src.rpm", 2201996, "BSD", "CentOS", "", "Development libraries for ATLAS", "RSA/SHA256, Thu Aug 10 14:58:36 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool-ltdl", "2.4.2", "22.el7_3", "x86_64", "libtool-2.4.2-22.el7_3.src.rpm", 67814, "LGPLv2+", "CentOS", "", "Runtime libraries for GNU Libtool Dynamic Module Loader", "RSA/SHA256, Thu Apr 13 01:26:27 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-gobject-base", "3.22.0", "1.el7_4.1", "x86_64", "pygobject3-3.22.0-1.el7_4.1.src.rpm", 1123114, "LGPLv2+ and MIT", "CentOS", "", "Python 2 bindings for GObject Introspection base package", "RSA/SHA256, Tue Nov 21 14:17:15 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyliblzma", "0.5.3", "11.el7", "x86_64", "pyliblzma-0.5.3-11.el7.src.rpm", 190112, "LGPLv3+", "CentOS", "", "Python bindings for lzma", "RSA/SHA256, Fri Jul  4 04:37:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-urlgrabber", "3.10", "9.el7", "noarch", "python-urlgrabber-3.10-9.el7.src.rpm", 503349, "LGPLv2+", "CentOS", "", "A high-level cross-protocol url-grabber", "RSA/SHA256, Mon Nov 12 15:19:19 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pyxattr", "0.5.1", "5.el7", "x86_64", "pyxattr-0.5.1-5.el7.src.rpm", 63304, "LGPLv2+", "CentOS", "", "Extended attributes library wrapper for Python", "RSA/SHA256, Fri Jul  4 04:43:07 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-kitchen", "1.1.1", "5.el7", "noarch", "python-kitchen-1.1.1-5.el7.src.rpm", 1465161, "LGPLv2+", "CentOS", "", "Small, useful pieces of code to make python coding easier", "RSA/SHA256, Fri Jul  4 04:39:31 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.11", "4.el7_0", "x86_64", "json-c-0.11-4.el7_0.src.rpm", 65593, "MIT", "CentOS", "", "A JSON implementation in C", "RSA/SHA256, Sat Jul  5 15:25:00 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps-ng", "3.3.10", "23.el7", "x86_64", "procps-ng-3.3.10-23.el7.src.rpm", 760565, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA256, Mon Nov 12 14:44:44 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 339987, "GPLv2", "CentOS", "", "Device mapper utility", "RSA/SHA256, Fri Feb  1 16:18:53 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "2.0.3", "3.el7", "x86_64", "cryptsetup-2.0.3-3.el7.src.rpm", 1219591, "GPLv2+ and LGPLv2+", "CentOS", "", "Cryptsetup shared library", "RSA/SHA256, Mon Nov 12 14:23:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod", "20", "23.el7", "x86_64", "kmod-20-23.el7.src.rpm", 243559, "GPLv2+", "CentOS", "", "Linux kernel module management utilities", "RSA/SHA256, Mon Nov 12 14:30:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 1263456, "LGPLv2+ and MIT", "CentOS", "", "systemd libraries", "RSA/SHA256, Wed Feb 20 17:14:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "219", "62.el7_6.5", "x86_64", "systemd-219-62.el7_6.5.src.rpm", 24440903, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "A System and Service Manager", "RSA/SHA256, Wed Feb 20 17:14:02 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.172", "2.el7", "noarch", "elfutils-0.172-2.el7.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Mon Nov 12 15:15:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20160308", "10.el7", "x86_64", "iputils-20160308-10.el7.src.rpm", 343497, "BSD and GPLv2+", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA256, Thu Aug 10 16:47:33 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.100", "7.el7", "x86_64", "dbus-glib-0.100-7.el7.src.rpm", 301237, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA256, Fri Jul  4 01:06:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pth", "2.0.7", "23.el7", "x86_64", "pth-2.0.7-23.el7.src.rpm", 267851, "LGPLv2+", "CentOS", "", "The GNU Portable Threads library", "RSA/SHA256, Wed Nov 25 15:32:05 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 166776, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Mon Nov 12 14:45:45 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.3.2", "5.el7", "x86_64", "gpgme-1.3.2-5.el7.src.rpm", 547534, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Fri Jul  4 01:44:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-fastestmirror", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 53895, "GPLv2+", "CentOS", "", "Yum plugin which chooses fastest repository from a mirrorlist", "RSA/SHA256, Mon Nov 12 15:27:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-utils", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 345277, "GPLv2+", "CentOS", "", "Utilities based around the yum package manager", "RSA/SHA256, Mon Nov 12 15:27:36 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.79", "4.el7", "x86_64", "passwd-0.79-4.el7.src.rpm", 429874, "BSD or GPL+", "CentOS", "", "An utility for setting or changing passwords using PAM", "RSA/SHA256, Fri Jul  4 04:12:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "7.4.160", "5.el7", "x86_64", "vim-7.4.160-5.el7.src.rpm", 917744, "Vim", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA256, Mon Nov 12 14:48:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "f4a80eb5", "53a7ff4b", "", "", 0, "pubkey", "", "", "gpg(CentOS-7 Key (CentOS 7 Official Signing Key) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lzo", "2.06", "8.el7", "x86_64", "lzo-2.06-8.el7.src.rpm", 165360, "GPLv2+", "CentOS", "", "Data compression library with very fast (de)compression", "RSA/SHA256, Wed Nov 25 15:15:42 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcroco", "0.6.12", "4.el7", "x86_64", "libcroco-0.6.12-4.el7.src.rpm", 320955, "LGPLv2", "CentOS", "", "A CSS2 parsing library", "RSA/SHA256, Mon Nov 12 14:31:55 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libarchive", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 745291, "BSD", "CentOS", "", "A library for handling streaming archive formats", "RSA/SHA256, Thu Sep 15 23:28:35 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 5029340, "GPLv3+ and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA256, Thu Aug 10 16:07:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff-base", "1.22.2", "8.el7", "x86_64", "groff-1.22.2-8.el7.src.rpm", 3453946, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", "Parts of the groff formatting system required to display manual pages", "RSA/SHA256, Fri Jul  4 01:45:51 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release-scl-rh", "2", "3.el7.centos", "noarch", "centos-release-scl-rh-2-3.el7.centos.src.rpm", 20015, "GPLv2", "CentOS", "", "Software collections from the CentOS SCLo SIG (upstream scl only)", "RSA/SHA256, Mon Apr  1 12:41:53 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "f2ee9d55", "560cfc0a", "", "", 0, "pubkey", "", "", "gpg(CentOS SoftwareCollections SIG (https://wiki.centos.org/SpecialInterestGroup/SCLo) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 20326, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Tue Mar 19 19:53:03 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "3.1.1", "4.el7", "x86_64", "mpfr-3.1.1-4.el7.src.rpm", 554279, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Fri Jul  4 03:49:45 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1077442, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA256, Tue Mar 19 19:52:58 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libpng", "1.5.13", "7.el7_2", "x86_64", "libpng-1.5.13-7.el7_2.src.rpm", 616101, "zlib", "CentOS", "", "A library of functions for manipulating PNG image format files", "RSA/SHA256, Wed Dec  9 17:02:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libpng-devel", "1.5.13", "7.el7_2", "x86_64", "libpng-1.5.13-7.el7_2.src.rpm", 216267, "zlib", "CentOS", "", "Development tools for programs to manipulate PNG image format files", "RSA/SHA256, Wed Dec  9 17:02:09 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 265973, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA256, Tue Mar 19 19:52:11 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libjpeg-turbo", "1.2.90", "6.el7", "x86_64", "libjpeg-turbo-1.2.90-6.el7.src.rpm", 350499, "IJG", "CentOS", "", "A MMX/SSE2 accelerated library for manipulating JPEG image files", "RSA/SHA256, Mon Nov 12 14:33:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-nodejs10-runtime", "3.2", "2.el7", "x86_64", "rh-nodejs10-3.2-2.el7.src.rpm", 3921, "MIT", "CentOS", "", "Package that handles rh-nodejs10 Software Collection.", "RSA/SHA1, Wed Dec  5 23:56:42 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXau", "1.0.8", "2.1.el7", "x86_64", "libXau-1.0.8-2.1.el7.src.rpm", 55529, "MIT", "CentOS", "", "Sample Authorization Protocol for X", "RSA/SHA256, Fri Jul  4 03:29:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xorg-x11-proto-devel", "2018.4", "1.el7", "noarch", "xorg-x11-proto-devel-2018.4-1.el7.src.rpm", 1835516, "MIT", "CentOS", "", "X.Org X11 Protocol headers", "RSA/SHA256, Mon Nov 12 15:27:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcb-devel", "1.13", "1.el7", "x86_64", "libxcb-1.13-1.el7.src.rpm", 2717470, "MIT", "CentOS", "", "Development files for libxcb", "RSA/SHA256, Mon Nov 12 14:39:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-nodejs10-npm", "6.4.1", "10.10.0.2.el7", "x86_64", "rh-nodejs10-nodejs-10.10.0-2.el7.src.rpm", 16465524, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "", "Node.js Package Manager", "RSA/SHA1, Wed Dec  5 23:56:41 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dejavu-fonts-common", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 130455, "Bitstream Vera and Public Domain", "CentOS", "", "Common files for the Dejavu font set", "RSA/SHA256, Fri Jul  4 01:06:50 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontconfig", "2.13.0", "4.3.el7", "x86_64", "fontconfig-2.13.0-4.3.el7.src.rpm", 666475, "MIT and Public Domain and UCD", "CentOS", "", "Font configuration and customization library", "RSA/SHA256, Mon Nov 12 14:25:25 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "postgresql", "9.2.24", "1.el7_5", "x86_64", "postgresql-9.2.24-1.el7_5.src.rpm", 16706464, "PostgreSQL", "CentOS", "", "PostgreSQL client programs", "RSA/SHA256, Fri Aug 24 14:51:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 15644861, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "The C Preprocessor", "RSA/SHA256, Tue Mar 19 19:51:05 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 8436804, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Header files and libraries for C++ development", "RSA/SHA256, Tue Mar 19 19:52:58 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck-lib", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 11466, "BSD", "CentOS", "", "Library files for fipscheck", "RSA/SHA256, Thu Aug 10 15:53:57 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-parent", "0.225", "244.el7", "noarch", "perl-parent-0.225-244.el7.src.rpm", 8141, "GPL+ or Artistic", "CentOS", "", "Establish an ISA relationship with base classes at compile time", "RSA/SHA256, Fri Jul  4 04:21:55 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-podlators", "2.5.1", "3.el7", "noarch", "perl-podlators-2.5.1-3.el7.src.rpm", 287679, "GPL+ or Artistic", "CentOS", "", "Format POD source into various output formats", "RSA/SHA256, Fri Jul  4 04:22:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.04", "294.el7_6", "noarch", "perl-5.16.3-294.el7_6.src.rpm", 21091, "GPL+ or Artistic", "CentOS", "", "Perl module for resolving POD escape sequences", "RSA/SHA256, Thu Jan 24 13:22:34 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Encode", "2.51", "7.el7", "x86_64", "perl-Encode-2.51-7.el7.src.rpm", 10176350, "GPL+ or Artistic", "CentOS", "", "Character encodings in Perl", "RSA/SHA256, Fri Jul  4 04:17:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 1647344, "GPL+ or Artistic", "CentOS", "", "The libraries for the perl runtime", "RSA/SHA256, Thu Jan 24 13:22:16 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Time-HiRes", "1.9725", "3.el7", "x86_64", "perl-Time-HiRes-1.9725-3.el7.src.rpm", 94069, "GPL+ or Artistic", "CentOS", "", "High resolution alarm, sleep, gettimeofday, interval timers", "RSA/SHA256, Fri Jul  4 04:25:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads", "1.87", "4.el7", "x86_64", "perl-threads-1.87-4.el7.src.rpm", 98615, "GPL+ or Artistic", "CentOS", "", "Perl interpreter-based threads", "RSA/SHA256, Fri Jul  4 04:25:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Carp", "1.26", "244.el7", "noarch", "perl-Carp-1.26-244.el7.src.rpm", 28276, "GPL+ or Artistic", "CentOS", "", "Alternative warn and die for modules", "RSA/SHA256, Fri Jul  4 04:15:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-constant", "1.27", "2.el7", "noarch", "perl-constant-1.27-2.el7.src.rpm", 26364, "GPL+ or Artistic", "CentOS", "", "Perl pragma to declare constants", "RSA/SHA256, Fri Jul  4 04:15:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-macros", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 5134, "GPL+ or Artistic", "CentOS", "", "Macros for rpmbuild", "RSA/SHA256, Thu Jan 24 13:22:17 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Temp", "0.23.01", "3.el7", "noarch", "perl-File-Temp-0.23.01-3.el7.src.rpm", 158781, "GPL+ or Artistic", "CentOS", "", "Return name and handle of a temporary file safely", "RSA/SHA256, Fri Jul  4 04:18:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-PathTools", "3.40", "5.el7", "x86_64", "perl-PathTools-3.40-5.el7.src.rpm", 174131, "(GPL+ or Artistic) and BSD", "CentOS", "", "PathTools Perl module (Cwd, File::Spec)", "RSA/SHA256, Fri Jul  4 04:22:03 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.28", "4.el7", "noarch", "perl-Pod-Simple-3.28-4.el7.src.rpm", 538320, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA256, Fri Jul  4 04:22:44 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl", "5.16.3", "294.el7_6", "x86_64", "perl-5.16.3-294.el7_6.src.rpm", 23552128, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and Copyright Only and MIT and Public Domain and UCD", "CentOS", "", "Practical Extraction and Report Language", "RSA/SHA256, Thu Jan 24 13:22:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-TermReadKey", "2.30", "20.el7", "x86_64", "perl-TermReadKey-2.30-20.el7.src.rpm", 59999, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", "A perl module for simple terminal control", "RSA/SHA256, Fri Jul  4 04:23:54 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Test-Harness", "3.28", "3.el7", "noarch", "perl-Test-Harness-3.28-3.el7.src.rpm", 607239, "GPL+ or Artistic", "CentOS", "", "Run Perl standard test scripts with statistics", "RSA/SHA256, Wed Aug 12 14:33:49 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat-devel", "2.1.0", "10.el7_3", "x86_64", "expat-2.1.0-10.el7_3.src.rpm", 182002, "MIT", "CentOS", "", "Libraries and header files to develop applications using expat", "RSA/SHA256, Mon Nov 28 22:32:13 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err-devel", "1.42.9", "13.el7", "x86_64", "e2fsprogs-1.42.9-13.el7.src.rpm", 17196, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Mon Nov 12 14:31:54 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2018i", "1.el7", "noarch", "tzdata-2018i-1.el7.src.rpm", 2007607, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA256, Thu Jan 10 16:43:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-devel", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 168793, "LGPLv2+", "CentOS", "", "Devel libraries & headers for liblzma", "RSA/SHA256, Sun Nov 20 21:02:43 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "5.9", "14.20130511.el7_4", "noarch", "ncurses-5.9-14.20130511.el7_4.src.rpm", 223432, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA256, Thu Sep  7 12:43:14 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsmartcols", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 164608, "LGPLv2+", "CentOS", "", "Formatting library for ls-like programs.", "RSA/SHA256, Tue Mar 19 19:52:56 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.7.4", "1.el7", "x86_64", "chkconfig-1.7.4-1.el7.src.rpm", 779531, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Thu Aug 10 15:17:48 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh", "7.4p1", "16.el7", "x86_64", "openssh-7.4p1-16.el7.src.rpm", 1995364, "BSD", "CentOS", "", "An open source implementation of SSH protocol versions 1 and 2", "RSA/SHA256, Wed Apr 25 11:32:50 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 439378, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA256, Thu Sep  7 12:43:10 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-headers", "3.10.0", "957.10.1.el7", "x86_64", "kernel-3.10.0-957.10.1.el7.src.rpm", 3823832, "GPLv2", "CentOS", "", "Header files for the Linux kernel for use by glibc", "RSA/SHA256, Mon Mar 18 15:45:45 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.8.71", "10.el7", "noarch", "setup-2.8.71-10.el7.src.rpm", 696893, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA256, Mon Nov 12 15:19:37 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-devel", "2.17", "260.el7_6.3", "x86_64", "glibc-2.17-260.el7_6.3.src.rpm", 1066078, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+", "CentOS", "", "Object files for development using standard C libraries.", "RSA/SHA256, Fri Feb  1 16:19:42 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "10.0", "7.el7.centos", "noarch", "basesystem-10.0-7.el7.centos.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple CentOS Linux system", "RSA/SHA256, Fri Jul  4 00:46:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m4", "1.4.16", "10.el7", "x86_64", "m4-1.4.16-10.el7.src.rpm", 525707, "GPLv3+", "CentOS", "", "The GNU macro processor", "RSA/SHA256, Wed Nov 25 15:16:04 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 185294, "zlib and Boost", "CentOS", "", "The compression and decompression library", "RSA/SHA256, Mon Nov 12 14:49:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre-devel", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1505771, "BSD", "CentOS", "", "Development files for pcre", "RSA/SHA256, Thu Aug 10 19:04:40 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.36.0", "1.1.el7_6", "x86_64", "nss-util-3.36.0-1.1.el7_6.src.rpm", 199008, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA256, Fri Feb  1 16:21:37 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11", "1.6.5", "2.el7", "x86_64", "libX11-1.6.5-2.el7.src.rpm", 1325648, "MIT", "CentOS", "", "Core X11 protocol client library", "RSA/SHA256, Mon Nov 12 14:39:08 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 47766, "MIT and Public Domain", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Sun Nov 20 18:39:28 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11-devel", "1.6.5", "2.el7", "x86_64", "libX11-1.6.5-2.el7.src.rpm", 1100103, "MIT", "CentOS", "", "Development files for libX11", "RSA/SHA256, Mon Nov 12 14:39:09 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.46", "13.el7", "x86_64", "attr-2.4.46-13.el7.src.rpm", 19896, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA256, Wed Apr 25 11:11:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXext", "1.3.3", "3.el7", "x86_64", "libXext-1.3.3-3.el7.src.rpm", 87102, "MIT", "CentOS", "", "X.Org X11 libXext runtime library", "RSA/SHA256, Wed Nov 25 15:13:57 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.51", "14.el7", "x86_64", "acl-2.2.51-14.el7.src.rpm", 37056, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA256, Wed Apr 25 11:10:52 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXpm-devel", "3.5.12", "1.el7", "x86_64", "libXpm-3.5.12-1.el7.src.rpm", 68654, "MIT", "CentOS", "", "X.Org X11 libXpm development package", "RSA/SHA256, Thu Aug 10 18:12:35 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "5.9", "14.20130511.el7_4", "x86_64", "ncurses-5.9-14.20130511.el7_4.src.rpm", 1028216, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA256, Thu Sep  7 12:43:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rsync", "3.1.2", "4.el7", "x86_64", "rsync-3.1.2-4.el7.src.rpm", 834618, "GPLv3+", "CentOS", "", "A program for synchronizing files over a network", "RSA/SHA256, Wed Apr 25 11:44:59 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.5", "10.el7", "x86_64", "libsepol-2.5-10.el7.src.rpm", 686640, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Mon Nov 12 14:37:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error-devel", "1.12", "3.el7", "x86_64", "libgpg-error-1.12-3.el7.src.rpm", 29702, "LGPLv2+", "CentOS", "", "Development files for the libgpg-error package", "RSA/SHA256, Fri Jul  4 02:49:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.32", "17.el7", "x86_64", "pcre-8.32-17.el7.src.rpm", 1475532, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Thu Aug 10 19:04:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libedit", "3.0", "12.20121213cvs.el7", "x86_64", "libedit-3.0-12.20121213cvs.el7.src.rpm", 244257, "BSD", "CentOS", "", "The NetBSD Editline library", "RSA/SHA256, Fri Jul  4 02:44:30 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.2.2", "5.el7", "x86_64", "sed-4.2.2-5.el7.src.rpm", 601208, "GPLv3+", "CentOS", "", "A GNU stream text editor", "RSA/SHA256, Fri Jul  4 04:58:02 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Git", "1.8.3.1", "20.el7", "noarch", "git-1.8.3.1-20.el7.src.rpm", 58567, "GPLv2", "CentOS", "", "Perl interface to Git", "RSA/SHA256, Tue Nov 20 20:42:15 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.5", "3.el7", "x86_64", "p11-kit-0.23.5-3.el7.src.rpm", 1337825, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Thu Aug 10 18:44:31 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol-devel", "2.5", "10.el7", "x86_64", "libsepol-2.5-10.el7.src.rpm", 126580, "LGPLv2+", "CentOS", "", "Header files and libraries used to build policy manipulation tools", "RSA/SHA256, Mon Nov 12 14:37:35 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.0.0", "15.el7", "x86_64", "gmp-6.0.0-15.el7.src.rpm", 657046, "LGPLv3+ or GPLv2+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA256, Thu Aug 10 16:14:25 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto-devel", "0.2.5", "4.el7", "x86_64", "libverto-0.2.5-4.el7.src.rpm", 25871, "MIT", "CentOS", "", "Development files for libverto", "RSA/SHA256, Fri Jul  4 03:23:51 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.10", "1.el7", "x86_64", "libtasn1-4.10-1.el7.src.rpm", 424486, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Thu Aug 10 17:58:43 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-devel", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 3268426, "OpenSSL", "CentOS", "", "Files for development of applications which will use OpenSSL", "RSA/SHA256, Mon Mar 18 15:45:51 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2018.2.22", "70.0.el7_5", "noarch", "ca-certificates-2018.2.22-70.0.el7_5.src.rpm", 973960, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Thu May 17 13:16:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxslt-devel", "1.1.28", "5.el7", "x86_64", "libxslt-1.1.28-5.el7.src.rpm", 2502662, "MIT", "CentOS", "", "Development files for libxslt", "RSA/SHA256, Fri Jul  4 03:32:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.22", "23.el7", "x86_64", "coreutils-8.22-23.el7.src.rpm", 14588674, "GPLv3+", "CentOS", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Mon Nov 12 14:22:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "automake", "1.13.4", "3.el7", "noarch", "automake-1.13.4-3.el7.src.rpm", 1731909, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", "A GNU tool for automatically creating Makefiles", "RSA/SHA256, Fri Jul  4 00:44:21 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "7", "6.1810.2.el7.centos", "x86_64", "centos-release-7-6.1810.2.el7.centos.src.rpm", 41271, "GPLv2", "CentOS", "", "CentOS Linux release file", "RSA/SHA256, Fri Nov 23 13:35:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "postgresql-devel", "9.2.24", "1.el7_5", "x86_64", "postgresql-9.2.24-1.el7_5.src.rpm", 4147268, "PostgreSQL", "CentOS", "", "PostgreSQL development header files and libraries", "RSA/SHA256, Fri Aug 24 14:51:12 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "13.el7", "x86_64", "bzip2-1.0.6-13.el7.src.rpm", 70093, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Wed Nov 25 14:18:43 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "wget", "1.14", "18.el7", "x86_64", "wget-1.14-18.el7.src.rpm", 2055557, "GPLv3+", "CentOS", "", "A utility for retrieving files using the HTTP or FTP protocols", "RSA/SHA256, Mon Nov 12 14:49:07 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 913443, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA256, Mon Nov 12 14:24:07 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl-devel", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 638377, "MIT", "CentOS", "", "Files needed for building applications with libcurl", "RSA/SHA256, Mon Nov 12 14:31:58 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1710062, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA256, Thu Jun 23 20:07:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite-devel", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 374846, "Public Domain", "CentOS", "", "Development tools for the sqlite3 embeddable SQL database engine", "RSA/SHA256, Wed Nov 25 15:40:42 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "6.2", "10.el7", "x86_64", "readline-6.2-10.el7.src.rpm", 460464, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA256, Thu Aug 10 19:38:52 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "3.82", "23.el7", "x86_64", "make-3.82-23.el7.src.rpm", 1160684, "GPLv2+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA256, Sun Nov 20 19:23:44 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.11", "27.el7", "x86_64", "cpio-2.11-27.el7.src.rpm", 689335, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA256, Wed Apr 25 10:56:03 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-runtime", "2.0", "2.el7", "x86_64", "rh-python35-2.0-2.el7.src.rpm", 21152, "GPLv2+", "CentOS", "", "Package that handles rh-python35 Software Collection.", "RSA/SHA1, Mon Jun 13 09:53:13 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 198751, "ASL 2.0", "CentOS", "", "Apache Portable Runtime Utility library", "RSA/SHA256, Fri Jul  4 00:39:24 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.56.1", "2.el7", "x86_64", "glib2-2.56.1-2.el7.src.rpm", 12166425, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA256, Mon Nov 12 14:26:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 1186168, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Fortran runtime", "RSA/SHA256, Tue Mar 19 19:52:13 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite", "3.7.17", "8.el7", "x86_64", "sqlite-3.7.17-8.el7.src.rpm", 814231, "Public Domain", "CentOS", "", "Library that implements an embeddable SQL database engine", "RSA/SHA256, Wed Nov 25 15:40:39 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-python-setuptools", "18.0.1", "2.el7", "noarch", "rh-python35-python-setuptools-18.0.1-2.el7.src.rpm", 1785163, "Python or ZPLv2.0", "CentOS", "", "Easily build and distribute Python packages", "RSA/SHA1, Mon Jun 13 09:53:09 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 209610, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Fri Jul  4 01:02:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-python", "3.5.1", "11.el7", "x86_64", "rh-python35-python-3.5.1-11.el7.src.rpm", 42812, "Python", "CentOS", "", "Version 3 of the Python programming language aka Python 3000", "RSA/SHA1, Wed Dec 14 16:11:37 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.28", "4.el7", "x86_64", "libidn-1.28-4.el7.src.rpm", 630407, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Wed Nov 25 14:58:28 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnfnetlink", "1.0.1", "4.el7", "x86_64", "libnfnetlink-1.0.1-4.el7.src.rpm", 47123, "GPLv2+", "CentOS", "", "Netfilter netlink userspace library", "RSA/SHA256, Fri Jul  4 03:01:58 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnetfilter_conntrack", "1.0.6", "1.el7_3", "x86_64", "libnetfilter_conntrack-1.0.6-1.el7_3.src.rpm", 143566, "GPLv2+", "CentOS", "", "Netfilter conntrack userspace library", "RSA/SHA256, Thu May 25 23:23:09 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.5", "4.el7", "x86_64", "libcap-ng-0.7.5-4.el7.src.rpm", 50510, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Wed Nov 25 14:52:00 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iproute", "4.11.0", "14.el7", "x86_64", "iproute-4.11.0-14.el7.src.rpm", 1788731, "GPLv2+ and Public Domain", "CentOS", "", "Advanced IP routing and network device configuration tools", "RSA/SHA256, Wed Apr 25 11:05:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.9.0", "11.el7", "x86_64", "cracklib-2.9.0-11.el7.src.rpm", 9389116, "LGPLv2+", "CentOS", "", "The standard CrackLib dictionaries", "RSA/SHA256, Fri Jul  4 01:02:17 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libquadmath-devel", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 18514, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC __float128 support", "RSA/SHA256, Tue Mar 19 19:52:54 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.2.3", "5.el7", "x86_64", "libpwquality-1.2.3-5.el7.src.rpm", 332421, "BSD or GPLv2+", "CentOS", "", "A library for password generation and password quality checking", "RSA/SHA256, Wed Apr 25 11:17:46 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util-openssl", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 19896, "ASL 2.0", "CentOS", "", "APR utility library OpenSSL crytpo support", "RSA/SHA256, Fri Jul  4 00:39:38 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-pem", "1.0.3", "5.el7", "x86_64", "nss-pem-1.0.3-5.el7.src.rpm", 205539, "MPLv1.1", "CentOS", "", "PEM file reader for Network Security Services (NSS)", "RSA/SHA256, Mon Nov 12 14:41:18 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hunspell-en-US", "0.20121024", "6.el7", "noarch", "hunspell-en-0.20121024-6.el7.src.rpm", 549311, "LGPLv2+ and LGPLv2 and BSD", "CentOS", "", "US English hunspell dictionaries", "RSA/SHA256, Thu Aug 10 16:41:24 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.36.0", "7.1.el7_6", "x86_64", "nss-3.36.0-7.1.el7_6.src.rpm", 14067, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA256, Fri Feb  1 16:21:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 172645, "Public Domain", "CentOS", "", "SELinux libselinux utilies", "RSA/SHA256, Mon Nov 12 14:37:31 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "5.2.2", "1.el7", "x86_64", "xz-5.2.2-1.el7.src.rpm", 798130, "LGPLv2+", "CentOS", "", "LZMA compression utilities", "RSA/SHA256, Sun Nov 20 21:02:26 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zip", "3.0", "11.el7", "x86_64", "zip-3.0-11.el7.src.rpm", 815173, "BSD", "CentOS", "", "A file compression and packaging utility compatible with PKZIP", "RSA/SHA256, Sun Nov 20 21:04:58 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.11", "35.el7", "x86_64", "file-5.11-35.el7.src.rpm", 3076831, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA256, Mon Nov 12 14:25:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xml-common", "0.6.3", "39.el7", "noarch", "sgml-common-0.6.3-39.el7.src.rpm", 46969, "GPL+", "CentOS", "", "Common XML catalog and DTD files", "RSA/SHA256, Fri Jul  4 05:46:52 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4", "1.7.5", "2.el7", "x86_64", "lz4-1.7.5-2.el7.src.rpm", 366872, "GPLv2+ and BSD", "CentOS", "", "Extremely fast compression algorithm", "RSA/SHA256, Wed Apr 25 11:26:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-python", "2.5", "14.1.el7", "x86_64", "libselinux-2.5-14.1.el7.src.rpm", 603236, "Public Domain", "CentOS", "", "SELinux python bindings for libselinux", "RSA/SHA256, Mon Nov 12 14:37:29 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "checkpolicy", "2.5", "8.el7", "x86_64", "checkpolicy-2.5-8.el7.src.rpm", 1288327, "GPLv2", "CentOS", "", "SELinux policy compiler", "RSA/SHA256, Mon Nov 12 14:22:21 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 833657, "OpenSSL", "CentOS", "", "Utilities from the general purpose cryptography library with TLS implementation", "RSA/SHA256, Mon Mar 18 15:45:50 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-IPy", "0.75", "6.el7", "noarch", "python-IPy-0.75-6.el7.src.rpm", 121946, "BSD", "CentOS", "", "Python module for handling IPv4 and IPv6 Addresses and Networks", "RSA/SHA256, Fri Jul  4 04:39:22 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "pkgconfig", "0.27.1", "4.el7", "x86_64", "pkgconfig-0.27.1-4.el7.src.rpm", 105522, "GPLv2+", "CentOS", "", "A tool for determining compilation options", "RSA/SHA256, Fri Jul  4 04:28:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-rpm-config", "9.1.0", "87.el7.centos", "noarch", "redhat-rpm-config-9.1.0-87.el7.centos.src.rpm", 174572, "GPL+", "CentOS", "", "CentOS specific rpm configuration files", "RSA/SHA256, Mon Nov 12 15:19:20 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35-python-devel", "3.5.1", "11.el7", "x86_64", "rh-python35-python-3.5.1-11.el7.src.rpm", 600179, "Python", "CentOS", "", "Libraries and header files needed for Python 3 development", "RSA/SHA1, Wed Dec 14 16:11:38 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 396911, "BSD with advertising", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Wed Apr 25 10:56:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sysvinit-tools", "2.88", "14.dsf.el7", "x86_64", "sysvinit-2.88-14.dsf.el7.src.rpm", 109118, "GPLv2+", "CentOS", "", "Tools used for process and utmp management.", "RSA/SHA256, Fri Jul  4 05:09:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.27", "34.base.el7", "x86_64", "binutils-2.27-34.base.el7.src.rpm", 25150000, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA256, Mon Nov 12 14:22:05 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl", "2.1.26", "23.el7", "x86_64", "cyrus-sasl-2.1.26-23.el7.src.rpm", 144492, "BSD with advertising", "CentOS", "", "The Cyrus SASL library", "RSA/SHA256, Wed Apr 25 10:56:39 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.29.0", "51.el7", "x86_64", "curl-7.29.0-51.el7.src.rpm", 435192, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA256, Mon Nov 12 14:31:56 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap-devel", "2.4.44", "21.el7_6", "x86_64", "openldap-2.4.44-21.el7_6.src.rpm", 3847489, "OpenLDAP", "CentOS", "", "LDAP development libraries and header files", "RSA/SHA256, Fri Feb  1 16:21:41 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 611536, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Mon Nov 12 14:45:48 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "apr-util-devel", "1.5.2", "6.el7", "x86_64", "apr-util-1.5.2-6.el7.src.rpm", 298354, "ASL 2.0", "CentOS", "", "APR utility library development kit", "RSA/SHA256, Fri Jul  4 00:39:29 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.44", "21.el7_6", "x86_64", "openldap-2.4.44-21.el7_6.src.rpm", 1037424, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA256, Fri Feb  1 16:21:40 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setools-libs", "3.3.8", "4.el7", "x86_64", "setools-3.3.8-4.el7.src.rpm", 1917790, "LGPLv2", "CentOS", "", "Policy analysis support libraries for SELinux", "RSA/SHA256, Mon Nov 12 14:46:38 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils-python", "2.5", "29.el7_6.1", "x86_64", "policycoreutils-2.5-29.el7_6.1.src.rpm", 1299284, "GPLv2", "CentOS", "", "SELinux policy core python utilities", "RSA/SHA256, Fri Feb  1 16:22:00 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pinentry", "0.8.1", "17.el7", "x86_64", "pinentry-0.8.1-17.el7.src.rpm", 159929, "GPLv2+", "CentOS", "", "Collection of simple PIN or passphrase entry dialogs", "RSA/SHA256, Sun Nov 20 20:05:16 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-libcurl", "7.61.1", "1.el7", "x86_64", "httpd24-curl-7.61.1-1.el7.src.rpm", 545704, "MIT", "CentOS", "", "A library for getting files from web servers", "RSA/SHA1, Wed Nov 28 22:38:15 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-httpd-tools", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 177148, "ASL 2.0", "CentOS", "", "Tools for use with the Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:15 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ustr", "1.0.4", "16.el7", "x86_64", "ustr-1.0.4-16.el7.src.rpm", 285943, "MIT or LGPLv2+ or BSD", "CentOS", "", "String library, very low memory overhead, simple to import", "RSA/SHA256, Fri Jul  4 05:39:11 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-mod_auth_kerb", "5.4", "33.el7", "x86_64", "httpd24-mod_auth_kerb-5.4-33.el7.src.rpm", 67371, "BSD and MIT and ASL 2.0", "CentOS", "", "Kerberos authentication module for HTTP", "RSA/SHA1, Mon Nov 27 10:19:23 2017, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.1.5.1", "25.el7", "x86_64", "shadow-utils-4.1.5.1-25.el7.src.rpm", 3540592, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Mon Nov 12 14:46:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24-mod_ldap", "2.4.34", "7.el7", "x86_64", "httpd24-httpd-2.4.34-7.el7.src.rpm", 134213, "ASL 2.0", "CentOS", "", "LDAP authentication modules for the Apache HTTP Server", "RSA/SHA1, Wed Nov 28 22:38:17 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "hardlink", "1.0", "19.el7", "x86_64", "hardlink-1.0-19.el7.src.rpm", 16545, "GPL+", "CentOS", "", "Create a tree of hardlinks", "RSA/SHA256, Fri Jul  4 01:53:39 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "httpd24", "1.1", "18.el7", "x86_64", "httpd24-1.1-18.el7.src.rpm", 0, "GPLv2+", "CentOS", "", "Package that installs httpd24", "RSA/SHA1, Mon Nov 27 10:19:20 2017, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdbm", "1.10", "8.el7", "x86_64", "gdbm-1.10-8.el7.src.rpm", 184322, "GPLv3+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Fri Jul  4 01:27:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-python35", "2.0", "2.el7", "x86_64", "rh-python35-2.0-2.el7.src.rpm", 0, "GPLv2+", "CentOS", "", "Package that installs rh-python35", "RSA/SHA1, Mon Jun 13 09:53:02 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python", "2.7.5", "76.el7", "x86_64", "python-2.7.5-76.el7.src.rpm", 80907, "Python", "CentOS", "", "An interpreted, interactive, object-oriented programming language", "RSA/SHA256, Mon Nov 12 14:44:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-gfortran", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 16443248, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Fortran support", "RSA/SHA256, Tue Mar 19 19:51:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2-python", "2.9.1", "6.el7_2.3", "x86_64", "libxml2-2.9.1-6.el7_2.3.src.rpm", 1503050, "MIT", "CentOS", "", "Python bindings for the libxml2 library", "RSA/SHA256, Thu Jun 23 20:08:06 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss_wrapper", "1.0.3", "1.el7", "x86_64", "nss_wrapper-1.0.3-1.el7.src.rpm", 61024, "BSD", "CentOS", "", "A wrapper for the user, group and hosts NSS API", "RSA/SHA1, Tue Jul 19 16:06:25 2016, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi-devel", "3.0.13", "18.el7", "x86_64", "libffi-3.0.13-18.el7.src.rpm", 27170, "MIT and Public Domain", "CentOS", "", "Development files for libffi", "RSA/SHA256, Sun Nov 20 18:39:36 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-metadata-parser", "1.1.4", "10.el7", "x86_64", "yum-metadata-parser-1.1.4-10.el7.src.rpm", 58789, "GPLv2", "CentOS", "", "A fast metadata parser for yum", "RSA/SHA256, Fri Jul  4 05:53:04 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pycurl", "7.19.0", "19.el7", "x86_64", "python-pycurl-7.19.0-19.el7.src.rpm", 241513, "LGPLv2+ or MIT", "CentOS", "", "A Python interface to libcurl", "RSA/SHA256, Sun Nov 20 20:16:57 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-iniparse", "0.4", "9.el7", "noarch", "python-iniparse-0.4-9.el7.src.rpm", 115166, "MIT", "CentOS", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Fri Jul  4 04:39:14 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-chardet", "2.2.1", "1.el7_1", "noarch", "python-chardet-2.2.1-1.el7_1.src.rpm", 1156541, "LGPLv2", "CentOS", "", "Character encoding auto-detection in Python", "RSA/SHA256, Wed Jul 22 20:25:06 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hostname", "3.13", "3.el7", "x86_64", "hostname-3.13-3.el7.src.rpm", 19449, "GPLv2+", "CentOS", "", "Utility to set/show the host name or domain name", "RSA/SHA256, Fri Jul  4 01:54:34 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kpartx", "0.4.9", "123.el7", "x86_64", "device-mapper-multipath-0.4.9-123.el7.src.rpm", 41363, "GPL+", "CentOS", "", "Partition device manager for device-mapper devices", "RSA/SHA256, Mon Nov 12 14:31:04 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(7), "device-mapper-libs", "1.02.149", "10.el7_6.3", "x86_64", "lvm2-2.02.180-10.el7_6.3.src.rpm", 400607, "LGPLv2", "CentOS", "", "Device-mapper shared library", "RSA/SHA256, Fri Feb  1 16:18:57 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut", "033", "554.el7", "x86_64", "dracut-033-554.el7.src.rpm", 903230, "GPLv2+ and LGPLv2+", "CentOS", "", "Initramfs generator using udev", "RSA/SHA256, Mon Nov 12 14:23:43 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.172", "2.el7", "x86_64", "elfutils-0.172-2.el7.src.rpm", 793087, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA256, Mon Nov 12 14:24:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 362560, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA256, Mon Nov 12 14:23:11 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.10.24", "12.el7", "x86_64", "dbus-1.10.24-12.el7.src.rpm", 595210, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Mon Nov 12 14:23:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-python", "1.1.1", "9.el7", "x86_64", "dbus-python-1.1.1-9.el7.src.rpm", 848122, "MIT", "CentOS", "", "D-Bus Python Bindings", "RSA/SHA256, Fri Jul  4 01:06:25 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.0.22", "5.el7_5", "x86_64", "gnupg2-2.0.22-5.el7_5.src.rpm", 6637796, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA256, Fri Jul 13 15:56:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-python", "4.11.3", "35.el7", "x86_64", "rpm-4.11.3-35.el7.src.rpm", 149898, "GPLv2+", "CentOS", "", "Python bindings for apps which will manipulate RPM packages", "RSA/SHA256, Mon Nov 12 14:45:49 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pygpgme", "0.3", "9.el7", "x86_64", "pygpgme-0.3-9.el7.src.rpm", 197501, "LGPLv2+", "CentOS", "", "Python module for working with OpenPGP messages", "RSA/SHA256, Fri Jul  4 04:36:27 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "3.4.3", "161.el7.centos", "noarch", "yum-3.4.3-161.el7.centos.src.rpm", 5824869, "GPLv2+", "CentOS", "", "RPM package installer/updater/manager", "RSA/SHA256, Mon Nov 12 15:27:16 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum-plugin-ovl", "1.1.31", "50.el7", "noarch", "yum-utils-1.1.31-50.el7.src.rpm", 22399, "GPLv2+", "CentOS", "", "Yum plugin to work around overlayfs issues", "RSA/SHA256, Mon Nov 12 15:27:26 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "11.el7", "noarch", "rootfiles-8.1-11.el7.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Fri Jul  4 04:50:28 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 212184, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC OpenMP v3.0 shared support library", "RSA/SHA256, Tue Mar 19 19:52:30 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.3", "9.el7", "x86_64", "libunistring-0.9.3-9.el7.src.rpm", 1145761, "LGPLv3+", "CentOS", "", "GNU Unicode string library", "RSA/SHA256, Fri Jul  4 03:22:35 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.19.8.1", "2.el7", "x86_64", "gettext-0.19.8.1-2.el7.src.rpm", 1546952, "LGPLv2+ and GPLv3+", "CentOS", "", "Libraries for gettext", "RSA/SHA256, Thu Aug 10 16:08:05 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bsdtar", "3.1.2", "10.el7_2", "x86_64", "libarchive-3.1.2-10.el7_2.src.rpm", 110459, "BSD", "CentOS", "", "Manipulate tape archives", "RSA/SHA256, Thu Sep 15 23:18:53 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "19.el7", "x86_64", "unzip-6.0-19.el7.src.rpm", 373986, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA256, Wed Apr 25 11:50:02 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "scl-utils", "20130529", "19.el7", "x86_64", "scl-utils-20130529-19.el7.src.rpm", 25141, "GPLv2+", "CentOS", "", "Utilities for alternative packaging", "RSA/SHA256, Mon Nov 12 14:46:32 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release-scl", "2", "3.el7.centos", "noarch", "centos-release-scl-2-3.el7.centos.src.rpm", 20042, "GPLv2", "CentOS", "", "Software collections from the CentOS SCLo SIG", "RSA/SHA256, Mon Apr  1 15:32:14 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.0.2k", "16.el7_6.1", "x86_64", "openssl-1.0.2k-16.el7_6.1.src.rpm", 3204708, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Mon Mar 18 15:45:52 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib-devel", "1.2.7", "18.el7", "x86_64", "zlib-1.2.7-18.el7.src.rpm", 135536, "zlib and Boost", "CentOS", "", "Header files and libraries for Zlib development", "RSA/SHA256, Mon Nov 12 14:49:53 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "4.8.5", "36.el7_6.1", "x86_64", "gcc-4.8.5-36.el7_6.1.src.rpm", 179328, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC version 4.8 shared support library", "RSA/SHA256, Tue Mar 19 19:52:12 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmpc", "1.0.1", "3.el7", "x86_64", "libmpc-1.0.1-3.el7.src.rpm", 113833, "LGPLv3+ and GFDL", "CentOS", "", "C library for multiple precision complex arithmetic", "RSA/SHA256, Fri Jul  4 02:59:41 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "freetype", "2.8", "12.el7_6.1", "x86_64", "freetype-2.8-12.el7_6.1.src.rpm", 824497, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", "A free and portable font rendering engine", "RSA/SHA256, Fri Feb  1 16:19:35 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "freetype-devel", "2.8", "12.el7_6.1", "x86_64", "freetype-2.8-12.el7_6.1.src.rpm", 2980705, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", "FreeType development libraries and header files", "RSA/SHA256, Fri Feb  1 16:19:36 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "postgresql-libs", "9.2.24", "1.el7_5", "x86_64", "postgresql-9.2.24-1.el7_5.src.rpm", 683495, "PostgreSQL", "CentOS", "", "The shared libraries required for any PostgreSQL clients", "RSA/SHA256, Fri Aug 24 14:51:14 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontpackages-filesystem", "1.44", "8.el7", "noarch", "fontpackages-1.44-8.el7.src.rpm", 0, "Public Domain", "CentOS", "", "Directories used by font packages", "RSA/SHA256, Fri Jul  4 01:22:56 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libICE", "1.0.9", "9.el7", "x86_64", "libICE-1.0.9-9.el7.src.rpm", 152213, "MIT", "CentOS", "", "X.Org X11 ICE runtime library", "RSA/SHA256, Thu Aug 10 17:17:23 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcb", "1.13", "1.el7", "x86_64", "libxcb-1.13-1.el7.src.rpm", 1011680, "MIT", "CentOS", "", "A C binding to the X11 protocol", "RSA/SHA256, Mon Nov 12 14:39:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXau-devel", "1.0.8", "2.1.el7", "x86_64", "libXau-1.0.8-2.1.el7.src.rpm", 6519, "MIT", "CentOS", "", "Development files for libXau", "RSA/SHA256, Fri Jul  4 03:29:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libSM", "1.2.2", "2.el7", "x86_64", "libSM-1.2.2-2.el7.src.rpm", 81546, "MIT", "CentOS", "", "X.Org X11 SM runtime library", "RSA/SHA256, Wed Nov 25 15:08:11 2015, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rh-nodejs10-nodejs", "10.10.0", "2.el7", "x86_64", "rh-nodejs10-nodejs-10.10.0-2.el7.src.rpm", 28549171, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "", "JavaScript runtime", "RSA/SHA1, Wed Dec  5 23:56:39 2018, Key ID 4eb84e71f2ee9d55", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dejavu-sans-fonts", "2.33", "6.el7", "noarch", "dejavu-fonts-2.33-6.el7.src.rpm", 5395167, "Bitstream Vera and Public Domain", "CentOS", "", "Variable-width sans-serif font faces", "RSA/SHA256, Fri Jul  4 01:07:01 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libjpeg-turbo-devel", "1.2.90", "6.el7", "x86_64", "libjpeg-turbo-1.2.90-6.el7.src.rpm", 321845, "IJG", "CentOS", "", "Headers for the libjpeg-turbo library", "RSA/SHA256, Mon Nov 12 14:33:17 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 278173, "LGPLv2+", "CentOS", "", "Device mounting library", "RSA/SHA256, Tue Mar 19 19:52:49 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "mariadb-libs", "5.5.60", "1.el7_5", "x86_64", "mariadb-5.5.60-1.el7_5.src.rpm", 4615006, "GPLv2 with exceptions and LGPLv2 and BSD", "CentOS", "", "The shared libraries required for MariaDB/MySQL clients", "RSA/SHA256, Mon Aug 20 14:16:27 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid-devel", "2.23.2", "59.el7_6.1", "x86_64", "util-linux-2.23.2-59.el7_6.1.src.rpm", 17258, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Tue Mar 19 19:53:04 2019, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck", "1.4.1", "6.el7", "x86_64", "fipscheck-1.4.1-6.el7.src.rpm", 38839, "BSD", "CentOS", "", "A library for integrity verification of FIPS validated modules", "RSA/SHA256, Thu Aug 10 15:53:42 2017, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTTP-Tiny", "0.033", "3.el7", "noarch", "perl-HTTP-Tiny-0.033-3.el7.src.rpm", 97210, "GPL+ or Artistic", "CentOS", "", "Small, simple, correct HTTP/1.1 client", "RSA/SHA256, Fri Jul  4 04:19:08 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Perldoc", "3.20", "4.el7", "noarch", "perl-Pod-Perldoc-3.20-4.el7.src.rpm", 166910, "GPL+ or Artistic", "CentOS", "", "Look up Perl documentation in Pod format", "RSA/SHA256, Fri Jul  4 04:22:38 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Text-ParseWords", "3.29", "4.el7", "noarch", "perl-Text-ParseWords-3.29-4.el7.src.rpm", 16431, "GPL+ or Artistic", "CentOS", "", "Parse text into an array of tokens or array of arrays", "RSA/SHA256, Fri Jul  4 04:25:15 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Usage", "1.63", "3.el7", "noarch", "perl-Pod-Usage-1.63-3.el7.src.rpm", 44671, "GPL+ or Artistic", "CentOS", "", "Print a usage message from embedded POD documentation", "RSA/SHA256, Fri Jul  4 04:22:48 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Socket", "2.010", "4.el7", "x86_64", "perl-Socket-2.010-4.el7.src.rpm", 114497, "GPL+ or Artistic", "CentOS", "", "Networking constants and support functions", "RSA/SHA256, Sun Nov 20 20:02:40 2016, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Filter", "1.49", "3.el7", "x86_64", "perl-Filter-1.49-3.el7.src.rpm", 148475, "GPL+ or Artistic", "CentOS", "", "Perl source filters", "RSA/SHA256, Fri Jul  4 04:18:19 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Storable", "2.45", "3.el7", "x86_64", "perl-Storable-2.45-3.el7.src.rpm", 181031, "GPL+ or Artistic", "CentOS", "", "Persistence for Perl data structures", "RSA/SHA256, Fri Jul  4 04:23:18 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Exporter", "5.68", "3.el7", "noarch", "perl-Exporter-5.68-3.el7.src.rpm", 56612, "GPL+ or Artistic", "CentOS", "", "Implements default import method for modules", "RSA/SHA256, Fri Jul  4 04:17:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Time-Local", "1.2300", "2.el7", "noarch", "perl-Time-Local-1.2300-2.el7.src.rpm", 44062, "GPL+ or Artistic", "CentOS", "", "Efficiently compute time from local and GMT time", "RSA/SHA256, Fri Jul  4 04:25:36 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads-shared", "1.43", "6.el7", "x86_64", "perl-threads-shared-1.43-6.el7.src.rpm", 73972, "GPL+ or Artistic", "CentOS", "", "Perl extension for sharing data structures between threads", "RSA/SHA256, Fri Jul  4 04:25:26 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Path", "2.09", "2.el7", "noarch", "perl-File-Path-2.09-2.el7.src.rpm", 50067, "GPL+ or Artistic", "CentOS", "", "Create or remove directory trees", "RSA/SHA256, Fri Jul  4 04:18:06 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Scalar-List-Utils", "1.27", "248.el7", "x86_64", "perl-Scalar-List-Utils-1.27-248.el7.src.rpm", 67994, "GPL+ or Artistic", "CentOS", "", "A selection of general-utility scalar and list subroutines", "RSA/SHA256, Fri Jul  4 04:23:05 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Getopt-Long", "2.40", "3.el7", "noarch", "perl-Getopt-Long-2.40-3.el7.src.rpm", 134846, "GPLv2+ or Artistic", "CentOS", "", "Extended processing of command line options", "RSA/SHA256, Wed Apr 25 11:36:10 2018, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Error", "0.17020", "2.el7", "noarch", "perl-Error-0.17020-2.el7.src.rpm", 50015, "(GPL+ or Artistic) and MIT", "CentOS", "", "Error/exception handling in an OO-ish way", "RSA/SHA256, Fri Jul  4 04:17:32 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Data-Dumper", "2.145", "3.el7", "x86_64", "perl-Data-Dumper-2.145-3.el7.src.rpm", 99287, "GPL+ or Artistic", "CentOS", "", "Stringify perl data structures, suitable for printing and eval", "RSA/SHA256, Fri Jul  4 04:16:13 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Thread-Queue", "3.02", "2.el7", "noarch", "perl-Thread-Queue-3.02-2.el7.src.rpm", 27642, "GPL+ or Artistic", "CentOS", "", "Thread-safe queues", "RSA/SHA256, Fri Jul  4 04:25:23 2014, Key ID 24c6a8a7f4a80eb5", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it centos:8 bash
	// yum module install -y container-tools
	// yum groupinstall -y "Development tools"
	// yum -y install nodejs podman-docker
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"%{MODULARITYLABEL}\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/(none)//g"
	CentOS8Modularitylabel = []*PackageInfo{
		{intRef(), "strace", "4.24", "9.el8", "x86_64", "strace-4.24-9.el8.src.rpm", 2176244, "LGPL-2.1+ and GPL-2.0+", "CentOS", "", "Tracks and displays system calls associated with a running process", "RSA/SHA256, Sun Apr 26 03:02:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcb", "1.13.1", "1.el8", "x86_64", "libxcb-1.13.1-1.el8.src.rpm", 1028472, "MIT", "CentOS", "", "A C binding to the X11 protocol", "RSA/SHA256, Thu Apr  9 03:50:23 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-gpg-keys", "8.2", "2.2004.0.1.el8", "noarch", "centos-release-8.2-2.2004.0.1.el8.src.rpm", 3370, "GPLv2", "CentOS", "", "CentOS Linux RPM keys", "RSA/SHA256, Wed Jun  3 01:09:47 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "byacc", "1.9.20170709", "4.el8", "x86_64", "byacc-1.9.20170709-4.el8.src.rpm", 253862, "Public Domain", "CentOS", "", "Berkeley Yacc, a parser generator", "RSA/SHA256, Mon Jul  1 20:54:04 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrender", "0.9.10", "7.el8", "x86_64", "libXrender-0.9.10-7.el8.src.rpm", 52595, "MIT", "CentOS", "", "X.Org X11 libXrender runtime library", "RSA/SHA256, Mon Jul  1 23:56:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.8", "2.el8", "x86_64", "filesystem-3.8-2.el8.src.rpm", 0, "Public Domain", "CentOS", "", "The basic directory layout for a Linux system", "RSA/SHA256, Mon Jul  1 21:32:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-gobject", "3.28.3", "1.el8", "x86_64", "pygobject3-3.28.3-1.el8.src.rpm", 16432, "LGPLv2+ and MIT", "CentOS", "", "Python 3 bindings for GObject Introspection", "RSA/SHA256, Tue Jul  2 01:04:50 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre2", "10.32", "1.el8", "x86_64", "pcre2-10.32-1.el8.src.rpm", 667046, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Tue Jul  2 00:38:38 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "containernetworking-plugins", "0.8.3", "5.module_el8.2.0+305+5e198a41", "x86_64", "containernetworking-plugins-0.8.3-5.module_el8.2.0+305+5e198a41.src.rpm", 74349750, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "CNI network plugins", "RSA/SHA256, Tue May 12 14:26:07 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 9531204, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", "Common binaries and locale data for glibc", "RSA/SHA256, Fri May  1 21:04:19 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "toolbox", "0.0.7", "1.module_el8.2.0+305+5e198a41", "noarch", "toolbox-0.0.7-1.module_el8.2.0+305+5e198a41.src.rpm", 18199, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "Script to launch privileged container with podman", "RSA/SHA256, Tue May 12 14:56:17 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.11", "13.el8", "x86_64", "zlib-1.2.11-13.el8.src.rpm", 195551, "zlib and Boost", "CentOS", "", "The compression and decompression library", "RSA/SHA256, Tue Apr  7 01:20:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "udica", "0.2.1", "2.module_el8.2.0+305+5e198a41", "noarch", "udica-0.2.1-2.module_el8.2.0+305+5e198a41.src.rpm", 106242, "GPLv3+", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "A tool for generating SELinux security policies for containers", "RSA/SHA256, Tue May 12 14:56:20 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.31", "1.el8", "x86_64", "libgpg-error-1.31-1.el8.src.rpm", 902818, "LGPLv2+", "CentOS", "", "Library for error values used by GnuPG components", "RSA/SHA256, Mon Jul  1 23:20:59 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Carp", "1.42", "396.el8", "noarch", "perl-Carp-1.42-396.el8.src.rpm", 41852, "GPL+ or Artistic", "CentOS", "", "Alternative warn and die for modules", "RSA/SHA256, Tue Jul  2 00:40:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcrypt", "4.1.1", "4.el8", "x86_64", "libxcrypt-4.1.1-4.el8.src.rpm", 194420, "LGPLv2+ and BSD and Public Domain", "CentOS", "", "Extended crypt library for DES, MD5, Blowfish and others", "RSA/SHA256, Mon Jul  1 23:53:52 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(3), "perl-Scalar-List-Utils", "1.49", "2.el8", "x86_64", "perl-Scalar-List-Utils-1.49-2.el8.src.rpm", 124632, "GPL+ or Artistic", "CentOS", "", "A selection of general-utility scalar and list subroutines", "RSA/SHA256, Tue Jul  2 00:50:25 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 1855607, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GNU Standard C++ Library", "RSA/SHA256, Fri Apr 17 22:06:46 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 331057, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC OpenMP v4.5 shared support library", "RSA/SHA256, Fri Apr 17 22:06:36 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "7.0", "10.el8", "x86_64", "readline-7.0-10.el8.src.rpm", 466321, "GPLv3+", "CentOS", "", "A library for editing typed command lines", "RSA/SHA256, Tue Jul  2 01:21:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "m4", "1.4.18", "7.el8", "x86_64", "m4-1.4.18-7.el8.src.rpm", 379304, "GPLv3+", "CentOS", "", "The GNU macro processor", "RSA/SHA256, Tue Jul  2 00:01:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.53", "1.el8", "x86_64", "acl-2.2.53-1.el8.src.rpm", 59272, "LGPLv2+", "CentOS", "", "Dynamic library for access control list support", "RSA/SHA256, Mon Jul  1 23:05:20 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "cups-libs", "2.2.6", "33.el8", "x86_64", "cups-2.2.6-33.el8.src.rpm", 947548, "LGPLv2 and zlib", "CentOS", "", "CUPS printing system - libraries", "RSA/SHA256, Sun Apr 26 01:54:00 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 398154, "LGPLv2+", "CentOS", "", "Device mounting library", "RSA/SHA256, Sun Apr 26 02:22:05 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcursor", "1.1.15", "3.el8", "x86_64", "libXcursor-1.1.15-3.el8.src.rpm", 48759, "MIT", "CentOS", "", "Cursor management library", "RSA/SHA256, Mon Jul  1 23:54:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsmartcols", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 244258, "LGPLv2+", "CentOS", "", "Formatting library for ls-like programs.", "RSA/SHA256, Sun Apr 26 02:23:14 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXt", "1.1.5", "12.el8", "x86_64", "libXt-1.1.5-12.el8.src.rpm", 597617, "MIT", "CentOS", "", "X.Org X11 libXt runtime library", "RSA/SHA256, Thu Dec  5 01:04:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.14", "5.el8_0", "x86_64", "p11-kit-0.23.14-5.el8_0.src.rpm", 1394732, "BSD", "CentOS", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Sat Aug  3 19:31:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-Errno", "1.28", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 9495, "GPL+ or Artistic", "CentOS", "", "System errno constants", "RSA/SHA256, Tue Jul  2 00:44:05 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.9", "3.el8", "x86_64", "libunistring-0.9.9-3.el8.src.rpm", 1855932, "GPLv2+ or LGPLv3+", "CentOS", "", "GNU Unicode string library", "RSA/SHA256, Mon Jul  1 23:48:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Path", "2.15", "2.el8", "noarch", "perl-File-Path-2.15-2.el8.src.rpm", 64920, "GPL+ or Artistic", "CentOS", "", "Create or remove directory trees", "RSA/SHA256, Tue Jul  2 00:44:52 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gdbm-libs", "1.18", "1.el8", "x86_64", "gdbm-1.18-1.el8.src.rpm", 135248, "GPLv3+", "CentOS", "", "Libraries files for gdbm", "RSA/SHA256, Mon Jul  1 21:40:18 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-threads", "2.21", "2.el8", "x86_64", "perl-threads-2.21-2.el8.src.rpm", 109155, "GPL+ or Artistic", "CentOS", "", "Perl interpreter-based threads", "RSA/SHA256, Tue Jul  2 00:52:55 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lzo", "2.08", "14.el8", "x86_64", "lzo-2.08-14.el8.src.rpm", 198757, "GPLv2+", "CentOS", "", "Data compression library with very fast (de)compression", "RSA/SHA256, Tue Jul  2 00:01:31 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-IO-Socket-IP", "0.39", "5.el8", "noarch", "perl-IO-Socket-IP-0.39-5.el8.src.rpm", 99525, "GPL+ or Artistic", "CentOS", "", "Drop-in replacement for IO::Socket::INET supporting both IPv4 and IPv6", "RSA/SHA256, Tue Jul  2 00:45:59 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 380576, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "Libraries for accessing D-BUS", "RSA/SHA256, Fri Aug  7 22:56:51 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xml-common", "0.6.3", "50.el8", "noarch", "sgml-common-0.6.3-50.el8.src.rpm", 80250, "GPL+", "CentOS", "", "Common XML catalog and DTD files", "RSA/SHA256, Tue Jul  2 02:04:25 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "procps-ng", "3.3.15", "1.el8", "x86_64", "procps-ng-3.3.15-1.el8.src.rpm", 938380, "GPL+ and GPLv2 and GPLv2+ and GPLv3+ and LGPLv2+", "CentOS", "", "System and process monitoring utilities", "RSA/SHA256, Tue Jul  2 01:00:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "efivar-libs", "36", "1.el8", "x86_64", "efivar-36-1.el8.src.rpm", 250520, "LGPLv2.1", "CentOS", "", "Library to manage UEFI variables", "RSA/SHA256, Mon Jul  1 21:20:27 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gdbm", "1.18", "1.el8", "x86_64", "gdbm-1.18-1.el8.src.rpm", 399977, "GPLv3+", "CentOS", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Mon Jul  1 21:40:12 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "javapackages-filesystem", "5.3.0", "1.module_el8.0.0+11+5b8c10bd", "noarch", "javapackages-tools-5.3.0-1.module_el8.0.0+11+5b8c10bd.src.rpm", 1935, "BSD", "CentOS", "javapackages-runtime:201801:8000020190530193251:278695df", "Java packages filesystem layout", "RSA/SHA256, Wed Jul 31 00:11:10 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfdisk", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 438722, "LGPLv2+", "CentOS", "", "Partitioning library for fdisk-like programs.", "RSA/SHA256, Sun Apr 26 02:20:20 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "mokutil", "0.3.0", "9.el8", "x86_64", "mokutil-0.3.0-9.el8.src.rpm", 89577, "GPLv3+", "CentOS", "", "Tool to manage UEFI Secure Boot MoK Keys", "RSA/SHA256, Tue Jul  2 00:12:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "snappy", "1.1.7", "5.el8", "x86_64", "snappy-1.1.7-5.el8.src.rpm", 58789, "BSD", "CentOS", "", "Fast compression and decompression library", "RSA/SHA256, Tue Jul  2 01:32:04 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Error", "0.17025", "2.el8", "noarch", "perl-Error-0.17025-2.el8.src.rpm", 71565, "(GPL+ or Artistic) and MIT", "CentOS", "", "Error/exception handling in an OO-ish way", "RSA/SHA256, Tue Jul  2 00:44:06 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libksba", "1.3.5", "7.el8", "x86_64", "libksba-1.3.5-7.el8.src.rpm", 342935, "(LGPLv3+ or GPLv2+) and GPLv3+", "CentOS", "", "CMS and X.509 library", "RSA/SHA256, Mon Jul  1 23:27:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Escapes", "1.07", "395.el8", "noarch", "perl-Pod-Escapes-1.07-395.el8.src.rpm", 25763, "GPL+ or Artistic", "CentOS", "", "Resolve POD escape sequences", "RSA/SHA256, Tue Jul  2 00:49:59 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmnl", "1.0.4", "6.el8", "x86_64", "libmnl-1.0.4-6.el8.src.rpm", 53687, "LGPLv2+", "CentOS", "", "A minimalistic Netlink library", "RSA/SHA256, Mon Jul  1 23:29:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-timer", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 26226, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost timer library", "RSA/SHA256, Thu Apr  9 03:29:54 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libseccomp", "2.4.1", "1.el8", "x86_64", "libseccomp-2.4.1-1.el8.src.rpm", 402960, "LGPLv2", "CentOS", "", "Enhanced seccomp library", "RSA/SHA256, Thu Dec  5 00:52:51 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpp", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 29644557, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "The C Preprocessor", "RSA/SHA256, Fri Apr 17 22:05:20 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnsl2", "1.2.0", "2.20180605git4a062cf.el8", "x86_64", "libnsl2-1.2.0-2.20180605git4a062cf.el8.src.rpm", 147122, "BSD and LGPLv2+", "CentOS", "", "Public client interface library for NIS(YP) and NIS+", "RSA/SHA256, Mon Jul  1 23:33:03 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jasper-libs", "2.0.14", "4.el8", "x86_64", "jasper-2.0.14-4.el8.src.rpm", 389890, "JasPer", "CentOS", "", "Runtime libraries for jasper", "RSA/SHA256, Mon Jul  1 22:52:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "crypto-policies", "20191128", "2.git23e1bf1.el8", "noarch", "crypto-policies-20191128-2.git23e1bf1.el8.src.rpm", 190228, "LGPLv2+", "CentOS", "", "System-wide crypto policies", "RSA/SHA256, Thu Apr  9 03:32:16 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-sysinit", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 14402, "MPLv2.0", "CentOS", "", "System NSS Initialization", "RSA/SHA256, Tue Aug 11 23:26:30 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.28", "37.el8", "x86_64", "libdb-5.3.28-37.el8.src.rpm", 2515048, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "The Berkeley DB database library for C", "RSA/SHA256, Thu Dec  5 00:17:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck-lib", "1.5.0", "4.el8", "x86_64", "fipscheck-1.5.0-4.el8.src.rpm", 12433, "BSD", "CentOS", "", "Library files for fipscheck", "RSA/SHA256, Mon Jul  1 21:33:02 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "3.6.8", "11.el8_2", "x86_64", "gnutls-3.6.8-11.el8_2.src.rpm", 2687433, "GPLv3+ and LGPLv2+", "CentOS", "", "A TLS protocol implementation", "RSA/SHA256, Tue Jun 23 13:26:40 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "docbook-dtds", "1.0", "69.el8", "noarch", "docbook-dtds-1.0-69.el8.src.rpm", 8665150, "Copyright only", "CentOS", "", "SGML and XML document type definitions for DocBook", "RSA/SHA256, Mon Jul  1 21:15:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ima-evm-utils", "1.1", "5.el8", "x86_64", "ima-evm-utils-1.1-5.el8.src.rpm", 123538, "GPLv2", "CentOS", "", "IMA/EVM support utilities", "RSA/SHA256, Wed Dec  4 23:57:28 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf-plugins-core", "4.0.12", "4.el8_2", "noarch", "dnf-plugins-core-4.0.12-4.el8_2.src.rpm", 16900, "GPLv2+", "CentOS", "", "Core Plugins for DNF", "RSA/SHA256, Wed Sep 16 20:09:39 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.27", "1.el8", "x86_64", "cyrus-sasl-2.1.27-1.el8.src.rpm", 734978, "BSD with advertising", "CentOS", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Wed Dec  4 23:01:41 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Term-Cap", "1.17", "395.el8", "noarch", "perl-Term-Cap-1.17-395.el8.src.rpm", 29850, "GPL+ or Artistic", "CentOS", "", "Perl termcap interface", "RSA/SHA256, Tue Jul  2 00:51:28 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(32), "bind-export-libs", "9.11.13", "5.el8_2", "x86_64", "bind-9.11.13-5.el8_2.src.rpm", 3067121, "MPLv2.0", "CentOS", "", "ISC libs for DHCP application", "RSA/SHA256, Tue Jul  7 15:02:11 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsecret", "0.18.6", "1.el8", "x86_64", "libsecret-0.18.6-1.el8.src.rpm", 520362, "LGPLv2+", "CentOS", "", "Library for storing and retrieving passwords and other secrets", "RSA/SHA256, Mon Jul  1 23:41:18 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsolv", "0.7.7", "1.el8", "x86_64", "libsolv-0.7.7-1.el8.src.rpm", 789176, "BSD", "CentOS", "", "Package dependency solver", "RSA/SHA256, Wed Jan 15 19:26:47 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libicu", "60.3", "2.el8_1", "x86_64", "icu-60.3-2.el8_1.src.rpm", 33716339, "MIT and UCD and Public Domain", "CentOS", "", "International Components for Unicode - libraries", "RSA/SHA256, Sat Mar 21 01:07:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.2.9", "1.el8", "x86_64", "gnupg2-2.2.9-1.el8.src.rpm", 9632671, "GPLv3+", "CentOS", "", "Utility for secure communication and data storage", "RSA/SHA256, Mon Jul  1 22:24:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git-core", "2.18.4", "2.el8_2", "x86_64", "git-2.18.4-2.el8_2.src.rpm", 24912186, "GPLv2", "CentOS", "", "Core package of git with minimal functionality", "RSA/SHA256, Mon May 11 17:33:37 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libdnf", "0.39.1", "6.el8_2", "x86_64", "libdnf-0.39.1-6.el8_2.src.rpm", 3666814, "LGPLv2+", "CentOS", "", "Python 3 bindings for the libdnf library.", "RSA/SHA256, Fri Aug  7 23:40:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcrypt-devel", "4.1.1", "4.el8", "x86_64", "libxcrypt-4.1.1-4.el8.src.rpm", 24771, "LGPLv2+ and BSD and Public Domain", "CentOS", "", "Development files for libxcrypt", "RSA/SHA256, Mon Jul  1 23:53:54 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf-data", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 36254, "GPLv2+ and GPLv2 and GPL", "CentOS", "", "Common data and configuration files for DNF", "RSA/SHA256, Fri Aug  7 23:00:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Pod-Simple", "3.35", "395.el8", "noarch", "perl-Pod-Simple-3.35-395.el8.src.rpm", 543719, "GPL+ or Artistic", "CentOS", "", "Framework for parsing POD documentation", "RSA/SHA256, Tue Jul  2 00:50:10 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(8), "device-mapper", "1.02.169", "3.el8", "x86_64", "lvm2-2.03.08-3.el8.src.rpm", 355102, "GPLv2", "CentOS", "", "Device mapper utility", "RSA/SHA256, Sun Apr 26 01:54:15 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Pod-Perldoc", "3.28", "396.el8", "noarch", "perl-Pod-Perldoc-3.28-396.el8.src.rpm", 169228, "GPL+ or Artistic", "CentOS", "", "Look up Perl documentation in Pod format", "RSA/SHA256, Tue Jul  2 00:50:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 717567, "GPLv2+ or LGPLv3+", "CentOS", "", "Libraries to handle compiled objects", "RSA/SHA256, Sun Apr 26 02:01:05 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-URI", "1.73", "3.el8", "noarch", "perl-URI-1.73-3.el8.src.rpm", 216452, "GPL+ or Artistic", "CentOS", "", "A Perl module implementing URI parsing and manipulation", "RSA/SHA256, Tue Jul  2 00:53:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iputils", "20180629", "2.el8", "x86_64", "iputils-20180629-2.el8.src.rpm", 351665, "BSD and GPLv2+", "CentOS", "", "Network monitoring tools including ping", "RSA/SHA256, Thu Dec  5 00:02:06 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git", "2.18.4", "2.el8_2", "x86_64", "git-2.18.4-2.el8_2.src.rpm", 399381, "GPLv2", "CentOS", "", "Fast Version Control System", "RSA/SHA256, Mon May 11 17:33:36 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-udev", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 7940076, "LGPLv2+", "CentOS", "", "Rule-based device node and kernel event manager", "RSA/SHA256, Sat Aug  8 01:28:22 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zstd", "1.4.2", "2.el8", "x86_64", "zstd-1.4.2-2.el8.src.rpm", 1550971, "BSD and GPLv2", "CentOS", "", "Zstd compression library", "RSA/SHA256, Wed Jan 22 15:07:11 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 215992, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Sun Apr 26 02:52:00 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rust-srpm-macros", "5", "2.el8", "noarch", "rust-srpm-macros-5-2.el8.src.rpm", 1131, "MIT", "CentOS", "", "RPM macros for building Rust source packages", "RSA/SHA256, Tue Jul  2 01:26:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 70885, "GPLv2+ and GPLv2 and GPL", "CentOS", "", "Package manager", "RSA/SHA256, Fri Aug  7 23:00:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-srpm-macros", "1", "25.el8", "noarch", "perl-srpm-macros-1-25.el8.src.rpm", 794, "GPLv3+", "CentOS", "", "RPM macros for building Perl source package from source repository", "RSA/SHA256, Tue Jul  2 00:50:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "8.0.1763", "13.el8", "x86_64", "vim-8.0.1763-13.el8.src.rpm", 1420484, "Vim and MIT", "CentOS", "", "A minimal version of the VIM editor", "RSA/SHA256, Thu Dec  5 04:05:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua", "5.3.4", "11.el8", "x86_64", "lua-5.3.4-11.el8.src.rpm", 638964, "MIT", "CentOS", "", "Powerful light-weight programming language", "RSA/SHA256, Thu Dec  5 01:12:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "22.el8", "noarch", "rootfiles-8.1-22.el8.src.rpm", 599, "Public Domain", "CentOS", "", "The basic required files for the root user's directory", "RSA/SHA256, Tue Jul  2 01:23:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++-devel", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 11807826, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Header files and libraries for C++ development", "RSA/SHA256, Fri Apr 17 22:06:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "nodejs", "10.21.0", "3.module_el8.2.0+391+8da3adc6", "x86_64", "nodejs-10.21.0-3.module_el8.2.0+391+8da3adc6.src.rpm", 31483781, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "nodejs:10:8020020200707141642:6a468ee4", "JavaScript runtime", "RSA/SHA256, Tue Jul  7 16:08:24 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libipt", "1.6.1", "8.el8", "x86_64", "libipt-1.6.1-8.el8.src.rpm", 108543, "BSD", "CentOS", "", "Intel Processor Trace Decoder Library", "RSA/SHA256, Mon Jul  1 23:25:06 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnl3", "3.5.0", "1.el8", "x86_64", "libnl3-3.5.0-1.el8.src.rpm", 994296, "LGPLv2", "CentOS", "", "Convenience library for kernel netlink sockets", "RSA/SHA256, Thu Apr  9 03:47:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xorg-x11-fonts-ISO8859-1-100dpi", "7.5", "19.el8", "noarch", "xorg-x11-fonts-7.5-19.el8.src.rpm", 1070824, "MIT and Lucida and Public Domain", "CentOS", "", "A set of 100dpi ISO-8859-1 fonts for X", "RSA/SHA256, Tue Jul  2 02:06:32 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "slirp4netns", "0.4.2", "3.git21fdece.module_el8.2.0+305+5e198a41", "x86_64", "slirp4netns-0.4.2-3.git21fdece.module_el8.2.0+305+5e198a41.src.rpm", 173387, "GPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "slirp for network namespaces", "RSA/SHA256, Tue May 12 14:55:34 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libatomic_ops", "7.6.2", "3.el8", "x86_64", "libatomic_ops-7.6.2-3.el8.src.rpm", 76822, "GPLv2 and MIT", "CentOS", "", "Atomic memory update operations", "RSA/SHA256, Mon Jul  1 23:06:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdk-pixbuf2", "2.36.12", "5.el8", "x86_64", "gdk-pixbuf2-2.36.12-5.el8.src.rpm", 2657576, "LGPLv2+", "CentOS", "", "An image loading library", "RSA/SHA256, Wed Dec  4 23:22:33 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXxf86vm", "1.1.4", "9.el8", "x86_64", "libXxf86vm-1.1.4-9.el8.src.rpm", 26424, "MIT", "CentOS", "", "X.Org X11 libXxf86vm runtime library", "RSA/SHA256, Mon Jul  1 23:57:18 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnfnetlink", "1.0.1", "13.el8", "x86_64", "libnfnetlink-1.0.1-13.el8.src.rpm", 52395, "GPLv2+", "CentOS", "", "Netfilter netlink userspace library", "RSA/SHA256, Mon Jul  1 23:32:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-c059-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1460348, "AGPLv3", "CentOS", "", "C059 font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "abattis-cantarell-fonts", "0.0.25", "4.el8", "noarch", "abattis-cantarell-fonts-0.0.25-4.el8.src.rpm", 302227, "OFL", "CentOS", "", "Cantarell, a Humanist sans-serif font family", "RSA/SHA256, Mon Jul  1 20:37:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-nimbus-roman-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1429675, "AGPLv3", "CentOS", "", "Nimbus Roman font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:33 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit", "3.0", "0.17.20191104git1c2f876.el8", "x86_64", "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm", 671305, "GPLv2+", "CentOS", "", "User space tools for kernel auditing", "RSA/SHA256, Sun Apr 26 01:45:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-z003-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 400088, "AGPLv3", "CentOS", "", "Z003 font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:37 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libteam", "1.29", "1.el8_2.2", "x86_64", "libteam-1.29-1.el8_2.2.src.rpm", 106092, "LGPLv2+", "CentOS", "", "Library for controlling team network device", "RSA/SHA256, Wed Sep 16 20:20:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lcms2", "2.9", "2.el8", "x86_64", "lcms2-2.9-2.el8.src.rpm", 399313, "MIT", "CentOS", "", "Color Management Engine", "RSA/SHA256, Mon Jul  1 23:03:43 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-slip", "0.6.4", "11.el8", "noarch", "python-slip-0.6.4-11.el8.src.rpm", 61396, "GPLv2+", "CentOS", "", "Convenience, extension and workaround code for Python 3.x", "RSA/SHA256, Tue Jul  2 01:10:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdk-pixbuf2-modules", "2.36.12", "5.el8", "x86_64", "gdk-pixbuf2-2.36.12-5.el8.src.rpm", 315856, "LGPLv2+", "CentOS", "", "Additional image modules for gdk-pixbuf", "RSA/SHA256, Wed Dec  4 23:22:52 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-decorator", "4.2.1", "2.el8", "noarch", "python-decorator-4.2.1-2.el8.src.rpm", 47871, "BSD", "CentOS", "", "Module to simplify usage of decorators in python3", "RSA/SHA256, Tue Jul  2 01:04:20 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "annobin", "8.90", "1.el8.0.1", "x86_64", "annobin-8.90-1.el8.0.1.src.rpm", 432502, "GPLv3+", "CentOS", "", "Binary annotation plugin for GCC", "RSA/SHA256, Fri Apr 17 16:56:19 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mozjs60", "60.9.0", "4.el8", "x86_64", "mozjs60-60.9.0-4.el8.src.rpm", 23728688, "MPLv2.0 and MPLv1.1 and BSD and GPLv2+ and GPLv3+ and LGPLv2+ and AFL and ASL 2.0", "CentOS", "", "SpiderMonkey JavaScript library", "RSA/SHA256, Fri Apr 24 20:36:56 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gtk-update-icon-cache", "3.22.30", "5.el8", "x86_64", "gtk3-3.22.30-5.el8.src.rpm", 60214, "LGPLv2+", "CentOS", "", "Icon theme caching utility", "RSA/SHA256, Thu Apr  9 03:41:01 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstemmer", "0", "10.585svn.el8", "x86_64", "libstemmer-0-10.585svn.el8.src.rpm", 361957, "BSD", "CentOS", "", "C stemming algorithm library", "RSA/SHA256, Mon Jul  1 23:45:28 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "go-srpm-macros", "2", "16.el8", "noarch", "go-srpm-macros-2-16.el8.src.rpm", 18532, "GPLv3+", "CentOS", "", "RPM macros for building Golang packages for various architectures", "RSA/SHA256, Mon Jul  1 22:29:16 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmodman", "2.0.1", "17.el8", "x86_64", "libmodman-2.0.1-17.el8.src.rpm", 69479, "LGPLv2+", "CentOS", "", "A simple library for managing C++ modules (plug-ins)", "RSA/SHA256, Mon Jul  1 23:29:53 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gtk2", "2.24.32", "4.el8", "x86_64", "gtk2-2.24.32-4.el8.src.rpm", 13811558, "LGPLv2+", "CentOS", "", "GTK+ graphical user interface library", "RSA/SHA256, Mon Jul  1 22:33:48 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsoup", "2.62.3", "1.el8", "x86_64", "libsoup-2.62.3-1.el8.src.rpm", 1594291, "LGPLv2", "CentOS", "", "Soup, an HTTP library implementation", "RSA/SHA256, Mon Jul  1 23:43:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "efi-srpm-macros", "3", "2.el8", "noarch", "efi-rpm-macros-3-2.el8.src.rpm", 39223, "GPLv3+", "CentOS", "", "Common SRPM Macros for building EFI-related packages", "RSA/SHA256, Mon Jul  1 21:20:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "teamd", "1.29", "1.el8_2.2", "x86_64", "libteam-1.29-1.el8_2.2.src.rpm", 278854, "LGPLv2+", "CentOS", "", "Team network device control daemon", "RSA/SHA256, Wed Sep 16 20:30:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "source-highlight", "3.1.8", "16.el8", "x86_64", "source-highlight-3.1.8-16.el8.src.rpm", 3516067, "GPLv3+", "CentOS", "", "Produces a document with syntax highlighting", "RSA/SHA256, Tue Jul  2 01:32:35 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffutils", "3.6", "6.el8", "x86_64", "diffutils-3.6-6.el8.src.rpm", 1369962, "GPLv3+", "CentOS", "", "A GNU collection of diff utilities", "RSA/SHA256, Thu Apr  9 03:34:45 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-runtime", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 1393756, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - runtime", "RSA/SHA256, Sun Apr 26 03:04:37 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "selinux-policy-targeted", "3.14.3", "41.el8_2.8", "noarch", "selinux-policy-3.14.3-41.el8_2.8.src.rpm", 52586852, "GPLv2+", "CentOS", "", "SELinux targeted base policy", "RSA/SHA256, Fri Oct 30 16:22:16 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "graphviz", "2.40.1", "40.el8", "x86_64", "graphviz-2.40.1-40.el8.src.rpm", 7807623, "EPL-1.0", "CentOS", "", "Graph Visualization Tools", "RSA/SHA256, Tue Apr  7 01:15:41 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "checkpolicy", "2.9", "1.el8", "x86_64", "checkpolicy-2.9-1.el8.src.rpm", 1768984, "GPLv2", "CentOS", "", "SELinux policy compiler", "RSA/SHA256, Wed Dec  4 22:51:20 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb", "8.2", "11.el8", "x86_64", "gdb-8.2-11.el8.src.rpm", 363845, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and LGPLv3+ and BSD and Public Domain and GFDL", "CentOS", "", "A stub package for GNU source-level debugger", "RSA/SHA256, Sun Apr 26 02:04:51 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "NetworkManager-libnm", "1.22.8", "5.el8_2", "x86_64", "NetworkManager-1.22.8-5.el8_2.src.rpm", 9207215, "LGPLv2+", "CentOS", "", "Libraries for adding NetworkManager support to applications (new API).", "RSA/SHA256, Fri Aug  7 22:45:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "intltool", "0.51.0", "11.el8", "noarch", "intltool-0.51.0-11.el8.src.rpm", 173158, "GPLv2 with exceptions", "CentOS", "", "Utility for internationalizing various kinds of data files", "RSA/SHA256, Mon Jul  1 22:49:06 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-psutil", "5.4.3", "10.el8", "x86_64", "python-psutil-5.4.3-10.el8.src.rpm", 2041226, "BSD", "CentOS", "", "A process and system utilities module for Python", "RSA/SHA256, Wed May  6 03:26:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patchutils", "0.3.4", "10.el8", "x86_64", "patchutils-0.3.4-10.el8.src.rpm", 285091, "GPLv2+", "CentOS", "", "A collection of programs for manipulating patch files", "RSA/SHA256, Tue Jul  2 00:33:48 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "criu", "3.12", "9.module_el8.2.0+305+5e198a41", "x86_64", "criu-3.12-9.module_el8.2.0+305+5e198a41.src.rpm", 1332765, "GPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "Tool for Checkpoint/Restore in User-space", "RSA/SHA256, Tue May 12 14:27:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 190232, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC version 8 shared support library", "RSA/SHA256, Fri Apr 17 22:06:32 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXau", "1.0.8", "13.el8", "x86_64", "libXau-1.0.8-13.el8.src.rpm", 59505, "MIT", "CentOS", "", "Sample Authorization Protocol for X", "RSA/SHA256, Mon Jul  1 23:53:21 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-pip-wheel", "9.0.3", "16.el8", "noarch", "python-pip-9.0.3-16.el8.src.rpm", 1255748, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "CentOS", "", "The pip wheel", "RSA/SHA256, Sun Apr 26 02:49:23 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11-common", "1.6.8", "3.el8", "noarch", "libX11-1.6.8-3.el8.src.rpm", 1339608, "MIT", "CentOS", "", "Common data for libX11", "RSA/SHA256, Sun Apr 26 02:26:11 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-release", "8.2", "2.2004.0.1.el8", "x86_64", "centos-release-8.2-2.2004.0.1.el8.src.rpm", 25430, "GPLv2", "CentOS", "", "CentOS Linux release file", "RSA/SHA256, Wed Jun  3 01:09:51 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXext", "1.3.3", "9.el8", "x86_64", "libXext-1.3.3-9.el8.src.rpm", 97990, "MIT", "CentOS", "", "X.Org X11 libXext runtime library", "RSA/SHA256, Mon Jul  1 23:54:20 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.12.2", "5.el8", "noarch", "setup-2.12.2-5.el8.src.rpm", 724831, "Public Domain", "CentOS", "", "A set of system configuration and setup files", "RSA/SHA256, Tue Apr  7 01:19:41 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cairo", "1.15.12", "3.el8", "x86_64", "cairo-1.15.12-3.el8.src.rpm", 1881396, "LGPLv2 or MPLv1.1", "CentOS", "", "A 2D graphics library", "RSA/SHA256, Mon Jul  1 20:54:51 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "11", "5.el8", "noarch", "basesystem-11-5.el8.src.rpm", 0, "Public Domain", "CentOS", "", "The skeleton package which defines a simple centos system", "RSA/SHA256, Mon Jul  1 20:45:34 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-cairo", "1.16.3", "6.el8", "x86_64", "pycairo-1.16.3-6.el8.src.rpm", 324125, "MPLv1.1 or LGPLv2", "CentOS", "", "Python 3 bindings for the cairo library", "RSA/SHA256, Tue Jul  2 01:03:39 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "6.1", "7.20180224.el8", "noarch", "ncurses-6.1-7.20180224.el8.src.rpm", 290089, "MIT", "CentOS", "", "Descriptions of common terminals", "RSA/SHA256, Tue Jul  2 00:16:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setroubleshoot-plugins", "3.3.11", "2.el8", "noarch", "setroubleshoot-plugins-3.3.11-2.el8.src.rpm", 2621479, "GPLv2+", "CentOS", "", "Analysis plugins for use with setroubleshoot", "RSA/SHA256, Sun Apr 26 02:58:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.9", "3.el8", "x86_64", "libselinux-2.9-3.el8.src.rpm", 305912, "Public Domain", "CentOS", "", "SELinux library and simple utilities", "RSA/SHA256, Tue Apr 14 06:05:19 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cockpit-system", "211.3", "1.el8", "noarch", "cockpit-211.3-1.el8.src.rpm", 2428779, "LGPLv2+", "CentOS", "", "Cockpit admin interface package for configuring and troubleshooting a system", "RSA/SHA256, Sun Apr 26 01:52:07 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-minimal-langpack", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 0, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", "Minimal language packs for glibc.", "RSA/SHA256, Fri May  1 21:07:23 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "conmon", "2.0.6", "1.module_el8.2.0+305+5e198a41", "x86_64", "conmon-2.0.6-1.module_el8.2.0+305+5e198a41.src.rpm", 85817, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "OCI container runtime monitor", "RSA/SHA256, Tue May 12 14:25:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 17885631, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", "The GNU libc libraries", "RSA/SHA256, Fri May  1 21:04:11 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cockpit-podman", "12", "1.module_el8.2.0+305+5e198a41", "noarch", "cockpit-podman-12-1.module_el8.2.0+305+5e198a41.src.rpm", 4244724, "LGPLv2+", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "Cockpit component for Podman containers", "RSA/SHA256, Tue May 12 14:25:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.9", "1.el8", "x86_64", "libsepol-2.9-1.el8.src.rpm", 996264, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Thu Dec  5 00:54:06 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "buildah", "1.11.6", "7.module_el8.2.0+305+5e198a41", "x86_64", "buildah-1.11.6-7.module_el8.2.0+305+5e198a41.src.rpm", 37059509, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "A command line tool used for creating OCI Images", "RSA/SHA256, Tue May 12 14:21:47 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.4", "3.el8", "x86_64", "xz-5.2.4-3.el8.src.rpm", 194799, "Public Domain", "CentOS", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Tue Jul  2 02:08:32 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-podman-api", "1.2.0", "0.2.gitd0a45fe.module_el8.2.0+305+5e198a41", "noarch", "python-podman-api-1.2.0-0.2.gitd0a45fe.module_el8.2.0+305+5e198a41.src.rpm", 120489, "LGPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "Podman API", "RSA/SHA256, Tue May 12 14:51:43 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.26", "3.el8", "x86_64", "libcap-2.26-3.el8.src.rpm", 124170, "GPLv2", "CentOS", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Tue Apr  7 01:16:50 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "podman-docker", "1.6.4", "10.module_el8.2.0+305+5e198a41", "noarch", "podman-1.6.4-10.module_el8.2.0+305+5e198a41.src.rpm", 5996, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "Emulate Docker CLI using podman", "RSA/SHA256, Tue May 12 14:50:19 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "6.5", "6.el8", "x86_64", "texinfo-6.5-6.el8.src.rpm", 386513, "GPLv3+", "CentOS", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Sun Apr 26 02:09:04 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-libs", "5.26.3", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 6122645, "(GPL+ or Artistic) and HSRL and MIT and UCD", "CentOS", "", "The libraries for the perl run-time", "RSA/SHA256, Tue Jul  2 00:46:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.45.4", "3.el8", "x86_64", "e2fsprogs-1.45.4-3.el8.src.rpm", 61921, "MIT", "CentOS", "", "Common error description library", "RSA/SHA256, Sun Apr 26 02:19:31 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-fonts-common", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 38217, "AGPLv3", "CentOS", "", "Common files of the (URW)++ Level 2 Core Font Set", "RSA/SHA256, Tue Jul  2 01:56:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.7", "7.el8", "x86_64", "libxml2-2.9.7-7.el8.src.rpm", 1752506, "MIT", "CentOS", "", "Library providing XML and HTML support", "RSA/SHA256, Tue Apr  7 01:18:24 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-util", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 220716, "MPLv2.0", "CentOS", "", "Network Security Services Utilities Library", "RSA/SHA256, Tue Aug 11 23:26:33 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.2.5", "3.el8", "x86_64", "expat-2.2.5-3.el8.src.rpm", 314068, "MIT", "CentOS", "", "An XML parser library", "RSA/SHA256, Mon Jul  1 21:26:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-parent", "0.237", "1.el8", "noarch", "perl-parent-0.237-1.el8.src.rpm", 9187, "GPL+ or Artistic", "CentOS", "", "Establish an ISA relationship with base classes at compile time", "RSA/SHA256, Tue Jul  2 00:49:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 34832, "BSD", "CentOS", "", "Universally unique ID library", "RSA/SHA256, Sun Apr 26 02:25:30 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-system", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 21994, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost system support library", "RSA/SHA256, Thu Apr  9 03:29:33 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.11", "1.el8", "x86_64", "chkconfig-1.11-1.el8.src.rpm", 791234, "GPLv2", "CentOS", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Mon Jul  1 20:57:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libICE", "1.0.9", "15.el8", "x86_64", "libICE-1.0.9-15.el8.src.rpm", 205821, "MIT", "CentOS", "", "X.Org X11 ICE runtime library", "RSA/SHA256, Thu Dec  5 00:24:49 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.1.2", "10.el8", "x86_64", "gmp-6.1.2-10.el8.src.rpm", 1678740, "LGPLv3+ or GPLv2+", "CentOS", "", "A GNU arbitrary precision library", "RSA/SHA256, Wed Dec  4 23:43:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "unzip", "6.0", "43.el8", "x86_64", "unzip-6.0-43.el8.src.rpm", 423365, "BSD", "CentOS", "", "A utility for unpacking zip files", "RSA/SHA256, Thu Apr  9 04:05:16 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.48", "3.el8", "x86_64", "attr-2.4.48-3.el8.src.rpm", 27346, "LGPLv2+", "CentOS", "", "Dynamic library for extended attribute support", "RSA/SHA256, Mon Jul  1 23:07:09 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcroco", "0.6.12", "4.el8_2.1", "x86_64", "libcroco-0.6.12-4.el8_2.1.src.rpm", 330811, "LGPLv2", "CentOS", "", "A CSS2 parsing library", "RSA/SHA256, Wed Sep 16 20:18:06 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-single", "8.30", "7.el8_2.1", "x86_64", "coreutils-8.30-7.el8_2.1.src.rpm", 1356273, "GPLv3+", "CentOS", "", "coreutils multicall binary", "RSA/SHA256, Wed Jun 10 19:36:44 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "avahi-libs", "0.7", "19.el8", "x86_64", "avahi-0.7-19.el8.src.rpm", 162712, "LGPLv2+", "CentOS", "", "Libraries for avahi run-time use", "RSA/SHA256, Mon Jul  1 20:44:16 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 339680, "LGPLv2+", "CentOS", "", "Block device ID library", "RSA/SHA256, Sun Apr 26 02:19:00 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmpc", "1.0.2", "9.el8", "x86_64", "libmpc-1.0.2-9.el8.src.rpm", 154016, "LGPLv3+ and GFDL", "CentOS", "", "C library for multiple precision complex arithmetic", "RSA/SHA256, Mon Jul  1 23:30:18 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.9", "5.el8", "x86_64", "libcap-ng-0.7.9-5.el8.src.rpm", 51278, "LGPLv2+", "CentOS", "", "An alternate posix capabilities library", "RSA/SHA256, Tue Apr  7 01:16:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXfixes", "5.0.3", "7.el8", "x86_64", "libXfixes-5.0.3-7.el8.src.rpm", 29263, "MIT", "CentOS", "", "X Fixes library", "RSA/SHA256, Mon Jul  1 23:54:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.1", "21.el8", "x86_64", "libffi-3.1-21.el8.src.rpm", 68404, "MIT", "CentOS", "", "A portable foreign function interface library", "RSA/SHA256, Thu Dec  5 00:20:54 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-libs", "0.19.8.1", "17.el8", "x86_64", "gettext-0.19.8.1-17.el8.src.rpm", 1612648, "LGPLv2+ and GPLv3+", "CentOS", "", "Libraries for gettext", "RSA/SHA256, Wed Dec  4 23:25:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libzstd", "1.4.2", "2.el8", "x86_64", "zstd-1.4.2-2.el8.src.rpm", 703765, "BSD and GPLv2", "CentOS", "", "Zstd shared library", "RSA/SHA256, Wed Jan 22 15:04:34 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libSM", "1.2.3", "1.el8", "x86_64", "libSM-1.2.3-1.el8.src.rpm", 93427, "MIT", "CentOS", "", "X.Org X11 SM runtime library", "RSA/SHA256, Mon Jul  1 23:42:28 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4-libs", "1.8.1.2", "4.el8", "x86_64", "lz4-1.8.1.2-4.el8.src.rpm", 97367, "GPLv2+ and BSD", "CentOS", "", "Libaries for lz4", "RSA/SHA256, Tue Jul  2 00:01:25 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXmu", "1.1.2", "12.el8", "x86_64", "libXmu-1.1.2-12.el8.src.rpm", 196334, "MIT", "CentOS", "", "X.Org X11 libXmu/libXmuu runtime libraries", "RSA/SHA256, Mon Jul  1 23:55:35 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.8.3", "4.el8", "x86_64", "libgcrypt-1.8.3-4.el8.src.rpm", 1547061, "LGPLv2+", "CentOS", "", "A general-purpose cryptography library", "RSA/SHA256, Thu Dec  5 00:21:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-macros", "5.26.3", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 5184, "GPL+ or Artistic", "CentOS", "", "Macros for rpmbuild", "RSA/SHA256, Tue Jul  2 00:47:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.6", "15.el8", "x86_64", "cracklib-2.9.6-15.el8.src.rpm", 239047, "LGPLv2+", "CentOS", "", "A password-checking library", "RSA/SHA256, Mon Jul  1 21:04:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Socket", "2.027", "3.el8", "x86_64", "perl-Socket-2.027-3.el8.src.rpm", 127014, "GPL+ or Artistic", "CentOS", "", "Networking constants and support functions", "RSA/SHA256, Thu Dec  5 02:29:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn2", "2.2.0", "1.el8", "x86_64", "libidn2-2.2.0-1.el8.src.rpm", 287762, "(GPLv2+ or LGPLv3+) and GPLv3+", "CentOS", "", "Library to support IDNA2008 internationalized domain names", "RSA/SHA256, Thu Dec  5 00:25:25 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Unicode-Normalize", "1.25", "396.el8", "x86_64", "perl-Unicode-Normalize-1.25-396.el8.src.rpm", 637517, "GPL+ or Artistic", "CentOS", "", "Unicode Normalization Forms", "RSA/SHA256, Tue Jul  2 00:53:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.33", "13.el8", "x86_64", "file-5.33-13.el8.src.rpm", 6382974, "BSD", "CentOS", "", "Libraries for applications using libmagic", "RSA/SHA256, Thu Apr  9 03:37:43 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(0), "perl-IO", "1.38", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 140303, "GPL+ or Artistic", "CentOS", "", "Perl input/output modules", "RSA/SHA256, Tue Jul  2 00:45:50 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.10", "6.el8", "x86_64", "keyutils-1.5.10-6.el8.src.rpm", 43926, "GPLv2+ and LGPLv2+", "CentOS", "", "Key utilities library", "RSA/SHA256, Mon Jul  1 23:00:10 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-constant", "1.33", "396.el8", "noarch", "perl-constant-1.33-396.el8.src.rpm", 27104, "GPL+ or Artistic", "CentOS", "", "Perl pragma to declare constants", "RSA/SHA256, Tue Jul  2 00:41:32 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.14", "5.el8_0", "x86_64", "p11-kit-0.23.14-5.el8_0.src.rpm", 508547, "BSD", "CentOS", "", "System trust module from p11-kit", "RSA/SHA256, Sat Aug  3 19:32:12 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-threads-shared", "1.58", "2.el8", "x86_64", "perl-threads-shared-1.58-2.el8.src.rpm", 78170, "GPL+ or Artistic", "CentOS", "", "Perl extension for sharing data structures between threads", "RSA/SHA256, Tue Jul  2 00:52:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.42", "4.el8", "x86_64", "pcre-8.42-4.el8.src.rpm", 518067, "BSD", "CentOS", "", "Perl-compatible regular expression library", "RSA/SHA256, Tue Jul  2 00:38:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-MIME-Base64", "3.15", "396.el8", "x86_64", "perl-MIME-Base64-3.15-396.el8.src.rpm", 41435, "(GPL+ or Artistic) and MIT", "CentOS", "", "Encoding and decoding of Base64 and quoted-printable strings", "RSA/SHA256, Tue Jul  2 00:47:33 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 4497790, "LGPLv2+ and MIT", "CentOS", "", "systemd libraries", "RSA/SHA256, Sat Aug  8 01:28:14 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Time-Local", "1.280", "1.el8", "noarch", "perl-Time-Local-1.280-1.el8.src.rpm", 59906, "GPL+ or Artistic", "CentOS", "", "Efficiently compute time from local and GMT time", "RSA/SHA256, Tue Jul  2 00:53:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-tools", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 125490, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS Tools and Utilities", "RSA/SHA256, Fri Aug  7 22:56:54 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-File-Temp", "0.230.600", "1.el8", "noarch", "perl-File-Temp-0.230.600-1.el8.src.rpm", 164723, "GPL+ or Artistic", "CentOS", "", "Return name and handle of a temporary file safely", "RSA/SHA256, Tue Jul  2 00:45:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libusbx", "1.0.22", "1.el8", "x86_64", "libusbx-1.0.22-1.el8.src.rpm", 151177, "LGPLv2+", "CentOS", "", "Library for accessing USB devices", "RSA/SHA256, Mon Jul  1 23:48:43 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "patch", "2.7.6", "11.el8", "x86_64", "patch-2.7.6-11.el8.src.rpm", 266609, "GPLv3+", "CentOS", "", "Utility for modifying/upgrading files", "RSA/SHA256, Thu Apr  9 03:59:45 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2019.2.32", "80.0.el8_1", "noarch", "ca-certificates-2019.2.32-80.0.el8_1.src.rpm", 993761, "Public Domain", "CentOS", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Mon Dec 23 19:19:03 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file", "5.33", "13.el8", "x86_64", "file-5.33-13.el8.src.rpm", 93224, "BSD", "CentOS", "", "A utility for determining file types", "RSA/SHA256, Thu Apr  9 03:37:29 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "squashfs-tools", "4.3", "19.el8", "x86_64", "squashfs-tools-4.3-19.el8.src.rpm", 502829, "GPLv2+", "CentOS", "", "Utility for the creation of squashfs filesystems", "RSA/SHA256, Thu Dec  5 03:43:49 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXrandr", "1.5.1", "7.el8", "x86_64", "libXrandr-1.5.1-7.el8.src.rpm", 53138, "MIT", "CentOS", "", "X.Org X11 libXrandr runtime library", "RSA/SHA256, Mon Jul  1 23:56:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.9", "2.el8", "x86_64", "libsemanage-2.9-2.el8.src.rpm", 477962, "LGPLv2+", "CentOS", "", "SELinux binary policy manipulation library", "RSA/SHA256, Tue Apr 14 06:05:29 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXi", "1.7.9", "7.el8", "x86_64", "libXi-1.7.9-7.el8.src.rpm", 98363, "MIT", "CentOS", "", "X.Org X11 libXi runtime library", "RSA/SHA256, Mon Jul  1 23:54:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "14.el8", "x86_64", "libutempter-1.1.6-14.el8.src.rpm", 52637, "LGPLv2+", "CentOS", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Mon Jul  1 23:49:02 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "atk", "2.28.1", "1.el8", "x86_64", "atk-2.28.1-1.el8.src.rpm", 1294970, "LGPLv2+", "CentOS", "", "Interfaces for accessibility support", "RSA/SHA256, Mon Jul  1 20:41:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.53", "1.el8", "x86_64", "acl-2.2.53-1.el8.src.rpm", 205740, "GPLv2+", "CentOS", "", "Access control list utilities", "RSA/SHA256, Mon Jul  1 20:37:24 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "adobe-mappings-cmap-deprecated", "20171205", "3.el8", "noarch", "adobe-mappings-cmap-20171205-3.el8.src.rpm", 596942, "BSD", "CentOS", "", "Deprecated CMap resources for Adobe's character collections", "RSA/SHA256, Mon Jul  1 20:37:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nettle", "3.4.1", "1.el8", "x86_64", "nettle-3.4.1-1.el8.src.rpm", 683185, "LGPLv3+ or GPLv2+", "CentOS", "", "A low-level cryptographic library", "RSA/SHA256, Tue Jul  2 00:17:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Digest", "1.17", "395.el8", "noarch", "perl-Digest-1.17-395.el8.src.rpm", 26685, "GPL+ or Artistic", "CentOS", "", "Modules that calculate message digests", "RSA/SHA256, Tue Jul  2 00:43:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcomps", "0.1.11", "4.el8", "x86_64", "libcomps-0.1.11-4.el8.src.rpm", 217067, "GPLv2+", "CentOS", "", "Comps XML file manipulation library", "RSA/SHA256, Sun Apr 26 02:19:42 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Net-SSLeay", "1.88", "1.el8", "x86_64", "perl-Net-SSLeay-1.88-1.el8.src.rpm", 1368791, "Artistic 2.0", "CentOS", "", "Perl extension for using OpenSSL", "RSA/SHA256, Thu Dec  5 02:23:41 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.6.0", "20.el8", "x86_64", "findutils-4.6.0-20.el8.src.rpm", 1816673, "GPLv3+", "CentOS", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Mon Jul  1 21:32:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-TermReadKey", "2.37", "7.el8", "x86_64", "perl-TermReadKey-2.37-7.el8.src.rpm", 66206, "(Copyright only) and (Artistic or GPL+)", "CentOS", "", "A perl module for simple terminal control", "RSA/SHA256, Tue Jul  2 00:51:32 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cpio", "2.12", "8.el8", "x86_64", "cpio-2.12-8.el8.src.rpm", 989536, "GPLv3+", "CentOS", "", "A GNU archiving program", "RSA/SHA256, Mon Jul  1 21:03:43 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "valgrind", "3.15.0", "11.el8", "x86_64", "valgrind-3.15.0-11.el8.src.rpm", 32152354, "GPLv2+", "CentOS", "", "Tool for finding memory management bugs in programs", "RSA/SHA256, Sun Apr 26 03:07:44 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ipcalc", "0.2.4", "4.el8", "x86_64", "ipcalc-0.2.4-4.el8.src.rpm", 67705, "GPLv2+", "CentOS", "", "IP network address calculator", "RSA/SHA256, Tue Apr  7 01:16:26 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Storable", "3.11", "3.el8", "x86_64", "perl-Storable-3.11-3.el8.src.rpm", 221862, "GPL+ or Artistic", "CentOS", "", "Persistence for Perl data structures", "RSA/SHA256, Tue Jul  2 00:50:49 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnghttp2", "1.33.0", "3.el8_2.1", "x86_64", "nghttp2-1.33.0-3.el8_2.1.src.rpm", 168044, "MIT", "CentOS", "", "A library implementing the HTTP/2 protocol", "RSA/SHA256, Fri Jun 26 14:54:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Mozilla-CA", "20160104", "7.el8", "noarch", "perl-Mozilla-CA-20160104-7.el8.src.rpm", 5716, "MPLv2.0", "CentOS", "", "Mozilla's CA cert bundle in PEM format", "RSA/SHA256, Tue Jul  2 00:48:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iptables-libs", "1.8.4", "10.el8_2.1", "x86_64", "iptables-1.8.4-10.el8_2.1.src.rpm", 201920, "GPLv2 and Artistic 2.0 and ISC", "CentOS", "", "iptables libraries", "RSA/SHA256, Fri Aug  7 23:20:58 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXaw", "1.0.13", "10.el8", "x86_64", "libXaw-1.0.13-10.el8.src.rpm", 523837, "MIT", "CentOS", "", "X Athena Widget Set", "RSA/SHA256, Mon Jul  1 23:53:27 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsigsegv", "2.11", "5.el8", "x86_64", "libsigsegv-2.11-5.el8.src.rpm", 47034, "GPLv2+", "CentOS", "", "Library for handling page faults in user mode", "RSA/SHA256, Mon Jul  1 23:42:19 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXdamage", "1.1.4", "14.el8", "x86_64", "libXdamage-1.1.4-14.el8.src.rpm", 30432, "MIT", "CentOS", "", "X Damage extension library", "RSA/SHA256, Mon Jul  1 23:54:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.3.0", "5.el8", "x86_64", "libverto-0.3.0-5.el8.src.rpm", 28244, "MIT", "CentOS", "", "Main loop abstraction library", "RSA/SHA256, Mon Jul  1 23:49:52 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn", "1.34", "5.el8", "x86_64", "libidn-1.34-5.el8.src.rpm", 713211, "LGPLv2+ and GPLv3+ and GFDL", "CentOS", "", "Internationalized Domain Name support library", "RSA/SHA256, Mon Jul  1 23:23:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtirpc", "1.1.4", "4.el8", "x86_64", "libtirpc-1.1.4-4.el8.src.rpm", 381964, "SISSL and BSD", "CentOS", "", "Transport Independent RPC Library", "RSA/SHA256, Thu Dec  5 00:59:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-thread", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 182682, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost thread library", "RSA/SHA256, Thu Apr  9 03:29:47 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.1.1c", "15.el8", "x86_64", "openssl-1.1.1c-15.el8.src.rpm", 3744176, "OpenSSL", "CentOS", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Sun Apr 26 02:38:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn-freebl", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 634614, "MPLv2.0", "CentOS", "", "Freebl library for the Network Security Services", "RSA/SHA256, Tue Aug 11 23:26:27 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "platform-python-setuptools", "39.2.0", "5.el8", "noarch", "python-setuptools-39.2.0-5.el8.src.rpm", 2930163, "MIT", "CentOS", "", "Easily build and distribute Python 3 packages", "RSA/SHA256, Thu Dec  5 02:50:43 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 1996163, "MPLv2.0", "CentOS", "", "Network Security Services", "RSA/SHA256, Tue Aug 11 23:26:20 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libs", "3.6.8", "23.el8", "x86_64", "python3-3.6.8-23.el8.src.rpm", 32187857, "Python", "CentOS", "", "Python runtime libraries", "RSA/SHA256, Thu Apr 16 14:39:06 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-tools", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 2286837, "MPLv2.0", "CentOS", "", "Tools for the Network Security Services", "RSA/SHA256, Tue Aug 11 23:26:31 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.4.0", "9.el8", "x86_64", "libpwquality-1.4.0-9.el8.src.rpm", 384791, "BSD or GPLv2+", "CentOS", "", "A library for password generation and password quality checking", "RSA/SHA256, Mon Jul  1 23:37:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Term-ANSIColor", "4.06", "396.el8", "noarch", "perl-Term-ANSIColor-4.06-396.el8.src.rpm", 89627, "GPL+ or Artistic", "CentOS", "", "Color screen output using ANSI escape sequences", "RSA/SHA256, Tue Jul  2 00:51:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.32.1", "22.el8", "x86_64", "util-linux-2.32.1-22.el8.src.rpm", 11560494, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "CentOS", "", "A collection of basic system utilities", "RSA/SHA256, Sun Apr 26 03:06:40 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fipscheck", "1.5.0", "4.el8", "x86_64", "fipscheck-1.5.0-4.el8.src.rpm", 48547, "BSD", "CentOS", "", "A library for integrity verification of FIPS validated modules", "RSA/SHA256, Mon Jul  1 21:32:56 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.56.4", "8.el8", "x86_64", "glib2-2.56.4-8.el8.src.rpm", 12272168, "LGPLv2+", "CentOS", "", "A library of handy utility functions", "RSA/SHA256, Sun Apr 26 02:05:39 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sgml-common", "0.6.3", "50.el8", "noarch", "sgml-common-0.6.3-50.el8.src.rpm", 172077, "GPL+", "CentOS", "", "Common SGML catalog and DTD files", "RSA/SHA256, Tue Jul  2 01:30:43 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iproute", "5.3.0", "1.el8", "x86_64", "iproute-5.3.0-1.el8.src.rpm", 1894954, "GPLv2+ and Public Domain", "CentOS", "", "Advanced IP routing and network device configuration tools", "RSA/SHA256, Tue Apr  7 01:16:29 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "docbook-style-xsl", "1.79.2", "7.el8", "noarch", "docbook-style-xsl-1.79.2-7.el8.src.rpm", 16311851, "DMIT", "CentOS", "", "Norman Walsh's XSL stylesheets for DocBook XML", "RSA/SHA256, Mon Jul  1 21:15:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod", "25", "16.el8", "x86_64", "kmod-25-16.el8.src.rpm", 243998, "GPLv2+", "CentOS", "", "Linux kernel module management utilities", "RSA/SHA256, Thu Apr  9 03:42:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dnf-plugins-core", "4.0.12", "4.el8_2", "noarch", "dnf-plugins-core-4.0.12-4.el8_2.src.rpm", 663140, "GPLv2+", "CentOS", "", "Core Plugins for DNF", "RSA/SHA256, Wed Sep 16 20:28:54 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.61.1", "12.el8", "x86_64", "curl-7.61.1-12.el8.src.rpm", 709006, "MIT", "CentOS", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Fri Mar 27 03:14:59 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pkgconf-m4", "1.4.2", "1.el8", "noarch", "pkgconf-1.4.2-1.el8.src.rpm", 14187, "GPLv2+ with exceptions", "CentOS", "", "m4 macros for pkgconf", "RSA/SHA256, Tue Jul  2 00:55:48 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.46", "11.el8_1", "x86_64", "openldap-2.4.46-11.el8_1.src.rpm", 1388793, "OpenLDAP", "CentOS", "", "LDAP support libraries", "RSA/SHA256, Wed Feb  5 00:06:28 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses", "6.1", "7.20180224.el8", "x86_64", "ncurses-6.1-7.20180224.el8.src.rpm", 600396, "MIT", "CentOS", "", "Ncurses support utilities", "RSA/SHA256, Tue Jul  2 00:16:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libcomps", "0.1.11", "4.el8", "x86_64", "libcomps-0.1.11-4.el8.src.rpm", 147027, "GPLv2+", "CentOS", "", "Python 3 bindings for libcomps library", "RSA/SHA256, Sun Apr 26 02:48:27 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "make", "4.2.1", "10.el8", "x86_64", "make-4.2.1-10.el8.src.rpm", 1435840, "GPLv3+", "CentOS", "", "A GNU tool which simplifies the build process for users", "RSA/SHA256, Fri Mar 27 03:18:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libarchive", "3.3.2", "8.el8_1", "x86_64", "libarchive-3.3.2-8.el8_1.src.rpm", 1139914, "BSD", "CentOS", "", "A library for handling streaming archive formats", "RSA/SHA256, Thu Jan 30 21:38:35 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxslt", "1.1.32", "4.el8", "x86_64", "libxslt-1.1.32-4.el8.src.rpm", 751661, "MIT", "CentOS", "", "Library providing the Gnome XSLT engine", "RSA/SHA256, Sun Apr 26 02:26:37 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 722464, "GPLv2+ and LGPLv2+ with exceptions", "CentOS", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Sun Apr 26 02:52:23 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpkgconf", "1.4.2", "1.el8", "x86_64", "pkgconf-1.4.2-1.el8.src.rpm", 68093, "ISC", "CentOS", "", "Backend library for pkgconf", "RSA/SHA256, Mon Jul  1 23:35:55 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libyaml", "0.1.7", "5.el8", "x86_64", "libyaml-0.1.7-5.el8.src.rpm", 136478, "MIT", "CentOS", "", "YAML 1.1 parser and emitter written in C", "RSA/SHA256, Mon Jul  1 23:57:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "npth", "1.5", "4.el8", "x86_64", "npth-1.5-4.el8.src.rpm", 47909, "LGPLv2+", "CentOS", "", "The New GNU Portable Threads library", "RSA/SHA256, Tue Jul  2 00:19:41 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.10.0", "6.el8.0.1", "x86_64", "gpgme-1.10.0-6.el8.0.1.src.rpm", 741097, "LGPLv2+", "CentOS", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Mon Jul  1 22:29:25 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdnf", "0.39.1", "6.el8_2", "x86_64", "libdnf-0.39.1-6.el8_2.src.rpm", 2123765, "LGPLv2+", "CentOS", "", "Library providing simplified C and Python API to libsolv", "RSA/SHA256, Fri Aug  7 23:40:07 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-hawkey", "0.39.1", "6.el8_2", "x86_64", "libdnf-0.39.1-6.el8_2.src.rpm", 263176, "LGPLv2+", "CentOS", "", "Python 3 bindings for the hawkey library", "RSA/SHA256, Fri Aug  7 23:40:10 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libreport-filesystem", "2.9.5", "10.el8", "x86_64", "libreport-2.9.5-10.el8.src.rpm", 0, "GPLv2+", "CentOS", "", "Filesystem layout for libreport", "RSA/SHA256, Wed May  6 23:06:33 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(12), "dhcp-common", "4.3.6", "40.el8", "noarch", "dhcp-4.3.6-40.el8.src.rpm", 301814, "ISC", "CentOS", "", "Common files used by ISC dhcp client, server and relay agent", "RSA/SHA256, Fri Apr 24 14:50:41 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-daemon", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 560056, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Fri Aug  7 22:56:46 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(8), "device-mapper-libs", "1.02.169", "3.el8", "x86_64", "lvm2-2.03.08-3.el8.src.rpm", 416167, "LGPLv2", "CentOS", "", "Device-mapper shared library", "RSA/SHA256, Sun Apr 26 01:54:46 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.178", "7.el8", "noarch", "elfutils-0.178-7.el8.src.rpm", 1810, "GPLv2+ or LGPLv3+", "CentOS", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Sun Apr 26 02:00:40 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-pam", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 902504, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "systemd PAM module", "RSA/SHA256, Sat Aug  8 01:28:16 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.12.8", "10.el8_2", "x86_64", "dbus-1.12.8-10.el8_2.src.rpm", 0, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus", "RSA/SHA256, Fri Aug  7 22:56:45 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(12), "dhcp-client", "4.3.6", "40.el8", "x86_64", "dhcp-4.3.6-40.el8.src.rpm", 530732, "ISC", "CentOS", "", "Provides the ISC DHCP client daemon and dhclient-script", "RSA/SHA256, Fri Apr 24 14:50:40 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libkcapi-hmaccalc", "1.1.1", "16_1.el8", "x86_64", "libkcapi-1.1.1-16_1.el8.src.rpm", 35165, "BSD or GPLv2", "CentOS", "", "Drop-in replacements for hmaccalc provided by the libkcapi package", "RSA/SHA256, Mon Jul  1 23:26:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut", "049", "70.git20200228.el8", "x86_64", "dracut-049-70.git20200228.el8.src.rpm", 1046582, "GPLv2+ and LGPLv2+", "CentOS", "", "Initramfs generator using udev", "RSA/SHA256, Sun Apr 26 01:59:08 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut-squash", "049", "70.git20200228.el8", "x86_64", "dracut-049-70.git20200228.el8.src.rpm", 3054, "GPLv2+ and LGPLv2+", "CentOS", "", "dracut module to build an initramfs with most files in a squashfs image", "RSA/SHA256, Sun Apr 26 01:59:35 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-rpm", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 430929, "GPLv2+", "CentOS", "", "Python 3 bindings for apps which will manipulate RPM packages", "RSA/SHA256, Sun Apr 26 02:49:43 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 1670640, "GPLv2+ and GPLv2 and GPL", "CentOS", "", "Package manager", "RSA/SHA256, Fri Aug  7 23:00:54 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kexec-tools", "2.0.20", "14.el8", "x86_64", "kexec-tools-2.0.20-14.el8.src.rpm", 1222009, "GPLv2", "CentOS", "", "The kexec/kdump userspace component", "RSA/SHA256, Sun Apr 26 02:17:32 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.30", "4.el8", "x86_64", "tar-1.30-4.el8.src.rpm", 2914728, "GPLv3+", "CentOS", "", "A GNU file archiving program", "RSA/SHA256, Tue Jul  2 01:40:27 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hostname", "3.20", "6.el8", "x86_64", "hostname-3.20-6.el8.src.rpm", 43979, "GPLv2+", "CentOS", "", "Utility to set/show the host name or domain name", "RSA/SHA256, Mon Jul  1 22:38:32 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "langpacks-en", "1.0", "12.el8", "noarch", "langpacks-1.0-12.el8.src.rpm", 400, "GPLv2+", "CentOS", "", "English langpacks meta-package", "RSA/SHA256, Mon Jul  1 23:02:04 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "8483c65d", "5ccc5b19", "", "", 0, "pubkey", "", "", "gpg(CentOS (CentOS Official Signing Key) <security@centos.org>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "npm", "6.14.4", "1.10.21.0.3.module_el8.2.0+391+8da3adc6", "x86_64", "nodejs-10.21.0-3.module_el8.2.0+391+8da3adc6.src.rpm", 16351222, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "nodejs:10:8020020200707141642:6a468ee4", "Node.js Package Manager", "RSA/SHA256, Tue Jul  7 16:08:47 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libselinux", "2.9", "3.el8", "x86_64", "libselinux-2.9-3.el8.src.rpm", 894878, "Public Domain", "CentOS", "", "SELinux python 3 bindings for libselinux", "RSA/SHA256, Tue Apr 14 06:05:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "libpng", "1.6.34", "5.el8", "x86_64", "libpng-1.6.34-5.el8.src.rpm", 235304, "zlib", "CentOS", "", "A library of functions for manipulating PNG image format files", "RSA/SHA256, Mon Jul  1 23:36:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "freetype", "2.9.1", "4.el8", "x86_64", "freetype-2.9.1-4.el8.src.rpm", 828847, "(FTL or GPLv2+) and BSD and MIT and Public Domain and zlib with acknowledgement", "CentOS", "", "A free and portable font rendering engine", "RSA/SHA256, Mon Jul  1 21:37:06 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.56.1", "1.el8", "x86_64", "gobject-introspection-1.56.1-1.el8.src.rpm", 880467, "GPLv2+, LGPLv2+, MIT", "CentOS", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Mon Jul  1 22:25:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnl3-cli", "3.5.0", "1.el8", "x86_64", "libnl3-3.5.0-1.el8.src.rpm", 838214, "LGPLv2", "CentOS", "", "Command line interface utils for libnl3", "RSA/SHA256, Thu Apr  9 03:47:16 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "shared-mime-info", "1.9", "3.el8", "x86_64", "shared-mime-info-1.9-3.el8.src.rpm", 2442451, "GPLv2+", "CentOS", "", "Shared MIME information database", "RSA/SHA256, Tue Jul  2 01:30:56 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-audit", "3.0", "0.17.20191104git1c2f876.el8", "x86_64", "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm", 333023, "LGPLv2+", "CentOS", "", "Python3 bindings for libaudit", "RSA/SHA256, Sun Apr 26 02:47:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnftnl", "1.1.5", "4.el8", "x86_64", "libnftnl-1.1.5-4.el8.src.rpm", 222320, "GPLv2+", "CentOS", "", "Library for low-level interaction with nftables Netlink's API over libmnl", "RSA/SHA256, Sun Apr 26 02:22:27 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-glib", "1.4.4", "1.el8", "x86_64", "json-glib-1.4.4-1.el8.src.rpm", 530243, "LGPLv2+", "CentOS", "", "Library for JavaScript Object Notation format", "RSA/SHA256, Mon Jul  1 22:57:51 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontpackages-filesystem", "1.44", "22.el8", "noarch", "fontpackages-1.44-22.el8.src.rpm", 0, "Public Domain", "CentOS", "", "Directories used by font packages", "RSA/SHA256, Mon Jul  1 21:35:43 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fontconfig", "2.13.1", "3.el8", "x86_64", "fontconfig-2.13.1-3.el8.src.rpm", 729249, "MIT and Public Domain and UCD", "CentOS", "", "Font configuration and customization library", "RSA/SHA256, Mon Jul  1 21:35:05 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gsettings-desktop-schemas", "3.32.0", "4.el8", "x86_64", "gsettings-desktop-schemas-3.32.0-4.el8.src.rpm", 4216968, "LGPLv2+", "CentOS", "", "A collection of GSettings schemas", "RSA/SHA256, Thu Apr  9 03:39:43 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnetfilter_conntrack", "1.0.6", "5.el8", "x86_64", "libnetfilter_conntrack-1.0.6-5.el8.src.rpm", 165190, "GPLv2+", "CentOS", "", "Netfilter conntrack userspace library", "RSA/SHA256, Mon Jul  1 23:31:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "nftables", "0.9.3", "12.el8_2.1", "x86_64", "nftables-0.9.3-12.el8_2.1.src.rpm", 811211, "GPLv2", "CentOS", "", "Netfilter Tables userspace utillites", "RSA/SHA256, Fri Oct 30 16:22:05 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "PackageKit-glib", "1.1.12", "4.el8", "x86_64", "PackageKit-1.1.12-4.el8.src.rpm", 635676, "GPLv2+ and LGPLv2+", "CentOS", "", "GLib libraries for accessing PackageKit", "RSA/SHA256, Wed Apr 15 02:24:04 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-setools", "4.2.2", "2.el8", "x86_64", "setools-4.2.2-2.el8.src.rpm", 2691942, "GPLv2", "CentOS", "", "Policy analysis tools for SELinux", "RSA/SHA256, Wed Apr 15 02:24:14 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-six", "1.11.0", "8.el8", "noarch", "python-six-1.11.0-8.el8.src.rpm", 100282, "MIT", "CentOS", "", "Python 2 and 3 compatibility utilities", "RSA/SHA256, Tue Jul  2 01:10:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libxml2", "2.9.7", "7.el8", "x86_64", "libxml2-2.9.7-7.el8.src.rpm", 1358319, "MIT", "CentOS", "", "Python 3 bindings for the libxml2 library", "RSA/SHA256, Tue Apr  7 01:19:26 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "platform-python-pip", "9.0.3", "16.el8", "noarch", "python-pip-9.0.3-16.el8.src.rpm", 7749727, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "CentOS", "", "A tool for installing and managing Python3 packages", "RSA/SHA256, Sun Apr 26 02:46:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-pip", "9.0.3", "16.el8", "noarch", "python-pip-9.0.3-16.el8.src.rpm", 2856, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "CentOS", "", "A tool for installing and managing Python3 packages", "RSA/SHA256, Sun Apr 26 02:49:22 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "polkit", "0.115", "11.el8", "x86_64", "polkit-0.115-11.el8.src.rpm", 469075, "LGPLv2+", "CentOS", "", "An authorization framework", "RSA/SHA256, Tue Apr 14 06:05:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libvarlink", "18", "3.el8", "x86_64", "libvarlink-18-3.el8.src.rpm", 132453, "ASL 2.0", "CentOS", "", "Varlink C Library", "RSA/SHA256, Thu Dec  5 01:00:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh-config", "0.9.0", "4.el8", "noarch", "libssh-0.9.0-4.el8.src.rpm", 357, "LGPLv2+", "CentOS", "", "Configuration files for libssh", "RSA/SHA256, Thu Dec  5 00:55:17 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libndp", "1.7", "3.el8", "x86_64", "libndp-1.7-3.el8.src.rpm", 80786, "LGPLv2+", "CentOS", "", "Library for Neighbor Discovery Protocol", "RSA/SHA256, Tue Apr  7 01:17:38 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libproxy", "0.4.15", "5.2.el8", "x86_64", "libproxy-0.4.15-5.2.el8.src.rpm", 201294, "LGPLv2+", "CentOS", "", "A library handling all the details of proxy configuration", "RSA/SHA256, Mon Jul  1 23:36:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cockpit-bridge", "211.3", "1.el8", "x86_64", "cockpit-211.3-1.el8.src.rpm", 1062966, "LGPLv2+", "CentOS", "", "Cockpit bridge server-side component", "RSA/SHA256, Sun Apr 26 01:51:46 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libappstream-glib", "0.7.14", "3.el8", "x86_64", "libappstream-glib-0.7.14-3.el8.src.rpm", 1072064, "LGPLv2+", "CentOS", "", "Library for AppStream metadata", "RSA/SHA256, Mon Jul  1 23:05:53 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdaemon", "0.14", "15.el8", "x86_64", "libdaemon-0.14-15.el8.src.rpm", 64469, "LGPLv2+", "CentOS", "", "Library for writing UNIX daemons", "RSA/SHA256, Mon Jul  1 23:12:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fuse3-libs", "3.2.1", "12.el8", "x86_64", "fuse-2.9.7-12.el8.src.rpm", 285282, "LGPLv2+", "CentOS", "", "File System in Userspace (FUSE) v3 libraries", "RSA/SHA256, Mon Jul  1 21:37:50 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "containers-common", "0.1.40", "11.module_el8.2.0+377+92552693", "x86_64", "skopeo-0.1.40-11.module_el8.2.0+377+92552693.src.rpm", 44763, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200603213325:0d58ad57", "Configuration files for working with image signatures", "RSA/SHA256, Wed Jun  3 22:11:19 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils", "2.9", "9.el8", "x86_64", "policycoreutils-2.9-9.el8.src.rpm", 672959, "GPLv2", "CentOS", "", "SELinux policy core utilities", "RSA/SHA256, Sun Apr 26 02:46:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "selinux-policy", "3.14.3", "41.el8_2.8", "noarch", "selinux-policy-3.14.3-41.el8_2.8.src.rpm", 24923, "GPLv2+", "CentOS", "", "SELinux policy configuration", "RSA/SHA256, Fri Oct 30 16:22:14 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.110", "2.el8", "x86_64", "dbus-glib-0.110-2.el8.src.rpm", 367078, "AFL and GPLv2+", "CentOS", "", "GLib bindings for D-Bus", "RSA/SHA256, Mon Jul  1 21:10:19 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-slip-dbus", "0.6.4", "11.el8", "noarch", "python-slip-0.6.4-11.el8.src.rpm", 71273, "GPLv2+", "CentOS", "", "Convenience functions for dbus services in Python 3.x", "RSA/SHA256, Tue Jul  2 01:10:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-policycoreutils", "2.9", "9.el8", "noarch", "policycoreutils-2.9-9.el8.src.rpm", 5632728, "GPLv2", "CentOS", "", "SELinux policy core python3 interfaces", "RSA/SHA256, Sun Apr 26 02:49:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "container-selinux", "2.124.0", "1.module_el8.2.0+305+5e198a41", "noarch", "container-selinux-2.124.0-1.module_el8.2.0+305+5e198a41.src.rpm", 45036, "GPLv2", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "SELinux policies for container runtimes", "RSA/SHA256, Tue May 12 14:26:43 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "NetworkManager", "1.22.8", "5.el8_2", "x86_64", "NetworkManager-1.22.8-5.el8_2.src.rpm", 6568601, "GPLv2+ and LGPLv2+", "CentOS", "", "Network connection manager and user applications", "RSA/SHA256, Fri Aug  7 22:45:46 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-systemd", "234", "8.el8", "x86_64", "python-systemd-234-8.el8.src.rpm", 259121, "LGPLv2+", "CentOS", "", "Python module wrapping systemd functionality", "RSA/SHA256, Tue Jul  2 01:10:38 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "protobuf-c", "1.3.0", "4.el8", "x86_64", "protobuf-c-1.3.0-4.el8.src.rpm", 57650, "BSD", "CentOS", "", "C bindings for Google's Protocol Buffers", "RSA/SHA256, Tue Jul  2 01:00:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnet", "1.1.6", "15.el8", "x86_64", "libnet-1.1.6-15.el8.src.rpm", 174574, "BSD", "CentOS", "", "C library for portable packet creation and injection", "RSA/SHA256, Mon Jul  1 23:31:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "flex", "2.6.1", "9.el8", "x86_64", "flex-2.6.1-9.el8.src.rpm", 931867, "BSD and LGPLv2+", "CentOS", "", "A tool for creating scanners (text pattern recognizers)", "RSA/SHA256, Mon Jul  1 21:34:22 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-sign", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 18996, "GPLv2+", "CentOS", "", "Package signing support", "RSA/SHA256, Sun Apr 26 02:53:32 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "diffstat", "1.61", "7.el8", "x86_64", "diffstat-1.61-7.el8.src.rpm", 65815, "MIT", "CentOS", "", "A utility which provides statistics based on the output of diff", "RSA/SHA256, Mon Jul  1 21:13:16 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pkgconf-pkg-config", "1.4.2", "1.el8", "x86_64", "pkgconf-1.4.2-1.el8.src.rpm", 3094, "ISC", "CentOS", "", "pkgconf shim to provide /usr/bin/pkg-config", "RSA/SHA256, Tue Jul  2 00:55:51 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-regex", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 1185250, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost regular expression library", "RSA/SHA256, Thu Apr  9 03:29:00 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh-clients", "8.0p1", "4.el8_1", "x86_64", "openssh-8.0p1-4.el8_1.src.rpm", 3567696, "BSD", "CentOS", "", "An open source SSH client applications", "RSA/SHA256, Wed Feb  5 00:07:29 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "git-core-doc", "2.18.4", "2.el8_2", "noarch", "git-2.18.4-2.el8_2.src.rpm", 11778148, "GPLv2", "CentOS", "", "Documentation files for git-core", "RSA/SHA256, Mon May 11 17:33:44 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-headers", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 2029912, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", "Header files for development using standard C libraries.", "RSA/SHA256, Fri May  1 21:04:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-devel", "2.28", "101.el8", "x86_64", "glibc-2.28-101.el8.src.rpm", 1273916, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "CentOS", "", "Object files for development using standard C libraries.", "RSA/SHA256, Fri May  1 21:04:24 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Encode", "2.97", "3.el8", "x86_64", "perl-Encode-2.97-3.el8.src.rpm", 10200695, "(GPL+ or Artistic) and Artistic 2.0 and UCD", "CentOS", "", "Character encodings in Perl", "RSA/SHA256, Tue Jul  2 00:43:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "perl-Getopt-Long", "2.50", "4.el8", "noarch", "perl-Getopt-Long-2.50-4.el8.src.rpm", 139724, "GPLv2+ or Artistic", "CentOS", "", "Extended processing of command line options", "RSA/SHA256, Tue Jul  2 00:45:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-Pod-Usage", "1.69", "395.el8", "noarch", "perl-Pod-Usage-1.69-395.el8.src.rpm", 49721, "GPL+ or Artistic", "CentOS", "", "Print a usage message from embedded POD documentation", "RSA/SHA256, Tue Jul  2 00:50:11 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-HTTP-Tiny", "0.074", "1.el8", "noarch", "perl-HTTP-Tiny-0.074-1.el8.src.rpm", 149162, "GPL+ or Artistic", "CentOS", "", "Small, simple, correct HTTP/1.1 client", "RSA/SHA256, Tue Jul  2 00:45:38 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-libnet", "3.11", "3.el8", "noarch", "perl-libnet-3.11-3.el8.src.rpm", 277135, "GPL+ or Artistic", "CentOS", "", "Perl clients for various network protocols", "RSA/SHA256, Tue Jul  2 00:46:40 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "autoconf", "2.69", "27.el8", "noarch", "autoconf-2.69-27.el8.src.rpm", 2323003, "GPLv2+ and GFDL", "CentOS", "", "A GNU tool for automatically configuring source code", "RSA/SHA256, Mon Jul  1 20:42:53 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Git", "2.18.4", "2.el8_2", "noarch", "git-2.18.4-2.el8_2.src.rpm", 64807, "GPLv2", "CentOS", "", "Perl interface to Git", "RSA/SHA256, Mon May 11 17:34:03 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-common-devel", "0.19.8.1", "17.el8", "noarch", "gettext-0.19.8.1-17.el8.src.rpm", 397912, "GPLv3+", "CentOS", "", "Common development files for gettext", "RSA/SHA256, Wed Dec  4 23:25:02 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2", "1.0.6", "26.el8", "x86_64", "bzip2-1.0.6-26.el8.src.rpm", 93460, "BSD", "CentOS", "", "A file compression utility", "RSA/SHA256, Mon Jul  1 20:54:13 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-filesystem", "8.0.1763", "13.el8", "noarch", "vim-8.0.1763-13.el8.src.rpm", 40, "Vim and MIT", "CentOS", "", "VIM filesystem layout", "RSA/SHA256, Thu Dec  5 04:05:10 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tbb", "2018.2", "9.el8", "x86_64", "tbb-2018.2-9.el8.src.rpm", 470470, "ASL 2.0", "CentOS", "", "The Threading Building Blocks library abstracts low-level threading details", "RSA/SHA256, Tue Jul  2 01:40:33 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "qt5-srpm-macros", "5.12.5", "3.el8", "noarch", "qt5-5.12.5-3.el8.src.rpm", 0, "GPLv3", "CentOS", "", "RPM macros for source Qt5 packages", "RSA/SHA256, Tue Mar 24 21:22:42 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-srpm-macros", "3", "38.el8", "noarch", "python-rpm-macros-3-38.el8.src.rpm", 3747, "MIT", "CentOS", "", "RPM macros for building Python source packages", "RSA/SHA256, Tue Apr  7 01:19:31 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openjpeg2", "2.3.1", "6.el8", "x86_64", "openjpeg2-2.3.1-6.el8.src.rpm", 356438, "BSD and MIT", "CentOS", "", "C-Library for JPEG 2000", "RSA/SHA256, Sun Apr 26 02:35:33 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ocaml-srpm-macros", "5", "4.el8", "noarch", "ocaml-srpm-macros-5-4.el8.src.rpm", 737, "GPLv2+", "CentOS", "", "OCaml architecture macros", "RSA/SHA256, Tue Jul  2 00:23:51 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "copy-jdk-configs", "3.7", "1.el8", "noarch", "copy-jdk-configs-3.7-1.el8.src.rpm", 16774, "BSD", "CentOS", "", "JDKs configuration files copier", "RSA/SHA256, Mon Jul  1 21:02:55 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libwebp", "1.0.0", "1.el8", "x86_64", "libwebp-1.0.0-1.el8.src.rpm", 860976, "BSD", "CentOS", "", "Library and tools for the WebP graphics format", "RSA/SHA256, Mon Jul  1 23:51:56 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpaper", "1.1.24", "22.el8", "x86_64", "libpaper-1.1.24-22.el8.src.rpm", 90939, "GPLv2", "CentOS", "", "Library and tools for handling papersize", "RSA/SHA256, Mon Jul  1 23:34:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mcpp", "2.7.2", "20.el8", "x86_64", "mcpp-2.7.2-20.el8.src.rpm", 53794, "BSD", "CentOS", "", "Alternative C/C++ preprocessor", "RSA/SHA256, Tue Jul  2 00:03:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libijs", "0.35", "5.el8", "x86_64", "libijs-0.35-5.el8.src.rpm", 60640, "AGPLv3+", "CentOS", "", "IJS Raster Image Transport Protocol Library", "RSA/SHA256, Mon Jul  1 23:24:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "xorg-x11-font-utils", "7.5", "40.el8", "x86_64", "xorg-x11-font-utils-7.5-40.el8.src.rpm", 383068, "MIT", "CentOS", "", "X.Org X11 font utilities", "RSA/SHA256, Tue Jul  2 02:06:46 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdatrie", "0.2.9", "7.el8", "x86_64", "libdatrie-0.2.9-7.el8.src.rpm", 62583, "LGPLv2+", "CentOS", "", "Implementation of Double-Array structure for representing trie", "RSA/SHA256, Mon Jul  1 23:12:40 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libbabeltrace", "1.5.4", "2.el8", "x86_64", "babeltrace-1.5.4-2.el8.src.rpm", 580059, "MIT and GPLv2", "CentOS", "", "Common Trace Format Babel Tower", "RSA/SHA256, Mon Jul  1 23:07:21 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gc", "7.6.4", "3.el8", "x86_64", "gc-7.6.4-3.el8.src.rpm", 229024, "BSD", "CentOS", "", "A garbage collector for C and C++", "RSA/SHA256, Mon Jul  1 21:38:53 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb-headless", "8.2", "11.el8", "x86_64", "gdb-8.2-11.el8.src.rpm", 11897980, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and LGPLv3+ and BSD and Public Domain and GFDL", "CentOS", "", "A GNU source-level debugger for C, C++, Fortran, Go and other languages", "RSA/SHA256, Sun Apr 26 02:05:14 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXxf86misc", "1.0.4", "1.el8", "x86_64", "libXxf86misc-1.0.4-1.el8.src.rpm", 32012, "MIT", "CentOS", "", "X.Org X11 libXxf86misc runtime library", "RSA/SHA256, Mon Jul  1 23:57:12 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-bookman-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1428518, "AGPLv3", "CentOS", "", "URW Bookman font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:25 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-d050000l-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 86572, "AGPLv3", "CentOS", "", "D050000L font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-nimbus-mono-ps-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1099749, "AGPLv3", "CentOS", "", "Nimbus Mono PS font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:33 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-nimbus-sans-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 2469317, "AGPLv3", "CentOS", "", "Nimbus Sans font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:34 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-standard-symbols-ps-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 45184, "AGPLv3", "CentOS", "", "Standard Symbols PS font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 5478, "AGPLv3", "CentOS", "", "Core Font Set containing 35 freely distributable fonts from (URW)++", "RSA/SHA256, Tue Jul  2 01:56:27 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXcomposite", "0.4.4", "14.el8", "x86_64", "libXcomposite-0.4.4-14.el8.src.rpm", 35952, "MIT", "CentOS", "", "X Composite Extension library", "RSA/SHA256, Mon Jul  1 23:53:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jbigkit-libs", "2.1", "14.el8", "x86_64", "jbigkit-2.1-14.el8.src.rpm", 109677, "GPLv2+", "CentOS", "", "JBIG1 lossless image compression library", "RSA/SHA256, Mon Jul  1 22:56:46 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gd", "2.2.5", "6.el8", "x86_64", "gd-2.2.5-6.el8.src.rpm", 441251, "MIT", "CentOS", "", "A graphics library for quick creation of PNG or JPEG images", "RSA/SHA256, Mon Jul  1 21:39:49 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jbig2dec-libs", "0.14", "4.el8_2", "x86_64", "jbig2dec-0.14-4.el8_2.src.rpm", 146739, "GPLv2", "CentOS", "", "A decoder implementation of the JBIG2 image compression format", "RSA/SHA256, Tue Jul 14 14:25:08 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 61698975, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "Various compilers (C, C++, Objective-C, ...)", "RSA/SHA256, Fri Apr 17 22:05:39 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-gdb-plugin", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 341891, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "GCC plugin for GDB", "RSA/SHA256, Fri Apr 17 22:06:06 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "hicolor-icon-theme", "0.17", "2.el8", "noarch", "hicolor-icon-theme-0.17-2.el8.src.rpm", 73932, "GPLv2+", "CentOS", "", "Basic requirement for icon themes", "RSA/SHA256, Mon Jul  1 22:38:13 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "graphite2", "1.3.10", "10.el8", "x86_64", "graphite2-1.3.10-10.el8.src.rpm", 270396, "(LGPLv2+ or GPLv2+ or MPL) and (Netscape or GPLv2+ or LGPLv2+)", "CentOS", "", "Font rendering capabilities for complex non-Roman writing systems", "RSA/SHA256, Mon Jul  1 22:29:50 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "google-droid-sans-fonts", "20120715", "13.el8", "noarch", "google-droid-fonts-20120715-13.el8.src.rpm", 6229278, "ASL 2.0", "CentOS", "", "A humanist sans serif typeface", "RSA/SHA256, Mon Jul  1 22:25:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ghc-srpm-macros", "1.4.2", "7.el8", "noarch", "ghc-srpm-macros-1.4.2-7.el8.src.rpm", 414, "GPLv2+", "CentOS", "", "RPM macros for building Haskell source packages", "RSA/SHA256, Mon Jul  1 21:59:12 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pango", "1.42.4", "6.el8", "x86_64", "pango-1.42.4-6.el8.src.rpm", 958244, "LGPLv2+", "CentOS", "", "System for layout and rendering of internationalized text", "RSA/SHA256, Thu Dec  5 01:48:27 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "librsvg2", "2.42.7", "3.el8", "x86_64", "librsvg2-2.42.7-3.el8.src.rpm", 1830479, "LGPLv2+", "CentOS", "", "An SVG library based on cairo", "RSA/SHA256, Thu Dec  5 00:52:20 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 2835784, "GPLv3+ and (GPLv2+ or LGPLv3+) and GFDL", "CentOS", "", "A collection of utilities and DSOs to handle ELF files and DWARF data", "RSA/SHA256, Sun Apr 26 02:00:14 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dwz", "0.12", "9.el8", "x86_64", "dwz-0.12-9.el8.src.rpm", 232103, "GPLv2+ and GPLv3+", "CentOS", "", "DWARF optimization and duplicate removal tool", "RSA/SHA256, Mon Jul  1 21:19:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ctags", "5.8", "22.el8", "x86_64", "ctags-5.8-22.el8.src.rpm", 417116, "GPLv2+ and LGPLv2+ and Public Domain", "CentOS", "", "A C programming language indexing and/or cross-reference tool", "RSA/SHA256, Mon Jul  1 21:06:33 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-date-time", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 79610, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost date-time library", "RSA/SHA256, Thu Apr  9 03:26:07 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dyninst", "10.1.0", "4.el8", "x86_64", "dyninst-10.1.0-4.el8.src.rpm", 14686061, "LGPLv2+", "CentOS", "", "An API for Run-time Code Generation", "RSA/SHA256, Thu Apr  9 03:35:03 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-client", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 11184527, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - client", "RSA/SHA256, Sun Apr 26 03:04:00 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgs", "9.25", "5.el8_1.1", "x86_64", "ghostscript-9.25-5.el8_1.1.src.rpm", 20878358, "AGPLv3+", "CentOS", "", "Library providing Ghostcript's core functionality", "RSA/SHA256, Mon Dec 23 19:30:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "asciidoc", "8.6.10", "0.5.20180627gitf7c2274.el8", "noarch", "asciidoc-8.6.10-0.5.20180627gitf7c2274.el8.src.rpm", 808989, "GPL+ and GPLv2+", "CentOS", "", "Text based document generation", "RSA/SHA256, Mon Jul  1 20:40:21 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 299895, "GPLv2+", "CentOS", "", "Scripts and executable programs used to build packages", "RSA/SHA256, Sun Apr 26 02:51:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gcc-c++", "8.3.1", "5.el8.0.2", "x86_64", "gcc-8.3.1-5.el8.0.2.src.rpm", 32170609, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "CentOS", "", "C++ support for GCC", "RSA/SHA256, Fri Apr 17 22:05:41 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jna", "4.5.1", "5.el8", "x86_64", "jna-4.5.1-5.el8.src.rpm", 416128, "(LGPLv2 or ASL 2.0) and ASL 2.0", "CentOS", "", "Pure Java access to native libraries", "RSA/SHA256, Thu Dec  5 00:04:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "valgrind-devel", "3.15.0", "11.el8", "x86_64", "valgrind-3.15.0-11.el8.src.rpm", 474728, "GPLv2+", "CentOS", "", "Development files for valgrind aware programs", "RSA/SHA256, Sun Apr 26 03:08:01 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pesign", "0.112", "25.el8", "x86_64", "pesign-0.112-25.el8.src.rpm", 1060595, "GPLv2", "CentOS", "", "Signing utility for UEFI binaries", "RSA/SHA256, Tue Jul  2 00:54:41 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bison", "3.0.4", "10.el8", "x86_64", "bison-3.0.4-10.el8.src.rpm", 2199622, "GPLv3+", "CentOS", "", "A GNU general-purpose parser generator", "RSA/SHA256, Mon Jul  1 20:47:37 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "runc", "1.0.0", "65.rc10.module_el8.2.0+305+5e198a41", "x86_64", "runc-1.0.0-65.rc10.module_el8.2.0+305+5e198a41.src.rpm", 10250793, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "CLI for running Open Containers", "RSA/SHA256, Tue May 12 14:52:44 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-setuptools-wheel", "39.2.0", "5.el8", "noarch", "python-setuptools-39.2.0-5.el8.src.rpm", 347696, "MIT", "CentOS", "", "The setuptools wheel", "RSA/SHA256, Thu Dec  5 03:11:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ltrace", "0.7.91", "28.el8", "x86_64", "ltrace-0.7.91-28.el8.src.rpm", 339426, "GPLv2+", "CentOS", "", "Tracks runtime library calls from dynamically linked executables", "RSA/SHA256, Tue Apr  7 01:18:36 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libX11", "1.6.8", "3.el8", "x86_64", "libX11-1.6.8-3.el8.src.rpm", 1343952, "MIT", "CentOS", "", "Core X11 protocol client library", "RSA/SHA256, Sun Apr 26 02:26:10 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "centos-repos", "8.2", "2.2004.0.1.el8", "x86_64", "centos-release-8.2-2.2004.0.1.el8.src.rpm", 9660, "GPLv2", "CentOS", "", "CentOS Linux package repositories", "RSA/SHA256, Wed Jun  3 01:09:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cairo-gobject", "1.15.12", "3.el8", "x86_64", "cairo-1.15.12-3.el8.src.rpm", 36928, "LGPLv2 or MPLv1.1", "CentOS", "", "GObject bindings for cairo", "RSA/SHA256, Mon Jul  1 20:54:57 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2020a", "1.el8", "noarch", "tzdata-2020a-1.el8.src.rpm", 1904256, "Public Domain", "CentOS", "", "Timezone data", "RSA/SHA256, Tue Jun  2 20:59:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setroubleshoot-server", "3.3.22", "2.el8", "x86_64", "setroubleshoot-3.3.22-2.el8.src.rpm", 1347731, "GPLv2+", "CentOS", "", "SELinux troubleshoot server", "RSA/SHA256, Sun Apr 26 02:58:30 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "6.1", "7.20180224.el8", "x86_64", "ncurses-6.1-7.20180224.el8.src.rpm", 1120040, "MIT", "CentOS", "", "Ncurses libraries", "RSA/SHA256, Tue Jul  2 00:16:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "podman", "1.6.4", "10.module_el8.2.0+305+5e198a41", "x86_64", "podman-1.6.4-10.module_el8.2.0+305+5e198a41.src.rpm", 57521087, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "Manage Pods, Containers and Container Images", "RSA/SHA256, Tue May 12 14:49:47 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.4.19", "10.el8", "x86_64", "bash-4.4.19-10.el8.src.rpm", 6930068, "GPLv3+", "CentOS", "", "The GNU Bourne Again shell", "RSA/SHA256, Wed Dec  4 22:45:04 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "skopeo", "0.1.40", "11.module_el8.2.0+377+92552693", "x86_64", "skopeo-0.1.40-11.module_el8.2.0+377+92552693.src.rpm", 22732055, "ASL 2.0", "CentOS", "container-tools:rhel8:8020020200603213325:0d58ad57", "Inspect container images and repositories on registries", "RSA/SHA256, Wed Jun  3 22:11:31 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "26.el8", "x86_64", "bzip2-1.0.6-26.el8.src.rpm", 77229, "BSD", "CentOS", "", "Libraries for applications using bzip2", "RSA/SHA256, Mon Jul  1 20:54:19 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Exporter", "5.72", "396.el8", "noarch", "perl-Exporter-5.72-396.el8.src.rpm", 55719, "GPL+ or Artistic", "CentOS", "", "Implements default import method for modules", "RSA/SHA256, Tue Jul  2 00:44:11 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 920699, "GPLv2+ or LGPLv3+", "CentOS", "", "Library to read and write ELF files", "RSA/SHA256, Sun Apr 26 02:00:51 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nspr", "4.25.0", "2.el8_2", "x86_64", "nspr-4.25.0-2.el8_2.src.rpm", 317302, "MPLv2.0", "CentOS", "", "Netscape Portable Runtime", "RSA/SHA256, Fri Aug  7 23:59:18 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite-libs", "3.26.0", "6.el8", "x86_64", "sqlite-3.26.0-6.el8.src.rpm", 1162241, "Public Domain", "CentOS", "", "Shared library for the sqlite3 embeddable SQL database engine.", "RSA/SHA256, Sun Apr 26 02:59:30 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libjpeg-turbo", "1.5.3", "10.el8", "x86_64", "libjpeg-turbo-1.5.3-10.el8.src.rpm", 638420, "IJG", "CentOS", "", "A MMX/SSE2/SIMD accelerated library for manipulating JPEG image files", "RSA/SHA256, Thu Dec  5 00:27:10 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.16", "14.el8", "x86_64", "popt-1.16-14.el8.src.rpm", 128374, "MIT", "CentOS", "", "C library for parsing command line parameters", "RSA/SHA256, Tue Jul  2 00:58:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Text-ParseWords", "3.30", "395.el8", "noarch", "perl-Text-ParseWords-3.30-395.el8.src.rpm", 13101, "GPL+ or Artistic", "CentOS", "", "Parse text into an array of tokens or array of arrays", "RSA/SHA256, Tue Jul  2 00:52:35 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.13.1", "0.2.el8", "x86_64", "json-c-0.13.1-0.2.el8.src.rpm", 73898, "MIT", "CentOS", "", "JSON implementation in C", "RSA/SHA256, Mon Jul  1 22:57:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "emacs-filesystem", "26.1", "5.el8", "noarch", "emacs-26.1-5.el8.src.rpm", 0, "GPLv3+ and CC0-1.0", "CentOS", "", "Emacs filesystem layout", "RSA/SHA256, Mon Jul  1 21:22:18 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.5", "1.el8", "x86_64", "sed-4.5-1.el8.src.rpm", 776854, "GPLv3+", "CentOS", "", "A GNU stream text editor", "RSA/SHA256, Tue Jul  2 01:29:38 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXpm", "3.5.12", "8.el8", "x86_64", "libXpm-3.5.12-8.el8.src.rpm", 120823, "MIT", "CentOS", "", "X.Org X11 libXpm runtime library", "RSA/SHA256, Thu Apr  9 03:50:41 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "3.0", "0.17.20191104git1c2f876.el8", "x86_64", "audit-3.0-0.17.20191104git1c2f876.el8.src.rpm", 283708, "LGPLv2+", "CentOS", "", "Dynamic library for libaudit", "RSA/SHA256, Sun Apr 26 01:45:13 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zip", "3.0", "23.el8", "x86_64", "zip-3.0-23.el8.src.rpm", 842885, "BSD", "CentOS", "", "A file compression and packaging utility compatible with PKZIP", "RSA/SHA256, Tue Jul  2 02:09:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua-libs", "5.3.4", "11.el8", "x86_64", "lua-5.3.4-11.el8.src.rpm", 351728, "MIT", "CentOS", "", "Libraries for lua", "RSA/SHA256, Thu Dec  5 01:13:03 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-chrono", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 38826, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost chrono library", "RSA/SHA256, Thu Apr  9 03:25:42 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.9", "9.el8", "x86_64", "gzip-1.9-9.el8.src.rpm", 426515, "GPLv3+ and GFDL", "CentOS", "", "The GNU data compression program", "RSA/SHA256, Wed Dec  4 23:54:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Text-Tabs+Wrap", "2013.0523", "395.el8", "noarch", "perl-Text-Tabs+Wrap-2013.0523-395.el8.src.rpm", 24825, "TTWL", "CentOS", "", "Expand tabs and do simple line wrapping", "RSA/SHA256, Tue Jul  2 00:52:40 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.5.1", "3.el8", "x86_64", "libassuan-2.5.1-3.el8.src.rpm", 202763, "LGPLv2+ and GPLv3+", "CentOS", "", "GnuPG IPC library", "RSA/SHA256, Mon Jul  1 23:06:19 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-PathTools", "3.74", "1.el8", "x86_64", "perl-PathTools-3.74-1.el8.src.rpm", 182821, "(GPL+ or Artistic) and BSD", "CentOS", "", "PathTools Perl module (Cwd, File::Spec)", "RSA/SHA256, Tue Jul  2 00:49:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.13", "3.el8", "x86_64", "libtasn1-4.13-3.el8.src.rpm", 168725, "GPLv3+ and LGPLv2+", "CentOS", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Mon Jul  1 23:46:12 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(4), "perl-interpreter", "5.26.3", "416.el8", "x86_64", "perl-5.26.3-416.el8.src.rpm", 14381705, "(GPL+ or Artistic) and (GPLv2+ or Artistic) and BSD and Public Domain and UCD", "CentOS", "", "Standalone executable Perl interpreter", "RSA/SHA256, Tue Jul  2 00:45:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "3.1", "6.el8", "x86_64", "grep-3.1-6.el8.src.rpm", 835205, "GPLv3+", "CentOS", "", "Pattern matching utilities", "RSA/SHA256, Mon Jul  1 22:30:49 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Data-Dumper", "2.167", "399.el8", "x86_64", "perl-Data-Dumper-2.167-399.el8.src.rpm", 106523, "GPL+ or Artistic", "CentOS", "", "Stringify perl data structures, suitable for printing and eval", "RSA/SHA256, Tue Jul  2 00:41:59 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(12), "dhcp-libs", "4.3.6", "40.el8", "x86_64", "dhcp-4.3.6-40.el8.src.rpm", 161256, "ISC", "CentOS", "", "Shared libraries used by ISC dhcp client and server", "RSA/SHA256, Fri Apr 24 14:50:45 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool-ltdl", "2.4.6", "25.el8", "x86_64", "libtool-2.4.6-25.el8.src.rpm", 71434, "LGPLv2+", "CentOS", "", "Runtime libraries for GNU Libtool Dynamic Module Loader", "RSA/SHA256, Mon Jul  1 23:47:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz", "5.2.4", "3.el8", "x86_64", "xz-5.2.4-3.el8.src.rpm", 432832, "GPLv2+ and Public Domain", "CentOS", "", "LZMA compression utilities", "RSA/SHA256, Tue Jul  2 02:08:26 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXinerama", "1.1.4", "1.el8", "x86_64", "libXinerama-1.1.4-1.el8.src.rpm", 15719, "MIT", "CentOS", "", "X.Org X11 libXinerama runtime library", "RSA/SHA256, Mon Jul  1 23:54:52 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.6", "8.el8", "x86_64", "shadow-utils-4.6-8.el8.src.rpm", 5368080, "BSD and GPLv2+", "CentOS", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Thu Dec  5 03:38:03 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "adobe-mappings-cmap", "20171205", "3.el8", "noarch", "adobe-mappings-cmap-20171205-3.el8.src.rpm", 13746679, "BSD", "CentOS", "", "CMap resources for Adobe's character collections", "RSA/SHA256, Mon Jul  1 20:37:42 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "3.1.6", "1.el8", "x86_64", "mpfr-3.1.6-1.el8.src.rpm", 612625, "LGPLv3+ and GPLv3+ and GFDL", "CentOS", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Tue Jul  2 00:12:54 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Digest-MD5", "2.55", "396.el8", "x86_64", "perl-Digest-MD5-2.55-396.el8.src.rpm", 56718, "(GPL+ or Artistic) and BSD", "CentOS", "", "Perl interface to the MD5 algorithm", "RSA/SHA256, Tue Jul  2 00:43:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmetalink", "0.1.3", "7.el8", "x86_64", "libmetalink-0.1.3-7.el8.src.rpm", 76960, "MIT", "CentOS", "", "Metalink library written in C", "RSA/SHA256, Mon Jul  1 23:29:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-XML-Parser", "2.44", "11.el8", "x86_64", "perl-XML-Parser-2.44-11.el8.src.rpm", 643439, "GPL+ or Artistic", "CentOS", "", "Perl module for parsing XML documents", "RSA/SHA256, Tue Jul  2 00:54:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "ethtool", "5.0", "2.el8", "x86_64", "ethtool-5.0-2.el8.src.rpm", 502623, "GPLv2", "CentOS", "", "Settings tool for Ethernet NICs", "RSA/SHA256, Wed Dec  4 23:12:50 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Thread-Queue", "3.13", "1.el8", "noarch", "perl-Thread-Queue-3.13-1.el8.src.rpm", 29787, "GPL+ or Artistic", "CentOS", "", "Thread-safe queues", "RSA/SHA256, Tue Jul  2 00:52:50 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(14), "libpcap", "1.9.0", "3.el8", "x86_64", "libpcap-1.9.0-3.el8.src.rpm", 424251, "BSD with advertising", "CentOS", "", "A system-independent interface for user-level packet capture", "RSA/SHA256, Mon Dec 16 17:39:10 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext", "0.19.8.1", "17.el8", "x86_64", "gettext-0.19.8.1-17.el8.src.rpm", 5412553, "GPLv3+ and LGPLv2+", "CentOS", "", "GNU libraries and utilities for producing multi-lingual messages", "RSA/SHA256, Wed Dec  4 23:25:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.2.1", "1.el8", "x86_64", "gawk-4.2.1-1.el8.src.rpm", 2717614, "GPLv3+ and GPLv2+ and LGPLv2+ and BSD", "CentOS", "", "The GNU version of the AWK text processing utility", "RSA/SHA256, Mon Jul  1 21:38:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-filesystem", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 113690, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost filesystem library", "RSA/SHA256, Thu Apr  9 03:26:48 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.17", "18.el8", "x86_64", "krb5-1.17-18.el8.src.rpm", 2259532, "MIT", "CentOS", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Sun Apr 26 02:17:59 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nss-softokn", "3.53.1", "11.el8_2", "x86_64", "nss-3.53.1-11.el8_2.src.rpm", 1917766, "MPLv2.0", "CentOS", "", "Network Security Services Softoken Module", "RSA/SHA256, Tue Aug 11 23:26:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "platform-python", "3.6.8", "23.el8", "x86_64", "python3-3.6.8-23.el8.src.rpm", 41790, "Python", "CentOS", "", "Internal interpreter of the Python programming language", "RSA/SHA256, Thu Apr 16 14:38:56 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-Fedora-VSP", "0.001", "9.el8", "noarch", "perl-Fedora-VSP-0.001-9.el8.src.rpm", 40886, "GPLv3+", "CentOS", "", "Perl version normalization for RPM", "RSA/SHA256, Tue Jul  2 00:44:29 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.3.1", "8.el8", "x86_64", "pam-1.3.1-8.el8.src.rpm", 2857052, "BSD and GPLv2+", "CentOS", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Thu Apr 16 00:43:57 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openssh", "8.0p1", "4.el8_1", "x86_64", "openssh-8.0p1-4.el8_1.src.rpm", 2255675, "BSD", "CentOS", "", "An open source implementation of SSH protocol version 2", "RSA/SHA256, Wed Feb  5 00:07:08 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "25", "16.el8", "x86_64", "kmod-25-16.el8.src.rpm", 126640, "LGPLv2+", "CentOS", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Thu Apr  9 03:42:38 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "python3-dateutil", "2.6.1", "6.el8", "noarch", "python-dateutil-2.6.1-6.el8.src.rpm", 596677, "BSD", "CentOS", "", "Powerful extensions to the standard datetime module", "RSA/SHA256, Tue Jul  2 01:04:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl-minimal", "7.61.1", "12.el8", "x86_64", "curl-7.61.1-12.el8.src.rpm", 551776, "MIT", "CentOS", "", "Conservatively configured build of libcurl for minimal installations", "RSA/SHA256, Fri Mar 27 03:15:10 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl", "1.1.1c", "15.el8", "x86_64", "openssl-1.1.1c-15.el8.src.rpm", 1175523, "OpenSSL", "CentOS", "", "Utilities from the general purpose cryptography library with TLS implementation", "RSA/SHA256, Sun Apr 26 02:37:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.28", "37.el8", "x86_64", "libdb-5.3.28-37.el8.src.rpm", 536911, "BSD and LGPLv2 and Sleepycat", "CentOS", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Thu Dec  5 00:19:15 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lksctp-tools", "1.0.18", "3.el8", "x86_64", "lksctp-tools-1.0.18-3.el8.src.rpm", 258226, "GPLv2 and GPLv2+ and LGPLv2 and MIT", "CentOS", "", "User-space access to Linux Kernel SCTP", "RSA/SHA256, Mon Jul  1 23:58:07 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 2084270, "GPLv2+", "CentOS", "", "The RPM package management system", "RSA/SHA256, Sun Apr 26 02:51:49 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pkgconf", "1.4.2", "1.el8", "x86_64", "pkgconf-1.4.2-1.el8.src.rpm", 63271, "ISC", "CentOS", "", "Package compiler and linker metadata toolkit", "RSA/SHA256, Tue Jul  2 00:55:47 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmodulemd1", "1.8.16", "0.2.8.2.1", "x86_64", "libmodulemd-2.8.2-1.el8.src.rpm", 546039, "MIT", "CentOS", "", "Compatibility package for libmodulemd 1.x", "RSA/SHA256, Thu Feb 20 16:53:40 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libedit", "3.1", "23.20170329cvs.el8", "x86_64", "libedit-3.1-23.20170329cvs.el8.src.rpm", 247168, "BSD", "CentOS", "", "The NetBSD Editline library", "RSA/SHA256, Mon Jul  1 23:15:59 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "librepo", "1.11.0", "2.el8", "x86_64", "librepo-1.11.0-2.el8.src.rpm", 262664, "LGPLv2+", "CentOS", "", "Repodata downloading library", "RSA/SHA256, Thu Apr 16 00:43:50 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kernel-headers", "4.18.0", "193.28.1.el8_2", "x86_64", "kernel-4.18.0-193.28.1.el8_2.src.rpm", 4958028, "GPLv2 and Redistributable, no modification permitted", "CentOS", "", "Header files for the Linux kernel for use by glibc", "RSA/SHA256, Thu Oct 22 02:46:04 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-gpg", "1.10.0", "6.el8.0.1", "x86_64", "gpgme-1.10.0-6.el8.0.1.src.rpm", 1295107, "LGPLv2+", "CentOS", "", "gpgme bindings for Python 3", "RSA/SHA256, Tue Jul  2 01:04:57 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "groff-base", "1.22.3", "18.el8", "x86_64", "groff-1.22.3-18.el8.src.rpm", 4216866, "GPLv3+ and GFDL and BSD and MIT", "CentOS", "", "Parts of the groff formatting system required to display manual pages", "RSA/SHA256, Mon Jul  1 22:31:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-common", "1.12.8", "10.el8_2", "noarch", "dbus-1.12.8-10.el8_2.src.rpm", 11131, "(GPLv2+ or AFL) and GPLv2+", "CentOS", "", "D-BUS message bus configuration", "RSA/SHA256, Fri Aug  7 22:56:46 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-podlators", "4.11", "1.el8", "noarch", "perl-podlators-4.11-1.el8.src.rpm", 287639, "(GPL+ or Artistic) and FSFAP", "CentOS", "", "Format POD source into various output formats", "RSA/SHA256, Tue Jul  2 00:50:02 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "2.2.2", "1.el8", "x86_64", "cryptsetup-2.2.2-1.el8.src.rpm", 1871402, "GPLv2+ and LGPLv2+", "CentOS", "", "Cryptsetup shared library", "RSA/SHA256, Thu Apr  9 03:32:38 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-IO-Socket-SSL", "2.066", "4.el8", "noarch", "perl-IO-Socket-SSL-2.066-4.el8.src.rpm", 618705, "(GPL+ or Artistic) and MPLv2.0", "CentOS", "", "Perl library for transparent SSL", "RSA/SHA256, Tue Apr  7 01:18:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "239", "31.el8_2.2", "x86_64", "systemd-239-31.el8_2.2.src.rpm", 11073343, "LGPLv2+ and MIT and GPLv2+", "CentOS", "", "System and Service Manager", "RSA/SHA256, Sat Aug  8 01:28:05 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "automake", "1.16.1", "6.el8", "noarch", "automake-1.16.1-6.el8.src.rpm", 1805946, "GPLv2+ and GFDL and Public Domain and MIT", "CentOS", "", "A GNU tool for automatically creating Makefiles", "RSA/SHA256, Mon Jul  1 20:43:16 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libkcapi", "1.1.1", "16_1.el8", "x86_64", "libkcapi-1.1.1-16_1.el8.src.rpm", 82828, "BSD or GPLv2", "CentOS", "", "User space interface to the Linux Kernel Crypto API", "RSA/SHA256, Mon Jul  1 23:26:02 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gettext-devel", "0.19.8.1", "17.el8", "x86_64", "gettext-0.19.8.1-17.el8.src.rpm", 1552453, "LGPLv2+ and GPLv3+", "CentOS", "", "Development files for gettext", "RSA/SHA256, Wed Dec  4 23:25:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dracut-network", "049", "70.git20200228.el8", "x86_64", "dracut-049-70.git20200228.el8.src.rpm", 160704, "GPLv2+ and LGPLv2+", "CentOS", "", "dracut modules to build a dracut initramfs with network support", "RSA/SHA256, Sun Apr 26 01:59:31 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata-java", "2020d", "1.el8", "noarch", "tzdata-2020d-1.el8.src.rpm", 374148, "Public Domain", "CentOS", "", "Timezone data for Java", "RSA/SHA256, Mon Oct 26 22:26:24 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dnf", "4.2.17", "7.el8_2", "noarch", "dnf-4.2.17-7.el8_2.src.rpm", 1829655, "GPLv2+ and GPLv2 and GPL", "CentOS", "", "Python 3 interface to DNF", "RSA/SHA256, Fri Aug  7 23:00:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-rpm-macros", "3", "38.el8", "noarch", "python-rpm-macros-3-38.el8.src.rpm", 1888, "MIT", "CentOS", "", "RPM macros for building Python 3 packages", "RSA/SHA256, Tue Apr  7 01:19:29 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "binutils", "2.30", "73.el8", "x86_64", "binutils-2.30-73.el8.src.rpm", 24856745, "GPLv3+", "CentOS", "", "A GNU collection of binary utilities", "RSA/SHA256, Sun Apr 26 01:47:49 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openblas-srpm-macros", "2", "2.el8", "noarch", "openblas-srpm-macros-2-2.el8.src.rpm", 104, "MIT", "CentOS", "", "OpenBLAS architecture macros", "RSA/SHA256, Tue Jul  2 00:25:23 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "less", "530", "1.el8", "x86_64", "less-530-1.el8.src.rpm", 344874, "GPLv3+ or BSD", "CentOS", "", "A text file browser similar to more, but better", "RSA/SHA256, Mon Jul  1 23:04:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "java-1.8.0-openjdk-headless", "1.8.0.272.b10", "1.el8_2", "x86_64", "java-1.8.0-openjdk-1.8.0.272.b10-1.el8_2.src.rpm", 122536636, "ASL 1.1 and ASL 2.0 and BSD and BSD with advertising and GPL+ and GPLv2 and GPLv2 with exceptions and IJG and LGPLv2+ and MIT and MPLv2.0 and Public Domain and W3C and zlib", "CentOS", "", "OpenJDK Headless Runtime Environment 8", "RSA/SHA256, Fri Oct 30 16:32:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "nodejs-full-i18n", "10.21.0", "3.module_el8.2.0+391+8da3adc6", "x86_64", "nodejs-10.21.0-3.module_el8.2.0+391+8da3adc6.src.rpm", 27531792, "MIT and ASL 2.0 and ISC and BSD", "CentOS", "nodejs:10:8020020200707141642:6a468ee4", "Non-English locale data for Node.js", "RSA/SHA256, Tue Jul  7 16:08:45 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmcpp", "2.7.2", "20.el8", "x86_64", "mcpp-2.7.2-20.el8.src.rpm", 153388, "BSD", "CentOS", "", "Alternative C/C++ preprocessor (library build)", "RSA/SHA256, Mon Jul  1 23:28:55 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "polkit-libs", "0.115", "11.el8", "x86_64", "polkit-0.115-11.el8.src.rpm", 273132, "LGPLv2+", "CentOS", "", "Libraries for polkit", "RSA/SHA256, Tue Apr 14 06:05:51 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfontenc", "1.1.3", "8.el8", "x86_64", "libfontenc-1.1.3-8.el8.src.rpm", 57021, "MIT", "CentOS", "", "X.Org X11 libfontenc runtime library", "RSA/SHA256, Mon Jul  1 23:18:40 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "jansson", "2.11", "3.el8", "x86_64", "jansson-2.11-3.el8.src.rpm", 88783, "MIT", "CentOS", "", "C library for encoding, decoding and manipulating JSON data", "RSA/SHA256, Mon Jul  1 22:51:58 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libthai", "0.1.27", "2.el8", "x86_64", "libthai-0.1.27-2.el8.src.rpm", 774997, "LGPLv2+", "CentOS", "", "Thai language support routines", "RSA/SHA256, Mon Jul  1 23:46:44 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libsemanage", "2.9", "2.el8", "x86_64", "libsemanage-2.9-2.el8.src.rpm", 474221, "LGPLv2+", "CentOS", "", "semanage python 3 bindings for libsemanage", "RSA/SHA256, Tue Apr 14 06:05:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(5), "guile", "2.0.14", "7.el8", "x86_64", "guile-2.0.14-7.el8.src.rpm", 12159310, "LGPLv3+", "CentOS", "", "A GNU implementation of Scheme for application extensibility", "RSA/SHA256, Mon Jul  1 22:35:28 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux-utils", "2.9", "3.el8", "x86_64", "libselinux-2.9-3.el8.src.rpm", 369120, "Public Domain", "CentOS", "", "SELinux libselinux utilities", "RSA/SHA256, Tue Apr 14 06:05:26 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xorg-x11-server-utils", "7.7", "27.el8", "x86_64", "xorg-x11-server-utils-7.7-27.el8.src.rpm", 502730, "MIT", "CentOS", "", "X.Org X11 X server utilities", "RSA/SHA256, Tue Jul  2 02:07:01 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "initscripts", "10.00.6", "1.el8_2.2", "x86_64", "initscripts-10.00.6-1.el8_2.2.src.rpm", 1086847, "GPLv2", "CentOS", "", "Basic support for legacy System V init scripts", "RSA/SHA256, Wed Sep 16 20:12:35 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-gothic-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1216672, "AGPLv3", "CentOS", "", "URW Gothic font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:32 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pixman", "0.38.4", "1.el8", "x86_64", "pixman-0.38.4-1.el8.src.rpm", 693167, "MIT", "CentOS", "", "Pixel manipulation library", "RSA/SHA256, Thu Apr  9 04:00:07 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "urw-base35-p052-fonts", "20170801", "10.el8", "noarch", "urw-base35-fonts-20170801-10.el8.src.rpm", 1557171, "AGPLv3", "CentOS", "", "P052 font family [part of Level 2 Core Font Set]", "RSA/SHA256, Tue Jul  2 01:56:35 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "iptables", "1.8.4", "10.el8_2.1", "x86_64", "iptables-1.8.4-10.el8_2.1.src.rpm", 1974841, "GPLv2 and Artistic 2.0 and ISC", "CentOS", "", "Tools for managing Linux kernel packet filtering capabilities", "RSA/SHA256, Fri Aug  7 23:20:53 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libXft", "2.3.2", "10.el8", "x86_64", "libXft-2.3.2-10.el8.src.rpm", 136069, "MIT", "CentOS", "", "X.Org X11 libXft runtime library", "RSA/SHA256, Mon Jul  1 23:54:39 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-gobject-base", "3.28.3", "1.el8", "x86_64", "pygobject3-3.28.3-1.el8.src.rpm", 1116879, "LGPLv2+ and MIT", "CentOS", "", "Python 3 bindings for GObject Introspection base package", "RSA/SHA256, Tue Jul  2 01:04:53 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtiff", "4.0.9", "17.el8", "x86_64", "libtiff-4.0.9-17.el8.src.rpm", 517321, "libtiff", "CentOS", "", "Library of functions for manipulating TIFF format image files", "RSA/SHA256, Thu Apr  9 03:48:32 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-setuptools", "39.2.0", "5.el8", "noarch", "python-setuptools-39.2.0-5.el8.src.rpm", 460967, "MIT", "CentOS", "", "Easily build and distribute Python 3 packages", "RSA/SHA256, Thu Dec  5 03:11:46 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "isl", "0.16.1", "6.el8", "x86_64", "isl-0.16.1-6.el8.src.rpm", 3270833, "MIT", "CentOS", "", "Integer point manipulation library", "RSA/SHA256, Mon Jul  1 22:51:04 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python36", "3.6.8", "2.module_el8.1.0+245+c39af44f", "x86_64", "python36-3.6.8-2.module_el8.1.0+245+c39af44f.src.rpm", 13131, "Python", "CentOS", "python36:3.6:8010020191115015851:a920e634", "Interpreter of the Python programming language", "RSA/SHA256, Thu Dec  5 03:03:36 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap-devel", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 8837735, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system - development headers, tools", "RSA/SHA256, Sun Apr 26 03:04:20 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "polkit-pkla-compat", "0.1", "12.el8", "x86_64", "polkit-pkla-compat-0.1-12.el8.src.rpm", 95728, "LGPLv2+", "CentOS", "", "Rules for polkit to add compatibility with pklocalauthority", "RSA/SHA256, Tue Jul  2 00:58:08 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "harfbuzz", "1.7.5", "3.el8", "x86_64", "harfbuzz-1.7.5-3.el8.src.rpm", 802826, "MIT", "CentOS", "", "Text shaping library", "RSA/SHA256, Mon Jul  1 22:37:39 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh", "0.9.0", "4.el8", "x86_64", "libssh-0.9.0-4.el8.src.rpm", 822758, "LGPLv2+", "CentOS", "", "A library implementing the SSH protocol", "RSA/SHA256, Thu Dec  5 00:55:16 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fribidi", "1.0.4", "8.el8", "x86_64", "fribidi-1.0.4-8.el8.src.rpm", 319733, "LGPLv2+ and UCD", "CentOS", "", "Library implementing the Unicode Bidirectional Algorithm", "RSA/SHA256, Thu Apr  9 03:38:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib-networking", "2.56.1", "1.1.el8", "x86_64", "glib-networking-2.56.1-1.1.el8.src.rpm", 531110, "LGPLv2+", "CentOS", "", "Networking support for GLib", "RSA/SHA256, Mon Jul  1 22:19:14 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-debuginfod-client", "0.178", "7.el8", "x86_64", "elfutils-0.178-7.el8.src.rpm", 35910, "GPLv3+ and (GPLv2+ or LGPLv3+)", "CentOS", "", "Library and command line client for build-id HTTP ELF/DWARF server", "RSA/SHA256, Sun Apr 26 02:00:25 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "PackageKit", "1.1.12", "4.el8", "x86_64", "PackageKit-1.1.12-4.el8.src.rpm", 2873887, "GPLv2+ and LGPLv2+", "CentOS", "", "Package management service", "RSA/SHA256, Wed Apr 15 02:23:59 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-rpm-config", "122", "1.el8", "noarch", "redhat-rpm-config-122-1.el8.src.rpm", 140370, "GPL+", "CentOS", "", "CentOS specific rpm configuration files", "RSA/SHA256, Wed May  6 02:50:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fuse-overlayfs", "0.7.2", "5.module_el8.2.0+305+5e198a41", "x86_64", "fuse-overlayfs-0.7.2-5.module_el8.2.0+305+5e198a41.src.rpm", 119420, "GPLv3+", "CentOS", "container-tools:rhel8:8020020200507003530:0d58ad57", "FUSE overlay+shiftfs implementation for rootless containers", "RSA/SHA256, Tue May 12 14:29:01 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "boost-atomic", "1.66.0", "7.el8", "x86_64", "boost-1.66.0-7.el8.src.rpm", 8666, "Boost and MIT and Python", "CentOS", "", "Run-time component of boost atomic library", "RSA/SHA256, Thu Apr  9 03:25:35 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-plugin-selinux", "4.14.2", "37.el8", "x86_64", "rpm-4.14.2-37.el8.src.rpm", 11880, "GPLv2+", "CentOS", "", "Rpm plugin for SELinux functionality", "RSA/SHA256, Sun Apr 26 02:53:12 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "adobe-mappings-pdf", "20180407", "1.el8", "noarch", "adobe-mappings-pdf-20180407-1.el8.src.rpm", 4398414, "BSD", "CentOS", "", "PDF mapping resources from Adobe", "RSA/SHA256, Mon Jul  1 20:37:45 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dbus", "1.2.4", "15.el8", "x86_64", "dbus-python-1.2.4-15.el8.src.rpm", 489189, "MIT", "CentOS", "", "D-Bus bindings for python3", "RSA/SHA256, Thu Dec  5 03:05:04 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemtap", "4.2", "6.el8", "x86_64", "systemtap-4.2-6.el8.src.rpm", 0, "GPLv2+", "CentOS", "", "Programmable system-wide instrumentation system", "RSA/SHA256, Sun Apr 26 03:03:55 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "policycoreutils-python-utils", "2.9", "9.el8", "noarch", "policycoreutils-2.9-9.el8.src.rpm", 140042, "GPLv2", "CentOS", "", "SELinux policy core python utilities", "RSA/SHA256, Sun Apr 26 02:47:17 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtool", "2.4.6", "25.el8", "x86_64", "libtool-2.4.6-25.el8.src.rpm", 2687501, "GPLv2+ and LGPLv2+ and GFDL", "CentOS", "", "The GNU Portable Library Tool", "RSA/SHA256, Mon Jul  1 23:47:28 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "NetworkManager-team", "1.22.8", "5.el8_2", "x86_64", "NetworkManager-1.22.8-5.el8_2.src.rpm", 45480, "GPLv2+ and LGPLv2+", "CentOS", "", "Team device plugin for NetworkManager", "RSA/SHA256, Fri Aug  7 22:46:02 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-generators", "1.10", "9.el8", "noarch", "perl-generators-1.10-9.el8.src.rpm", 21852, "GPL+", "CentOS", "", "RPM Perl dependencies generators", "RSA/SHA256, Thu Dec  5 02:14:30 2019, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ostree-libs", "2019.6", "2.el8", "x86_64", "ostree-2019.6-2.el8.src.rpm", 981292, "LGPLv2+", "CentOS", "", "Development headers for ostree", "RSA/SHA256, Thu Apr  9 03:59:21 2020, Key ID 05b555b38483c65d", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --platform s390x --rm -it registry.access.redhat.com/ubi8/ubi bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"%{MODULARITYLABEL}\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/^{\([[:digit:]]\+\)/{intRef(\1)/g" | sed "s/(none)//g"
	UBI8s390x = []*PackageInfo{
		{intRef(), "tzdata", "2022a", "1.el8", "noarch", "tzdata-2022a-1.el8.src.rpm", 1891990, "Public Domain", "Red Hat, Inc.", "", "Timezone data", "RSA/SHA256, Tue Mar 22 08:30:35 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-pip-wheel", "9.0.3", "22.el8", "noarch", "python-pip-9.0.3-22.el8.src.rpm", 929805, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "Red Hat, Inc.", "", "The pip wheel", "RSA/SHA256, Thu Oct 14 09:17:00 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "redhat-release", "8.6", "0.1.el8", "s390x", "redhat-release-8.6-0.1.el8.src.rpm", 56548, "GPLv2", "Red Hat, Inc.", "", "Red Hat Enterprise Linux release file", "RSA/SHA256, Wed Apr  6 12:04:34 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.8", "6.el8", "s390x", "filesystem-3.8-6.el8.src.rpm", 0, "Public Domain", "Red Hat, Inc.", "", "The basic directory layout for a Linux system", "RSA/SHA256, Mon Jun 21 11:17:44 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "publicsuffix-list-dafsa", "20180723", "1.el8", "noarch", "publicsuffix-list-20180723-1.el8.src.rpm", 64502, "MPLv2.0", "Red Hat, Inc.", "", "Cross-vendor public domain suffix database in DAFSA form", "RSA/SHA256, Sat Dec 15 00:46:44 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre2", "10.32", "2.el8", "s390x", "pcre2-10.32-2.el8.src.rpm", 466150, "BSD", "Red Hat, Inc.", "", "Perl-compatible regular expression library", "RSA/SHA256, Fri May 29 10:23:33 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "6.1", "9.20180224.el8", "s390x", "ncurses-6.1-9.20180224.el8.src.rpm", 977472, "MIT", "Red Hat, Inc.", "", "Ncurses libraries", "RSA/SHA256, Mon May 31 10:28:35 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.28", "189.1.el8", "s390x", "glibc-2.28-189.1.el8.src.rpm", 8623535, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Red Hat, Inc.", "", "Common binaries and locale data for glibc", "RSA/SHA256, Wed Mar 23 08:54:38 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.4.20", "3.el8", "s390x", "bash-4.4.20-3.el8.src.rpm", 7065310, "GPLv3+", "Red Hat, Inc.", "", "The GNU Bourne Again shell", "RSA/SHA256, Thu Sep 30 08:42:21 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.11", "18.el8_5", "s390x", "zlib-1.2.11-18.el8_5.src.rpm", 212335, "zlib and Boost", "Red Hat, Inc.", "", "The compression and decompression library", "RSA/SHA256, Wed Apr 13 13:49:22 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.6", "26.el8", "s390x", "bzip2-1.0.6-26.el8.src.rpm", 84197, "BSD", "Red Hat, Inc.", "", "Libraries for applications using bzip2", "RSA/SHA256, Fri Dec 14 21:50:53 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite-libs", "3.26.0", "15.el8", "s390x", "sqlite-3.26.0-15.el8.src.rpm", 1265377, "Public Domain", "Red Hat, Inc.", "", "Shared library for the sqlite3 embeddable SQL database engine.", "RSA/SHA256, Wed May 19 06:05:23 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.48", "2.el8", "s390x", "libcap-2.48-2.el8.src.rpm", 165085, "BSD or GPLv2", "Red Hat, Inc.", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Mon Jan 31 11:32:17 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libzstd", "1.4.4", "1.el8", "s390x", "zstd-1.4.4-1.el8.src.rpm", 709973, "BSD and GPLv2", "Red Hat, Inc.", "", "Zstd shared library", "RSA/SHA256, Mon Jun  8 09:18:39 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.7", "13.el8", "s390x", "libxml2-2.9.7-13.el8.src.rpm", 1829754, "MIT", "Red Hat, Inc.", "", "Library providing XML and HTML support", "RSA/SHA256, Fri Feb 25 09:49:18 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.2.5", "8.el8", "s390x", "expat-2.2.5-8.el8.src.rpm", 379588, "MIT", "Red Hat, Inc.", "", "An XML parser library", "RSA/SHA256, Tue Mar 15 11:22:07 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.45.6", "4.el8", "s390x", "e2fsprogs-1.45.6-4.el8.src.rpm", 61025, "MIT", "Red Hat, Inc.", "", "Common error description library", "RSA/SHA256, Thu Mar  3 13:49:25 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.32.1", "35.el8", "s390x", "util-linux-2.32.1-35.el8.src.rpm", 34312, "BSD", "Red Hat, Inc.", "", "Universally unique ID library", "RSA/SHA256, Wed Mar  9 12:02:43 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.1.2", "10.el8", "s390x", "gmp-6.1.2-10.el8.src.rpm", 1475820, "LGPLv3+ or GPLv2+", "Red Hat, Inc.", "", "A GNU arbitrary precision library", "RSA/SHA256, Fri Jun 14 08:58:38 2019, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.2.53", "1.el8", "s390x", "acl-2.2.53-1.el8.src.rpm", 55680, "LGPLv2+", "Red Hat, Inc.", "", "Dynamic library for access control list support", "RSA/SHA256, Fri Dec 14 21:44:35 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.32.1", "35.el8", "s390x", "util-linux-2.32.1-35.el8.src.rpm", 359904, "LGPLv2+", "Red Hat, Inc.", "", "Block device ID library", "RSA/SHA256, Wed Mar  9 12:02:43 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.5", "5.el8", "s390x", "sed-4.5-5.el8.src.rpm", 781054, "GPLv3+", "Red Hat, Inc.", "", "A GNU stream text editor", "RSA/SHA256, Wed Oct  6 10:26:15 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "8.5.0", "10.el8", "s390x", "gcc-8.5.0-10.el8.src.rpm", 2072324, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Red Hat, Inc.", "", "GNU Standard C++ Library", "RSA/SHA256, Fri Jan 28 23:02:30 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.22", "1.el8", "s390x", "p11-kit-0.23.22-1.el8.src.rpm", 1755223, "BSD", "Red Hat, Inc.", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Mon Jan 11 15:36:36 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.9", "3.el8", "s390x", "libunistring-0.9.9-3.el8.src.rpm", 1788492, "GPLv2+ or LGPLv3+", "Red Hat, Inc.", "", "GNU Unicode string library", "RSA/SHA256, Tue Sep 11 05:54:29 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.8.5", "6.el8", "s390x", "libgcrypt-1.8.5-6.el8.src.rpm", 905470, "LGPLv2+", "Red Hat, Inc.", "", "A general-purpose cryptography library", "RSA/SHA256, Mon Jun 28 15:03:57 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.7.11", "1.el8", "s390x", "libcap-ng-0.7.11-1.el8.src.rpm", 51126, "LGPLv2+", "Red Hat, Inc.", "", "An alternate posix capabilities library", "RSA/SHA256, Fri Jun  4 11:01:48 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4-libs", "1.8.3", "3.el8_4", "s390x", "lz4-1.8.3-3.el8_4.src.rpm", 128927, "GPLv2+ and BSD", "Red Hat, Inc.", "", "Libaries for lz4", "RSA/SHA256, Thu Jun  3 09:14:59 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gdbm-libs", "1.18", "1.el8", "s390x", "gdbm-1.18-1.el8.src.rpm", 135944, "GPLv3+", "Red Hat, Inc.", "", "Libraries files for gdbm", "RSA/SHA256, Fri Sep 28 16:37:02 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.13", "3.el8", "s390x", "libtasn1-4.13-3.el8.src.rpm", 175293, "GPLv3+ and LGPLv2+", "Red Hat, Inc.", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Fri Dec 14 23:50:19 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.42", "6.el8", "s390x", "pcre-8.42-6.el8.src.rpm", 327843, "BSD", "Red Hat, Inc.", "", "Perl-compatible regular expression library", "RSA/SHA256, Fri Jun  4 08:09:03 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-libs", "239", "58.el8", "s390x", "systemd-239-58.el8.src.rpm", 4673382, "LGPLv2+ and MIT", "Red Hat, Inc.", "", "systemd libraries", "RSA/SHA256, Thu Feb 10 13:03:17 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2021.2.50", "80.0.el8_4", "noarch", "ca-certificates-2021.2.50-80.0.el8_4.src.rpm", 930318, "Public Domain", "Red Hat, Inc.", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Wed Jun 16 22:47:00 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libusbx", "1.0.23", "4.el8", "s390x", "libusbx-1.0.23-4.el8.src.rpm", 157907, "LGPLv2+", "Red Hat, Inc.", "", "Library for accessing USB devices", "RSA/SHA256, Mon Aug 17 03:33:58 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "2.9", "8.el8", "s390x", "libsemanage-2.9-8.el8.src.rpm", 319800, "LGPLv2+", "Red Hat, Inc.", "", "SELinux binary policy manipulation library", "RSA/SHA256, Wed Feb 23 09:47:58 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libutempter", "1.1.6", "14.el8", "s390x", "libutempter-1.1.6-14.el8.src.rpm", 51557, "LGPLv2+", "Red Hat, Inc.", "", "A privileged helper for utmp/wtmp updates", "RSA/SHA256, Fri Dec 14 23:53:17 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfdisk", "2.32.1", "35.el8", "s390x", "util-linux-2.32.1-35.el8.src.rpm", 454514, "LGPLv2+", "Red Hat, Inc.", "", "Partitioning library for fdisk-like programs.", "RSA/SHA256, Wed Mar  9 12:02:42 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.9", "13.el8_5", "s390x", "gzip-1.9-13.el8_5.src.rpm", 364906, "GPLv3+ and GFDL", "Red Hat, Inc.", "", "The GNU data compression program", "RSA/SHA256, Thu Apr 21 14:29:13 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib-dicts", "2.9.6", "15.el8", "s390x", "cracklib-2.9.6-15.el8.src.rpm", 9815016, "LGPLv2+", "Red Hat, Inc.", "", "The standard CrackLib dictionaries", "RSA/SHA256, Mon Nov 26 16:25:16 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "3.1.6", "1.el8", "s390x", "mpfr-3.1.6-1.el8.src.rpm", 659537, "LGPLv3+ and GPLv3+ and GFDL", "Red Hat, Inc.", "", "A C library for multiple-precision floating-point computations", "RSA/SHA256, Sat Dec 15 00:10:29 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcomps", "0.1.18", "1.el8", "s390x", "libcomps-0.1.18-1.el8.src.rpm", 238804, "GPLv2+", "Red Hat, Inc.", "", "Comps XML file manipulation library", "RSA/SHA256, Mon Nov 22 13:32:42 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "brotli", "1.0.6", "3.el8", "s390x", "brotli-1.0.6-3.el8.src.rpm", 1577676, "MIT", "Red Hat, Inc.", "", "Lossless compression algorithm", "RSA/SHA256, Mon Jan 11 14:53:51 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnl3", "3.5.0", "1.el8", "s390x", "libnl3-3.5.0-1.el8.src.rpm", 1028840, "LGPLv2", "Red Hat, Inc.", "", "Convenience library for kernel netlink sockets", "RSA/SHA256, Mon Dec  2 15:09:57 2019, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsigsegv", "2.11", "5.el8", "s390x", "libsigsegv-2.11-5.el8.src.rpm", 46082, "GPLv2+", "Red Hat, Inc.", "", "Library for handling page faults in user mode", "RSA/SHA256, Fri Dec 14 23:49:12 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.3.0", "5.el8", "s390x", "libverto-0.3.0-5.el8.src.rpm", 27740, "MIT", "Red Hat, Inc.", "", "Main loop abstraction library", "RSA/SHA256, Fri Dec 14 23:53:34 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtirpc", "1.1.4", "6.el8", "s390x", "libtirpc-1.1.4-6.el8.src.rpm", 236366, "SISSL and BSD", "Red Hat, Inc.", "", "Transport Independent RPC Library", "RSA/SHA256, Thu Dec  2 20:17:09 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.1.1k", "6.el8_5", "s390x", "openssl-1.1.1k-6.el8_5.src.rpm", 3364026, "OpenSSL and ASL 2.0", "Red Hat, Inc.", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Thu Mar 24 09:58:56 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "crypto-policies-scripts", "20211116", "1.gitae470d6.el8", "noarch", "crypto-policies-20211116-1.gitae470d6.el8.src.rpm", 189741, "LGPLv2+", "Red Hat, Inc.", "", "Tool to switch between crypto policies", "RSA/SHA256, Mon Nov 22 10:02:04 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "platform-python", "3.6.8", "45.el8", "s390x", "python3-3.6.8-45.el8.src.rpm", 41118, "Python", "Red Hat, Inc.", "", "Internal interpreter of the Python programming language", "RSA/SHA256, Mon Jan 17 17:22:08 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.28", "42.el8_4", "s390x", "libdb-5.3.28-42.el8_4.src.rpm", 1906952, "BSD and LGPLv2 and Sleepycat", "Red Hat, Inc.", "", "The Berkeley DB database library for C", "RSA/SHA256, Thu Sep  9 08:03:41 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.3.1", "16.el8", "s390x", "pam-1.3.1-16.el8.src.rpm", 2613560, "BSD and GPLv2+", "Red Hat, Inc.", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Mon Jan 31 08:31:36 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "util-linux", "2.32.1", "35.el8", "s390x", "util-linux-2.32.1-35.el8.src.rpm", 11563941, "GPLv2 and GPLv2+ and LGPLv2+ and BSD with advertising and Public Domain", "Red Hat, Inc.", "", "A collection of basic system utilities", "RSA/SHA256, Wed Mar  9 12:02:41 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "3.6.16", "4.el8", "s390x", "gnutls-3.6.16-4.el8.src.rpm", 2838279, "GPLv3+ and LGPLv2+", "Red Hat, Inc.", "", "A TLS protocol implementation", "RSA/SHA256, Tue Jun 29 11:32:17 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-glib", "1.4.4", "1.el8", "s390x", "json-glib-1.4.4-1.el8.src.rpm", 537299, "LGPLv2+", "Red Hat, Inc.", "", "Library for JavaScript Object Notation format", "RSA/SHA256, Fri Dec 14 22:54:57 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-iniparse", "0.4", "31.el8", "noarch", "python-iniparse-0.4-31.el8.src.rpm", 108846, "MIT and Python", "Red Hat, Inc.", "", "Python Module for Accessing and Modifying Configuration Data in INI files", "RSA/SHA256, Sat Dec 15 00:48:07 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dbus", "1.2.4", "15.el8", "s390x", "dbus-python-1.2.4-15.el8.src.rpm", 523093, "MIT", "Red Hat, Inc.", "", "D-Bus bindings for python3", "RSA/SHA256, Thu Jun  6 14:05:44 2019, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-gobject-base", "3.28.3", "2.el8", "s390x", "pygobject3-3.28.3-2.el8.src.rpm", 1128653, "LGPLv2+ and MIT", "Red Hat, Inc.", "", "Python 3 bindings for GObject Introspection base package", "RSA/SHA256, Thu Jun 11 21:28:41 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.27", "6.el8_5", "s390x", "cyrus-sasl-2.1.27-6.el8_5.src.rpm", 736746, "BSD with advertising", "Red Hat, Inc.", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Thu Feb 17 22:29:14 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuser", "0.62", "24.el8", "s390x", "libuser-0.62-24.el8.src.rpm", 1968316, "LGPLv2+", "Red Hat, Inc.", "", "A user and group account administration library", "RSA/SHA256, Thu Nov 18 16:19:28 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "usermode", "1.113", "2.el8", "s390x", "usermode-1.113-2.el8.src.rpm", 853880, "GPLv2+", "Red Hat, Inc.", "", "Tools for certain user account management tasks", "RSA/SHA256, Fri Aug 27 11:48:40 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-ethtool", "0.14", "5.el8", "s390x", "python-ethtool-0.14-5.el8.src.rpm", 95616, "GPLv2", "Red Hat, Inc.", "", "Python module to interface with ethtool", "RSA/SHA256, Tue Feb  8 03:06:24 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-chardet", "3.0.4", "7.el8", "noarch", "python-chardet-3.0.4-7.el8.src.rpm", 925538, "LGPLv2", "Red Hat, Inc.", "", "Character encoding auto-detection in Python 3", "RSA/SHA256, Sat Dec 15 00:47:35 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-idna", "2.5", "5.el8", "noarch", "python-idna-2.5-5.el8.src.rpm", 521503, "BSD and Python and Unicode", "Red Hat, Inc.", "", "Internationalized Domain Names in Applications (IDNA)", "RSA/SHA256, Sat Dec 15 00:48:06 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-pysocks", "1.6.8", "3.el8", "noarch", "python-pysocks-1.6.8-3.el8.src.rpm", 77054, "BSD", "Red Hat, Inc.", "", "A Python SOCKS client module", "RSA/SHA256, Sat Dec 15 00:48:50 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-requests", "2.20.0", "2.1.el8_1", "noarch", "python-requests-2.20.0-2.1.el8_1.src.rpm", 377832, "ASL 2.0", "Red Hat, Inc.", "", "HTTP library, written in Python, for human beings", "RSA/SHA256, Thu Oct 17 09:25:38 2019, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-syspurpose", "1.28.29", "3.el8", "s390x", "subscription-manager-1.28.29-3.el8.src.rpm", 165137, "GPLv2", "Red Hat, Inc.", "", "A commandline utility for declaring system syspurpose", "RSA/SHA256, Thu Apr 14 10:32:20 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(8), "device-mapper", "1.02.181", "3.el8", "s390x", "lvm2-2.03.14-3.el8.src.rpm", 360430, "GPLv2", "Red Hat, Inc.", "", "Device mapper utility", "RSA/SHA256, Thu Jan 27 10:59:13 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cryptsetup-libs", "2.3.7", "2.el8", "s390x", "cryptsetup-2.3.7-2.el8.src.rpm", 2149647, "GPLv2+ and LGPLv2+", "Red Hat, Inc.", "", "Cryptsetup shared library", "RSA/SHA256, Fri Feb 25 09:02:27 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.186", "1.el8", "s390x", "elfutils-0.186-1.el8.src.rpm", 749343, "GPLv2+ or LGPLv3+", "Red Hat, Inc.", "", "Libraries to handle compiled objects", "RSA/SHA256, Fri Nov 26 19:32:32 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-daemon", "1.12.8", "18.el8", "s390x", "dbus-1.12.8-18.el8.src.rpm", 569168, "(GPLv2+ or AFL) and GPLv2+", "Red Hat, Inc.", "", "D-BUS message bus", "RSA/SHA256, Tue Dec  7 08:09:23 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd", "239", "58.el8", "s390x", "systemd-239-58.el8.src.rpm", 11171575, "LGPLv2+ and MIT and GPLv2+", "Red Hat, Inc.", "", "System and Service Manager", "RSA/SHA256, Thu Feb 10 13:03:17 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libarchive", "3.3.3", "3.el8_5", "s390x", "libarchive-3.3.3-3.el8_5.src.rpm", 879679, "BSD", "Red Hat, Inc.", "", "A library for handling streaming archive formats", "RSA/SHA256, Wed Jan 12 20:57:54 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ima-evm-utils", "1.3.2", "12.el8", "s390x", "ima-evm-utils-1.3.2-12.el8.src.rpm", 141033, "GPLv2", "Red Hat, Inc.", "", "IMA/EVM support utilities", "RSA/SHA256, Mon Feb 22 12:31:55 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "npth", "1.5", "4.el8", "s390x", "npth-1.5-4.el8.src.rpm", 47245, "LGPLv2+", "Red Hat, Inc.", "", "The New GNU Portable Threads library", "RSA/SHA256, Sat Dec 15 00:16:26 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.13.1", "11.el8", "s390x", "gpgme-1.13.1-11.el8.src.rpm", 1023808, "LGPLv2+ and GPLv3+", "Red Hat, Inc.", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Mon Feb 21 10:32:10 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh-config", "0.9.6", "3.el8", "noarch", "libssh-0.9.6-3.el8.src.rpm", 277, "LGPLv2+", "Red Hat, Inc.", "", "Configuration files for libssh", "RSA/SHA256, Tue Nov  9 15:02:05 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.61.1", "22.el8", "s390x", "curl-7.61.1-22.el8.src.rpm", 617928, "MIT", "Red Hat, Inc.", "", "A library for getting files from web servers", "RSA/SHA256, Wed Oct  6 20:24:06 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-librepo", "1.14.2", "1.el8", "s390x", "librepo-1.14.2-1.el8.src.rpm", 183126, "LGPLv2+", "Red Hat, Inc.", "", "Python 3 bindings for the librepo library", "RSA/SHA256, Mon Nov 22 12:02:35 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.14.3", "23.el8", "s390x", "rpm-4.14.3-23.el8.src.rpm", 2084813, "GPLv2+", "Red Hat, Inc.", "", "The RPM package management system", "RSA/SHA256, Wed Apr  6 13:07:30 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmodulemd", "2.13.0", "1.el8", "s390x", "libmodulemd-2.13.0-1.el8.src.rpm", 691082, "MIT", "Red Hat, Inc.", "", "Module metadata manipulation library", "RSA/SHA256, Wed Aug 18 08:11:16 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdnf", "0.63.0", "8.el8", "s390x", "libdnf-0.63.0-8.el8.src.rpm", 2404251, "LGPLv2+", "Red Hat, Inc.", "", "Library providing simplified C and Python API to libsolv", "RSA/SHA256, Mon Mar 21 09:41:37 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-hawkey", "0.63.0", "8.el8", "s390x", "libdnf-0.63.0-8.el8.src.rpm", 297200, "LGPLv2+", "Red Hat, Inc.", "", "Python 3 bindings for the hawkey library", "RSA/SHA256, Mon Mar 21 09:41:38 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-rpm", "4.14.3", "23.el8", "s390x", "rpm-4.14.3-23.el8.src.rpm", 423965, "GPLv2+", "Red Hat, Inc.", "", "Python 3 bindings for apps which will manipulate RPM packages", "RSA/SHA256, Wed Apr  6 13:07:56 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libreport-filesystem", "2.9.5", "15.el8", "s390x", "libreport-2.9.5-15.el8.src.rpm", 0, "GPLv2+", "Red Hat, Inc.", "", "Filesystem layout for libreport", "RSA/SHA256, Wed Aug 19 11:20:06 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dnf", "4.7.0", "8.el8", "noarch", "dnf-4.7.0-8.el8.src.rpm", 1905194, "GPLv2+", "Red Hat, Inc.", "", "Python 3 interface to DNF", "RSA/SHA256, Mon Mar 21 09:39:04 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dnf-plugins-core", "4.0.21", "11.el8", "noarch", "dnf-plugins-core-4.0.21-11.el8.src.rpm", 825827, "GPLv2+", "Red Hat, Inc.", "", "Core Plugins for DNF", "RSA/SHA256, Mon Mar 21 09:39:39 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subscription-manager", "1.28.29", "3.el8", "s390x", "subscription-manager-1.28.29-3.el8.src.rpm", 4550333, "GPLv2", "Red Hat, Inc.", "", "Tools and libraries for subscription and repository management", "RSA/SHA256, Thu Apr 14 10:32:20 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gdb-gdbserver", "8.2", "18.el8", "s390x", "gdb-8.2-18.el8.src.rpm", 782013, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ and GPLv2+ with exceptions and GPL+ and LGPLv2+ and LGPLv3+ and BSD and Public Domain and GFDL", "Red Hat, Inc.", "", "A standalone server for GDB (the GNU source-level debugger)", "RSA/SHA256, Tue Dec 14 13:35:54 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "8.0.1763", "16.el8_5.13", "s390x", "vim-8.0.1763-16.el8_5.13.src.rpm", 1341404, "Vim and MIT", "Red Hat, Inc.", "", "A minimal version of the VIM editor", "RSA/SHA256, Mon Apr 11 12:19:53 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "langpacks-en", "1.0", "12.el8", "noarch", "langpacks-1.0-12.el8.src.rpm", 400, "GPLv2+", "Red Hat, Inc.", "", "English langpacks meta-package", "RSA/SHA256, Fri Dec 14 22:59:37 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "fd431d51", "4ae0493b", "", "", 0, "pubkey", "", "", "gpg(Red Hat, Inc. (release key 2) <security@redhat.com>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc", "8.5.0", "10.el8", "s390x", "gcc-8.5.0-10.el8.src.rpm", 160544, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Red Hat, Inc.", "", "GCC version 8 shared support library", "RSA/SHA256, Fri Jan 28 23:02:30 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-setuptools-wheel", "39.2.0", "6.el8", "noarch", "python-setuptools-39.2.0-6.el8.src.rpm", 347720, "MIT", "Red Hat, Inc.", "", "The setuptools wheel", "RSA/SHA256, Thu Mar 26 19:12:47 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "subscription-manager-rhsm-certificates", "1.28.29", "3.el8", "s390x", "subscription-manager-1.28.29-3.el8.src.rpm", 9716, "GPLv2", "Red Hat, Inc.", "", "Certificates required to communicate with a Red Hat Unified Entitlement Platform", "RSA/SHA256, Thu Apr 14 10:32:21 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.12.2", "6.el8", "noarch", "setup-2.12.2-6.el8.src.rpm", 724837, "Public Domain", "Red Hat, Inc.", "", "A set of system configuration and setup files", "RSA/SHA256, Thu Apr 23 13:41:49 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "11", "5.el8", "noarch", "basesystem-11-5.el8.src.rpm", 0, "Public Domain", "Red Hat, Inc.", "", "The skeleton package which defines a simple Red Hat Enterprise Linux system", "RSA/SHA256, Fri Dec 14 21:49:21 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "6.1", "9.20180224.el8", "noarch", "ncurses-6.1-9.20180224.el8.src.rpm", 290089, "MIT", "Red Hat, Inc.", "", "Descriptions of common terminals", "RSA/SHA256, Mon May 31 10:28:26 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "2.9", "5.el8", "s390x", "libselinux-2.9-5.el8.src.rpm", 185616, "Public Domain", "Red Hat, Inc.", "", "SELinux library and simple utilities", "RSA/SHA256, Thu Oct 22 11:36:50 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-minimal-langpack", "2.28", "189.1.el8", "s390x", "glibc-2.28-189.1.el8.src.rpm", 0, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Red Hat, Inc.", "", "Minimal language packs for glibc.", "RSA/SHA256, Wed Mar 23 08:55:30 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.28", "189.1.el8", "s390x", "glibc-2.28-189.1.el8.src.rpm", 5258281, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Red Hat, Inc.", "", "The GNU libc libraries", "RSA/SHA256, Wed Mar 23 08:54:37 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "2.9", "3.el8", "s390x", "libsepol-2.9-3.el8.src.rpm", 802488, "LGPLv2+", "Red Hat, Inc.", "", "SELinux binary policy manipulation library", "RSA/SHA256, Tue Aug 24 17:22:07 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.4", "4.el8_6", "s390x", "xz-5.2.4-4.el8_6.src.rpm", 172471, "Public Domain", "Red Hat, Inc.", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Mon Jun  6 10:38:17 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.31", "1.el8", "s390x", "libgpg-error-1.31-1.el8.src.rpm", 902914, "LGPLv2+", "Red Hat, Inc.", "", "Library for error values used by GnuPG components", "RSA/SHA256, Fri Dec 14 23:17:44 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "info", "6.5", "7.el8", "s390x", "texinfo-6.5-7.el8.src.rpm", 413222, "GPLv3+", "Red Hat, Inc.", "", "A stand-alone TTY-based reader for GNU texinfo documentation", "RSA/SHA256, Mon Feb 21 11:32:06 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcrypt", "4.1.1", "6.el8", "s390x", "libxcrypt-4.1.1-6.el8.src.rpm", 185564, "LGPLv2+ and BSD and Public Domain", "Red Hat, Inc.", "", "Extended crypt library for DES, MD5, Blowfish and others", "RSA/SHA256, Mon May  3 12:25:30 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.18", "1.el8", "s390x", "popt-1.18-1.el8.src.rpm", 134450, "MIT", "Red Hat, Inc.", "", "C library for parsing command line parameters", "RSA/SHA256, Mon Jan 18 09:13:30 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.186", "1.el8", "s390x", "elfutils-0.186-1.el8.src.rpm", 1027205, "GPLv2+ or LGPLv3+", "Red Hat, Inc.", "", "Library to read and write ELF files", "RSA/SHA256, Fri Nov 26 19:32:33 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.13.1", "3.el8", "s390x", "json-c-0.13.1-3.el8.src.rpm", 72698, "MIT", "Red Hat, Inc.", "", "JSON implementation in C", "RSA/SHA256, Tue Nov  9 11:52:49 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.1", "23.el8", "s390x", "libffi-3.1-23.el8.src.rpm", 53124, "MIT", "Red Hat, Inc.", "", "A portable foreign function interface library", "RSA/SHA256, Fri Nov 26 15:31:26 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "7.0", "10.el8", "s390x", "readline-7.0-10.el8.src.rpm", 505065, "GPLv3+", "Red Hat, Inc.", "", "A library for editing typed command lines", "RSA/SHA256, Sat Dec 15 00:58:11 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.4.48", "3.el8", "s390x", "attr-2.4.48-3.el8.src.rpm", 26266, "LGPLv2+", "Red Hat, Inc.", "", "Dynamic library for extended attribute support", "RSA/SHA256, Fri Dec 14 21:48:46 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-single", "8.30", "12.el8", "s390x", "coreutils-8.30-12.el8.src.rpm", 1497657, "GPLv3+", "Red Hat, Inc.", "", "coreutils multicall binary", "RSA/SHA256, Tue Jul 13 10:32:12 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.32.1", "35.el8", "s390x", "util-linux-2.32.1-35.el8.src.rpm", 418282, "LGPLv2+", "Red Hat, Inc.", "", "Device mounting library", "RSA/SHA256, Wed Mar  9 12:02:42 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsmartcols", "2.32.1", "35.el8", "s390x", "util-linux-2.32.1-35.el8.src.rpm", 260194, "LGPLv2+", "Red Hat, Inc.", "", "Formatting library for ls-like programs.", "RSA/SHA256, Wed Mar  9 12:02:42 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua-libs", "5.3.4", "12.el8", "s390x", "lua-5.3.4-12.el8.src.rpm", 276232, "MIT", "Red Hat, Inc.", "", "Libraries for lua", "RSA/SHA256, Thu Aug 19 08:51:46 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "chkconfig", "1.19.1", "1.el8", "s390x", "chkconfig-1.19.1-1.el8.src.rpm", 827014, "GPLv2", "Red Hat, Inc.", "", "A system tool for maintaining the /etc/rc*.d hierarchy", "RSA/SHA256, Tue Jul 27 08:52:49 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn2", "2.2.0", "1.el8", "s390x", "libidn2-2.2.0-1.el8.src.rpm", 278258, "(GPLv2+ or LGPLv3+) and GPLv3+", "Red Hat, Inc.", "", "Library to support IDNA2008 internationalized domain names", "RSA/SHA256, Mon Jun 10 12:13:58 2019, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.33", "20.el8", "s390x", "file-5.33-20.el8.src.rpm", 6394213, "BSD", "Red Hat, Inc.", "", "Libraries for applications using libmagic", "RSA/SHA256, Fri May  7 07:30:10 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "3.0.7", "2.el8.2", "s390x", "audit-3.0.7-2.el8.2.src.rpm", 311170, "LGPLv2+", "Red Hat, Inc.", "", "Dynamic library for libaudit", "RSA/SHA256, Tue Apr  5 11:47:59 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.5.1", "3.el8", "s390x", "libassuan-2.5.1-3.el8.src.rpm", 199299, "LGPLv2+ and GPLv3+", "Red Hat, Inc.", "", "GnuPG IPC library", "RSA/SHA256, Fri Dec 14 23:09:07 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.5.10", "9.el8", "s390x", "keyutils-1.5.10-9.el8.src.rpm", 43486, "GPLv2+ and LGPLv2+", "Red Hat, Inc.", "", "Key utilities library", "RSA/SHA256, Fri Jun 18 07:50:02 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.22", "1.el8", "s390x", "p11-kit-0.23.22-1.el8.src.rpm", 479001, "BSD", "Red Hat, Inc.", "", "System trust module from p11-kit", "RSA/SHA256, Mon Jan 11 15:36:36 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "3.1", "6.el8", "s390x", "grep-3.1-6.el8.src.rpm", 843669, "GPLv3+", "Red Hat, Inc.", "", "Pattern matching utilities", "RSA/SHA256, Fri Dec 14 22:34:41 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-libs", "1.12.8", "18.el8", "s390x", "dbus-1.12.8-18.el8.src.rpm", 400512, "(GPLv2+ or AFL) and GPLv2+", "Red Hat, Inc.", "", "Libraries for accessing D-BUS", "RSA/SHA256, Tue Dec  7 08:09:23 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-tools", "1.12.8", "18.el8", "s390x", "dbus-1.12.8-18.el8.src.rpm", 122507, "(GPLv2+ or AFL) and GPLv2+", "Red Hat, Inc.", "", "D-BUS Tools and Utilities", "RSA/SHA256, Tue Dec  7 08:09:23 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gdbm", "1.18", "1.el8", "s390x", "gdbm-1.18-1.el8.src.rpm", 413369, "GPLv3+", "Red Hat, Inc.", "", "A GNU set of database routines which use extensible hashing", "RSA/SHA256, Fri Sep 28 16:37:01 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.6", "16.el8", "s390x", "shadow-utils-4.6-16.el8.src.rpm", 4167677, "BSD and GPLv2+", "Red Hat, Inc.", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Thu Dec  9 12:07:04 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpsl", "0.20.2", "6.el8", "s390x", "libpsl-0.20.2-6.el8.src.rpm", 70372, "MIT", "Red Hat, Inc.", "", "C library for the Publix Suffix List", "RSA/SHA256, Thu Jun  4 20:06:04 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "which", "2.21", "17.el8", "s390x", "which-2.21-17.el8.src.rpm", 86670, "GPLv3", "Red Hat, Inc.", "", "Displays where a particular program in your path is located", "RSA/SHA256, Thu Dec  2 19:37:33 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.6", "15.el8", "s390x", "cracklib-2.9.6-15.el8.src.rpm", 241319, "LGPLv2+", "Red Hat, Inc.", "", "A password-checking library", "RSA/SHA256, Mon Nov 26 16:25:16 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "acl", "2.2.53", "1.el8", "s390x", "acl-2.2.53-1.el8.src.rpm", 209884, "GPLv2+", "Red Hat, Inc.", "", "Access control list utilities", "RSA/SHA256, Fri Dec 14 21:44:34 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nettle", "3.4.1", "7.el8", "s390x", "nettle-3.4.1-7.el8.src.rpm", 591705, "LGPLv3+ or GPLv2+", "Red Hat, Inc.", "", "A low-level cryptographic library", "RSA/SHA256, Thu Jul 15 07:33:55 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libksba", "1.3.5", "7.el8", "s390x", "libksba-1.3.5-7.el8.src.rpm", 351823, "(LGPLv3+ or GPLv2+) and GPLv3+", "Red Hat, Inc.", "", "CMS and X.509 library", "RSA/SHA256, Fri Dec 14 23:24:33 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnghttp2", "1.33.0", "3.el8_2.1", "s390x", "nghttp2-1.33.0-3.el8_2.1.src.rpm", 167740, "MIT", "Red Hat, Inc.", "", "A library implementing the HTTP/2 protocol", "RSA/SHA256, Tue Jun  9 13:51:01 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libseccomp", "2.5.2", "1.el8", "s390x", "libseccomp-2.5.2-1.el8.src.rpm", 177341, "LGPLv2", "Red Hat, Inc.", "", "Enhanced seccomp library", "RSA/SHA256, Tue Nov  9 13:32:17 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "4.2.1", "4.el8", "s390x", "gawk-4.2.1-4.el8.src.rpm", 2768302, "GPLv3+ and GPLv2+ and LGPLv2+ and BSD", "Red Hat, Inc.", "", "The GNU version of the AWK text processing utility", "RSA/SHA256, Sun Feb 27 12:02:20 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnsl2", "1.2.0", "2.20180605git4a062cf.el8", "s390x", "libnsl2-1.2.0-2.20180605git4a062cf.el8.src.rpm", 152210, "BSD and LGPLv2+", "Red Hat, Inc.", "", "Public client interface library for NIS(YP) and NIS+", "RSA/SHA256, Fri Dec 14 23:32:11 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.18.2", "14.el8", "s390x", "krb5-1.18.2-14.el8.src.rpm", 2291939, "MIT", "Red Hat, Inc.", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Wed Aug 25 17:32:16 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "crypto-policies", "20211116", "1.gitae470d6.el8", "noarch", "crypto-policies-20211116-1.gitae470d6.el8.src.rpm", 73257, "LGPLv2+", "Red Hat, Inc.", "", "System-wide crypto policies", "RSA/SHA256, Mon Nov 22 10:02:04 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "platform-python-setuptools", "39.2.0", "6.el8", "noarch", "python-setuptools-39.2.0-6.el8.src.rpm", 2930503, "MIT", "Red Hat, Inc.", "", "Easily build and distribute Python 3 packages", "RSA/SHA256, Thu Mar 26 19:12:47 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libs", "3.6.8", "45.el8", "s390x", "python3-3.6.8-45.el8.src.rpm", 32457398, "Python", "Red Hat, Inc.", "", "Python runtime libraries", "RSA/SHA256, Mon Jan 17 17:22:08 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.4.4", "3.el8", "s390x", "libpwquality-1.4.4-3.el8.src.rpm", 399312, "BSD or GPLv2+", "Red Hat, Inc.", "", "A library for password generation and password quality checking", "RSA/SHA256, Mon Feb 22 16:21:02 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-six", "1.11.0", "8.el8", "noarch", "python-six-1.11.0-8.el8.src.rpm", 100282, "MIT", "Red Hat, Inc.", "", "Python 2 and 3 compatibility utilities", "RSA/SHA256, Sat Dec 15 00:49:15 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "python3-dateutil", "2.6.1", "6.el8", "noarch", "python-dateutil-2.6.1-6.el8.src.rpm", 596677, "BSD", "Red Hat, Inc.", "", "Powerful extensions to the standard datetime module", "RSA/SHA256, Sat Dec 15 00:47:46 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.56.4", "158.el8", "s390x", "glib2-2.56.4-158.el8.src.rpm", 12460592, "LGPLv2+", "Red Hat, Inc.", "", "A library of handy utility functions", "RSA/SHA256, Mon Dec  6 08:02:02 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "librhsm", "0.0.3", "4.el8", "s390x", "librhsm-0.0.3-4.el8.src.rpm", 75824, "LGPLv2+", "Red Hat, Inc.", "", "Red Hat Subscription Manager library", "RSA/SHA256, Thu Jan  7 07:55:17 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dbus-glib", "0.110", "2.el8", "s390x", "dbus-glib-0.110-2.el8.src.rpm", 379662, "AFL and GPLv2+", "Red Hat, Inc.", "", "GLib bindings for D-Bus", "RSA/SHA256, Fri Dec 14 21:59:00 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gobject-introspection", "1.56.1", "1.el8", "s390x", "gobject-introspection-1.56.1-1.el8.src.rpm", 898391, "GPLv2+, LGPLv2+, MIT", "Red Hat, Inc.", "", "Introspection system for GObject-based libraries", "RSA/SHA256, Fri Dec 14 22:33:36 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "virt-what", "1.18", "13.el8", "s390x", "virt-what-1.18-13.el8.src.rpm", 47599, "GPLv2+", "Red Hat, Inc.", "", "Detect if we are running in a virtual machine", "RSA/SHA256, Wed Jan 12 12:01:12 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.46", "18.el8", "s390x", "openldap-2.4.46-18.el8.src.rpm", 1042339, "OpenLDAP", "Red Hat, Inc.", "", "LDAP support libraries", "RSA/SHA256, Mon Aug  9 14:46:39 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "passwd", "0.80", "4.el8", "s390x", "passwd-0.80-4.el8.src.rpm", 441893, "BSD or GPL+", "Red Hat, Inc.", "", "An utility for setting or changing passwords using PAM", "RSA/SHA256, Tue Feb 15 14:32:21 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb-utils", "5.3.28", "42.el8_4", "s390x", "libdb-5.3.28-42.el8_4.src.rpm", 393695, "BSD and LGPLv2 and Sleepycat", "Red Hat, Inc.", "", "Command line tools for managing Berkeley DB databases", "RSA/SHA256, Thu Sep  9 08:03:41 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libcomps", "0.1.18", "1.el8", "s390x", "libcomps-0.1.18-1.el8.src.rpm", 151158, "GPLv2+", "Red Hat, Inc.", "", "Python 3 bindings for libcomps library", "RSA/SHA256, Mon Nov 22 13:32:43 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-decorator", "4.2.1", "2.el8", "noarch", "python-decorator-4.2.1-2.el8.src.rpm", 47871, "BSD", "Red Hat, Inc.", "", "Module to simplify usage of decorators in python3", "RSA/SHA256, Sat Dec 15 00:47:48 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-inotify", "0.9.6", "13.el8", "noarch", "python-inotify-0.9.6-13.el8.src.rpm", 248598, "MIT", "Red Hat, Inc.", "", "Monitor filesystem events with Python under Linux", "RSA/SHA256, Tue Nov 27 12:55:34 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-urllib3", "1.24.2", "5.el8", "noarch", "python-urllib3-1.24.2-5.el8.src.rpm", 620045, "MIT", "Red Hat, Inc.", "", "Python3 HTTP library with thread-safe connection pooling and file post", "RSA/SHA256, Tue Nov 10 09:15:18 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-cloud-what", "1.28.29", "3.el8", "s390x", "subscription-manager-1.28.29-3.el8.src.rpm", 71971, "GPLv2", "Red Hat, Inc.", "", "Python package for detection of public cloud provider", "RSA/SHA256, Thu Apr 14 10:32:22 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "kmod-libs", "25", "19.el8", "s390x", "kmod-25-19.el8.src.rpm", 134664, "LGPLv2+", "Red Hat, Inc.", "", "Libraries to handle kernel module loading and unloading", "RSA/SHA256, Tue Nov 30 12:02:09 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(8), "device-mapper-libs", "1.02.181", "3.el8", "s390x", "lvm2-2.03.14-3.el8.src.rpm", 435871, "LGPLv2", "Red Hat, Inc.", "", "Device-mapper shared library", "RSA/SHA256, Thu Jan 27 10:59:13 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.186", "1.el8", "noarch", "elfutils-0.186-1.el8.src.rpm", 1810, "GPLv2+ or LGPLv3+", "Red Hat, Inc.", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Fri Nov 26 19:32:19 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus-common", "1.12.8", "18.el8", "noarch", "dbus-1.12.8-18.el8.src.rpm", 11131, "(GPLv2+ or AFL) and GPLv2+", "Red Hat, Inc.", "", "D-BUS message bus configuration", "RSA/SHA256, Tue Dec  7 08:09:11 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "systemd-pam", "239", "58.el8", "s390x", "systemd-239-58.el8.src.rpm", 937656, "LGPLv2+ and MIT and GPLv2+", "Red Hat, Inc.", "", "systemd PAM module", "RSA/SHA256, Thu Feb 10 13:03:17 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "dbus", "1.12.8", "18.el8", "s390x", "dbus-1.12.8-18.el8.src.rpm", 0, "(GPLv2+ or AFL) and GPLv2+", "Red Hat, Inc.", "", "D-BUS message bus", "RSA/SHA256, Tue Dec  7 08:09:22 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tpm2-tss", "2.3.2", "4.el8", "s390x", "tpm2-tss-2.3.2-4.el8.src.rpm", 1145142, "BSD", "Red Hat, Inc.", "", "TPM2.0 Software Stack", "RSA/SHA256, Fri May 14 21:41:47 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libyaml", "0.1.7", "5.el8", "s390x", "libyaml-0.1.7-5.el8.src.rpm", 127126, "MIT", "Red Hat, Inc.", "", "YAML 1.1 parser and emitter written in C", "RSA/SHA256, Fri Dec 14 23:55:57 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.2.20", "2.el8", "s390x", "gnupg2-2.2.20-2.el8.src.rpm", 10294211, "GPLv3+", "Red Hat, Inc.", "", "Utility for secure communication and data storage", "RSA/SHA256, Tue May  5 07:24:29 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-gpg", "1.13.1", "11.el8", "s390x", "gpgme-1.13.1-11.el8.src.rpm", 1436090, "LGPLv2+ and GPLv3+", "Red Hat, Inc.", "", "gpgme bindings for Python 3", "RSA/SHA256, Mon Feb 21 10:32:12 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh", "0.9.6", "3.el8", "s390x", "libssh-0.9.6-3.el8.src.rpm", 529471, "LGPLv2+", "Red Hat, Inc.", "", "A library implementing the SSH protocol", "RSA/SHA256, Tue Nov  9 15:02:08 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "librepo", "1.14.2", "1.el8", "s390x", "librepo-1.14.2-1.el8.src.rpm", 212388, "LGPLv2+", "Red Hat, Inc.", "", "Repodata downloading library", "RSA/SHA256, Mon Nov 22 12:02:35 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.61.1", "22.el8", "s390x", "curl-7.61.1-22.el8.src.rpm", 704757, "MIT", "Red Hat, Inc.", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Wed Oct  6 20:24:06 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.14.3", "23.el8", "s390x", "rpm-4.14.3-23.el8.src.rpm", 783184, "GPLv2+ and LGPLv2+ with exceptions", "Red Hat, Inc.", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Wed Apr  6 13:07:55 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsolv", "0.7.20", "1.el8", "s390x", "libsolv-0.7.20-1.el8.src.rpm", 875691, "BSD", "Red Hat, Inc.", "", "Package dependency solver", "RSA/SHA256, Wed Nov 24 12:32:26 2021, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libdnf", "0.63.0", "8.el8", "s390x", "libdnf-0.63.0-8.el8.src.rpm", 4025722, "LGPLv2+", "Red Hat, Inc.", "", "Python 3 bindings for the libdnf library.", "RSA/SHA256, Mon Mar 21 09:41:38 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.14.3", "23.el8", "s390x", "rpm-4.14.3-23.el8.src.rpm", 223408, "GPLv2+ and LGPLv2+ with exceptions", "Red Hat, Inc.", "", "Libraries for building and signing RPM packages", "RSA/SHA256, Wed Apr  6 13:07:55 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-subscription-manager-rhsm", "1.28.29", "3.el8", "s390x", "subscription-manager-1.28.29-3.el8.src.rpm", 424353, "GPLv2", "Red Hat, Inc.", "", "A Python library to communicate with a Red Hat Unified Entitlement Platform", "RSA/SHA256, Thu Apr 14 10:32:21 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf-data", "4.7.0", "8.el8", "noarch", "dnf-4.7.0-8.el8.src.rpm", 38535, "GPLv2+", "Red Hat, Inc.", "", "Common data and configuration files for DNF", "RSA/SHA256, Mon Mar 21 09:39:03 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf", "4.7.0", "8.el8", "noarch", "dnf-4.7.0-8.el8.src.rpm", 2086072, "GPLv2+", "Red Hat, Inc.", "", "Package manager", "RSA/SHA256, Mon Mar 21 09:39:03 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf-plugin-subscription-manager", "1.28.29", "3.el8", "s390x", "subscription-manager-1.28.29-3.el8.src.rpm", 93730, "GPLv2", "Red Hat, Inc.", "", "Subscription Manager plugins for DNF", "RSA/SHA256, Thu Apr 14 10:32:21 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "4.7.0", "8.el8", "noarch", "dnf-4.7.0-8.el8.src.rpm", 76588, "GPLv2+", "Red Hat, Inc.", "", "Package manager", "RSA/SHA256, Mon Mar 21 09:39:04 2022, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.30", "5.el8", "s390x", "tar-1.30-5.el8.src.rpm", 2937393, "GPLv3+", "Red Hat, Inc.", "", "A GNU file archiving program", "RSA/SHA256, Wed Jun 24 07:55:53 2020, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "findutils", "4.6.0", "20.el8", "s390x", "findutils-4.6.0-20.el8.src.rpm", 1838089, "GPLv3+", "Red Hat, Inc.", "", "The GNU versions of find utilities (find and xargs)", "RSA/SHA256, Mon Nov  5 14:36:20 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "22.el8", "noarch", "rootfiles-8.1-22.el8.src.rpm", 599, "Public Domain", "Red Hat, Inc.", "", "The basic required files for the root user's directory", "RSA/SHA256, Sat Dec 15 00:58:44 2018, Key ID 199e2f91fd431d51", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "d4082792", "5b32db75", "", "", 0, "pubkey", "", "", "gpg(Red Hat, Inc. (auxiliary key) <security@redhat.com>)", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it registry.suse.com/bci/minimal:15.3 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\"\, \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/(none)/0/g"
	SLE15WithNDB = []*PackageInfo{
		{intRef(), "system-user-root", "20190513", "3.3.1", "noarch", "system-user-root-20190513-3.3.1.src.rpm", 186, "MIT", "SUSE LLC <https://www.suse.com/>", "", "System user and group root", "RSA/SHA256, Mon May 20 13:48:14 2019, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "15.0", "11.3.2", "x86_64", "filesystem-15.0-11.3.2.src.rpm", 535, "MIT", "SUSE LLC <https://www.suse.com/>", "", "Basic Directory Layout", "RSA/SHA256, Wed Mar  3 11:52:34 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.31", "9.3.2", "x86_64", "glibc-2.31-9.3.2.src.rpm", 6183407, "LGPL-2.1-or-later AND LGPL-2.1-or-later WITH GCC-exception-2.0 AND GPL-2.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "Standard Shared Libraries (from the GNU C Library)", "RSA/SHA256, Tue Sep 21 17:14:53 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpcre1", "8.45", "20.10.1", "x86_64", "pcre-8.45-20.10.1.src.rpm", 938295, "BSD-3-Clause", "SUSE LLC <https://www.suse.com/>", "", "A library for Perl-compatible regular expressions", "RSA/SHA256, Wed Oct 20 07:15:25 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgmp10", "6.1.2", "4.6.1", "x86_64", "gmp-6.1.2-4.6.1.src.rpm", 711445, "LGPL-3.0-or-later OR GPL-2.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "Shared library for the GNU MP Library", "RSA/SHA256, Fri Jan 29 08:30:59 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcc_s1", "11.2.1+git610", "1.3.9", "x86_64", "gcc11-11.2.1+git610-1.3.9.src.rpm", 101024, "GPL-3.0-or-later WITH GCC-exception-3.1", "SUSE LLC <https://www.suse.com/>", "", "C compiler runtime library", "RSA/SHA256, Fri Oct 29 17:04:45 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap2", "2.26", "4.6.1", "x86_64", "libcap-2.26-4.6.1.src.rpm", 39224, "BSD-3-Clause or GPL-2.0", "SUSE LLC <https://www.suse.com/>", "", "Library for Capabilities (linux-privs) Support", "RSA/SHA256, Tue Apr 20 09:21:25 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++6", "11.2.1+git610", "1.3.9", "x86_64", "gcc11-11.2.1+git610-1.3.9.src.rpm", 2161776, "GPL-3.0-or-later WITH GCC-exception-3.1", "SUSE LLC <https://www.suse.com/>", "", "The standard C++ shared library", "RSA/SHA256, Fri Oct 29 17:04:49 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libncurses6", "6.1", "5.9.1", "x86_64", "ncurses-6.1-5.9.1.src.rpm", 1116008, "MIT", "SUSE LLC <https://www.suse.com/>", "", "Terminal control library", "RSA/SHA256, Thu Oct 14 10:16:39 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "terminfo-base", "6.1", "5.9.1", "x86_64", "ncurses-6.1-5.9.1.src.rpm", 1179602, "MIT", "SUSE LLC <https://www.suse.com/>", "", "A terminal descriptions database", "RSA/SHA256, Thu Oct 14 10:16:40 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr1", "2.4.47", "2.19", "x86_64", "attr-2.4.47-2.19.src.rpm", 46233, "GPL-2.0-or-later AND LGPL-2.1-or-later", "SUSE LLC <https://www.suse.com/>", "", "A dynamic library for filesystem extended attribute support", "RSA/SHA256, Fri May 25 17:06:56 2018, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux1", "3.0", "1.31", "x86_64", "libselinux-3.0-1.31.src.rpm", 159424, "SUSE-Public-Domain", "SUSE LLC <https://www.suse.com/>", "", "SELinux runtime library", "RSA/SHA256, Sat Jun  6 00:48:51 2020, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libreadline7", "7.0", "19.6.1", "x86_64", "bash-4.4-19.6.1.src.rpm", 396195, "GPL-3.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "The Readline Library", "RSA/SHA256, Fri Aug  6 15:46:05 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "4.4", "19.6.1", "x86_64", "bash-4.4-19.6.1.src.rpm", 1114706, "GPL-3.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "The GNU Bourne-Again Shell", "RSA/SHA256, Fri Aug  6 15:46:04 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl1", "2.2.52", "4.3.1", "x86_64", "acl-2.2.52-4.3.1.src.rpm", 35424, "GPL-2.0+ and LGPL-2.1+", "SUSE LLC <https://www.suse.com/>", "", "A dynamic library for accessing POSIX Access Control Lists", "RSA/SHA256, Tue Oct 23 13:58:06 2018, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.32", "3.2.1", "x86_64", "coreutils-8.32-3.2.1.src.rpm", 6488992, "GPL-3.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "GNU Core Utilities", "RSA/SHA256, Fri Sep 24 13:58:14 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sles-release", "15.3", "55.4.1", "x86_64", "sles-release-15.3-55.4.1.src.rpm", 342491, "MIT", "SUSE LLC <https://www.suse.com/>", "", "SUSE Linux Enterprise Server 15 SP3", "RSA/SHA256, Thu Jul  8 17:03:11 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates-mozilla-prebuilt", "2.44", "21.1", "noarch", "ca-certificates-mozilla-prebuilt-2.44-21.1.src.rpm", 836576, "MPL-2.0", "SUSE LLC <https://www.suse.com/>", "", "Pre-built CA certificates for OpenSSL", "RSA/SHA256, Thu Oct  7 14:44:21 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error0", "1.29", "1.8", "x86_64", "libgpg-error-1.29-1.8.src.rpm", 565983, "GPL-2.0-or-later AND LGPL-2.1-or-later", "SUSE LLC <https://www.suse.com/>", "", "Library That Defines Common Error Values for All GnuPG Components", "RSA/SHA256, Fri May 25 18:12:44 2018, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpopt0", "1.16", "3.22", "x86_64", "popt-1.16-3.22.src.rpm", 124686, "MIT", "SUSE LLC <https://www.suse.com/>", "", "A C library for parsing command line parameters", "RSA/SHA256, Fri May 25 17:07:25 2018, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-magic", "5.32", "7.14.1", "noarch", "file-5.32-7.14.1.src.rpm", 5916442, "BSD-2-Clause", "SUSE LLC <https://www.suse.com/>", "", "Database for libmagic to help identify files", "RSA/SHA256, Thu Sep  9 14:04:27 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libbz2-1", "1.0.6", "5.11.1", "x86_64", "bzip2-1.0.6-5.11.1.src.rpm", 120168, "BSD-3-Clause", "SUSE LLC <https://www.suse.com/>", "", "The bzip2 runtime library", "RSA/SHA256, Tue May  4 17:23:49 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "liblua5_3-5", "5.3.6", "3.6.1", "x86_64", "lua53-5.3.6-3.6.1.src.rpm", 237296, "MIT", "SUSE LLC <https://www.suse.com/>", "", "The Lua integration library", "RSA/SHA256, Fri Jun 11 07:27:38 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "liblzma5", "5.2.3", "4.3.1", "x86_64", "xz-5.2.3-4.3.1.src.rpm", 235576, "SUSE-Public-Domain", "SUSE LLC <https://www.suse.com/>", "", "Lempel–Ziv–Markov chain algorithm compression library", "RSA/SHA256, Fri Jun 21 09:19:03 2019, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libz1", "1.2.11", "3.21.1", "x86_64", "zlib-1.2.11-3.21.1.src.rpm", 110685, "Zlib", "SUSE LLC <https://www.suse.com/>", "", "Library implementing the DEFLATE compression algorithm", "RSA/SHA256, Mon Mar  8 14:03:39 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libzstd1", "1.4.4", "1.6.1", "x86_64", "zstd-1.4.4-1.6.1.src.rpm", 682141, "BSD-3-Clause AND GPL-2.0-only", "SUSE LLC <https://www.suse.com/>", "", "Zstd compression library", "RSA/SHA256, Fri Mar 12 16:23:09 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmagic1", "5.32", "7.14.1", "x86_64", "file-5.32-7.14.1.src.rpm", 138472, "BSD-2-Clause", "SUSE LLC <https://www.suse.com/>", "", "Library for heuristic file type identification", "RSA/SHA256, Thu Sep  9 14:04:27 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdw1", "0.168", "4.5.3", "x86_64", "elfutils-0.168-4.5.3.src.rpm", 294456, "SUSE-GPL-2.0-with-OSI-exception", "SUSE LLC <https://www.suse.com/>", "", "Library to access DWARF debugging information", "RSA/SHA256, Tue Jun  4 14:13:28 2019, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libebl-plugins", "0.168", "4.5.3", "x86_64", "elfutils-0.168-4.5.3.src.rpm", 372800, "SUSE-GPL-2.0-with-OSI-exception", "SUSE LLC <https://www.suse.com/>", "", "Architecture backends for libebl", "RSA/SHA256, Tue Jun  4 14:13:28 2019, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libelf1", "0.168", "4.5.3", "x86_64", "elfutils-0.168-4.5.3.src.rpm", 96880, "SUSE-GPL-2.0-with-OSI-exception", "SUSE LLC <https://www.suse.com/>", "", "Library to read and write ELF files", "RSA/SHA256, Tue Jun  4 14:13:28 2019, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcrypt1", "4.4.15", "2.51", "x86_64", "libxcrypt-4.4.15-2.51.src.rpm", 265241, "LGPL-2.1-or-later AND BSD-2-Clause AND BSD-3-Clause AND SUSE-Public-Domain", "SUSE LLC <https://www.suse.com/>", "", "Extended crypt library for DES, MD5, Blowfish and others", "RSA/SHA256, Thu May  6 15:32:02 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "perl-base", "5.26.1", "15.87", "x86_64", "perl-5.26.1-15.87.src.rpm", 4299811, "Artistic-1.0 or GPL-2.0+", "SUSE LLC <https://www.suse.com/>", "", "The Perl interpreter", "RSA/SHA256, Thu May  6 16:47:48 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt20", "1.8.2", "8.39.1", "x86_64", "libgcrypt-1.8.2-8.39.1.src.rpm", 1198761, "GPL-2.0+ AND LGPL-2.1+", "SUSE LLC <https://www.suse.com/>", "", "The GNU Crypto Library", "RSA/SHA256, Tue Jun 15 07:04:32 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-config-SUSE", "1", "5.6.1", "noarch", "rpm-config-SUSE-1-5.6.1.src.rpm", 38001, "GPL-2.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "SUSE specific RPM configuration files", "RSA/SHA256, Thu Nov 18 06:59:33 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-ndb", "4.14.3", "40.1", "x86_64", "rpm-ndb-4.14.3-40.1.src.rpm", 3132579, "GPL-2.0-or-later", "SUSE LLC <https://www.suse.com/>", "", "The RPM Package Manager, ndb only version", "RSA/SHA256, Tue Oct 12 12:00:13 2021, Key ID 70af9e8139db7c82", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it fedora:35 bash
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\", \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"%{MODULARITYLABEL}\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil\},\n" | sed "s/^{(none)/{intRef()/g" | sed "s/^{\([[:digit:]]\+\)/{intRef(\1)/g" | sed "s/(none)//g"
	Fedora35WithSQLite3 = []*PackageInfo{
		{intRef(), "libgcc", "11.2.1", "1.fc35", "x86_64", "gcc-11.2.1-1.fc35.src.rpm", 194980, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Fedora Project", "", "GCC version 11 shared support library", "RSA/SHA256, Thu Jul 29 07:41:04 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "crypto-policies", "20210819", "1.gitd0fdcfb.fc35", "noarch", "crypto-policies-20210819-1.gitd0fdcfb.fc35.src.rpm", 86107, "LGPLv2+", "Fedora Project", "", "System-wide crypto policies", "RSA/SHA256, Thu Aug 19 18:23:42 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2021e", "1.fc35", "noarch", "tzdata-2021e-1.fc35.src.rpm", 1800709, "Public Domain", "Fedora Project", "", "Timezone data", "RSA/SHA256, Thu Oct 28 22:21:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-release-identity-container", "35", "35", "noarch", "fedora-release-35-35.src.rpm", 1512, "MIT", "Fedora Project", "", "Package providing the identity for Fedora Container Base Image", "RSA/SHA256, Sat Nov 20 12:58:51 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-setuptools-wheel", "57.4.0", "1.fc35", "noarch", "python-setuptools-57.4.0-1.fc35.src.rpm", 596568, "MIT and (BSD or ASL 2.0)", "Fedora Project", "", "The setuptools wheel", "RSA/SHA256, Tue Aug  3 14:19:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "publicsuffix-list-dafsa", "20210518", "2.fc35", "noarch", "publicsuffix-list-20210518-2.fc35.src.rpm", 68815, "MPLv2.0", "Fedora Project", "", "Cross-vendor public domain suffix database in DAFSA form", "RSA/SHA256, Mon Jul 26 12:01:38 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre2-syntax", "10.37", "4.fc35", "noarch", "pcre2-10.37-4.fc35.src.rpm", 222822, "BSD", "Fedora Project", "", "Documentation for PCRE2 regular expressions", "RSA/SHA256, Tue Jul 27 11:12:27 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "6.2", "8.20210508.fc35", "noarch", "ncurses-6.2-8.20210508.fc35.src.rpm", 307293, "MIT", "Fedora Project", "", "Descriptions of common terminals", "RSA/SHA256, Mon Jul 26 07:18:39 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh-config", "0.9.6", "1.fc35", "noarch", "libssh-0.9.6-1.fc35.src.rpm", 277, "LGPLv2+", "Fedora Project", "", "Configuration files for libssh", "RSA/SHA256, Tue Sep 21 17:02:36 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libreport-filesystem", "2.15.2", "6.fc35", "noarch", "libreport-2.15.2-6.fc35.src.rpm", 0, "GPLv2+", "Fedora Project", "", "Filesystem layout for libreport", "RSA/SHA256, Mon Jul 26 03:56:01 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf-data", "4.9.0", "1.fc35", "noarch", "dnf-4.9.0-1.fc35.src.rpm", 38568, "GPLv2+", "Fedora Project", "", "Common data and configuration files for DNF", "RSA/SHA256, Thu Sep 23 12:32:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-gpg-keys", "35", "1", "noarch", "fedora-repos-35-1.src.rpm", 118311, "MIT", "Fedora Project", "", "Fedora RPM keys", "RSA/SHA256, Mon Oct 11 17:33:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-release-container", "35", "35", "noarch", "fedora-release-35-35.src.rpm", 0, "MIT", "Fedora Project", "", "Base package for Fedora container specific default configurations", "RSA/SHA256, Sat Nov 20 12:58:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-repos", "35", "1", "noarch", "fedora-repos-35-1.src.rpm", 4597, "MIT", "Fedora Project", "", "Fedora package repositories", "RSA/SHA256, Mon Oct 11 17:33:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-release-common", "35", "35", "noarch", "fedora-release-35-35.src.rpm", 17557, "MIT", "Fedora Project", "", "Fedora release files", "RSA/SHA256, Sat Nov 20 12:58:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.13.9.1", "2.fc35", "noarch", "setup-2.13.9.1-2.fc35.src.rpm", 736053, "Public Domain", "Fedora Project", "", "A set of system configuration and setup files", "RSA/SHA256, Mon Jul 26 17:30:47 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.14", "7.fc35", "x86_64", "filesystem-3.14-7.fc35.src.rpm", 106, "Public Domain", "Fedora Project", "", "The basic directory layout for a Linux system", "RSA/SHA256, Sun Jul 25 18:44:58 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "11", "12.fc35", "noarch", "basesystem-11-12.fc35.src.rpm", 0, "Public Domain", "Fedora Project", "", "The skeleton package which defines a simple Fedora system", "RSA/SHA256, Sun Jul 25 03:58:03 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "5.1.8", "2.fc35", "x86_64", "bash-5.1.8-2.fc35.src.rpm", 7739604, "GPLv3+", "Fedora Project", "", "The GNU Bourne Again shell", "RSA/SHA256, Sun Jul 25 03:58:08 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "6.2", "8.20210508.fc35", "x86_64", "ncurses-6.2-8.20210508.fc35.src.rpm", 996375, "MIT", "Fedora Project", "", "Ncurses libraries", "RSA/SHA256, Mon Jul 26 07:19:01 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.34", "8.fc35", "x86_64", "glibc-2.34-8.fc35.src.rpm", 1089462, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Fedora Project", "", "Common binaries and locale data for glibc", "RSA/SHA256, Wed Nov  3 12:09:17 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-minimal-langpack", "2.34", "8.fc35", "x86_64", "glibc-2.34-8.fc35.src.rpm", 0, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Fedora Project", "", "Minimal language packs for glibc.", "RSA/SHA256, Wed Nov  3 12:09:21 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.34", "8.fc35", "x86_64", "glibc-2.34-8.fc35.src.rpm", 6237291, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Fedora Project", "", "The GNU libc libraries", "RSA/SHA256, Wed Nov  3 12:08:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.11", "30.fc35", "x86_64", "zlib-1.2.11-30.fc35.src.rpm", 203449, "zlib and Boost", "Fedora Project", "", "Compression and decompression library", "RSA/SHA256, Thu Jul 29 10:39:56 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.8", "9.fc35", "x86_64", "bzip2-1.0.8-9.fc35.src.rpm", 78660, "BSD", "Fedora Project", "", "Libraries for applications using bzip2", "RSA/SHA256, Sun Jul 25 04:31:34 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.5", "7.fc35", "x86_64", "xz-5.2.5-7.fc35.src.rpm", 181437, "Public Domain", "Fedora Project", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Tue Jul 27 00:02:26 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libzstd", "1.5.0", "2.fc35", "x86_64", "zstd-1.5.0-2.fc35.src.rpm", 1028163, "BSD and GPLv2", "Fedora Project", "", "Zstd shared library", "RSA/SHA256, Tue Jul 27 00:18:51 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite-libs", "3.36.0", "3.fc35", "x86_64", "sqlite-3.36.0-3.fc35.src.rpm", 1334505, "Public Domain", "Fedora Project", "", "Shared library for the sqlite3 embeddable SQL database engine.", "RSA/SHA256, Mon Jul 26 19:04:38 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.2.0", "7.fc35", "x86_64", "gmp-6.2.0-7.fc35.src.rpm", 809478, "LGPLv3+ or GPLv2+", "Fedora Project", "", "GNU arbitrary precision library", "RSA/SHA256, Sun Jul 25 21:26:14 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.48", "3.fc35", "x86_64", "libcap-2.48-3.fc35.src.rpm", 180511, "BSD or GPLv2", "Fedora Project", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Mon Jul 26 02:26:54 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.18", "6.fc35", "x86_64", "popt-1.18-6.fc35.src.rpm", 130256, "MIT", "Fedora Project", "", "C library for parsing command line parameters", "RSA/SHA256, Mon Jul 26 11:42:54 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.43", "1.fc35", "x86_64", "libgpg-error-1.43-1.fc35.src.rpm", 851181, "LGPLv2+", "Fedora Project", "", "Library for error values used by GnuPG components", "RSA/SHA256, Thu Nov  4 14:52:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.12", "6.fc35", "x86_64", "libxml2-2.9.12-6.fc35.src.rpm", 1923894, "MIT", "Fedora Project", "", "Library providing XML and HTML support", "RSA/SHA256, Mon Jul 26 04:38:49 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.46.3", "1.fc35", "x86_64", "e2fsprogs-1.46.3-1.fc35.src.rpm", 68441, "MIT", "Fedora Project", "", "Common error description library", "RSA/SHA256, Fri Jul 30 12:54:26 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "11.2.1", "1.fc35", "x86_64", "gcc-11.2.1-1.fc35.src.rpm", 2476520, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Fedora Project", "", "GNU Standard C++ Library", "RSA/SHA256, Thu Jul 29 07:40:59 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcrypt", "4.4.26", "4.fc35", "x86_64", "libxcrypt-4.4.26-4.fc35.src.rpm", 275090, "LGPLv2+ and BSD and Public Domain", "Fedora Project", "", "Extended crypt library for descrypt, md5crypt, bcrypt, and others", "RSA/SHA256, Tue Sep 21 21:45:46 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua-libs", "5.4.3", "2.fc35", "x86_64", "lua-5.4.3-2.fc35.src.rpm", 555606, "MIT", "Fedora Project", "", "Libraries for lua", "RSA/SHA256, Mon Jul 26 05:14:46 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.185", "5.fc35", "x86_64", "elfutils-0.185-5.fc35.src.rpm", 992174, "GPLv2+ or LGPLv3+", "Fedora Project", "", "Library to read and write ELF files", "RSA/SHA256, Fri Aug  6 14:19:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.40", "9.fc35", "x86_64", "file-5.40-9.fc35.src.rpm", 8529778, "BSD", "Fedora Project", "", "Libraries for applications using libmagic", "RSA/SHA256, Sun Jul 25 18:44:19 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.5.1", "3.fc35", "x86_64", "attr-2.5.1-3.fc35.src.rpm", 29341, "LGPLv2+", "Fedora Project", "", "Dynamic library for extended attribute support", "RSA/SHA256, Sun Jul 25 03:41:40 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.3.1", "2.fc35", "x86_64", "acl-2.3.1-2.fc35.src.rpm", 41090, "LGPLv2+", "Fedora Project", "", "Dynamic library for access control list support", "RSA/SHA256, Sun Jul 25 01:39:14 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.1", "29.fc35", "x86_64", "libffi-3.1-29.fc35.src.rpm", 56872, "MIT", "Fedora Project", "", "A portable foreign function interface library", "RSA/SHA256, Thu Aug 12 22:46:18 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.22", "4.fc35", "x86_64", "p11-kit-0.23.22-4.fc35.src.rpm", 1659536, "BSD", "Fedora Project", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Mon Jul 26 09:16:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.10", "14.fc35", "x86_64", "libunistring-0.9.10-14.fc35.src.rpm", 1642923, "GPLv2+ or LGPLv3+", "Fedora Project", "", "GNU Unicode string library", "RSA/SHA256, Mon Jul 26 04:25:07 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn2", "2.3.2", "3.fc35", "x86_64", "libidn2-2.3.2-3.fc35.src.rpm", 291720, "(GPLv2+ or LGPLv3+) and GPLv3+", "Fedora Project", "", "Library to support IDNA2008 internationalized domain names", "RSA/SHA256, Tue Aug 31 17:38:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.37.2", "1.fc35", "x86_64", "util-linux-2.37.2-1.fc35.src.rpm", 34389, "BSD", "Fedora Project", "", "Universally unique ID library", "RSA/SHA256, Tue Aug 17 09:04:18 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "8.1", "3.fc35", "x86_64", "readline-8.1-3.fc35.src.rpm", 492684, "GPLv3+", "Fedora Project", "", "A library for editing typed command lines", "RSA/SHA256, Mon Jul 26 14:23:02 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.5.5", "3.fc35", "x86_64", "libassuan-2.5.5-3.fc35.src.rpm", 171069, "LGPLv2+ and GPLv3+", "Fedora Project", "", "GnuPG IPC library", "RSA/SHA256, Mon Jul 26 02:21:30 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.4.1", "2.fc35", "x86_64", "expat-2.4.1-2.fc35.src.rpm", 295041, "MIT", "Fedora Project", "", "An XML parser library", "RSA/SHA256, Sun Jul 25 18:20:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.15", "2.fc35", "x86_64", "json-c-0.15-2.fc35.src.rpm", 79583, "MIT", "Fedora Project", "", "JSON implementation in C", "RSA/SHA256, Mon Jul 26 00:40:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.6.1", "3.fc35", "x86_64", "keyutils-1.6.1-3.fc35.src.rpm", 55801, "GPLv2+ and LGPLv2+", "Fedora Project", "", "Key utilities library", "RSA/SHA256, Mon Jul 26 01:04:35 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsigsegv", "2.13", "3.fc35", "x86_64", "libsigsegv-2.13-3.fc35.src.rpm", 50250, "GPLv2+", "Fedora Project", "", "Library for handling page faults in user mode", "RSA/SHA256, Mon Jul 26 04:07:44 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsmartcols", "2.37.2", "1.fc35", "x86_64", "util-linux-2.37.2-1.fc35.src.rpm", 135371, "LGPLv2+", "Fedora Project", "", "Formatting library for ls-like programs.", "RSA/SHA256, Tue Aug 17 09:04:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.16.0", "6.fc35", "x86_64", "libtasn1-4.16.0-6.fc35.src.rpm", 183868, "GPLv3+ and LGPLv2+", "Fedora Project", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Mon Jul 26 04:15:56 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.45", "1.fc35", "x86_64", "pcre-8.45-1.fc35.src.rpm", 539220, "BSD", "Fedora Project", "", "Perl-compatible regular expression library", "RSA/SHA256, Wed Aug 18 09:50:02 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "3.6", "4.fc35", "x86_64", "grep-3.6-4.fc35.src.rpm", 857744, "GPLv3+", "Fedora Project", "", "Pattern matching utilities", "RSA/SHA256, Sun Jul 25 22:56:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gdbm-libs", "1.22", "1.fc35", "x86_64", "gdbm-1.22-1.fc35.src.rpm", 128594, "GPLv3+", "Fedora Project", "", "Libraries files for gdbm", "RSA/SHA256, Wed Oct 20 14:16:49 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "3.3", "2.fc35", "x86_64", "libsepol-3.3-2.fc35.src.rpm", 755891, "LGPLv2+", "Fedora Project", "", "SELinux binary policy manipulation library", "RSA/SHA256, Thu Nov 11 16:05:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcomps", "0.1.18", "1.fc35", "x86_64", "libcomps-0.1.18-1.fc35.src.rpm", 214999, "GPLv2+", "Fedora Project", "", "Comps XML file manipulation library", "RSA/SHA256, Thu Sep 23 12:32:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpsl", "0.21.1", "4.fc35", "x86_64", "libpsl-0.21.1-4.fc35.src.rpm", 78520, "MIT", "Fedora Project", "", "C library for the Publix Suffix List", "RSA/SHA256, Mon Jul 26 03:49:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpdecimal", "2.5.1", "2.fc35", "x86_64", "mpdecimal-2.5.1-2.fc35.src.rpm", 246955, "BSD", "Fedora Project", "", "Library for general decimal arithmetic", "RSA/SHA256, Mon Jul 26 06:53:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.9.4", "1.fc35", "x86_64", "libgcrypt-1.9.4-1.fc35.src.rpm", 1392828, "LGPLv2+", "Fedora Project", "", "A general-purpose cryptography library", "RSA/SHA256, Mon Aug 23 12:50:27 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libksba", "1.6.0", "2.fc35", "x86_64", "libksba-1.6.0-2.fc35.src.rpm", 401600, "(LGPLv3+ or GPLv2+) and GPLv3+", "Fedora Project", "", "CMS and X.509 library", "RSA/SHA256, Mon Jul 26 03:17:40 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "4.1.0", "8.fc35", "x86_64", "mpfr-4.1.0-8.fc35.src.rpm", 802431, "LGPLv3+", "Fedora Project", "", "C library for multiple-precision floating-point computations", "RSA/SHA256, Mon Jul 26 06:54:09 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "5.1.0", "4.fc35", "x86_64", "gawk-5.1.0-4.fc35.src.rpm", 1684030, "GPLv3+ and GPLv2+ and LGPLv2+ and BSD", "Fedora Project", "", "The GNU version of the AWK text processing utility", "RSA/SHA256, Sun Jul 25 19:25:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nettle", "3.7.3", "2.fc35", "x86_64", "nettle-3.7.3-2.fc35.src.rpm", 735221, "LGPLv3+ or GPLv2+", "Fedora Project", "", "A low-level cryptographic library", "RSA/SHA256, Mon Jul 26 07:30:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "alternatives", "1.19", "1.fc35", "x86_64", "chkconfig-1.19-1.fc35.src.rpm", 63264, "GPLv2", "Fedora Project", "", "A tool to maintain symbolic links determining default commands", "RSA/SHA256, Fri Jul 23 15:41:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.22", "4.fc35", "x86_64", "p11-kit-0.23.22-4.fc35.src.rpm", 451087, "BSD", "Fedora Project", "", "System trust module from p11-kit", "RSA/SHA256, Mon Jul 26 09:16:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "3.7.2", "2.fc35", "x86_64", "gnutls-3.7.2-2.fc35.src.rpm", 3141270, "GPLv3+ and LGPLv2+", "Fedora Project", "", "A TLS protocol implementation", "RSA/SHA256, Sun Jul 25 21:45:33 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libbrotli", "1.0.9", "6.fc35", "x86_64", "brotli-1.0.9-6.fc35.src.rpm", 784274, "MIT", "Fedora Project", "", "Library for brotli lossless compression algorithm", "RSA/SHA256, Sun Jul 25 04:24:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.8.2", "6.fc35", "x86_64", "libcap-ng-0.8.2-6.fc35.src.rpm", 75012, "LGPLv2+", "Fedora Project", "", "Alternate posix capabilities library", "RSA/SHA256, Mon Jul 26 02:27:07 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "3.0.6", "1.fc35", "x86_64", "audit-3.0.6-1.fc35.src.rpm", 307177, "LGPLv2+", "Fedora Project", "", "Dynamic library for libaudit", "RSA/SHA256, Fri Oct  1 20:49:35 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.28", "50.fc35", "x86_64", "libdb-5.3.28-50.fc35.src.rpm", 1922782, "BSD and LGPLv2 and Sleepycat", "Fedora Project", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Sep 22 12:07:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libeconf", "0.4.0", "2.fc35", "x86_64", "libeconf-0.4.0-2.fc35.src.rpm", 46171, "MIT", "Fedora Project", "", "Enhanced config file parser library", "RSA/SHA256, Mon Jul 26 02:43:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "11.2.1", "1.fc35", "x86_64", "gcc-11.2.1-1.fc35.src.rpm", 413740, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Fedora Project", "", "GCC OpenMP v4.5 shared support library", "RSA/SHA256, Thu Jul 29 07:41:02 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnghttp2", "1.45.1", "1.fc35", "x86_64", "nghttp2-1.45.1-1.fc35.src.rpm", 162468, "MIT", "Fedora Project", "", "A library implementing the HTTP/2 protocol", "RSA/SHA256, Wed Sep 22 05:31:49 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.3.2", "2.fc35", "x86_64", "libverto-0.3.2-2.fc35.src.rpm", 30277, "MIT", "Fedora Project", "", "Main loop abstraction library", "RSA/SHA256, Mon Jul 26 04:28:43 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libyaml", "0.2.5", "6.fc35", "x86_64", "libyaml-0.2.5-6.fc35.src.rpm", 138211, "MIT", "Fedora Project", "", "YAML 1.1 parser and emitter written in C", "RSA/SHA256, Mon Jul 26 04:40:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4-libs", "1.9.3", "3.fc35", "x86_64", "lz4-1.9.3-3.fc35.src.rpm", 145387, "GPLv2+ and BSD", "Fedora Project", "", "Libaries for lz4", "RSA/SHA256, Mon Jul 26 05:29:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "npth", "1.6", "7.fc35", "x86_64", "npth-1.6-7.fc35.src.rpm", 50531, "LGPLv2+", "Fedora Project", "", "The New GNU Portable Threads library", "RSA/SHA256, Mon Jul 26 07:48:27 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre2", "10.37", "4.fc35", "x86_64", "pcre2-10.37-4.fc35.src.rpm", 633138, "BSD", "Fedora Project", "", "Perl-compatible regular expression library", "RSA/SHA256, Tue Jul 27 11:12:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "3.3", "1.fc35", "x86_64", "libselinux-3.3-1.fc35.src.rpm", 169365, "Public Domain", "Fedora Project", "", "SELinux library and simple utilities", "RSA/SHA256, Sat Oct 23 08:36:29 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.8", "8.fc35", "x86_64", "sed-4.8-8.fc35.src.rpm", 813479, "GPLv3+", "Fedora Project", "", "A GNU stream text editor", "RSA/SHA256, Mon Jul 26 17:15:08 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "3.3", "1.fc35", "x86_64", "libsemanage-3.3-1.fc35.src.rpm", 303824, "LGPLv2+", "Fedora Project", "", "SELinux binary policy manipulation library", "RSA/SHA256, Sat Oct 23 08:36:57 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.9", "7.fc35", "x86_64", "shadow-utils-4.9-7.fc35.src.rpm", 3836461, "BSD and GPLv2+", "Fedora Project", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Fri Nov 12 16:14:19 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "8.2.3642", "1.fc35", "x86_64", "vim-8.2.3642-1.fc35.src.rpm", 1529767, "Vim and MIT", "Fedora Project", "", "A minimal version of the VIM editor", "RSA/SHA256, Mon Nov 22 13:42:00 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.185", "5.fc35", "noarch", "elfutils-0.185-5.fc35.src.rpm", 1810, "GPLv2+ or LGPLv3+", "Fedora Project", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Fri Aug  6 14:19:38 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.185", "5.fc35", "x86_64", "elfutils-0.185-5.fc35.src.rpm", 709117, "GPLv2+ or LGPLv3+", "Fedora Project", "", "Libraries to handle compiled objects", "RSA/SHA256, Fri Aug  6 14:19:43 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-common", "8.32", "31.fc35", "x86_64", "coreutils-8.32-31.fc35.src.rpm", 10880210, "GPLv3+", "Fedora Project", "", "coreutils common optional components", "RSA/SHA256, Sun Jul 25 16:10:51 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.1.1l", "2.fc35", "x86_64", "openssl-1.1.1l-2.fc35.src.rpm", 3855396, "OpenSSL and ASL 2.0", "Fedora Project", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Wed Sep 15 16:42:04 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.32", "31.fc35", "x86_64", "coreutils-8.32-31.fc35.src.rpm", 6040898, "GPLv3+", "Fedora Project", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Sun Jul 25 16:10:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2021.2.50", "3.fc35", "noarch", "ca-certificates-2021.2.50-3.fc35.src.rpm", 939948, "Public Domain", "Fedora Project", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Sun Jul 25 04:32:46 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.19.2", "2.fc35", "x86_64", "krb5-1.19.2-2.fc35.src.rpm", 2198421, "MIT", "Fedora Project", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Thu Aug 19 16:58:29 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtirpc", "1.3.2", "1.fc35", "x86_64", "libtirpc-1.3.2-1.fc35.src.rpm", 208122, "SISSL and BSD", "Fedora Project", "", "Transport Independent RPC Library", "RSA/SHA256, Mon Jul 26 04:19:48 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnsl2", "1.3.0", "4.fc35", "x86_64", "libnsl2-1.3.0-4.fc35.src.rpm", 130270, "BSD and LGPLv2+", "Fedora Project", "", "Public client interface library for NIS(YP) and NIS+", "RSA/SHA256, Mon Jul 26 03:37:13 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zchunk-libs", "1.1.15", "2.fc35", "x86_64", "zchunk-1.1.15-2.fc35.src.rpm", 90820, "BSD and MIT", "Fedora Project", "", "Zchunk library", "RSA/SHA256, Tue Jul 27 00:11:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfsverity", "1.4", "6.fc35", "x86_64", "fsverity-utils-1.4-6.fc35.src.rpm", 29672, "BSD", "Fedora Project", "", "Development package for fsverity-utils", "RSA/SHA256, Wed Oct 27 23:27:09 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.27", "13.fc35", "x86_64", "cyrus-sasl-2.1.27-13.fc35.src.rpm", 2409736, "BSD with advertising", "Fedora Project", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Tue Aug 24 16:01:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.59", "3.fc35", "x86_64", "openldap-2.4.59-3.fc35.src.rpm", 718501, "OpenLDAP", "Fedora Project", "", "LDAP support libraries", "RSA/SHA256, Fri Oct  1 15:29:57 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.3.3", "1.fc35", "x86_64", "gnupg2-2.3.3-1.fc35.src.rpm", 9244445, "GPLv3+", "Fedora Project", "", "Utility for secure communication and data storage", "RSA/SHA256, Wed Oct 13 09:14:25 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpgme", "1.15.1", "6.fc35", "x86_64", "gpgme-1.15.1-6.fc35.src.rpm", 573957, "LGPLv2+", "Fedora Project", "", "GnuPG Made Easy - high level crypto API", "RSA/SHA256, Tue Nov  2 19:13:57 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh", "0.9.6", "1.fc35", "x86_64", "libssh-0.9.6-1.fc35.src.rpm", 513049, "LGPLv2+", "Fedora Project", "", "A library implementing the SSH protocol", "RSA/SHA256, Tue Sep 21 17:02:37 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcurl", "7.79.1", "1.fc35", "x86_64", "curl-7.79.1-1.fc35.src.rpm", 681030, "MIT", "Fedora Project", "", "A library for getting files from web servers", "RSA/SHA256, Wed Sep 22 09:59:03 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tpm2-tss", "3.1.0", "3.fc35", "x86_64", "tpm2-tss-3.1.0-3.fc35.src.rpm", 2227128, "BSD and TCGL", "Fedora Project", "", "TPM2.0 Software Stack", "RSA/SHA256, Mon Jul 26 20:19:02 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ima-evm-utils", "1.3.2", "3.fc35", "x86_64", "ima-evm-utils-1.3.2-3.fc35.src.rpm", 141126, "GPLv2", "Fedora Project", "", "IMA/EVM support utilities", "RSA/SHA256, Mon Jul 26 00:06:30 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "curl", "7.79.1", "1.fc35", "x86_64", "curl-7.79.1-1.fc35.src.rpm", 723076, "MIT", "Fedora Project", "", "A utility for getting files from remote servers (FTP, HTTP, and others)", "RSA/SHA256, Wed Sep 22 09:59:03 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-pip-wheel", "21.2.3", "4.fc35", "noarch", "python-pip-21.2.3-4.fc35.src.rpm", 1220638, "MIT and Python and ASL 2.0 and BSD and ISC and LGPLv2 and MPLv2.0 and (ASL 2.0 or BSD)", "Fedora Project", "", "The pip wheel", "RSA/SHA256, Thu Nov 11 15:21:56 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3", "3.10.0", "1.fc35", "x86_64", "python3.10-3.10.0-1.fc35.src.rpm", 33090, "Python", "Fedora Project", "", "Python 3.10 interpreter", "RSA/SHA256, Mon Oct  4 23:01:38 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libs", "3.10.0", "1.fc35", "x86_64", "python3.10-3.10.0-1.fc35.src.rpm", 33027906, "Python", "Fedora Project", "", "Python runtime libraries", "RSA/SHA256, Mon Oct  4 23:01:35 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libcomps", "0.1.18", "1.fc35", "x86_64", "libcomps-0.1.18-1.fc35.src.rpm", 146971, "GPLv2+", "Fedora Project", "", "Python 3 bindings for libcomps library", "RSA/SHA256, Thu Sep 23 12:32:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-gpg", "1.15.1", "6.fc35", "x86_64", "gpgme-1.15.1-6.fc35.src.rpm", 1394334, "LGPLv2+", "Fedora Project", "", "gpgme bindings for Python 3", "RSA/SHA256, Tue Nov  2 19:13:56 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gzip", "1.10", "5.fc35", "x86_64", "gzip-1.10-5.fc35.src.rpm", 357298, "GPLv3+ and GFDL", "Fedora Project", "", "GNU data compression program", "RSA/SHA256, Sun Jul 25 23:28:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cracklib", "2.9.6", "27.fc35", "x86_64", "cracklib-2.9.6-27.fc35.src.rpm", 251474, "LGPLv2+", "Fedora Project", "", "A password-checking library", "RSA/SHA256, Mon Aug 30 21:36:42 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpwquality", "1.4.4", "6.fc35", "x86_64", "libpwquality-1.4.4-6.fc35.src.rpm", 415452, "BSD or GPLv2+", "Fedora Project", "", "A library for password generation and password quality checking", "RSA/SHA256, Sat Aug 21 14:00:39 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pam", "1.5.2", "5.fc35", "x86_64", "pam-1.5.2-5.fc35.src.rpm", 1947788, "BSD and GPLv2+", "Fedora Project", "", "An extensible library which provides authentication for applications", "RSA/SHA256, Thu Sep 23 11:00:59 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libblkid", "2.37.2", "1.fc35", "x86_64", "util-linux-2.37.2-1.fc35.src.rpm", 230761, "LGPLv2+", "Fedora Project", "", "Block device ID library", "RSA/SHA256, Tue Aug 17 09:04:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmount", "2.37.2", "1.fc35", "x86_64", "util-linux-2.37.2-1.fc35.src.rpm", 311125, "LGPLv2+", "Fedora Project", "", "Device mounting library", "RSA/SHA256, Tue Aug 17 09:04:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glib2", "2.70.1", "1.fc35", "x86_64", "glib2-2.70.1-1.fc35.src.rpm", 13474770, "LGPLv2+", "Fedora Project", "", "A library of handy utility functions", "RSA/SHA256, Tue Nov  2 19:43:11 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "librepo", "1.14.2", "1.fc35", "x86_64", "librepo-1.14.2-1.fc35.src.rpm", 241974, "LGPLv2+", "Fedora Project", "", "Repodata downloading library", "RSA/SHA256, Thu Sep 23 12:33:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libarchive", "3.5.2", "2.fc35", "x86_64", "libarchive-3.5.2-2.fc35.src.rpm", 907245, "BSD", "Fedora Project", "", "A library for handling streaming archive formats", "RSA/SHA256, Mon Aug 30 07:30:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-libs", "4.17.0", "1.fc35", "x86_64", "rpm-4.17.0-1.fc35.src.rpm", 775132, "GPLv2+ and LGPLv2+ with exceptions", "Fedora Project", "", "Libraries for manipulating RPM packages", "RSA/SHA256, Fri Sep  3 11:43:11 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm", "4.17.0", "1.fc35", "x86_64", "rpm-4.17.0-1.fc35.src.rpm", 2948898, "GPLv2+", "Fedora Project", "", "The RPM package management system", "RSA/SHA256, Fri Sep  3 11:43:11 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libmodulemd", "2.13.0", "3.fc35", "x86_64", "libmodulemd-2.13.0-3.fc35.src.rpm", 733689, "MIT", "Fedora Project", "", "Module metadata manipulation library", "RSA/SHA256, Tue Sep 14 13:43:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsolv", "0.7.19", "3.fc35", "x86_64", "libsolv-0.7.19-3.fc35.src.rpm", 897882, "BSD", "Fedora Project", "", "Package dependency solver", "RSA/SHA256, Mon Jul 26 04:09:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdnf", "0.64.0", "1.fc35", "x86_64", "libdnf-0.64.0-1.fc35.src.rpm", 2045581, "LGPLv2+", "Fedora Project", "", "Library providing simplified C and Python API to libsolv", "RSA/SHA256, Thu Sep 23 12:32:54 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-libdnf", "0.64.0", "1.fc35", "x86_64", "libdnf-0.64.0-1.fc35.src.rpm", 3766775, "LGPLv2+", "Fedora Project", "", "Python 3 bindings for the libdnf library.", "RSA/SHA256, Thu Sep 23 12:32:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-hawkey", "0.64.0", "1.fc35", "x86_64", "libdnf-0.64.0-1.fc35.src.rpm", 310028, "LGPLv2+", "Fedora Project", "", "Python 3 bindings for the hawkey library", "RSA/SHA256, Thu Sep 23 12:32:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-build-libs", "4.17.0", "1.fc35", "x86_64", "rpm-4.17.0-1.fc35.src.rpm", 199518, "GPLv2+ and LGPLv2+ with exceptions", "Fedora Project", "", "Libraries for building RPM packages", "RSA/SHA256, Fri Sep  3 11:43:13 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rpm-sign-libs", "4.17.0", "1.fc35", "x86_64", "rpm-4.17.0-1.fc35.src.rpm", 40492, "GPLv2+ and LGPLv2+ with exceptions", "Fedora Project", "", "Libraries for signing RPM packages", "RSA/SHA256, Fri Sep  3 11:43:14 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-rpm", "4.17.0", "1.fc35", "x86_64", "rpm-4.17.0-1.fc35.src.rpm", 378257, "GPLv2+", "Fedora Project", "", "Python 3 bindings for apps which will manipulate RPM packages", "RSA/SHA256, Fri Sep  3 11:43:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python3-dnf", "4.9.0", "1.fc35", "noarch", "dnf-4.9.0-1.fc35.src.rpm", 1898937, "GPLv2+", "Fedora Project", "", "Python 3 interface to DNF", "RSA/SHA256, Thu Sep 23 12:32:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf", "4.9.0", "1.fc35", "noarch", "dnf-4.9.0-1.fc35.src.rpm", 2203005, "GPLv2+", "Fedora Project", "", "Package manager", "RSA/SHA256, Thu Sep 23 12:32:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "yum", "4.9.0", "1.fc35", "noarch", "dnf-4.9.0-1.fc35.src.rpm", 22042, "GPLv2+", "Fedora Project", "", "Package manager", "RSA/SHA256, Thu Sep 23 12:32:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sudo", "1.9.7p2", "2.fc35", "x86_64", "sudo-1.9.7p2-2.fc35.src.rpm", 4324216, "ISC", "Fedora Project", "", "Allows restricted root access for specified users", "RSA/SHA256, Sat Aug  7 17:26:01 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "tar", "1.34", "2.fc35", "x86_64", "tar-1.34-2.fc35.src.rpm", 3156278, "GPLv3+", "Fedora Project", "", "GNU file archiving program", "RSA/SHA256, Mon Jul 26 19:42:40 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-repos-modular", "35", "1", "noarch", "fedora-repos-35-1.src.rpm", 4042, "MIT", "Fedora Project", "", "Fedora modular package repositories", "RSA/SHA256, Mon Oct 11 17:33:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "rootfiles", "8.1", "30.fc35", "noarch", "rootfiles-8.1-30.fc35.src.rpm", 817, "Public Domain", "Fedora Project", "", "The basic required files for the root user's directory", "RSA/SHA256, Mon Jul 26 14:35:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gpg-pubkey", "9867c58f", "601c49ca", "", "", 0, "pubkey", "", "", "Fedora (35) <fedora-35-primary@fedoraproject.org> public key", "", 0, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
	}

	// docker run --rm -it fedora:35 bash
	// dnf -y install https://repo.mongodb.org/yum/redhat/8/mongodb-org/5.0/x86_64/RPMS/mongodb-org-shell-5.0.9-1.el8.x86_64.rpm
	// dnf -y install https://repo.mongodb.org/yum/redhat/8/mongodb-org/5.0/x86_64/RPMS/mongodb-cli-1.25.0.x86_64.rpm
	// rpm -qa --queryformat "\{%{EPOCH}, \"%{NAME}\", \"%{VERSION}\", \"%{RELEASE}\", \"%{ARCH}\"\, \"%{SOURCERPM}\", %{SIZE}, \"%{LICENSE}\", \"%{VENDOR}\", \"\", \"%{SUMMARY}\", \"%{SIGPGP:pgpsig}\", nil, nil, nil\},\n" | sed "s/(none)/0/g" | sed 's/"0"/""/g'
	Fedora35PlusMongoDBWithSQLite3 = []*PackageInfo{
		{intRef(), "libgcc", "11.2.1", "9.fc35", "x86_64", "gcc-11.2.1-9.fc35.src.rpm", 198596, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Fedora Project", "", "GCC version 11 shared support library", "RSA/SHA256, Fri Jan 28 13:43:52 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "crypto-policies", "20210819", "1.gitd0fdcfb.fc35", "noarch", "crypto-policies-20210819-1.gitd0fdcfb.fc35.src.rpm", 86107, "LGPLv2+", "Fedora Project", "", "System-wide crypto policies", "RSA/SHA256, Thu Aug 19 18:23:42 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "tzdata", "2021e", "1.fc35", "noarch", "tzdata-2021e-1.fc35.src.rpm", 1800709, "Public Domain", "Fedora Project", "", "Timezone data", "RSA/SHA256, Thu Oct 28 22:21:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-release-identity-container", "35", "36", "noarch", "fedora-release-35-36.src.rpm", 1512, "MIT", "Fedora Project", "", "Package providing the identity for Fedora Container Base Image", "RSA/SHA256, Thu Nov 25 07:40:23 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-data", "8.2.4386", "1.fc35", "noarch", "vim-8.2.4386-1.fc35.src.rpm", 17949, "Vim and MIT", "Fedora Project", "", "Shared data for Vi and Vim", "RSA/SHA256, Tue Feb 15 07:31:06 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre2-syntax", "10.39", "1.fc35", "noarch", "pcre2-10.39-1.fc35.src.rpm", 229322, "BSD", "Fedora Project", "", "Documentation for PCRE2 regular expressions", "RSA/SHA256, Fri Jan 14 12:26:53 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "python-setuptools-wheel", "57.4.0", "1.fc35", "noarch", "python-setuptools-57.4.0-1.fc35.src.rpm", 596568, "MIT and (BSD or ASL 2.0)", "Fedora Project", "", "The setuptools wheel", "RSA/SHA256, Tue Aug  3 14:19:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "publicsuffix-list-dafsa", "20210518", "2.fc35", "noarch", "publicsuffix-list-20210518-2.fc35.src.rpm", 68815, "MPLv2.0", "Fedora Project", "", "Cross-vendor public domain suffix database in DAFSA form", "RSA/SHA256, Mon Jul 26 12:01:38 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-base", "6.2", "8.20210508.fc35", "noarch", "ncurses-6.2-8.20210508.fc35.src.rpm", 307293, "MIT", "Fedora Project", "", "Descriptions of common terminals", "RSA/SHA256, Mon Jul 26 07:18:39 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libssh-config", "0.9.6", "1.fc35", "noarch", "libssh-0.9.6-1.fc35.src.rpm", 277, "LGPLv2+", "Fedora Project", "", "Configuration files for libssh", "RSA/SHA256, Tue Sep 21 17:02:36 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libreport-filesystem", "2.15.2", "6.fc35", "noarch", "libreport-2.15.2-6.fc35.src.rpm", 0, "GPLv2+", "Fedora Project", "", "Filesystem layout for libreport", "RSA/SHA256, Mon Jul 26 03:56:01 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "dnf-data", "4.9.0", "1.fc35", "noarch", "dnf-4.9.0-1.fc35.src.rpm", 38568, "GPLv2+", "Fedora Project", "", "Common data and configuration files for DNF", "RSA/SHA256, Thu Sep 23 12:32:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-gpg-keys", "35", "1", "noarch", "fedora-repos-35-1.src.rpm", 118311, "MIT", "Fedora Project", "", "Fedora RPM keys", "RSA/SHA256, Mon Oct 11 17:33:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-release-container", "35", "36", "noarch", "fedora-release-35-36.src.rpm", 0, "MIT", "Fedora Project", "", "Base package for Fedora container specific default configurations", "RSA/SHA256, Thu Nov 25 07:40:27 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-repos", "35", "1", "noarch", "fedora-repos-35-1.src.rpm", 4597, "MIT", "Fedora Project", "", "Fedora package repositories", "RSA/SHA256, Mon Oct 11 17:33:31 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "fedora-release-common", "35", "36", "noarch", "fedora-release-35-36.src.rpm", 17657, "MIT", "Fedora Project", "", "Fedora release files", "RSA/SHA256, Thu Nov 25 07:40:22 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "setup", "2.13.9.1", "2.fc35", "noarch", "setup-2.13.9.1-2.fc35.src.rpm", 736053, "Public Domain", "Fedora Project", "", "A set of system configuration and setup files", "RSA/SHA256, Mon Jul 26 17:30:47 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "filesystem", "3.14", "7.fc35", "x86_64", "filesystem-3.14-7.fc35.src.rpm", 106, "Public Domain", "Fedora Project", "", "The basic directory layout for a Linux system", "RSA/SHA256, Sun Jul 25 18:44:58 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "basesystem", "11", "12.fc35", "noarch", "basesystem-11-12.fc35.src.rpm", 0, "Public Domain", "Fedora Project", "", "The skeleton package which defines a simple Fedora system", "RSA/SHA256, Sun Jul 25 03:58:03 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bash", "5.1.8", "2.fc35", "x86_64", "bash-5.1.8-2.fc35.src.rpm", 7739604, "GPLv3+", "Fedora Project", "", "The GNU Bourne Again shell", "RSA/SHA256, Sun Jul 25 03:58:08 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ncurses-libs", "6.2", "8.20210508.fc35", "x86_64", "ncurses-6.2-8.20210508.fc35.src.rpm", 996375, "MIT", "Fedora Project", "", "Ncurses libraries", "RSA/SHA256, Mon Jul 26 07:19:01 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-common", "2.34", "25.fc35", "x86_64", "glibc-2.34-25.fc35.src.rpm", 1089465, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Fedora Project", "", "Common binaries and locale data for glibc", "RSA/SHA256, Fri Feb  4 11:04:50 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc-minimal-langpack", "2.34", "25.fc35", "x86_64", "glibc-2.34-25.fc35.src.rpm", 0, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Fedora Project", "", "Minimal language packs for glibc.", "RSA/SHA256, Fri Feb  4 11:04:54 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "glibc", "2.34", "25.fc35", "x86_64", "glibc-2.34-25.fc35.src.rpm", 6262755, "LGPLv2+ and LGPLv2+ with exceptions and GPLv2+ and GPLv2+ with exceptions and BSD and Inner-Net and ISC and Public Domain and GFDL", "Fedora Project", "", "The GNU libc libraries", "RSA/SHA256, Fri Feb  4 11:04:02 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zlib", "1.2.11", "30.fc35", "x86_64", "zlib-1.2.11-30.fc35.src.rpm", 203449, "zlib and Boost", "Fedora Project", "", "Compression and decompression library", "RSA/SHA256, Thu Jul 29 10:39:56 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "bzip2-libs", "1.0.8", "9.fc35", "x86_64", "bzip2-1.0.8-9.fc35.src.rpm", 78660, "BSD", "Fedora Project", "", "Libraries for applications using bzip2", "RSA/SHA256, Sun Jul 25 04:31:34 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "xz-libs", "5.2.5", "7.fc35", "x86_64", "xz-5.2.5-7.fc35.src.rpm", 181437, "Public Domain", "Fedora Project", "", "Libraries for decoding LZMA compression", "RSA/SHA256, Tue Jul 27 00:02:26 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libzstd", "1.5.2", "1.fc35", "x86_64", "zstd-1.5.2-1.fc35.src.rpm", 738483, "BSD and GPLv2", "Fedora Project", "", "Zstd shared library", "RSA/SHA256, Sun Jan 23 23:29:15 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sqlite-libs", "3.36.0", "3.fc35", "x86_64", "sqlite-3.36.0-3.fc35.src.rpm", 1334505, "Public Domain", "Fedora Project", "", "Shared library for the sqlite3 embeddable SQL database engine.", "RSA/SHA256, Mon Jul 26 19:04:38 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gmp", "6.2.0", "7.fc35", "x86_64", "gmp-6.2.0-7.fc35.src.rpm", 809478, "LGPLv3+ or GPLv2+", "Fedora Project", "", "GNU arbitrary precision library", "RSA/SHA256, Sun Jul 25 21:26:14 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap", "2.48", "3.fc35", "x86_64", "libcap-2.48-3.fc35.src.rpm", 180511, "BSD or GPLv2", "Fedora Project", "", "Library for getting and setting POSIX.1e capabilities", "RSA/SHA256, Mon Jul 26 02:26:54 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "popt", "1.18", "6.fc35", "x86_64", "popt-1.18-6.fc35.src.rpm", 130256, "MIT", "Fedora Project", "", "C library for parsing command line parameters", "RSA/SHA256, Mon Jul 26 11:42:54 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgpg-error", "1.43", "1.fc35", "x86_64", "libgpg-error-1.43-1.fc35.src.rpm", 851181, "LGPLv2+", "Fedora Project", "", "Library for error values used by GnuPG components", "RSA/SHA256, Thu Nov  4 14:52:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxml2", "2.9.12", "6.fc35", "x86_64", "libxml2-2.9.12-6.fc35.src.rpm", 1923894, "MIT", "Fedora Project", "", "Library providing XML and HTML support", "RSA/SHA256, Mon Jul 26 04:38:49 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcom_err", "1.46.3", "1.fc35", "x86_64", "e2fsprogs-1.46.3-1.fc35.src.rpm", 68441, "MIT", "Fedora Project", "", "Common error description library", "RSA/SHA256, Fri Jul 30 12:54:26 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libstdc++", "11.2.1", "9.fc35", "x86_64", "gcc-11.2.1-9.fc35.src.rpm", 2481086, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Fedora Project", "", "GNU Standard C++ Library", "RSA/SHA256, Fri Jan 28 13:43:47 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libxcrypt", "4.4.28", "1.fc35", "x86_64", "libxcrypt-4.4.28-1.fc35.src.rpm", 275394, "LGPLv2+ and BSD and Public Domain", "Fedora Project", "", "Extended crypt library for descrypt, md5crypt, bcrypt, and others", "RSA/SHA256, Tue Feb  1 23:01:12 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lua-libs", "5.4.4", "1.fc35", "x86_64", "lua-5.4.4-1.fc35.src.rpm", 555678, "MIT", "Fedora Project", "", "Libraries for lua", "RSA/SHA256, Tue Feb  1 19:46:01 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "file-libs", "5.40", "9.fc35", "x86_64", "file-5.40-9.fc35.src.rpm", 8529778, "BSD", "Fedora Project", "", "Libraries for applications using libmagic", "RSA/SHA256, Sun Jul 25 18:44:19 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libelf", "0.186", "1.fc35", "x86_64", "elfutils-0.186-1.fc35.src.rpm", 1027449, "GPLv2+ or LGPLv3+", "Fedora Project", "", "Library to read and write ELF files", "RSA/SHA256, Thu Nov 18 22:14:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libattr", "2.5.1", "3.fc35", "x86_64", "attr-2.5.1-3.fc35.src.rpm", 29341, "LGPLv2+", "Fedora Project", "", "Dynamic library for extended attribute support", "RSA/SHA256, Sun Jul 25 03:41:40 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libacl", "2.3.1", "2.fc35", "x86_64", "acl-2.3.1-2.fc35.src.rpm", 41090, "LGPLv2+", "Fedora Project", "", "Dynamic library for access control list support", "RSA/SHA256, Sun Jul 25 01:39:14 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libffi", "3.1", "29.fc35", "x86_64", "libffi-3.1-29.fc35.src.rpm", 56872, "MIT", "Fedora Project", "", "A portable foreign function interface library", "RSA/SHA256, Thu Aug 12 22:46:18 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit", "0.23.22", "4.fc35", "x86_64", "p11-kit-0.23.22-4.fc35.src.rpm", 1659536, "BSD", "Fedora Project", "", "Library for loading and sharing PKCS#11 modules", "RSA/SHA256, Mon Jul 26 09:16:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libunistring", "0.9.10", "14.fc35", "x86_64", "libunistring-0.9.10-14.fc35.src.rpm", 1642923, "GPLv2+ or LGPLv3+", "Fedora Project", "", "GNU Unicode string library", "RSA/SHA256, Mon Jul 26 04:25:07 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libidn2", "2.3.2", "3.fc35", "x86_64", "libidn2-2.3.2-3.fc35.src.rpm", 291720, "(GPLv2+ or LGPLv3+) and GPLv3+", "Fedora Project", "", "Library to support IDNA2008 internationalized domain names", "RSA/SHA256, Tue Aug 31 17:38:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "readline", "8.1", "3.fc35", "x86_64", "readline-8.1-3.fc35.src.rpm", 492684, "GPLv3+", "Fedora Project", "", "A library for editing typed command lines", "RSA/SHA256, Mon Jul 26 14:23:02 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libuuid", "2.37.4", "1.fc35", "x86_64", "util-linux-2.37.4-1.fc35.src.rpm", 34389, "BSD", "Fedora Project", "", "Universally unique ID library", "RSA/SHA256, Mon Feb 14 12:04:09 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libassuan", "2.5.5", "3.fc35", "x86_64", "libassuan-2.5.5-3.fc35.src.rpm", 171069, "LGPLv2+ and GPLv3+", "Fedora Project", "", "GnuPG IPC library", "RSA/SHA256, Mon Jul 26 02:21:30 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "json-c", "0.15", "2.fc35", "x86_64", "json-c-0.15-2.fc35.src.rpm", 79583, "MIT", "Fedora Project", "", "JSON implementation in C", "RSA/SHA256, Mon Jul 26 00:40:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "keyutils-libs", "1.6.1", "3.fc35", "x86_64", "keyutils-1.6.1-3.fc35.src.rpm", 55801, "GPLv2+ and LGPLv2+", "Fedora Project", "", "Key utilities library", "RSA/SHA256, Mon Jul 26 01:04:35 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsigsegv", "2.13", "3.fc35", "x86_64", "libsigsegv-2.13-3.fc35.src.rpm", 50250, "GPLv2+", "Fedora Project", "", "Library for handling page faults in user mode", "RSA/SHA256, Mon Jul 26 04:07:44 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtasn1", "4.16.0", "6.fc35", "x86_64", "libtasn1-4.16.0-6.fc35.src.rpm", 183868, "GPLv3+ and LGPLv2+", "Fedora Project", "", "The ASN.1 library used in GNUTLS", "RSA/SHA256, Mon Jul 26 04:15:56 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre", "8.45", "1.fc35", "x86_64", "pcre-8.45-1.fc35.src.rpm", 539220, "BSD", "Fedora Project", "", "Perl-compatible regular expression library", "RSA/SHA256, Wed Aug 18 09:50:02 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "grep", "3.6", "4.fc35", "x86_64", "grep-3.6-4.fc35.src.rpm", 857744, "GPLv3+", "Fedora Project", "", "Pattern matching utilities", "RSA/SHA256, Sun Jul 25 22:56:32 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "expat", "2.4.4", "1.fc35", "x86_64", "expat-2.4.4-1.fc35.src.rpm", 300148, "MIT", "Fedora Project", "", "An XML parser library", "RSA/SHA256, Mon Jan 31 09:01:06 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "gdbm-libs", "1.22", "1.fc35", "x86_64", "gdbm-1.22-1.fc35.src.rpm", 128594, "GPLv3+", "Fedora Project", "", "Libraries files for gdbm", "RSA/SHA256, Wed Oct 20 14:16:49 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsepol", "3.3", "2.fc35", "x86_64", "libsepol-3.3-2.fc35.src.rpm", 755891, "LGPLv2+", "Fedora Project", "", "SELinux binary policy manipulation library", "RSA/SHA256, Thu Nov 11 16:05:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsmartcols", "2.37.4", "1.fc35", "x86_64", "util-linux-2.37.4-1.fc35.src.rpm", 135379, "LGPLv2+", "Fedora Project", "", "Formatting library for ls-like programs.", "RSA/SHA256, Mon Feb 14 12:04:08 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcomps", "0.1.18", "1.fc35", "x86_64", "libcomps-0.1.18-1.fc35.src.rpm", 214999, "GPLv2+", "Fedora Project", "", "Comps XML file manipulation library", "RSA/SHA256, Thu Sep 23 12:32:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libpsl", "0.21.1", "4.fc35", "x86_64", "libpsl-0.21.1-4.fc35.src.rpm", 78520, "MIT", "Fedora Project", "", "C library for the Publix Suffix List", "RSA/SHA256, Mon Jul 26 03:49:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpdecimal", "2.5.1", "2.fc35", "x86_64", "mpdecimal-2.5.1-2.fc35.src.rpm", 246955, "BSD", "Fedora Project", "", "Library for general decimal arithmetic", "RSA/SHA256, Mon Jul 26 06:53:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgcrypt", "1.9.4", "1.fc35", "x86_64", "libgcrypt-1.9.4-1.fc35.src.rpm", 1392828, "LGPLv2+", "Fedora Project", "", "A general-purpose cryptography library", "RSA/SHA256, Mon Aug 23 12:50:27 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libksba", "1.6.0", "2.fc35", "x86_64", "libksba-1.6.0-2.fc35.src.rpm", 401600, "(LGPLv3+ or GPLv2+) and GPLv3+", "Fedora Project", "", "CMS and X.509 library", "RSA/SHA256, Mon Jul 26 03:17:40 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "mpfr", "4.1.0", "8.fc35", "x86_64", "mpfr-4.1.0-8.fc35.src.rpm", 802431, "LGPLv3+", "Fedora Project", "", "C library for multiple-precision floating-point computations", "RSA/SHA256, Mon Jul 26 06:54:09 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gawk", "5.1.0", "4.fc35", "x86_64", "gawk-5.1.0-4.fc35.src.rpm", 1684030, "GPLv3+ and GPLv2+ and LGPLv2+ and BSD", "Fedora Project", "", "The GNU version of the AWK text processing utility", "RSA/SHA256, Sun Jul 25 19:25:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "nettle", "3.7.3", "2.fc35", "x86_64", "nettle-3.7.3-2.fc35.src.rpm", 735221, "LGPLv3+ or GPLv2+", "Fedora Project", "", "A low-level cryptographic library", "RSA/SHA256, Mon Jul 26 07:30:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "alternatives", "1.19", "1.fc35", "x86_64", "chkconfig-1.19-1.fc35.src.rpm", 63264, "GPLv2", "Fedora Project", "", "A tool to maintain symbolic links determining default commands", "RSA/SHA256, Fri Jul 23 15:41:41 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "p11-kit-trust", "0.23.22", "4.fc35", "x86_64", "p11-kit-0.23.22-4.fc35.src.rpm", 451087, "BSD", "Fedora Project", "", "System trust module from p11-kit", "RSA/SHA256, Mon Jul 26 09:16:55 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnutls", "3.7.2", "2.fc35", "x86_64", "gnutls-3.7.2-2.fc35.src.rpm", 3141270, "GPLv3+ and LGPLv2+", "Fedora Project", "", "A TLS protocol implementation", "RSA/SHA256, Sun Jul 25 21:45:33 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libbrotli", "1.0.9", "6.fc35", "x86_64", "brotli-1.0.9-6.fc35.src.rpm", 784274, "MIT", "Fedora Project", "", "Library for brotli lossless compression algorithm", "RSA/SHA256, Sun Jul 25 04:24:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libdb", "5.3.28", "50.fc35", "x86_64", "libdb-5.3.28-50.fc35.src.rpm", 1922782, "BSD and LGPLv2 and Sleepycat", "Fedora Project", "", "The Berkeley DB database library for C", "RSA/SHA256, Wed Sep 22 12:07:45 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libeconf", "0.4.0", "2.fc35", "x86_64", "libeconf-0.4.0-2.fc35.src.rpm", 46171, "MIT", "Fedora Project", "", "Enhanced config file parser library", "RSA/SHA256, Mon Jul 26 02:43:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnghttp2", "1.45.1", "1.fc35", "x86_64", "nghttp2-1.45.1-1.fc35.src.rpm", 162468, "MIT", "Fedora Project", "", "A library implementing the HTTP/2 protocol", "RSA/SHA256, Wed Sep 22 05:31:49 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libverto", "0.3.2", "2.fc35", "x86_64", "libverto-0.3.2-2.fc35.src.rpm", 30277, "MIT", "Fedora Project", "", "Main loop abstraction library", "RSA/SHA256, Mon Jul 26 04:28:43 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libyaml", "0.2.5", "6.fc35", "x86_64", "libyaml-0.2.5-6.fc35.src.rpm", 138211, "MIT", "Fedora Project", "", "YAML 1.1 parser and emitter written in C", "RSA/SHA256, Mon Jul 26 04:40:12 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "lz4-libs", "1.9.3", "3.fc35", "x86_64", "lz4-1.9.3-3.fc35.src.rpm", 145387, "GPLv2+ and BSD", "Fedora Project", "", "Libaries for lz4", "RSA/SHA256, Mon Jul 26 05:29:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "npth", "1.6", "7.fc35", "x86_64", "npth-1.6-7.fc35.src.rpm", 50531, "LGPLv2+", "Fedora Project", "", "The New GNU Portable Threads library", "RSA/SHA256, Mon Jul 26 07:48:27 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libcap-ng", "0.8.2", "8.fc35", "x86_64", "libcap-ng-0.8.2-8.fc35.src.rpm", 75012, "LGPLv2+", "Fedora Project", "", "Alternate posix capabilities library", "RSA/SHA256, Mon Jan  3 23:27:13 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "audit-libs", "3.0.7", "2.fc35", "x86_64", "audit-3.0.7-2.fc35.src.rpm", 307185, "LGPLv2+", "Fedora Project", "", "Dynamic library for libaudit", "RSA/SHA256, Tue Feb 15 03:17:18 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libgomp", "11.2.1", "9.fc35", "x86_64", "gcc-11.2.1-9.fc35.src.rpm", 412830, "GPLv3+ and GPLv3+ with exceptions and GPLv2+ with exceptions and LGPLv2+ and BSD", "Fedora Project", "", "GCC OpenMP v4.5 shared support library", "RSA/SHA256, Fri Jan 28 13:43:51 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "pcre2", "10.39", "1.fc35", "x86_64", "pcre2-10.39-1.fc35.src.rpm", 633146, "BSD", "Fedora Project", "", "Perl-compatible regular expression library", "RSA/SHA256, Fri Jan 14 12:26:57 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libselinux", "3.3", "1.fc35", "x86_64", "libselinux-3.3-1.fc35.src.rpm", 169365, "Public Domain", "Fedora Project", "", "SELinux library and simple utilities", "RSA/SHA256, Sat Oct 23 08:36:29 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "sed", "4.8", "8.fc35", "x86_64", "sed-4.8-8.fc35.src.rpm", 813479, "GPLv3+", "Fedora Project", "", "A GNU stream text editor", "RSA/SHA256, Mon Jul 26 17:15:08 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libsemanage", "3.3", "1.fc35", "x86_64", "libsemanage-3.3-1.fc35.src.rpm", 303824, "LGPLv2+", "Fedora Project", "", "SELinux binary policy manipulation library", "RSA/SHA256, Sat Oct 23 08:36:57 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "shadow-utils", "4.9", "9.fc35", "x86_64", "shadow-utils-4.9-9.fc35.src.rpm", 3841041, "BSD and GPLv2+", "Fedora Project", "", "Utilities for managing accounts and shadow password files", "RSA/SHA256, Fri Jan 21 15:27:29 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(2), "vim-minimal", "8.2.4386", "1.fc35", "x86_64", "vim-8.2.4386-1.fc35.src.rpm", 1545045, "Vim and MIT", "Fedora Project", "", "A minimal version of the VIM editor", "RSA/SHA256, Tue Feb 15 07:31:10 2022, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-default-yama-scope", "0.186", "1.fc35", "noarch", "elfutils-0.186-1.fc35.src.rpm", 1810, "GPLv2+ or LGPLv3+", "Fedora Project", "", "Default yama attach scope sysctl setting", "RSA/SHA256, Thu Nov 18 22:14:10 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "elfutils-libs", "0.186", "1.fc35", "x86_64", "elfutils-0.186-1.fc35.src.rpm", 682389, "GPLv2+ or LGPLv3+", "Fedora Project", "", "Libraries to handle compiled objects", "RSA/SHA256, Thu Nov 18 22:14:17 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils-common", "8.32", "31.fc35", "x86_64", "coreutils-8.32-31.fc35.src.rpm", 10880210, "GPLv3+", "Fedora Project", "", "coreutils common optional components", "RSA/SHA256, Sun Jul 25 16:10:51 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(1), "openssl-libs", "1.1.1l", "2.fc35", "x86_64", "openssl-1.1.1l-2.fc35.src.rpm", 3855396, "OpenSSL and ASL 2.0", "Fedora Project", "", "A general purpose cryptography library with TLS implementation", "RSA/SHA256, Wed Sep 15 16:42:04 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "coreutils", "8.32", "31.fc35", "x86_64", "coreutils-8.32-31.fc35.src.rpm", 6040898, "GPLv3+", "Fedora Project", "", "A set of basic GNU tools commonly used in shell scripts", "RSA/SHA256, Sun Jul 25 16:10:50 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "ca-certificates", "2021.2.52", "1.0.fc35", "noarch", "ca-certificates-2021.2.52-1.0.fc35.src.rpm", 972279, "Public Domain", "Fedora Project", "", "The Mozilla CA root certificate bundle", "RSA/SHA256, Mon Dec 13 19:16:42 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "krb5-libs", "1.19.2", "2.fc35", "x86_64", "krb5-1.19.2-2.fc35.src.rpm", 2198421, "MIT", "Fedora Project", "", "The non-admin shared libraries used by Kerberos 5", "RSA/SHA256, Thu Aug 19 16:58:29 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libtirpc", "1.3.2", "1.fc35", "x86_64", "libtirpc-1.3.2-1.fc35.src.rpm", 208122, "SISSL and BSD", "Fedora Project", "", "Transport Independent RPC Library", "RSA/SHA256, Mon Jul 26 04:19:48 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libnsl2", "1.3.0", "4.fc35", "x86_64", "libnsl2-1.3.0-4.fc35.src.rpm", 130270, "BSD and LGPLv2+", "Fedora Project", "", "Public client interface library for NIS(YP) and NIS+", "RSA/SHA256, Mon Jul 26 03:37:13 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "zchunk-libs", "1.1.15", "2.fc35", "x86_64", "zchunk-1.1.15-2.fc35.src.rpm", 90820, "BSD and MIT", "Fedora Project", "", "Zchunk library", "RSA/SHA256, Tue Jul 27 00:11:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "libfsverity", "1.4", "6.fc35", "x86_64", "fsverity-utils-1.4-6.fc35.src.rpm", 29672, "BSD", "Fedora Project", "", "Development package for fsverity-utils", "RSA/SHA256, Wed Oct 27 23:27:09 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "cyrus-sasl-lib", "2.1.27", "13.fc35", "x86_64", "cyrus-sasl-2.1.27-13.fc35.src.rpm", 2409736, "BSD with advertising", "Fedora Project", "", "Shared libraries needed by applications which use Cyrus SASL", "RSA/SHA256, Tue Aug 24 16:01:53 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "openldap", "2.4.59", "3.fc35", "x86_64", "openldap-2.4.59-3.fc35.src.rpm", 718501, "OpenLDAP", "Fedora Project", "", "LDAP support libraries", "RSA/SHA256, Fri Oct  1 15:29:57 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA256, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil},
		{intRef(), "gnupg2", "2.3.4", "1.fc35", "x86_64", "gnupg2-2.3.4-1.fc35.src.rpm", 9261756, "GPLv3+", "Fedora Project", "", "Utility for secure communication and data storage", "RSA/SHA256, Tue Dec 21 12:21:16 2021, Key ID db4639719867c58f", PGPHASHALGO_SHA25