/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/* myerrno.h

   Define values assigned to global variable myerrno
*/

#ifndef COMMON_MYERRNO_H
#define COMMON_MYERRNO_H

/* Generic error codes */
typedef enum myerrno_e {
MENONE=0x0000,       /* no error */

MEINVAL,              /* invalid argument */
MEFAULT,              /* invalid address */
MENOMEM,              /* not enough memory */

/* File I/O error codes */
MENOENT,             /* a component of the path file name does not exists */
MENAMETOOLONG,       /* file name is as it is said */
MENOTDIR,            /* file is not a directory */
MEACCESS,            /* permission denied */
MERACCESS,           /* read permission denied */
MEWACCESS,           /* write permission denied */ 
MELOOP,              /* too much symbolic link */

MEUNKNOWN=0xFFFF     /* undefined error, look at errno for more inofo */
} myerrno_t;

extern myerrno_t myerrno;

#endif /* COMMON_MYERRNO_H */
