## tsMuxeR 2.6.16
- Fixed a an issue so that Dolby Vision EL stream type is now correct 
- Fixed a bug with HEVC streams when an HDR10+ SEI payload is too short
- Fixed a bug where the first 2 frames of the first video track are muxed before anything else
- Introduced an improvement so Single Track Double Layer files now can properly handled
- Fixed a bug so that if no MOOF atom is met we stop atom parsing at the next MDAT atom
- Fixed an issue with HDR flags, so we only set them if an HEVC stream is detected
- Introduced correct ATSC descriptor for pure EAC3 tracks
- Introduced correct HDMV TS descriptors for MPEG-2 streams
- Fixed an issue where Blu-Ray movies will loop rather than stopping after reading
- Introduced being able to include Dolby Vision descriptors in TS or M2TS mode
- Fixed the order of streams so that video streams always come first
- Introduced a GUI option for adjusting PIP transparency
- Fixed an issue where translated strings appeared in the meta file
- Fixed a bug in the output paths of the MXE build scripts
- Ensured we keep M2TS descriptors in TS files (temporary until a long-term solution can be found)
- Fixed a bug where filenames were being truncated prematurely if there were dots in the filename
- Introduced putting overnight builds into OBS, to build for various Linux platforms
- Improved the documentation to fix a broken URL for the test files
- Introduced a simplification of the method used to play sounds in the GUI
- Fixed an issue with broken ISO labels when using non-ASCII characters
- Introduced a refactoring that moved the About page into an external HTML file for the GUI
- Introduced a code cleanup that removed all usages of std::wstring
- Fixed an issue with incorrect subtitle spacing on Windows
- Introduced support for M4V files
- Fixed issue with subtitle timestamps when joining multiple M2TS files together
- Fixed incorrect usage of POSIX APIs in Windows builds
- Fixed a bug with encoding errors when dealing with SSIF files
- Fixed a bug where we could read over the end of an MP4 file
- Introduced keeping the track order when multiple video tracks are added
- Introduced support for reading fragmented MP4 files
- Introduced support for specific AVC and HEVC descriptors in TS files
- Introduced support for Dolby Vision atoms in AVC or HEVC streams
- Introduced a changelog and improved general documentation
- Fixed an issue with garbled subtitles being displayed
- Introduced translation support, as well as a full Russian translation of the GUI
- Introduced getting the HDR10 information from the SPS VUI in HEVC
- Introduced detection of UTF8 in subtitle files
- Fixed usage of WinMain, which lead to issues with console output on Windows
- Introduced converting meta files using active code page if UTF8 fails
- Improved the documentation for building with Msys2
- Fixed bugs in the handling of non-ASCII characters in paths on Windows
- Fixed bugs in subtitles PIDs for BD V3 M2TS with HDR
- Fixed bug with the display of bitrate and channel numbers for EAC3 and AC3 tracks
- Fixed bug with GUI not correctly allowing to select DTS Express 24-bit as a secondary track
- Introduced an error message when an output file longer than 255 characters and reduced overall file length
- Fixed bug where 3D plane information was showing for 2D BD-ROMs
- Fixed a bug with uneven width between characters in subtitles on Mac and Linux
- Introduced the ability to detect audio delays in MKV files
- Fixed a bug where the 3D planes were not detected in specific cases
- Fixed a bug with alignment of the subtitle tracks and 3D planes
- Removed unnecessary floating point conversion code from the GUI source tree
- Added support for frame rates of 50, 59.94 and 60
- Fixed an issue with HDR10 HEVC streams where the maxCLL and maxFALL values were set incorrectly
- Fixed typos and improved the clarity of certain wording in the GUI
- Fixed typos and grammar issues with the readme and usage information
- Introduced the git revision to the version string in the GUI and CLI
- Introduced automatic selection of BD V3 for HEVC in GUI
- Fixed an issue with compiling on Mac
- Fixed an issue with the handling of wav64
- Introduced a workaround for QTBUG-28893
- Performed another round of GUI code cleanup
- Introduced a uniform code formatting style
- Fixed a bug with reading the FPS information from certain streams
- Fixed a typo in the GUI settings for the font family setting
- Introduced a warning when a V2 video format is used for a V3 Blu-ray
- Fixed a bug with incorrect stream ID for TS stream
- Fixed typos in the source files
- Introduced UHD Blu-ray as an option in the GUI
- Fixed a bug where invalid font files could crash tsMuxer
- Fixed an issue with HEVC stream detection in the GUI
- Introduced reading the FPS info from VPS or SPS, rather than VPS only
- Fixed a bug with the CPI table I-frame thresholds with UHD
- Introduced Dolby Vision support
- Fixed compiler warnings on return value overflows
- Fixed an issue with the stream ID being incorrectly set for BD V3
- Fixed an issue when spaces where in the path to the temporary meta file in the GUI
- Fixed an issue with buffer overflows on HEVC streams
- Fixed an issue so that TS descriptors are the same as on commercial Blu-rays
- Fixed an issue where numbers were shown instead of language codes in the GUI
- Introduced nightly builds, hosted on Bintray
- Fixed a bug where the tsMuxer executable could not be found on Windows in the GUI
- Fixed a bug where muxing a SRT results in a segfault on Linux
- Introduced support for UHD HDR10 and HDR10+
- Introduced a migration from "override" to "virtual" keywords in the code to conform better to C++14
- Introduced a migration from "QObject::connect" syntax to Qt5 equivalent in the GUI
- Fixed an issue with the min and max functions when compiling on Windows
- Fixed an issue calculating the AAC frame size
- Introduced UHD (width >= 2600) support in the MPLS and CLPI
- Introduced a clean up and reformatting of the documentation
- Introduced UHD BD V3 support
- Fixed an issue with EAC3 bitrate, sampling rate and channel information not being set correctly
- Fixed a bug with parsing of AC3
- Fixed an issue with the stream type not being set correctly for H265
- Fixed an issue when parsing MP4 AAC 5.1 where the channel output is not read correctly
- Fixed an issue with parsing the AAC frame length
- Introduced an update of the C++ standard from 11 to 14
- Introduced a cleanup of precompiled headers
- Introduced using std::thread for the TerminatableThread in libmediation
- Introduced cross-platform CMake build system
- Introduced a cleanup of libmediation that removed condvar, mutex and time from the library
- Introduced a translation of comments from Russian to English
- Introduced a migration from Qt4 to Qt5

## tsMuxeR 2.6.15
- Fixed mkv parser a bit. I've got unparsed file example

## tsMuxeR 2.6.13
- update SEI correction: do not correct SPS/PPS if stream contains different PPS with same pps_id

## tsMuxeR 2.6.12
- several minor bugs fixed

## tsMuxeR 2.6.11
- fixed saving UI settings to a registry. Also, if file tsMuxerGUI.ini found, UI will switch settings to an ini file instead of registry
  (you can create empty ini file at the beginning).
- UI: change control for cut start/end time
- fixed SEI processing for 'force' mode ( it doesn't work correctly for some movies)
- fixed bug in the wav demuxer (first audio frame has mixed up channels)
- fixed timings for PG streams. Timings was inaccurate for amount of several ms (for some movies only, it depended of the first PTS of the file)

## tsMuxeR 2.6.9
- inserting SEI did not work for some H.264 stream at all
- add more correction for VUI parameters if option insert SEI is active (it helps to open some H.264 streams in the Scenarins
  and solve PS3 problem for some sources)
- fixed channels for 7.1 and 7.0 wav files
- fixed combined H.264 streams read from Elementary Stream
- BD Bitrate control improved a little bit

## tsMuxeR 2.6.4
- Add secondary video support
- fixed mp4 files with MPEG-DASH
- fixed SEI again
- fixed DTS-ES recognition
- fixed font renderer (a little bit wrong text position)
- several minor improvments and bug fixes

## tsMuxeR 2.5.7
- fixed bug with SEI messages for some movie
- fixed problem with some movies where problem occured during processing several last video frames
- several minor bug fixes

## tsMuxeR 2.5.5
- add HEVC video codec support
- UI improvment: Save settings for General tab, Subtitles tab and last output folder
- Fixed file duration detection for ssif and some m2ts files
- Fixed bug if mux playlist and several sup files (it is a very olg bug, but it became much more often since 2.4.x)
- Several minor bug fixes

## tsMuxeR 2.4.0
- Add secondary audio support for bluray muxing. Due to standart It is allowed only for DTS-Express and DD+ codecs.
- Filter out H.264 filler packets
- UI improvment: option for MPLS offset can be entered either as time or as 45Khz clock value
- UI improvment: UI displays opened file duration
- UI improvment: chapter list correctly updated if join several files. Also joining for MPLS is enabled.
- Add help if run tsMuxeR without parameters
- Fixed muxing for 96Khz TRUE-HD tracks
- PCM inside VOB was anonced before, but actually did not work. Fixed.
- UI fix: if open MPLS, then close, track list is not cleared. It is broken in previous build only.
- Subtitles renderer fixed (broken in previous build only after in/out effects)

## tsMuxeR 2.3.2
- Support PG subtitles inside MKV
- Support MKV tracks with zlib compression
- Support 3D MP4 and MOV files (combined AVC+MVC stream)
- Add option 'line spacing' to subtitles renderer
- Add fade in/out effect to subtitles renderer
- Fixed ability to drag&drop files directly to tsMuxerGUI shurtcut (it worked before in version 10.6)
- Fixed splitting operation if no video track present
- bug fixed: tsMuxeR can't create output directory for UNC path (for instance \\.\Volume{E5FB13D8-5096-11E3-B9C4-005056C00008}\folder1\test.ts)
- bug fixed: message "file already exist" appeared if open several files from a folder with '(' in the name

## tsMuxeR 2.2.3
- Add support for DTS-HD elementary stream with extra DTSHD headers
- Add support for mkv with 'Header Stripping' compression
- Add 3D MKV support
- Add PCM inside MKV support
- Add PCM inside VOB support
- Fixed option 'bind to video fps' for subtitles
- Improved font renderer quality
- Fixed file splitting option (it was disabled since v.1.11.x because of was not implemented for ISO and 3D-blurays)
- Several minor bug fixes

## tsMuxeR 2.1.8
- Fixed join files problem with True-HD track
- introduce MAC build

## tsMuxeR 2.1.6
- Add support for combined AVC+MVC streams
- Output file size slightly reduced
- Fixed bug if mux AVC+MVC tracks to m2ts file. Some 3d m2ts movies did not play on Samsung Smart TV
- Fixed minor bug in a SSIF interleaving for some movies
- introduce Linux build

## tsMuxeR 2.1.4
- Same problem fixed again. Sometimes tsMuxeR get access to file with wrong name during mpls processing.

## tsMuxeR 2.1.3
- Previous version introduce a new bug. Sometime tsMuxeR showed error message "file not found". Fixed.

## tsMuxeR 2.1.2(b);
- fixed bug in MVC stream recognition. MVC from Intel Media Encoder now work.
- SSIF files is not required any more if you open 3D MPLS file
- Add Stereo subtitles basic support. If source PG stream has stereo format, same stereo PG stream will be created in a output file
- Add tag <force> (or <f>) to srt parser. This tag force to show subtitle message. For instance:

	1
	00:00:10,440 --> 00:00:20,375
	<force>	
	<b>Senator</b>, we're making
	our final approach into Coruscant.

## tsMuxeR 2.0.8:
- fixed subtitles bug: "3d-plane" option was inaccessible for many disks

## tsMuxeR 2.0.7:
 improvments:
- add control for select/unselect all tracks at once
 bug fixes:
- extract ac3 core from e-ac3 track fixed
- fixed option --m2tsOffset (was broken in version 2.x.x)
- fixed 'bufer overflow' error message if simultaneously mux several m2ts files and one of them has PSG tracks only
- fixed problem with too long file names in demux mode for large mpls files

## tsMuxeR 2.0.6:
- bug fixed: removing overlapped frames for HD audio fixed

## tsMuxeR 2.0.5:
- add direct ISO output

## tsMuxeR 1.12.10:
- fixed H.264 stream parser. Same fix as in previous version but more careful
- fixed subtitles color selection in UI

## tsMuxeR 1.12.10:
- fixed H.264 stream parser. It cause video distortion for some movies.
- add DTS-express support. Is not fully complete yet, tsMuxeR doesn't produce subpath for secondary audio

## tsMuxeR 1.12.9:
- fixed file join for mov/mp4
- fixed bug in SEI unit processing (if enable options 'insert picture timing'). Bug may cause video distortion.
- fixed distortion for VC1 codec if join several files
- seamless audio fixed. Extra audio frame correctly removed.

## tsMuxeR 1.12.6:
- fixed 3d subtitles. Add ability to select 3D offset plane for subtitles
- add new parameter '--start-time'. This parameter define time for first video frame in output file. This parameter is filled automatically (too keep same input time) if open MPLS file.
- several more minor fixes in transport stream to improve Blu-ray compatibility
- fixed E-AC3 codec

## tsMuxeR 1.12.3:
- fixed problem with ssif muxing
- add addition check for 'insert picture timing' parameter. For MVC depended view used same value as for primary video stream
- add new parameter to GUI and tsMuxeR core: 'right-eye'. Parameter is used for 3D blurays only. If parameter is set then MPEG-4 MVC Base view video used for Right eye.
This parameter filled automatically in GUI if open MPLS file.

## tsMuxeR 1.12.2:
- add 3d bluray support. Bluray muxing activated automatically if MVC substream appears in input tracks.
To reduce HDD space, tsMuxeR doesn't produce ssif file, only a couple of .m2ts files. ssif files can be 
creted on the fly in DVD fab using "create mini iso" menu item.
- add ability to mux to ssif file directly. It is not supported in GUI, but you can provide .ssif file extension
- fixed bugs in SEI message processing and add MVC sei message support
- fixed several bugs in the Transport Stream to improve compatibility with Blu-ray standart.

## tsMuxeR 1.11.6:
- fixed bug in SSIF file demuxing. It cause a problem for subtitles tracks.

## tsMuxeR 1.11.5:
- added SSIF files support for blu-ray play lists (MPLS)

## tsMuxeR 1.11.4:
- detect language for audio/subtitle tracks fixed for SSIF files (it's work if ssif file is opened from Blu-ray disk structure)

## tsMuxeR 1.11.3:
- bug fixed in MVC parsing

## tsMuxeR 1.11.0:
- add support of SSIF files and MVC codec (3d Blu-ray compatibility)
